/* Copyright 2017 R. Thomas
 * Copyright 2017 Quarkslab
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_PE_MSVCP120_DLL_LOOKUP_H_
#define LIEF_PE_MSVCP120_DLL_LOOKUP_H_

#include <map>

namespace LIEF {
namespace PE {

static const std::map<uint32_t, const char*> msvcp120_dll_lookup {
    { 0x0001, "??$_Getvals@_W@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IEAAX_WAEBV_Locinfo@1@@Z"                                                                       },
    { 0x0002, "??$_Getvals@_W@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IEAAX_WAEBV_Locinfo@1@@Z"                                                                       },
    { 0x0003, "??$_Getvals@_W@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IEAAX_WAEBV_Locinfo@1@@Z"                                                                    },
    { 0x0004, "??0?$_Yarn@D@std@@QEAA@AEBV01@@Z"                                                                                                                                                    },
    { 0x0005, "??0?$_Yarn@D@std@@QEAA@PEBD@Z"                                                                                                                                                       },
    { 0x0006, "??0?$_Yarn@D@std@@QEAA@XZ"                                                                                                                                                           },
    { 0x0007, "??0?$_Yarn@_W@std@@QEAA@XZ"                                                                                                                                                          },
    { 0x0008, "??0?$basic_ios@DU?$char_traits@D@std@@@std@@IEAA@XZ"                                                                                                                                 },
    { 0x0009, "??0?$basic_ios@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@@Z"                                                                                 },
    { 0x000a, "??0?$basic_ios@GU?$char_traits@G@std@@@std@@IEAA@XZ"                                                                                                                                 },
    { 0x000b, "??0?$basic_ios@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@@Z"                                                                                 },
    { 0x000c, "??0?$basic_ios@_WU?$char_traits@_W@std@@@std@@IEAA@XZ"                                                                                                                               },
    { 0x000d, "??0?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@@Z"                                                                             },
    { 0x000e, "??0?$basic_iostream@DU?$char_traits@D@std@@@std@@IEAA@$$QEAV01@@Z"                                                                                                                   },
    { 0x000f, "??0?$basic_iostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@@Z"                                                                            },
    { 0x0010, "??0?$basic_iostream@GU?$char_traits@G@std@@@std@@IEAA@$$QEAV01@@Z"                                                                                                                   },
    { 0x0011, "??0?$basic_iostream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@@Z"                                                                            },
    { 0x0012, "??0?$basic_iostream@_WU?$char_traits@_W@std@@@std@@IEAA@$$QEAV01@@Z"                                                                                                                 },
    { 0x0013, "??0?$basic_iostream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@@Z"                                                                        },
    { 0x0014, "??0?$basic_istream@DU?$char_traits@D@std@@@std@@IEAA@$$QEAV01@@Z"                                                                                                                    },
    { 0x0015, "??0?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N1@Z"                                                                          },
    { 0x0016, "??0?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z"                                                                           },
    { 0x0017, "??0?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA@W4_Uninitialized@1@@Z"                                                                                                          },
    { 0x0018, "??0?$basic_istream@GU?$char_traits@G@std@@@std@@IEAA@$$QEAV01@@Z"                                                                                                                    },
    { 0x0019, "??0?$basic_istream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N1@Z"                                                                          },
    { 0x001a, "??0?$basic_istream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z"                                                                           },
    { 0x001b, "??0?$basic_istream@GU?$char_traits@G@std@@@std@@QEAA@W4_Uninitialized@1@@Z"                                                                                                          },
    { 0x001c, "??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@IEAA@$$QEAV01@@Z"                                                                                                                  },
    { 0x001d, "??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N1@Z"                                                                      },
    { 0x001e, "??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z"                                                                       },
    { 0x001f, "??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAA@W4_Uninitialized@1@@Z"                                                                                                        },
    { 0x0020, "??0?$basic_ostream@DU?$char_traits@D@std@@@std@@IEAA@$$QEAV01@@Z"                                                                                                                    },
    { 0x0021, "??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z"                                                                           },
    { 0x0022, "??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@W4_Uninitialized@1@_N@Z"                                                                                                        },
    { 0x0023, "??0?$basic_ostream@GU?$char_traits@G@std@@@std@@IEAA@$$QEAV01@@Z"                                                                                                                    },
    { 0x0024, "??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z"                                                                           },
    { 0x0025, "??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@W4_Uninitialized@1@_N@Z"                                                                                                        },
    { 0x0026, "??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@IEAA@$$QEAV01@@Z"                                                                                                                  },
    { 0x0027, "??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z"                                                                       },
    { 0x0028, "??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@W4_Uninitialized@1@_N@Z"                                                                                                      },
    { 0x0029, "??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAA@AEBV01@@Z"                                                                                                                    },
    { 0x002a, "??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAA@W4_Uninitialized@1@@Z"                                                                                                        },
    { 0x002b, "??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAA@XZ"                                                                                                                           },
    { 0x002c, "??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAA@AEBV01@@Z"                                                                                                                    },
    { 0x002d, "??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAA@W4_Uninitialized@1@@Z"                                                                                                        },
    { 0x002e, "??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAA@XZ"                                                                                                                           },
    { 0x002f, "??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAA@AEBV01@@Z"                                                                                                                  },
    { 0x0030, "??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAA@W4_Uninitialized@1@@Z"                                                                                                      },
    { 0x0031, "??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAA@XZ"                                                                                                                         },
    { 0x0032, "??0?$codecvt@DDH@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                                                                      },
    { 0x0033, "??0?$codecvt@DDH@std@@QEAA@_K@Z"                                                                                                                                                     },
    { 0x0034, "??0?$codecvt@GDH@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                                                                      },
    { 0x0035, "??0?$codecvt@GDH@std@@QEAA@_K@Z"                                                                                                                                                     },
    { 0x0036, "??0?$codecvt@_WDH@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                                                                     },
    { 0x0037, "??0?$codecvt@_WDH@std@@QEAA@_K@Z"                                                                                                                                                    },
    { 0x0038, "??0?$ctype@D@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                                                                          },
    { 0x0039, "??0?$ctype@D@std@@QEAA@PEBF_N_K@Z"                                                                                                                                                   },
    { 0x003a, "??0?$ctype@G@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                                                                          },
    { 0x003b, "??0?$ctype@G@std@@QEAA@_K@Z"                                                                                                                                                         },
    { 0x003c, "??0?$ctype@_W@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                                                                         },
    { 0x003d, "??0?$ctype@_W@std@@QEAA@_K@Z"                                                                                                                                                        },
    { 0x003e, "??0?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                    },
    { 0x003f, "??0?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@_K@Z"                                                                                                   },
    { 0x0040, "??0?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                    },
    { 0x0041, "??0?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@_K@Z"                                                                                                   },
    { 0x0042, "??0?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                 },
    { 0x0043, "??0?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@_K@Z"                                                                                                },
    { 0x0044, "??0?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                    },
    { 0x0045, "??0?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@_K@Z"                                                                                                   },
    { 0x0046, "??0?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                    },
    { 0x0047, "??0?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@_K@Z"                                                                                                   },
    { 0x0048, "??0?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                 },
    { 0x0049, "??0?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@_K@Z"                                                                                                },
    { 0x004a, "??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IEAA@PEBD_K@Z"                                                                                              },
    { 0x004b, "??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                   },
    { 0x004c, "??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@_K@Z"                                                                                                  },
    { 0x004d, "??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IEAA@PEBD_K@Z"                                                                                              },
    { 0x004e, "??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                   },
    { 0x004f, "??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@_K@Z"                                                                                                  },
    { 0x0050, "??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IEAA@PEBD_K@Z"                                                                                           },
    { 0x0051, "??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                },
    { 0x0052, "??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@_K@Z"                                                                                               },
    { 0x0053, "??0?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                   },
    { 0x0054, "??0?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@_K@Z"                                                                                                  },
    { 0x0055, "??0?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IEAA@PEBD_K@Z"                                                                                              },
    { 0x0056, "??0?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                   },
    { 0x0057, "??0?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@_K@Z"                                                                                                  },
    { 0x0058, "??0?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IEAA@PEBD_K@Z"                                                                                           },
    { 0x0059, "??0?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"                                                                                },
    { 0x005a, "??0?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@_K@Z"                                                                                               },
    { 0x005b, "??0Init@ios_base@std@@QEAA@XZ"                                                                                                                                                       },
    { 0x005c, "??0_Concurrent_queue_base_v4@details@Concurrency@@IEAA@_K@Z"                                                                                                                         },
    { 0x005d, "??0_Concurrent_queue_iterator_base_v4@details@Concurrency@@IEAA@AEBV_Concurrent_queue_base_v4@12@@Z"                                                                                 },
    { 0x005e, "??0_Container_base12@std@@QEAA@AEBU01@@Z"                                                                                                                                            },
    { 0x005f, "??0_Container_base12@std@@QEAA@XZ"                                                                                                                                                   },
    { 0x0060, "??0_Facet_base@std@@QEAA@AEBV01@@Z"                                                                                                                                                  },
    { 0x0061, "??0_Facet_base@std@@QEAA@XZ"                                                                                                                                                         },
    { 0x0062, "??0_Init_locks@std@@QEAA@XZ"                                                                                                                                                         },
    { 0x0063, "??0_Locimp@locale@std@@AEAA@AEBV012@@Z"                                                                                                                                              },
    { 0x0064, "??0_Locimp@locale@std@@AEAA@_N@Z"                                                                                                                                                    },
    { 0x0065, "??0_Locinfo@std@@QEAA@HPEBD@Z"                                                                                                                                                       },
    { 0x0066, "??0_Locinfo@std@@QEAA@PEBD@Z"                                                                                                                                                        },
    { 0x0067, "??0_Lockit@std@@QEAA@H@Z"                                                                                                                                                            },
    { 0x0068, "??0_Lockit@std@@QEAA@XZ"                                                                                                                                                             },
    { 0x0069, "??0_Pad@std@@QEAA@AEBV01@@Z"                                                                                                                                                         },
    { 0x006a, "??0_Pad@std@@QEAA@XZ"                                                                                                                                                                },
    { 0x006b, "??0_Runtime_object@details@Concurrency@@QEAA@H@Z"                                                                                                                                    },
    { 0x006c, "??0_Runtime_object@details@Concurrency@@QEAA@XZ"                                                                                                                                     },
    { 0x006d, "??0_Timevec@std@@QEAA@AEBV01@@Z"                                                                                                                                                     },
    { 0x006e, "??0_Timevec@std@@QEAA@PEAX@Z"                                                                                                                                                        },
    { 0x006f, "??0_UShinit@std@@QEAA@XZ"                                                                                                                                                            },
    { 0x0070, "??0_Winit@std@@QEAA@XZ"                                                                                                                                                              },
    { 0x0071, "??0agent@Concurrency@@QEAA@AEAVScheduleGroup@1@@Z"                                                                                                                                   },
    { 0x0072, "??0agent@Concurrency@@QEAA@AEAVScheduler@1@@Z"                                                                                                                                       },
    { 0x0073, "??0agent@Concurrency@@QEAA@XZ"                                                                                                                                                       },
    { 0x0074, "??0codecvt_base@std@@QEAA@_K@Z"                                                                                                                                                      },
    { 0x0075, "??0ctype_base@std@@QEAA@_K@Z"                                                                                                                                                        },
    { 0x0076, "??0facet@locale@std@@IEAA@_K@Z"                                                                                                                                                      },
    { 0x0077, "??0id@locale@std@@QEAA@_K@Z"                                                                                                                                                         },
    { 0x0078, "??0ios_base@std@@IEAA@XZ"                                                                                                                                                            },
    { 0x0079, "??0time_base@std@@QEAA@_K@Z"                                                                                                                                                         },
    { 0x007a, "??1?$_Yarn@D@std@@QEAA@XZ"                                                                                                                                                           },
    { 0x007b, "??1?$_Yarn@_W@std@@QEAA@XZ"                                                                                                                                                          },
    { 0x007c, "??1?$basic_ios@DU?$char_traits@D@std@@@std@@UEAA@XZ"                                                                                                                                 },
    { 0x007d, "??1?$basic_ios@GU?$char_traits@G@std@@@std@@UEAA@XZ"                                                                                                                                 },
    { 0x007e, "??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"                                                                                                                               },
    { 0x007f, "??1?$basic_iostream@DU?$char_traits@D@std@@@std@@UEAA@XZ"                                                                                                                            },
    { 0x0080, "??1?$basic_iostream@GU?$char_traits@G@std@@@std@@UEAA@XZ"                                                                                                                            },
    { 0x0081, "??1?$basic_iostream@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"                                                                                                                          },
    { 0x0082, "??1?$basic_istream@DU?$char_traits@D@std@@@std@@UEAA@XZ"                                                                                                                             },
    { 0x0083, "??1?$basic_istream@GU?$char_traits@G@std@@@std@@UEAA@XZ"                                                                                                                             },
    { 0x0084, "??1?$basic_istream@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"                                                                                                                           },
    { 0x0085, "??1?$basic_ostream@DU?$char_traits@D@std@@@std@@UEAA@XZ"                                                                                                                             },
    { 0x0086, "??1?$basic_ostream@GU?$char_traits@G@std@@@std@@UEAA@XZ"                                                                                                                             },
    { 0x0087, "??1?$basic_ostream@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"                                                                                                                           },
    { 0x0088, "??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAA@XZ"                                                                                                                           },
    { 0x0089, "??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UEAA@XZ"                                                                                                                           },
    { 0x008a, "??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"                                                                                                                         },
    { 0x008b, "??1?$codecvt@DDH@std@@MEAA@XZ"                                                                                                                                                       },
    { 0x008c, "??1?$codecvt@GDH@std@@MEAA@XZ"                                                                                                                                                       },
    { 0x008d, "??1?$codecvt@_WDH@std@@MEAA@XZ"                                                                                                                                                      },
    { 0x008e, "??1?$ctype@D@std@@MEAA@XZ"                                                                                                                                                           },
    { 0x008f, "??1?$ctype@G@std@@MEAA@XZ"                                                                                                                                                           },
    { 0x0090, "??1?$ctype@_W@std@@MEAA@XZ"                                                                                                                                                          },
    { 0x0091, "??1?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ"                                                                                                     },
    { 0x0092, "??1?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ"                                                                                                     },
    { 0x0093, "??1?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ"                                                                                                  },
    { 0x0094, "??1?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ"                                                                                                     },
    { 0x0095, "??1?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ"                                                                                                     },
    { 0x0096, "??1?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ"                                                                                                  },
    { 0x0097, "??1?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ"                                                                                                    },
    { 0x0098, "??1?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ"                                                                                                    },
    { 0x0099, "??1?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ"                                                                                                 },
    { 0x009a, "??1?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ"                                                                                                    },
    { 0x009b, "??1?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ"                                                                                                    },
    { 0x009c, "??1?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ"                                                                                                 },
    { 0x009d, "??1Init@ios_base@std@@QEAA@XZ"                                                                                                                                                       },
    { 0x009e, "??1_Concurrent_queue_base_v4@details@Concurrency@@MEAA@XZ"                                                                                                                           },
    { 0x009f, "??1_Concurrent_queue_iterator_base_v4@details@Concurrency@@IEAA@XZ"                                                                                                                  },
    { 0x00a0, "??1_Concurrent_vector_base_v4@details@Concurrency@@IEAA@XZ"                                                                                                                          },
    { 0x00a1, "??1_Container_base12@std@@QEAA@XZ"                                                                                                                                                   },
    { 0x00a2, "??1_Facet_base@std@@UEAA@XZ"                                                                                                                                                         },
    { 0x00a3, "??1_Init_locks@std@@QEAA@XZ"                                                                                                                                                         },
    { 0x00a4, "??1_Locimp@locale@std@@MEAA@XZ"                                                                                                                                                      },
    { 0x00a5, "??1_Locinfo@std@@QEAA@XZ"                                                                                                                                                            },
    { 0x00a6, "??1_Lockit@std@@QEAA@XZ"                                                                                                                                                             },
    { 0x00a7, "??1_Pad@std@@QEAA@XZ"                                                                                                                                                                },
    { 0x00a8, "??1_Timevec@std@@QEAA@XZ"                                                                                                                                                            },
    { 0x00a9, "??1_UShinit@std@@QEAA@XZ"                                                                                                                                                            },
    { 0x00aa, "??1_Winit@std@@QEAA@XZ"                                                                                                                                                              },
    { 0x00ab, "??1agent@Concurrency@@UEAA@XZ"                                                                                                                                                       },
    { 0x00ac, "??1codecvt_base@std@@UEAA@XZ"                                                                                                                                                        },
    { 0x00ad, "??1ctype_base@std@@UEAA@XZ"                                                                                                                                                          },
    { 0x00ae, "??1facet@locale@std@@MEAA@XZ"                                                                                                                                                        },
    { 0x00af, "??1ios_base@std@@UEAA@XZ"                                                                                                                                                            },
    { 0x00b0, "??1time_base@std@@UEAA@XZ"                                                                                                                                                           },
    { 0x00b1, "??4?$_Iosb@H@std@@QEAAAEAV01@AEBV01@@Z"                                                                                                                                              },
    { 0x00b2, "??4?$_Yarn@D@std@@QEAAAEAV01@AEBV01@@Z"                                                                                                                                              },
    { 0x00b3, "??4?$_Yarn@D@std@@QEAAAEAV01@PEBD@Z"                                                                                                                                                 },
    { 0x00b4, "??4?$_Yarn@_W@std@@QEAAAEAV01@PEB_W@Z"                                                                                                                                               },
    { 0x00b5, "??4?$basic_iostream@DU?$char_traits@D@std@@@std@@IEAAAEAV01@$$QEAV01@@Z"                                                                                                             },
    { 0x00b6, "??4?$basic_iostream@GU?$char_traits@G@std@@@std@@IEAAAEAV01@$$QEAV01@@Z"                                                                                                             },
    { 0x00b7, "??4?$basic_iostream@_WU?$char_traits@_W@std@@@std@@IEAAAEAV01@$$QEAV01@@Z"                                                                                                           },
    { 0x00b8, "??4?$basic_istream@DU?$char_traits@D@std@@@std@@IEAAAEAV01@$$QEAV01@@Z"                                                                                                              },
    { 0x00b9, "??4?$basic_istream@GU?$char_traits@G@std@@@std@@IEAAAEAV01@$$QEAV01@@Z"                                                                                                              },
    { 0x00ba, "??4?$basic_istream@_WU?$char_traits@_W@std@@@std@@IEAAAEAV01@$$QEAV01@@Z"                                                                                                            },
    { 0x00bb, "??4?$basic_ostream@DU?$char_traits@D@std@@@std@@IEAAAEAV01@$$QEAV01@@Z"                                                                                                              },
    { 0x00bc, "??4?$basic_ostream@GU?$char_traits@G@std@@@std@@IEAAAEAV01@$$QEAV01@@Z"                                                                                                              },
    { 0x00bd, "??4?$basic_ostream@_WU?$char_traits@_W@std@@@std@@IEAAAEAV01@$$QEAV01@@Z"                                                                                                            },
    { 0x00be, "??4?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAAEAV01@AEBV01@@Z"                                                                                                              },
    { 0x00bf, "??4?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAAEAV01@AEBV01@@Z"                                                                                                              },
    { 0x00c0, "??4?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAAEAV01@AEBV01@@Z"                                                                                                            },
    { 0x00c1, "??4Init@ios_base@std@@QEAAAEAV012@AEBV012@@Z"                                                                                                                                        },
    { 0x00c2, "??4_Container_base0@std@@QEAAAEAU01@AEBU01@@Z"                                                                                                                                       },
    { 0x00c3, "??4_Container_base12@std@@QEAAAEAU01@AEBU01@@Z"                                                                                                                                      },
    { 0x00c4, "??4_Facet_base@std@@QEAAAEAV01@AEBV01@@Z"                                                                                                                                            },
    { 0x00c5, "??4_Init_locks@std@@QEAAAEAV01@AEBV01@@Z"                                                                                                                                            },
    { 0x00c6, "??4_Pad@std@@QEAAAEAV01@AEBV01@@Z"                                                                                                                                                   },
    { 0x00c7, "??4_Timevec@std@@QEAAAEAV01@AEBV01@@Z"                                                                                                                                               },
    { 0x00c8, "??4_UShinit@std@@QEAAAEAV01@AEBV01@@Z"                                                                                                                                               },
    { 0x00c9, "??4_Winit@std@@QEAAAEAV01@AEBV01@@Z"                                                                                                                                                 },
    { 0x00ca, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAF@Z"                                                                                                                   },
    { 0x00cb, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAG@Z"                                                                                                                   },
    { 0x00cc, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAH@Z"                                                                                                                   },
    { 0x00cd, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAI@Z"                                                                                                                   },
    { 0x00ce, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAJ@Z"                                                                                                                   },
    { 0x00cf, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAK@Z"                                                                                                                   },
    { 0x00d0, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAM@Z"                                                                                                                   },
    { 0x00d1, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAN@Z"                                                                                                                   },
    { 0x00d2, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAO@Z"                                                                                                                   },
    { 0x00d3, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAPEAX@Z"                                                                                                                },
    { 0x00d4, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEA_J@Z"                                                                                                                  },
    { 0x00d5, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEA_K@Z"                                                                                                                  },
    { 0x00d6, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEA_N@Z"                                                                                                                  },
    { 0x00d7, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAV01@AEAV01@@Z@Z"                                                                                                    },
    { 0x00d8, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAV?$basic_ios@DU?$char_traits@D@std@@@1@AEAV21@@Z@Z"                                                                 },
    { 0x00d9, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAVios_base@1@AEAV21@@Z@Z"                                                                                            },
    { 0x00da, "??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@@Z"                                                                       },
    { 0x00db, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@AEAF@Z"                                                                                                                   },
    { 0x00dc, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@AEAG@Z"                                                                                                                   },
    { 0x00dd, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@AEAH@Z"                                                                                                                   },
    { 0x00de, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@AEAI@Z"                                                                                                                   },
    { 0x00df, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@AEAJ@Z"                                                                                                                   },
    { 0x00e0, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@AEAK@Z"                                                                                                                   },
    { 0x00e1, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@AEAM@Z"                                                                                                                   },
    { 0x00e2, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@AEAN@Z"                                                                                                                   },
    { 0x00e3, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@AEAO@Z"                                                                                                                   },
    { 0x00e4, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@AEAPEAX@Z"                                                                                                                },
    { 0x00e5, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@AEA_J@Z"                                                                                                                  },
    { 0x00e6, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@AEA_K@Z"                                                                                                                  },
    { 0x00e7, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@AEA_N@Z"                                                                                                                  },
    { 0x00e8, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@P6AAEAV01@AEAV01@@Z@Z"                                                                                                    },
    { 0x00e9, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@P6AAEAV?$basic_ios@GU?$char_traits@G@std@@@1@AEAV21@@Z@Z"                                                                 },
    { 0x00ea, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@P6AAEAVios_base@1@AEAV21@@Z@Z"                                                                                            },
    { 0x00eb, "??5?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@@Z"                                                                       },
    { 0x00ec, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@AEAF@Z"                                                                                                                 },
    { 0x00ed, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@AEAG@Z"                                                                                                                 },
    { 0x00ee, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@AEAH@Z"                                                                                                                 },
    { 0x00ef, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@AEAI@Z"                                                                                                                 },
    { 0x00f0, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@AEAJ@Z"                                                                                                                 },
    { 0x00f1, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@AEAK@Z"                                                                                                                 },
    { 0x00f2, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@AEAM@Z"                                                                                                                 },
    { 0x00f3, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@AEAN@Z"                                                                                                                 },
    { 0x00f4, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@AEAO@Z"                                                                                                                 },
    { 0x00f5, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@AEAPEAX@Z"                                                                                                              },
    { 0x00f6, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@AEA_J@Z"                                                                                                                },
    { 0x00f7, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@AEA_K@Z"                                                                                                                },
    { 0x00f8, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@AEA_N@Z"                                                                                                                },
    { 0x00f9, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@P6AAEAV01@AEAV01@@Z@Z"                                                                                                  },
    { 0x00fa, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@P6AAEAV?$basic_ios@_WU?$char_traits@_W@std@@@1@AEAV21@@Z@Z"                                                             },
    { 0x00fb, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@P6AAEAVios_base@1@AEAV21@@Z@Z"                                                                                          },
    { 0x00fc, "??5?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@@Z"                                                                   },
    { 0x00fd, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@F@Z"                                                                                                                      },
    { 0x00fe, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@G@Z"                                                                                                                      },
    { 0x00ff, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@H@Z"                                                                                                                      },
    { 0x0100, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@I@Z"                                                                                                                      },
    { 0x0101, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@J@Z"                                                                                                                      },
    { 0x0102, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@K@Z"                                                                                                                      },
    { 0x0103, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@M@Z"                                                                                                                      },
    { 0x0104, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@N@Z"                                                                                                                      },
    { 0x0105, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@O@Z"                                                                                                                      },
    { 0x0106, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAV01@AEAV01@@Z@Z"                                                                                                    },
    { 0x0107, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAV?$basic_ios@DU?$char_traits@D@std@@@1@AEAV21@@Z@Z"                                                                 },
    { 0x0108, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAVios_base@1@AEAV21@@Z@Z"                                                                                            },
    { 0x0109, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@@Z"                                                                       },
    { 0x010a, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@PEBX@Z"                                                                                                                   },
    { 0x010b, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_J@Z"                                                                                                                     },
    { 0x010c, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_K@Z"                                                                                                                     },
    { 0x010d, "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_N@Z"                                                                                                                     },
    { 0x010e, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@F@Z"                                                                                                                      },
    { 0x010f, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@G@Z"                                                                                                                      },
    { 0x0110, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@H@Z"                                                                                                                      },
    { 0x0111, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@I@Z"                                                                                                                      },
    { 0x0112, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@J@Z"                                                                                                                      },
    { 0x0113, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@K@Z"                                                                                                                      },
    { 0x0114, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@M@Z"                                                                                                                      },
    { 0x0115, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@N@Z"                                                                                                                      },
    { 0x0116, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@O@Z"                                                                                                                      },
    { 0x0117, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@P6AAEAV01@AEAV01@@Z@Z"                                                                                                    },
    { 0x0118, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@P6AAEAV?$basic_ios@GU?$char_traits@G@std@@@1@AEAV21@@Z@Z"                                                                 },
    { 0x0119, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@P6AAEAVios_base@1@AEAV21@@Z@Z"                                                                                            },
    { 0x011a, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@@Z"                                                                       },
    { 0x011b, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@PEBX@Z"                                                                                                                   },
    { 0x011c, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@_J@Z"                                                                                                                     },
    { 0x011d, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@_K@Z"                                                                                                                     },
    { 0x011e, "??6?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV01@_N@Z"                                                                                                                     },
    { 0x011f, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@F@Z"                                                                                                                    },
    { 0x0120, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@G@Z"                                                                                                                    },
    { 0x0121, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@H@Z"                                                                                                                    },
    { 0x0122, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@I@Z"                                                                                                                    },
    { 0x0123, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@J@Z"                                                                                                                    },
    { 0x0124, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@K@Z"                                                                                                                    },
    { 0x0125, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@M@Z"                                                                                                                    },
    { 0x0126, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@N@Z"                                                                                                                    },
    { 0x0127, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@O@Z"                                                                                                                    },
    { 0x0128, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@P6AAEAV01@AEAV01@@Z@Z"                                                                                                  },
    { 0x0129, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@P6AAEAV?$basic_ios@_WU?$char_traits@_W@std@@@1@AEAV21@@Z@Z"                                                             },
    { 0x012a, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@P6AAEAVios_base@1@AEAV21@@Z@Z"                                                                                          },
    { 0x012b, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@@Z"                                                                   },
    { 0x012c, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@PEBX@Z"                                                                                                                 },
    { 0x012d, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@_J@Z"                                                                                                                   },
    { 0x012e, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@_K@Z"                                                                                                                   },
    { 0x012f, "??6?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@_N@Z"                                                                                                                   },
    { 0x0130, "??7ios_base@std@@QEBA_NXZ"                                                                                                                                                           },
    { 0x0131, "??Bid@locale@std@@QEAA_KXZ"                                                                                                                                                          },
    { 0x0132, "??Bios_base@std@@QEBA_NXZ"                                                                                                                                                           },
    { 0x0133, "??_7?$basic_ios@DU?$char_traits@D@std@@@std@@6B@"                                                                                                                                    },
    { 0x0134, "??_7?$basic_ios@GU?$char_traits@G@std@@@std@@6B@"                                                                                                                                    },
    { 0x0135, "??_7?$basic_ios@_WU?$char_traits@_W@std@@@std@@6B@"                                                                                                                                  },
    { 0x0136, "??_7?$basic_iostream@DU?$char_traits@D@std@@@std@@6B@"                                                                                                                               },
    { 0x0137, "??_7?$basic_iostream@GU?$char_traits@G@std@@@std@@6B@"                                                                                                                               },
    { 0x0138, "??_7?$basic_iostream@_WU?$char_traits@_W@std@@@std@@6B@"                                                                                                                             },
    { 0x0139, "??_7?$basic_istream@DU?$char_traits@D@std@@@std@@6B@"                                                                                                                                },
    { 0x013a, "??_7?$basic_istream@GU?$char_traits@G@std@@@std@@6B@"                                                                                                                                },
    { 0x013b, "??_7?$basic_istream@_WU?$char_traits@_W@std@@@std@@6B@"                                                                                                                              },
    { 0x013c, "??_7?$basic_ostream@DU?$char_traits@D@std@@@std@@6B@"                                                                                                                                },
    { 0x013d, "??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@"                                                                                                                                },
    { 0x013e, "??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@"                                                                                                                              },
    { 0x013f, "??_7?$basic_streambuf@DU?$char_traits@D@std@@@std@@6B@"                                                                                                                              },
    { 0x0140, "??_7?$basic_streambuf@GU?$char_traits@G@std@@@std@@6B@"                                                                                                                              },
    { 0x0141, "??_7?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@6B@"                                                                                                                            },
    { 0x0142, "??_7?$codecvt@DDH@std@@6B@"                                                                                                                                                          },
    { 0x0143, "??_7?$codecvt@GDH@std@@6B@"                                                                                                                                                          },
    { 0x0144, "??_7?$codecvt@_WDH@std@@6B@"                                                                                                                                                         },
    { 0x0145, "??_7?$ctype@D@std@@6B@"                                                                                                                                                              },
    { 0x0146, "??_7?$ctype@G@std@@6B@"                                                                                                                                                              },
    { 0x0147, "??_7?$ctype@_W@std@@6B@"                                                                                                                                                             },
    { 0x0148, "??_7?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"                                                                                                        },
    { 0x0149, "??_7?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"                                                                                                        },
    { 0x014a, "??_7?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"                                                                                                     },
    { 0x014b, "??_7?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"                                                                                                        },
    { 0x014c, "??_7?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"                                                                                                        },
    { 0x014d, "??_7?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"                                                                                                     },
    { 0x014e, "??_7?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"                                                                                                       },
    { 0x014f, "??_7?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"                                                                                                       },
    { 0x0150, "??_7?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"                                                                                                    },
    { 0x0151, "??_7?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"                                                                                                       },
    { 0x0152, "??_7?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"                                                                                                       },
    { 0x0153, "??_7?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"                                                                                                    },
    { 0x0154, "??_7_Facet_base@std@@6B@"                                                                                                                                                            },
    { 0x0155, "??_7_Locimp@locale@std@@6B@"                                                                                                                                                         },
    { 0x0156, "??_7_Pad@std@@6B@"                                                                                                                                                                   },
    { 0x0157, "??_7codecvt_base@std@@6B@"                                                                                                                                                           },
    { 0x0158, "??_7ctype_base@std@@6B@"                                                                                                                                                             },
    { 0x0159, "??_7facet@locale@std@@6B@"                                                                                                                                                           },
    { 0x015a, "??_7ios_base@std@@6B@"                                                                                                                                                               },
    { 0x015b, "??_7time_base@std@@6B@"                                                                                                                                                              },
    { 0x015c, "??_8?$basic_iostream@DU?$char_traits@D@std@@@std@@7B?$basic_istream@DU?$char_traits@D@std@@@1@@"                                                                                     },
    { 0x015d, "??_8?$basic_iostream@DU?$char_traits@D@std@@@std@@7B?$basic_ostream@DU?$char_traits@D@std@@@1@@"                                                                                     },
    { 0x015e, "??_8?$basic_iostream@GU?$char_traits@G@std@@@std@@7B?$basic_istream@GU?$char_traits@G@std@@@1@@"                                                                                     },
    { 0x015f, "??_8?$basic_iostream@GU?$char_traits@G@std@@@std@@7B?$basic_ostream@GU?$char_traits@G@std@@@1@@"                                                                                     },
    { 0x0160, "??_8?$basic_iostream@_WU?$char_traits@_W@std@@@std@@7B?$basic_istream@_WU?$char_traits@_W@std@@@1@@"                                                                                 },
    { 0x0161, "??_8?$basic_iostream@_WU?$char_traits@_W@std@@@std@@7B?$basic_ostream@_WU?$char_traits@_W@std@@@1@@"                                                                                 },
    { 0x0162, "??_8?$basic_istream@DU?$char_traits@D@std@@@std@@7B@"                                                                                                                                },
    { 0x0163, "??_8?$basic_istream@GU?$char_traits@G@std@@@std@@7B@"                                                                                                                                },
    { 0x0164, "??_8?$basic_istream@_WU?$char_traits@_W@std@@@std@@7B@"                                                                                                                              },
    { 0x0165, "??_8?$basic_ostream@DU?$char_traits@D@std@@@std@@7B@"                                                                                                                                },
    { 0x0166, "??_8?$basic_ostream@GU?$char_traits@G@std@@@std@@7B@"                                                                                                                                },
    { 0x0167, "??_8?$basic_ostream@_WU?$char_traits@_W@std@@@std@@7B@"                                                                                                                              },
    { 0x0168, "??_D?$basic_iostream@DU?$char_traits@D@std@@@std@@QEAAXXZ"                                                                                                                           },
    { 0x0169, "??_D?$basic_iostream@GU?$char_traits@G@std@@@std@@QEAAXXZ"                                                                                                                           },
    { 0x016a, "??_D?$basic_iostream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"                                                                                                                         },
    { 0x016b, "??_D?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAXXZ"                                                                                                                            },
    { 0x016c, "??_D?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAXXZ"                                                                                                                            },
    { 0x016d, "??_D?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"                                                                                                                          },
    { 0x016e, "??_D?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ"                                                                                                                            },
    { 0x016f, "??_D?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAXXZ"                                                                                                                            },
    { 0x0170, "??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"                                                                                                                          },
    { 0x0171, "??_F?$codecvt@DDH@std@@QEAAXXZ"                                                                                                                                                      },
    { 0x0172, "??_F?$codecvt@GDH@std@@QEAAXXZ"                                                                                                                                                      },
    { 0x0173, "??_F?$codecvt@_WDH@std@@QEAAXXZ"                                                                                                                                                     },
    { 0x0174, "??_F?$ctype@D@std@@QEAAXXZ"                                                                                                                                                          },
    { 0x0175, "??_F?$ctype@G@std@@QEAAXXZ"                                                                                                                                                          },
    { 0x0176, "??_F?$ctype@_W@std@@QEAAXXZ"                                                                                                                                                         },
    { 0x0177, "??_F?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAAXXZ"                                                                                                    },
    { 0x0178, "??_F?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAAXXZ"                                                                                                    },
    { 0x0179, "??_F?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAAXXZ"                                                                                                 },
    { 0x017a, "??_F?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAAXXZ"                                                                                                    },
    { 0x017b, "??_F?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAAXXZ"                                                                                                    },
    { 0x017c, "??_F?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAAXXZ"                                                                                                 },
    { 0x017d, "??_F?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAAXXZ"                                                                                                   },
    { 0x017e, "??_F?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAAXXZ"                                                                                                   },
    { 0x017f, "??_F?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAAXXZ"                                                                                                },
    { 0x0180, "??_F?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAAXXZ"                                                                                                   },
    { 0x0181, "??_F?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAAXXZ"                                                                                                   },
    { 0x0182, "??_F?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAAXXZ"                                                                                                },
    { 0x0183, "??_F_Locinfo@std@@QEAAXXZ"                                                                                                                                                           },
    { 0x0184, "??_F_Timevec@std@@QEAAXXZ"                                                                                                                                                           },
    { 0x0185, "??_Fcodecvt_base@std@@QEAAXXZ"                                                                                                                                                       },
    { 0x0186, "??_Fctype_base@std@@QEAAXXZ"                                                                                                                                                         },
    { 0x0187, "??_Ffacet@locale@std@@QEAAXXZ"                                                                                                                                                       },
    { 0x0188, "??_Fid@locale@std@@QEAAXXZ"                                                                                                                                                          },
    { 0x0189, "??_Ftime_base@std@@QEAAXXZ"                                                                                                                                                          },
    { 0x018a, "?GetNextAsyncId@platform@details@Concurrency@@YAIXZ"                                                                                                                                 },
    { 0x018b, "?NFS_Allocate@details@Concurrency@@YAPEAX_K0PEAX@Z"                                                                                                                                  },
    { 0x018c, "?NFS_Free@details@Concurrency@@YAXPEAX@Z"                                                                                                                                            },
    { 0x018d, "?NFS_GetLineSize@details@Concurrency@@YA_KXZ"                                                                                                                                        },
    { 0x018e, "?_10@placeholders@std@@3V?$_Ph@$09@2@A"                                                                                                                                              },
    { 0x018f, "?_11@placeholders@std@@3V?$_Ph@$0L@@2@A"                                                                                                                                             },
    { 0x0190, "?_12@placeholders@std@@3V?$_Ph@$0M@@2@A"                                                                                                                                             },
    { 0x0191, "?_13@placeholders@std@@3V?$_Ph@$0N@@2@A"                                                                                                                                             },
    { 0x0192, "?_14@placeholders@std@@3V?$_Ph@$0O@@2@A"                                                                                                                                             },
    { 0x0193, "?_15@placeholders@std@@3V?$_Ph@$0P@@2@A"                                                                                                                                             },
    { 0x0194, "?_16@placeholders@std@@3V?$_Ph@$0BA@@2@A"                                                                                                                                            },
    { 0x0195, "?_17@placeholders@std@@3V?$_Ph@$0BB@@2@A"                                                                                                                                            },
    { 0x0196, "?_18@placeholders@std@@3V?$_Ph@$0BC@@2@A"                                                                                                                                            },
    { 0x0197, "?_19@placeholders@std@@3V?$_Ph@$0BD@@2@A"                                                                                                                                            },
    { 0x0198, "?_1@placeholders@std@@3V?$_Ph@$00@2@A"                                                                                                                                               },
    { 0x0199, "?_20@placeholders@std@@3V?$_Ph@$0BE@@2@A"                                                                                                                                            },
    { 0x019a, "?_2@placeholders@std@@3V?$_Ph@$01@2@A"                                                                                                                                               },
    { 0x019b, "?_3@placeholders@std@@3V?$_Ph@$02@2@A"                                                                                                                                               },
    { 0x019c, "?_4@placeholders@std@@3V?$_Ph@$03@2@A"                                                                                                                                               },
    { 0x019d, "?_5@placeholders@std@@3V?$_Ph@$04@2@A"                                                                                                                                               },
    { 0x019e, "?_6@placeholders@std@@3V?$_Ph@$05@2@A"                                                                                                                                               },
    { 0x019f, "?_7@placeholders@std@@3V?$_Ph@$06@2@A"                                                                                                                                               },
    { 0x01a0, "?_8@placeholders@std@@3V?$_Ph@$07@2@A"                                                                                                                                               },
    { 0x01a1, "?_9@placeholders@std@@3V?$_Ph@$08@2@A"                                                                                                                                               },
    { 0x01a2, "?_Addcats@_Locinfo@std@@QEAAAEAV12@HPEBD@Z"                                                                                                                                          },
    { 0x01a3, "?_Addfac@_Locimp@locale@std@@AEAAXPEAVfacet@23@_K@Z"                                                                                                                                 },
    { 0x01a4, "?_Addstd@ios_base@std@@SAXPEAV12@@Z"                                                                                                                                                 },
    { 0x01a5, "?_Advance@_Concurrent_queue_iterator_base_v4@details@Concurrency@@IEAAXXZ"                                                                                                           },
    { 0x01a6, "?_Assign@_Concurrent_queue_iterator_base_v4@details@Concurrency@@IEAAXAEBV123@@Z"                                                                                                    },
    { 0x01a7, "?_Atexit@@YAXP6AXXZ@Z"                                                                                                                                                               },
    { 0x01a8, "?_BADOFF@std@@3_JB"                                                                                                                                                                  },
    { 0x01a9, "?_Byte_reverse_table@details@Concurrency@@3QBEB"                                                                                                                                     },
    { 0x01aa, "?_C_str@?$_Yarn@D@std@@QEBAPEBDXZ"                                                                                                                                                   },
    { 0x01ab, "?_C_str@?$_Yarn@_W@std@@QEBAPEB_WXZ"                                                                                                                                                 },
    { 0x01ac, "?_Callfns@ios_base@std@@AEAAXW4event@12@@Z"                                                                                                                                          },
    { 0x01ad, "?_Clocptr@_Locimp@locale@std@@0PEAV123@EA"                                                                                                                                           },
    { 0x01ae, "?_Close_dir@sys@tr2@std@@YAXPEAX@Z"                                                                                                                                                  },
    { 0x01af, "?_Copy_file@sys@tr2@std@@YAHPEBD0_N@Z"                                                                                                                                               },
    { 0x01b0, "?_Copy_file@sys@tr2@std@@YAHPEB_W0_N@Z"                                                                                                                                              },
    { 0x01b1, "?_Current_get@sys@tr2@std@@YAPEADAEAY0BAE@D@Z"                                                                                                                                       },
    { 0x01b2, "?_Current_get@sys@tr2@std@@YAPEA_WAEAY0BAE@_W@Z"                                                                                                                                     },
    { 0x01b3, "?_Current_set@sys@tr2@std@@YA_NPEBD@Z"                                                                                                                                               },
    { 0x01b4, "?_Current_set@sys@tr2@std@@YA_NPEB_W@Z"                                                                                                                                              },
    { 0x01b5, "?_Decref@facet@locale@std@@UEAAPEAV_Facet_base@3@XZ"                                                                                                                                 },
    { 0x01b6, "?_Donarrow@?$ctype@G@std@@IEBADGD@Z"                                                                                                                                                 },
    { 0x01b7, "?_Donarrow@?$ctype@_W@std@@IEBAD_WD@Z"                                                                                                                                               },
    { 0x01b8, "?_Dowiden@?$ctype@G@std@@IEBAGD@Z"                                                                                                                                                   },
    { 0x01b9, "?_Dowiden@?$ctype@_W@std@@IEBA_WD@Z"                                                                                                                                                 },
    { 0x01ba, "?_Empty@?$_Yarn@D@std@@QEBA_NXZ"                                                                                                                                                     },
    { 0x01bb, "?_Empty@?$_Yarn@_W@std@@QEBA_NXZ"                                                                                                                                                    },
    { 0x01bc, "?_Equivalent@sys@tr2@std@@YAHPEBD0@Z"                                                                                                                                                },
    { 0x01bd, "?_Equivalent@sys@tr2@std@@YAHPEB_W0@Z"                                                                                                                                               },
    { 0x01be, "?_Ffmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAPEADPEADDH@Z"                                                                                        },
    { 0x01bf, "?_Ffmt@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAPEADPEADDH@Z"                                                                                        },
    { 0x01c0, "?_Ffmt@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAPEADPEADDH@Z"                                                                                     },
    { 0x01c1, "?_File_size@sys@tr2@std@@YA_KPEBD@Z"                                                                                                                                                 },
    { 0x01c2, "?_File_size@sys@tr2@std@@YA_KPEB_W@Z"                                                                                                                                                },
    { 0x01c3, "?_Findarr@ios_base@std@@AEAAAEAU_Iosarray@12@H@Z"                                                                                                                                    },
    { 0x01c4, "?_Fiopen@std@@YAPEAU_iobuf@@PEBDHH@Z"                                                                                                                                                },
    { 0x01c5, "?_Fiopen@std@@YAPEAU_iobuf@@PEBGHH@Z"                                                                                                                                                },
    { 0x01c6, "?_Fiopen@std@@YAPEAU_iobuf@@PEB_WHH@Z"                                                                                                                                               },
    { 0x01c7, "?_Fput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEBD_K333@Z"                  },
    { 0x01c8, "?_Fput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GPEBD_K333@Z"                  },
    { 0x01c9, "?_Fput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WPEBD_K444@Z"            },
    { 0x01ca, "?_Future_error_map@std@@YAPEBDH@Z"                                                                                                                                                   },
    { 0x01cb, "?_GetCombinableSize@details@Concurrency@@YA_KXZ"                                                                                                                                     },
    { 0x01cc, "?_Getcat@?$codecvt@DDH@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                                                                     },
    { 0x01cd, "?_Getcat@?$codecvt@GDH@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                                                                     },
    { 0x01ce, "?_Getcat@?$codecvt@_WDH@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                                                                    },
    { 0x01cf, "?_Getcat@?$ctype@D@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                                                                         },
    { 0x01d0, "?_Getcat@?$ctype@G@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                                                                         },
    { 0x01d1, "?_Getcat@?$ctype@_W@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                                                                        },
    { 0x01d2, "?_Getcat@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                   },
    { 0x01d3, "?_Getcat@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                   },
    { 0x01d4, "?_Getcat@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                },
    { 0x01d5, "?_Getcat@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                   },
    { 0x01d6, "?_Getcat@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                   },
    { 0x01d7, "?_Getcat@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                },
    { 0x01d8, "?_Getcat@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                  },
    { 0x01d9, "?_Getcat@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                  },
    { 0x01da, "?_Getcat@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                               },
    { 0x01db, "?_Getcat@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                  },
    { 0x01dc, "?_Getcat@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                                  },
    { 0x01dd, "?_Getcat@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"                                                               },
    { 0x01de, "?_Getcat@facet@locale@std@@SA_KPEAPEBV123@PEBV23@@Z"                                                                                                                                 },
    { 0x01df, "?_Getcoll@_Locinfo@std@@QEBA?AU_Collvec@@XZ"                                                                                                                                         },
    { 0x01e0, "?_Getctype@_Locinfo@std@@QEBA?AU_Ctypevec@@XZ"                                                                                                                                       },
    { 0x01e1, "?_Getcvt@_Locinfo@std@@QEBA?AU_Cvtvec@@XZ"                                                                                                                                           },
    { 0x01e2, "?_Getdateorder@_Locinfo@std@@QEBAHXZ"                                                                                                                                                },
    { 0x01e3, "?_Getdays@_Locinfo@std@@QEBAPEBDXZ"                                                                                                                                                  },
    { 0x01e4, "?_Getfalse@_Locinfo@std@@QEBAPEBDXZ"                                                                                                                                                 },
    { 0x01e5, "?_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AEAVios_base@2@PEAH@Z"                  },
    { 0x01e6, "?_Getffld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1AEAVios_base@2@PEAH@Z"                  },
    { 0x01e7, "?_Getffld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1AEAVios_base@2@PEAH@Z"             },
    { 0x01e8, "?_Getffldx@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AEAVios_base@2@PEAH@Z"                 },
    { 0x01e9, "?_Getffldx@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1AEAVios_base@2@PEAH@Z"                 },
    { 0x01ea, "?_Getffldx@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1AEAVios_base@2@PEAH@Z"            },
    { 0x01eb, "?_Getfmt@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@PEBD@Z"        },
    { 0x01ec, "?_Getfmt@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@PEBD@Z"        },
    { 0x01ed, "?_Getfmt@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@PEBD@Z"   },
    { 0x01ee, "?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ"                                                                                                                                   },
    { 0x01ef, "?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HAEBVlocale@2@@Z"                       },
    { 0x01f0, "?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HAEBVlocale@2@@Z"                       },
    { 0x01f1, "?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HAEBVlocale@2@@Z"                  },
    { 0x01f2, "?_Getint@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@0HHAEAHAEBV?$ctype@D@2@@Z"                   },
    { 0x01f3, "?_Getint@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@0HHAEAHAEBV?$ctype@G@2@@Z"                   },
    { 0x01f4, "?_Getint@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@0HHAEAHAEBV?$ctype@_W@2@@Z"             },
    { 0x01f5, "?_Getlconv@_Locinfo@std@@QEBAPEBUlconv@@XZ"                                                                                                                                          },
    { 0x01f6, "?_Getmonths@_Locinfo@std@@QEBAPEBDXZ"                                                                                                                                                },
    { 0x01f7, "?_Getname@_Locinfo@std@@QEBAPEBDXZ"                                                                                                                                                  },
    { 0x01f8, "?_Getpfirst@_Container_base12@std@@QEBAPEAPEAU_Iterator_base12@2@XZ"                                                                                                                 },
    { 0x01f9, "?_Getptr@_Timevec@std@@QEBAPEAXXZ"                                                                                                                                                   },
    { 0x01fa, "?_Gettnames@_Locinfo@std@@QEBA?AV_Timevec@2@XZ"                                                                                                                                      },
    { 0x01fb, "?_Gettrue@_Locinfo@std@@QEBAPEBDXZ"                                                                                                                                                  },
    { 0x01fc, "?_Gnavail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBA_JXZ"                                                                                                                   },
    { 0x01fd, "?_Gnavail@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEBA_JXZ"                                                                                                                   },
    { 0x01fe, "?_Gnavail@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEBA_JXZ"                                                                                                                 },
    { 0x01ff, "?_Gndec@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAPEADXZ"                                                                                                                   },
    { 0x0200, "?_Gndec@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAPEAGXZ"                                                                                                                   },
    { 0x0201, "?_Gndec@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAPEA_WXZ"                                                                                                                },
    { 0x0202, "?_Gninc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAPEADXZ"                                                                                                                   },
    { 0x0203, "?_Gninc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAPEAGXZ"                                                                                                                   },
    { 0x0204, "?_Gninc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAPEA_WXZ"                                                                                                                },
    { 0x0205, "?_Gnpreinc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAPEADXZ"                                                                                                                },
    { 0x0206, "?_Gnpreinc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAPEAGXZ"                                                                                                                },
    { 0x0207, "?_Gnpreinc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAPEA_WXZ"                                                                                                             },
    { 0x0208, "?_Id_cnt@id@locale@std@@0HA"                                                                                                                                                         },
    { 0x0209, "?_Ifmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAPEADPEADPEBDH@Z"                                                                                     },
    { 0x020a, "?_Ifmt@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAPEADPEADPEBDH@Z"                                                                                     },
    { 0x020b, "?_Ifmt@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAPEADPEADPEBDH@Z"                                                                                  },
    { 0x020c, "?_Incref@facet@locale@std@@UEAAXXZ"                                                                                                                                                  },
    { 0x020d, "?_Index@ios_base@std@@0HA"                                                                                                                                                           },
    { 0x020e, "?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXPEAPEAD0PEAH001@Z"                                                                                                        },
    { 0x020f, "?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXXZ"                                                                                                                       },
    { 0x0210, "?_Init@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXPEAPEAG0PEAH001@Z"                                                                                                        },
    { 0x0211, "?_Init@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXXZ"                                                                                                                       },
    { 0x0212, "?_Init@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXPEAPEA_W0PEAH001@Z"                                                                                                     },
    { 0x0213, "?_Init@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXXZ"                                                                                                                     },
    { 0x0214, "?_Init@?$codecvt@DDH@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                                                                    },
    { 0x0215, "?_Init@?$codecvt@GDH@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                                                                    },
    { 0x0216, "?_Init@?$codecvt@_WDH@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                                                                   },
    { 0x0217, "?_Init@?$ctype@D@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                                                                        },
    { 0x0218, "?_Init@?$ctype@G@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                                                                        },
    { 0x0219, "?_Init@?$ctype@_W@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                                                                       },
    { 0x021a, "?_Init@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                  },
    { 0x021b, "?_Init@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                  },
    { 0x021c, "?_Init@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                               },
    { 0x021d, "?_Init@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                  },
    { 0x021e, "?_Init@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                  },
    { 0x021f, "?_Init@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                               },
    { 0x0220, "?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                 },
    { 0x0221, "?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                 },
    { 0x0222, "?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                              },
    { 0x0223, "?_Init@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                 },
    { 0x0224, "?_Init@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                                 },
    { 0x0225, "?_Init@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z"                                                                              },
    { 0x0226, "?_Init@ios_base@std@@IEAAXXZ"                                                                                                                                                        },
    { 0x0227, "?_Init@locale@std@@CAPEAV_Locimp@12@_N@Z"                                                                                                                                            },
    { 0x0228, "?_Init_cnt@Init@ios_base@std@@0HA"                                                                                                                                                   },
    { 0x0229, "?_Init_cnt@_UShinit@std@@0HA"                                                                                                                                                        },
    { 0x022a, "?_Init_cnt@_Winit@std@@0HA"                                                                                                                                                          },
    { 0x022b, "?_Init_cnt_func@Init@ios_base@std@@CAAEAHXZ"                                                                                                                                         },
    { 0x022c, "?_Init_ctor@Init@ios_base@std@@CAXPEAV123@@Z"                                                                                                                                        },
    { 0x022d, "?_Init_dtor@Init@ios_base@std@@CAXPEAV123@@Z"                                                                                                                                        },
    { 0x022e, "?_Init_locks_ctor@_Init_locks@std@@CAXPEAV12@@Z"                                                                                                                                     },
    { 0x022f, "?_Init_locks_dtor@_Init_locks@std@@CAXPEAV12@@Z"                                                                                                                                     },
    { 0x0230, "?_Internal_assign@_Concurrent_vector_base_v4@details@Concurrency@@IEAAXAEBV123@_KP6AXPEAX1@ZP6AX2PEBX1@Z5@Z"                                                                         },
    { 0x0231, "?_Internal_capacity@_Concurrent_vector_base_v4@details@Concurrency@@IEBA_KXZ"                                                                                                        },
    { 0x0232, "?_Internal_clear@_Concurrent_vector_base_v4@details@Concurrency@@IEAA_KP6AXPEAX_K@Z@Z"                                                                                               },
    { 0x0233, "?_Internal_compact@_Concurrent_vector_base_v4@details@Concurrency@@IEAAPEAX_KPEAXP6AX10@ZP6AX1PEBX0@Z@Z"                                                                             },
    { 0x0234, "?_Internal_copy@_Concurrent_vector_base_v4@details@Concurrency@@IEAAXAEBV123@_KP6AXPEAXPEBX1@Z@Z"                                                                                    },
    { 0x0235, "?_Internal_empty@_Concurrent_queue_base_v4@details@Concurrency@@IEBA_NXZ"                                                                                                            },
    { 0x0236, "?_Internal_finish_clear@_Concurrent_queue_base_v4@details@Concurrency@@IEAAXXZ"                                                                                                      },
    { 0x0237, "?_Internal_grow_by@_Concurrent_vector_base_v4@details@Concurrency@@IEAA_K_K0P6AXPEAXPEBX0@Z2@Z"                                                                                      },
    { 0x0238, "?_Internal_grow_to_at_least_with_result@_Concurrent_vector_base_v4@details@Concurrency@@IEAA_K_K0P6AXPEAXPEBX0@Z2@Z"                                                                 },
    { 0x0239, "?_Internal_move_push@_Concurrent_queue_base_v4@details@Concurrency@@IEAAXPEAX@Z"                                                                                                     },
    { 0x023a, "?_Internal_pop_if_present@_Concurrent_queue_base_v4@details@Concurrency@@IEAA_NPEAX@Z"                                                                                               },
    { 0x023b, "?_Internal_push@_Concurrent_queue_base_v4@details@Concurrency@@IEAAXPEBX@Z"                                                                                                          },
    { 0x023c, "?_Internal_push_back@_Concurrent_vector_base_v4@details@Concurrency@@IEAAPEAX_KAEA_K@Z"                                                                                              },
    { 0x023d, "?_Internal_reserve@_Concurrent_vector_base_v4@details@Concurrency@@IEAAX_K00@Z"                                                                                                      },
    { 0x023e, "?_Internal_resize@_Concurrent_vector_base_v4@details@Concurrency@@IEAAX_K00P6AXPEAX0@ZP6AX1PEBX0@Z3@Z"                                                                               },
    { 0x023f, "?_Internal_size@_Concurrent_queue_base_v4@details@Concurrency@@IEBA_KXZ"                                                                                                             },
    { 0x0240, "?_Internal_swap@_Concurrent_queue_base_v4@details@Concurrency@@IEAAXAEAV123@@Z"                                                                                                      },
    { 0x0241, "?_Internal_swap@_Concurrent_vector_base_v4@details@Concurrency@@IEAAXAEAV123@@Z"                                                                                                     },
    { 0x0242, "?_Internal_throw_exception@_Concurrent_queue_base_v4@details@Concurrency@@IEBAXXZ"                                                                                                   },
    { 0x0243, "?_Internal_throw_exception@_Concurrent_vector_base_v4@details@Concurrency@@IEBAX_K@Z"                                                                                                },
    { 0x0244, "?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z"                                                                                                                                          },
    { 0x0245, "?_Ipfx@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA_N_N@Z"                                                                                                                      },
    { 0x0246, "?_Ipfx@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAA_N_N@Z"                                                                                                                      },
    { 0x0247, "?_Ipfx@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAA_N_N@Z"                                                                                                                    },
    { 0x0248, "?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEAD_K@Z"                     },
    { 0x0249, "?_Iput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GPEAD_K@Z"                     },
    { 0x024a, "?_Iput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WPEAD_K@Z"               },
    { 0x024b, "?_Last_write_time@sys@tr2@std@@YAXPEBD_J@Z"                                                                                                                                          },
    { 0x024c, "?_Last_write_time@sys@tr2@std@@YAXPEB_W_J@Z"                                                                                                                                         },
    { 0x024d, "?_Last_write_time@sys@tr2@std@@YA_JPEBD@Z"                                                                                                                                           },
    { 0x024e, "?_Last_write_time@sys@tr2@std@@YA_JPEB_W@Z"                                                                                                                                          },
    { 0x024f, "?_Launch@_Pad@std@@QEAAXPEAU_Thrd_imp_t@@@Z"                                                                                                                                         },
    { 0x0250, "?_Link@sys@tr2@std@@YAHPEBD0@Z"                                                                                                                                                      },
    { 0x0251, "?_Link@sys@tr2@std@@YAHPEB_W0@Z"                                                                                                                                                     },
    { 0x0252, "?_Locimp_Addfac@_Locimp@locale@std@@CAXPEAV123@PEAVfacet@23@_K@Z"                                                                                                                    },
    { 0x0253, "?_Locimp_ctor@_Locimp@locale@std@@CAXPEAV123@AEBV123@@Z"                                                                                                                             },
    { 0x0254, "?_Locimp_dtor@_Locimp@locale@std@@CAXPEAV123@@Z"                                                                                                                                     },
    { 0x0255, "?_Locinfo_Addcats@_Locinfo@std@@SAAEAV12@PEAV12@HPEBD@Z"                                                                                                                             },
    { 0x0256, "?_Locinfo_ctor@_Locinfo@std@@SAXPEAV12@HPEBD@Z"                                                                                                                                      },
    { 0x0257, "?_Locinfo_ctor@_Locinfo@std@@SAXPEAV12@PEBD@Z"                                                                                                                                       },
    { 0x0258, "?_Locinfo_dtor@_Locinfo@std@@SAXPEAV12@@Z"                                                                                                                                           },
    { 0x0259, "?_Lock@?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAAXXZ"                                                                                                                       },
    { 0x025a, "?_Lock@?$basic_streambuf@GU?$char_traits@G@std@@@std@@UEAAXXZ"                                                                                                                       },
    { 0x025b, "?_Lock@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UEAAXXZ"                                                                                                                     },
    { 0x025c, "?_Lockit_ctor@_Lockit@std@@CAXPEAV12@@Z"                                                                                                                                             },
    { 0x025d, "?_Lockit_ctor@_Lockit@std@@CAXPEAV12@H@Z"                                                                                                                                            },
    { 0x025e, "?_Lockit_ctor@_Lockit@std@@SAXH@Z"                                                                                                                                                   },
    { 0x025f, "?_Lockit_dtor@_Lockit@std@@CAXPEAV12@@Z"                                                                                                                                             },
    { 0x0260, "?_Lockit_dtor@_Lockit@std@@SAXH@Z"                                                                                                                                                   },
    { 0x0261, "?_Lstat@sys@tr2@std@@YA?AW4file_type@123@PEBDAEAH@Z"                                                                                                                                 },
    { 0x0262, "?_Lstat@sys@tr2@std@@YA?AW4file_type@123@PEB_WAEAH@Z"                                                                                                                                },
    { 0x0263, "?_MP_Add@std@@YAXQEA_K_K@Z"                                                                                                                                                          },
    { 0x0264, "?_MP_Get@std@@YA_KQEA_K@Z"                                                                                                                                                           },
    { 0x0265, "?_MP_Mul@std@@YAXQEA_K_K1@Z"                                                                                                                                                         },
    { 0x0266, "?_MP_Rem@std@@YAXQEA_K_K@Z"                                                                                                                                                          },
    { 0x0267, "?_Make_dir@sys@tr2@std@@YAHPEBD@Z"                                                                                                                                                   },
    { 0x0268, "?_Make_dir@sys@tr2@std@@YAHPEB_W@Z"                                                                                                                                                  },
    { 0x0269, "?_Makeloc@_Locimp@locale@std@@CAPEAV123@AEBV_Locinfo@3@HPEAV123@PEBV23@@Z"                                                                                                           },
    { 0x026a, "?_Makeushloc@_Locimp@locale@std@@CAXAEBV_Locinfo@3@HPEAV123@PEBV23@@Z"                                                                                                               },
    { 0x026b, "?_Makewloc@_Locimp@locale@std@@CAXAEBV_Locinfo@3@HPEAV123@PEBV23@@Z"                                                                                                                 },
    { 0x026c, "?_Makexloc@_Locimp@locale@std@@CAXAEBV_Locinfo@3@HPEAV123@PEBV23@@Z"                                                                                                                 },
    { 0x026d, "?_Mtx_delete@threads@stdext@@YAXPEAX@Z"                                                                                                                                              },
    { 0x026e, "?_Mtx_lock@threads@stdext@@YAXPEAX@Z"                                                                                                                                                },
    { 0x026f, "?_Mtx_new@threads@stdext@@YAXAEAPEAX@Z"                                                                                                                                              },
    { 0x0270, "?_Mtx_unlock@threads@stdext@@YAXPEAX@Z"                                                                                                                                              },
    { 0x0271, "?_New_Locimp@_Locimp@locale@std@@CAPEAV123@AEBV123@@Z"                                                                                                                               },
    { 0x0272, "?_New_Locimp@_Locimp@locale@std@@CAPEAV123@_N@Z"                                                                                                                                     },
    { 0x0273, "?_Open_dir@sys@tr2@std@@YAPEAXAEAY0BAE@DPEBDAEAHAEAW4file_type@123@@Z"                                                                                                               },
    { 0x0274, "?_Open_dir@sys@tr2@std@@YAPEAXAEAY0BAE@_WPEB_WAEAHAEAW4file_type@123@@Z"                                                                                                             },
    { 0x0275, "?_Orphan_all@_Container_base0@std@@QEAAXXZ"                                                                                                                                          },
    { 0x0276, "?_Orphan_all@_Container_base12@std@@QEAAXXZ"                                                                                                                                         },
    { 0x0277, "?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ"                                                                                                                         },
    { 0x0278, "?_Osfx@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAXXZ"                                                                                                                         },
    { 0x0279, "?_Osfx@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"                                                                                                                       },
    { 0x027a, "?_Pnavail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBA_JXZ"                                                                                                                   },
    { 0x027b, "?_Pnavail@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEBA_JXZ"                                                                                                                   },
    { 0x027c, "?_Pnavail@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEBA_JXZ"                                                                                                                 },
    { 0x027d, "?_Pninc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAPEADXZ"                                                                                                                   },
    { 0x027e, "?_Pninc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAPEAGXZ"                                                                                                                   },
    { 0x027f, "?_Pninc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAPEA_WXZ"                                                                                                                },
    { 0x0280, "?_Ptr_cerr@std@@3PEAV?$basic_ostream@DU?$char_traits@D@std@@@1@EA"                                                                                                                   },
    { 0x0281, "?_Ptr_cin@std@@3PEAV?$basic_istream@DU?$char_traits@D@std@@@1@EA"                                                                                                                    },
    { 0x0282, "?_Ptr_clog@std@@3PEAV?$basic_ostream@DU?$char_traits@D@std@@@1@EA"                                                                                                                   },
    { 0x0283, "?_Ptr_cout@std@@3PEAV?$basic_ostream@DU?$char_traits@D@std@@@1@EA"                                                                                                                   },
    { 0x0284, "?_Ptr_wcerr@std@@3PEAV?$basic_ostream@GU?$char_traits@G@std@@@1@EA"                                                                                                                  },
    { 0x0285, "?_Ptr_wcerr@std@@3PEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@EA"                                                                                                                },
    { 0x0286, "?_Ptr_wcin@std@@3PEAV?$basic_istream@GU?$char_traits@G@std@@@1@EA"                                                                                                                   },
    { 0x0287, "?_Ptr_wcin@std@@3PEAV?$basic_istream@_WU?$char_traits@_W@std@@@1@EA"                                                                                                                 },
    { 0x0288, "?_Ptr_wclog@std@@3PEAV?$basic_ostream@GU?$char_traits@G@std@@@1@EA"                                                                                                                  },
    { 0x0289, "?_Ptr_wclog@std@@3PEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@EA"                                                                                                                },
    { 0x028a, "?_Ptr_wcout@std@@3PEAV?$basic_ostream@GU?$char_traits@G@std@@@1@EA"                                                                                                                  },
    { 0x028b, "?_Ptr_wcout@std@@3PEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@EA"                                                                                                                },
    { 0x028c, "?_Put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@PEBD_K@Z"                                      },
    { 0x028d, "?_Put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@PEBG_K@Z"                                      },
    { 0x028e, "?_Put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@PEB_W_K@Z"                                },
    { 0x028f, "?_Raise_handler@std@@3P6AXAEBVexception@stdext@@@ZEA"                                                                                                                                },
    { 0x0290, "?_Random_device@std@@YAIXZ"                                                                                                                                                          },
    { 0x0291, "?_Read_dir@sys@tr2@std@@YAPEADAEAY0BAE@DPEAXAEAW4file_type@123@@Z"                                                                                                                   },
    { 0x0292, "?_Read_dir@sys@tr2@std@@YAPEA_WAEAY0BAE@_WPEAXAEAW4file_type@123@@Z"                                                                                                                 },
    { 0x0293, "?_Release@_Pad@std@@QEAAXXZ"                                                                                                                                                         },
    { 0x0294, "?_Remove_dir@sys@tr2@std@@YA_NPEBD@Z"                                                                                                                                                },
    { 0x0295, "?_Remove_dir@sys@tr2@std@@YA_NPEB_W@Z"                                                                                                                                               },
    { 0x0296, "?_Rename@sys@tr2@std@@YAHPEBD0@Z"                                                                                                                                                    },
    { 0x0297, "?_Rename@sys@tr2@std@@YAHPEB_W0@Z"                                                                                                                                                   },
    { 0x0298, "?_Rep@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@D_K@Z"                                         },
    { 0x0299, "?_Rep@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@G_K@Z"                                         },
    { 0x029a, "?_Rep@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@_W_K@Z"                                   },
    { 0x029b, "?_Rethrow_future_exception@std@@YAXVexception_ptr@1@@Z"                                                                                                                              },
    { 0x029c, "?_Rng_abort@std@@YAXPEBD@Z"                                                                                                                                                          },
    { 0x029d, "?_Segment_index_of@_Concurrent_vector_base_v4@details@Concurrency@@KA_K_K@Z"                                                                                                         },
    { 0x029e, "?_Setgloballocale@locale@std@@CAXPEAX@Z"                                                                                                                                             },
    { 0x029f, "?_Src@?1??_Getffldx@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@3@1AEAVios_base@3@PEAH@Z@4QBDB"  },
    { 0x02a0, "?_Src@?1??_Getffldx@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@3@1AEAVios_base@3@PEAH@Z@4QBDB"  },
    { 0x02a1, "?_Src@?1??_Getffldx@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@3@1AEAVios_base@3@PEAH@Z@4QBDB" },
    { 0x02a2, "?_Src@?1??_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@3@1HAEBVlocale@3@@Z@4QBDB"        },
    { 0x02a3, "?_Src@?1??_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@3@1HAEBVlocale@3@@Z@4QBDB"        },
    { 0x02a4, "?_Src@?1??_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@3@1HAEBVlocale@3@@Z@4QBDB"   },
    { 0x02a5, "?_Src@?3??_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@3@1AEAVios_base@3@PEAH@Z@4QBDB"   },
    { 0x02a6, "?_Src@?3??_Getffld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@3@1AEAVios_base@3@PEAH@Z@4QBDB"   },
    { 0x02a7, "?_Src@?3??_Getffld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@3@1AEAVios_base@3@PEAH@Z@4QBDB" },
    { 0x02a8, "?_Stat@sys@tr2@std@@YA?AW4file_type@123@PEBDAEAH@Z"                                                                                                                                  },
    { 0x02a9, "?_Stat@sys@tr2@std@@YA?AW4file_type@123@PEB_WAEAH@Z"                                                                                                                                 },
    { 0x02aa, "?_Statvfs@sys@tr2@std@@YA?AUspace_info@123@PEBD@Z"                                                                                                                                   },
    { 0x02ab, "?_Statvfs@sys@tr2@std@@YA?AUspace_info@123@PEB_W@Z"                                                                                                                                  },
    { 0x02ac, "?_Swap_all@_Container_base0@std@@QEAAXAEAU12@@Z"                                                                                                                                     },
    { 0x02ad, "?_Swap_all@_Container_base12@std@@QEAAXAEAU12@@Z"                                                                                                                                    },
    { 0x02ae, "?_Symlink@sys@tr2@std@@YAHPEBD0@Z"                                                                                                                                                   },
    { 0x02af, "?_Symlink@sys@tr2@std@@YAHPEB_W0@Z"                                                                                                                                                  },
    { 0x02b0, "?_Sync@ios_base@std@@0_NA"                                                                                                                                                           },
    { 0x02b1, "?_Syserror_map@std@@YAPEBDH@Z"                                                                                                                                                       },
    { 0x02b2, "?_Throw_C_error@std@@YAXH@Z"                                                                                                                                                         },
    { 0x02b3, "?_Throw_Cpp_error@std@@YAXH@Z"                                                                                                                                                       },
    { 0x02b4, "?_Throw_future_error@std@@YAXAEBVerror_code@1@@Z"                                                                                                                                    },
    { 0x02b5, "?_Throw_lock_error@threads@stdext@@YAXXZ"                                                                                                                                            },
    { 0x02b6, "?_Throw_resource_error@threads@stdext@@YAXXZ"                                                                                                                                        },
    { 0x02b7, "?_Tidy@?$_Yarn@D@std@@AEAAXXZ"                                                                                                                                                       },
    { 0x02b8, "?_Tidy@?$_Yarn@_W@std@@AEAAXXZ"                                                                                                                                                      },
    { 0x02b9, "?_Tidy@?$ctype@D@std@@IEAAXXZ"                                                                                                                                                       },
    { 0x02ba, "?_Tidy@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEAAXXZ"                                                                                                },
    { 0x02bb, "?_Tidy@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEAAXXZ"                                                                                                },
    { 0x02bc, "?_Tidy@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEAAXXZ"                                                                                             },
    { 0x02bd, "?_Tidy@ios_base@std@@AEAAXXZ"                                                                                                                                                        },
    { 0x02be, "?_Unlink@sys@tr2@std@@YAHPEBD@Z"                                                                                                                                                     },
    { 0x02bf, "?_Unlink@sys@tr2@std@@YAHPEB_W@Z"                                                                                                                                                    },
    { 0x02c0, "?_Unlock@?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAAXXZ"                                                                                                                     },
    { 0x02c1, "?_Unlock@?$basic_streambuf@GU?$char_traits@G@std@@@std@@UEAAXXZ"                                                                                                                     },
    { 0x02c2, "?_Unlock@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UEAAXXZ"                                                                                                                   },
    { 0x02c3, "?_W_Getdays@_Locinfo@std@@QEBAPEBGXZ"                                                                                                                                                },
    { 0x02c4, "?_W_Getmonths@_Locinfo@std@@QEBAPEBGXZ"                                                                                                                                              },
    { 0x02c5, "?_W_Gettnames@_Locinfo@std@@QEBA?AV_Timevec@2@XZ"                                                                                                                                    },
    { 0x02c6, "?_Winerror_map@std@@YAPEBDH@Z"                                                                                                                                                       },
    { 0x02c7, "?_XLgamma@std@@YAMM@Z"                                                                                                                                                               },
    { 0x02c8, "?_XLgamma@std@@YANN@Z"                                                                                                                                                               },
    { 0x02c9, "?_XLgamma@std@@YAOO@Z"                                                                                                                                                               },
    { 0x02ca, "?_Xbad_alloc@std@@YAXXZ"                                                                                                                                                             },
    { 0x02cb, "?_Xbad_function_call@std@@YAXXZ"                                                                                                                                                     },
    { 0x02cc, "?_Xinvalid_argument@std@@YAXPEBD@Z"                                                                                                                                                  },
    { 0x02cd, "?_Xlength_error@std@@YAXPEBD@Z"                                                                                                                                                      },
    { 0x02ce, "?_Xout_of_range@std@@YAXPEBD@Z"                                                                                                                                                      },
    { 0x02cf, "?_Xoverflow_error@std@@YAXPEBD@Z"                                                                                                                                                    },
    { 0x02d0, "?_Xregex_error@std@@YAXW4error_type@regex_constants@1@@Z"                                                                                                                            },
    { 0x02d1, "?_Xruntime_error@std@@YAXPEBD@Z"                                                                                                                                                     },
    { 0x02d2, "?adopt_lock@std@@3Uadopt_lock_t@1@B"                                                                                                                                                 },
    { 0x02d3, "?always_noconv@codecvt_base@std@@QEBA_NXZ"                                                                                                                                           },
    { 0x02d4, "?bad@ios_base@std@@QEBA_NXZ"                                                                                                                                                         },
    { 0x02d5, "?c_str@?$_Yarn@D@std@@QEBAPEBDXZ"                                                                                                                                                    },
    { 0x02d6, "?cancel@agent@Concurrency@@QEAA_NXZ"                                                                                                                                                 },
    { 0x02d7, "?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A"                                                                                                                            },
    { 0x02d8, "?cin@std@@3V?$basic_istream@DU?$char_traits@D@std@@@1@A"                                                                                                                             },
    { 0x02d9, "?classic@locale@std@@SAAEBV12@XZ"                                                                                                                                                    },
    { 0x02da, "?classic_table@?$ctype@D@std@@SAPEBFXZ"                                                                                                                                              },
    { 0x02db, "?clear@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z"                                                                                                                          },
    { 0x02dc, "?clear@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXI@Z"                                                                                                                            },
    { 0x02dd, "?clear@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAXH_N@Z"                                                                                                                          },
    { 0x02de, "?clear@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAXI@Z"                                                                                                                            },
    { 0x02df, "?clear@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAXH_N@Z"                                                                                                                        },
    { 0x02e0, "?clear@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAXI@Z"                                                                                                                          },
    { 0x02e1, "?clear@ios_base@std@@QEAAXH@Z"                                                                                                                                                       },
    { 0x02e2, "?clear@ios_base@std@@QEAAXH_N@Z"                                                                                                                                                     },
    { 0x02e3, "?clear@ios_base@std@@QEAAXI@Z"                                                                                                                                                       },
    { 0x02e4, "?clog@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A"                                                                                                                            },
    { 0x02e5, "?copyfmt@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAAEAV12@AEBV12@@Z"                                                                                                              },
    { 0x02e6, "?copyfmt@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAAEAV12@AEBV12@@Z"                                                                                                              },
    { 0x02e7, "?copyfmt@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@AEBV12@@Z"                                                                                                            },
    { 0x02e8, "?copyfmt@ios_base@std@@QEAAAEAV12@AEBV12@@Z"                                                                                                                                         },
    { 0x02e9, "?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A"                                                                                                                            },
    { 0x02ea, "?date_order@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AW4dateorder@time_base@2@XZ"                                                                  },
    { 0x02eb, "?date_order@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AW4dateorder@time_base@2@XZ"                                                                  },
    { 0x02ec, "?date_order@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AW4dateorder@time_base@2@XZ"                                                               },
    { 0x02ed, "?defer_lock@std@@3Udefer_lock_t@1@B"                                                                                                                                                 },
    { 0x02ee, "?do_always_noconv@?$codecvt@DDH@std@@MEBA_NXZ"                                                                                                                                       },
    { 0x02ef, "?do_always_noconv@?$codecvt@GDH@std@@MEBA_NXZ"                                                                                                                                       },
    { 0x02f0, "?do_always_noconv@?$codecvt@_WDH@std@@MEBA_NXZ"                                                                                                                                      },
    { 0x02f1, "?do_always_noconv@codecvt_base@std@@MEBA_NXZ"                                                                                                                                        },
    { 0x02f2, "?do_date_order@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AW4dateorder@time_base@2@XZ"                                                               },
    { 0x02f3, "?do_date_order@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AW4dateorder@time_base@2@XZ"                                                               },
    { 0x02f4, "?do_date_order@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AW4dateorder@time_base@2@XZ"                                                            },
    { 0x02f5, "?do_encoding@?$codecvt@GDH@std@@MEBAHXZ"                                                                                                                                             },
    { 0x02f6, "?do_encoding@?$codecvt@_WDH@std@@MEBAHXZ"                                                                                                                                            },
    { 0x02f7, "?do_encoding@codecvt_base@std@@MEBAHXZ"                                                                                                                                              },
    { 0x02f8, "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAG@Z"                  },
    { 0x02f9, "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAI@Z"                  },
    { 0x02fa, "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAJ@Z"                  },
    { 0x02fb, "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAK@Z"                  },
    { 0x02fc, "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAM@Z"                  },
    { 0x02fd, "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAN@Z"                  },
    { 0x02fe, "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAO@Z"                  },
    { 0x02ff, "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAPEAX@Z"               },
    { 0x0300, "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEA_J@Z"                 },
    { 0x0301, "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEA_K@Z"                 },
    { 0x0302, "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEA_N@Z"                 },
    { 0x0303, "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAG@Z"                  },
    { 0x0304, "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAI@Z"                  },
    { 0x0305, "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAJ@Z"                  },
    { 0x0306, "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAK@Z"                  },
    { 0x0307, "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAM@Z"                  },
    { 0x0308, "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAN@Z"                  },
    { 0x0309, "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAO@Z"                  },
    { 0x030a, "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAPEAX@Z"               },
    { 0x030b, "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEA_J@Z"                 },
    { 0x030c, "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEA_K@Z"                 },
    { 0x030d, "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEA_N@Z"                 },
    { 0x030e, "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAG@Z"             },
    { 0x030f, "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAI@Z"             },
    { 0x0310, "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAJ@Z"             },
    { 0x0311, "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAK@Z"             },
    { 0x0312, "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAM@Z"             },
    { 0x0313, "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAN@Z"             },
    { 0x0314, "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAO@Z"             },
    { 0x0315, "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAPEAX@Z"          },
    { 0x0316, "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEA_J@Z"            },
    { 0x0317, "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEA_K@Z"            },
    { 0x0318, "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEA_N@Z"            },
    { 0x0319, "?do_get@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@DD@Z"           },
    { 0x031a, "?do_get@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@DD@Z"           },
    { 0x031b, "?do_get@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@DD@Z"      },
    { 0x031c, "?do_get_date@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"        },
    { 0x031d, "?do_get_date@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"        },
    { 0x031e, "?do_get_date@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"   },
    { 0x031f, "?do_get_monthname@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"   },
    { 0x0320, "?do_get_monthname@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"   },
    { 0x0321, "?do_get_monthname@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z" },
    { 0x0322, "?do_get_time@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"        },
    { 0x0323, "?do_get_time@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"        },
    { 0x0324, "?do_get_time@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"   },
    { 0x0325, "?do_get_weekday@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"     },
    { 0x0326, "?do_get_weekday@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"     },
    { 0x0327, "?do_get_weekday@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z" },
    { 0x0328, "?do_get_year@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"        },
    { 0x0329, "?do_get_year@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"        },
    { 0x032a, "?do_get_year@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"   },
    { 0x032b, "?do_in@?$codecvt@DDH@std@@MEBAHAEAHPEBD1AEAPEBDPEAD3AEAPEAD@Z"                                                                                                                       },
    { 0x032c, "?do_in@?$codecvt@GDH@std@@MEBAHAEAHPEBD1AEAPEBDPEAG3AEAPEAG@Z"                                                                                                                       },
    { 0x032d, "?do_in@?$codecvt@_WDH@std@@MEBAHAEAHPEBD1AEAPEBDPEA_W3AEAPEA_W@Z"                                                                                                                    },
    { 0x032e, "?do_is@?$ctype@G@std@@MEBAPEBGPEBG0PEAF@Z"                                                                                                                                           },
    { 0x032f, "?do_is@?$ctype@G@std@@MEBA_NFG@Z"                                                                                                                                                    },
    { 0x0330, "?do_is@?$ctype@_W@std@@MEBAPEB_WPEB_W0PEAF@Z"                                                                                                                                        },
    { 0x0331, "?do_is@?$ctype@_W@std@@MEBA_NF_W@Z"                                                                                                                                                  },
    { 0x0332, "?do_length@?$codecvt@DDH@std@@MEBAHAEAHPEBD1_K@Z"                                                                                                                                    },
    { 0x0333, "?do_length@?$codecvt@GDH@std@@MEBAHAEAHPEBD1_K@Z"                                                                                                                                    },
    { 0x0334, "?do_length@?$codecvt@_WDH@std@@MEBAHAEAHPEBD1_K@Z"                                                                                                                                   },
    { 0x0335, "?do_max_length@?$codecvt@GDH@std@@MEBAHXZ"                                                                                                                                           },
    { 0x0336, "?do_max_length@?$codecvt@_WDH@std@@MEBAHXZ"                                                                                                                                          },
    { 0x0337, "?do_max_length@codecvt_base@std@@MEBAHXZ"                                                                                                                                            },
    { 0x0338, "?do_narrow@?$ctype@D@std@@MEBADDD@Z"                                                                                                                                                 },
    { 0x0339, "?do_narrow@?$ctype@D@std@@MEBAPEBDPEBD0DPEAD@Z"                                                                                                                                      },
    { 0x033a, "?do_narrow@?$ctype@G@std@@MEBADGD@Z"                                                                                                                                                 },
    { 0x033b, "?do_narrow@?$ctype@G@std@@MEBAPEBGPEBG0DPEAD@Z"                                                                                                                                      },
    { 0x033c, "?do_narrow@?$ctype@_W@std@@MEBAD_WD@Z"                                                                                                                                               },
    { 0x033d, "?do_narrow@?$ctype@_W@std@@MEBAPEB_WPEB_W0DPEAD@Z"                                                                                                                                   },
    { 0x033e, "?do_out@?$codecvt@DDH@std@@MEBAHAEAHPEBD1AEAPEBDPEAD3AEAPEAD@Z"                                                                                                                      },
    { 0x033f, "?do_out@?$codecvt@GDH@std@@MEBAHAEAHPEBG1AEAPEBGPEAD3AEAPEAD@Z"                                                                                                                      },
    { 0x0340, "?do_out@?$codecvt@_WDH@std@@MEBAHAEAHPEB_W1AEAPEB_WPEAD3AEAPEAD@Z"                                                                                                                   },
    { 0x0341, "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DJ@Z"                         },
    { 0x0342, "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DK@Z"                         },
    { 0x0343, "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DN@Z"                         },
    { 0x0344, "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DO@Z"                         },
    { 0x0345, "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEBX@Z"                      },
    { 0x0346, "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@D_J@Z"                        },
    { 0x0347, "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@D_K@Z"                        },
    { 0x0348, "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@D_N@Z"                        },
    { 0x0349, "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GJ@Z"                         },
    { 0x034a, "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GK@Z"                         },
    { 0x034b, "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GN@Z"                         },
    { 0x034c, "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GO@Z"                         },
    { 0x034d, "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GPEBX@Z"                      },
    { 0x034e, "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@G_J@Z"                        },
    { 0x034f, "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@G_K@Z"                        },
    { 0x0350, "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@G_N@Z"                        },
    { 0x0351, "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WJ@Z"                   },
    { 0x0352, "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WK@Z"                   },
    { 0x0353, "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WN@Z"                   },
    { 0x0354, "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WO@Z"                   },
    { 0x0355, "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WPEBX@Z"                },
    { 0x0356, "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_W_J@Z"                  },
    { 0x0357, "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_W_K@Z"                  },
    { 0x0358, "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_W_N@Z"                  },
    { 0x0359, "?do_put@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEBUtm@@DD@Z"               },
    { 0x035a, "?do_put@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GPEBUtm@@DD@Z"               },
    { 0x035b, "?do_put@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WPEBUtm@@DD@Z"         },
    { 0x035c, "?do_scan_is@?$ctype@G@std@@MEBAPEBGFPEBG0@Z"                                                                                                                                         },
    { 0x035d, "?do_scan_is@?$ctype@_W@std@@MEBAPEB_WFPEB_W0@Z"                                                                                                                                      },
    { 0x035e, "?do_scan_not@?$ctype@G@std@@MEBAPEBGFPEBG0@Z"                                                                                                                                        },
    { 0x035f, "?do_scan_not@?$ctype@_W@std@@MEBAPEB_WFPEB_W0@Z"                                                                                                                                     },
    { 0x0360, "?do_tolower@?$ctype@D@std@@MEBADD@Z"                                                                                                                                                 },
    { 0x0361, "?do_tolower@?$ctype@D@std@@MEBAPEBDPEADPEBD@Z"                                                                                                                                       },
    { 0x0362, "?do_tolower@?$ctype@G@std@@MEBAGG@Z"                                                                                                                                                 },
    { 0x0363, "?do_tolower@?$ctype@G@std@@MEBAPEBGPEAGPEBG@Z"                                                                                                                                       },
    { 0x0364, "?do_tolower@?$ctype@_W@std@@MEBAPEB_WPEA_WPEB_W@Z"                                                                                                                                   },
    { 0x0365, "?do_tolower@?$ctype@_W@std@@MEBA_W_W@Z"                                                                                                                                              },
    { 0x0366, "?do_toupper@?$ctype@D@std@@MEBADD@Z"                                                                                                                                                 },
    { 0x0367, "?do_toupper@?$ctype@D@std@@MEBAPEBDPEADPEBD@Z"                                                                                                                                       },
    { 0x0368, "?do_toupper@?$ctype@G@std@@MEBAGG@Z"                                                                                                                                                 },
    { 0x0369, "?do_toupper@?$ctype@G@std@@MEBAPEBGPEAGPEBG@Z"                                                                                                                                       },
    { 0x036a, "?do_toupper@?$ctype@_W@std@@MEBAPEB_WPEA_WPEB_W@Z"                                                                                                                                   },
    { 0x036b, "?do_toupper@?$ctype@_W@std@@MEBA_W_W@Z"                                                                                                                                              },
    { 0x036c, "?do_unshift@?$codecvt@DDH@std@@MEBAHAEAHPEAD1AEAPEAD@Z"                                                                                                                              },
    { 0x036d, "?do_unshift@?$codecvt@GDH@std@@MEBAHAEAHPEAD1AEAPEAD@Z"                                                                                                                              },
    { 0x036e, "?do_unshift@?$codecvt@_WDH@std@@MEBAHAEAHPEAD1AEAPEAD@Z"                                                                                                                             },
    { 0x036f, "?do_widen@?$ctype@D@std@@MEBADD@Z"                                                                                                                                                   },
    { 0x0370, "?do_widen@?$ctype@D@std@@MEBAPEBDPEBD0PEAD@Z"                                                                                                                                        },
    { 0x0371, "?do_widen@?$ctype@G@std@@MEBAGD@Z"                                                                                                                                                   },
    { 0x0372, "?do_widen@?$ctype@G@std@@MEBAPEBDPEBD0PEAG@Z"                                                                                                                                        },
    { 0x0373, "?do_widen@?$ctype@_W@std@@MEBAPEBDPEBD0PEA_W@Z"                                                                                                                                      },
    { 0x0374, "?do_widen@?$ctype@_W@std@@MEBA_WD@Z"                                                                                                                                                 },
    { 0x0375, "?done@agent@Concurrency@@IEAA_NXZ"                                                                                                                                                   },
    { 0x0376, "?eback@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ"                                                                                                                    },
    { 0x0377, "?eback@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEBAPEAGXZ"                                                                                                                    },
    { 0x0378, "?eback@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEBAPEA_WXZ"                                                                                                                 },
    { 0x0379, "?egptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ"                                                                                                                    },
    { 0x037a, "?egptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEBAPEAGXZ"                                                                                                                    },
    { 0x037b, "?egptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEBAPEA_WXZ"                                                                                                                 },
    { 0x037c, "?empty@?$_Yarn@D@std@@QEBA_NXZ"                                                                                                                                                      },
    { 0x037d, "?empty@locale@std@@SA?AV12@XZ"                                                                                                                                                       },
    { 0x037e, "?encoding@codecvt_base@std@@QEBAHXZ"                                                                                                                                                 },
    { 0x037f, "?eof@ios_base@std@@QEBA_NXZ"                                                                                                                                                         },
    { 0x0380, "?epptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ"                                                                                                                    },
    { 0x0381, "?epptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEBAPEAGXZ"                                                                                                                    },
    { 0x0382, "?epptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEBAPEA_WXZ"                                                                                                                 },
    { 0x0383, "?exceptions@ios_base@std@@QEAAXH@Z"                                                                                                                                                  },
    { 0x0384, "?exceptions@ios_base@std@@QEAAXI@Z"                                                                                                                                                  },
    { 0x0385, "?exceptions@ios_base@std@@QEBAHXZ"                                                                                                                                                   },
    { 0x0386, "?fail@ios_base@std@@QEBA_NXZ"                                                                                                                                                        },
    { 0x0387, "?fill@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAADD@Z"                                                                                                                             },
    { 0x0388, "?fill@?$basic_ios@DU?$char_traits@D@std@@@std@@QEBADXZ"                                                                                                                              },
    { 0x0389, "?fill@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAGG@Z"                                                                                                                             },
    { 0x038a, "?fill@?$basic_ios@GU?$char_traits@G@std@@@std@@QEBAGXZ"                                                                                                                              },
    { 0x038b, "?fill@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAA_W_W@Z"                                                                                                                         },
    { 0x038c, "?fill@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEBA_WXZ"                                                                                                                           },
    { 0x038d, "?flags@ios_base@std@@QEAAHH@Z"                                                                                                                                                       },
    { 0x038e, "?flags@ios_base@std@@QEBAHXZ"                                                                                                                                                        },
    { 0x038f, "?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@XZ"                                                                                                                   },
    { 0x0390, "?flush@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@XZ"                                                                                                                   },
    { 0x0391, "?flush@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@XZ"                                                                                                                 },
    { 0x0392, "?gbump@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXH@Z"                                                                                                                      },
    { 0x0393, "?gbump@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXH@Z"                                                                                                                      },
    { 0x0394, "?gbump@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXH@Z"                                                                                                                    },
    { 0x0395, "?gcount@?$basic_istream@DU?$char_traits@D@std@@@std@@QEBA_JXZ"                                                                                                                       },
    { 0x0396, "?gcount@?$basic_istream@GU?$char_traits@G@std@@@std@@QEBA_JXZ"                                                                                                                       },
    { 0x0397, "?gcount@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEBA_JXZ"                                                                                                                     },
    { 0x0398, "?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@AEAD@Z"                                                                                                                 },
    { 0x0399, "?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@AEAV?$basic_streambuf@DU?$char_traits@D@std@@@2@@Z"                                                                     },
    { 0x039a, "?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@AEAV?$basic_streambuf@DU?$char_traits@D@std@@@2@D@Z"                                                                    },
    { 0x039b, "?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@PEAD_J@Z"                                                                                                               },
    { 0x039c, "?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@PEAD_JD@Z"                                                                                                              },
    { 0x039d, "?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAHXZ"                                                                                                                           },
    { 0x039e, "?get@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@AEAG@Z"                                                                                                                 },
    { 0x039f, "?get@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@AEAV?$basic_streambuf@GU?$char_traits@G@std@@@2@@Z"                                                                     },
    { 0x03a0, "?get@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@AEAV?$basic_streambuf@GU?$char_traits@G@std@@@2@G@Z"                                                                    },
    { 0x03a1, "?get@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@PEAG_J@Z"                                                                                                               },
    { 0x03a2, "?get@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@PEAG_JG@Z"                                                                                                              },
    { 0x03a3, "?get@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAGXZ"                                                                                                                           },
    { 0x03a4, "?get@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@AEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@2@@Z"                                                                 },
    { 0x03a5, "?get@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@AEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@2@_W@Z"                                                               },
    { 0x03a6, "?get@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@AEA_W@Z"                                                                                                              },
    { 0x03a7, "?get@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@PEA_W_J@Z"                                                                                                            },
    { 0x03a8, "?get@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@PEA_W_J_W@Z"                                                                                                          },
    { 0x03a9, "?get@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAGXZ"                                                                                                                         },
    { 0x03aa, "?get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAG@Z"                     },
    { 0x03ab, "?get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAI@Z"                     },
    { 0x03ac, "?get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAJ@Z"                     },
    { 0x03ad, "?get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAK@Z"                     },
    { 0x03ae, "?get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAM@Z"                     },
    { 0x03af, "?get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAN@Z"                     },
    { 0x03b0, "?get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAO@Z"                     },
    { 0x03b1, "?get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAPEAX@Z"                  },
    { 0x03b2, "?get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEA_J@Z"                    },
    { 0x03b3, "?get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEA_K@Z"                    },
    { 0x03b4, "?get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEA_N@Z"                    },
    { 0x03b5, "?get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAG@Z"                     },
    { 0x03b6, "?get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAI@Z"                     },
    { 0x03b7, "?get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAJ@Z"                     },
    { 0x03b8, "?get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAK@Z"                     },
    { 0x03b9, "?get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAM@Z"                     },
    { 0x03ba, "?get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAN@Z"                     },
    { 0x03bb, "?get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAO@Z"                     },
    { 0x03bc, "?get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAPEAX@Z"                  },
    { 0x03bd, "?get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEA_J@Z"                    },
    { 0x03be, "?get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEA_K@Z"                    },
    { 0x03bf, "?get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEA_N@Z"                    },
    { 0x03c0, "?get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAG@Z"                },
    { 0x03c1, "?get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAI@Z"                },
    { 0x03c2, "?get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAJ@Z"                },
    { 0x03c3, "?get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAK@Z"                },
    { 0x03c4, "?get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAM@Z"                },
    { 0x03c5, "?get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAN@Z"                },
    { 0x03c6, "?get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAO@Z"                },
    { 0x03c7, "?get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAPEAX@Z"             },
    { 0x03c8, "?get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEA_J@Z"               },
    { 0x03c9, "?get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEA_K@Z"               },
    { 0x03ca, "?get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEA_N@Z"               },
    { 0x03cb, "?get@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@DD@Z"              },
    { 0x03cc, "?get@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@PEBD4@Z"           },
    { 0x03cd, "?get@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@DD@Z"              },
    { 0x03ce, "?get@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@PEBG4@Z"           },
    { 0x03cf, "?get@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@DD@Z"         },
    { 0x03d0, "?get@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@PEB_W4@Z"     },
    { 0x03d1, "?get_date@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"           },
    { 0x03d2, "?get_date@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"           },
    { 0x03d3, "?get_date@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"      },
    { 0x03d4, "?get_monthname@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"      },
    { 0x03d5, "?get_monthname@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"      },
    { 0x03d6, "?get_monthname@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z" },
    { 0x03d7, "?get_new_handler@std@@YAP6AXXZXZ"                                                                                                                                                    },
    { 0x03d8, "?get_time@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"           },
    { 0x03d9, "?get_time@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"           },
    { 0x03da, "?get_time@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"      },
    { 0x03db, "?get_weekday@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"        },
    { 0x03dc, "?get_weekday@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"        },
    { 0x03dd, "?get_weekday@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"   },
    { 0x03de, "?get_year@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"           },
    { 0x03df, "?get_year@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"           },
    { 0x03e0, "?get_year@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHPEAUtm@@@Z"      },
    { 0x03e1, "?getline@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@PEAD_J@Z"                                                                                                           },
    { 0x03e2, "?getline@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@PEAD_JD@Z"                                                                                                          },
    { 0x03e3, "?getline@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@PEAG_J@Z"                                                                                                           },
    { 0x03e4, "?getline@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@PEAG_JG@Z"                                                                                                          },
    { 0x03e5, "?getline@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@PEA_W_J@Z"                                                                                                        },
    { 0x03e6, "?getline@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@PEA_W_J_W@Z"                                                                                                      },
    { 0x03e7, "?getloc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEBA?AVlocale@2@XZ"                                                                                                           },
    { 0x03e8, "?getloc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEBA?AVlocale@2@XZ"                                                                                                           },
    { 0x03e9, "?getloc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEBA?AVlocale@2@XZ"                                                                                                         },
    { 0x03ea, "?getloc@ios_base@std@@QEBA?AVlocale@2@XZ"                                                                                                                                            },
    { 0x03eb, "?global@locale@std@@SA?AV12@AEBV12@@Z"                                                                                                                                               },
    { 0x03ec, "?good@ios_base@std@@QEBA_NXZ"                                                                                                                                                        },
    { 0x03ed, "?gptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ"                                                                                                                     },
    { 0x03ee, "?gptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEBAPEAGXZ"                                                                                                                     },
    { 0x03ef, "?gptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEBAPEA_WXZ"                                                                                                                  },
    { 0x03f0, "?id@?$codecvt@DDH@std@@2V0locale@2@A"                                                                                                                                                },
    { 0x03f1, "?id@?$codecvt@GDH@std@@2V0locale@2@A"                                                                                                                                                },
    { 0x03f2, "?id@?$codecvt@_WDH@std@@2V0locale@2@A"                                                                                                                                               },
    { 0x03f3, "?id@?$collate@D@std@@2V0locale@2@A"                                                                                                                                                  },
    { 0x03f4, "?id@?$collate@G@std@@2V0locale@2@A"                                                                                                                                                  },
    { 0x03f5, "?id@?$collate@_W@std@@2V0locale@2@A"                                                                                                                                                 },
    { 0x03f6, "?id@?$ctype@D@std@@2V0locale@2@A"                                                                                                                                                    },
    { 0x03f7, "?id@?$ctype@G@std@@2V0locale@2@A"                                                                                                                                                    },
    { 0x03f8, "?id@?$ctype@_W@std@@2V0locale@2@A"                                                                                                                                                   },
    { 0x03f9, "?id@?$messages@D@std@@2V0locale@2@A"                                                                                                                                                 },
    { 0x03fa, "?id@?$messages@G@std@@2V0locale@2@A"                                                                                                                                                 },
    { 0x03fb, "?id@?$messages@_W@std@@2V0locale@2@A"                                                                                                                                                },
    { 0x03fc, "?id@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A"                                                                                            },
    { 0x03fd, "?id@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A"                                                                                            },
    { 0x03fe, "?id@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A"                                                                                         },
    { 0x03ff, "?id@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A"                                                                                            },
    { 0x0400, "?id@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A"                                                                                            },
    { 0x0401, "?id@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A"                                                                                         },
    { 0x0402, "?id@?$moneypunct@D$00@std@@2V0locale@2@A"                                                                                                                                            },
    { 0x0403, "?id@?$moneypunct@D$0A@@std@@2V0locale@2@A"                                                                                                                                           },
    { 0x0404, "?id@?$moneypunct@G$00@std@@2V0locale@2@A"                                                                                                                                            },
    { 0x0405, "?id@?$moneypunct@G$0A@@std@@2V0locale@2@A"                                                                                                                                           },
    { 0x0406, "?id@?$moneypunct@_W$00@std@@2V0locale@2@A"                                                                                                                                           },
    { 0x0407, "?id@?$moneypunct@_W$0A@@std@@2V0locale@2@A"                                                                                                                                          },
    { 0x0408, "?id@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A"                                                                                              },
    { 0x0409, "?id@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A"                                                                                              },
    { 0x040a, "?id@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A"                                                                                           },
    { 0x040b, "?id@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A"                                                                                              },
    { 0x040c, "?id@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A"                                                                                              },
    { 0x040d, "?id@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A"                                                                                           },
    { 0x040e, "?id@?$numpunct@D@std@@2V0locale@2@A"                                                                                                                                                 },
    { 0x040f, "?id@?$numpunct@G@std@@2V0locale@2@A"                                                                                                                                                 },
    { 0x0410, "?id@?$numpunct@_W@std@@2V0locale@2@A"                                                                                                                                                },
    { 0x0411, "?id@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A"                                                                                             },
    { 0x0412, "?id@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A"                                                                                             },
    { 0x0413, "?id@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A"                                                                                          },
    { 0x0414, "?id@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A"                                                                                             },
    { 0x0415, "?id@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A"                                                                                             },
    { 0x0416, "?id@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A"                                                                                          },
    { 0x0417, "?ignore@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@_JH@Z"                                                                                                               },
    { 0x0418, "?ignore@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@_JG@Z"                                                                                                               },
    { 0x0419, "?ignore@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@_JG@Z"                                                                                                             },
    { 0x041a, "?imbue@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAA?AVlocale@2@AEBV32@@Z"                                                                                                           },
    { 0x041b, "?imbue@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAA?AVlocale@2@AEBV32@@Z"                                                                                                           },
    { 0x041c, "?imbue@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAA?AVlocale@2@AEBV32@@Z"                                                                                                         },
    { 0x041d, "?imbue@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAXAEBVlocale@2@@Z"                                                                                                          },
    { 0x041e, "?imbue@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAAXAEBVlocale@2@@Z"                                                                                                          },
    { 0x041f, "?imbue@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAAXAEBVlocale@2@@Z"                                                                                                        },
    { 0x0420, "?imbue@ios_base@std@@QEAA?AVlocale@2@AEBV32@@Z"                                                                                                                                      },
    { 0x0421, "?in@?$codecvt@DDH@std@@QEBAHAEAHPEBD1AEAPEBDPEAD3AEAPEAD@Z"                                                                                                                          },
    { 0x0422, "?in@?$codecvt@GDH@std@@QEBAHAEAHPEBD1AEAPEBDPEAG3AEAPEAG@Z"                                                                                                                          },
    { 0x0423, "?in@?$codecvt@_WDH@std@@QEBAHAEAHPEBD1AEAPEBDPEA_W3AEAPEA_W@Z"                                                                                                                       },
    { 0x0424, "?in_avail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA_JXZ"                                                                                                                   },
    { 0x0425, "?in_avail@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAA_JXZ"                                                                                                                   },
    { 0x0426, "?in_avail@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAA_JXZ"                                                                                                                 },
    { 0x0427, "?init@?$basic_ios@DU?$char_traits@D@std@@@std@@IEAAXPEAV?$basic_streambuf@DU?$char_traits@D@std@@@2@_N@Z"                                                                            },
    { 0x0428, "?init@?$basic_ios@GU?$char_traits@G@std@@@std@@IEAAXPEAV?$basic_streambuf@GU?$char_traits@G@std@@@2@_N@Z"                                                                            },
    { 0x0429, "?init@?$basic_ios@_WU?$char_traits@_W@std@@@std@@IEAAXPEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@2@_N@Z"                                                                        },
    { 0x042a, "?intl@?$moneypunct@D$00@std@@2_NB"                                                                                                                                                   },
    { 0x042b, "?intl@?$moneypunct@D$0A@@std@@2_NB"                                                                                                                                                  },
    { 0x042c, "?intl@?$moneypunct@G$00@std@@2_NB"                                                                                                                                                   },
    { 0x042d, "?intl@?$moneypunct@G$0A@@std@@2_NB"                                                                                                                                                  },
    { 0x042e, "?intl@?$moneypunct@_W$00@std@@2_NB"                                                                                                                                                  },
    { 0x042f, "?intl@?$moneypunct@_W$0A@@std@@2_NB"                                                                                                                                                 },
    { 0x0430, "?ipfx@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA_N_N@Z"                                                                                                                       },
    { 0x0431, "?ipfx@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAA_N_N@Z"                                                                                                                       },
    { 0x0432, "?ipfx@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAA_N_N@Z"                                                                                                                     },
    { 0x0433, "?is@?$ctype@D@std@@QEBAPEBDPEBD0PEAF@Z"                                                                                                                                              },
    { 0x0434, "?is@?$ctype@D@std@@QEBA_NFD@Z"                                                                                                                                                       },
    { 0x0435, "?is@?$ctype@G@std@@QEBAPEBGPEBG0PEAF@Z"                                                                                                                                              },
    { 0x0436, "?is@?$ctype@G@std@@QEBA_NFG@Z"                                                                                                                                                       },
    { 0x0437, "?is@?$ctype@_W@std@@QEBAPEB_WPEB_W0PEAF@Z"                                                                                                                                           },
    { 0x0438, "?is@?$ctype@_W@std@@QEBA_NF_W@Z"                                                                                                                                                     },
    { 0x0439, "?is_current_task_group_canceling@Concurrency@@YA_NXZ"                                                                                                                                },
    { 0x043a, "?isfx@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAXXZ"                                                                                                                          },
    { 0x043b, "?isfx@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAXXZ"                                                                                                                          },
    { 0x043c, "?isfx@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"                                                                                                                        },
    { 0x043d, "?iword@ios_base@std@@QEAAAEAJH@Z"                                                                                                                                                    },
    { 0x043e, "?length@?$codecvt@DDH@std@@QEBAHAEAHPEBD1_K@Z"                                                                                                                                       },
    { 0x043f, "?length@?$codecvt@GDH@std@@QEBAHAEAHPEBD1_K@Z"                                                                                                                                       },
    { 0x0440, "?length@?$codecvt@_WDH@std@@QEBAHAEAHPEBD1_K@Z"                                                                                                                                      },
    { 0x0441, "?max_length@codecvt_base@std@@QEBAHXZ"                                                                                                                                               },
    { 0x0442, "?move@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAX$$QEAV12@@Z"                                                                                                                     },
    { 0x0443, "?move@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXAEAV12@@Z"                                                                                                                       },
    { 0x0444, "?move@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAX$$QEAV12@@Z"                                                                                                                     },
    { 0x0445, "?move@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAXAEAV12@@Z"                                                                                                                       },
    { 0x0446, "?move@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAX$$QEAV12@@Z"                                                                                                                   },
    { 0x0447, "?move@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAXAEAV12@@Z"                                                                                                                     },
    { 0x0448, "?narrow@?$basic_ios@DU?$char_traits@D@std@@@std@@QEBADDD@Z"                                                                                                                          },
    { 0x0449, "?narrow@?$basic_ios@GU?$char_traits@G@std@@@std@@QEBADGD@Z"                                                                                                                          },
    { 0x044a, "?narrow@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEBAD_WD@Z"                                                                                                                       },
    { 0x044b, "?narrow@?$ctype@D@std@@QEBADDD@Z"                                                                                                                                                    },
    { 0x044c, "?narrow@?$ctype@D@std@@QEBAPEBDPEBD0DPEAD@Z"                                                                                                                                         },
    { 0x044d, "?narrow@?$ctype@G@std@@QEBADGD@Z"                                                                                                                                                    },
    { 0x044e, "?narrow@?$ctype@G@std@@QEBAPEBGPEBG0DPEAD@Z"                                                                                                                                         },
    { 0x044f, "?narrow@?$ctype@_W@std@@QEBAD_WD@Z"                                                                                                                                                  },
    { 0x0450, "?narrow@?$ctype@_W@std@@QEBAPEB_WPEB_W0DPEAD@Z"                                                                                                                                      },
    { 0x0451, "?opfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA_NXZ"                                                                                                                         },
    { 0x0452, "?opfx@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA_NXZ"                                                                                                                         },
    { 0x0453, "?opfx@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA_NXZ"                                                                                                                       },
    { 0x0454, "?osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ"                                                                                                                          },
    { 0x0455, "?osfx@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAXXZ"                                                                                                                          },
    { 0x0456, "?osfx@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"                                                                                                                        },
    { 0x0457, "?out@?$codecvt@DDH@std@@QEBAHAEAHPEBD1AEAPEBDPEAD3AEAPEAD@Z"                                                                                                                         },
    { 0x0458, "?out@?$codecvt@GDH@std@@QEBAHAEAHPEBG1AEAPEBGPEAD3AEAPEAD@Z"                                                                                                                         },
    { 0x0459, "?out@?$codecvt@_WDH@std@@QEBAHAEAHPEB_W1AEAPEB_WPEAD3AEAPEAD@Z"                                                                                                                      },
    { 0x045a, "?overflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z"                                                                                                                   },
    { 0x045b, "?overflow@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAAGG@Z"                                                                                                                   },
    { 0x045c, "?overflow@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAAGG@Z"                                                                                                                 },
    { 0x045d, "?pbackfail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z"                                                                                                                  },
    { 0x045e, "?pbackfail@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAAGG@Z"                                                                                                                  },
    { 0x045f, "?pbackfail@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAAGG@Z"                                                                                                                },
    { 0x0460, "?pbase@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ"                                                                                                                    },
    { 0x0461, "?pbase@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEBAPEAGXZ"                                                                                                                    },
    { 0x0462, "?pbase@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEBAPEA_WXZ"                                                                                                                 },
    { 0x0463, "?pbump@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXH@Z"                                                                                                                      },
    { 0x0464, "?pbump@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXH@Z"                                                                                                                      },
    { 0x0465, "?pbump@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXH@Z"                                                                                                                    },
    { 0x0466, "?peek@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAHXZ"                                                                                                                          },
    { 0x0467, "?peek@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAGXZ"                                                                                                                          },
    { 0x0468, "?peek@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAGXZ"                                                                                                                        },
    { 0x0469, "?pptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBAPEADXZ"                                                                                                                     },
    { 0x046a, "?pptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEBAPEAGXZ"                                                                                                                     },
    { 0x046b, "?pptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEBAPEA_WXZ"                                                                                                                  },
    { 0x046c, "?precision@ios_base@std@@QEAA_J_J@Z"                                                                                                                                                 },
    { 0x046d, "?precision@ios_base@std@@QEBA_JXZ"                                                                                                                                                   },
    { 0x046e, "?pubimbue@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA?AVlocale@2@AEBV32@@Z"                                                                                                  },
    { 0x046f, "?pubimbue@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAA?AVlocale@2@AEBV32@@Z"                                                                                                  },
    { 0x0470, "?pubimbue@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAA?AVlocale@2@AEBV32@@Z"                                                                                                },
    { 0x0471, "?pubseekoff@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA?AV?$fpos@H@2@_JHH@Z"                                                                                                 },
    { 0x0472, "?pubseekoff@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA?AV?$fpos@H@2@_JII@Z"                                                                                                 },
    { 0x0473, "?pubseekoff@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAA?AV?$fpos@H@2@_JHH@Z"                                                                                                 },
    { 0x0474, "?pubseekoff@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAA?AV?$fpos@H@2@_JII@Z"                                                                                                 },
    { 0x0475, "?pubseekoff@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAA?AV?$fpos@H@2@_JHH@Z"                                                                                               },
    { 0x0476, "?pubseekoff@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAA?AV?$fpos@H@2@_JII@Z"                                                                                               },
    { 0x0477, "?pubseekpos@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA?AV?$fpos@H@2@V32@H@Z"                                                                                                },
    { 0x0478, "?pubseekpos@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA?AV?$fpos@H@2@V32@I@Z"                                                                                                },
    { 0x0479, "?pubseekpos@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAA?AV?$fpos@H@2@V32@H@Z"                                                                                                },
    { 0x047a, "?pubseekpos@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAA?AV?$fpos@H@2@V32@I@Z"                                                                                                },
    { 0x047b, "?pubseekpos@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAA?AV?$fpos@H@2@V32@H@Z"                                                                                              },
    { 0x047c, "?pubseekpos@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAA?AV?$fpos@H@2@V32@I@Z"                                                                                              },
    { 0x047d, "?pubsetbuf@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAPEAV12@PEAD_J@Z"                                                                                                       },
    { 0x047e, "?pubsetbuf@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAAPEAV12@PEAG_J@Z"                                                                                                       },
    { 0x047f, "?pubsetbuf@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAAPEAV12@PEA_W_J@Z"                                                                                                    },
    { 0x0480, "?pubsync@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHXZ"                                                                                                                     },
    { 0x0481, "?pubsync@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAAHXZ"                                                                                                                     },
    { 0x0482, "?pubsync@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAAHXZ"                                                                                                                   },
    { 0x0483, "?put@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@D@Z"                                                                                                                    },
    { 0x0484, "?put@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@G@Z"                                                                                                                    },
    { 0x0485, "?put@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@_W@Z"                                                                                                                 },
    { 0x0486, "?put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DJ@Z"                            },
    { 0x0487, "?put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DK@Z"                            },
    { 0x0488, "?put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DN@Z"                            },
    { 0x0489, "?put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DO@Z"                            },
    { 0x048a, "?put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEBX@Z"                         },
    { 0x048b, "?put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@D_J@Z"                           },
    { 0x048c, "?put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@D_K@Z"                           },
    { 0x048d, "?put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@D_N@Z"                           },
    { 0x048e, "?put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GJ@Z"                            },
    { 0x048f, "?put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GK@Z"                            },
    { 0x0490, "?put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GN@Z"                            },
    { 0x0491, "?put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GO@Z"                            },
    { 0x0492, "?put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GPEBX@Z"                         },
    { 0x0493, "?put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@G_J@Z"                           },
    { 0x0494, "?put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@G_K@Z"                           },
    { 0x0495, "?put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@G_N@Z"                           },
    { 0x0496, "?put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WJ@Z"                      },
    { 0x0497, "?put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WK@Z"                      },
    { 0x0498, "?put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WN@Z"                      },
    { 0x0499, "?put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WO@Z"                      },
    { 0x049a, "?put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WPEBX@Z"                   },
    { 0x049b, "?put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_W_J@Z"                     },
    { 0x049c, "?put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_W_K@Z"                     },
    { 0x049d, "?put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_W_N@Z"                     },
    { 0x049e, "?put@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEBUtm@@DD@Z"                  },
    { 0x049f, "?put@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEBUtm@@PEBD3@Z"               },
    { 0x04a0, "?put@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GPEBUtm@@DD@Z"                  },
    { 0x04a1, "?put@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AEAVios_base@2@GPEBUtm@@PEBG3@Z"               },
    { 0x04a2, "?put@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WPEBUtm@@DD@Z"            },
    { 0x04a3, "?put@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AEAVios_base@2@_WPEBUtm@@PEB_W4@Z"        },
    { 0x04a4, "?putback@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@D@Z"                                                                                                                },
    { 0x04a5, "?putback@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@G@Z"                                                                                                                },
    { 0x04a6, "?putback@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@_W@Z"                                                                                                             },
    { 0x04a7, "?pword@ios_base@std@@QEAAAEAPEAXH@Z"                                                                                                                                                 },
    { 0x04a8, "?rdbuf@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAPEAV?$basic_streambuf@DU?$char_traits@D@std@@@2@PEAV32@@Z"                                                                       },
    { 0x04a9, "?rdbuf@?$basic_ios@DU?$char_traits@D@std@@@std@@QEBAPEAV?$basic_streambuf@DU?$char_traits@D@std@@@2@XZ"                                                                              },
    { 0x04aa, "?rdbuf@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAPEAV?$basic_streambuf@GU?$char_traits@G@std@@@2@PEAV32@@Z"                                                                       },
    { 0x04ab, "?rdbuf@?$basic_ios@GU?$char_traits@G@std@@@std@@QEBAPEAV?$basic_streambuf@GU?$char_traits@G@std@@@2@XZ"                                                                              },
    { 0x04ac, "?rdbuf@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAPEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@2@PEAV32@@Z"                                                                   },
    { 0x04ad, "?rdbuf@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEBAPEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@2@XZ"                                                                          },
    { 0x04ae, "?rdstate@ios_base@std@@QEBAHXZ"                                                                                                                                                      },
    { 0x04af, "?read@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@PEAD_J@Z"                                                                                                              },
    { 0x04b0, "?read@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@PEAG_J@Z"                                                                                                              },
    { 0x04b1, "?read@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@PEA_W_J@Z"                                                                                                           },
    { 0x04b2, "?readsome@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA_JPEAD_J@Z"                                                                                                               },
    { 0x04b3, "?readsome@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAA_JPEAG_J@Z"                                                                                                               },
    { 0x04b4, "?readsome@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAA_JPEA_W_J@Z"                                                                                                            },
    { 0x04b5, "?register_callback@ios_base@std@@QEAAXP6AXW4event@12@AEAV12@H@ZH@Z"                                                                                                                  },
    { 0x04b6, "?resetiosflags@std@@YA?AU?$_Smanip@H@1@H@Z"                                                                                                                                          },
    { 0x04b7, "?sbumpc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHXZ"                                                                                                                      },
    { 0x04b8, "?sbumpc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAAGXZ"                                                                                                                      },
    { 0x04b9, "?sbumpc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAAGXZ"                                                                                                                    },
    { 0x04ba, "?scan_is@?$ctype@D@std@@QEBAPEBDFPEBD0@Z"                                                                                                                                            },
    { 0x04bb, "?scan_is@?$ctype@G@std@@QEBAPEBGFPEBG0@Z"                                                                                                                                            },
    { 0x04bc, "?scan_is@?$ctype@_W@std@@QEBAPEB_WFPEB_W0@Z"                                                                                                                                         },
    { 0x04bd, "?scan_not@?$ctype@D@std@@QEBAPEBDFPEBD0@Z"                                                                                                                                           },
    { 0x04be, "?scan_not@?$ctype@G@std@@QEBAPEBGFPEBG0@Z"                                                                                                                                           },
    { 0x04bf, "?scan_not@?$ctype@_W@std@@QEBAPEB_WFPEB_W0@Z"                                                                                                                                        },
    { 0x04c0, "?seekg@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@V?$fpos@H@2@@Z"                                                                                                       },
    { 0x04c1, "?seekg@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@_JH@Z"                                                                                                                },
    { 0x04c2, "?seekg@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@V?$fpos@H@2@@Z"                                                                                                       },
    { 0x04c3, "?seekg@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@_JH@Z"                                                                                                                },
    { 0x04c4, "?seekg@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@V?$fpos@H@2@@Z"                                                                                                     },
    { 0x04c5, "?seekg@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@_JH@Z"                                                                                                              },
    { 0x04c6, "?seekoff@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA?AV?$fpos@H@2@_JHH@Z"                                                                                                    },
    { 0x04c7, "?seekoff@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAA?AV?$fpos@H@2@_JHH@Z"                                                                                                    },
    { 0x04c8, "?seekoff@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAA?AV?$fpos@H@2@_JHH@Z"                                                                                                  },
    { 0x04c9, "?seekp@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@V?$fpos@H@2@@Z"                                                                                                       },
    { 0x04ca, "?seekp@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@_JH@Z"                                                                                                                },
    { 0x04cb, "?seekp@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@V?$fpos@H@2@@Z"                                                                                                       },
    { 0x04cc, "?seekp@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@_JH@Z"                                                                                                                },
    { 0x04cd, "?seekp@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@V?$fpos@H@2@@Z"                                                                                                     },
    { 0x04ce, "?seekp@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@_JH@Z"                                                                                                              },
    { 0x04cf, "?seekpos@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA?AV?$fpos@H@2@V32@H@Z"                                                                                                   },
    { 0x04d0, "?seekpos@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAA?AV?$fpos@H@2@V32@H@Z"                                                                                                   },
    { 0x04d1, "?seekpos@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAA?AV?$fpos@H@2@V32@H@Z"                                                                                                 },
    { 0x04d2, "?set_new_handler@std@@YAP6AXXZP6AXXZ@Z"                                                                                                                                              },
    { 0x04d3, "?set_rdbuf@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXPEAV?$basic_streambuf@DU?$char_traits@D@std@@@2@@Z"                                                                         },
    { 0x04d4, "?set_rdbuf@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAXPEAV?$basic_streambuf@GU?$char_traits@G@std@@@2@@Z"                                                                         },
    { 0x04d5, "?set_rdbuf@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAXPEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@2@@Z"                                                                     },
    { 0x04d6, "?setbase@std@@YA?AU?$_Smanip@H@1@H@Z"                                                                                                                                                },
    { 0x04d7, "?setbuf@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAPEAV12@PEAD_J@Z"                                                                                                          },
    { 0x04d8, "?setbuf@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAAPEAV12@PEAG_J@Z"                                                                                                          },
    { 0x04d9, "?setbuf@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAAPEAV12@PEA_W_J@Z"                                                                                                       },
    { 0x04da, "?setf@ios_base@std@@QEAAHH@Z"                                                                                                                                                        },
    { 0x04db, "?setf@ios_base@std@@QEAAHHH@Z"                                                                                                                                                       },
    { 0x04dc, "?setg@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXPEAD00@Z"                                                                                                                  },
    { 0x04dd, "?setg@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXPEAG00@Z"                                                                                                                  },
    { 0x04de, "?setg@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXPEA_W00@Z"                                                                                                               },
    { 0x04df, "?setiosflags@std@@YA?AU?$_Smanip@H@1@H@Z"                                                                                                                                            },
    { 0x04e0, "?setp@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXPEAD00@Z"                                                                                                                  },
    { 0x04e1, "?setp@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXPEAD0@Z"                                                                                                                   },
    { 0x04e2, "?setp@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXPEAG00@Z"                                                                                                                  },
    { 0x04e3, "?setp@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXPEAG0@Z"                                                                                                                   },
    { 0x04e4, "?setp@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXPEA_W00@Z"                                                                                                               },
    { 0x04e5, "?setp@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXPEA_W0@Z"                                                                                                                },
    { 0x04e6, "?setprecision@std@@YA?AU?$_Smanip@_J@1@_J@Z"                                                                                                                                         },
    { 0x04e7, "?setstate@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z"                                                                                                                       },
    { 0x04e8, "?setstate@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXI@Z"                                                                                                                         },
    { 0x04e9, "?setstate@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAXH_N@Z"                                                                                                                       },
    { 0x04ea, "?setstate@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAXI@Z"                                                                                                                         },
    { 0x04eb, "?setstate@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAXH_N@Z"                                                                                                                     },
    { 0x04ec, "?setstate@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAXI@Z"                                                                                                                       },
    { 0x04ed, "?setstate@ios_base@std@@QEAAXH@Z"                                                                                                                                                    },
    { 0x04ee, "?setstate@ios_base@std@@QEAAXH_N@Z"                                                                                                                                                  },
    { 0x04ef, "?setstate@ios_base@std@@QEAAXI@Z"                                                                                                                                                    },
    { 0x04f0, "?setw@std@@YA?AU?$_Smanip@_J@1@_J@Z"                                                                                                                                                 },
    { 0x04f1, "?sgetc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHXZ"                                                                                                                       },
    { 0x04f2, "?sgetc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAAGXZ"                                                                                                                       },
    { 0x04f3, "?sgetc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAAGXZ"                                                                                                                     },
    { 0x04f4, "?sgetn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA_JPEAD_J@Z"                                                                                                                },
    { 0x04f5, "?sgetn@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAA_JPEAG_J@Z"                                                                                                                },
    { 0x04f6, "?sgetn@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAA_JPEA_W_J@Z"                                                                                                             },
    { 0x04f7, "?showmanyc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JXZ"                                                                                                                  },
    { 0x04f8, "?showmanyc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAA_JXZ"                                                                                                                  },
    { 0x04f9, "?showmanyc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAA_JXZ"                                                                                                                },
    { 0x04fa, "?snextc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHXZ"                                                                                                                      },
    { 0x04fb, "?snextc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAAGXZ"                                                                                                                      },
    { 0x04fc, "?snextc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAAGXZ"                                                                                                                    },
    { 0x04fd, "?sputbackc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHD@Z"                                                                                                                  },
    { 0x04fe, "?sputbackc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAAGG@Z"                                                                                                                  },
    { 0x04ff, "?sputbackc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAAG_W@Z"                                                                                                               },
    { 0x0500, "?sputc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHD@Z"                                                                                                                      },
    { 0x0501, "?sputc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAAGG@Z"                                                                                                                      },
    { 0x0502, "?sputc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAAG_W@Z"                                                                                                                   },
    { 0x0503, "?sputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA_JPEBD_J@Z"                                                                                                                },
    { 0x0504, "?sputn@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAA_JPEBG_J@Z"                                                                                                                },
    { 0x0505, "?sputn@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAA_JPEB_W_J@Z"                                                                                                             },
    { 0x0506, "?start@agent@Concurrency@@QEAA_NXZ"                                                                                                                                                  },
    { 0x0507, "?status@agent@Concurrency@@QEAA?AW4agent_status@2@XZ"                                                                                                                                },
    { 0x0508, "?status_port@agent@Concurrency@@QEAAPEAV?$ISource@W4agent_status@Concurrency@@@2@XZ"                                                                                                 },
    { 0x0509, "?stossc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAXXZ"                                                                                                                      },
    { 0x050a, "?stossc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAAXXZ"                                                                                                                      },
    { 0x050b, "?stossc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"                                                                                                                    },
    { 0x050c, "?sungetc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHXZ"                                                                                                                     },
    { 0x050d, "?sungetc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAAGXZ"                                                                                                                     },
    { 0x050e, "?sungetc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAAGXZ"                                                                                                                   },
    { 0x050f, "?swap@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXAEAV12@@Z"                                                                                                                       },
    { 0x0510, "?swap@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAXAEAV12@@Z"                                                                                                                       },
    { 0x0511, "?swap@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAXAEAV12@@Z"                                                                                                                     },
    { 0x0512, "?swap@?$basic_iostream@DU?$char_traits@D@std@@@std@@IEAAXAEAV12@@Z"                                                                                                                  },
    { 0x0513, "?swap@?$basic_iostream@GU?$char_traits@G@std@@@std@@IEAAXAEAV12@@Z"                                                                                                                  },
    { 0x0514, "?swap@?$basic_iostream@_WU?$char_traits@_W@std@@@std@@IEAAXAEAV12@@Z"                                                                                                                },
    { 0x0515, "?swap@?$basic_istream@DU?$char_traits@D@std@@@std@@IEAAXAEAV12@@Z"                                                                                                                   },
    { 0x0516, "?swap@?$basic_istream@GU?$char_traits@G@std@@@std@@IEAAXAEAV12@@Z"                                                                                                                   },
    { 0x0517, "?swap@?$basic_istream@_WU?$char_traits@_W@std@@@std@@IEAAXAEAV12@@Z"                                                                                                                 },
    { 0x0518, "?swap@?$basic_ostream@DU?$char_traits@D@std@@@std@@IEAAXAEAV12@@Z"                                                                                                                   },
    { 0x0519, "?swap@?$basic_ostream@GU?$char_traits@G@std@@@std@@IEAAXAEAV12@@Z"                                                                                                                   },
    { 0x051a, "?swap@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@IEAAXAEAV12@@Z"                                                                                                                 },
    { 0x051b, "?swap@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXAEAV12@@Z"                                                                                                                 },
    { 0x051c, "?swap@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXAEAV12@@Z"                                                                                                                 },
    { 0x051d, "?swap@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXAEAV12@@Z"                                                                                                               },
    { 0x051e, "?swap@ios_base@std@@QEAAXAEAV12@@Z"                                                                                                                                                  },
    { 0x051f, "?sync@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAHXZ"                                                                                                                          },
    { 0x0520, "?sync@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAHXZ"                                                                                                                          },
    { 0x0521, "?sync@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAHXZ"                                                                                                                        },
    { 0x0522, "?sync@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ"                                                                                                                        },
    { 0x0523, "?sync@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAAHXZ"                                                                                                                        },
    { 0x0524, "?sync@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAAHXZ"                                                                                                                      },
    { 0x0525, "?sync_with_stdio@ios_base@std@@SA_N_N@Z"                                                                                                                                             },
    { 0x0526, "?table@?$ctype@D@std@@QEBAPEBFXZ"                                                                                                                                                    },
    { 0x0527, "?table_size@?$ctype@D@std@@2_KB"                                                                                                                                                     },
    { 0x0528, "?tellg@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA?AV?$fpos@H@2@XZ"                                                                                                            },
    { 0x0529, "?tellg@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAA?AV?$fpos@H@2@XZ"                                                                                                            },
    { 0x052a, "?tellg@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAA?AV?$fpos@H@2@XZ"                                                                                                          },
    { 0x052b, "?tellp@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA?AV?$fpos@H@2@XZ"                                                                                                            },
    { 0x052c, "?tellp@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA?AV?$fpos@H@2@XZ"                                                                                                            },
    { 0x052d, "?tellp@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA?AV?$fpos@H@2@XZ"                                                                                                          },
    { 0x052e, "?tie@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAPEAV?$basic_ostream@DU?$char_traits@D@std@@@2@PEAV32@@Z"                                                                           },
    { 0x052f, "?tie@?$basic_ios@DU?$char_traits@D@std@@@std@@QEBAPEAV?$basic_ostream@DU?$char_traits@D@std@@@2@XZ"                                                                                  },
    { 0x0530, "?tie@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAPEAV?$basic_ostream@GU?$char_traits@G@std@@@2@PEAV32@@Z"                                                                           },
    { 0x0531, "?tie@?$basic_ios@GU?$char_traits@G@std@@@std@@QEBAPEAV?$basic_ostream@GU?$char_traits@G@std@@@2@XZ"                                                                                  },
    { 0x0532, "?tie@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAPEAV?$basic_ostream@_WU?$char_traits@_W@std@@@2@PEAV32@@Z"                                                                       },
    { 0x0533, "?tie@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEBAPEAV?$basic_ostream@_WU?$char_traits@_W@std@@@2@XZ"                                                                              },
    { 0x0534, "?tolower@?$ctype@D@std@@QEBADD@Z"                                                                                                                                                    },
    { 0x0535, "?tolower@?$ctype@D@std@@QEBAPEBDPEADPEBD@Z"                                                                                                                                          },
    { 0x0536, "?tolower@?$ctype@G@std@@QEBAGG@Z"                                                                                                                                                    },
    { 0x0537, "?tolower@?$ctype@G@std@@QEBAPEBGPEAGPEBG@Z"                                                                                                                                          },
    { 0x0538, "?tolower@?$ctype@_W@std@@QEBAPEB_WPEA_WPEB_W@Z"                                                                                                                                      },
    { 0x0539, "?tolower@?$ctype@_W@std@@QEBA_W_W@Z"                                                                                                                                                 },
    { 0x053a, "?toupper@?$ctype@D@std@@QEBADD@Z"                                                                                                                                                    },
    { 0x053b, "?toupper@?$ctype@D@std@@QEBAPEBDPEADPEBD@Z"                                                                                                                                          },
    { 0x053c, "?toupper@?$ctype@G@std@@QEBAGG@Z"                                                                                                                                                    },
    { 0x053d, "?toupper@?$ctype@G@std@@QEBAPEBGPEAGPEBG@Z"                                                                                                                                          },
    { 0x053e, "?toupper@?$ctype@_W@std@@QEBAPEB_WPEA_WPEB_W@Z"                                                                                                                                      },
    { 0x053f, "?toupper@?$ctype@_W@std@@QEBA_W_W@Z"                                                                                                                                                 },
    { 0x0540, "?try_to_lock@std@@3Utry_to_lock_t@1@B"                                                                                                                                               },
    { 0x0541, "?uflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ"                                                                                                                       },
    { 0x0542, "?uflow@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAAGXZ"                                                                                                                       },
    { 0x0543, "?uflow@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAAGXZ"                                                                                                                     },
    { 0x0544, "?uncaught_exception@std@@YA_NXZ"                                                                                                                                                     },
    { 0x0545, "?underflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ"                                                                                                                   },
    { 0x0546, "?underflow@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAAGXZ"                                                                                                                   },
    { 0x0547, "?underflow@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAAGXZ"                                                                                                                 },
    { 0x0548, "?unget@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@XZ"                                                                                                                   },
    { 0x0549, "?unget@?$basic_istream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@XZ"                                                                                                                   },
    { 0x054a, "?unget@?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@XZ"                                                                                                                 },
    { 0x054b, "?unsetf@ios_base@std@@QEAAXH@Z"                                                                                                                                                      },
    { 0x054c, "?unshift@?$codecvt@DDH@std@@QEBAHAEAHPEAD1AEAPEAD@Z"                                                                                                                                 },
    { 0x054d, "?unshift@?$codecvt@GDH@std@@QEBAHAEAHPEAD1AEAPEAD@Z"                                                                                                                                 },
    { 0x054e, "?unshift@?$codecvt@_WDH@std@@QEBAHAEAHPEAD1AEAPEAD@Z"                                                                                                                                },
    { 0x054f, "?wait@agent@Concurrency@@SA?AW4agent_status@2@PEAV12@I@Z"                                                                                                                            },
    { 0x0550, "?wait_for_all@agent@Concurrency@@SAX_KPEAPEAV12@PEAW4agent_status@2@I@Z"                                                                                                             },
    { 0x0551, "?wait_for_one@agent@Concurrency@@SAX_KPEAPEAV12@AEAW4agent_status@2@AEA_KI@Z"                                                                                                        },
    { 0x0552, "?wcerr@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A"                                                                                                                           },
    { 0x0553, "?wcerr@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A"                                                                                                                         },
    { 0x0554, "?wcin@std@@3V?$basic_istream@GU?$char_traits@G@std@@@1@A"                                                                                                                            },
    { 0x0555, "?wcin@std@@3V?$basic_istream@_WU?$char_traits@_W@std@@@1@A"                                                                                                                          },
    { 0x0556, "?wclog@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A"                                                                                                                           },
    { 0x0557, "?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A"                                                                                                                         },
    { 0x0558, "?wcout@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A"                                                                                                                           },
    { 0x0559, "?wcout@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A"                                                                                                                         },
    { 0x055a, "?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QEBADD@Z"                                                                                                                            },
    { 0x055b, "?widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QEBAGD@Z"                                                                                                                            },
    { 0x055c, "?widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEBA_WD@Z"                                                                                                                         },
    { 0x055d, "?widen@?$ctype@D@std@@QEBADD@Z"                                                                                                                                                      },
    { 0x055e, "?widen@?$ctype@D@std@@QEBAPEBDPEBD0PEAD@Z"                                                                                                                                           },
    { 0x055f, "?widen@?$ctype@G@std@@QEBAGD@Z"                                                                                                                                                      },
    { 0x0560, "?widen@?$ctype@G@std@@QEBAPEBDPEBD0PEAG@Z"                                                                                                                                           },
    { 0x0561, "?widen@?$ctype@_W@std@@QEBAPEBDPEBD0PEA_W@Z"                                                                                                                                         },
    { 0x0562, "?widen@?$ctype@_W@std@@QEBA_WD@Z"                                                                                                                                                    },
    { 0x0563, "?width@ios_base@std@@QEAA_J_J@Z"                                                                                                                                                     },
    { 0x0564, "?width@ios_base@std@@QEBA_JXZ"                                                                                                                                                       },
    { 0x0565, "?write@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@PEBD_J@Z"                                                                                                             },
    { 0x0566, "?write@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@PEBG_J@Z"                                                                                                             },
    { 0x0567, "?write@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@PEB_W_J@Z"                                                                                                          },
    { 0x0568, "?ws@std@@YAAEAV?$basic_istream@DU?$char_traits@D@std@@@1@AEAV21@@Z"                                                                                                                  },
    { 0x0569, "?ws@std@@YAAEAV?$basic_istream@GU?$char_traits@G@std@@@1@AEAV21@@Z"                                                                                                                  },
    { 0x056a, "?ws@std@@YAAEAV?$basic_istream@_WU?$char_traits@_W@std@@@1@AEAV21@@Z"                                                                                                                },
    { 0x056b, "?xalloc@ios_base@std@@SAHXZ"                                                                                                                                                         },
    { 0x056c, "?xsgetn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEAD_J@Z"                                                                                                               },
    { 0x056d, "?xsgetn@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAA_JPEAG_J@Z"                                                                                                               },
    { 0x056e, "?xsgetn@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAA_JPEA_W_J@Z"                                                                                                            },
    { 0x056f, "?xsputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEBD_J@Z"                                                                                                               },
    { 0x0570, "?xsputn@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAA_JPEBG_J@Z"                                                                                                               },
    { 0x0571, "?xsputn@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAA_JPEB_W_J@Z"                                                                                                            },
    { 0x0572, "_Call_once"                                                                                                                                                                          },
    { 0x0573, "_Call_onceEx"                                                                                                                                                                        },
    { 0x0574, "_Cnd_broadcast"                                                                                                                                                                      },
    { 0x0575, "_Cnd_destroy"                                                                                                                                                                        },
    { 0x0576, "_Cnd_do_broadcast_at_thread_exit"                                                                                                                                                    },
    { 0x0577, "_Cnd_init"                                                                                                                                                                           },
    { 0x0578, "_Cnd_register_at_thread_exit"                                                                                                                                                        },
    { 0x0579, "_Cnd_signal"                                                                                                                                                                         },
    { 0x057a, "_Cnd_timedwait"                                                                                                                                                                      },
    { 0x057b, "_Cnd_unregister_at_thread_exit"                                                                                                                                                      },
    { 0x057c, "_Cnd_wait"                                                                                                                                                                           },
    { 0x057d, "_Cosh"                                                                                                                                                                               },
    { 0x057e, "_Denorm"                                                                                                                                                                             },
    { 0x057f, "_Dint"                                                                                                                                                                               },
    { 0x0580, "_Dnorm"                                                                                                                                                                              },
    { 0x0581, "_Do_call"                                                                                                                                                                            },
    { 0x0582, "_Dscale"                                                                                                                                                                             },
    { 0x0583, "_Dtento"                                                                                                                                                                             },
    { 0x0584, "_Dtest"                                                                                                                                                                              },
    { 0x0585, "_Dunscale"                                                                                                                                                                           },
    { 0x0586, "_Eps"                                                                                                                                                                                },
    { 0x0587, "_Exp"                                                                                                                                                                                },
    { 0x0588, "_FCosh"                                                                                                                                                                              },
    { 0x0589, "_FDenorm"                                                                                                                                                                            },
    { 0x058a, "_FDint"                                                                                                                                                                              },
    { 0x058b, "_FDnorm"                                                                                                                                                                             },
    { 0x058c, "_FDscale"                                                                                                                                                                            },
    { 0x058d, "_FDtento"                                                                                                                                                                            },
    { 0x058e, "_FDtest"                                                                                                                                                                             },
    { 0x058f, "_FDunscale"                                                                                                                                                                          },
    { 0x0590, "_FEps"                                                                                                                                                                               },
    { 0x0591, "_FExp"                                                                                                                                                                               },
    { 0x0592, "_FInf"                                                                                                                                                                               },
    { 0x0593, "_FNan"                                                                                                                                                                               },
    { 0x0594, "_FPlsw"                                                                                                                                                                              },
    { 0x0595, "_FPmsw"                                                                                                                                                                              },
    { 0x0596, "_FRteps"                                                                                                                                                                             },
    { 0x0597, "_FSinh"                                                                                                                                                                              },
    { 0x0598, "_FSnan"                                                                                                                                                                              },
    { 0x0599, "_FXbig"                                                                                                                                                                              },
    { 0x059a, "_FXp_addh"                                                                                                                                                                           },
    { 0x059b, "_FXp_addx"                                                                                                                                                                           },
    { 0x059c, "_FXp_getw"                                                                                                                                                                           },
    { 0x059d, "_FXp_invx"                                                                                                                                                                           },
    { 0x059e, "_FXp_ldexpx"                                                                                                                                                                         },
    { 0x059f, "_FXp_movx"                                                                                                                                                                           },
    { 0x05a0, "_FXp_mulh"                                                                                                                                                                           },
    { 0x05a1, "_FXp_mulx"                                                                                                                                                                           },
    { 0x05a2, "_FXp_setn"                                                                                                                                                                           },
    { 0x05a3, "_FXp_setw"                                                                                                                                                                           },
    { 0x05a4, "_FXp_sqrtx"                                                                                                                                                                          },
    { 0x05a5, "_FXp_subx"                                                                                                                                                                           },
    { 0x05a6, "_FZero"                                                                                                                                                                              },
    { 0x05a7, "_Getcoll"                                                                                                                                                                            },
    { 0x05a8, "_Getctype"                                                                                                                                                                           },
    { 0x05a9, "_Getcvt"                                                                                                                                                                             },
    { 0x05aa, "_Getdateorder"                                                                                                                                                                       },
    { 0x05ab, "_Getwctype"                                                                                                                                                                          },
    { 0x05ac, "_Getwctypes"                                                                                                                                                                         },
    { 0x05ad, "_Hugeval"                                                                                                                                                                            },
    { 0x05ae, "_Inf"                                                                                                                                                                                },
    { 0x05af, "_LCosh"                                                                                                                                                                              },
    { 0x05b0, "_LDenorm"                                                                                                                                                                            },
    { 0x05b1, "_LDint"                                                                                                                                                                              },
    { 0x05b2, "_LDscale"                                                                                                                                                                            },
    { 0x05b3, "_LDtento"                                                                                                                                                                            },
    { 0x05b4, "_LDtest"                                                                                                                                                                             },
    { 0x05b5, "_LDunscale"                                                                                                                                                                          },
    { 0x05b6, "_LEps"                                                                                                                                                                               },
    { 0x05b7, "_LExp"                                                                                                                                                                               },
    { 0x05b8, "_LInf"                                                                                                                                                                               },
    { 0x05b9, "_LNan"                                                                                                                                                                               },
    { 0x05ba, "_LPlsw"                                                                                                                                                                              },
    { 0x05bb, "_LPmsw"                                                                                                                                                                              },
    { 0x05bc, "_LPoly"                                                                                                                                                                              },
    { 0x05bd, "_LRteps"                                                                                                                                                                             },
    { 0x05be, "_LSinh"                                                                                                                                                                              },
    { 0x05bf, "_LSnan"                                                                                                                                                                              },
    { 0x05c0, "_LXbig"                                                                                                                                                                              },
    { 0x05c1, "_LXp_addh"                                                                                                                                                                           },
    { 0x05c2, "_LXp_addx"                                                                                                                                                                           },
    { 0x05c3, "_LXp_getw"                                                                                                                                                                           },
    { 0x05c4, "_LXp_invx"                                                                                                                                                                           },
    { 0x05c5, "_LXp_ldexpx"                                                                                                                                                                         },
    { 0x05c6, "_LXp_movx"                                                                                                                                                                           },
    { 0x05c7, "_LXp_mulh"                                                                                                                                                                           },
    { 0x05c8, "_LXp_mulx"                                                                                                                                                                           },
    { 0x05c9, "_LXp_setn"                                                                                                                                                                           },
    { 0x05ca, "_LXp_setw"                                                                                                                                                                           },
    { 0x05cb, "_LXp_sqrtx"                                                                                                                                                                          },
    { 0x05cc, "_LXp_subx"                                                                                                                                                                           },
    { 0x05cd, "_LZero"                                                                                                                                                                              },
    { 0x05ce, "_Lock_shared_ptr_spin_lock"                                                                                                                                                          },
    { 0x05cf, "_Mbrtowc"                                                                                                                                                                            },
    { 0x05d0, "_Mtx_clear_owner"                                                                                                                                                                    },
    { 0x05d1, "_Mtx_current_owns"                                                                                                                                                                   },
    { 0x05d2, "_Mtx_destroy"                                                                                                                                                                        },
    { 0x05d3, "_Mtx_getconcrtcs"                                                                                                                                                                    },
    { 0x05d4, "_Mtx_init"                                                                                                                                                                           },
    { 0x05d5, "_Mtx_lock"                                                                                                                                                                           },
    { 0x05d6, "_Mtx_reset_owner"                                                                                                                                                                    },
    { 0x05d7, "_Mtx_timedlock"                                                                                                                                                                      },
    { 0x05d8, "_Mtx_trylock"                                                                                                                                                                        },
    { 0x05d9, "_Mtx_unlock"                                                                                                                                                                         },
    { 0x05da, "_Mtxdst"                                                                                                                                                                             },
    { 0x05db, "_Mtxinit"                                                                                                                                                                            },
    { 0x05dc, "_Mtxlock"                                                                                                                                                                            },
    { 0x05dd, "_Mtxunlock"                                                                                                                                                                          },
    { 0x05de, "_Nan"                                                                                                                                                                                },
    { 0x05df, "_Once"                                                                                                                                                                               },
    { 0x05e0, "_Plsw"                                                                                                                                                                               },
    { 0x05e1, "_Pmsw"                                                                                                                                                                               },
    { 0x05e2, "_Poly"                                                                                                                                                                               },
    { 0x05e3, "_Rteps"                                                                                                                                                                              },
    { 0x05e4, "_Sinh"                                                                                                                                                                               },
    { 0x05e5, "_Snan"                                                                                                                                                                               },
    { 0x05e6, "_Stod"                                                                                                                                                                               },
    { 0x05e7, "_Stodx"                                                                                                                                                                              },
    { 0x05e8, "_Stof"                                                                                                                                                                               },
    { 0x05e9, "_Stoflt"                                                                                                                                                                             },
    { 0x05ea, "_Stofx"                                                                                                                                                                              },
    { 0x05eb, "_Stold"                                                                                                                                                                              },
    { 0x05ec, "_Stoldx"                                                                                                                                                                             },
    { 0x05ed, "_Stoll"                                                                                                                                                                              },
    { 0x05ee, "_Stollx"                                                                                                                                                                             },
    { 0x05ef, "_Stolx"                                                                                                                                                                              },
    { 0x05f0, "_Stopfx"                                                                                                                                                                             },
    { 0x05f1, "_Stoul"                                                                                                                                                                              },
    { 0x05f2, "_Stoull"                                                                                                                                                                             },
    { 0x05f3, "_Stoullx"                                                                                                                                                                            },
    { 0x05f4, "_Stoulx"                                                                                                                                                                             },
    { 0x05f5, "_Stoxflt"                                                                                                                                                                            },
    { 0x05f6, "_Strcoll"                                                                                                                                                                            },
    { 0x05f7, "_Strxfrm"                                                                                                                                                                            },
    { 0x05f8, "_Thrd_abort"                                                                                                                                                                         },
    { 0x05f9, "_Thrd_create"                                                                                                                                                                        },
    { 0x05fa, "_Thrd_current"                                                                                                                                                                       },
    { 0x05fb, "_Thrd_detach"                                                                                                                                                                        },
    { 0x05fc, "_Thrd_equal"                                                                                                                                                                         },
    { 0x05fd, "_Thrd_exit"                                                                                                                                                                          },
    { 0x05fe, "_Thrd_join"                                                                                                                                                                          },
    { 0x05ff, "_Thrd_lt"                                                                                                                                                                            },
    { 0x0600, "_Thrd_sleep"                                                                                                                                                                         },
    { 0x0601, "_Thrd_start"                                                                                                                                                                         },
    { 0x0602, "_Thrd_yield"                                                                                                                                                                         },
    { 0x0603, "_Tolower"                                                                                                                                                                            },
    { 0x0604, "_Toupper"                                                                                                                                                                            },
    { 0x0605, "_Towlower"                                                                                                                                                                           },
    { 0x0606, "_Towupper"                                                                                                                                                                           },
    { 0x0607, "_Tss_create"                                                                                                                                                                         },
    { 0x0608, "_Tss_delete"                                                                                                                                                                         },
    { 0x0609, "_Tss_get"                                                                                                                                                                            },
    { 0x060a, "_Tss_set"                                                                                                                                                                            },
    { 0x060b, "_Unlock_shared_ptr_spin_lock"                                                                                                                                                        },
    { 0x060c, "_Wcrtomb"                                                                                                                                                                            },
    { 0x060d, "_Wcscoll"                                                                                                                                                                            },
    { 0x060e, "_Wcsxfrm"                                                                                                                                                                            },
    { 0x060f, "_Xbig"                                                                                                                                                                               },
    { 0x0610, "_Xp_addh"                                                                                                                                                                            },
    { 0x0611, "_Xp_addx"                                                                                                                                                                            },
    { 0x0612, "_Xp_getw"                                                                                                                                                                            },
    { 0x0613, "_Xp_invx"                                                                                                                                                                            },
    { 0x0614, "_Xp_ldexpx"                                                                                                                                                                          },
    { 0x0615, "_Xp_movx"                                                                                                                                                                            },
    { 0x0616, "_Xp_mulh"                                                                                                                                                                            },
    { 0x0617, "_Xp_mulx"                                                                                                                                                                            },
    { 0x0618, "_Xp_setn"                                                                                                                                                                            },
    { 0x0619, "_Xp_setw"                                                                                                                                                                            },
    { 0x061a, "_Xp_sqrtx"                                                                                                                                                                           },
    { 0x061b, "_Xp_subx"                                                                                                                                                                            },
    { 0x061c, "_Xtime_diff_to_millis"                                                                                                                                                               },
    { 0x061d, "_Xtime_diff_to_millis2"                                                                                                                                                              },
    { 0x061e, "_Xtime_get_ticks"                                                                                                                                                                    },
    { 0x061f, "_Zero"                                                                                                                                                                               },
    { 0x0620, "__Wcrtomb_lk"                                                                                                                                                                        },
    { 0x0621, "xtime_get"                                                                                                                                                                           },
};


}
}

#endif

