; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --scrub-attributes
; RUN: opt < %s -passes=argpromotion -S | FileCheck %s

target datalayout = "E-p:64:64:64-a0:0:8-f32:32:32-f64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-v64:64:64-v128:128:128"

%struct.ss = type { i32, i64 }

define internal void @f(ptr byval(%struct.ss) align 4 %b) nounwind  {
; CHECK-LABEL: define {{[^@]+}}@f
; CHECK-SAME: (i32 [[B_0_VAL:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TEMP2:%.*]] = add i32 [[B_0_VAL]], 1
; CHECK-NEXT:    ret void
;
entry:
  %temp1 = load i32, ptr %b, align 4
  %temp2 = add i32 %temp1, 1
  store i32 %temp2, ptr %b, align 4
  ret void
}

define internal void @g(ptr byval(%struct.ss) align 32 %b) nounwind {
; CHECK-LABEL: define {{[^@]+}}@g
; CHECK-SAME: (i32 [[B_0_VAL:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TEMP2:%.*]] = add i32 [[B_0_VAL]], 1
; CHECK-NEXT:    ret void
;
entry:
  %temp1 = load i32, ptr %b, align 4
  %temp2 = add i32 %temp1, 1
  store i32 %temp2, ptr %b, align 4
  ret void
}

; Don't transform if alignment isn't specified; the actual alignment
; is target-specific, and not exposed anywhere.
;
; (If we ever change byval so a missing alignment isn't legal, we can
; just delete this test.)
define internal void @h(ptr byval(%struct.ss) %b) nounwind {
; CHECK-LABEL: define {{[^@]+}}@h
; CHECK-SAME: (ptr byval([[STRUCT_SS:%.*]]) [[B:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TEMP1:%.*]] = load i32, ptr [[B]], align 4
; CHECK-NEXT:    [[TEMP2:%.*]] = add i32 [[TEMP1]], 1
; CHECK-NEXT:    store i32 [[TEMP2]], ptr [[B]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %temp1 = load i32, ptr %b, align 4
  %temp2 = add i32 %temp1, 1
  store i32 %temp2, ptr %b, align 4
  ret void
}

; Transform even if an argument is written to and then is loaded from.
define internal void @k(ptr byval(%struct.ss) align 4 %b) nounwind  {
; CHECK-LABEL: define {{[^@]+}}@k
; CHECK-SAME: (i32 [[B_0_VAL:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TEMP2:%.*]] = add i32 [[B_0_VAL]], 1
; CHECK-NEXT:    ret void
;
entry:
  %temp1 = load i32, ptr %b, align 4
  %temp2 = add i32 %temp1, 1
  store i32 %temp2, ptr %b, align 4
  %temp3 = load i32, ptr %b, align 4
  ret void
}

; Transform even if a store instruction is the single user.
define internal void @l(ptr byval(%struct.ss) align 4 %b) nounwind  {
; CHECK-LABEL: define {{[^@]+}}@l
; CHECK-SAME: (i32 [[B_0_VAL:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret void
;
entry:
  store i32 1, ptr %b, align 4
  ret void
}

; Transform all the arguments creating the required number of 'alloca's and
; then optimize them out.
define internal void @m(ptr byval(%struct.ss) align 4 %b, ptr byval(%struct.ss) align 4 %c) nounwind  {
; CHECK-LABEL: define {{[^@]+}}@m
; CHECK-SAME: (i32 [[B_0_VAL:%.*]], i32 [[C_0_VAL:%.*]], i64 [[C_4_VAL:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TEMP2:%.*]] = add i32 [[B_0_VAL]], 1
; CHECK-NEXT:    [[TEMP6:%.*]] = add i64 [[C_4_VAL]], 1
; CHECK-NEXT:    ret void
;
entry:
  %temp1 = load i32, ptr %b, align 4
  %temp2 = add i32 %temp1, 1
  store i32 %temp2, ptr %b, align 4

  store i32 %temp2, ptr %c, align 4

  %temp4 = getelementptr %struct.ss, ptr %c, i32 0, i32 1
  %temp5 = load i64, ptr %temp4, align 8
  %temp6 = add i64 %temp5, 1
  store i64 %temp6, ptr %temp4, align 8

  ret void
}

define i32 @main() nounwind  {
; CHECK-LABEL: define {{[^@]+}}@main
; CHECK-SAME: () #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[S:%.*]] = alloca [[STRUCT_SS:%.*]], align 32
; CHECK-NEXT:    store i32 1, ptr [[S]], align 8
; CHECK-NEXT:    [[TEMP4:%.*]] = getelementptr [[STRUCT_SS]], ptr [[S]], i32 0, i32 1
; CHECK-NEXT:    store i64 2, ptr [[TEMP4]], align 4
; CHECK-NEXT:    [[S_VAL:%.*]] = load i32, ptr [[S]], align 4
; CHECK-NEXT:    call void @f(i32 [[S_VAL]])
; CHECK-NEXT:    [[S_VAL1:%.*]] = load i32, ptr [[S]], align 4
; CHECK-NEXT:    call void @g(i32 [[S_VAL1]])
; CHECK-NEXT:    call void @h(ptr byval([[STRUCT_SS]]) [[S]])
; CHECK-NEXT:    [[S_VAL2:%.*]] = load i32, ptr [[S]], align 4
; CHECK-NEXT:    call void @k(i32 [[S_VAL2]])
; CHECK-NEXT:    [[S_VAL3:%.*]] = load i32, ptr [[S]], align 4
; CHECK-NEXT:    call void @l(i32 [[S_VAL3]])
; CHECK-NEXT:    [[S_VAL4:%.*]] = load i32, ptr [[S]], align 4
; CHECK-NEXT:    [[S_VAL5:%.*]] = load i32, ptr [[S]], align 4
; CHECK-NEXT:    [[TMP0:%.*]] = getelementptr i8, ptr [[S]], i64 4
; CHECK-NEXT:    [[S_VAL6:%.*]] = load i64, ptr [[TMP0]], align 8
; CHECK-NEXT:    call void @m(i32 [[S_VAL4]], i32 [[S_VAL5]], i64 [[S_VAL6]])
; CHECK-NEXT:    ret i32 0
;
entry:
  %S = alloca %struct.ss, align 32
  store i32 1, ptr %S, align 8
  %temp4 = getelementptr %struct.ss, ptr %S, i32 0, i32 1
  store i64 2, ptr %temp4, align 4
  call void @f(ptr byval(%struct.ss) align 4 %S) nounwind
  call void @g(ptr byval(%struct.ss) align 32 %S) nounwind
  call void @h(ptr byval(%struct.ss) %S) nounwind
  call void @k(ptr byval(%struct.ss) align 4 %S) nounwind
  call void @l(ptr byval(%struct.ss) align 4 %S) nounwind
  call void @m(ptr byval(%struct.ss) align 4 %S, ptr byval(%struct.ss) align 4 %S) nounwind
  ret i32 0
}
