; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

@hello = constant [6 x i8] c"hello\00"
@null = constant [1 x i8] zeroinitializer

declare ptr @strndup(ptr, i64)

define ptr @test1() {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    [[STRDUP:%.*]] = call dereferenceable_or_null(1) ptr @strdup(ptr nonnull @null)
; CHECK-NEXT:    ret ptr [[STRDUP]]
;
  %ret = call ptr @strndup(ptr @null, i64 0)
  ret ptr %ret
}

define ptr @test2() {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    [[RET:%.*]] = call dereferenceable_or_null(5) ptr @strndup(ptr nonnull dereferenceable(6) @hello, i64 4)
; CHECK-NEXT:    ret ptr [[RET]]
;
  %ret = call ptr @strndup(ptr @hello, i64 4)
  ret ptr %ret
}

define ptr @test3() {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    [[STRDUP:%.*]] = call dereferenceable_or_null(6) ptr @strdup(ptr nonnull @hello)
; CHECK-NEXT:    ret ptr [[STRDUP]]
;
  %ret = call ptr @strndup(ptr @hello, i64 5)
  ret ptr %ret
}

define ptr @test4() {
; CHECK-LABEL: @test4(
; CHECK-NEXT:    [[STRDUP:%.*]] = call dereferenceable_or_null(6) ptr @strdup(ptr nonnull @hello)
; CHECK-NEXT:    ret ptr [[STRDUP]]
;
  %ret = call ptr @strndup(ptr @hello, i64 6)
  ret ptr %ret
}

define ptr @test5() {
; CHECK-LABEL: @test5(
; CHECK-NEXT:    [[STRDUP:%.*]] = call dereferenceable_or_null(6) ptr @strdup(ptr nonnull @hello)
; CHECK-NEXT:    ret ptr [[STRDUP]]
;
  %ret = call ptr @strndup(ptr @hello, i64 7)
  ret ptr %ret
}

define ptr @test6(i64 %n) {
; CHECK-LABEL: @test6(
; CHECK-NEXT:    [[RET:%.*]] = call ptr @strndup(ptr nonnull @hello, i64 [[N:%.*]])
; CHECK-NEXT:    ret ptr [[RET]]
;
  %ret = call ptr @strndup(ptr @hello, i64 %n)
  ret ptr %ret
}
