; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=reassociate -S | FileCheck %s

; When there is nothing to do, or not much to do, check that reassociate leaves
; things alone.

declare void @use(i32)

define void @test1(i32 %a, i32 %b) {
; Shouldn't change or move any of the add instructions.  Should commute but
; otherwise not change or move any of the mul instructions.
; CHECK-LABEL: @test1(
; CHECK-NEXT:    [[A0:%.*]] = add nsw i32 [[A:%.*]], 1
; CHECK-NEXT:    [[M0:%.*]] = mul nsw i32 [[A]], 3
; CHECK-NEXT:    [[A1:%.*]] = add nsw i32 [[A0]], [[B:%.*]]
; CHECK-NEXT:    [[M1:%.*]] = mul nsw i32 [[M0]], [[B]]
; CHECK-NEXT:    call void @use(i32 [[A1]])
; CHECK-NEXT:    call void @use(i32 [[M1]])
; CHECK-NEXT:    ret void
;
  %a0 = add nsw i32 %a, 1
  %m0 = mul nsw i32 3, %a
  %a1 = add nsw i32 %a0, %b
  %m1 = mul nsw i32 %b, %m0
  call void @use(i32 %a1)
  call void @use(i32 %m1)
  ret void
}

define void @test2(i32 %a, i32 %b, i32 %c, i32 %d) {
; The initial add doesn't change so should not lose the nsw flag.
; CHECK-LABEL: @test2(
; CHECK-NEXT:    [[A0:%.*]] = add nsw i32 [[B:%.*]], [[A:%.*]]
; CHECK-NEXT:    [[A1:%.*]] = add i32 [[A0]], [[C:%.*]]
; CHECK-NEXT:    [[A2:%.*]] = add i32 [[A1]], [[D:%.*]]
; CHECK-NEXT:    call void @use(i32 [[A2]])
; CHECK-NEXT:    ret void
;
  %a0 = add nsw i32 %b, %a
  %a1 = add nsw i32 %a0, %d
  %a2 = add nsw i32 %a1, %c
  call void @use(i32 %a2)
  ret void
}
