; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=reassociate < %s | FileCheck %s
; rdar://8944681

; Reassociate should clear optional flags like nsw when reassociating.

define i64 @test0(i64 %a, i64 %b, i64 %c) {
;
; CHECK-LABEL: @test0(
; CHECK-NEXT:    [[Y:%.*]] = add i64 [[B:%.*]], [[A:%.*]]
; CHECK-NEXT:    [[Z:%.*]] = add i64 [[Y]], [[C:%.*]]
; CHECK-NEXT:    ret i64 [[Z]]
;
  %y = add nsw i64 %c, %b
  %z = add i64 %y, %a
  ret i64 %z
}

define i64 @test1(i64 %a, i64 %b, i64 %c) {
;
; CHECK-LABEL: @test1(
; CHECK-NEXT:    [[Y:%.*]] = add i64 [[B:%.*]], [[A:%.*]]
; CHECK-NEXT:    [[Z:%.*]] = add i64 [[Y]], [[C:%.*]]
; CHECK-NEXT:    ret i64 [[Z]]
;
  %y = add i64 %c, %b
  %z = add nsw i64 %y, %a
  ret i64 %z
}

; PR9215
define i32 @test2(i32 %x, i32 %y) {
;
; CHECK-LABEL: @test2(
; CHECK-NEXT:    [[S:%.*]] = add nsw i32 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    ret i32 [[S]]
;
  %s = add nsw i32 %x, %y
  ret i32 %s
}
