; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -mtriple=x86_64-unknown -passes=slp-vectorizer -S | FileCheck %s
; RUN: opt < %s -mtriple=x86_64-unknown -mcpu=slm -passes=slp-vectorizer -S | FileCheck %s
; RUN: opt < %s -mtriple=x86_64-unknown -mcpu=corei7-avx -passes=slp-vectorizer -S | FileCheck %s
; RUN: opt < %s -mtriple=x86_64-unknown -mcpu=core-avx2 -passes=slp-vectorizer -S | FileCheck %s
; RUN: opt < %s -mtriple=x86_64-unknown -mcpu=knl -passes=slp-vectorizer -S | FileCheck %s
; RUN: opt < %s -mtriple=x86_64-unknown -mcpu=skx -mattr=-prefer-256-bit -passes=slp-vectorizer -S | FileCheck %s
; RUN: opt < %s -mtriple=x86_64-unknown -mcpu=skx -mattr=+prefer-256-bit -passes=slp-vectorizer -S | FileCheck %s

@a64 = common global [8 x i64] zeroinitializer, align 64
@b64 = common global [8 x i64] zeroinitializer, align 64
@c64 = common global [8 x i64] zeroinitializer, align 64
@a32 = common global [16 x i32] zeroinitializer, align 64
@b32 = common global [16 x i32] zeroinitializer, align 64
@c32 = common global [16 x i32] zeroinitializer, align 64
@a16 = common global [32 x i16] zeroinitializer, align 64
@b16 = common global [32 x i16] zeroinitializer, align 64
@c16 = common global [32 x i16] zeroinitializer, align 64
@a8  = common global [64 x i8] zeroinitializer, align 64
@b8  = common global [64 x i8] zeroinitializer, align 64
@c8  = common global [64 x i8] zeroinitializer, align 64

declare {i64, i1} @llvm.smul.with.overflow.i64(i64, i64)
declare {i32, i1} @llvm.smul.with.overflow.i32(i32, i32)
declare {i16, i1} @llvm.smul.with.overflow.i16(i16, i16)
declare {i8 , i1} @llvm.smul.with.overflow.i8 (i8 , i8 )

define void @mul_v8i64() {
; CHECK-LABEL: @mul_v8i64(
; CHECK-NEXT:    [[A0:%.*]] = load i64, ptr @a64, align 8
; CHECK-NEXT:    [[A1:%.*]] = load i64, ptr getelementptr inbounds ([8 x i64], ptr @a64, i32 0, i64 1), align 8
; CHECK-NEXT:    [[A2:%.*]] = load i64, ptr getelementptr inbounds ([8 x i64], ptr @a64, i32 0, i64 2), align 8
; CHECK-NEXT:    [[A3:%.*]] = load i64, ptr getelementptr inbounds ([8 x i64], ptr @a64, i32 0, i64 3), align 8
; CHECK-NEXT:    [[A4:%.*]] = load i64, ptr getelementptr inbounds ([8 x i64], ptr @a64, i32 0, i64 4), align 8
; CHECK-NEXT:    [[A5:%.*]] = load i64, ptr getelementptr inbounds ([8 x i64], ptr @a64, i32 0, i64 5), align 8
; CHECK-NEXT:    [[A6:%.*]] = load i64, ptr getelementptr inbounds ([8 x i64], ptr @a64, i32 0, i64 6), align 8
; CHECK-NEXT:    [[A7:%.*]] = load i64, ptr getelementptr inbounds ([8 x i64], ptr @a64, i32 0, i64 7), align 8
; CHECK-NEXT:    [[B0:%.*]] = load i64, ptr @b64, align 8
; CHECK-NEXT:    [[B1:%.*]] = load i64, ptr getelementptr inbounds ([8 x i64], ptr @b64, i32 0, i64 1), align 8
; CHECK-NEXT:    [[B2:%.*]] = load i64, ptr getelementptr inbounds ([8 x i64], ptr @b64, i32 0, i64 2), align 8
; CHECK-NEXT:    [[B3:%.*]] = load i64, ptr getelementptr inbounds ([8 x i64], ptr @b64, i32 0, i64 3), align 8
; CHECK-NEXT:    [[B4:%.*]] = load i64, ptr getelementptr inbounds ([8 x i64], ptr @b64, i32 0, i64 4), align 8
; CHECK-NEXT:    [[B5:%.*]] = load i64, ptr getelementptr inbounds ([8 x i64], ptr @b64, i32 0, i64 5), align 8
; CHECK-NEXT:    [[B6:%.*]] = load i64, ptr getelementptr inbounds ([8 x i64], ptr @b64, i32 0, i64 6), align 8
; CHECK-NEXT:    [[B7:%.*]] = load i64, ptr getelementptr inbounds ([8 x i64], ptr @b64, i32 0, i64 7), align 8
; CHECK-NEXT:    [[C0:%.*]] = call { i64, i1 } @llvm.smul.with.overflow.i64(i64 [[A0]], i64 [[B0]])
; CHECK-NEXT:    [[C1:%.*]] = call { i64, i1 } @llvm.smul.with.overflow.i64(i64 [[A1]], i64 [[B1]])
; CHECK-NEXT:    [[C2:%.*]] = call { i64, i1 } @llvm.smul.with.overflow.i64(i64 [[A2]], i64 [[B2]])
; CHECK-NEXT:    [[C3:%.*]] = call { i64, i1 } @llvm.smul.with.overflow.i64(i64 [[A3]], i64 [[B3]])
; CHECK-NEXT:    [[C4:%.*]] = call { i64, i1 } @llvm.smul.with.overflow.i64(i64 [[A4]], i64 [[B4]])
; CHECK-NEXT:    [[C5:%.*]] = call { i64, i1 } @llvm.smul.with.overflow.i64(i64 [[A5]], i64 [[B5]])
; CHECK-NEXT:    [[C6:%.*]] = call { i64, i1 } @llvm.smul.with.overflow.i64(i64 [[A6]], i64 [[B6]])
; CHECK-NEXT:    [[C7:%.*]] = call { i64, i1 } @llvm.smul.with.overflow.i64(i64 [[A7]], i64 [[B7]])
; CHECK-NEXT:    [[R0:%.*]] = extractvalue { i64, i1 } [[C0]], 0
; CHECK-NEXT:    [[R1:%.*]] = extractvalue { i64, i1 } [[C1]], 0
; CHECK-NEXT:    [[R2:%.*]] = extractvalue { i64, i1 } [[C2]], 0
; CHECK-NEXT:    [[R3:%.*]] = extractvalue { i64, i1 } [[C3]], 0
; CHECK-NEXT:    [[R4:%.*]] = extractvalue { i64, i1 } [[C4]], 0
; CHECK-NEXT:    [[R5:%.*]] = extractvalue { i64, i1 } [[C5]], 0
; CHECK-NEXT:    [[R6:%.*]] = extractvalue { i64, i1 } [[C6]], 0
; CHECK-NEXT:    [[R7:%.*]] = extractvalue { i64, i1 } [[C7]], 0
; CHECK-NEXT:    store i64 [[R0]], ptr @c64, align 8
; CHECK-NEXT:    store i64 [[R1]], ptr getelementptr inbounds ([8 x i64], ptr @c64, i32 0, i64 1), align 8
; CHECK-NEXT:    store i64 [[R2]], ptr getelementptr inbounds ([8 x i64], ptr @c64, i32 0, i64 2), align 8
; CHECK-NEXT:    store i64 [[R3]], ptr getelementptr inbounds ([8 x i64], ptr @c64, i32 0, i64 3), align 8
; CHECK-NEXT:    store i64 [[R4]], ptr getelementptr inbounds ([8 x i64], ptr @c64, i32 0, i64 4), align 8
; CHECK-NEXT:    store i64 [[R5]], ptr getelementptr inbounds ([8 x i64], ptr @c64, i32 0, i64 5), align 8
; CHECK-NEXT:    store i64 [[R6]], ptr getelementptr inbounds ([8 x i64], ptr @c64, i32 0, i64 6), align 8
; CHECK-NEXT:    store i64 [[R7]], ptr getelementptr inbounds ([8 x i64], ptr @c64, i32 0, i64 7), align 8
; CHECK-NEXT:    ret void
;
  %a0 = load i64, ptr @a64, align 8
  %a1 = load i64, ptr getelementptr inbounds ([8 x i64], ptr @a64, i32 0, i64 1), align 8
  %a2 = load i64, ptr getelementptr inbounds ([8 x i64], ptr @a64, i32 0, i64 2), align 8
  %a3 = load i64, ptr getelementptr inbounds ([8 x i64], ptr @a64, i32 0, i64 3), align 8
  %a4 = load i64, ptr getelementptr inbounds ([8 x i64], ptr @a64, i32 0, i64 4), align 8
  %a5 = load i64, ptr getelementptr inbounds ([8 x i64], ptr @a64, i32 0, i64 5), align 8
  %a6 = load i64, ptr getelementptr inbounds ([8 x i64], ptr @a64, i32 0, i64 6), align 8
  %a7 = load i64, ptr getelementptr inbounds ([8 x i64], ptr @a64, i32 0, i64 7), align 8
  %b0 = load i64, ptr @b64, align 8
  %b1 = load i64, ptr getelementptr inbounds ([8 x i64], ptr @b64, i32 0, i64 1), align 8
  %b2 = load i64, ptr getelementptr inbounds ([8 x i64], ptr @b64, i32 0, i64 2), align 8
  %b3 = load i64, ptr getelementptr inbounds ([8 x i64], ptr @b64, i32 0, i64 3), align 8
  %b4 = load i64, ptr getelementptr inbounds ([8 x i64], ptr @b64, i32 0, i64 4), align 8
  %b5 = load i64, ptr getelementptr inbounds ([8 x i64], ptr @b64, i32 0, i64 5), align 8
  %b6 = load i64, ptr getelementptr inbounds ([8 x i64], ptr @b64, i32 0, i64 6), align 8
  %b7 = load i64, ptr getelementptr inbounds ([8 x i64], ptr @b64, i32 0, i64 7), align 8
  %c0 = call {i64, i1} @llvm.smul.with.overflow.i64(i64 %a0, i64 %b0)
  %c1 = call {i64, i1} @llvm.smul.with.overflow.i64(i64 %a1, i64 %b1)
  %c2 = call {i64, i1} @llvm.smul.with.overflow.i64(i64 %a2, i64 %b2)
  %c3 = call {i64, i1} @llvm.smul.with.overflow.i64(i64 %a3, i64 %b3)
  %c4 = call {i64, i1} @llvm.smul.with.overflow.i64(i64 %a4, i64 %b4)
  %c5 = call {i64, i1} @llvm.smul.with.overflow.i64(i64 %a5, i64 %b5)
  %c6 = call {i64, i1} @llvm.smul.with.overflow.i64(i64 %a6, i64 %b6)
  %c7 = call {i64, i1} @llvm.smul.with.overflow.i64(i64 %a7, i64 %b7)
  %r0 = extractvalue {i64, i1} %c0, 0
  %r1 = extractvalue {i64, i1} %c1, 0
  %r2 = extractvalue {i64, i1} %c2, 0
  %r3 = extractvalue {i64, i1} %c3, 0
  %r4 = extractvalue {i64, i1} %c4, 0
  %r5 = extractvalue {i64, i1} %c5, 0
  %r6 = extractvalue {i64, i1} %c6, 0
  %r7 = extractvalue {i64, i1} %c7, 0
  store i64 %r0, ptr @c64, align 8
  store i64 %r1, ptr getelementptr inbounds ([8 x i64], ptr @c64, i32 0, i64 1), align 8
  store i64 %r2, ptr getelementptr inbounds ([8 x i64], ptr @c64, i32 0, i64 2), align 8
  store i64 %r3, ptr getelementptr inbounds ([8 x i64], ptr @c64, i32 0, i64 3), align 8
  store i64 %r4, ptr getelementptr inbounds ([8 x i64], ptr @c64, i32 0, i64 4), align 8
  store i64 %r5, ptr getelementptr inbounds ([8 x i64], ptr @c64, i32 0, i64 5), align 8
  store i64 %r6, ptr getelementptr inbounds ([8 x i64], ptr @c64, i32 0, i64 6), align 8
  store i64 %r7, ptr getelementptr inbounds ([8 x i64], ptr @c64, i32 0, i64 7), align 8
  ret void
}

define void @mul_v16i32() {
; CHECK-LABEL: @mul_v16i32(
; CHECK-NEXT:    [[A0:%.*]] = load i32, ptr @a32, align 4
; CHECK-NEXT:    [[A1:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 1), align 4
; CHECK-NEXT:    [[A2:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 2), align 4
; CHECK-NEXT:    [[A3:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 3), align 4
; CHECK-NEXT:    [[A4:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 4), align 4
; CHECK-NEXT:    [[A5:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 5), align 4
; CHECK-NEXT:    [[A6:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 6), align 4
; CHECK-NEXT:    [[A7:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 7), align 4
; CHECK-NEXT:    [[A8:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 8), align 4
; CHECK-NEXT:    [[A9:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 9), align 4
; CHECK-NEXT:    [[A10:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 10), align 4
; CHECK-NEXT:    [[A11:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 11), align 4
; CHECK-NEXT:    [[A12:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 12), align 4
; CHECK-NEXT:    [[A13:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 13), align 4
; CHECK-NEXT:    [[A14:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 14), align 4
; CHECK-NEXT:    [[A15:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 15), align 4
; CHECK-NEXT:    [[B0:%.*]] = load i32, ptr @b32, align 4
; CHECK-NEXT:    [[B1:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 1), align 4
; CHECK-NEXT:    [[B2:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 2), align 4
; CHECK-NEXT:    [[B3:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 3), align 4
; CHECK-NEXT:    [[B4:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 4), align 4
; CHECK-NEXT:    [[B5:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 5), align 4
; CHECK-NEXT:    [[B6:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 6), align 4
; CHECK-NEXT:    [[B7:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 7), align 4
; CHECK-NEXT:    [[B8:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 8), align 4
; CHECK-NEXT:    [[B9:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 9), align 4
; CHECK-NEXT:    [[B10:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 10), align 4
; CHECK-NEXT:    [[B11:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 11), align 4
; CHECK-NEXT:    [[B12:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 12), align 4
; CHECK-NEXT:    [[B13:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 13), align 4
; CHECK-NEXT:    [[B14:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 14), align 4
; CHECK-NEXT:    [[B15:%.*]] = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 15), align 4
; CHECK-NEXT:    [[C0:%.*]] = call { i32, i1 } @llvm.smul.with.overflow.i32(i32 [[A0]], i32 [[B0]])
; CHECK-NEXT:    [[C1:%.*]] = call { i32, i1 } @llvm.smul.with.overflow.i32(i32 [[A1]], i32 [[B1]])
; CHECK-NEXT:    [[C2:%.*]] = call { i32, i1 } @llvm.smul.with.overflow.i32(i32 [[A2]], i32 [[B2]])
; CHECK-NEXT:    [[C3:%.*]] = call { i32, i1 } @llvm.smul.with.overflow.i32(i32 [[A3]], i32 [[B3]])
; CHECK-NEXT:    [[C4:%.*]] = call { i32, i1 } @llvm.smul.with.overflow.i32(i32 [[A4]], i32 [[B4]])
; CHECK-NEXT:    [[C5:%.*]] = call { i32, i1 } @llvm.smul.with.overflow.i32(i32 [[A5]], i32 [[B5]])
; CHECK-NEXT:    [[C6:%.*]] = call { i32, i1 } @llvm.smul.with.overflow.i32(i32 [[A6]], i32 [[B6]])
; CHECK-NEXT:    [[C7:%.*]] = call { i32, i1 } @llvm.smul.with.overflow.i32(i32 [[A7]], i32 [[B7]])
; CHECK-NEXT:    [[C8:%.*]] = call { i32, i1 } @llvm.smul.with.overflow.i32(i32 [[A8]], i32 [[B8]])
; CHECK-NEXT:    [[C9:%.*]] = call { i32, i1 } @llvm.smul.with.overflow.i32(i32 [[A9]], i32 [[B9]])
; CHECK-NEXT:    [[C10:%.*]] = call { i32, i1 } @llvm.smul.with.overflow.i32(i32 [[A10]], i32 [[B10]])
; CHECK-NEXT:    [[C11:%.*]] = call { i32, i1 } @llvm.smul.with.overflow.i32(i32 [[A11]], i32 [[B11]])
; CHECK-NEXT:    [[C12:%.*]] = call { i32, i1 } @llvm.smul.with.overflow.i32(i32 [[A12]], i32 [[B12]])
; CHECK-NEXT:    [[C13:%.*]] = call { i32, i1 } @llvm.smul.with.overflow.i32(i32 [[A13]], i32 [[B13]])
; CHECK-NEXT:    [[C14:%.*]] = call { i32, i1 } @llvm.smul.with.overflow.i32(i32 [[A14]], i32 [[B14]])
; CHECK-NEXT:    [[C15:%.*]] = call { i32, i1 } @llvm.smul.with.overflow.i32(i32 [[A15]], i32 [[B15]])
; CHECK-NEXT:    [[R0:%.*]] = extractvalue { i32, i1 } [[C0]], 0
; CHECK-NEXT:    [[R1:%.*]] = extractvalue { i32, i1 } [[C1]], 0
; CHECK-NEXT:    [[R2:%.*]] = extractvalue { i32, i1 } [[C2]], 0
; CHECK-NEXT:    [[R3:%.*]] = extractvalue { i32, i1 } [[C3]], 0
; CHECK-NEXT:    [[R4:%.*]] = extractvalue { i32, i1 } [[C4]], 0
; CHECK-NEXT:    [[R5:%.*]] = extractvalue { i32, i1 } [[C5]], 0
; CHECK-NEXT:    [[R6:%.*]] = extractvalue { i32, i1 } [[C6]], 0
; CHECK-NEXT:    [[R7:%.*]] = extractvalue { i32, i1 } [[C7]], 0
; CHECK-NEXT:    [[R8:%.*]] = extractvalue { i32, i1 } [[C8]], 0
; CHECK-NEXT:    [[R9:%.*]] = extractvalue { i32, i1 } [[C9]], 0
; CHECK-NEXT:    [[R10:%.*]] = extractvalue { i32, i1 } [[C10]], 0
; CHECK-NEXT:    [[R11:%.*]] = extractvalue { i32, i1 } [[C11]], 0
; CHECK-NEXT:    [[R12:%.*]] = extractvalue { i32, i1 } [[C12]], 0
; CHECK-NEXT:    [[R13:%.*]] = extractvalue { i32, i1 } [[C13]], 0
; CHECK-NEXT:    [[R14:%.*]] = extractvalue { i32, i1 } [[C14]], 0
; CHECK-NEXT:    [[R15:%.*]] = extractvalue { i32, i1 } [[C15]], 0
; CHECK-NEXT:    store i32 [[R0]], ptr @c32, align 4
; CHECK-NEXT:    store i32 [[R1]], ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 1), align 4
; CHECK-NEXT:    store i32 [[R2]], ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 2), align 4
; CHECK-NEXT:    store i32 [[R3]], ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 3), align 4
; CHECK-NEXT:    store i32 [[R4]], ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 4), align 4
; CHECK-NEXT:    store i32 [[R5]], ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 5), align 4
; CHECK-NEXT:    store i32 [[R6]], ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 6), align 4
; CHECK-NEXT:    store i32 [[R7]], ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 7), align 4
; CHECK-NEXT:    store i32 [[R8]], ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 8), align 4
; CHECK-NEXT:    store i32 [[R9]], ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 9), align 4
; CHECK-NEXT:    store i32 [[R10]], ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 10), align 4
; CHECK-NEXT:    store i32 [[R11]], ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 11), align 4
; CHECK-NEXT:    store i32 [[R12]], ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 12), align 4
; CHECK-NEXT:    store i32 [[R13]], ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 13), align 4
; CHECK-NEXT:    store i32 [[R14]], ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 14), align 4
; CHECK-NEXT:    store i32 [[R15]], ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 15), align 4
; CHECK-NEXT:    ret void
;
  %a0  = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 0 ), align 4
  %a1  = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 1 ), align 4
  %a2  = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 2 ), align 4
  %a3  = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 3 ), align 4
  %a4  = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 4 ), align 4
  %a5  = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 5 ), align 4
  %a6  = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 6 ), align 4
  %a7  = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 7 ), align 4
  %a8  = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 8 ), align 4
  %a9  = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 9 ), align 4
  %a10 = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 10), align 4
  %a11 = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 11), align 4
  %a12 = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 12), align 4
  %a13 = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 13), align 4
  %a14 = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 14), align 4
  %a15 = load i32, ptr getelementptr inbounds ([16 x i32], ptr @a32, i32 0, i64 15), align 4
  %b0  = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 0 ), align 4
  %b1  = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 1 ), align 4
  %b2  = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 2 ), align 4
  %b3  = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 3 ), align 4
  %b4  = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 4 ), align 4
  %b5  = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 5 ), align 4
  %b6  = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 6 ), align 4
  %b7  = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 7 ), align 4
  %b8  = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 8 ), align 4
  %b9  = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 9 ), align 4
  %b10 = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 10), align 4
  %b11 = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 11), align 4
  %b12 = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 12), align 4
  %b13 = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 13), align 4
  %b14 = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 14), align 4
  %b15 = load i32, ptr getelementptr inbounds ([16 x i32], ptr @b32, i32 0, i64 15), align 4
  %c0  = call {i32, i1} @llvm.smul.with.overflow.i32(i32 %a0 , i32 %b0 )
  %c1  = call {i32, i1} @llvm.smul.with.overflow.i32(i32 %a1 , i32 %b1 )
  %c2  = call {i32, i1} @llvm.smul.with.overflow.i32(i32 %a2 , i32 %b2 )
  %c3  = call {i32, i1} @llvm.smul.with.overflow.i32(i32 %a3 , i32 %b3 )
  %c4  = call {i32, i1} @llvm.smul.with.overflow.i32(i32 %a4 , i32 %b4 )
  %c5  = call {i32, i1} @llvm.smul.with.overflow.i32(i32 %a5 , i32 %b5 )
  %c6  = call {i32, i1} @llvm.smul.with.overflow.i32(i32 %a6 , i32 %b6 )
  %c7  = call {i32, i1} @llvm.smul.with.overflow.i32(i32 %a7 , i32 %b7 )
  %c8  = call {i32, i1} @llvm.smul.with.overflow.i32(i32 %a8 , i32 %b8 )
  %c9  = call {i32, i1} @llvm.smul.with.overflow.i32(i32 %a9 , i32 %b9 )
  %c10 = call {i32, i1} @llvm.smul.with.overflow.i32(i32 %a10, i32 %b10)
  %c11 = call {i32, i1} @llvm.smul.with.overflow.i32(i32 %a11, i32 %b11)
  %c12 = call {i32, i1} @llvm.smul.with.overflow.i32(i32 %a12, i32 %b12)
  %c13 = call {i32, i1} @llvm.smul.with.overflow.i32(i32 %a13, i32 %b13)
  %c14 = call {i32, i1} @llvm.smul.with.overflow.i32(i32 %a14, i32 %b14)
  %c15 = call {i32, i1} @llvm.smul.with.overflow.i32(i32 %a15, i32 %b15)
  %r0  = extractvalue {i32, i1} %c0 , 0
  %r1  = extractvalue {i32, i1} %c1 , 0
  %r2  = extractvalue {i32, i1} %c2 , 0
  %r3  = extractvalue {i32, i1} %c3 , 0
  %r4  = extractvalue {i32, i1} %c4 , 0
  %r5  = extractvalue {i32, i1} %c5 , 0
  %r6  = extractvalue {i32, i1} %c6 , 0
  %r7  = extractvalue {i32, i1} %c7 , 0
  %r8  = extractvalue {i32, i1} %c8 , 0
  %r9  = extractvalue {i32, i1} %c9 , 0
  %r10 = extractvalue {i32, i1} %c10, 0
  %r11 = extractvalue {i32, i1} %c11, 0
  %r12 = extractvalue {i32, i1} %c12, 0
  %r13 = extractvalue {i32, i1} %c13, 0
  %r14 = extractvalue {i32, i1} %c14, 0
  %r15 = extractvalue {i32, i1} %c15, 0
  store i32 %r0 , ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 0 ), align 4
  store i32 %r1 , ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 1 ), align 4
  store i32 %r2 , ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 2 ), align 4
  store i32 %r3 , ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 3 ), align 4
  store i32 %r4 , ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 4 ), align 4
  store i32 %r5 , ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 5 ), align 4
  store i32 %r6 , ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 6 ), align 4
  store i32 %r7 , ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 7 ), align 4
  store i32 %r8 , ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 8 ), align 4
  store i32 %r9 , ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 9 ), align 4
  store i32 %r10, ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 10), align 4
  store i32 %r11, ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 11), align 4
  store i32 %r12, ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 12), align 4
  store i32 %r13, ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 13), align 4
  store i32 %r14, ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 14), align 4
  store i32 %r15, ptr getelementptr inbounds ([16 x i32], ptr @c32, i32 0, i64 15), align 4
  ret void
}

define void @mul_v32i16() {
; CHECK-LABEL: @mul_v32i16(
; CHECK-NEXT:    [[A0:%.*]] = load i16, ptr @a16, align 2
; CHECK-NEXT:    [[A1:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 1), align 2
; CHECK-NEXT:    [[A2:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 2), align 2
; CHECK-NEXT:    [[A3:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 3), align 2
; CHECK-NEXT:    [[A4:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 4), align 2
; CHECK-NEXT:    [[A5:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 5), align 2
; CHECK-NEXT:    [[A6:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 6), align 2
; CHECK-NEXT:    [[A7:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 7), align 2
; CHECK-NEXT:    [[A8:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 8), align 2
; CHECK-NEXT:    [[A9:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 9), align 2
; CHECK-NEXT:    [[A10:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 10), align 2
; CHECK-NEXT:    [[A11:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 11), align 2
; CHECK-NEXT:    [[A12:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 12), align 2
; CHECK-NEXT:    [[A13:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 13), align 2
; CHECK-NEXT:    [[A14:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 14), align 2
; CHECK-NEXT:    [[A15:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 15), align 2
; CHECK-NEXT:    [[A16:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 16), align 2
; CHECK-NEXT:    [[A17:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 17), align 2
; CHECK-NEXT:    [[A18:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 18), align 2
; CHECK-NEXT:    [[A19:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 19), align 2
; CHECK-NEXT:    [[A20:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 20), align 2
; CHECK-NEXT:    [[A21:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 21), align 2
; CHECK-NEXT:    [[A22:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 22), align 2
; CHECK-NEXT:    [[A23:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 23), align 2
; CHECK-NEXT:    [[A24:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 24), align 2
; CHECK-NEXT:    [[A25:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 25), align 2
; CHECK-NEXT:    [[A26:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 26), align 2
; CHECK-NEXT:    [[A27:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 27), align 2
; CHECK-NEXT:    [[A28:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 28), align 2
; CHECK-NEXT:    [[A29:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 29), align 2
; CHECK-NEXT:    [[A30:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 30), align 2
; CHECK-NEXT:    [[A31:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 31), align 2
; CHECK-NEXT:    [[B0:%.*]] = load i16, ptr @b16, align 2
; CHECK-NEXT:    [[B1:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 1), align 2
; CHECK-NEXT:    [[B2:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 2), align 2
; CHECK-NEXT:    [[B3:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 3), align 2
; CHECK-NEXT:    [[B4:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 4), align 2
; CHECK-NEXT:    [[B5:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 5), align 2
; CHECK-NEXT:    [[B6:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 6), align 2
; CHECK-NEXT:    [[B7:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 7), align 2
; CHECK-NEXT:    [[B8:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 8), align 2
; CHECK-NEXT:    [[B9:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 9), align 2
; CHECK-NEXT:    [[B10:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 10), align 2
; CHECK-NEXT:    [[B11:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 11), align 2
; CHECK-NEXT:    [[B12:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 12), align 2
; CHECK-NEXT:    [[B13:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 13), align 2
; CHECK-NEXT:    [[B14:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 14), align 2
; CHECK-NEXT:    [[B15:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 15), align 2
; CHECK-NEXT:    [[B16:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 16), align 2
; CHECK-NEXT:    [[B17:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 17), align 2
; CHECK-NEXT:    [[B18:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 18), align 2
; CHECK-NEXT:    [[B19:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 19), align 2
; CHECK-NEXT:    [[B20:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 20), align 2
; CHECK-NEXT:    [[B21:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 21), align 2
; CHECK-NEXT:    [[B22:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 22), align 2
; CHECK-NEXT:    [[B23:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 23), align 2
; CHECK-NEXT:    [[B24:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 24), align 2
; CHECK-NEXT:    [[B25:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 25), align 2
; CHECK-NEXT:    [[B26:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 26), align 2
; CHECK-NEXT:    [[B27:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 27), align 2
; CHECK-NEXT:    [[B28:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 28), align 2
; CHECK-NEXT:    [[B29:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 29), align 2
; CHECK-NEXT:    [[B30:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 30), align 2
; CHECK-NEXT:    [[B31:%.*]] = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 31), align 2
; CHECK-NEXT:    [[C0:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A0]], i16 [[B0]])
; CHECK-NEXT:    [[C1:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A1]], i16 [[B1]])
; CHECK-NEXT:    [[C2:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A2]], i16 [[B2]])
; CHECK-NEXT:    [[C3:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A3]], i16 [[B3]])
; CHECK-NEXT:    [[C4:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A4]], i16 [[B4]])
; CHECK-NEXT:    [[C5:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A5]], i16 [[B5]])
; CHECK-NEXT:    [[C6:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A6]], i16 [[B6]])
; CHECK-NEXT:    [[C7:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A7]], i16 [[B7]])
; CHECK-NEXT:    [[C8:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A8]], i16 [[B8]])
; CHECK-NEXT:    [[C9:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A9]], i16 [[B9]])
; CHECK-NEXT:    [[C10:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A10]], i16 [[B10]])
; CHECK-NEXT:    [[C11:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A11]], i16 [[B11]])
; CHECK-NEXT:    [[C12:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A12]], i16 [[B12]])
; CHECK-NEXT:    [[C13:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A13]], i16 [[B13]])
; CHECK-NEXT:    [[C14:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A14]], i16 [[B14]])
; CHECK-NEXT:    [[C15:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A15]], i16 [[B15]])
; CHECK-NEXT:    [[C16:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A16]], i16 [[B16]])
; CHECK-NEXT:    [[C17:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A17]], i16 [[B17]])
; CHECK-NEXT:    [[C18:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A18]], i16 [[B18]])
; CHECK-NEXT:    [[C19:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A19]], i16 [[B19]])
; CHECK-NEXT:    [[C20:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A20]], i16 [[B20]])
; CHECK-NEXT:    [[C21:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A21]], i16 [[B21]])
; CHECK-NEXT:    [[C22:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A22]], i16 [[B22]])
; CHECK-NEXT:    [[C23:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A23]], i16 [[B23]])
; CHECK-NEXT:    [[C24:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A24]], i16 [[B24]])
; CHECK-NEXT:    [[C25:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A25]], i16 [[B25]])
; CHECK-NEXT:    [[C26:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A26]], i16 [[B26]])
; CHECK-NEXT:    [[C27:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A27]], i16 [[B27]])
; CHECK-NEXT:    [[C28:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A28]], i16 [[B28]])
; CHECK-NEXT:    [[C29:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A29]], i16 [[B29]])
; CHECK-NEXT:    [[C30:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A30]], i16 [[B30]])
; CHECK-NEXT:    [[C31:%.*]] = call { i16, i1 } @llvm.smul.with.overflow.i16(i16 [[A31]], i16 [[B31]])
; CHECK-NEXT:    [[R0:%.*]] = extractvalue { i16, i1 } [[C0]], 0
; CHECK-NEXT:    [[R1:%.*]] = extractvalue { i16, i1 } [[C1]], 0
; CHECK-NEXT:    [[R2:%.*]] = extractvalue { i16, i1 } [[C2]], 0
; CHECK-NEXT:    [[R3:%.*]] = extractvalue { i16, i1 } [[C3]], 0
; CHECK-NEXT:    [[R4:%.*]] = extractvalue { i16, i1 } [[C4]], 0
; CHECK-NEXT:    [[R5:%.*]] = extractvalue { i16, i1 } [[C5]], 0
; CHECK-NEXT:    [[R6:%.*]] = extractvalue { i16, i1 } [[C6]], 0
; CHECK-NEXT:    [[R7:%.*]] = extractvalue { i16, i1 } [[C7]], 0
; CHECK-NEXT:    [[R8:%.*]] = extractvalue { i16, i1 } [[C8]], 0
; CHECK-NEXT:    [[R9:%.*]] = extractvalue { i16, i1 } [[C9]], 0
; CHECK-NEXT:    [[R10:%.*]] = extractvalue { i16, i1 } [[C10]], 0
; CHECK-NEXT:    [[R11:%.*]] = extractvalue { i16, i1 } [[C11]], 0
; CHECK-NEXT:    [[R12:%.*]] = extractvalue { i16, i1 } [[C12]], 0
; CHECK-NEXT:    [[R13:%.*]] = extractvalue { i16, i1 } [[C13]], 0
; CHECK-NEXT:    [[R14:%.*]] = extractvalue { i16, i1 } [[C14]], 0
; CHECK-NEXT:    [[R15:%.*]] = extractvalue { i16, i1 } [[C15]], 0
; CHECK-NEXT:    [[R16:%.*]] = extractvalue { i16, i1 } [[C16]], 0
; CHECK-NEXT:    [[R17:%.*]] = extractvalue { i16, i1 } [[C17]], 0
; CHECK-NEXT:    [[R18:%.*]] = extractvalue { i16, i1 } [[C18]], 0
; CHECK-NEXT:    [[R19:%.*]] = extractvalue { i16, i1 } [[C19]], 0
; CHECK-NEXT:    [[R20:%.*]] = extractvalue { i16, i1 } [[C20]], 0
; CHECK-NEXT:    [[R21:%.*]] = extractvalue { i16, i1 } [[C21]], 0
; CHECK-NEXT:    [[R22:%.*]] = extractvalue { i16, i1 } [[C22]], 0
; CHECK-NEXT:    [[R23:%.*]] = extractvalue { i16, i1 } [[C23]], 0
; CHECK-NEXT:    [[R24:%.*]] = extractvalue { i16, i1 } [[C24]], 0
; CHECK-NEXT:    [[R25:%.*]] = extractvalue { i16, i1 } [[C25]], 0
; CHECK-NEXT:    [[R26:%.*]] = extractvalue { i16, i1 } [[C26]], 0
; CHECK-NEXT:    [[R27:%.*]] = extractvalue { i16, i1 } [[C27]], 0
; CHECK-NEXT:    [[R28:%.*]] = extractvalue { i16, i1 } [[C28]], 0
; CHECK-NEXT:    [[R29:%.*]] = extractvalue { i16, i1 } [[C29]], 0
; CHECK-NEXT:    [[R30:%.*]] = extractvalue { i16, i1 } [[C30]], 0
; CHECK-NEXT:    [[R31:%.*]] = extractvalue { i16, i1 } [[C31]], 0
; CHECK-NEXT:    store i16 [[R0]], ptr @c16, align 2
; CHECK-NEXT:    store i16 [[R1]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 1), align 2
; CHECK-NEXT:    store i16 [[R2]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 2), align 2
; CHECK-NEXT:    store i16 [[R3]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 3), align 2
; CHECK-NEXT:    store i16 [[R4]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 4), align 2
; CHECK-NEXT:    store i16 [[R5]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 5), align 2
; CHECK-NEXT:    store i16 [[R6]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 6), align 2
; CHECK-NEXT:    store i16 [[R7]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 7), align 2
; CHECK-NEXT:    store i16 [[R8]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 8), align 2
; CHECK-NEXT:    store i16 [[R9]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 9), align 2
; CHECK-NEXT:    store i16 [[R10]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 10), align 2
; CHECK-NEXT:    store i16 [[R11]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 11), align 2
; CHECK-NEXT:    store i16 [[R12]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 12), align 2
; CHECK-NEXT:    store i16 [[R13]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 13), align 2
; CHECK-NEXT:    store i16 [[R14]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 14), align 2
; CHECK-NEXT:    store i16 [[R15]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 15), align 2
; CHECK-NEXT:    store i16 [[R16]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 16), align 2
; CHECK-NEXT:    store i16 [[R17]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 17), align 2
; CHECK-NEXT:    store i16 [[R18]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 18), align 2
; CHECK-NEXT:    store i16 [[R19]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 19), align 2
; CHECK-NEXT:    store i16 [[R20]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 20), align 2
; CHECK-NEXT:    store i16 [[R21]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 21), align 2
; CHECK-NEXT:    store i16 [[R22]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 22), align 2
; CHECK-NEXT:    store i16 [[R23]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 23), align 2
; CHECK-NEXT:    store i16 [[R24]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 24), align 2
; CHECK-NEXT:    store i16 [[R25]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 25), align 2
; CHECK-NEXT:    store i16 [[R26]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 26), align 2
; CHECK-NEXT:    store i16 [[R27]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 27), align 2
; CHECK-NEXT:    store i16 [[R28]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 28), align 2
; CHECK-NEXT:    store i16 [[R29]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 29), align 2
; CHECK-NEXT:    store i16 [[R30]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 30), align 2
; CHECK-NEXT:    store i16 [[R31]], ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 31), align 2
; CHECK-NEXT:    ret void
;
  %a0  = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 0 ), align 2
  %a1  = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 1 ), align 2
  %a2  = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 2 ), align 2
  %a3  = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 3 ), align 2
  %a4  = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 4 ), align 2
  %a5  = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 5 ), align 2
  %a6  = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 6 ), align 2
  %a7  = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 7 ), align 2
  %a8  = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 8 ), align 2
  %a9  = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 9 ), align 2
  %a10 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 10), align 2
  %a11 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 11), align 2
  %a12 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 12), align 2
  %a13 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 13), align 2
  %a14 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 14), align 2
  %a15 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 15), align 2
  %a16 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 16), align 2
  %a17 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 17), align 2
  %a18 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 18), align 2
  %a19 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 19), align 2
  %a20 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 20), align 2
  %a21 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 21), align 2
  %a22 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 22), align 2
  %a23 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 23), align 2
  %a24 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 24), align 2
  %a25 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 25), align 2
  %a26 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 26), align 2
  %a27 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 27), align 2
  %a28 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 28), align 2
  %a29 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 29), align 2
  %a30 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 30), align 2
  %a31 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @a16, i32 0, i64 31), align 2
  %b0  = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 0 ), align 2
  %b1  = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 1 ), align 2
  %b2  = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 2 ), align 2
  %b3  = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 3 ), align 2
  %b4  = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 4 ), align 2
  %b5  = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 5 ), align 2
  %b6  = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 6 ), align 2
  %b7  = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 7 ), align 2
  %b8  = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 8 ), align 2
  %b9  = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 9 ), align 2
  %b10 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 10), align 2
  %b11 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 11), align 2
  %b12 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 12), align 2
  %b13 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 13), align 2
  %b14 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 14), align 2
  %b15 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 15), align 2
  %b16 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 16), align 2
  %b17 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 17), align 2
  %b18 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 18), align 2
  %b19 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 19), align 2
  %b20 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 20), align 2
  %b21 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 21), align 2
  %b22 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 22), align 2
  %b23 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 23), align 2
  %b24 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 24), align 2
  %b25 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 25), align 2
  %b26 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 26), align 2
  %b27 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 27), align 2
  %b28 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 28), align 2
  %b29 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 29), align 2
  %b30 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 30), align 2
  %b31 = load i16, ptr getelementptr inbounds ([32 x i16], ptr @b16, i32 0, i64 31), align 2
  %c0  = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a0 , i16 %b0 )
  %c1  = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a1 , i16 %b1 )
  %c2  = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a2 , i16 %b2 )
  %c3  = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a3 , i16 %b3 )
  %c4  = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a4 , i16 %b4 )
  %c5  = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a5 , i16 %b5 )
  %c6  = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a6 , i16 %b6 )
  %c7  = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a7 , i16 %b7 )
  %c8  = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a8 , i16 %b8 )
  %c9  = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a9 , i16 %b9 )
  %c10 = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a10, i16 %b10)
  %c11 = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a11, i16 %b11)
  %c12 = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a12, i16 %b12)
  %c13 = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a13, i16 %b13)
  %c14 = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a14, i16 %b14)
  %c15 = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a15, i16 %b15)
  %c16 = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a16, i16 %b16)
  %c17 = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a17, i16 %b17)
  %c18 = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a18, i16 %b18)
  %c19 = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a19, i16 %b19)
  %c20 = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a20, i16 %b20)
  %c21 = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a21, i16 %b21)
  %c22 = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a22, i16 %b22)
  %c23 = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a23, i16 %b23)
  %c24 = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a24, i16 %b24)
  %c25 = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a25, i16 %b25)
  %c26 = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a26, i16 %b26)
  %c27 = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a27, i16 %b27)
  %c28 = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a28, i16 %b28)
  %c29 = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a29, i16 %b29)
  %c30 = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a30, i16 %b30)
  %c31 = call {i16, i1} @llvm.smul.with.overflow.i16(i16 %a31, i16 %b31)
  %r0  = extractvalue {i16, i1} %c0 , 0
  %r1  = extractvalue {i16, i1} %c1 , 0
  %r2  = extractvalue {i16, i1} %c2 , 0
  %r3  = extractvalue {i16, i1} %c3 , 0
  %r4  = extractvalue {i16, i1} %c4 , 0
  %r5  = extractvalue {i16, i1} %c5 , 0
  %r6  = extractvalue {i16, i1} %c6 , 0
  %r7  = extractvalue {i16, i1} %c7 , 0
  %r8  = extractvalue {i16, i1} %c8 , 0
  %r9  = extractvalue {i16, i1} %c9 , 0
  %r10 = extractvalue {i16, i1} %c10, 0
  %r11 = extractvalue {i16, i1} %c11, 0
  %r12 = extractvalue {i16, i1} %c12, 0
  %r13 = extractvalue {i16, i1} %c13, 0
  %r14 = extractvalue {i16, i1} %c14, 0
  %r15 = extractvalue {i16, i1} %c15, 0
  %r16 = extractvalue {i16, i1} %c16, 0
  %r17 = extractvalue {i16, i1} %c17, 0
  %r18 = extractvalue {i16, i1} %c18, 0
  %r19 = extractvalue {i16, i1} %c19, 0
  %r20 = extractvalue {i16, i1} %c20, 0
  %r21 = extractvalue {i16, i1} %c21, 0
  %r22 = extractvalue {i16, i1} %c22, 0
  %r23 = extractvalue {i16, i1} %c23, 0
  %r24 = extractvalue {i16, i1} %c24, 0
  %r25 = extractvalue {i16, i1} %c25, 0
  %r26 = extractvalue {i16, i1} %c26, 0
  %r27 = extractvalue {i16, i1} %c27, 0
  %r28 = extractvalue {i16, i1} %c28, 0
  %r29 = extractvalue {i16, i1} %c29, 0
  %r30 = extractvalue {i16, i1} %c30, 0
  %r31 = extractvalue {i16, i1} %c31, 0
  store i16 %r0 , ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 0 ), align 2
  store i16 %r1 , ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 1 ), align 2
  store i16 %r2 , ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 2 ), align 2
  store i16 %r3 , ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 3 ), align 2
  store i16 %r4 , ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 4 ), align 2
  store i16 %r5 , ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 5 ), align 2
  store i16 %r6 , ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 6 ), align 2
  store i16 %r7 , ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 7 ), align 2
  store i16 %r8 , ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 8 ), align 2
  store i16 %r9 , ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 9 ), align 2
  store i16 %r10, ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 10), align 2
  store i16 %r11, ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 11), align 2
  store i16 %r12, ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 12), align 2
  store i16 %r13, ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 13), align 2
  store i16 %r14, ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 14), align 2
  store i16 %r15, ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 15), align 2
  store i16 %r16, ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 16), align 2
  store i16 %r17, ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 17), align 2
  store i16 %r18, ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 18), align 2
  store i16 %r19, ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 19), align 2
  store i16 %r20, ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 20), align 2
  store i16 %r21, ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 21), align 2
  store i16 %r22, ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 22), align 2
  store i16 %r23, ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 23), align 2
  store i16 %r24, ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 24), align 2
  store i16 %r25, ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 25), align 2
  store i16 %r26, ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 26), align 2
  store i16 %r27, ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 27), align 2
  store i16 %r28, ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 28), align 2
  store i16 %r29, ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 29), align 2
  store i16 %r30, ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 30), align 2
  store i16 %r31, ptr getelementptr inbounds ([32 x i16], ptr @c16, i32 0, i64 31), align 2
  ret void
}

define void @mul_v64i8() {
; CHECK-LABEL: @mul_v64i8(
; CHECK-NEXT:    [[A0:%.*]] = load i8, ptr @a8, align 1
; CHECK-NEXT:    [[A1:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 1), align 1
; CHECK-NEXT:    [[A2:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 2), align 1
; CHECK-NEXT:    [[A3:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 3), align 1
; CHECK-NEXT:    [[A4:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 4), align 1
; CHECK-NEXT:    [[A5:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 5), align 1
; CHECK-NEXT:    [[A6:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 6), align 1
; CHECK-NEXT:    [[A7:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 7), align 1
; CHECK-NEXT:    [[A8:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 8), align 1
; CHECK-NEXT:    [[A9:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 9), align 1
; CHECK-NEXT:    [[A10:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 10), align 1
; CHECK-NEXT:    [[A11:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 11), align 1
; CHECK-NEXT:    [[A12:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 12), align 1
; CHECK-NEXT:    [[A13:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 13), align 1
; CHECK-NEXT:    [[A14:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 14), align 1
; CHECK-NEXT:    [[A15:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 15), align 1
; CHECK-NEXT:    [[A16:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 16), align 1
; CHECK-NEXT:    [[A17:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 17), align 1
; CHECK-NEXT:    [[A18:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 18), align 1
; CHECK-NEXT:    [[A19:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 19), align 1
; CHECK-NEXT:    [[A20:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 20), align 1
; CHECK-NEXT:    [[A21:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 21), align 1
; CHECK-NEXT:    [[A22:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 22), align 1
; CHECK-NEXT:    [[A23:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 23), align 1
; CHECK-NEXT:    [[A24:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 24), align 1
; CHECK-NEXT:    [[A25:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 25), align 1
; CHECK-NEXT:    [[A26:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 26), align 1
; CHECK-NEXT:    [[A27:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 27), align 1
; CHECK-NEXT:    [[A28:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 28), align 1
; CHECK-NEXT:    [[A29:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 29), align 1
; CHECK-NEXT:    [[A30:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 30), align 1
; CHECK-NEXT:    [[A31:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 31), align 1
; CHECK-NEXT:    [[A32:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 32), align 1
; CHECK-NEXT:    [[A33:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 33), align 1
; CHECK-NEXT:    [[A34:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 34), align 1
; CHECK-NEXT:    [[A35:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 35), align 1
; CHECK-NEXT:    [[A36:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 36), align 1
; CHECK-NEXT:    [[A37:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 37), align 1
; CHECK-NEXT:    [[A38:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 38), align 1
; CHECK-NEXT:    [[A39:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 39), align 1
; CHECK-NEXT:    [[A40:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 40), align 1
; CHECK-NEXT:    [[A41:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 41), align 1
; CHECK-NEXT:    [[A42:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 42), align 1
; CHECK-NEXT:    [[A43:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 43), align 1
; CHECK-NEXT:    [[A44:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 44), align 1
; CHECK-NEXT:    [[A45:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 45), align 1
; CHECK-NEXT:    [[A46:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 46), align 1
; CHECK-NEXT:    [[A47:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 47), align 1
; CHECK-NEXT:    [[A48:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 48), align 1
; CHECK-NEXT:    [[A49:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 49), align 1
; CHECK-NEXT:    [[A50:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 50), align 1
; CHECK-NEXT:    [[A51:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 51), align 1
; CHECK-NEXT:    [[A52:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 52), align 1
; CHECK-NEXT:    [[A53:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 53), align 1
; CHECK-NEXT:    [[A54:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 54), align 1
; CHECK-NEXT:    [[A55:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 55), align 1
; CHECK-NEXT:    [[A56:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 56), align 1
; CHECK-NEXT:    [[A57:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 57), align 1
; CHECK-NEXT:    [[A58:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 58), align 1
; CHECK-NEXT:    [[A59:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 59), align 1
; CHECK-NEXT:    [[A60:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 60), align 1
; CHECK-NEXT:    [[A61:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 61), align 1
; CHECK-NEXT:    [[A62:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 62), align 1
; CHECK-NEXT:    [[A63:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 63), align 1
; CHECK-NEXT:    [[B0:%.*]] = load i8, ptr @b8, align 1
; CHECK-NEXT:    [[B1:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 1), align 1
; CHECK-NEXT:    [[B2:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 2), align 1
; CHECK-NEXT:    [[B3:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 3), align 1
; CHECK-NEXT:    [[B4:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 4), align 1
; CHECK-NEXT:    [[B5:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 5), align 1
; CHECK-NEXT:    [[B6:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 6), align 1
; CHECK-NEXT:    [[B7:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 7), align 1
; CHECK-NEXT:    [[B8:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 8), align 1
; CHECK-NEXT:    [[B9:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 9), align 1
; CHECK-NEXT:    [[B10:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 10), align 1
; CHECK-NEXT:    [[B11:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 11), align 1
; CHECK-NEXT:    [[B12:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 12), align 1
; CHECK-NEXT:    [[B13:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 13), align 1
; CHECK-NEXT:    [[B14:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 14), align 1
; CHECK-NEXT:    [[B15:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 15), align 1
; CHECK-NEXT:    [[B16:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 16), align 1
; CHECK-NEXT:    [[B17:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 17), align 1
; CHECK-NEXT:    [[B18:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 18), align 1
; CHECK-NEXT:    [[B19:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 19), align 1
; CHECK-NEXT:    [[B20:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 20), align 1
; CHECK-NEXT:    [[B21:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 21), align 1
; CHECK-NEXT:    [[B22:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 22), align 1
; CHECK-NEXT:    [[B23:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 23), align 1
; CHECK-NEXT:    [[B24:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 24), align 1
; CHECK-NEXT:    [[B25:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 25), align 1
; CHECK-NEXT:    [[B26:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 26), align 1
; CHECK-NEXT:    [[B27:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 27), align 1
; CHECK-NEXT:    [[B28:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 28), align 1
; CHECK-NEXT:    [[B29:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 29), align 1
; CHECK-NEXT:    [[B30:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 30), align 1
; CHECK-NEXT:    [[B31:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 31), align 1
; CHECK-NEXT:    [[B32:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 32), align 1
; CHECK-NEXT:    [[B33:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 33), align 1
; CHECK-NEXT:    [[B34:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 34), align 1
; CHECK-NEXT:    [[B35:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 35), align 1
; CHECK-NEXT:    [[B36:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 36), align 1
; CHECK-NEXT:    [[B37:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 37), align 1
; CHECK-NEXT:    [[B38:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 38), align 1
; CHECK-NEXT:    [[B39:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 39), align 1
; CHECK-NEXT:    [[B40:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 40), align 1
; CHECK-NEXT:    [[B41:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 41), align 1
; CHECK-NEXT:    [[B42:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 42), align 1
; CHECK-NEXT:    [[B43:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 43), align 1
; CHECK-NEXT:    [[B44:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 44), align 1
; CHECK-NEXT:    [[B45:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 45), align 1
; CHECK-NEXT:    [[B46:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 46), align 1
; CHECK-NEXT:    [[B47:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 47), align 1
; CHECK-NEXT:    [[B48:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 48), align 1
; CHECK-NEXT:    [[B49:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 49), align 1
; CHECK-NEXT:    [[B50:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 50), align 1
; CHECK-NEXT:    [[B51:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 51), align 1
; CHECK-NEXT:    [[B52:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 52), align 1
; CHECK-NEXT:    [[B53:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 53), align 1
; CHECK-NEXT:    [[B54:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 54), align 1
; CHECK-NEXT:    [[B55:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 55), align 1
; CHECK-NEXT:    [[B56:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 56), align 1
; CHECK-NEXT:    [[B57:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 57), align 1
; CHECK-NEXT:    [[B58:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 58), align 1
; CHECK-NEXT:    [[B59:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 59), align 1
; CHECK-NEXT:    [[B60:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 60), align 1
; CHECK-NEXT:    [[B61:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 61), align 1
; CHECK-NEXT:    [[B62:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 62), align 1
; CHECK-NEXT:    [[B63:%.*]] = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 63), align 1
; CHECK-NEXT:    [[C0:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A0]], i8 [[B0]])
; CHECK-NEXT:    [[C1:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A1]], i8 [[B1]])
; CHECK-NEXT:    [[C2:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A2]], i8 [[B2]])
; CHECK-NEXT:    [[C3:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A3]], i8 [[B3]])
; CHECK-NEXT:    [[C4:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A4]], i8 [[B4]])
; CHECK-NEXT:    [[C5:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A5]], i8 [[B5]])
; CHECK-NEXT:    [[C6:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A6]], i8 [[B6]])
; CHECK-NEXT:    [[C7:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A7]], i8 [[B7]])
; CHECK-NEXT:    [[C8:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A8]], i8 [[B8]])
; CHECK-NEXT:    [[C9:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A9]], i8 [[B9]])
; CHECK-NEXT:    [[C10:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A10]], i8 [[B10]])
; CHECK-NEXT:    [[C11:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A11]], i8 [[B11]])
; CHECK-NEXT:    [[C12:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A12]], i8 [[B12]])
; CHECK-NEXT:    [[C13:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A13]], i8 [[B13]])
; CHECK-NEXT:    [[C14:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A14]], i8 [[B14]])
; CHECK-NEXT:    [[C15:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A15]], i8 [[B15]])
; CHECK-NEXT:    [[C16:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A16]], i8 [[B16]])
; CHECK-NEXT:    [[C17:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A17]], i8 [[B17]])
; CHECK-NEXT:    [[C18:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A18]], i8 [[B18]])
; CHECK-NEXT:    [[C19:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A19]], i8 [[B19]])
; CHECK-NEXT:    [[C20:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A20]], i8 [[B20]])
; CHECK-NEXT:    [[C21:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A21]], i8 [[B21]])
; CHECK-NEXT:    [[C22:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A22]], i8 [[B22]])
; CHECK-NEXT:    [[C23:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A23]], i8 [[B23]])
; CHECK-NEXT:    [[C24:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A24]], i8 [[B24]])
; CHECK-NEXT:    [[C25:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A25]], i8 [[B25]])
; CHECK-NEXT:    [[C26:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A26]], i8 [[B26]])
; CHECK-NEXT:    [[C27:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A27]], i8 [[B27]])
; CHECK-NEXT:    [[C28:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A28]], i8 [[B28]])
; CHECK-NEXT:    [[C29:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A29]], i8 [[B29]])
; CHECK-NEXT:    [[C30:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A30]], i8 [[B30]])
; CHECK-NEXT:    [[C31:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A31]], i8 [[B31]])
; CHECK-NEXT:    [[C32:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A32]], i8 [[B32]])
; CHECK-NEXT:    [[C33:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A33]], i8 [[B33]])
; CHECK-NEXT:    [[C34:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A34]], i8 [[B34]])
; CHECK-NEXT:    [[C35:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A35]], i8 [[B35]])
; CHECK-NEXT:    [[C36:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A36]], i8 [[B36]])
; CHECK-NEXT:    [[C37:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A37]], i8 [[B37]])
; CHECK-NEXT:    [[C38:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A38]], i8 [[B38]])
; CHECK-NEXT:    [[C39:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A39]], i8 [[B39]])
; CHECK-NEXT:    [[C40:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A40]], i8 [[B40]])
; CHECK-NEXT:    [[C41:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A41]], i8 [[B41]])
; CHECK-NEXT:    [[C42:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A42]], i8 [[B42]])
; CHECK-NEXT:    [[C43:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A43]], i8 [[B43]])
; CHECK-NEXT:    [[C44:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A44]], i8 [[B44]])
; CHECK-NEXT:    [[C45:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A45]], i8 [[B45]])
; CHECK-NEXT:    [[C46:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A46]], i8 [[B46]])
; CHECK-NEXT:    [[C47:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A47]], i8 [[B47]])
; CHECK-NEXT:    [[C48:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A48]], i8 [[B48]])
; CHECK-NEXT:    [[C49:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A49]], i8 [[B49]])
; CHECK-NEXT:    [[C50:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A50]], i8 [[B50]])
; CHECK-NEXT:    [[C51:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A51]], i8 [[B51]])
; CHECK-NEXT:    [[C52:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A52]], i8 [[B52]])
; CHECK-NEXT:    [[C53:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A53]], i8 [[B53]])
; CHECK-NEXT:    [[C54:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A54]], i8 [[B54]])
; CHECK-NEXT:    [[C55:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A55]], i8 [[B55]])
; CHECK-NEXT:    [[C56:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A56]], i8 [[B56]])
; CHECK-NEXT:    [[C57:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A57]], i8 [[B57]])
; CHECK-NEXT:    [[C58:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A58]], i8 [[B58]])
; CHECK-NEXT:    [[C59:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A59]], i8 [[B59]])
; CHECK-NEXT:    [[C60:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A60]], i8 [[B60]])
; CHECK-NEXT:    [[C61:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A61]], i8 [[B61]])
; CHECK-NEXT:    [[C62:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A62]], i8 [[B62]])
; CHECK-NEXT:    [[C63:%.*]] = call { i8, i1 } @llvm.smul.with.overflow.i8(i8 [[A63]], i8 [[B63]])
; CHECK-NEXT:    [[R0:%.*]] = extractvalue { i8, i1 } [[C0]], 0
; CHECK-NEXT:    [[R1:%.*]] = extractvalue { i8, i1 } [[C1]], 0
; CHECK-NEXT:    [[R2:%.*]] = extractvalue { i8, i1 } [[C2]], 0
; CHECK-NEXT:    [[R3:%.*]] = extractvalue { i8, i1 } [[C3]], 0
; CHECK-NEXT:    [[R4:%.*]] = extractvalue { i8, i1 } [[C4]], 0
; CHECK-NEXT:    [[R5:%.*]] = extractvalue { i8, i1 } [[C5]], 0
; CHECK-NEXT:    [[R6:%.*]] = extractvalue { i8, i1 } [[C6]], 0
; CHECK-NEXT:    [[R7:%.*]] = extractvalue { i8, i1 } [[C7]], 0
; CHECK-NEXT:    [[R8:%.*]] = extractvalue { i8, i1 } [[C8]], 0
; CHECK-NEXT:    [[R9:%.*]] = extractvalue { i8, i1 } [[C9]], 0
; CHECK-NEXT:    [[R10:%.*]] = extractvalue { i8, i1 } [[C10]], 0
; CHECK-NEXT:    [[R11:%.*]] = extractvalue { i8, i1 } [[C11]], 0
; CHECK-NEXT:    [[R12:%.*]] = extractvalue { i8, i1 } [[C12]], 0
; CHECK-NEXT:    [[R13:%.*]] = extractvalue { i8, i1 } [[C13]], 0
; CHECK-NEXT:    [[R14:%.*]] = extractvalue { i8, i1 } [[C14]], 0
; CHECK-NEXT:    [[R15:%.*]] = extractvalue { i8, i1 } [[C15]], 0
; CHECK-NEXT:    [[R16:%.*]] = extractvalue { i8, i1 } [[C16]], 0
; CHECK-NEXT:    [[R17:%.*]] = extractvalue { i8, i1 } [[C17]], 0
; CHECK-NEXT:    [[R18:%.*]] = extractvalue { i8, i1 } [[C18]], 0
; CHECK-NEXT:    [[R19:%.*]] = extractvalue { i8, i1 } [[C19]], 0
; CHECK-NEXT:    [[R20:%.*]] = extractvalue { i8, i1 } [[C20]], 0
; CHECK-NEXT:    [[R21:%.*]] = extractvalue { i8, i1 } [[C21]], 0
; CHECK-NEXT:    [[R22:%.*]] = extractvalue { i8, i1 } [[C22]], 0
; CHECK-NEXT:    [[R23:%.*]] = extractvalue { i8, i1 } [[C23]], 0
; CHECK-NEXT:    [[R24:%.*]] = extractvalue { i8, i1 } [[C24]], 0
; CHECK-NEXT:    [[R25:%.*]] = extractvalue { i8, i1 } [[C25]], 0
; CHECK-NEXT:    [[R26:%.*]] = extractvalue { i8, i1 } [[C26]], 0
; CHECK-NEXT:    [[R27:%.*]] = extractvalue { i8, i1 } [[C27]], 0
; CHECK-NEXT:    [[R28:%.*]] = extractvalue { i8, i1 } [[C28]], 0
; CHECK-NEXT:    [[R29:%.*]] = extractvalue { i8, i1 } [[C29]], 0
; CHECK-NEXT:    [[R30:%.*]] = extractvalue { i8, i1 } [[C30]], 0
; CHECK-NEXT:    [[R31:%.*]] = extractvalue { i8, i1 } [[C31]], 0
; CHECK-NEXT:    [[R32:%.*]] = extractvalue { i8, i1 } [[C32]], 0
; CHECK-NEXT:    [[R33:%.*]] = extractvalue { i8, i1 } [[C33]], 0
; CHECK-NEXT:    [[R34:%.*]] = extractvalue { i8, i1 } [[C34]], 0
; CHECK-NEXT:    [[R35:%.*]] = extractvalue { i8, i1 } [[C35]], 0
; CHECK-NEXT:    [[R36:%.*]] = extractvalue { i8, i1 } [[C36]], 0
; CHECK-NEXT:    [[R37:%.*]] = extractvalue { i8, i1 } [[C37]], 0
; CHECK-NEXT:    [[R38:%.*]] = extractvalue { i8, i1 } [[C38]], 0
; CHECK-NEXT:    [[R39:%.*]] = extractvalue { i8, i1 } [[C39]], 0
; CHECK-NEXT:    [[R40:%.*]] = extractvalue { i8, i1 } [[C40]], 0
; CHECK-NEXT:    [[R41:%.*]] = extractvalue { i8, i1 } [[C41]], 0
; CHECK-NEXT:    [[R42:%.*]] = extractvalue { i8, i1 } [[C42]], 0
; CHECK-NEXT:    [[R43:%.*]] = extractvalue { i8, i1 } [[C43]], 0
; CHECK-NEXT:    [[R44:%.*]] = extractvalue { i8, i1 } [[C44]], 0
; CHECK-NEXT:    [[R45:%.*]] = extractvalue { i8, i1 } [[C45]], 0
; CHECK-NEXT:    [[R46:%.*]] = extractvalue { i8, i1 } [[C46]], 0
; CHECK-NEXT:    [[R47:%.*]] = extractvalue { i8, i1 } [[C47]], 0
; CHECK-NEXT:    [[R48:%.*]] = extractvalue { i8, i1 } [[C48]], 0
; CHECK-NEXT:    [[R49:%.*]] = extractvalue { i8, i1 } [[C49]], 0
; CHECK-NEXT:    [[R50:%.*]] = extractvalue { i8, i1 } [[C50]], 0
; CHECK-NEXT:    [[R51:%.*]] = extractvalue { i8, i1 } [[C51]], 0
; CHECK-NEXT:    [[R52:%.*]] = extractvalue { i8, i1 } [[C52]], 0
; CHECK-NEXT:    [[R53:%.*]] = extractvalue { i8, i1 } [[C53]], 0
; CHECK-NEXT:    [[R54:%.*]] = extractvalue { i8, i1 } [[C54]], 0
; CHECK-NEXT:    [[R55:%.*]] = extractvalue { i8, i1 } [[C55]], 0
; CHECK-NEXT:    [[R56:%.*]] = extractvalue { i8, i1 } [[C56]], 0
; CHECK-NEXT:    [[R57:%.*]] = extractvalue { i8, i1 } [[C57]], 0
; CHECK-NEXT:    [[R58:%.*]] = extractvalue { i8, i1 } [[C58]], 0
; CHECK-NEXT:    [[R59:%.*]] = extractvalue { i8, i1 } [[C59]], 0
; CHECK-NEXT:    [[R60:%.*]] = extractvalue { i8, i1 } [[C60]], 0
; CHECK-NEXT:    [[R61:%.*]] = extractvalue { i8, i1 } [[C61]], 0
; CHECK-NEXT:    [[R62:%.*]] = extractvalue { i8, i1 } [[C62]], 0
; CHECK-NEXT:    [[R63:%.*]] = extractvalue { i8, i1 } [[C63]], 0
; CHECK-NEXT:    store i8 [[R0]], ptr @c8, align 1
; CHECK-NEXT:    store i8 [[R1]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 1), align 1
; CHECK-NEXT:    store i8 [[R2]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 2), align 1
; CHECK-NEXT:    store i8 [[R3]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 3), align 1
; CHECK-NEXT:    store i8 [[R4]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 4), align 1
; CHECK-NEXT:    store i8 [[R5]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 5), align 1
; CHECK-NEXT:    store i8 [[R6]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 6), align 1
; CHECK-NEXT:    store i8 [[R7]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 7), align 1
; CHECK-NEXT:    store i8 [[R8]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 8), align 1
; CHECK-NEXT:    store i8 [[R9]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 9), align 1
; CHECK-NEXT:    store i8 [[R10]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 10), align 1
; CHECK-NEXT:    store i8 [[R11]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 11), align 1
; CHECK-NEXT:    store i8 [[R12]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 12), align 1
; CHECK-NEXT:    store i8 [[R13]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 13), align 1
; CHECK-NEXT:    store i8 [[R14]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 14), align 1
; CHECK-NEXT:    store i8 [[R15]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 15), align 1
; CHECK-NEXT:    store i8 [[R16]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 16), align 1
; CHECK-NEXT:    store i8 [[R17]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 17), align 1
; CHECK-NEXT:    store i8 [[R18]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 18), align 1
; CHECK-NEXT:    store i8 [[R19]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 19), align 1
; CHECK-NEXT:    store i8 [[R20]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 20), align 1
; CHECK-NEXT:    store i8 [[R21]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 21), align 1
; CHECK-NEXT:    store i8 [[R22]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 22), align 1
; CHECK-NEXT:    store i8 [[R23]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 23), align 1
; CHECK-NEXT:    store i8 [[R24]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 24), align 1
; CHECK-NEXT:    store i8 [[R25]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 25), align 1
; CHECK-NEXT:    store i8 [[R26]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 26), align 1
; CHECK-NEXT:    store i8 [[R27]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 27), align 1
; CHECK-NEXT:    store i8 [[R28]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 28), align 1
; CHECK-NEXT:    store i8 [[R29]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 29), align 1
; CHECK-NEXT:    store i8 [[R30]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 30), align 1
; CHECK-NEXT:    store i8 [[R31]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 31), align 1
; CHECK-NEXT:    store i8 [[R32]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 32), align 1
; CHECK-NEXT:    store i8 [[R33]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 33), align 1
; CHECK-NEXT:    store i8 [[R34]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 34), align 1
; CHECK-NEXT:    store i8 [[R35]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 35), align 1
; CHECK-NEXT:    store i8 [[R36]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 36), align 1
; CHECK-NEXT:    store i8 [[R37]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 37), align 1
; CHECK-NEXT:    store i8 [[R38]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 38), align 1
; CHECK-NEXT:    store i8 [[R39]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 39), align 1
; CHECK-NEXT:    store i8 [[R40]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 40), align 1
; CHECK-NEXT:    store i8 [[R41]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 41), align 1
; CHECK-NEXT:    store i8 [[R42]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 42), align 1
; CHECK-NEXT:    store i8 [[R43]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 43), align 1
; CHECK-NEXT:    store i8 [[R44]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 44), align 1
; CHECK-NEXT:    store i8 [[R45]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 45), align 1
; CHECK-NEXT:    store i8 [[R46]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 46), align 1
; CHECK-NEXT:    store i8 [[R47]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 47), align 1
; CHECK-NEXT:    store i8 [[R48]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 48), align 1
; CHECK-NEXT:    store i8 [[R49]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 49), align 1
; CHECK-NEXT:    store i8 [[R50]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 50), align 1
; CHECK-NEXT:    store i8 [[R51]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 51), align 1
; CHECK-NEXT:    store i8 [[R52]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 52), align 1
; CHECK-NEXT:    store i8 [[R53]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 53), align 1
; CHECK-NEXT:    store i8 [[R54]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 54), align 1
; CHECK-NEXT:    store i8 [[R55]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 55), align 1
; CHECK-NEXT:    store i8 [[R56]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 56), align 1
; CHECK-NEXT:    store i8 [[R57]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 57), align 1
; CHECK-NEXT:    store i8 [[R58]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 58), align 1
; CHECK-NEXT:    store i8 [[R59]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 59), align 1
; CHECK-NEXT:    store i8 [[R60]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 60), align 1
; CHECK-NEXT:    store i8 [[R61]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 61), align 1
; CHECK-NEXT:    store i8 [[R62]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 62), align 1
; CHECK-NEXT:    store i8 [[R63]], ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 63), align 1
; CHECK-NEXT:    ret void
;
  %a0  = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 0 ), align 1
  %a1  = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 1 ), align 1
  %a2  = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 2 ), align 1
  %a3  = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 3 ), align 1
  %a4  = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 4 ), align 1
  %a5  = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 5 ), align 1
  %a6  = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 6 ), align 1
  %a7  = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 7 ), align 1
  %a8  = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 8 ), align 1
  %a9  = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 9 ), align 1
  %a10 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 10), align 1
  %a11 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 11), align 1
  %a12 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 12), align 1
  %a13 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 13), align 1
  %a14 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 14), align 1
  %a15 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 15), align 1
  %a16 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 16), align 1
  %a17 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 17), align 1
  %a18 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 18), align 1
  %a19 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 19), align 1
  %a20 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 20), align 1
  %a21 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 21), align 1
  %a22 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 22), align 1
  %a23 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 23), align 1
  %a24 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 24), align 1
  %a25 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 25), align 1
  %a26 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 26), align 1
  %a27 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 27), align 1
  %a28 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 28), align 1
  %a29 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 29), align 1
  %a30 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 30), align 1
  %a31 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 31), align 1
  %a32 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 32), align 1
  %a33 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 33), align 1
  %a34 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 34), align 1
  %a35 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 35), align 1
  %a36 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 36), align 1
  %a37 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 37), align 1
  %a38 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 38), align 1
  %a39 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 39), align 1
  %a40 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 40), align 1
  %a41 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 41), align 1
  %a42 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 42), align 1
  %a43 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 43), align 1
  %a44 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 44), align 1
  %a45 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 45), align 1
  %a46 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 46), align 1
  %a47 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 47), align 1
  %a48 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 48), align 1
  %a49 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 49), align 1
  %a50 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 50), align 1
  %a51 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 51), align 1
  %a52 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 52), align 1
  %a53 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 53), align 1
  %a54 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 54), align 1
  %a55 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 55), align 1
  %a56 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 56), align 1
  %a57 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 57), align 1
  %a58 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 58), align 1
  %a59 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 59), align 1
  %a60 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 60), align 1
  %a61 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 61), align 1
  %a62 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 62), align 1
  %a63 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @a8, i32 0, i64 63), align 1
  %b0  = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 0 ), align 1
  %b1  = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 1 ), align 1
  %b2  = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 2 ), align 1
  %b3  = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 3 ), align 1
  %b4  = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 4 ), align 1
  %b5  = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 5 ), align 1
  %b6  = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 6 ), align 1
  %b7  = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 7 ), align 1
  %b8  = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 8 ), align 1
  %b9  = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 9 ), align 1
  %b10 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 10), align 1
  %b11 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 11), align 1
  %b12 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 12), align 1
  %b13 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 13), align 1
  %b14 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 14), align 1
  %b15 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 15), align 1
  %b16 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 16), align 1
  %b17 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 17), align 1
  %b18 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 18), align 1
  %b19 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 19), align 1
  %b20 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 20), align 1
  %b21 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 21), align 1
  %b22 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 22), align 1
  %b23 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 23), align 1
  %b24 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 24), align 1
  %b25 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 25), align 1
  %b26 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 26), align 1
  %b27 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 27), align 1
  %b28 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 28), align 1
  %b29 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 29), align 1
  %b30 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 30), align 1
  %b31 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 31), align 1
  %b32 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 32), align 1
  %b33 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 33), align 1
  %b34 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 34), align 1
  %b35 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 35), align 1
  %b36 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 36), align 1
  %b37 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 37), align 1
  %b38 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 38), align 1
  %b39 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 39), align 1
  %b40 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 40), align 1
  %b41 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 41), align 1
  %b42 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 42), align 1
  %b43 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 43), align 1
  %b44 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 44), align 1
  %b45 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 45), align 1
  %b46 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 46), align 1
  %b47 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 47), align 1
  %b48 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 48), align 1
  %b49 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 49), align 1
  %b50 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 50), align 1
  %b51 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 51), align 1
  %b52 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 52), align 1
  %b53 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 53), align 1
  %b54 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 54), align 1
  %b55 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 55), align 1
  %b56 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 56), align 1
  %b57 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 57), align 1
  %b58 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 58), align 1
  %b59 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 59), align 1
  %b60 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 60), align 1
  %b61 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 61), align 1
  %b62 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 62), align 1
  %b63 = load i8, ptr getelementptr inbounds ([64 x i8], ptr @b8, i32 0, i64 63), align 1
  %c0  = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a0 , i8 %b0 )
  %c1  = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a1 , i8 %b1 )
  %c2  = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a2 , i8 %b2 )
  %c3  = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a3 , i8 %b3 )
  %c4  = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a4 , i8 %b4 )
  %c5  = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a5 , i8 %b5 )
  %c6  = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a6 , i8 %b6 )
  %c7  = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a7 , i8 %b7 )
  %c8  = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a8 , i8 %b8 )
  %c9  = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a9 , i8 %b9 )
  %c10 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a10, i8 %b10)
  %c11 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a11, i8 %b11)
  %c12 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a12, i8 %b12)
  %c13 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a13, i8 %b13)
  %c14 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a14, i8 %b14)
  %c15 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a15, i8 %b15)
  %c16 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a16, i8 %b16)
  %c17 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a17, i8 %b17)
  %c18 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a18, i8 %b18)
  %c19 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a19, i8 %b19)
  %c20 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a20, i8 %b20)
  %c21 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a21, i8 %b21)
  %c22 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a22, i8 %b22)
  %c23 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a23, i8 %b23)
  %c24 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a24, i8 %b24)
  %c25 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a25, i8 %b25)
  %c26 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a26, i8 %b26)
  %c27 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a27, i8 %b27)
  %c28 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a28, i8 %b28)
  %c29 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a29, i8 %b29)
  %c30 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a30, i8 %b30)
  %c31 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a31, i8 %b31)
  %c32 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a32, i8 %b32)
  %c33 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a33, i8 %b33)
  %c34 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a34, i8 %b34)
  %c35 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a35, i8 %b35)
  %c36 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a36, i8 %b36)
  %c37 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a37, i8 %b37)
  %c38 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a38, i8 %b38)
  %c39 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a39, i8 %b39)
  %c40 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a40, i8 %b40)
  %c41 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a41, i8 %b41)
  %c42 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a42, i8 %b42)
  %c43 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a43, i8 %b43)
  %c44 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a44, i8 %b44)
  %c45 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a45, i8 %b45)
  %c46 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a46, i8 %b46)
  %c47 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a47, i8 %b47)
  %c48 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a48, i8 %b48)
  %c49 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a49, i8 %b49)
  %c50 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a50, i8 %b50)
  %c51 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a51, i8 %b51)
  %c52 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a52, i8 %b52)
  %c53 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a53, i8 %b53)
  %c54 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a54, i8 %b54)
  %c55 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a55, i8 %b55)
  %c56 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a56, i8 %b56)
  %c57 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a57, i8 %b57)
  %c58 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a58, i8 %b58)
  %c59 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a59, i8 %b59)
  %c60 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a60, i8 %b60)
  %c61 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a61, i8 %b61)
  %c62 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a62, i8 %b62)
  %c63 = call {i8, i1} @llvm.smul.with.overflow.i8(i8 %a63, i8 %b63)
  %r0  = extractvalue {i8, i1} %c0 , 0
  %r1  = extractvalue {i8, i1} %c1 , 0
  %r2  = extractvalue {i8, i1} %c2 , 0
  %r3  = extractvalue {i8, i1} %c3 , 0
  %r4  = extractvalue {i8, i1} %c4 , 0
  %r5  = extractvalue {i8, i1} %c5 , 0
  %r6  = extractvalue {i8, i1} %c6 , 0
  %r7  = extractvalue {i8, i1} %c7 , 0
  %r8  = extractvalue {i8, i1} %c8 , 0
  %r9  = extractvalue {i8, i1} %c9 , 0
  %r10 = extractvalue {i8, i1} %c10, 0
  %r11 = extractvalue {i8, i1} %c11, 0
  %r12 = extractvalue {i8, i1} %c12, 0
  %r13 = extractvalue {i8, i1} %c13, 0
  %r14 = extractvalue {i8, i1} %c14, 0
  %r15 = extractvalue {i8, i1} %c15, 0
  %r16 = extractvalue {i8, i1} %c16, 0
  %r17 = extractvalue {i8, i1} %c17, 0
  %r18 = extractvalue {i8, i1} %c18, 0
  %r19 = extractvalue {i8, i1} %c19, 0
  %r20 = extractvalue {i8, i1} %c20, 0
  %r21 = extractvalue {i8, i1} %c21, 0
  %r22 = extractvalue {i8, i1} %c22, 0
  %r23 = extractvalue {i8, i1} %c23, 0
  %r24 = extractvalue {i8, i1} %c24, 0
  %r25 = extractvalue {i8, i1} %c25, 0
  %r26 = extractvalue {i8, i1} %c26, 0
  %r27 = extractvalue {i8, i1} %c27, 0
  %r28 = extractvalue {i8, i1} %c28, 0
  %r29 = extractvalue {i8, i1} %c29, 0
  %r30 = extractvalue {i8, i1} %c30, 0
  %r31 = extractvalue {i8, i1} %c31, 0
  %r32 = extractvalue {i8, i1} %c32, 0
  %r33 = extractvalue {i8, i1} %c33, 0
  %r34 = extractvalue {i8, i1} %c34, 0
  %r35 = extractvalue {i8, i1} %c35, 0
  %r36 = extractvalue {i8, i1} %c36, 0
  %r37 = extractvalue {i8, i1} %c37, 0
  %r38 = extractvalue {i8, i1} %c38, 0
  %r39 = extractvalue {i8, i1} %c39, 0
  %r40 = extractvalue {i8, i1} %c40, 0
  %r41 = extractvalue {i8, i1} %c41, 0
  %r42 = extractvalue {i8, i1} %c42, 0
  %r43 = extractvalue {i8, i1} %c43, 0
  %r44 = extractvalue {i8, i1} %c44, 0
  %r45 = extractvalue {i8, i1} %c45, 0
  %r46 = extractvalue {i8, i1} %c46, 0
  %r47 = extractvalue {i8, i1} %c47, 0
  %r48 = extractvalue {i8, i1} %c48, 0
  %r49 = extractvalue {i8, i1} %c49, 0
  %r50 = extractvalue {i8, i1} %c50, 0
  %r51 = extractvalue {i8, i1} %c51, 0
  %r52 = extractvalue {i8, i1} %c52, 0
  %r53 = extractvalue {i8, i1} %c53, 0
  %r54 = extractvalue {i8, i1} %c54, 0
  %r55 = extractvalue {i8, i1} %c55, 0
  %r56 = extractvalue {i8, i1} %c56, 0
  %r57 = extractvalue {i8, i1} %c57, 0
  %r58 = extractvalue {i8, i1} %c58, 0
  %r59 = extractvalue {i8, i1} %c59, 0
  %r60 = extractvalue {i8, i1} %c60, 0
  %r61 = extractvalue {i8, i1} %c61, 0
  %r62 = extractvalue {i8, i1} %c62, 0
  %r63 = extractvalue {i8, i1} %c63, 0
  store i8 %r0 , ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 0 ), align 1
  store i8 %r1 , ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 1 ), align 1
  store i8 %r2 , ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 2 ), align 1
  store i8 %r3 , ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 3 ), align 1
  store i8 %r4 , ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 4 ), align 1
  store i8 %r5 , ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 5 ), align 1
  store i8 %r6 , ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 6 ), align 1
  store i8 %r7 , ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 7 ), align 1
  store i8 %r8 , ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 8 ), align 1
  store i8 %r9 , ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 9 ), align 1
  store i8 %r10, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 10), align 1
  store i8 %r11, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 11), align 1
  store i8 %r12, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 12), align 1
  store i8 %r13, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 13), align 1
  store i8 %r14, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 14), align 1
  store i8 %r15, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 15), align 1
  store i8 %r16, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 16), align 1
  store i8 %r17, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 17), align 1
  store i8 %r18, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 18), align 1
  store i8 %r19, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 19), align 1
  store i8 %r20, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 20), align 1
  store i8 %r21, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 21), align 1
  store i8 %r22, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 22), align 1
  store i8 %r23, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 23), align 1
  store i8 %r24, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 24), align 1
  store i8 %r25, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 25), align 1
  store i8 %r26, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 26), align 1
  store i8 %r27, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 27), align 1
  store i8 %r28, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 28), align 1
  store i8 %r29, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 29), align 1
  store i8 %r30, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 30), align 1
  store i8 %r31, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 31), align 1
  store i8 %r32, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 32), align 1
  store i8 %r33, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 33), align 1
  store i8 %r34, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 34), align 1
  store i8 %r35, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 35), align 1
  store i8 %r36, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 36), align 1
  store i8 %r37, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 37), align 1
  store i8 %r38, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 38), align 1
  store i8 %r39, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 39), align 1
  store i8 %r40, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 40), align 1
  store i8 %r41, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 41), align 1
  store i8 %r42, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 42), align 1
  store i8 %r43, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 43), align 1
  store i8 %r44, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 44), align 1
  store i8 %r45, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 45), align 1
  store i8 %r46, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 46), align 1
  store i8 %r47, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 47), align 1
  store i8 %r48, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 48), align 1
  store i8 %r49, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 49), align 1
  store i8 %r50, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 50), align 1
  store i8 %r51, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 51), align 1
  store i8 %r52, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 52), align 1
  store i8 %r53, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 53), align 1
  store i8 %r54, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 54), align 1
  store i8 %r55, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 55), align 1
  store i8 %r56, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 56), align 1
  store i8 %r57, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 57), align 1
  store i8 %r58, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 58), align 1
  store i8 %r59, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 59), align 1
  store i8 %r60, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 60), align 1
  store i8 %r61, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 61), align 1
  store i8 %r62, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 62), align 1
  store i8 %r63, ptr getelementptr inbounds ([64 x i8], ptr @c8, i32 0, i64 63), align 1
  ret void
}
