; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes='sroa<preserve-cfg>' -S | FileCheck %s --check-prefixes=CHECK,CHECK-PRESERVE-CFG
; RUN: opt < %s -passes='sroa<modify-cfg>' -S | FileCheck %s --check-prefixes=CHECK,CHECK-MODIFY-CFG

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-n8:16:32:64"

define { i32, i32 } @test0(i32 %x, i32 %y, { i32, i32 } %v) {
; CHECK-LABEL: @test0(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[V_FCA_0_EXTRACT:%.*]] = extractvalue { i32, i32 } [[V:%.*]], 0
; CHECK-NEXT:    [[V_FCA_1_EXTRACT:%.*]] = extractvalue { i32, i32 } [[V]], 1
; CHECK-NEXT:    [[RESULT_FCA_0_INSERT:%.*]] = insertvalue { i32, i32 } poison, i32 [[X:%.*]], 0
; CHECK-NEXT:    [[RESULT_FCA_1_INSERT:%.*]] = insertvalue { i32, i32 } [[RESULT_FCA_0_INSERT]], i32 [[Y:%.*]], 1
; CHECK-NEXT:    ret { i32, i32 } [[RESULT_FCA_1_INSERT]]
;
entry:
  %a = alloca { i32, i32 }

  store { i32, i32 } %v, ptr %a

  %gep1 = getelementptr inbounds { i32, i32 }, ptr %a, i32 0, i32 0
  store i32 %x, ptr %gep1
  %gep2 = getelementptr inbounds { i32, i32 }, ptr %a, i32 0, i32 1
  store i32 %y, ptr %gep2

  %result = load { i32, i32 }, ptr %a
  ret { i32, i32 } %result
}

define { i32, i32 } @test1(i32 %x, i32 %y) {
; FIXME: This may be too conservative. Duncan argues that we are allowed to
; split the volatile load and store here but must produce volatile scalar loads
; and stores from them.
; CHECK-LABEL: @test1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca { i32, i32 }, align 8
; CHECK-NEXT:    [[B:%.*]] = alloca { i32, i32 }, align 8
; CHECK-NEXT:    store i32 [[X:%.*]], ptr [[A]], align 8
; CHECK-NEXT:    [[A_4_GEP2_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A]], i64 4
; CHECK-NEXT:    store i32 [[Y:%.*]], ptr [[A_4_GEP2_SROA_IDX]], align 4
; CHECK-NEXT:    [[A_0_RESULT:%.*]] = load volatile { i32, i32 }, ptr [[A]], align 8
; CHECK-NEXT:    store volatile { i32, i32 } [[A_0_RESULT]], ptr [[B]], align 8
; CHECK-NEXT:    ret { i32, i32 } [[A_0_RESULT]]
;
entry:
  %a = alloca { i32, i32 }
  %b = alloca { i32, i32 }

  %gep1 = getelementptr inbounds { i32, i32 }, ptr %a, i32 0, i32 0
  store i32 %x, ptr %gep1
  %gep2 = getelementptr inbounds { i32, i32 }, ptr %a, i32 0, i32 1
  store i32 %y, ptr %gep2

  %result = load volatile { i32, i32 }, ptr %a
  store volatile { i32, i32 } %result, ptr %b
  ret { i32, i32 } %result
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK-MODIFY-CFG: {{.*}}
; CHECK-PRESERVE-CFG: {{.*}}
