C
C   Copyright (c) 1997 Silvano Bonazzola
C
C    This file is part of LORENE.
C
C    LORENE is free software; you can redistribute it and/or modify
C    it under the terms of the GNU General Public License as published by
C    the Free Software Foundation; either version 2 of the License, or
C    (at your option) any later version.
C
C    LORENE is distributed in the hope that it will be useful,
C    but WITHOUT ANY WARRANTY; without even the implied warranty of
C    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C    GNU General Public License for more details.
C
C    You should have received a copy of the GNU General Public License
C    along with LORENE; if not, write to the Free Software
C    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
C
C
	SUBROUTINE FCER3S(NDEG,NDR,NDT,NNN64,IN1,IPPP,C64,CC,CS,DENT,DEN)

	IMPLICIT double PRECISION (A-H,O-Z)

C
C## Version du 16/10/96: ligne 853, anullation de DEN pour LY=NY1
C
C		ROUTINE POUR LE CALCUL DES TRANSFORMEES DE FOURIER ET DE
C		CHEBYSHEV POUR L'ECHANTILLONNAGE REAREFIE' A 3 DIMENSIONS
C		EXPLOITANT OU NON LES SYMETRIES DES FONCTIONS A TRANSFORMER 
C		(SYMETRIES EXISTANTES PAR EX. EN COORDONNEES SPHERIQUES)
C	
C		LE 3EME INDICE EST SUPPOSE' ETRE PERIODIQUES (COORDONNE AZI-
C		MUTHALE FI), LE 2EME VARIE ENTRE 0 ET PI. DANS UN DEVELOPPE-
C		MENT EN COORDONNEES SPHERIQUES, LES COEFFICIENTS DE FOURIER
C		D'UNE FONCTION SCALAIRE SERONT DES FONCTIONS SYMETRIQUES EN
C	 	THETA SI LES COEFFICIENTS DE FOURIER SONT PAIRS ET ANTISYME-
C		TRIQUES SONT IMPAIRS. LE DEVELOPPEMENT EN THETA EST DONC EF-
C		FECTUE EN POLYNOMES DE CHEBYSHEV DU 1ER GENRE POUR LES FONC-
C		TIONS PAIRES ET DU 2EME GENRE (EN SERIE DE SINUS) POUR LES
C		FONCTIONS IMPAIRES. ANALOGUEMENT LES COEFFICIENTS CML(R)
C		SONT DES FONCTIONS SYMETRIQUES EN r SI m+l EST PAIRE ET ANTI-
C		SYMETRIQUES DANS LE CAS OPPOSE. PAR CONSEQUENT LE DEVELOPPE-
C		MENT EN r DES COEFFICIENTS Cml(r) EST EFFECTUE SUR L'INTER-
C		VALLE 0<R<1 EN TENANT COMPTE DE LA PARITE'. LA TRANSFORMATION 
C
C	N.B.	DOIT ETRE PAR CONSEQUENT ORDONNEE, C'EST A DIRE IL FAUT
C	---	D'ABORD PROCEDER A LA TRANSFORMATION DE FOURIER SUR LA
C		VARIABLE phi (3EME INDICE), PUIS A LA TRANSFORMATION EN theta 
C		(2EME INDICE) ET ENFIN LA TRANSFORMATION EN r (PEMIER INDICE).
C		CELA PEUT ETRE GENANT. LA ROUTINE FGER3S EVITE CET INCO-
C		VENIENT. DANS LE CAS OU IL EXISTENT DES SYMETRIES PAR
C		RAPPORT AU PLAN EQUATORIAL z=0 ET LA FONCTION EST INVARIANTE
C		PAR RAPPORT A LA TRANSFORMATION x,y -> -x,-y L'APPEL DE LA
C		ROUTINE NE NECESSITE PLUS D'ETRE ORDONNE.
C
C		LE STOCKAGE DES COEFFICIENTS DANS LE CAS GENERAL ET DANS LE
C		CAS OU SEULMENT LA SYMETRIE PAR RAPPORT AU PLAN Z=0 EXISTE
C		EST LE SUIVANT (CFR. LA ROUTINE FUCE3S).
C		DANS DEN(LR,LT,1) IL Y A LES COEFFICIENTS CORRESPONDANT A
C		LA FREQUENCE ZERO DU DEVELOPPEMENT EN COSINUS
C		DANS DEN(LR,LT,2),DEN(LR,LT,3) LES COFFICIENTS COSINUS ET
C		SINUS DE LA FREQUENCE 1, DANS DEN(LR,LT,4), DEN(LR,LT,5)
C		LES COEFFICIENTS DE LA FREQUENCE 2 ET AINSI DE SUITE.
C			 DEN(LR,1,LM),DEN(LR,3,LM)... DEN(LR,2*N+1,LM)  
C		SONT LES COEFFICIENTS DU DEVELOPPEMENT SUR LES POLYNOMES
C		DE CHEBYSHEV DU 1ER ORDRE. DEN(LR,2,LM),DEN(LR,4,LM)...
C		DEN(LR,2*N,LM) LES COEFFICIENTS DE CHEBYSHEV DU 2EME ORDRE.
C		DEN(1,LR,LM),DEN(3,LR,LM)... SONT LES COEFFICIENTS
C		DU DEVELOPPEMENT EN POLYNOMES DE CHEBYTCHEV DES FON-
C		CTIONS SYMETRIQUES EN R, ET DEN(2,LR,LM),DEN(4,LR,LM)...
C		DES FONCTIONS ANTISYMETRIQUES.	
C		
C		DANS LE CAS DE LA SUPERSYMETRIE LE STOCKAGE EST LE SUIVANT:
C		DANS DEN(LR,J,1) LA PARTIE EN COS(PHI) DANS DEN(LR,J,2*L)
C		LA PARTIE EN COS(2*PHI),COS(4*PHI)... DANS DEN(LR,J,2*L+1)
C		LA PARTIE EN SIN(2*PHI),SIN(4*PHI)...
C		
C		LE DOMAINE DE LA VARIABLE Z=-R*COS(THETA) EST [0,1] 
C		PI/2 < THETA < PI
C
C		ROUTINE COMPLETEMENT CRAYTINIZEE.
C
C		ROUTINE AYANT TESTE'E AVEC LE PROTOCOL USUEL LE JOUR
C		DU SEIGNEUR 4/2/1987.
C		UN TEST SUR LA VALIDITE DES DIMENSIONS LIMITES INFERIEURES
C		DES TABLEAUX A ETE EFFECTUE' LE 30/AOUT/1990.
C
C		TROUVEE COUILLE ET ELIMINEE' LE 31 AOUT 1990 (ITHC AU LIEU DE 
C               ITCH)
C		LA ROUTINE A ETE' MODIFIEE LE 28/12/1992. UN TEST AVEC LES
C		DIMENSIONS MINIMALES A ETE EFFECTUE' 
C
C		ARGUMENTS DE LA ROUTINE:
C
C			NDEG	=TABLEAU, NDEG(3) CONTENANT LES DEGRES
C				 DE LIBERTE DES TRANSFORMEES A EFFECTUER
C				 NDEG(1) CONCERNE LE PREMIER INDICE DE LA
C				 MATRICE, NDEG(2) LE 2EME INDICE, NDEG(3)
C				 LE 3EME INDICE DE LA MATRICE.
C				 NDEG DOIT IMPERATIVEMENT ETRE DE LA FORME
C				 2**M*3**P*5**Q POUR LES TRANSFORMEES DE
C				 FOURIER (M,P,Q NOMBRES ENTIERS) ET
C				 2**P*3**P*5*Q+1 POUR LES TRANSFORMEES DE
C				 CHEBYSHEV.
C
C		NDT,NDIMZ  =DIMENSIONS DU TABLEAU YY(LR,LY,LZ).
C		POUR DES RAISONS DE CRAYTINISATION NDT ET NDIMZ NE DOIVENT
C		PAS ETRE UN MULTIPLE DE 8.
C
C		NNN64	=PARAMETRE DE LA VECTORISATION, PAR EXEMPLE
C			 NNN64=64 SIGNIFIE QUE 64 FONCTIONS A TRANSFORMER
C			 SONT VECTORISEES.
C
C		IN1	=PARAMETRE, SI IN1=1 LA TRANSFORMEE EST
C			 EFFECTUEE SUR LE PREMIER INDICE, SI IN1=2 SUR LE
C			 DEUXIEME, SI IN1=3 SUR LE 3EME.
C
C			 IN1=1:
C		IPPP=0,1 AUCUNE SYMETRIE
C		IPPP=2,3 SYMETRIES PAR RAPPORT AU PLAN z=0 (SEULEMNT)
C			 CAS D'UNE FONCTION (SCALAIRE OU VECTORIELLE) SYM-
C			 METRIQUE PAR RAPPORT AU PLAN z=0:
C			 FONCTION SYMETRIQUE SCALAIRE IPPP=2
C			 FONCTION SYMETRIQUE VECTORIELLE IPPP=3
C			 FONCTION ANTI-SYMETRIQUE SCALAIRE IPPP=3
C			 FONCTION ANTI-SYMETRIQUE VECTORIELLE IPPP=2
C			 VECTORIEL SIGNIFIE LE GRADIENT D/DR OU D/DZ D'UNE
C			 FONCTION SCALAIRE. 
C			 DE MEME, IPPP DOIT ETRE = 3, DANS LE CAS D'UNE
C			 FONCTION SCALAIRE SYMETRIQUE MOULTIPLIEE OU DIVISEE
C			 PAR UNE PUISSANCE IMPAIRE DE r. IPPP=4 DANS LE CAS
C			 D'UNE FONCTION ANTISYMETRIQUE MULTIPLIEE OU DIVISEE
C			 PAR UNE PUISSANCE IMPAIRE DE r
C
C		IPPP=4,5 SYMETRIES PAR RAPPORT LE PLAN Z=0 ET INVARIANCE
C			 PAR RAPPORT LA REFLEXION X,Y -> -X,-Y (RESPECTIVEMENT
C			 CAS SCALAIRE ET CAS VECTORIEL) . VOIR PLUS HAUT CE
C			 QUE SIGNIFIE " VECTORIEL " DANS CE CAS "4,5" REMPLCENT
C			 LE "2 ET 3" DU CAS PRCEDENT
C
C			 IN1=2:
C		IPPP=20  LA FONCTION A TRANSFORMER EST SYMMETRIQUE PAR
C		         RAPPORT AU PLAN z=0 ET ELLE EST SCALAIRE.	
C		IPPP=21  LA FONCTION A TRANSFORMER EST SYMETRIQUE PAR
C			 RAPPORT AU PLAN z=0 ET ELLE EST VECTORIELLE,
C			 (PAR EXAMPLE UNE FONCTION SCALAIRE A LAQUELLE ON
C			 AURAIT APPLIQUE L'OPERATEUR 1/SIN(THETA)*D/DPHI)
C		IPPP=30,31 LA FONCTION EST ANTISYMETRIQUE PAR
C			 RAPPORT AU PLAN z=0 RESPECTIVEMENT SCALAIRE OU
C			 VECTORIELLE)	
C
C		IPPP=40,41 LA FONCTION EST SYMETRIQUE PAR RAPPORT
C			 AU PLAN z=0 ET PAR RAPPORT A LA TRANSFORMATION
C			 x,y -> -x,-y RESPECTIVEMENT SCALAIRE ET VECTORIELLE
C			 (VOIR PLUS HAUT LA SIGNIFICATION DE VECTORIEL)	
C		IPPP=50,51 LA FONCTION EST ANTISYMETRIQUE PAR RAPPORT
C			 AU PLAN z=0, ET SYMETRIQUE PAR RAPPORT A LA
C			 TRANSFORMATION x,y -> -x,-y (RESPECTIVEMENT
C			 SCALAIRE ET TENSORIELLE)	
C
C			 IN1=3:
C		IPPP ARBITRAIRE
C
C
C		C64,CC,CS=TABLEAUX DE TRAVAIL: DIMENSIONS MINIMES=
C			  (NNN64+1)*((MAX(NDEG(1),NDEG(2))+3)
C
C		DENT	=TABLEAU DE TRAVIL A 3 DIMENSIONS. DIMENSIONS
C			 MINIMES DE DENT NDEG(1),NDEG(2),NDEG(3)
C		DEN	=TABLEAU A 3 DIMENSIONS CONTENANT LA FONCTION
C			 A TRANSFORMER EN INPUT, ET LA TRANSFORMEE EN
C			 OUTPUT. 
C
C
C
C $Id: fcer3s.f,v 1.3 2012/03/30 12:12:43 j_novak Exp $
C $Log: fcer3s.f,v $
C Revision 1.3  2012/03/30 12:12:43  j_novak
C Cleaning of fortran files
C
C Revision 1.2  2009/12/01 08:45:21  j_novak
C Shortened a line to 72 characters.
C
C Revision 1.1.1.1  2001/11/20 15:19:30  e_gourgoulhon
C LORENE
C
c Revision 1.1  1997/10/23  08:11:21  eric
c Initial revision
c
C
C $Header: /cvsroot/Lorene/F77/Source/Poisson2d/fcer3s.f,v 1.3 2012/03/30 12:12:43 j_novak Exp $
C
C
	character*120 header
	data header/'$Header: /cvsroot/Lorene/F77/Source/Poisson2d/fcer3s.f,v 1.3 2012/03/30 12:12:43 j_novak Exp $'/


	DIMENSION NDEG1(3),DEN(NDR,NDT,*),C64(*),CC(*),CS(*),NDEG(*)
	DIMENSION DENT(NDR,NDT,*)

	DATA NCY,NCR,NCZ/0,0,0/
	DATA NEQ/0/

	SAVE NCY,NCR,NCZ,NEQ,NR,NZ,NY,NNN65,NN64Z,NN65Z,NR1Y1,MULTZ
	SAVE IRESTZ,N6Z,MULT1,IREEE2,II,I2,N64Z,N65Z,LYY1,LYY2,LDY
	SAVE IRR2Z,N6565Z,N365Z

	NR1=NDEG(1)
	NY1=NDEG(2)
	NZ1=NDEG(3)
C
C		INITIALISATION.
C
	IF (NCY.EQ.NY1.AND.NCZ.EQ.NZ1.AND.NCR.EQ.NR1.AND.NEQ.EQ.NNN64) GOTO 800
C
	NCR=NR1
	NCY=NY1
	NCZ=NZ1
	NEQ=NNN64
	NR=NR1-1
	NZ=NZ1-1
	NY=NY1-1
	NNN65=NNN64
	IF ((NNN64/8)*8.EQ.NNN64)NNN65=NNN64+1
C
C		PREPARATION DES ELEMENTS NECESSARES POUR LA TRANSFORMATION
C		DU 3EME INDICE DU TABLEAU
C
	NN64Z=NNN64
	NN65Z=NNN65
	NR1Y1=NR1*NY1
	MULTZ=(NR1Y1)/NN64Z
	IRESTZ=NR1Y1-MULTZ*NN64Z
C
C		OPTIMISATION DE NN64Z
C
	IF (MULTZ.GT.0.AND.NNN64.GT.NR1) THEN
	N6Z=(NNN64/NR1)*NR1
	MULT1=NR1Y1/N6Z
	IREEE2=NR1Y1-MULT1*N6Z
	II=0
	I2=0
	IF (IRESTZ.GT.0)II=1
	IF (IREEE2.GT.0)I2=1
	IF (MULT1+I2.LE.MULTZ+II) THEN
	MULTZ=MULT1
	NN64Z=N6Z
	NN65Z=NN64Z
	IF ((NN64Z/8)*8.EQ.NN64Z)NN65Z=NN64Z+1
	IRESTZ=IREEE2
	ENDIF
	ENDIF
C
	IF (MULTZ.EQ.0) THEN
	NN64Z=NR1Y1
	NN65Z=NN64Z
	IF ((NN64Z/8)*8.EQ.NN64Z)NN65Z=NN64Z+1
	MULTZ=1
	IRESTZ=0
	ENDIF
C
	IF (IRESTZ.GT.0) THEN
	N64Z=IRESTZ
	N65Z=N64Z
	IF ((N64Z/8)*8.EQ.N64Z)N65Z=N64Z+1	
	ENDIF
C
	LYY1=1
	LYY2=NN64Z/NR1
	LDY=LYY2-LYY1
	IRR2Z=NN64Z-(NN64Z/NR1)*NR1
	N6565Z=NN65Z+NN65Z
	N365Z=N6565Z+NN65Z
C
 800	CONTINUE
C
	IMP=0
	IMPP=IPPP
	IF (IMPP.GT.10) IMPP=IPPP/10
	IF ((IMPP/2)*2.NE.IMPP) IMP=1
C
	NDEG1(1)=NDEG(1)
	NDEG1(2)=NDEG(3)
C
C
C111111111111111111111111111111111111111111111111111111111111111111111111111
C111111111111111111111111111111111111111111111111111111111111111111111111111
C
C	TRANSFORMATION DU PREMIER INDICE.

C
	IF (IN1.EQ.1) THEN
	IF (IMPP.LE.1) THEN
C
C		TERMES PAIRS EN r.
	DO 2 LZ=1,NZ1
	LY1=0	
	DO 1 LY=1,NY1,2
	LY1=LY1+1
	DO 3 LR=1,NR1
	DENT(LR,LY1,LZ)=DEN(LR,LY,LZ)
  3	CONTINUE
  1	CONTINUE
  2	CONTINUE
C
	NDEG1(2)=NY1/2+1
	NDEG1(3)=NZ1
	ITCH=0
C
	IF (IMP.EQ.1) ITCH=1
	CALL CERX3S(NDEG1,NDR,NDT,NNN64,ITCH,C64,CC,CS,DENT)
C
C		LES COEFFICIENTS SONT STOCKES DAN DEN(LR,LT,LM).
C
	DO 5 LZ=1,NZ1
	LY1=0
	DO 4 LY=1,NY1,2
	LY1=LY1+1
	DO 6 LR=1,NR1
	DEN(LR,LY,LZ)=DENT(LR,LY1,LZ)
  6	CONTINUE
  4	CONTINUE
  5	CONTINUE
C
	DO 8 LZ=1,NZ1
	LY1=0
	DO 7 LY=2,NY1,2
	LY1=LY1+1
	DO 9 LR=1,NR1
	DENT(LR,LY1,LZ)=DEN(LR,LY,LZ)
  9	CONTINUE
  7	CONTINUE
  8	CONTINUE
C
	ITCH=1	
	IF (IMP.EQ.1) ITCH=0
	NDEG1(2)=LY1
	NDEG1(3)=NZ1
C
C		TRANSFORMATION DE LA PARTIE ANTISYMETRIQUE,
C
	CALL CERX3S(NDEG1,NDR,NDT,NNN64,ITCH,C64,CC,CS,DENT)
C
C		LES COEFFICIENTS SONT STOCKES DANS DEN(LR,LT,LM)
C
	DO 11 LZ=1,NZ1
	LY1=0
	DO 10 LY=2,NY1,2
	LY1=LY1+1
	DO 12 LR=1,NR1
	DEN(LR,LY,LZ)=DENT(LR,LY1,LZ)
  12	CONTINUE
  10	CONTINUE
  11	CONTINUE
C
	RETURN
	ENDIF
C
C IN1=1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.1
C
C		CAS AVEC SYMETRIE PAR RAPPORT AU PLAN z=0
C
	IF (IMPP.EQ.2.OR.IMPP.EQ.3) THEN
	IMP=1
	IF ((IMPP/2)*2.EQ.IMPP) IMP=0
C
C		TRANSFORMATION PARTIE PAIRE
C
	DO LY=1,NY1
	DO LR=1,NR1
	DENT(LR,LY,1)=DEN(LR,LY,1)
	ENDDO
	ENDDO
C
	LZ1=1
	IF (NZ1.GT.1) THEN
	DO LZ=4,NZ1,4
	LZ2=MIN0(LZ+1,NZ1)
	DO J=LZ,LZ2
	LZ1=LZ1+1
	DO LY=1,NY1 
	DO LR=1,NR1
	DENT(LR,LY,LZ1)=DEN(LR,LY,J)
	ENDDO
	ENDDO
	ENDDO
	ENDDO
	ENDIF
C
	NDEG1(1)=NR1
	NDEG1(2)=NY1
	NDEG1(3)=LZ1
	ITCH=1
	IF (IMP.EQ.0) ITCH=0
C
	CALL CERX3S(NDEG1,NDR,NDT,NNN64,ITCH,C64,CC,CS,DENT)
C
	DO LY=1,NY1
	DO LR=1,NR1
	DEN(LR,LY,1)=DENT(LR,LY,1)
	ENDDO
	ENDDO
	IF (NZ1.EQ.1) RETURN
C	
	LZ2=1
	DO LZ=4,NZ1,4
	LZ1=MIN0(LZ+1,NZ1)
	DO J=LZ,LZ1
	LZ2=LZ2+1
	DO LY=1,NY1 
	DO LR=1,NR1
	DEN(LR,LY,J)=DENT(LR,LY,LZ2)
	ENDDO
	ENDDO
	ENDDO
	ENDDO
C
C		PARTIE ANTISYMETRIQUE EN r
C
	LZ2=0
	DO LZ=2,NZ1,4
	LZ1=MIN0(LZ+1,NZ1)
	DO J=LZ,LZ1
	LZ2=LZ2+1
	DO LY=1,NY1 
	DO LR=1,NR1
	DENT(LR,LY,LZ2)=DEN(LR,LY,J)
	ENDDO
	ENDDO
	ENDDO
	ENDDO
C
	NDEG1(3)=LZ2
	ITCH=0
	IF (IMP.EQ.0) ITCH=1
C
	CALL CERX3S(NDEG1,NDR,NDT,NNN64,ITCH,C64,CC,CS,DENT)
C
	LZ2=0
	DO LZ=2,NZ1,4
	LZ1=MIN0(LZ+1,NZ1)
	DO J=LZ,LZ1
	LZ2=LZ2+1
	DO LY=1,NY1 
	DO LR=1,NR1
	DEN(LR,LY,J)=DENT(LR,LY,LZ2)
	ENDDO
	ENDDO
	ENDDO
	ENDDO
C
	RETURN
	ENDIF
C
C^1^1^1^1^1^1^1^1^1^1^1^1^1^1^1^1^1^1^1^1^1^1^1^1^1^1^1^1^1^1^1^1^1^1^1^1^1^1
C
C		CAS SUPERSYMETRIQUE: IN1=1
C
	IF (IMPP.GE.4) THEN

	IMP=1
	IF ((IPPP/2)*2.EQ.IPPP) IMP=0
	NDEG1(1)=NR1
	NDEG1(2)=NY1
	NDEG1(3)=NZ1
	ITCH=1
	IF (IMP.EQ.0) ITCH=0
	CALL CERX3S(NDEG1,NDR,NDT,NNN64,ITCH,C64,CC,CS,DEN)
	RETURN
	ENDIF

		ENDIF

C2222222222222222222222222222222222222222222222222222222222222222222222222222
C2222222222222222222222222222222222222222222222222222222222222222222222222222
C
C		TRANSFORMATION DU 2EME COEFFICIENT.
C
C
	NDEG1(1)=NDEG(1)
	NDEG1(2)=NDEG(2)
C
	NY11=NY1+1
		IF (IN1.EQ.2) THEN
C
	IF (IMPP.LE.1) THEN
C
C		SI IMP=0 DEVELOPPEMENT EN POLYNOMES DE CHEBYSHEV DU 1ER TYPE
C		SI IMP=1 DEVELOPPEMENT EN POLYNOMES DE CHEBYSHEV DU 2EME TYPE
C
	DO 100 LY=1,NY1
	DO 101 LR=1,NR1
	DENT(LR,LY,1)=DEN(LR,LY,1)
  101	CONTINUE
  100	CONTINUE
C
	JZT=1
		IF (NZ1.GT.1) THEN
	DO 102 LZ=4,NZ1,4
	LZ2=MIN0(LZ+1,NZ1)
	DO 105 J=LZ,LZ2
	JZT=JZT+1
	DO 103 LY=1,NY1
	DO 104 LR=1,NR1
	DENT(LR,LY,JZT)=DEN(LR,LY,J)
  104	CONTINUE
  103	CONTINUE
  105	CONTINUE
  102	CONTINUE
C
	ENDIF
C
	NDEG1(3)=JZT
C
	ITCH=1
	IF (IMP.EQ.1) ITCH=2
	CALL CEY23S(NDEG1,NDR,NDT,NNN64,ITCH,C64,CC,CS,DENT)
C
C		LES COEFFICIENTS SONT STOCKES DANS DEN(LR,LT,LM).
C
	DO 107 LY=1,NY1
	DO 108 LR=1,NR1
	DEN(LR,LY,1)=DENT(LR,LY,1)
  108	CONTINUE
  107	CONTINUE
C
		IF (NZ1.EQ.1) RETURN
	JZT=1
	DO 109 LZ=4,NZ1,4
	LZ2=MIN0(LZ+1,NZ1)
	DO 112 J=LZ,LZ2
	JZT=JZT+1
       	DO 110 LY=1,NY1
        DO 111 LR=1,NR1
	DEN(LR,LY,J)=DENT(LR,LY,JZT)
  111	CONTINUE
  110	CONTINUE
  112   CONTINUE
  109	CONTINUE
C
C		DEVELOPPEMENT EN POLYNOMES DE CHEBYSHEV DU 2EME TYPE
C
	JZT=0
	DO 114 LZ=2,NZ1,4
	LZ2=MIN0(LZ+1,NZ1)
	DO 117 J=LZ,LZ2
	JZT=JZT+1
	DO 115 LY=1,NY1
	DO 116 LR=1,NR1
	DENT(LR,LY,JZT)=DEN(LR,LY,J)
  116	CONTINUE   
  115	CONTINUE   
  117	CONTINUE   
  114	CONTINUE   
C
	NDEG1(3)=JZT
	ITCH=2
	IF (IMP.EQ.1) ITCH=1
	CALL CEY23S(NDEG1,NDR,NDT,NNN64,ITCH,C64,CC,CS,DENT)
C
C		LE COEFFICIENTS SONT STOCKES DANS DEN(LR,LT,LM)
C
	JZT=0
	DO 119 LZ=2,NZ1,4
	LZ2=MIN0(LZ+1,NZ1)
	DO 122 J=LZ,LZ2
	JZT=JZT+1
	DO 120 LY=1,NY1
	DO 121 LR=1,NR1
	DEN(LR,LY,J)=DENT(LR,LY,JZT)
  121	CONTINUE   
  120	CONTINUE   
  122	CONTINUE   
  119	CONTINUE   
C
	RETURN
	ENDIF
C
C.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2
C
C		TRANSFORMATION DANS LE CAS OU IL Y A LA SYMETRIE PAR RAPPORT
C		AU PLAN z=0
C
	NY11=NY1+1
	IF (IMPP.EQ.2) THEN
C
	ITCH=0
	NDEG1(1)=NR1
	NDEG1(2)=NY1
C
	DO LY=1,NY1
	LY1=NY11-LY
	DO LR=1,NR1
C	DENT(LY1,LR,1)=DEN(LR,LY,1)
	DENT(LR,LY1,1)=DEN(LR,LY,1)
	ENDDO
	ENDDO
	LZ1=1
C
	IF (NZ1.GT.1) THEN
	DO LZ=4,NZ1,4
	DO J=LZ,MIN0(LZ+1,NZ1)
	LZ1=LZ1+1
	DO LY=1,NY1
	LY1=NY11-LY
	DO LR=1,NR1
C	DENT(LY,LR,LZ1)=DEN(LR,LY1,J)
	DENT(LR,LY,LZ1)=DEN(LR,LY1,J)
	ENDDO
	ENDDO
	ENDDO
	ENDDO
	ENDIF
C
	ITCH=0
	IF (IPPP.EQ.21) ITCH=1
	NDEG1(3)=LZ1
C
C	CALL CERY3S(NDEG1,NDR,NDT,NNN64,ITCH,C64,CC,CS,DENT)
	CALL CETY3S(NDEG1,NDR,NDT,NNN64,ITCH,C64,CC,CS,DENT)
C
	DO LY=1,NY1
	DO LR=1,NR1
C	DEN(LR,LY,1)=DENT(LY,LR,1)
	DEN(LR,LY,1)=DENT(LR,LY,1)
	ENDDO
	ENDDO
	IF (NZ1.EQ.1) RETURN
C
	LZ1=1
	DO LZ=4,NZ1,4
	DO J=LZ,MIN0(LZ+1,NZ1)
	LZ1=LZ1+1
	DO LY=1,NY1
	DO LR=1,NR1
C	DEN(LR,LY,J)=DENT(LY,LR,LZ1)
	DEN(LR,LY,J)=DENT(LR,LY,LZ1)
	ENDDO
	ENDDO
	ENDDO
	ENDDO
C
	LZ1=0
	DO LZ=2,NZ1,4
	DO J=LZ,MIN0(LZ+1,NZ1)
	LZ1=LZ1+1
	DO LY=1,NY1
	LY1=NY11-LY
	DO LR=1,NR1
C	DENT(LY1,LR,LZ1)=DEN(LR,LY,J)
	DENT(LR,LY1,LZ1)=DEN(LR,LY,J)
	ENDDO
	ENDDO
	ENDDO
	ENDDO
C
	NDEG1(3)=LZ1
	ITCH=1
	IF (IPPP.EQ.21) ITCH=0
C
C	CALL CERY3S(NDEG1,NDR,NDT,NNN64,ITCH,C64,CC,CS,DENT)
	CALL CETY3S(NDEG1,NDR,NDT,NNN64,ITCH,C64,CC,CS,DENT)
C
	LZ1=0
	DO LZ=2,NZ1,4
	DO J=LZ,MIN0(LZ+1,NZ1)
	LZ1=LZ1+1
	DO LY=1,NY1
	DO LR=1,NR1
C	DEN(LR,LY,J)=DENT(LY,LR,LZ1)
	DEN(LR,LY,J)=DENT(LR,LY,LZ1)
	ENDDO
	ENDDO
	ENDDO
	ENDDO
C
	RETURN
	ENDIF
C
	IF (IPPP.EQ.30) THEN
	ITCH=1
C
	DO LY=1,NY1
	DO LR=1,NR1
C	DENT(LY,LR,1)=DEN(LR,LY,1)
	DENT(LR,LY,1)=DEN(LR,LY,1)
	ENDDO
	ENDDO
	LZ1=1
C
	IF (NZ1.GT.1) THEN
	DO LZ=4,NZ1,4
	DO J=LZ,MIN0(LZ+1,NZ1)
	LZ1=LZ1+1
	DO LY=1,NY1
	DO LR=1,NR1
C	DENT(LY,LR,LZ1)=DEN(LR,LY,J)
	DENT(LR,LY,LZ1)=DEN(LR,LY,J)
	ENDDO
	ENDDO
	ENDDO
	ENDDO
C
	ENDIF
C
	NDEG1(3)=LZ1
C
	ITCH=1
C	CALL CERY3S(NDEG1,NDR,NDT,NNN64,ITCH,C64,CC,CS,DENT)
	CALL CETY3S(NDEG1,NDR,NDT,NNN64,ITCH,C64,CC,CS,DENT)
C
C	DO LR=1,NR1
C	DO LY=1,NY1
C	DEN(LR,LY,1)=DENT(LY,LR,1)
C	ENDDO
C	ENDDO
C
	DO LY=1,NY1
	DO LR=1,NR1
	DEN(LR,LY,1)=DENT(LR,LY,1)
	ENDDO
	ENDDO
C
	IF (NZ1.EQ.1) RETURN
C
	IF (NZ1.GT.1) THEN
	LZ1=1
	DO LZ=4,NZ1,4
	DO J=LZ,MIN0(LZ+1,NZ1)
	LZ1=LZ1+1
	DO LY=1,NY1
	DO LR=1,NR1
C	DEN(LR,LY,J)=DENT(LY,LR,LZ1)
	DEN(LR,LY,J)=DENT(LR,LY,LZ1)
	ENDDO
	ENDDO
	ENDDO
	ENDDO
C
	LZ1=0
	DO LZ=2,NZ1,4
	DO J=LZ,MIN0(LZ+1,NZ1)
	LZ1=LZ1+1
	DO LY=1,NY1
	DO LR=1,NR1
	DENT(LR,LY,LZ1)=DEN(LR,LY,J)
	ENDDO
	ENDDO
	ENDDO
	ENDDO
C
	NDEG1(3)=LZ1
C
	ITCH=2
	CALL CEY23S(NDEG1,NDR,NDT,NNN64,ITCH,C64,CC,CS,DENT)
C
	LZ1=0
	DO LZ=2,NZ1,4
	DO J=LZ,MIN0(LZ+1,NZ1)
	LZ1=LZ1+1
	DO LY=1,NY1
	DO LR=1,NR1
	DEN(LR,LY,J)=DENT(LR,LY,LZ1)
	ENDDO
	ENDDO
	ENDDO
	ENDDO
C
	RETURN
C
	ENDIF
	ENDIF
C
C		CAS VECTORIEL IPPP=31
C
	IF (IPPP.EQ.31) THEN
	ITCH=1
C
	DO LY=1,NY1
	DO LR=1,NR1
	DENT(LR,LY,1)=DEN(LR,LY,1)
	ENDDO
	ENDDO
	LZ1=1
C
	IF (NZ1.GT.1) THEN
	DO LZ=4,NZ1,4
	DO J=LZ,MIN0(LZ+1,NZ1)
	LZ1=LZ1+1
	DO LY=1,NY1
	DO LR=1,NR1
	DENT(LR,LY,LZ1)=DEN(LR,LY,J)
	ENDDO
	ENDDO
	ENDDO
	ENDDO
C
	ENDIF
C
	NDEG1(3)=LZ1
C
	ITCH=2
	CALL CEY23S(NDEG1,NDR,NDT,NNN64,ITCH,C64,CC,CS,DENT)
C
	DO LY=1,NY1
	DO LR=1,NR1
	DEN(LR,LY,1)=DENT(LR,LY,1)
	ENDDO
	ENDDO
C
	IF (NZ1.EQ.1) RETURN
C
	IF (NZ1.GT.1) THEN
	LZ1=1
	DO LZ=4,NZ1,4
	DO J=LZ,MIN0(LZ+1,NZ1)
	LZ1=LZ1+1
	DO LY=1,NY1
	DO LR=1,NR1
	DEN(LR,LY,J)=DENT(LR,LY,LZ1)
	ENDDO
	ENDDO
	ENDDO
	ENDDO
C
	LZ1=0
	DO LZ=2,NZ1,4
	DO J=LZ,MIN0(LZ+1,NZ1)
	LZ1=LZ1+1
	DO LY=1,NY1
	DO LR=1,NR1
C	DENT(LY,LR,LZ1)=DEN(LR,LY,J)
	DENT(LR,LY,LZ1)=DEN(LR,LY,J)
	ENDDO
	ENDDO
	ENDDO
	ENDDO
C
	ITCH=1
	NDEG1(3)=LZ1
C
C	CALL CERY3S(NDEG1,NDR,NDT,NNN64,ITCH,C64,CC,CS,DENT)
	CALL CETY3S(NDEG1,NDR,NDT,NNN64,ITCH,C64,CC,CS,DENT)
C
	LZ1=0
	DO LZ=2,NZ1,4
	DO J=LZ,MIN0(LZ+1,NZ1)
	LZ1=LZ1+1
	DO LY=1,NY1
	DO LR=1,NR1
	DEN(LR,LY,J)=DENT(LR,LY,LZ1)
	ENDDO
	ENDDO
	ENDDO
	ENDDO
C
	RETURN
C
	ENDIF
	ENDIF
C
C^2^2^2^2^2^2^2^2^2^2^2^2^2^2^2^2^2^2^2^2^2^2^2^2^2^2^2^2^2^2^2^2^2^2^2^2^2^2
C
C		CAS OU IL-Y-A UNE SYMETRIE PAR RAPPORT AU PLAN z=0
C		ET PAR RAPPORT LA TRANSFORMATION x,y -> -x,-y
C
	IF (IPPP.EQ.40.OR.IPPP.EQ.41) THEN
	ITCH=0
	NDEG1(3)=NZ1
C
	DO 260 LZ=1,NZ1
	DO 261 LY=1,NY1
	LY1=NY11-LY
	DO 262 LR=1,NR1
C	DENT(LY,LR,LZ)=DEN(LR,LY1,LZ)
	DENT(LR,LY,LZ)=DEN(LR,LY1,LZ)
  262	CONTINUE
  261	CONTINUE
  260	CONTINUE
C
	ITCH=1
	IF (IPPP.EQ.40) ITCH=0
C	CALL CERY3S(NDEG1,NDR,NDT,NNN64,ITCH,C64,CC,CS,DENT)
	CALL CETY3S(NDEG1,NDR,NDT,NNN64,ITCH,C64,CC,CS,DENT)
C
	DO 263 LZ=1,NZ1
	DO 265 LY=1,NY1
	DO 264 LR=1,NR1
	DEN(LR,LY,LZ)=DENT(LR,LY,LZ)
  264	CONTINUE
  265	CONTINUE
  263	CONTINUE
C
	IF (IPPP.EQ.41.OR.IPPP.EQ.51) THEN
	DO LZ=1,NZ1
	DO LR=1,NR1
	DEN(LR,NY1,LZ)=0
	ENDDO
	ENDDO
	ENDIF
C	
	RETURN 
	ENDIF		
C
	IF (IPPP.EQ.50) THEN
C
	DO 266 LZ=1,NZ1
	DO 267 LY=1,NY1
	DO 268 LR=1,NR1
C	DENT(LY,LR,LZ)=DEN(LR,LY,LZ)
	DENT(LR,LY,LZ)=DEN(LR,LY,LZ)
  268	CONTINUE
  267	CONTINUE
  266	CONTINUE
C
	NDEG1(3)=NZ1
C
	ITCH=1
C	CALL CERY3S(NDEG1,NDR,NDT,NNN64,ITCH,C64,CC,CS,DENT)
	CALL CETY3S(NDEG1,NDR,NDT,NNN64,ITCH,C64,CC,CS,DENT)
C
	DO 269 LZ=1,NZ1
	DO 270 LY=1,NY1
	DO 271 LR=1,NR1
	DEN(LR,LY,LZ)=DENT(LR,LY,LZ)
  271	CONTINUE
  270	CONTINUE
  269	CONTINUE
C
	RETURN
	ENDIF
	IF (IPPP.EQ.51) THEN
C
	ITCH=2
C	
	CALL CEY23S(NDEG,NDR,NDT,NNN64,ITCH,C64,CC,CS,DEN)
C
	RETURN
	ENDIF
	ENDIF
C
C33333333333333333333333333333333333333333333333333333333333333333333333333333
C33333333333333333333333333333333333333333333333333333333333333333333333333333
C 
		IF (IN1.EQ.3) THEN
C
		IF (NZ1.LT.2) RETURN
	IF (IRR2Z.EQ.0) THEN
C
C		ON EFFECTUE LA TRANSFORMATION DANS LE CAS N64Z MULTIPLE DE NR1
C
	LY1=LYY1
	LY2=LYY2
C
	DO 217 LMU=1,MULTZ
	JZ=0
	DO  202 LZ=1,NZ1
	JY=JZ	
	DO 200 LY=LY1,LY2
	DO 201 LR=1,NR1
	C64(LR+JY)=DEN(LR,LY,LZ)
 201	CONTINUE                        
	JY=JY+NR1
 200	CONTINUE                        
	JZ=JZ+NN65Z
 202	CONTINUE                        
C
	CALL TFMZS(NZ1,NN64Z,C64,CC)
C
C		ON STOCKE LES COEFFICIENTS DE LA TRANSFORMATION DANS 
C		DEN(LR,LY,LZ)
C
	JZ=0
	DO 205 LZ=1,2
	JY=JZ	
	DO 203 LY=LY1,LY2
	DO 204 LR=1,NR1
	DEN(LR,LY,LZ)=CC(LR+JY)
 204	CONTINUE                        
	JY=JY+NR1
 203	CONTINUE                        
	JZ=JZ+N6565Z
 205	CONTINUE                        
C
	DO 209 LZ=4,NZ1,2
	JY=JZ	
	DO 206 LY=LY1,LY2
	DO 207 LR=1,NR1
	DEN(LR,LY,LZ)=CC(LR+JY)
 207	CONTINUE                        
	JY=JY+NR1
 206	CONTINUE                        
	JZ=JZ+N6565Z
 209	CONTINUE                        
C	
	JZ=N365Z
	DO 212 LZ=3,NZ1,2
	JY=JZ
	DO 210 LY=LY1,LY2
	DO 211 LR=1,NR1
	DEN(LR,LY,LZ)=CC(LR+JY)
 211	CONTINUE                        
	JY=JY+NR1
 210	CONTINUE                        
	JZ=JZ+N6565Z
 212	CONTINUE                        
C
	LY1=LY2+1
	LY2=LY1+LDY
 217	CONTINUE                        
		IF (IRESTZ.EQ.0)RETURN
C
C		LE CALCUL EST CONTINUE SI NR1*NY1 N'EST PAS UN MULTIPLE
C		DE N64Z
C
	IF (IRESTZ.GT.0) THEN
	N265=N65Z+N65Z
	JZ=0
	DO 238 LZ=1,NZ1
	JY=JZ
	DO 218 LY=LY1,NY1
	DO 219 LR=1,NR1
	C64(LR+JY)=DEN(LR,LY,LZ)
 219	CONTINUE                        
	JY=JY+NR1
 218	CONTINUE                        
	JZ=JZ+N65Z
 238	CONTINUE                        
C
	CALL TFMZS(NZ1,N64Z,C64,CC)
C
C		ON REINTRODUIT LES COEFF. DE FOURIER DANS DEN(LR,LY,LZ)
C
	JZ=0
	DO 222 LZ=1,2
	JY=JZ	
	DO 220 LY=LY1,NY1
	DO 221 LR=1,NR1
	DEN(LR,LY,LZ)=CC(LR+JY)
 221	CONTINUE                        
	JY=JY+NR1
 220	CONTINUE                        
	JZ=JZ+N265
 222	CONTINUE                        
C
	DO 225 LZ=4,NZ1,2
	JY=JZ	
	DO 223 LY=LY1,NY1
	DO 224 LR=1,NR1
	DEN(LR,LY,LZ)=CC(LR+JY)
 224	CONTINUE                        
	JY=JY+NR1
 223	CONTINUE                        
	JZ=JZ+N265
 225	CONTINUE                        
C	
	JZ=N265+N65Z
	DO 228 LZ=3,NZ1,2
	JY=JZ
	DO 226 LY=LY1,NY1
	DO 227 LR=1,NR1
	DEN(LR,LY,LZ)=CC(LR+JY)
 227	CONTINUE                        
	JY=JY+NR1
 226	CONTINUE                        
	JZ=JZ+N265
 228	CONTINUE                        
C
C
	ENDIF
	RETURN
	ENDIF
C
C		CALCUL DE LA TF DANS LE CAS OU N64Z N'EST PAS UN MULTIPLE DE 
C		NR1
C
	IF (IRR2Z.GT.0) THEN
C		
	NR64Z=NN64Z
	N63R=NR1-NR64Z+1
	NR65Z=NN65Z
	MU2=NR64Z
	LY1=1
	LR1=1
	LRR=1
C
	DO 289 LM=1,MULTZ
	IF (LRR.GT.NR1) LRR=1
	LRR1=0
	LY1=(MU2-NR64Z)/NR1+1
	LY2=.99999+FLOAT(MU2)/NR1
	LR1=+MU2+N63R-LY1*NR1
	LR2=MU2-(LY2-1)*NR1
 	JZ=0
C
	DO 237 LZ=1,NZ1
	JJY=JZ
	IF (LY2.GT.LY1) THEN
	JY=JZ-LRR+1
C
	DO 232 LR=LRR,NR1
	C64(LR+JY)=DEN(LR,LY1,LZ)
 232	CONTINUE         
	JJY=NR1+JY
	LRR1=1
	ENDIF
C
	IF (LY2.GT.LY1+1) THEN
	JY=JJY
	DO 233 LY=LY1+1,LY2-1
	DO 234 LR=1,NR1
	C64(LR+JY)=DEN(LR,LY,LZ)
 234	CONTINUE         
	JY=JY+NR1
 233	CONTINUE         
	JJY=JY
	ENDIF
C
	IF (LR2.GE.LR1.OR.LRR1.EQ.1) THEN
C
	IF (LRR1.EQ.0) THEN
	JY=JJY+1-LR1
	DO 235 LR=LR1,LR2
	C64(LR+JY)=DEN(LR,LY2,LZ)
 235	CONTINUE         
	ENDIF
	IF (LRR1.EQ.1) THEN
	JY=JJY
	DO 236 LR=1,LR2
	C64(LR+JY)=DEN(LR,LY2,LZ)
 236	CONTINUE         
	ENDIF
C
	LSR=LR2+1
	ENDIF
	JZ=JZ+NR65Z
 237	CONTINUE         
C
	CALL TFMZS(NZ1,NR64Z,C64,CC)

C		LES VALEURS CALCLCULEES PAR TFMZS SONT MEMORISEES DANS 
C		DEN(LR,LY,LZ)
C
 	JZ=0
	N265=NR65Z+NR65Z
C
	DO 244 LZ=1,2
	JJY=JZ
	IF (LY2.GT.LY1) THEN
C
	JY=JZ-LRR+1
	DO 239 LR=LRR,NR1
	DEN(LR,LY1,LZ)=CC(LR+JY)
 239	CONTINUE
	JJY=NR1+JY
	LRR1=1
	ENDIF
C
	IF (LY2.GT.LY1+1) THEN
	JY=JJY
	DO 240 LY=LY1+1,LY2-1
	DO 241 LR=1,NR1
	DEN(LR,LY,LZ)=CC(LR+JY)
 241	CONTINUE                  
	JY=JY+NR1
 240	CONTINUE                  
	JJY=JY
	ENDIF
C
	IF (LR2.GE.LR1.OR.LRR1.EQ.1) THEN
	IF (LRR1.EQ.0) THEN
	JY=JJY+1-LR1
	DO 242 LR=LR1,LR2
	DEN(LR,LY2,LZ)=CC(LR+JY)
 242	CONTINUE                  
	ENDIF
C
	IF (LRR1.EQ.1) THEN
	JY=JJY
	DO 243 LR=1,LR2
	DEN(LR,LY2,LZ)=CC(LR+JY)
 243	CONTINUE                  
	ENDIF
C
	LSR=LR2+1
	ENDIF
 	JZ=JZ+N265
 244	CONTINUE                  
C
	DO 250 LZ=4,NZ1,2
	JJY=JZ
	IF (LY2.GT.LY1) THEN
C
	JY=JZ-LRR+1
	DO 245 LR=LRR,NR1
	DEN(LR,LY1,LZ)=CC(LR+JY)
 245	CONTINUE                  
	JJY=NR1+JY
	LRR1=1
	ENDIF
C
	IF (LY2.GT.LY1+1) THEN
	JY=JJY
	DO 246 LY=LY1+1,LY2-1
	DO 247 LR=1,NR1
	DEN(LR,LY,LZ)=CC(LR+JY)
 247	CONTINUE                  
	JY=JY+NR1
 246	CONTINUE
	JJY=JY
	ENDIF
C
	IF (LR2.GE.LR1.OR.LRR1.EQ.1) THEN
	IF (LRR1.EQ.0) THEN
	JY=JJY+1-LR1
	DO 248 LR=LR1,LR2
	DEN(LR,LY2,LZ)=CC(LR+JY)
 248	CONTINUE                  
	ENDIF
C
	IF (LRR1.EQ.1) THEN
	JY=JJY
	DO 249 LR=1,LR2
	DEN(LR,LY2,LZ)=CC(LR+JY)
 249	CONTINUE                  
	ENDIF
C
	LSR=LR2+1
	ENDIF
	JZ=JZ+N265
 250	CONTINUE                  
C
	JZ=N265+NR65Z
	DO 256 LZ=3,NZ1,2
	JJY=JZ
	IF (LY2.GT.LY1) THEN
C
	JY=JZ-LRR+1
	DO 251 LR=LRR,NR1
	DEN(LR,LY1,LZ)=CC(LR+JY)
 251	CONTINUE                     
	JJY=NR1+JY
	LRR1=1
	ENDIF
C
	IF (LY2.GT.LY1+1) THEN
	JY=JJY
	DO 252 LY=LY1+1,LY2-1
	DO 253 LR=1,NR1
	DEN(LR,LY,LZ)=CC(LR+JY)
 253	CONTINUE                     
	JY=JY+NR1
 252	CONTINUE                     
	JJY=JY
	ENDIF
C
	IF (LR2.GE.LR1.OR.LRR1.EQ.1) THEN
	IF (LRR1.EQ.0) THEN
	JY=JJY+1-LR1
	DO 254 LR=LR1,LR2
 	DEN(LR,LY2,LZ)=CC(LR+JY)
 254	CONTINUE                     
	ENDIF
C
	IF (LRR1.EQ.1) THEN
	JY=JJY
	DO 255 LR=1,LR2
	DEN(LR,LY2,LZ)=CC(LR+JY)
 255	CONTINUE                     
	ENDIF
C
	LSR=LR2+1
	ENDIF
	JZ=JZ+N265
  256	CONTINUE                     
C
	LRR=LSR	
C
	MU2=MU2+NR64Z
 289	CONTINUE
	ENDIF
C
	IF (IRESTZ.EQ.0) RETURN
	JZ=0
	LR1=LRR
	LY1=LY2
	LY3=LY2
	IF (LRR.GT.NR1) THEN
	LR1=1
	LY3=LY2+1
	ENDIF
	NR64Z=IRESTZ
	NR65Z=NR64Z
	IF ((NR64Z/8)*8.EQ.NR64Z)NR65Z=NR64Z+1
	N265=NR65Z+NR65Z
	JZ=-LR1+1
C
	DO 293 LZ=1,NZ1
C
	JY=JZ
	IF (LRR.LE.NR1) THEN
	DO 290 LR=LR1,NR1
	C64(LR+JY)=DEN(LR,LY2,LZ)
 290	CONTINUE          
	LY3=1+LY2
	JY=JY+NR1
	ENDIF
C
	IF (LY3.LE.NY1) THEN
	DO 291 LY=LY3,NY1
	DO 292 LR=1,NR1
	C64(LR+JY)=DEN(LR,LY,LZ)
 292	CONTINUE          
	JY=JY+NR1
 291	CONTINUE          
	ENDIF  
	JZ=JZ+NR65Z
 293	CONTINUE          
C	
	CALL TFMZS(NZ1,NR64Z,C64,CC)
C		
C		ON STOCKES LES COEFFICIENTS DE FOURIER DANS DEN(LR,LY,LZ)
C
	JZ=-LR1+1
	DO 297 LZ=1,2
	JY=JZ
	IF (LRR.LE.NR1) THEN
	DO 294 LR=LR1,NR1
	DEN(LR,LY2,LZ)=CC(LR+JY)
 294	CONTINUE          
	LY3=1+LY2
	JY=JY+NR1
	ENDIF
C
	IF (LY3.LE.NY1) THEN
	DO 295 LY=LY3,NY1
	DO 296 LR=1,NR1
	DEN(LR,LY,LZ)=CC(LR+JY)
 296	CONTINUE          
	JY=JY+NR1
 295	CONTINUE          
	ENDIF  
 	JZ=JZ+N265
 297	CONTINUE          
C
	DO 301 LZ=4,NZ1,2
	JY=JZ
	IF (LRR.LE.NR1) THEN
	DO 298 LR=LR1,NR1
	DEN(LR,LY2,LZ)=CC(LR+JY)
 298	CONTINUE                       
	LY3=1+LY2
	JY=JY+NR1
	ENDIF
C
	IF (LY3.LE.NY1) THEN
	DO 299 LY=LY3,NY1
	DO 300 LR=1,NR1
	DEN(LR,LY,LZ)=CC(LR+JY)
 300	CONTINUE                       
	JY=JY+NR1
 299	CONTINUE                       
	ENDIF  
	JZ=JZ+N265
 301	CONTINUE                       
C
	JZ=1-LR1+NR65Z+N265
C
	DO 305 LZ=3,NZ1,2
	JY=JZ
	IF (LRR.LE.NR1) THEN
	DO 302 LR=LR1,NR1
	DEN(LR,LY2,LZ)=CC(LR+JY)
  302	CONTINUE                       
	LY3=1+LY2
	JY=JY+NR1
	ENDIF
C
	IF (LY3.LE.NY1) THEN
 	DO 303 LY=LY3,NY1
	DO 304 LR=1,NR1
	DEN(LR,LY,LZ)=CC(LR+JY)
 304	CONTINUE                       
	JY=JY+NR1
 303	CONTINUE                       
	ENDIF  
	JZ=JZ+N265
 305	CONTINUE                       
C
		ENDIF
1000	FORMAT(1X,10E10.3)
1010	FORMAT(1X,' ')
	RETURN
	END
