/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;

public class GenerateId
extends Function {
    public String getName() {
        return "generate-id";
    }

    public int getDataType() {
        return 3;
    }

    public Expression simplify() throws XPathException {
        this.checkArgumentCount(0, 1);
        return this;
    }

    public String evaluateAsString(Context context) throws XPathException {
        int n = this.getNumberOfArguments();
        if (n == 0) {
            NodeInfo nodeInfo = context.getContextNodeInfo();
            String string = nodeInfo.generateId();
            return "d" + context.getController().getDocumentPool().getDocumentNumber(nodeInfo.getDocumentRoot()) + string;
        }
        NodeEnumeration nodeEnumeration = this.argument[0].enumerate(context, true);
        if (nodeEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo = nodeEnumeration.nextElement();
            String string = nodeInfo.generateId();
            return "d" + context.getController().getDocumentPool().getDocumentNumber(nodeInfo.getDocumentRoot()) + string;
        }
        return "";
    }

    public Value evaluate(Context context) throws XPathException {
        return new StringValue(this.evaluateAsString(context));
    }

    public int getDependencies() {
        if (this.getNumberOfArguments() == 0) {
            return 8;
        }
        return this.argument[0].getDependencies();
    }

    public Expression reduce(int n, Context context) throws XPathException {
        GenerateId generateId = new GenerateId();
        if (this.getNumberOfArguments() == 1) {
            generateId.addArgument(this.argument[0].reduce(n, context));
            generateId.setStaticContext(this.getStaticContext());
            return generateId;
        }
        if ((n & 8) != 0) {
            return this.evaluate(context);
        }
        return this;
    }
}

