#if   !defined(__REQUEST_HPP)
#define  __REQUEST_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

namespace   corelinux
{
   DECLARE_CLASS( Request );

   /**
   A Request is used for type identification
   to a handler object
   @see Handler
   */

   class Request
   {
      public:

         //
         // Constructors and destructor
         //

                              /// Default Constructor

                              Request( void );

                              /** Copy Constructor
                              @param Request const reference
                              */

                              Request( RequestCref );

                              /// Virtual Destructor  

         virtual              ~Request( void );

         //
         // Operator overloads
         //
                  /**
                  Assignment operator overload
                  @param  Request const reference
                  @return Request reference to self
                  */

                  RequestRef  operator=( RequestCref );

                  /**
                  Equality operator overload
                  @param Request const reference
                  @return true if equal, false otherwise
                  */

                  bool        operator==( RequestCref ) const;

                  /**
                  Non-equality operator overload
                  @param Request const reference
                  @return false if equal, true otherwise
                  */

                  bool        operator!=( RequestCref ) const;

   };
}

#endif   // if !defined(__REQUEST_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/04/27 14:32:21 $
   $Locker:  $
*/

