/***************************************************************************
       csharetreefolder.h  -  Object for storing a tree of folders
                             -------------------
    begin                : Fri Jul 25 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSHARETREEFOLDER_H
#define CSHARETREEFOLDER_H

/**
 * @author Edward Sheldrake
 *
 * In order to respond to partial list requests via "$ADCGET list ..."
 * we need to store the files and folders that make up the share
 * in a useful format, index.lst was probably designed for
 * creating the text share list and is not helpful for creating
 * partial listings.
 *
 * To save some memory empty lists will not be stored or
 * returned, instead NULL will be returned and lists will
 * be created as necessary.
 *
 * This class should be able to generate the entire XML
 * list, but it does it recursively, so the existing
 * method in CShareList is probably faster.
 */

#include <dclib/dcos.h>
#include <dclib/core/cstring.h>

#include <list>

class CSearchIndex;

class CShareTreeFolder {

public:
	/** Constructor */
	CShareTreeFolder( const CString & name, const CShareTreeFolder * parent );
	/** Destructor - virtual in case something extends this class */
	virtual ~CShareTreeFolder();
	
	/** Gets the name */
	const CString & GetName() const;
	
	/** Gets the parent folder object */
	const CShareTreeFolder * GetParent() const;
	
	/**
	 * Gets the list of child folders.
	 * 
	 * Returns 0 not an empty list if no children.
	 */
	std::list<CShareTreeFolder*> * GetChildren() const;
	
	/** Adds a new subfolder */
	CShareTreeFolder * AddFolder( const CString & name );
	
	/**
	 * Gets the list of files.
	 *
	 * Returns 0 not an empty list if no files.
	 */
	std::list<unsigned long int> * GetFiles() const;
	
	/** Adds a file */
	void AddFile( const unsigned long int fbi );
	
	/**
	 * Gets the XML to given depth.
	 * depth = -1 for unlimited
	 */
	CString GetXML( int depth, CSearchIndex * si ) const;

/** */
private:
	/** The folder name */
	const CString m_sName;
	/** The parent folder */
	const CShareTreeFolder * m_pParent;
	/** List of folders */
	std::list<CShareTreeFolder*> * m_pFolderList;
	/** List of files */
	std::list<unsigned long int> * m_pFileList;
};

#endif // CSHARETREEFOLDER_H
