/*
    dclib-tiger.cpp - Tiger Hash tool
    Copyright (C) 2009 Edward Sheldrake <ejs1920@yahoo.co.uk>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * DC++ headers are no longer installed with dclib.
 * And the symbols are supposed to be hidden from the library.
 */
#include "../dclib/hash/compat.h"
#include "../dclib/hash/TigerHash.h"

#include "../dclib/core/cbytearray.h"
#include "../dclib/core/cfile.h"

#include <cstdio>
#include <cstring>

int main( int argc, char * argv[] )
{
	dcpp::TigerHash hasher;
	CByteArray buffer(16*1024);
	CFile file;
	long read = -1;
	uint8_t res[24];
	
	for ( int i = 1; i < argc; ++i )
	{
		if ( file.Open(argv[i], IO_RAW | IO_READONLY) )
		{
			hasher.reset();
			while ( (read = file.Read((char*)buffer.Data(), buffer.Size())) > 0 )
			{
				hasher.update(buffer.Data(), read);
			}
			file.Close();
			
			memcpy(res, hasher.finalize(), 24);
			
			/* TODO: add option to make it like "gpg2 --print-md tiger192" */
			printf("%s:  ", argv[i]);
			
			/* This is like the NESSIE test vectors on the algorithm home page */
			for ( int j = 0; j < 24; ++j )
			{
				printf("%02X",res[j]);
			}
			printf("\n");
		}
	}
	
	return 0;
}
