/***************************************************************************
          cstring-number.cpp  -  test CString::number() functions
                             -------------------
    begin                : Tue Nov 11 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/**
 * Well since printf("%llu") didn't work on WIN32 here is a test
 * for the CString::number() functions.
 * CString::number(long long) needed fixing.
 */

#include <dclib/core/cstring.h>

#include <stdio.h>
#include <limits.h>

int main( int /* argc */, char*[] /* argv[] and remove the other [] */ )
{
	const int i1 = INT_MIN, i2 = 0, i3 = INT_MAX;
	const unsigned int ui1 = 0, ui2 = UINT_MAX;
	const long l1 = LONG_MIN, l2 = 0, l3 = LONG_MAX;
	const unsigned long ul1 = 0, ul2 = ULONG_MAX;
	const long long ll1 = LLONG_MIN, ll2 = 0, ll3 = LLONG_MAX;
	const unsigned long long ull1 = 0, ull2 = ULLONG_MAX;
	
	CString longmin, longmax, ulongmax;
	if ( sizeof(long) == 4 )
	{
		longmin = "-2147483648";
		longmax = "2147483647";
		ulongmax = "4294967295";
	}
	else if ( sizeof(long) == 8 )
	{
		longmin = "-9223372036854775808";
		longmax = "9223372036854775807";
		ulongmax = "18446744073709551615";
	}
	else
	{
		printf("sizeof(long)=%lu not handled\n",sizeof(long));
		return 0;
	}
	
	int ret = 0;
	
	CString s = CString::number(i1);
	if ( s != "-2147483648" )
	{
		printf("INT_MIN got '%s' expected '-2147483648'\n",s.Data());
		ret = 100;
	}
	
	s = CString::number(i2);
	if ( s != "0" )
	{
		printf("int 0 got '%s' expected '0'\n",s.Data());
		ret = 100;
	}
	
	s = CString::number(i3);
	if ( s != "2147483647" )
	{
		printf("INT_MAX got '%s' expected '2147483647'\n",s.Data());
		ret = 100;
	}
	
	s = CString::number(ui1);
	if ( s != "0" )
	{
		printf("unsigned int 0 got '%s' expected '0'\n",s.Data());
		ret = 100;
	}
	
	s = CString::number(ui2);
	if ( s != "4294967295" )
	{
		printf("UNIT_MAX got '%s' expected '4294967295'\n",s.Data());
		ret = 100;
	}
	
	s = CString::number(l1);
	if ( s != longmin )
	{
		printf("LONG_MIN got '%s' expected '%s'\n",s.Data(),longmin.Data());
		ret = 100;
	}
	
	s = CString::number(l2);
	if ( s != "0" )
	{
		printf("long 0 got '%s' expected '0'\n",s.Data());
		ret = 100;
	}
	
	s = CString::number(l3);
	if ( s != longmax )
	{
		printf("LONG_MAX got '%s' expected '%s'\n",s.Data(),longmax.Data());
		ret = 100;
	}
	
	s = CString::number(ul1);
	if ( s != "0" )
	{
		printf("unsigned long 0 got '%s' expected '0'\n",s.Data());
		ret = 100;
	}
	
	s = CString::number(ul2);
	if ( s != ulongmax )
	{
		printf("ULONG_MAX got '%s' expected '%s'\n",s.Data(),ulongmax.Data());
		ret = 100;
	}
	
	s = CString::number(ll1);
	if ( s != "-9223372036854775808" )
	{
		printf("LLONG_MIN got '%s' expected '-9223372036854775808'\n",s.Data());
		ret = 100;
	}
	
	s = CString::number(ll2);
	if ( s != "0" )
	{
		printf("long long 0 got '%s' expected '0'\n",s.Data());
		ret = 100;
	}
	
	s = CString::number(ll3);
	if ( s != "9223372036854775807" )
	{
		printf("LLONG_MAX got '%s' expected '9223372036854775807'\n",s.Data());
		ret = 100;
	}
	
	s = CString::number(ull1);
	if ( s != "0" )
	{
		printf("unsigned long long 0 got '%s' expected '0'\n",s.Data());
		ret = 100;
	}
	
	s = CString::number(ull2);
	if ( s != "18446744073709551615" )
	{
		printf("ULLONG_MAX got '%s' expected '18446744073709551615'\n",s.Data());
		ret = 100;
	}
	
	return ret;
}
