/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.java.hints.errors;

import java.util.prefs.Preferences;

/**
 *
 * @author Jan Lahoda
 */
public class SurroundWithTryCatchLog extends javax.swing.JPanel {

    private Preferences p;

    /** Creates new form SurroundWithTryCatchLog */
    public SurroundWithTryCatchLog(Preferences p) {
        initComponents();
        this.p = p;
        exceptions.setSelected(ErrorFixesFakeHint.isUseExceptions(p));
        logger.setSelected(ErrorFixesFakeHint.isUseLogger(p));
        rethrowRuntime.setSelected(ErrorFixesFakeHint.isRethrowAsRuntimeException(p));
        rethrow.setSelected(ErrorFixesFakeHint.isRethrow(p));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        exceptions = new javax.swing.JCheckBox();
        logger = new javax.swing.JCheckBox();
        printStackTrace = new javax.swing.JCheckBox();
        jLabel1 = new javax.swing.JLabel();
        rethrowRuntime = new javax.swing.JCheckBox();
        rethrow = new javax.swing.JCheckBox();

        exceptions.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(exceptions, org.openide.util.NbBundle.getBundle(SurroundWithTryCatchLog.class).getString("SurroundWithTryCatchLog.exceptions.text")); // NOI18N
        exceptions.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exceptionsActionPerformed(evt);
            }
        });

        logger.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(logger, org.openide.util.NbBundle.getBundle(SurroundWithTryCatchLog.class).getString("SurroundWithTryCatchLog.logger.text")); // NOI18N
        logger.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loggerActionPerformed(evt);
            }
        });

        printStackTrace.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(printStackTrace, org.openide.util.NbBundle.getBundle(SurroundWithTryCatchLog.class).getString("SurroundWithTryCatchLog.printStackTrace.text")); // NOI18N
        printStackTrace.setEnabled(false);

        jLabel1.setText(org.openide.util.NbBundle.getBundle(SurroundWithTryCatchLog.class).getString("SurroundWithTryCatchLog.jLabel1.text")); // NOI18N

        rethrowRuntime.setText(org.openide.util.NbBundle.getMessage(SurroundWithTryCatchLog.class, "SurroundWithTryCatchLog.rethrowRuntime.text")); // NOI18N
        rethrowRuntime.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rethrowRuntimeActionPerformed(evt);
            }
        });

        rethrow.setText(org.openide.util.NbBundle.getMessage(SurroundWithTryCatchLog.class, "SurroundWithTryCatchLog.rethrow.text")); // NOI18N
        rethrow.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rethrowActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jLabel1, javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                        .addGap(12, 12, 12)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(logger)
                            .addComponent(exceptions)
                            .addComponent(rethrowRuntime)
                            .addComponent(rethrow)
                            .addComponent(printStackTrace))))
                .addContainerGap(57, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(exceptions)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(logger)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(rethrowRuntime)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(rethrow)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(printStackTrace)
                .addContainerGap(134, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

private void loggerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loggerActionPerformed
    ErrorFixesFakeHint.setUseLogger(p, logger.isSelected());
}//GEN-LAST:event_loggerActionPerformed

private void exceptionsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exceptionsActionPerformed
    ErrorFixesFakeHint.setUseExceptions(p, exceptions.isSelected());
}//GEN-LAST:event_exceptionsActionPerformed

private void rethrowRuntimeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rethrowRuntimeActionPerformed
    ErrorFixesFakeHint.setRethrowAsRuntimeException(p, rethrowRuntime.isSelected());
}//GEN-LAST:event_rethrowRuntimeActionPerformed

private void rethrowActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rethrowActionPerformed
    ErrorFixesFakeHint.setRethrow(p, rethrow.isSelected());
}//GEN-LAST:event_rethrowActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox exceptions;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JCheckBox logger;
    private javax.swing.JCheckBox printStackTrace;
    private javax.swing.JCheckBox rethrow;
    private javax.swing.JCheckBox rethrowRuntime;
    // End of variables declaration//GEN-END:variables

}
