#include "osl/game_playing/recordTracer.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;
using namespace osl::game_playing;

class RecordTracerTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(RecordTracerTest);
  CPPUNIT_TEST(testEmpty);
  CPPUNIT_TEST(testTrace);
  CPPUNIT_TEST_SUITE_END();
public:
  void testEmpty()
  {
    vector<Move> moves;
    RecordTracer tracer(moves);
    CPPUNIT_ASSERT_EQUAL(true, tracer.isOutOfBook());
    CPPUNIT_ASSERT_EQUAL(Move::INVALID(), tracer.selectMove());
  }
  void testTrace() 
  {
    vector<Move> moves;
    const Move m76fu(Square(7,7),Square(7,6),PAWN,PTYPE_EMPTY,false,BLACK);
    const Move m26fu(Square(2,7),Square(2,6),PAWN,PTYPE_EMPTY,false,BLACK);
    const Move m34fu(Square(3,3),Square(3,4),PAWN,PTYPE_EMPTY,false,WHITE);
    moves.push_back(m76fu);
    moves.push_back(m34fu);
    
    RecordTracer tracer(moves);
    moves.clear();		// copy されたはず
    
    CPPUNIT_ASSERT_EQUAL(false, tracer.isOutOfBook());
    CPPUNIT_ASSERT_EQUAL(m76fu, tracer.selectMove());

    tracer.update(m76fu);

    CPPUNIT_ASSERT_EQUAL(false, tracer.isOutOfBook());
    CPPUNIT_ASSERT_EQUAL(m34fu, tracer.selectMove());

    tracer.update(m34fu);
    
    CPPUNIT_ASSERT_EQUAL(true, tracer.isOutOfBook());
    CPPUNIT_ASSERT_EQUAL(Move::INVALID(), tracer.selectMove());

    tracer.popMove();
    
    CPPUNIT_ASSERT_EQUAL(false, tracer.isOutOfBook());
    CPPUNIT_ASSERT_EQUAL(m34fu, tracer.selectMove());

    tracer.popMove();

    CPPUNIT_ASSERT_EQUAL(false, tracer.isOutOfBook());
    CPPUNIT_ASSERT_EQUAL(m76fu, tracer.selectMove());

    tracer.update(m26fu);

    CPPUNIT_ASSERT_EQUAL(true, tracer.isOutOfBook());
    CPPUNIT_ASSERT_EQUAL(Move::INVALID(), tracer.selectMove());
  }
};

CPPUNIT_TEST_SUITE_REGISTRATION(RecordTracerTest);

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
