/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2008  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#include "../support.h"
#include "obex_mobile_ds_client.c"
/* #include "http_mobile_ds_client.c" */
#include "libsyncml_ds_server.c"

extern SmlTransportType tspType;
extern const char *mobile_name;

char *testDirectory;

/* ************************************
 * *********** MOBILE TEST ************
 * ************************************
 */

START_TEST (obex_test_mobile)
{
	obex_mobile_connect();
	libsyncml_connect();
	obex_mobile_disconnect();
	libsyncml_disconnect();
}
END_TEST

Suite *obex_get_test_suite(void)
{
	Suite *s = suite_create(mobile_name);
	create_case(s, mobile_name, obex_test_mobile);
	
	return s;
}

int main(int argc, char **argv)
{
	configure_environment();

	int nf;

	/* init test environment */

	if (argc > 1)
		testDirectory = argv[1];
	else
		testDirectory = argv[0];

	/* init test suite */

	Suite *s = NULL;

	switch(tspType)
	{
		case SML_TRANSPORT_OBEX_CLIENT:
			s = obex_get_test_suite();
			break;
		default:
			return 1;
			break;
	}
	
	SRunner *sr;
	sr = srunner_create(s);
	srunner_run_all(sr, CK_VERBOSE);
	nf = srunner_ntests_failed(sr);
	srunner_free(sr);

	cleanup_environment();

	return (nf == 0) ? 0 : 1;
}

