type token =
  | IDENT of (string * Cabs.cabsloc)
  | CST_CHAR of (int64 list * Cabs.cabsloc)
  | CST_WCHAR of (int64 list * Cabs.cabsloc)
  | CST_INT of (string * Cabs.cabsloc)
  | CST_FLOAT of (string * Cabs.cabsloc)
  | NAMED_TYPE of (string * Cabs.cabsloc)
  | CST_STRING of (int64 list * Cabs.cabsloc)
  | CST_WSTRING of (int64 list * Cabs.cabsloc)
  | EOF
  | CHAR of (Cabs.cabsloc)
  | BOOL of (Cabs.cabsloc)
  | INT of (Cabs.cabsloc)
  | DOUBLE of (Cabs.cabsloc)
  | FLOAT of (Cabs.cabsloc)
  | VOID of (Cabs.cabsloc)
  | INT64 of (Cabs.cabsloc)
  | INT32 of (Cabs.cabsloc)
  | ENUM of (Cabs.cabsloc)
  | STRUCT of (Cabs.cabsloc)
  | TYPEDEF of (Cabs.cabsloc)
  | UNION of (Cabs.cabsloc)
  | SIGNED of (Cabs.cabsloc)
  | UNSIGNED of (Cabs.cabsloc)
  | LONG of (Cabs.cabsloc)
  | SHORT of (Cabs.cabsloc)
  | VOLATILE of (Cabs.cabsloc)
  | EXTERN of (Cabs.cabsloc)
  | STATIC of (Cabs.cabsloc)
  | CONST of (Cabs.cabsloc)
  | RESTRICT of (Cabs.cabsloc)
  | AUTO of (Cabs.cabsloc)
  | REGISTER of (Cabs.cabsloc)
  | THREAD of (Cabs.cabsloc)
  | SIZEOF of (Cabs.cabsloc)
  | ALIGNOF of (Cabs.cabsloc)
  | EQ
  | PLUS_EQ
  | MINUS_EQ
  | STAR_EQ
  | SLASH_EQ
  | PERCENT_EQ
  | AND_EQ
  | PIPE_EQ
  | CIRC_EQ
  | INF_INF_EQ
  | SUP_SUP_EQ
  | ARROW
  | DOT
  | EQ_EQ
  | EXCLAM_EQ
  | INF
  | SUP
  | INF_EQ
  | SUP_EQ
  | PLUS of (Cabs.cabsloc)
  | MINUS of (Cabs.cabsloc)
  | STAR of (Cabs.cabsloc)
  | SLASH
  | PERCENT
  | TILDE of (Cabs.cabsloc)
  | AND of (Cabs.cabsloc)
  | PIPE
  | CIRC
  | EXCLAM of (Cabs.cabsloc)
  | AND_AND of (Cabs.cabsloc)
  | PIPE_PIPE
  | INF_INF
  | SUP_SUP
  | PLUS_PLUS of (Cabs.cabsloc)
  | MINUS_MINUS of (Cabs.cabsloc)
  | RPAREN
  | LPAREN of (Cabs.cabsloc)
  | RBRACE of (Cabs.cabsloc)
  | LBRACE of (Cabs.cabsloc)
  | LBRACKET
  | RBRACKET
  | COLON
  | SEMICOLON of (Cabs.cabsloc)
  | COMMA
  | ELLIPSIS
  | QUEST
  | BREAK of (Cabs.cabsloc)
  | CONTINUE of (Cabs.cabsloc)
  | GOTO of (Cabs.cabsloc)
  | RETURN of (Cabs.cabsloc)
  | SWITCH of (Cabs.cabsloc)
  | CASE of (Cabs.cabsloc)
  | DEFAULT of (Cabs.cabsloc)
  | WHILE of (Cabs.cabsloc)
  | DO of (Cabs.cabsloc)
  | FOR of (Cabs.cabsloc)
  | IF of (Cabs.cabsloc)
  | TRY of (Cabs.cabsloc)
  | EXCEPT of (Cabs.cabsloc)
  | FINALLY of (Cabs.cabsloc)
  | ELSE
  | ATTRIBUTE of (Cabs.cabsloc)
  | INLINE of (Cabs.cabsloc)
  | ASM of (Cabs.cabsloc)
  | TYPEOF of (Cabs.cabsloc)
  | FUNCTION__ of (Cabs.cabsloc)
  | PRETTY_FUNCTION__ of (Cabs.cabsloc)
  | LABEL__
  | BUILTIN_VA_ARG of (Cabs.cabsloc)
  | ATTRIBUTE_USED of (Cabs.cabsloc)
  | BUILTIN_VA_LIST
  | BLOCKATTRIBUTE
  | BUILTIN_TYPES_COMPAT of (Cabs.cabsloc)
  | BUILTIN_OFFSETOF of (Cabs.cabsloc)
  | DECLSPEC of (Cabs.cabsloc)
  | MSASM of (string * Cabs.cabsloc)
  | MSATTR of (string * Cabs.cabsloc)
  | PRAGMA_LINE of (string * Cabs.cabsloc)
  | PRAGMA of (Cabs.cabsloc)
  | PRAGMA_EOL
  | AT_TRANSFORM of (Cabs.cabsloc)
  | AT_TRANSFORMEXPR of (Cabs.cabsloc)
  | AT_SPECIFIER of (Cabs.cabsloc)
  | AT_EXPR of (Cabs.cabsloc)
  | AT_NAME

open Parsing;;
# 44 "cparser.mly"
open Cabs
open Cabshelper
module E = Errormsg

let parse_error msg : unit =       (* sm: c++-mode highlight hack: -> ' <- *)
  E.parse_error msg

let print = print_string

(* unit -> string option *)
(*
let getComments () =
  match !comments with
    [] -> None
  | _ -> 
      let r = Some(String.concat "\n" (List.rev !comments)) in
      comments := [];
      r
*)

let cabslu = {lineno = -10; 
	      filename = "cabs loc unknown"; 
	      byteno = -10;
              ident = 0;}

(* cabsloc -> cabsloc *)
(*
let handleLoc l =
  l.clcomment <- getComments();
  l
*)

(*
** Expression building
*)
let smooth_expression lst =
  match lst with
    [] -> NOTHING
  | [expr] -> expr
  | _ -> COMMA (lst)


let currentFunctionName = ref "<outside any function>"
    
let announceFunctionName ((n, decl, _, _):name) =
  !Lexerhack.add_identifier n;
  (* Start a context that includes the parameter names and the whole body. 
   * Will pop when we finish parsing the function body *)
  !Lexerhack.push_context ();
  (* Go through all the parameter names and mark them as identifiers *)
  let rec findProto = function
      PROTO (d, args, _) when isJUSTBASE d -> 
        List.iter (fun (_, (an, _, _, _)) -> !Lexerhack.add_identifier an) args

    | PROTO (d, _, _) -> findProto d
    | PARENTYPE (_, d, _) -> findProto d
    | PTR (_, d) -> findProto d
    | ARRAY (d, _, _) -> findProto d
    | _ -> parse_error "Cannot find the prototype in a function definition";
           raise Parsing.Parse_error 

  and isJUSTBASE = function
      JUSTBASE -> true
    | PARENTYPE (_, d, _) -> isJUSTBASE d
    | _ -> false
  in
  findProto decl;
  currentFunctionName := n



let applyPointer (ptspecs: attribute list list) (dt: decl_type)  
       : decl_type = 
  (* Outer specification first *)
  let rec loop = function
      [] -> dt
    | attrs :: rest -> PTR(attrs, loop rest)
  in
  loop ptspecs

let doDeclaration (loc: cabsloc) (specs: spec_elem list) (nl: init_name list) : definition = 
  if isTypedef specs then begin
    (* Tell the lexer about the new type names *)
    List.iter (fun ((n, _, _, _), _) -> !Lexerhack.add_type n) nl;
    TYPEDEF ((specs, List.map (fun (n, _) -> n) nl), loc)
  end else
    if nl = [] then
      ONLYTYPEDEF (specs, loc)
    else begin
      (* Tell the lexer about the new variable names *)
      List.iter (fun ((n, _, _, _), _) -> !Lexerhack.add_identifier n) nl;
      DECDEF ((specs, nl), loc)  
    end


let doFunctionDef (loc: cabsloc)
                  (lend: cabsloc)
                  (specs: spec_elem list) 
                  (n: name) 
                  (b: block) : definition = 
  let fname = (specs, n) in
  FUNDEF (fname, b, loc, lend)


let doOldParDecl (names: string list)
                 ((pardefs: name_group list), (isva: bool)) 
    : single_name list * bool =
  let findOneName n =
    (* Search in pardefs for the definition for this parameter *)
    let rec loopGroups = function
        [] -> ([SpecType Tint], (n, JUSTBASE, [], cabslu))
      | (specs, names) :: restgroups ->
          let rec loopNames = function
              [] -> loopGroups restgroups
            | ((n',_, _, _) as sn) :: _ when n' = n -> (specs, sn)
            | _ :: restnames -> loopNames restnames
          in
          loopNames names
    in
    loopGroups pardefs
  in
  let args = List.map findOneName names in
  (args, isva)

let checkConnective (s : string) : unit =
begin
  (* checking this means I could possibly have more connectives, with *)
  (* different meaning *)
  if (s <> "to") then (
    parse_error "transformer connective must be 'to'";
    raise Parsing.Parse_error
  )
  else ()
end

let int64_to_char value =
  if (compare value (Int64.of_int 255) > 0) || (compare value Int64.zero < 0) then
    begin
      let msg = Printf.sprintf "cparser:intlist_to_string: character 0x%Lx too big" value in
      parse_error msg;
      raise Parsing.Parse_error
    end
  else
    Char.chr (Int64.to_int value)

(* takes a not-nul-terminated list, and converts it to a string. *)
let rec intlist_to_string (str: int64 list):string =
  match str with
    [] -> ""  (* add nul-termination *)
  | value::rest ->
      let this_char = int64_to_char value in
      (String.make 1 this_char) ^ (intlist_to_string rest)

let fst3 (result, _, _) = result
let snd3 (_, result, _) = result
let trd3 (_, _, result) = result


(*
   transform:  __builtin_offsetof(type, member)
   into     :  (size_t) (&(type * ) 0)->member
 *)

let transformOffsetOf (speclist, dtype) member =
  let rec addPointer = function
    | JUSTBASE ->
	PTR([], JUSTBASE)
    | PARENTYPE (attrs1, dtype, attrs2) ->
	PARENTYPE (attrs1, addPointer dtype, attrs2)
    | ARRAY (dtype, attrs, expr) ->
	ARRAY (addPointer dtype, attrs, expr)
    | PTR (attrs, dtype) ->
	PTR (attrs, addPointer dtype)
    | PROTO (dtype, names, variadic) ->
	PROTO (addPointer dtype, names, variadic)
  in
  let nullType = (speclist, addPointer dtype) in
  let nullExpr = CONSTANT (CONST_INT "0") in
  let castExpr = CAST (nullType, SINGLE_INIT nullExpr) in

  let rec replaceBase = function
    | VARIABLE field ->
	MEMBEROFPTR (castExpr, field)
    | MEMBEROF (base, field) ->
	MEMBEROF (replaceBase base, field)
    | INDEX (base, index) ->
	INDEX (replaceBase base, index)
    | _ ->
	parse_error "malformed offset expression in __builtin_offsetof";
        raise Parsing.Parse_error 
  in
  let memberExpr = replaceBase member in
  let addrExpr = UNARY (ADDROF, memberExpr) in
  (* slight cheat: hard-coded assumption that size_t == unsigned int *)
  let sizeofType = [SpecType Tunsigned], JUSTBASE in
  let resultExpr = CAST (sizeofType, SINGLE_INIT addrExpr) in
  resultExpr

# 324 "cparser.ml"
let yytransl_const = [|
    0 (* EOF *);
  291 (* EQ *);
  292 (* PLUS_EQ *);
  293 (* MINUS_EQ *);
  294 (* STAR_EQ *);
  295 (* SLASH_EQ *);
  296 (* PERCENT_EQ *);
  297 (* AND_EQ *);
  298 (* PIPE_EQ *);
  299 (* CIRC_EQ *);
  300 (* INF_INF_EQ *);
  301 (* SUP_SUP_EQ *);
  302 (* ARROW *);
  303 (* DOT *);
  304 (* EQ_EQ *);
  305 (* EXCLAM_EQ *);
  306 (* INF *);
  307 (* SUP *);
  308 (* INF_EQ *);
  309 (* SUP_EQ *);
  313 (* SLASH *);
  314 (* PERCENT *);
  317 (* PIPE *);
  318 (* CIRC *);
  321 (* PIPE_PIPE *);
  322 (* INF_INF *);
  323 (* SUP_SUP *);
  326 (* RPAREN *);
  330 (* LBRACKET *);
  331 (* RBRACKET *);
  332 (* COLON *);
  334 (* COMMA *);
  335 (* ELLIPSIS *);
  336 (* QUEST *);
  351 (* ELSE *);
  358 (* LABEL__ *);
  361 (* BUILTIN_VA_LIST *);
  362 (* BLOCKATTRIBUTE *);
  370 (* PRAGMA_EOL *);
  375 (* AT_NAME *);
    0|]

let yytransl_block = [|
  257 (* IDENT *);
  258 (* CST_CHAR *);
  259 (* CST_WCHAR *);
  260 (* CST_INT *);
  261 (* CST_FLOAT *);
  262 (* NAMED_TYPE *);
  263 (* CST_STRING *);
  264 (* CST_WSTRING *);
  265 (* CHAR *);
  266 (* BOOL *);
  267 (* INT *);
  268 (* DOUBLE *);
  269 (* FLOAT *);
  270 (* VOID *);
  271 (* INT64 *);
  272 (* INT32 *);
  273 (* ENUM *);
  274 (* STRUCT *);
  275 (* TYPEDEF *);
  276 (* UNION *);
  277 (* SIGNED *);
  278 (* UNSIGNED *);
  279 (* LONG *);
  280 (* SHORT *);
  281 (* VOLATILE *);
  282 (* EXTERN *);
  283 (* STATIC *);
  284 (* CONST *);
  285 (* RESTRICT *);
  286 (* AUTO *);
  287 (* REGISTER *);
  288 (* THREAD *);
  289 (* SIZEOF *);
  290 (* ALIGNOF *);
  310 (* PLUS *);
  311 (* MINUS *);
  312 (* STAR *);
  315 (* TILDE *);
  316 (* AND *);
  319 (* EXCLAM *);
  320 (* AND_AND *);
  324 (* PLUS_PLUS *);
  325 (* MINUS_MINUS *);
  327 (* LPAREN *);
  328 (* RBRACE *);
  329 (* LBRACE *);
  333 (* SEMICOLON *);
  337 (* BREAK *);
  338 (* CONTINUE *);
  339 (* GOTO *);
  340 (* RETURN *);
  341 (* SWITCH *);
  342 (* CASE *);
  343 (* DEFAULT *);
  344 (* WHILE *);
  345 (* DO *);
  346 (* FOR *);
  347 (* IF *);
  348 (* TRY *);
  349 (* EXCEPT *);
  350 (* FINALLY *);
  352 (* ATTRIBUTE *);
  353 (* INLINE *);
  354 (* ASM *);
  355 (* TYPEOF *);
  356 (* FUNCTION__ *);
  357 (* PRETTY_FUNCTION__ *);
  359 (* BUILTIN_VA_ARG *);
  360 (* ATTRIBUTE_USED *);
  363 (* BUILTIN_TYPES_COMPAT *);
  364 (* BUILTIN_OFFSETOF *);
  365 (* DECLSPEC *);
  366 (* MSASM *);
  367 (* MSATTR *);
  368 (* PRAGMA_LINE *);
  369 (* PRAGMA *);
  371 (* AT_TRANSFORM *);
  372 (* AT_TRANSFORMEXPR *);
  373 (* AT_SPECIFIER *);
  374 (* AT_EXPR *);
    0|]

let yylhs = "\255\255\
\001\000\002\000\003\000\003\000\003\000\051\000\004\000\004\000\
\004\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
\004\000\055\000\055\000\055\000\056\000\056\000\057\000\057\000\
\057\000\057\000\057\000\058\000\058\000\058\000\058\000\058\000\
\058\000\058\000\058\000\058\000\058\000\058\000\059\000\059\000\
\059\000\061\000\061\000\061\000\061\000\061\000\061\000\061\000\
\061\000\061\000\061\000\061\000\061\000\061\000\061\000\062\000\
\062\000\063\000\063\000\063\000\063\000\064\000\064\000\064\000\
\065\000\065\000\065\000\066\000\066\000\066\000\066\000\066\000\
\067\000\067\000\067\000\068\000\068\000\069\000\069\000\070\000\
\070\000\071\000\071\000\072\000\072\000\073\000\073\000\074\000\
\074\000\074\000\074\000\074\000\074\000\074\000\074\000\074\000\
\074\000\074\000\074\000\011\000\009\000\009\000\009\000\009\000\
\009\000\009\000\010\000\075\000\018\000\018\000\019\000\019\000\
\019\000\076\000\076\000\076\000\013\000\013\000\021\000\021\000\
\060\000\060\000\020\000\020\000\020\000\077\000\077\000\022\000\
\022\000\022\000\023\000\023\000\078\000\016\000\016\000\012\000\
\012\000\014\000\014\000\014\000\079\000\079\000\015\000\015\000\
\017\000\017\000\035\000\035\000\080\000\081\000\081\000\036\000\
\036\000\036\000\036\000\036\000\037\000\037\000\038\000\038\000\
\008\000\008\000\008\000\008\000\008\000\008\000\008\000\008\000\
\008\000\008\000\008\000\008\000\008\000\008\000\008\000\008\000\
\008\000\008\000\008\000\008\000\008\000\008\000\008\000\008\000\
\083\000\083\000\031\000\031\000\041\000\041\000\040\000\040\000\
\024\000\024\000\024\000\024\000\024\000\024\000\024\000\024\000\
\024\000\024\000\087\000\087\000\088\000\088\000\025\000\025\000\
\025\000\025\000\025\000\025\000\025\000\025\000\025\000\025\000\
\025\000\025\000\025\000\025\000\025\000\025\000\025\000\025\000\
\025\000\025\000\025\000\025\000\025\000\025\000\025\000\025\000\
\025\000\025\000\025\000\025\000\026\000\026\000\026\000\026\000\
\026\000\026\000\044\000\044\000\043\000\043\000\043\000\030\000\
\030\000\030\000\029\000\029\000\042\000\045\000\045\000\045\000\
\045\000\045\000\091\000\092\000\092\000\093\000\093\000\093\000\
\028\000\028\000\028\000\028\000\027\000\094\000\094\000\039\000\
\039\000\054\000\054\000\054\000\095\000\095\000\095\000\049\000\
\050\000\050\000\034\000\034\000\048\000\048\000\046\000\046\000\
\046\000\046\000\047\000\047\000\032\000\033\000\033\000\033\000\
\033\000\033\000\052\000\052\000\052\000\005\000\005\000\006\000\
\006\000\006\000\089\000\089\000\089\000\089\000\084\000\084\000\
\096\000\096\000\096\000\096\000\098\000\098\000\090\000\090\000\
\053\000\053\000\053\000\100\000\100\000\100\000\100\000\100\000\
\100\000\100\000\100\000\100\000\100\000\100\000\101\000\101\000\
\101\000\101\000\101\000\101\000\102\000\102\000\102\000\102\000\
\102\000\102\000\102\000\102\000\102\000\102\000\102\000\103\000\
\104\000\104\000\104\000\104\000\105\000\105\000\105\000\106\000\
\106\000\106\000\107\000\107\000\107\000\107\000\107\000\108\000\
\108\000\108\000\109\000\109\000\110\000\110\000\111\000\111\000\
\112\000\112\000\113\000\113\000\114\000\114\000\099\000\115\000\
\115\000\115\000\116\000\116\000\082\000\082\000\097\000\097\000\
\007\000\007\000\007\000\085\000\085\000\086\000\086\000\117\000\
\117\000\119\000\119\000\120\000\120\000\118\000\118\000\121\000\
\121\000\122\000\122\000\123\000\123\000\000\000\000\000"

let yylen = "\002\000\
\002\000\001\000\000\000\002\000\002\000\000\000\001\000\001\000\
\003\000\005\000\005\000\001\000\006\000\004\000\008\000\008\000\
\003\000\001\000\001\000\004\000\000\000\001\000\001\000\001\000\
\001\000\003\000\004\000\001\000\002\000\004\000\006\000\006\000\
\006\000\003\000\003\000\002\000\002\000\006\000\001\000\003\000\
\002\000\001\000\002\000\002\000\002\000\004\000\002\000\004\000\
\002\000\002\000\002\000\002\000\002\000\002\000\002\000\001\000\
\004\000\001\000\003\000\003\000\003\000\001\000\003\000\003\000\
\001\000\003\000\003\000\001\000\003\000\003\000\003\000\003\000\
\001\000\003\000\003\000\001\000\003\000\001\000\003\000\001\000\
\003\000\001\000\003\000\001\000\003\000\001\000\005\000\001\000\
\003\000\003\000\003\000\003\000\003\000\003\000\003\000\003\000\
\003\000\003\000\003\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\002\000\001\000\002\000\
\002\000\001\000\001\000\001\000\001\000\003\000\001\000\003\000\
\000\000\001\000\003\000\002\000\001\000\001\000\000\000\003\000\
\004\000\005\000\000\000\001\000\002\000\000\000\001\000\000\000\
\001\000\001\000\003\000\003\000\000\000\001\000\003\000\003\000\
\003\000\003\000\005\000\003\000\001\000\000\000\002\000\000\000\
\002\000\002\000\002\000\002\000\000\000\004\000\001\000\003\000\
\001\000\002\000\001\000\003\000\005\000\003\000\003\000\005\000\
\008\000\004\000\004\000\006\000\002\000\002\000\003\000\002\000\
\002\000\003\000\004\000\007\000\001\000\005\000\004\000\003\000\
\002\000\001\000\003\000\002\000\001\000\003\000\001\000\003\000\
\002\000\002\000\002\000\002\000\002\000\002\000\002\000\002\000\
\002\000\004\000\000\000\001\000\000\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\002\000\003\000\005\000\004\000\006\000\005\000\002\000\
\005\000\004\000\006\000\005\000\002\000\006\000\005\000\007\000\
\006\000\001\000\004\000\004\000\000\000\003\000\002\000\004\000\
\002\000\003\000\001\000\003\000\001\000\004\000\002\000\001\000\
\003\000\003\000\001\000\003\000\003\000\001\000\004\000\005\000\
\005\000\004\000\001\000\000\000\002\000\000\000\002\000\003\000\
\002\000\002\000\001\000\003\000\002\000\005\000\003\000\001\000\
\003\000\000\000\004\000\004\000\001\000\003\000\001\000\003\000\
\000\000\001\000\002\000\001\000\003\000\001\000\004\000\003\000\
\004\000\004\000\001\000\000\000\002\000\002\000\002\000\004\000\
\005\000\003\000\001\000\001\000\001\000\000\000\002\000\000\000\
\002\000\005\000\004\000\002\000\001\000\001\000\000\000\002\000\
\001\000\001\000\001\000\001\000\004\000\002\000\001\000\002\000\
\003\000\004\000\001\000\001\000\001\000\003\000\002\000\001\000\
\001\000\001\000\003\000\003\000\003\000\001\000\001\000\003\000\
\002\000\003\000\003\000\004\000\001\000\002\000\004\000\002\000\
\004\000\002\000\002\000\002\000\002\000\002\000\002\000\001\000\
\001\000\003\000\003\000\003\000\001\000\003\000\003\000\001\000\
\003\000\003\000\001\000\003\000\003\000\003\000\003\000\001\000\
\003\000\003\000\001\000\003\000\001\000\003\000\001\000\003\000\
\001\000\003\000\001\000\003\000\001\000\005\000\001\000\001\000\
\003\000\003\000\000\000\001\000\003\000\003\000\003\000\003\000\
\000\000\002\000\002\000\001\000\002\000\000\000\003\000\000\000\
\001\000\001\000\003\000\005\000\005\000\000\000\003\000\000\000\
\003\000\000\000\002\000\001\000\003\000\002\000\002\000"

let yydefred = "\000\000\
\000\000\000\000\000\000\000\000\234\000\208\000\210\000\211\000\
\215\000\214\000\207\000\213\000\000\000\000\000\000\000\000\000\
\216\000\217\000\212\000\209\000\044\001\000\000\000\000\043\001\
\045\001\000\000\000\000\054\001\000\000\000\000\000\000\000\000\
\000\000\000\000\053\001\067\001\000\000\000\000\000\000\000\000\
\158\001\000\000\002\000\000\000\000\000\000\000\007\000\008\000\
\000\000\000\000\000\000\012\000\000\000\159\001\000\000\000\000\
\018\000\019\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\204\000\193\000\000\000\
\000\000\000\000\114\000\115\000\116\000\000\000\000\000\109\000\
\194\000\195\000\196\000\197\000\005\000\000\000\199\000\000\000\
\000\000\000\000\052\001\000\000\000\000\069\001\078\001\074\001\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\073\001\000\000\079\001\000\000\096\001\097\001\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\127\001\000\000\000\000\000\000\001\000\004\000\
\000\000\188\000\039\001\000\000\000\000\000\000\026\001\000\000\
\206\000\198\000\006\000\149\000\037\001\000\000\000\000\200\000\
\201\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\248\000\000\000\000\000\062\001\000\000\000\000\000\000\
\000\000\064\001\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\009\000\110\000\000\000\000\000\000\000\023\000\103\000\104\000\
\101\000\102\000\111\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\024\000\105\000\000\000\025\000\000\000\
\000\000\000\000\028\000\000\000\056\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\088\000\100\000\000\000\000\000\000\000\071\001\000\000\000\000\
\081\001\000\000\000\000\086\001\000\000\088\001\090\001\091\001\
\092\001\095\001\093\001\094\001\000\000\000\000\000\000\065\001\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\060\001\058\001\059\001\000\000\057\001\000\000\000\000\
\187\000\000\000\000\000\000\000\254\000\013\001\000\000\000\000\
\000\000\017\000\000\000\014\000\000\000\000\000\009\001\010\001\
\000\000\000\000\000\000\005\001\040\001\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\239\000\000\000\
\000\000\000\000\000\000\000\000\000\000\221\000\241\000\000\000\
\000\000\000\000\226\000\000\000\000\000\000\000\000\000\000\000\
\000\000\132\001\000\000\051\001\000\000\000\000\045\000\000\000\
\047\000\049\000\050\000\051\000\054\000\052\000\053\000\055\000\
\000\000\043\000\044\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\235\000\113\000\112\000\027\001\
\000\000\236\000\000\000\000\000\036\000\037\000\000\000\000\000\
\029\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\134\001\
\000\000\000\000\133\001\080\001\075\001\076\001\000\000\000\000\
\070\001\077\001\066\001\082\001\083\001\000\000\098\001\099\001\
\100\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\202\000\024\001\047\001\190\000\000\000\
\117\000\192\000\000\000\000\000\000\000\000\000\253\000\000\000\
\000\000\148\000\000\000\000\000\000\000\000\000\017\001\000\000\
\000\000\012\001\000\000\000\000\000\000\000\000\007\001\000\000\
\252\000\250\000\249\000\231\000\061\001\020\000\000\000\000\000\
\000\000\242\000\247\000\238\000\000\000\000\000\000\000\220\000\
\223\000\000\000\225\000\228\000\000\000\010\000\136\001\135\001\
\011\000\000\000\000\000\000\000\144\000\000\000\000\000\143\000\
\000\000\026\000\000\000\000\000\000\000\000\000\000\000\035\000\
\034\000\000\000\135\000\000\000\000\000\000\000\089\000\090\000\
\091\000\092\000\093\000\094\000\095\000\096\000\097\000\098\000\
\099\000\059\000\060\000\061\000\058\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\137\000\000\000\130\001\
\129\001\000\000\000\000\084\001\000\000\000\000\000\000\000\000\
\000\000\000\000\125\000\000\000\122\000\000\000\000\000\000\000\
\000\000\000\000\015\001\000\000\000\000\000\000\000\000\049\001\
\000\000\000\000\151\000\000\000\000\000\161\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\181\000\000\000\000\000\000\000\163\000\
\000\000\000\000\023\001\000\000\000\000\013\000\000\000\000\000\
\003\001\029\001\000\000\000\000\008\001\230\000\233\000\000\000\
\000\000\244\000\240\000\222\000\227\000\000\000\000\000\000\000\
\140\000\139\000\000\000\057\000\000\000\000\000\000\000\027\000\
\000\000\030\000\146\000\145\000\000\000\126\001\000\000\000\000\
\000\000\000\000\000\000\126\000\000\000\133\000\118\000\124\000\
\255\000\000\000\000\000\142\000\000\000\000\000\002\001\160\000\
\158\000\000\000\000\000\176\000\177\000\000\000\000\000\174\000\
\000\000\000\000\000\000\000\000\173\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\154\000\162\000\
\153\000\147\000\156\000\000\000\000\000\032\001\000\000\000\000\
\000\000\232\000\246\000\000\000\000\000\000\000\039\000\000\000\
\087\000\000\000\000\000\132\000\128\000\000\000\000\000\120\000\
\123\000\014\001\001\001\000\001\000\000\184\000\000\000\000\000\
\178\000\000\000\175\000\000\000\166\000\000\000\000\000\167\000\
\000\000\000\000\000\000\186\000\000\000\000\000\000\000\000\000\
\138\001\139\001\000\000\022\001\019\001\020\001\031\001\034\001\
\033\001\038\000\031\000\032\000\000\000\033\000\041\000\015\000\
\016\000\129\000\000\000\050\001\170\000\056\001\179\000\171\000\
\000\000\000\000\185\000\000\000\000\000\000\000\183\000\108\000\
\000\000\000\000\040\000\130\000\000\000\168\000\000\000\165\000\
\182\000\141\001\000\000\000\000\172\000\000\000\000\000\000\000\
\000\000\146\001\000\000\000\000\000\000\000\000\000\000\143\001\
\000\000\000\000\180\000\169\000\153\001\000\000\147\001\000\000\
\000\000\151\001\000\000\000\000\000\000\155\001\149\001\148\001\
\000\000\157\001"

let yydgoto = "\003\000\
\041\000\042\000\043\000\044\000\021\001\191\001\158\002\077\002\
\204\000\205\000\093\001\029\002\043\002\078\002\207\000\252\001\
\113\001\079\000\208\000\044\002\045\002\046\002\181\002\165\000\
\046\000\166\000\131\000\151\000\154\000\155\000\047\000\048\000\
\049\000\210\000\080\002\081\002\033\001\196\001\148\000\132\000\
\133\000\058\001\059\001\060\001\204\001\205\001\206\001\167\002\
\135\000\061\001\050\000\051\000\167\000\201\001\029\001\048\001\
\211\000\212\000\176\002\048\002\213\000\214\000\215\000\216\000\
\217\000\218\000\219\000\220\000\221\000\222\000\223\000\224\000\
\225\000\226\000\241\002\080\000\125\002\049\002\133\002\142\000\
\198\001\091\000\205\002\191\002\242\002\252\002\081\000\138\000\
\053\000\064\000\192\001\152\000\044\001\030\001\085\002\023\001\
\180\000\065\000\228\000\109\000\110\000\111\000\112\000\113\000\
\114\000\115\000\116\000\117\000\118\000\119\000\120\000\121\000\
\122\000\123\000\229\000\075\001\000\003\008\003\001\003\002\003\
\003\003\018\003\022\003"

let yysindex = "\096\000\
\030\013\030\013\000\000\237\254\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\185\255\094\000\130\015\125\000\
\000\000\000\000\000\000\000\000\000\000\056\014\130\015\000\000\
\000\000\130\015\130\015\000\000\030\013\004\255\130\015\047\255\
\136\255\180\255\000\000\000\000\115\016\049\255\124\255\203\255\
\000\000\028\001\000\000\030\013\037\255\154\015\000\000\000\000\
\039\255\080\000\130\015\000\000\130\015\000\000\059\000\222\014\
\000\000\000\000\105\000\228\255\180\255\030\000\054\000\103\255\
\012\000\119\010\078\000\147\000\130\015\000\000\000\000\119\010\
\092\000\190\000\000\000\000\000\000\000\249\014\065\255\000\000\
\000\000\000\000\000\000\000\000\000\000\116\000\000\000\065\255\
\009\010\166\010\000\000\062\255\087\000\000\000\000\000\000\000\
\227\011\042\012\115\016\115\016\115\016\115\016\115\016\115\016\
\115\016\117\000\000\000\007\255\000\000\043\255\000\000\000\000\
\210\001\090\000\255\000\226\001\176\000\142\000\155\000\115\000\
\182\000\134\255\000\000\091\013\061\012\239\000\000\000\000\000\
\144\001\000\000\000\000\181\000\184\000\240\000\000\000\107\255\
\000\000\000\000\000\000\000\000\000\000\198\000\229\000\000\000\
\000\000\004\001\008\001\248\000\222\014\035\001\016\001\034\001\
\073\001\000\000\040\001\116\000\000\000\112\001\105\000\105\000\
\047\001\000\000\049\001\119\010\206\255\075\001\119\010\119\010\
\119\010\067\001\079\001\119\010\119\010\088\001\030\013\037\255\
\000\000\000\000\010\016\094\001\100\001\000\000\000\000\000\000\
\000\000\000\000\000\000\132\012\151\012\061\012\061\012\061\012\
\061\012\061\012\061\012\173\001\222\012\222\012\173\005\106\001\
\113\001\120\001\122\001\000\000\000\000\132\001\000\000\052\255\
\035\001\149\001\000\000\201\001\000\000\210\003\100\002\015\001\
\007\001\072\002\039\001\161\001\169\001\172\001\177\001\109\000\
\000\000\000\000\118\255\180\001\214\001\000\000\189\015\011\002\
\000\000\026\002\173\005\000\000\173\005\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\219\001\036\002\187\001\000\000\
\168\255\168\255\115\016\115\016\115\016\115\016\115\016\115\016\
\115\016\115\016\115\016\115\016\115\016\115\016\115\016\115\016\
\115\016\115\016\115\016\115\016\115\016\115\016\230\001\234\001\
\244\001\000\000\000\000\000\000\035\001\000\000\144\001\035\001\
\000\000\255\010\144\001\043\001\000\000\000\000\003\002\075\002\
\228\001\000\000\059\000\000\000\130\015\013\002\000\000\000\000\
\000\000\135\255\083\014\000\000\000\000\061\012\077\001\012\002\
\019\002\027\002\040\001\040\001\105\000\119\010\000\000\061\012\
\119\010\005\002\010\002\016\002\107\255\000\000\000\000\024\002\
\031\002\119\010\000\000\037\002\039\002\119\010\063\002\240\000\
\149\255\000\000\044\002\000\000\022\002\173\005\000\000\173\005\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\173\005\000\000\000\000\215\255\059\002\070\002\078\002\079\002\
\061\012\130\015\130\015\141\002\000\000\000\000\000\000\000\000\
\074\002\000\000\168\255\168\255\000\000\000\000\168\008\240\008\
\000\000\061\012\061\012\061\012\061\012\061\012\061\012\061\012\
\061\012\061\012\061\012\061\012\061\012\061\012\061\012\061\012\
\061\012\061\012\061\012\061\012\061\012\061\012\061\012\061\012\
\061\012\061\012\061\012\061\012\061\012\061\012\168\008\000\000\
\046\016\046\016\000\000\000\000\000\000\000\000\082\002\092\002\
\000\000\000\000\000\000\000\000\000\000\112\002\000\000\000\000\
\000\000\210\001\210\001\090\000\090\000\255\000\255\000\255\000\
\255\000\226\001\226\001\176\000\142\000\155\000\115\000\182\000\
\025\002\187\002\200\002\000\000\000\000\000\000\000\000\194\007\
\000\000\000\000\035\001\059\000\144\001\134\002\000\000\222\014\
\134\001\000\000\133\002\136\002\180\255\054\005\000\000\099\255\
\138\002\000\000\023\001\006\002\118\002\147\002\000\000\016\001\
\000\000\000\000\000\000\000\000\000\000\000\000\144\002\151\002\
\040\001\000\000\000\000\000\000\061\012\029\255\119\010\000\000\
\000\000\167\002\000\000\000\000\169\002\000\000\000\000\000\000\
\000\000\156\002\170\002\172\002\000\000\168\008\168\008\000\000\
\075\011\000\000\171\002\174\002\176\002\177\002\023\001\000\000\
\000\000\179\002\000\000\185\002\129\000\183\002\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\100\002\100\002\015\001\
\015\001\007\001\007\001\007\001\007\001\072\002\072\002\039\001\
\161\001\169\001\172\001\177\001\184\002\000\000\181\002\000\000\
\000\000\188\002\188\002\000\000\115\016\189\002\191\002\000\000\
\168\255\061\012\000\000\190\002\000\000\234\002\194\002\202\002\
\255\010\242\002\000\000\246\002\003\009\065\255\251\002\000\000\
\075\002\198\000\000\000\179\002\248\002\000\000\249\002\255\002\
\119\255\014\008\254\002\061\012\002\003\254\002\220\006\008\003\
\254\002\039\255\242\000\000\000\054\005\005\003\054\005\000\000\
\011\003\054\005\000\000\007\003\021\003\000\000\029\003\035\001\
\000\000\000\000\222\014\168\008\000\000\000\000\000\000\028\003\
\144\001\000\000\000\000\000\000\000\000\188\002\188\002\188\002\
\000\000\000\000\194\007\000\000\130\015\130\015\168\255\000\000\
\035\001\000\000\000\000\000\000\061\012\000\000\030\013\061\012\
\216\255\189\000\194\007\000\000\255\010\000\000\000\000\000\000\
\000\000\130\015\177\000\000\000\033\003\042\003\000\000\000\000\
\000\000\233\255\086\000\000\000\000\000\026\003\168\008\000\000\
\036\003\075\009\220\006\217\000\000\000\220\006\038\003\044\003\
\036\006\220\006\017\001\242\000\242\000\057\003\000\000\000\000\
\000\000\000\000\000\000\099\255\021\015\000\000\060\003\063\003\
\059\003\000\000\000\000\068\003\065\003\072\003\000\000\232\255\
\000\000\074\003\075\003\000\000\000\000\216\255\061\012\000\000\
\000\000\000\000\000\000\000\000\144\001\000\000\220\006\086\000\
\000\000\073\003\000\000\215\255\000\000\220\006\061\012\000\000\
\086\000\254\002\078\003\000\000\168\008\056\003\254\002\039\255\
\000\000\000\000\149\003\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\160\003\000\000\000\000\000\000\
\000\000\000\000\094\003\000\000\000\000\000\000\000\000\000\000\
\095\003\093\003\000\000\096\003\220\006\039\255\000\000\000\000\
\149\003\098\003\000\000\000\000\220\006\000\000\168\008\000\000\
\000\000\000\000\103\003\102\003\000\000\108\003\180\003\106\003\
\105\003\000\000\065\255\109\003\220\006\110\003\103\003\000\000\
\103\003\116\003\000\000\000\000\000\000\112\003\000\000\147\009\
\149\003\000\000\121\003\123\003\117\003\000\000\000\000\000\000\
\149\003\000\000"

let yyrindex = "\000\000\
\021\000\024\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\180\000\000\000\
\000\000\000\000\000\000\000\000\000\000\043\000\180\000\000\000\
\000\000\180\000\180\000\000\000\022\000\000\000\180\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\022\000\158\000\171\000\000\000\000\000\
\000\000\000\000\180\000\000\000\180\000\000\000\113\014\124\003\
\000\000\000\000\000\000\000\000\000\000\000\000\186\001\000\000\
\200\000\126\003\042\002\000\000\180\000\000\000\000\000\126\003\
\154\002\000\000\000\000\000\000\000\000\000\000\203\013\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\253\002\105\013\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\142\002\000\000\000\000\
\111\022\214\022\109\009\185\023\174\001\040\003\063\008\061\003\
\056\002\080\001\000\000\199\003\000\000\000\000\000\000\000\000\
\213\000\000\000\000\000\125\003\000\000\061\255\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\209\003\000\000\000\000\
\000\000\130\003\051\255\000\000\000\000\013\000\131\003\000\000\
\014\255\000\000\133\003\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\126\003\158\000\000\000\126\003\126\003\
\126\003\010\003\000\000\126\003\126\003\000\000\030\255\158\000\
\000\000\000\000\155\003\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\182\016\
\114\000\000\000\000\000\013\017\000\000\185\006\041\007\130\018\
\069\019\129\020\007\021\085\021\163\021\241\021\211\007\150\001\
\000\000\000\000\000\000\174\003\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\041\000\000\000\089\003\158\000\
\000\000\000\000\167\000\058\001\000\000\000\000\000\000\000\000\
\072\004\000\000\000\000\000\000\067\255\000\000\000\000\000\000\
\227\000\129\003\000\000\000\000\000\000\000\000\184\003\000\000\
\000\000\000\000\133\003\133\003\000\000\126\003\000\000\000\000\
\126\003\045\001\181\003\000\000\000\000\000\000\000\000\000\000\
\000\000\126\003\000\000\000\000\000\000\126\003\000\000\052\001\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\185\003\063\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\129\003\000\000\000\000\000\000\000\000\000\000\189\003\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\186\003\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\146\022\179\022\247\022\026\023\059\023\094\023\127\023\
\162\023\208\023\231\023\030\002\021\010\144\009\144\005\168\002\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\188\003\
\000\000\000\000\158\000\113\014\092\008\000\000\000\000\124\003\
\029\001\000\000\190\003\000\000\000\000\194\003\000\000\158\000\
\073\255\000\000\142\255\068\001\165\000\000\000\000\000\131\003\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\133\003\000\000\000\000\000\000\000\000\158\000\126\003\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\081\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\018\065\018\195\018\
\004\019\134\019\199\019\008\020\073\020\185\020\241\020\063\021\
\141\021\219\021\041\022\033\008\000\000\000\000\000\000\000\000\
\000\000\155\007\078\022\000\000\000\000\000\000\000\000\055\024\
\000\000\000\000\000\000\198\003\000\000\151\011\000\000\000\000\
\000\000\000\000\000\000\000\000\196\003\000\000\000\000\000\000\
\000\000\209\003\000\000\009\000\101\024\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\203\003\000\000\194\003\000\000\194\003\000\000\
\000\000\194\003\000\000\202\003\000\000\000\000\000\000\039\000\
\000\000\000\000\124\003\196\003\000\000\000\000\000\000\000\000\
\065\001\000\000\000\000\000\000\000\000\100\017\187\017\000\000\
\000\000\000\000\188\003\000\000\000\000\000\000\000\000\000\000\
\241\000\000\000\000\000\000\000\000\000\000\000\030\255\000\000\
\179\010\000\000\188\003\000\000\000\000\000\000\000\000\000\000\
\000\000\100\255\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\108\006\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\101\024\000\000\
\206\003\000\000\000\000\203\003\203\003\000\000\000\000\000\000\
\000\000\000\000\000\000\158\000\067\255\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\179\010\000\000\000\000\
\000\000\000\000\000\000\000\000\009\002\000\000\000\000\076\007\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\076\007\000\000\000\000\000\000\206\003\191\004\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\080\255\191\003\000\000\000\000\000\000\000\000\205\003\000\000\
\000\000\000\000\202\000\000\000\000\000\000\000\000\000\214\003\
\239\255\000\000\000\000\000\000\000\000\000\000\202\000\000\000\
\104\255\000\000\000\000\000\000\000\000\215\003\000\000\000\000\
\000\000\000\000\000\000\000\000\217\003\000\000\000\000\000\000\
\000\000\000\000"

let yygindex = "\000\000\
\000\000\018\005\235\255\164\004\005\255\111\003\011\000\194\254\
\000\000\234\255\169\255\146\253\240\254\069\255\021\254\000\000\
\113\002\000\000\000\000\000\000\000\000\189\253\120\002\018\000\
\000\000\100\000\000\000\160\255\000\004\132\255\183\255\000\000\
\000\000\122\255\208\255\064\255\000\003\012\003\238\254\000\000\
\031\004\225\255\000\000\091\003\187\004\000\000\000\000\182\255\
\117\255\229\255\126\255\000\000\002\000\094\254\042\000\231\254\
\000\000\000\000\000\000\153\254\183\001\193\255\060\001\050\001\
\251\001\087\001\236\003\237\003\204\003\183\003\233\003\000\000\
\004\003\249\003\065\254\219\255\000\000\000\000\030\003\000\000\
\000\000\201\255\000\000\193\002\139\002\000\000\153\004\000\000\
\156\255\114\001\003\000\077\254\171\003\000\000\217\002\253\254\
\230\004\000\000\020\000\000\000\000\000\000\000\060\000\018\002\
\023\002\231\002\029\002\124\004\127\004\123\004\126\004\129\004\
\000\000\002\255\111\255\000\000\132\002\000\000\000\000\137\002\
\000\000\000\000\122\002"

let yytablesize = 6581
let yytable = "\078\000\
\141\000\206\000\052\000\052\000\177\000\157\000\056\000\085\000\
\031\001\186\001\041\001\094\001\055\002\134\000\107\000\177\001\
\199\001\136\000\045\000\045\000\003\000\003\000\128\000\003\000\
\193\001\215\001\216\001\182\001\022\001\006\000\052\000\187\001\
\070\000\074\001\051\001\052\001\233\000\016\001\139\000\070\000\
\070\000\178\000\203\002\070\000\070\000\052\000\045\000\094\001\
\070\000\094\001\042\001\055\000\038\001\180\002\063\000\067\000\
\108\000\073\000\075\000\102\001\038\001\045\000\230\000\137\000\
\095\001\181\000\018\001\107\000\070\000\041\001\070\000\075\000\
\041\001\150\000\086\000\040\001\107\000\107\000\107\000\107\000\
\107\000\107\000\107\000\247\000\129\000\251\000\070\000\147\002\
\249\000\250\000\150\002\251\000\129\000\154\002\236\002\176\000\
\001\000\002\000\083\002\018\001\151\001\003\000\152\001\057\000\
\056\001\161\000\209\000\057\000\058\000\170\000\152\001\140\000\
\058\000\130\000\180\002\174\000\251\000\088\000\039\001\142\002\
\248\000\124\000\042\001\042\001\245\000\052\000\082\001\083\001\
\084\001\085\001\086\001\087\001\231\000\038\001\104\001\057\000\
\254\002\191\000\191\000\018\001\058\000\045\000\046\001\018\001\
\072\001\041\001\094\001\046\001\094\001\140\001\096\001\076\000\
\077\000\071\001\129\000\140\001\107\000\094\001\239\000\240\000\
\241\000\242\000\243\000\244\000\076\000\077\000\150\000\168\002\
\057\000\052\002\103\001\171\000\018\001\058\000\143\002\160\000\
\052\000\027\001\022\001\251\001\254\001\105\001\022\001\022\001\
\217\001\057\000\096\001\144\001\096\001\193\001\058\000\096\002\
\045\000\053\002\185\001\145\001\125\000\046\001\013\001\234\001\
\193\001\235\001\208\001\152\001\152\001\203\001\089\000\088\002\
\107\000\090\002\236\001\030\002\046\001\014\001\209\001\046\001\
\209\000\031\001\231\001\244\001\245\001\062\000\234\002\186\002\
\219\001\062\000\145\001\238\002\107\000\107\000\107\000\107\000\
\107\000\107\000\107\000\107\000\107\000\107\000\107\000\107\000\
\107\000\107\000\107\000\107\000\107\000\107\000\107\000\107\000\
\072\001\181\001\090\000\113\002\209\000\062\000\209\000\032\002\
\033\002\059\000\214\002\172\002\046\001\129\000\041\002\055\001\
\152\002\243\001\063\001\064\001\065\001\025\001\158\001\068\001\
\069\001\126\000\025\001\184\002\006\000\006\000\221\002\006\000\
\060\000\056\001\057\001\127\000\237\001\096\001\062\000\096\001\
\128\002\042\002\156\001\157\001\238\001\061\000\118\002\025\001\
\096\001\025\001\156\000\203\000\025\001\222\002\025\001\062\000\
\194\001\112\001\105\002\106\002\145\001\190\002\200\001\159\001\
\160\001\161\001\145\001\146\000\150\000\010\002\011\002\012\002\
\013\002\013\002\013\002\013\002\013\002\013\002\013\002\013\002\
\013\002\013\002\013\002\013\002\013\002\013\002\013\002\143\000\
\006\000\021\003\011\001\025\001\197\002\006\000\025\001\200\002\
\022\001\021\003\011\001\206\002\022\001\003\000\057\000\209\000\
\185\001\209\000\203\000\058\000\158\000\171\002\022\001\022\001\
\022\001\153\000\209\000\060\000\185\002\025\001\025\001\025\001\
\025\001\203\000\025\001\209\000\209\000\028\000\025\001\203\000\
\061\000\132\002\107\000\107\000\079\002\057\000\159\000\068\000\
\229\002\074\000\058\000\025\001\138\000\097\002\145\002\232\002\
\046\001\138\000\138\000\138\000\159\002\059\002\161\002\255\000\
\000\001\163\002\022\001\057\000\248\001\249\001\168\000\046\001\
\058\000\218\001\046\001\050\002\220\001\025\001\025\001\025\001\
\132\002\203\000\234\000\025\001\172\000\226\001\066\000\046\001\
\084\002\229\001\205\000\205\000\046\001\142\001\248\002\011\001\
\205\000\108\002\162\000\203\000\203\000\030\000\253\002\028\001\
\025\001\138\002\179\000\025\001\143\001\060\000\057\000\028\001\
\246\000\228\002\034\000\058\000\035\000\072\000\012\003\082\002\
\063\001\009\001\061\000\115\002\041\001\063\001\238\001\091\002\
\152\001\150\000\122\002\194\002\062\000\046\001\094\001\176\000\
\010\001\185\001\046\001\169\000\060\000\030\002\046\001\007\001\
\008\001\047\002\205\000\026\001\025\001\041\001\173\002\174\002\
\026\001\061\000\046\001\203\000\148\002\046\001\035\001\017\001\
\205\000\205\000\046\001\062\000\205\000\012\001\205\000\205\000\
\205\000\203\000\203\000\187\002\022\001\203\000\238\001\203\000\
\203\000\203\000\024\001\079\002\025\001\079\002\173\000\182\002\
\079\002\062\000\156\002\183\002\046\001\157\002\107\000\144\001\
\063\001\030\002\026\001\185\001\025\001\144\001\087\002\236\000\
\238\000\155\002\046\001\046\001\048\001\046\001\046\001\134\002\
\179\002\205\000\046\001\185\001\198\002\185\001\192\002\199\002\
\030\001\026\001\203\000\032\001\026\001\152\001\152\001\018\001\
\030\001\034\001\019\001\020\001\062\000\013\002\028\000\025\001\
\050\002\048\001\025\001\030\002\042\001\037\001\063\001\048\001\
\001\001\002\001\099\002\018\001\128\001\129\001\019\001\020\001\
\130\001\131\001\028\000\046\001\210\001\153\000\082\002\204\002\
\082\002\035\001\121\002\082\002\036\001\105\001\136\001\137\001\
\022\001\026\001\129\000\192\002\048\001\043\001\176\000\227\002\
\176\000\178\002\048\001\176\000\192\002\048\001\048\001\045\001\
\048\001\048\001\048\001\046\001\150\000\207\002\208\002\233\002\
\050\001\188\001\079\001\081\001\189\001\047\001\030\000\053\001\
\052\000\245\000\245\000\090\001\091\001\054\001\209\000\209\000\
\191\000\191\000\048\001\034\000\084\002\035\000\048\001\048\001\
\045\000\048\001\030\000\066\001\190\001\046\001\046\001\048\001\
\048\001\048\001\062\001\200\001\047\002\125\001\067\001\034\000\
\175\002\035\000\125\001\125\001\125\001\125\001\018\001\239\002\
\070\001\019\001\020\001\076\001\047\002\028\000\209\002\210\002\
\018\001\077\001\176\000\019\001\020\001\088\001\086\000\028\000\
\097\001\086\000\086\000\016\002\017\002\086\000\200\001\098\001\
\020\003\229\000\229\000\014\002\015\002\249\002\099\001\229\000\
\100\001\125\001\229\000\229\000\229\000\229\000\229\000\229\000\
\229\000\101\001\229\000\229\000\229\000\229\000\229\000\229\000\
\229\000\229\000\229\000\229\000\229\000\229\000\229\000\229\000\
\229\000\229\000\106\001\086\000\138\001\086\000\022\002\023\002\
\086\000\086\000\086\000\086\000\086\000\030\000\139\001\190\001\
\140\001\115\001\115\001\115\001\010\003\115\001\115\001\030\000\
\141\001\229\000\034\000\115\001\035\000\086\000\107\001\108\001\
\115\001\115\001\115\001\115\001\034\000\115\001\035\000\229\000\
\229\000\146\001\086\000\229\000\086\000\229\000\229\000\229\000\
\046\001\252\000\253\000\254\000\109\001\110\001\149\001\111\001\
\162\001\163\001\112\001\003\001\004\001\005\001\006\001\164\001\
\165\001\229\000\229\000\147\001\229\000\150\001\018\001\115\001\
\153\001\019\001\020\001\170\001\171\001\028\000\229\000\154\001\
\229\000\218\000\218\000\046\001\155\001\178\001\229\000\218\000\
\229\000\179\001\218\000\218\000\218\000\218\000\218\000\218\000\
\218\000\180\001\218\000\218\000\218\000\218\000\218\000\218\000\
\218\000\218\000\218\000\218\000\218\000\218\000\218\000\218\000\
\218\000\218\000\194\001\195\001\089\002\197\001\046\001\189\001\
\221\001\046\001\202\001\212\001\046\001\046\001\046\001\222\001\
\213\001\116\001\116\001\116\001\223\001\116\001\116\001\224\001\
\214\001\218\000\233\001\116\001\037\002\030\000\225\001\190\001\
\116\001\116\001\116\001\116\001\227\001\116\001\228\001\218\000\
\218\000\232\001\034\000\218\000\035\000\218\000\218\000\218\000\
\123\001\132\001\133\001\134\001\135\001\123\001\018\002\019\002\
\020\002\021\002\123\001\123\001\123\001\123\001\230\001\123\001\
\239\001\218\000\218\000\240\001\218\000\246\001\018\001\116\001\
\247\001\019\001\020\001\241\001\242\001\028\000\218\000\034\002\
\218\000\224\000\224\000\125\001\126\001\127\001\218\000\224\000\
\218\000\035\002\224\000\224\000\224\000\224\000\224\000\224\000\
\224\000\123\001\224\000\224\000\224\000\224\000\224\000\224\000\
\224\000\224\000\224\000\224\000\224\000\224\000\224\000\224\000\
\224\000\224\000\036\002\038\002\089\002\085\001\085\001\085\001\
\085\001\085\001\085\001\085\001\085\001\085\001\085\001\085\001\
\039\002\085\001\085\001\085\001\054\002\085\001\085\001\085\001\
\085\001\224\000\057\002\085\001\058\002\030\000\086\002\094\002\
\085\001\085\001\085\001\085\001\092\002\085\001\095\002\224\000\
\224\000\102\002\034\000\224\000\035\000\224\000\224\000\224\000\
\124\001\166\001\167\001\168\001\169\001\124\001\100\002\103\002\
\101\002\104\002\124\001\124\001\124\001\124\001\112\002\124\001\
\109\002\224\000\224\000\110\002\224\000\111\002\114\002\085\001\
\238\001\116\002\145\001\117\002\107\002\119\002\224\000\120\002\
\224\000\219\000\219\000\123\002\124\002\126\002\224\000\219\000\
\224\000\127\002\219\000\219\000\219\000\219\000\219\000\219\000\
\219\000\124\001\219\000\219\000\219\000\219\000\219\000\219\000\
\219\000\219\000\219\000\219\000\219\000\219\000\219\000\219\000\
\219\000\219\000\068\001\068\001\068\001\068\001\068\001\068\001\
\068\001\068\001\068\001\068\001\068\001\068\001\068\001\129\002\
\068\001\068\001\068\001\130\002\068\001\068\001\068\001\068\001\
\135\002\219\000\068\001\139\002\146\002\140\002\068\001\068\001\
\068\001\068\001\068\001\141\002\068\001\149\002\153\002\219\000\
\219\000\160\002\162\002\219\000\164\002\219\000\219\000\219\000\
\046\001\046\001\046\001\046\001\046\001\046\001\046\001\046\001\
\046\001\165\002\166\002\170\002\117\001\117\001\193\002\117\001\
\117\001\219\000\219\000\188\002\219\000\117\001\068\001\189\002\
\195\002\201\002\117\001\117\001\117\001\117\001\219\000\117\001\
\219\000\046\001\046\001\046\001\121\001\121\001\219\000\211\002\
\219\000\215\002\121\001\202\002\216\002\217\002\219\002\121\001\
\121\001\121\001\121\001\218\002\121\001\220\002\046\001\046\001\
\046\001\224\002\225\002\046\001\046\001\231\002\237\002\046\001\
\046\001\117\001\235\002\240\002\046\001\046\001\046\001\046\001\
\243\002\046\001\046\001\046\001\046\001\046\001\046\001\071\000\
\244\002\246\002\245\002\004\003\247\002\251\002\121\001\082\000\
\255\002\005\003\083\000\084\000\006\003\007\003\009\003\087\000\
\013\003\011\003\016\003\017\003\046\001\046\001\023\003\046\001\
\024\003\004\001\025\003\046\001\046\001\237\000\006\000\016\001\
\006\001\189\000\036\001\144\000\021\000\145\000\046\001\046\001\
\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\
\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\
\131\001\157\000\157\000\157\000\157\000\157\000\157\000\157\000\
\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\
\157\000\157\000\157\000\128\001\114\001\115\001\116\001\117\001\
\118\001\119\001\120\001\121\001\122\001\123\001\124\001\022\000\
\006\000\243\000\134\000\121\000\142\001\136\000\157\000\157\000\
\157\000\152\000\159\000\157\000\157\000\119\000\141\000\157\000\
\157\000\137\001\136\000\054\000\157\000\157\000\021\001\157\000\
\157\000\157\000\136\000\150\001\154\001\157\000\156\001\015\001\
\223\002\157\000\157\000\157\000\157\000\157\000\157\000\157\000\
\157\000\157\000\157\000\157\000\157\000\226\002\211\001\056\002\
\157\000\157\000\157\000\157\000\157\000\157\000\183\001\157\000\
\098\002\137\002\157\000\157\000\157\000\157\000\157\000\157\000\
\157\000\157\000\028\001\027\002\136\002\157\000\157\000\150\000\
\150\000\150\000\150\000\150\000\150\000\150\000\150\000\150\000\
\150\000\150\000\150\000\150\000\150\000\150\000\150\000\026\002\
\150\000\150\000\150\000\150\000\150\000\150\000\150\000\150\000\
\150\000\150\000\150\000\150\000\150\000\150\000\150\000\150\000\
\150\000\150\000\255\001\000\002\001\002\002\002\003\002\004\002\
\005\002\006\002\007\002\008\002\009\002\024\002\028\002\025\002\
\177\002\169\002\093\002\250\002\212\002\150\000\150\000\150\000\
\230\002\049\001\150\000\150\000\172\001\174\001\150\000\150\000\
\173\001\175\001\014\003\150\000\150\000\176\001\150\000\150\000\
\150\000\015\003\026\003\000\000\150\000\000\000\000\000\000\000\
\150\000\150\000\150\000\150\000\150\000\150\000\150\000\150\000\
\150\000\150\000\150\000\150\000\000\000\000\000\000\000\150\000\
\150\000\150\000\150\000\150\000\150\000\000\000\150\000\000\000\
\000\000\000\000\150\000\150\000\150\000\150\000\150\000\150\000\
\150\000\000\000\000\000\000\000\150\000\150\000\164\000\164\000\
\164\000\164\000\164\000\164\000\164\000\164\000\164\000\164\000\
\164\000\164\000\164\000\164\000\164\000\164\000\000\000\164\000\
\164\000\164\000\164\000\164\000\164\000\164\000\164\000\164\000\
\164\000\164\000\164\000\164\000\164\000\164\000\164\000\164\000\
\164\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\164\000\164\000\164\000\000\000\
\000\000\164\000\164\000\000\000\000\000\164\000\164\000\000\000\
\000\000\000\000\164\000\164\000\000\000\164\000\164\000\164\000\
\000\000\000\000\000\000\164\000\000\000\000\000\000\000\164\000\
\164\000\164\000\164\000\164\000\164\000\164\000\164\000\164\000\
\164\000\164\000\164\000\000\000\000\000\000\000\164\000\164\000\
\164\000\164\000\164\000\164\000\000\000\164\000\000\000\000\000\
\000\000\164\000\164\000\164\000\164\000\164\000\164\000\164\000\
\000\000\000\000\000\000\164\000\164\000\060\002\061\002\183\000\
\184\000\185\000\186\000\005\000\075\000\187\000\006\000\007\000\
\008\000\009\000\010\000\011\000\012\000\000\000\013\000\014\000\
\015\000\016\000\017\000\018\000\019\000\020\000\021\000\069\000\
\023\000\024\000\025\000\026\000\027\000\028\000\188\000\189\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\190\000\191\000\192\000\000\000\000\000\
\193\000\194\000\000\000\000\000\195\000\196\000\000\000\000\000\
\000\000\197\000\198\000\000\000\199\000\000\000\140\000\000\000\
\000\000\000\000\062\002\000\000\000\000\000\000\063\002\064\002\
\065\002\066\002\067\002\068\002\069\002\070\002\071\002\072\002\
\073\002\074\002\000\000\000\000\000\000\030\000\031\000\075\002\
\033\000\076\000\077\000\000\000\200\000\000\000\000\000\000\000\
\201\000\202\000\034\000\076\002\035\000\036\000\037\000\000\000\
\000\000\000\000\040\000\203\000\092\001\182\000\183\000\184\000\
\185\000\186\000\005\000\075\000\187\000\006\000\007\000\008\000\
\009\000\010\000\011\000\012\000\000\000\013\000\014\000\015\000\
\016\000\017\000\018\000\019\000\020\000\021\000\069\000\023\000\
\024\000\025\000\026\000\027\000\028\000\188\000\189\000\122\001\
\122\001\000\000\000\000\000\000\000\000\122\001\000\000\000\000\
\000\000\000\000\122\001\122\001\122\001\122\001\000\000\122\001\
\000\000\000\000\190\000\191\000\192\000\000\000\000\000\193\000\
\194\000\000\000\000\000\195\000\196\000\000\000\000\000\000\000\
\197\000\198\000\000\000\199\000\000\000\140\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\122\001\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\030\000\031\000\000\000\033\000\
\076\000\077\000\000\000\200\000\000\000\000\000\000\000\201\000\
\202\000\034\000\000\000\035\000\000\000\000\000\000\000\000\000\
\000\000\040\000\203\000\250\001\182\000\183\000\184\000\185\000\
\186\000\005\000\075\000\187\000\006\000\007\000\008\000\009\000\
\010\000\011\000\012\000\000\000\013\000\014\000\015\000\016\000\
\017\000\018\000\019\000\020\000\021\000\069\000\023\000\024\000\
\025\000\026\000\027\000\028\000\188\000\189\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\190\000\191\000\192\000\000\000\000\000\193\000\194\000\
\000\000\000\000\195\000\196\000\000\000\000\000\000\000\197\000\
\198\000\000\000\199\000\055\001\055\001\055\001\055\001\055\001\
\055\001\000\000\055\001\055\001\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\030\000\031\000\000\000\033\000\076\000\
\077\000\000\000\200\000\000\000\055\001\055\001\201\000\202\000\
\034\000\000\000\035\000\000\000\000\000\000\000\000\000\000\000\
\040\000\203\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\055\001\055\001\055\001\000\000\000\000\055\001\055\001\
\000\000\000\000\055\001\055\001\000\000\000\000\000\000\055\001\
\055\001\000\000\055\001\155\000\055\001\000\000\000\000\000\000\
\055\001\000\000\000\000\000\000\055\001\055\001\055\001\055\001\
\055\001\055\001\055\001\055\001\055\001\055\001\055\001\055\001\
\000\000\000\000\000\000\000\000\000\000\055\001\000\000\055\001\
\055\001\058\000\055\001\000\000\058\000\058\000\055\001\055\001\
\058\000\055\001\000\000\060\002\151\002\183\000\184\000\185\000\
\186\000\055\001\075\000\187\000\000\000\000\000\000\000\000\000\
\058\000\058\000\058\000\058\000\058\000\058\000\058\000\058\000\
\058\000\058\000\058\000\000\000\058\000\058\000\058\000\000\000\
\058\000\058\000\058\000\058\000\188\000\189\000\058\000\000\000\
\058\000\000\000\000\000\058\000\058\000\058\000\058\000\058\000\
\058\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\190\000\191\000\192\000\000\000\000\000\193\000\194\000\
\058\000\000\000\195\000\196\000\000\000\000\000\000\000\197\000\
\198\000\000\000\199\000\000\000\140\000\058\000\000\000\058\000\
\062\002\000\000\000\000\000\000\063\002\064\002\065\002\066\002\
\067\002\068\002\069\002\070\002\071\002\072\002\073\002\074\002\
\000\000\000\000\000\000\000\000\000\000\075\002\000\000\076\000\
\077\000\062\000\200\000\000\000\062\000\062\000\201\000\202\000\
\062\000\076\002\000\000\055\001\055\001\055\001\055\001\055\001\
\055\001\203\000\055\001\055\001\000\000\000\000\000\000\000\000\
\062\000\062\000\062\000\062\000\062\000\062\000\062\000\062\000\
\000\000\000\000\000\000\000\000\062\000\062\000\062\000\000\000\
\062\000\062\000\062\000\062\000\055\001\055\001\062\000\000\000\
\062\000\000\000\000\000\062\000\062\000\062\000\062\000\062\000\
\062\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\055\001\055\001\055\001\000\000\000\000\055\001\055\001\
\062\000\000\000\055\001\055\001\000\000\000\000\000\000\055\001\
\055\001\000\000\055\001\000\000\055\001\062\000\000\000\062\000\
\055\001\000\000\000\000\000\000\055\001\055\001\055\001\055\001\
\055\001\055\001\055\001\055\001\055\001\055\001\055\001\055\001\
\000\000\000\000\000\000\000\000\000\000\055\001\000\000\055\001\
\055\001\000\000\055\001\000\000\000\000\000\000\055\001\055\001\
\000\000\055\001\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\055\001\040\002\183\000\184\000\185\000\186\000\058\000\
\075\000\187\000\087\001\087\001\087\001\087\001\087\001\087\001\
\087\001\087\001\087\001\087\001\087\001\000\000\087\001\087\001\
\087\001\000\000\087\001\087\001\087\001\087\001\000\000\000\000\
\087\001\000\000\188\000\189\000\000\000\087\001\087\001\087\001\
\087\001\000\000\087\001\084\000\000\000\000\000\084\000\084\000\
\041\002\000\000\084\000\000\000\000\000\000\000\000\000\190\000\
\191\000\192\000\000\000\000\000\193\000\194\000\000\000\000\000\
\195\000\196\000\000\000\000\000\000\000\197\000\198\000\000\000\
\199\000\000\000\184\001\042\002\087\001\250\001\182\000\183\000\
\184\000\185\000\186\000\084\000\075\000\187\000\000\000\000\000\
\084\000\000\000\084\000\000\000\000\000\084\000\084\000\084\000\
\084\000\084\000\084\000\000\000\000\000\076\000\077\000\000\000\
\200\000\000\000\000\000\000\000\201\000\202\000\188\000\189\000\
\000\000\000\000\084\000\000\000\000\000\000\000\000\000\203\000\
\062\000\085\000\000\000\000\000\085\000\085\000\000\000\084\000\
\085\000\084\000\000\000\190\000\191\000\192\000\000\000\000\000\
\193\000\194\000\000\000\000\000\195\000\196\000\000\000\000\000\
\000\000\197\000\198\000\000\000\199\000\000\000\000\000\000\000\
\000\000\000\000\144\002\046\001\046\001\046\001\046\001\046\001\
\046\001\085\000\046\001\046\001\000\000\000\000\085\000\000\000\
\085\000\000\000\000\000\085\000\085\000\085\000\085\000\085\000\
\085\000\076\000\077\000\000\000\200\000\000\000\000\000\000\000\
\201\000\202\000\000\000\119\001\046\001\046\001\119\001\119\001\
\085\000\000\000\000\000\203\000\119\001\000\000\000\000\000\000\
\000\000\119\001\119\001\119\001\119\001\085\000\119\001\085\000\
\000\000\046\001\046\001\046\001\000\000\000\000\046\001\046\001\
\000\000\000\000\046\001\046\001\000\000\000\000\000\000\046\001\
\046\001\000\000\046\001\000\000\000\000\000\000\046\001\250\001\
\182\000\183\000\184\000\185\000\186\000\000\000\075\000\187\000\
\119\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\046\001\
\046\001\000\000\046\001\000\000\000\000\000\000\046\001\046\001\
\188\000\189\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\046\001\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\190\000\191\000\192\000\
\000\000\000\000\193\000\194\000\000\000\000\000\195\000\196\000\
\000\000\000\000\000\000\197\000\198\000\000\000\199\000\253\001\
\182\000\183\000\184\000\185\000\186\000\000\000\075\000\187\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\131\002\182\000\183\000\184\000\185\000\186\000\
\000\000\075\000\187\000\076\000\077\000\000\000\200\000\000\000\
\188\000\189\000\201\000\202\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\203\000\000\000\000\000\
\000\000\000\000\000\000\188\000\189\000\190\000\191\000\192\000\
\000\000\000\000\193\000\194\000\000\000\000\000\195\000\196\000\
\000\000\000\000\000\000\197\000\198\000\000\000\199\000\000\000\
\190\000\191\000\192\000\000\000\000\000\193\000\194\000\000\000\
\000\000\195\000\196\000\000\000\000\000\000\000\197\000\198\000\
\000\000\199\000\196\002\182\000\183\000\184\000\185\000\186\000\
\000\000\075\000\187\000\076\000\077\000\000\000\200\000\000\000\
\000\000\000\000\201\000\202\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\203\000\076\000\077\000\
\000\000\200\000\000\000\188\000\189\000\201\000\202\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\203\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\190\000\191\000\192\000\000\000\000\000\193\000\194\000\000\000\
\000\000\195\000\196\000\000\000\000\000\000\000\197\000\198\000\
\000\000\199\000\019\003\182\000\183\000\184\000\185\000\186\000\
\000\000\075\000\187\000\000\000\107\001\107\001\107\001\107\001\
\107\001\107\001\000\000\000\000\000\000\000\000\000\000\000\000\
\107\001\107\001\107\001\000\000\107\001\107\001\076\000\077\000\
\000\000\200\000\107\001\188\000\189\000\201\000\202\000\107\001\
\107\001\107\001\107\001\000\000\107\001\000\000\000\000\000\000\
\203\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\190\000\191\000\192\000\000\000\120\001\193\000\194\000\120\001\
\120\001\195\000\196\000\000\000\000\000\120\001\197\000\198\000\
\000\000\199\000\120\001\120\001\120\001\120\001\107\001\120\001\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\076\000\077\000\
\000\000\200\000\000\000\000\000\000\000\201\000\202\000\000\000\
\000\000\120\001\000\000\000\000\000\000\000\000\000\000\000\000\
\203\000\182\000\183\000\184\000\185\000\186\000\005\000\075\000\
\187\000\006\000\007\000\008\000\009\000\010\000\011\000\012\000\
\000\000\013\000\014\000\015\000\016\000\017\000\018\000\019\000\
\020\000\021\000\069\000\023\000\024\000\025\000\026\000\027\000\
\028\000\188\000\189\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\190\000\191\000\
\192\000\000\000\000\000\193\000\194\000\000\000\000\000\195\000\
\196\000\000\000\000\000\000\000\197\000\198\000\000\000\199\000\
\000\000\118\001\118\001\000\000\118\001\118\001\000\000\000\000\
\000\000\000\000\118\001\000\000\000\000\000\000\000\000\118\001\
\118\001\118\001\118\001\000\000\118\001\000\000\000\000\000\000\
\030\000\031\000\000\000\033\000\076\000\077\000\000\000\200\000\
\000\000\000\000\000\000\201\000\202\000\034\000\163\000\035\000\
\000\000\000\000\000\000\000\000\005\000\040\000\203\000\006\000\
\007\000\008\000\009\000\010\000\011\000\012\000\118\001\013\000\
\014\000\015\000\016\000\017\000\018\000\019\000\020\000\021\000\
\069\000\023\000\024\000\025\000\026\000\027\000\028\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\227\000\092\000\000\000\
\000\000\093\000\000\000\094\000\075\000\000\000\000\000\000\000\
\000\000\000\000\000\000\131\000\131\000\131\000\131\000\131\000\
\000\000\131\000\131\000\000\000\000\000\000\000\095\000\000\000\
\000\000\096\000\000\000\164\000\000\000\000\000\097\000\098\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\131\000\131\000\131\000\030\000\031\000\
\000\000\033\000\000\000\099\000\100\000\101\000\000\000\000\000\
\102\000\103\000\000\000\034\000\104\000\035\000\036\000\037\000\
\131\000\131\000\131\000\040\000\105\000\131\000\131\000\000\000\
\000\000\131\000\131\000\000\000\000\000\000\000\131\000\131\000\
\000\000\131\000\000\000\131\000\106\000\000\000\000\000\182\000\
\183\000\184\000\185\000\186\000\000\000\075\000\187\000\000\000\
\000\000\076\000\077\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\131\000\131\000\
\000\000\131\000\000\000\000\000\000\000\131\000\131\000\188\000\
\189\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\131\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\190\000\191\000\192\000\000\000\
\000\000\193\000\194\000\000\000\000\000\195\000\196\000\000\000\
\000\000\000\000\197\000\198\000\000\000\199\000\000\000\184\001\
\000\000\000\000\000\000\182\000\183\000\184\000\185\000\186\000\
\000\000\075\000\187\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\076\000\077\000\000\000\200\000\000\000\000\000\
\000\000\201\000\202\000\188\000\189\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\203\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\190\000\191\000\192\000\000\000\000\000\193\000\194\000\000\000\
\000\000\195\000\196\000\000\000\000\000\000\000\197\000\198\000\
\000\000\199\000\000\000\107\002\000\000\000\000\000\000\127\000\
\127\000\127\000\127\000\127\000\000\000\127\000\127\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\076\000\077\000\
\000\000\200\000\000\000\000\000\000\000\201\000\202\000\127\000\
\127\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\203\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\127\000\127\000\127\000\000\000\
\000\000\127\000\127\000\000\000\000\000\127\000\127\000\000\000\
\000\000\000\000\127\000\127\000\000\000\127\000\000\000\127\000\
\000\000\000\000\000\000\182\000\183\000\184\000\185\000\186\000\
\000\000\075\000\187\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\127\000\127\000\000\000\127\000\000\000\000\000\
\000\000\127\000\127\000\188\000\189\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\127\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\190\000\191\000\192\000\000\000\000\000\193\000\194\000\000\000\
\000\000\195\000\196\000\000\000\000\000\000\000\197\000\198\000\
\000\000\235\000\182\000\183\000\184\000\185\000\186\000\000\000\
\075\000\187\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\182\000\183\000\184\000\
\185\000\186\000\000\000\075\000\187\000\000\000\076\000\077\000\
\000\000\200\000\188\000\189\000\000\000\201\000\202\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\203\000\000\000\000\000\000\000\000\000\188\000\189\000\190\000\
\191\000\192\000\000\000\000\000\193\000\194\000\000\000\000\000\
\195\000\196\000\000\000\000\000\000\000\197\000\198\000\000\000\
\237\000\000\000\190\000\191\000\192\000\000\000\000\000\193\000\
\194\000\000\000\000\000\195\000\196\000\000\000\000\000\000\000\
\197\000\198\000\000\000\199\000\182\000\183\000\184\000\185\000\
\186\000\000\000\075\000\187\000\000\000\076\000\077\000\000\000\
\200\000\000\000\000\000\000\000\201\000\202\000\000\000\182\000\
\183\000\184\000\185\000\186\000\000\000\075\000\187\000\203\000\
\076\000\077\000\000\000\200\000\188\000\189\000\000\000\201\000\
\202\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\203\000\000\000\000\000\000\000\000\000\188\000\
\189\000\190\000\191\000\192\000\000\000\000\000\193\000\194\000\
\000\000\000\000\195\000\196\000\000\000\000\000\000\000\197\000\
\198\000\000\000\078\001\000\000\190\000\191\000\192\000\000\000\
\000\000\193\000\194\000\000\000\000\000\195\000\196\000\000\000\
\000\000\000\000\197\000\198\000\000\000\080\001\182\000\183\000\
\184\000\185\000\186\000\000\000\075\000\187\000\000\000\076\000\
\077\000\000\000\200\000\000\000\000\000\000\000\201\000\202\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\203\000\076\000\077\000\000\000\200\000\188\000\189\000\
\000\000\201\000\202\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\203\000\000\000\000\000\000\000\
\000\000\000\000\000\000\190\000\191\000\192\000\000\000\000\000\
\193\000\194\000\000\000\000\000\195\000\196\000\004\000\000\000\
\000\000\197\000\198\000\005\000\089\001\000\000\006\000\007\000\
\008\000\009\000\010\000\011\000\012\000\000\000\013\000\014\000\
\015\000\016\000\017\000\018\000\019\000\020\000\021\000\022\000\
\023\000\024\000\025\000\026\000\027\000\028\000\000\000\000\000\
\000\000\076\000\077\000\000\000\200\000\000\000\000\000\000\000\
\201\000\202\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\203\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\004\000\000\000\000\000\000\000\000\000\
\005\000\000\000\000\000\006\000\007\000\008\000\009\000\010\000\
\011\000\012\000\029\000\013\000\014\000\015\000\016\000\017\000\
\018\000\019\000\020\000\021\000\022\000\023\000\024\000\025\000\
\026\000\027\000\028\000\000\000\000\000\030\000\031\000\032\000\
\033\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\034\000\000\000\035\000\036\000\037\000\000\000\
\038\000\039\000\040\000\000\000\000\000\000\000\072\001\072\001\
\072\001\072\001\072\001\072\001\072\001\072\001\072\001\072\001\
\072\001\072\001\072\001\000\000\072\001\072\001\072\001\000\000\
\072\001\072\001\072\001\072\001\000\000\000\000\072\001\000\000\
\000\000\000\000\072\001\072\001\000\000\072\001\072\001\000\000\
\072\001\000\000\030\000\031\000\032\000\033\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\034\000\
\000\000\035\000\036\000\037\000\000\000\038\000\039\000\040\000\
\107\000\000\000\000\000\107\000\107\000\107\000\107\000\107\000\
\107\000\107\000\072\001\107\000\107\000\107\000\107\000\107\000\
\107\000\107\000\107\000\107\000\107\000\107\000\107\000\107\000\
\107\000\107\000\107\000\000\000\000\000\107\000\107\000\107\000\
\107\000\107\000\107\000\107\000\107\000\107\000\107\000\107\000\
\107\000\107\000\107\000\107\000\107\000\107\000\107\000\107\000\
\107\000\107\000\107\000\107\000\107\000\000\000\107\000\107\000\
\107\000\000\000\107\000\107\000\107\000\107\000\107\000\107\000\
\107\000\107\000\107\000\107\000\107\000\107\000\107\000\107\000\
\107\000\107\000\107\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\107\000\107\000\000\000\107\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\107\000\
\000\000\107\000\000\000\000\000\107\000\005\000\075\000\107\000\
\006\000\007\000\008\000\009\000\010\000\011\000\012\000\000\000\
\013\000\014\000\015\000\016\000\017\000\018\000\019\000\020\000\
\021\000\069\000\023\000\024\000\025\000\026\000\027\000\028\000\
\005\000\000\000\000\000\006\000\007\000\008\000\009\000\010\000\
\011\000\012\000\000\000\013\000\014\000\015\000\016\000\017\000\
\018\000\019\000\020\000\021\000\069\000\023\000\024\000\025\000\
\026\000\027\000\028\000\000\000\000\000\000\000\003\001\000\000\
\000\000\003\001\003\001\003\001\003\001\003\001\003\001\003\001\
\000\000\003\001\003\001\003\001\003\001\003\001\003\001\003\001\
\003\001\003\001\003\001\003\001\003\001\003\001\003\001\003\001\
\003\001\000\000\000\000\000\000\000\000\000\000\000\000\030\000\
\031\000\149\000\033\000\076\000\077\000\000\000\000\000\000\000\
\000\000\207\001\000\000\000\000\034\000\000\000\035\000\000\000\
\000\000\000\000\000\000\000\000\040\000\000\000\000\000\000\000\
\000\000\000\000\030\000\031\000\000\000\033\000\003\001\003\001\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\034\000\
\000\000\035\000\000\000\000\000\000\000\000\000\000\000\040\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\003\001\003\001\000\000\003\001\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\003\001\000\000\003\001\
\000\000\000\000\000\000\005\000\000\000\003\001\006\000\007\000\
\008\000\009\000\010\000\011\000\012\000\000\000\013\000\014\000\
\015\000\016\000\017\000\018\000\019\000\020\000\021\000\069\000\
\023\000\024\000\025\000\026\000\027\000\028\000\005\000\000\000\
\000\000\006\000\007\000\008\000\009\000\010\000\011\000\012\000\
\000\000\013\000\014\000\015\000\016\000\017\000\018\000\019\000\
\020\000\021\000\069\000\023\000\024\000\025\000\026\000\027\000\
\028\000\000\000\005\000\000\000\000\000\006\000\007\000\008\000\
\009\000\010\000\011\000\012\000\149\000\013\000\014\000\015\000\
\016\000\017\000\018\000\019\000\020\000\021\000\069\000\023\000\
\024\000\025\000\026\000\027\000\028\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\030\000\031\000\000\000\
\033\000\175\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\034\000\000\000\035\000\000\000\000\000\000\000\
\000\000\000\000\040\000\000\000\000\000\000\000\000\000\000\000\
\030\000\031\000\000\000\033\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\213\002\000\000\034\000\000\000\035\000\
\000\000\000\000\000\000\000\000\000\000\040\000\000\000\000\000\
\000\000\000\000\000\000\000\000\030\000\031\000\000\000\033\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\034\000\000\000\035\000\000\000\000\000\000\000\005\000\
\000\000\040\000\006\000\007\000\008\000\009\000\010\000\011\000\
\012\000\000\000\013\000\014\000\015\000\016\000\017\000\018\000\
\019\000\020\000\021\000\069\000\023\000\024\000\025\000\026\000\
\027\000\028\000\006\000\007\000\008\000\009\000\010\000\011\000\
\012\000\000\000\013\000\014\000\015\000\016\000\017\000\018\000\
\019\000\020\000\021\000\069\000\023\000\024\000\025\000\026\000\
\027\000\028\000\000\000\000\000\227\000\092\000\000\000\000\000\
\093\000\000\000\094\000\075\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\095\000\000\000\000\000\
\096\000\000\000\000\000\000\000\000\000\097\000\098\000\000\000\
\000\000\030\000\031\000\000\000\033\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\034\000\000\000\
\035\000\000\000\099\000\100\000\101\000\000\000\040\000\102\000\
\103\000\030\000\031\000\104\000\033\000\000\000\000\000\000\000\
\000\000\000\000\148\001\105\000\000\000\000\000\034\000\000\000\
\035\000\073\001\092\000\000\000\000\000\093\000\040\000\094\000\
\075\000\000\000\000\000\106\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\076\000\077\000\095\000\000\000\000\000\096\000\000\000\000\000\
\000\000\000\000\097\000\098\000\000\000\031\002\092\000\000\000\
\000\000\093\000\000\000\094\000\075\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\099\000\
\100\000\101\000\000\000\000\000\102\000\103\000\095\000\000\000\
\104\000\096\000\000\000\000\000\000\000\000\000\097\000\098\000\
\105\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\106\000\000\000\000\000\099\000\100\000\101\000\000\000\000\000\
\102\000\103\000\000\000\000\000\104\000\076\000\077\000\000\000\
\000\000\000\000\000\000\092\000\105\000\000\000\093\000\000\000\
\094\000\075\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\106\000\000\000\000\000\000\000\
\000\000\000\000\000\000\095\000\000\000\000\000\096\000\000\000\
\000\000\076\000\077\000\097\000\098\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\099\000\100\000\101\000\000\000\000\000\102\000\103\000\000\000\
\000\000\104\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\105\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\106\000\000\000\000\000\000\000\000\000\106\000\000\000\
\000\000\106\000\106\000\000\000\000\000\106\000\076\000\077\000\
\106\000\106\000\106\000\106\000\106\000\106\000\106\000\106\000\
\106\000\106\000\106\000\106\000\106\000\106\000\106\000\106\000\
\106\000\106\000\106\000\106\000\106\000\106\000\106\000\106\000\
\000\000\106\000\106\000\106\000\000\000\106\000\106\000\106\000\
\106\000\106\000\106\000\106\000\106\000\106\000\000\000\106\000\
\106\000\106\000\106\000\106\000\106\000\106\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\106\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\106\000\000\000\106\000\042\000\000\000\106\000\
\042\000\042\000\000\000\000\000\042\000\000\000\000\000\042\000\
\042\000\042\000\042\000\042\000\042\000\042\000\042\000\042\000\
\042\000\042\000\000\000\000\000\042\000\042\000\042\000\042\000\
\042\000\042\000\042\000\042\000\042\000\042\000\042\000\000\000\
\042\000\042\000\042\000\000\000\042\000\042\000\042\000\042\000\
\000\000\000\000\042\000\000\000\042\000\000\000\000\000\042\000\
\042\000\042\000\042\000\042\000\042\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\042\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\042\000\000\000\042\000\046\000\000\000\042\000\046\000\
\046\000\000\000\000\000\046\000\000\000\000\000\046\000\046\000\
\046\000\046\000\046\000\046\000\046\000\046\000\046\000\046\000\
\046\000\000\000\000\000\046\000\046\000\046\000\046\000\046\000\
\046\000\046\000\046\000\046\000\046\000\046\000\000\000\046\000\
\046\000\046\000\000\000\046\000\046\000\046\000\046\000\000\000\
\000\000\046\000\000\000\046\000\000\000\000\000\046\000\046\000\
\046\000\046\000\046\000\046\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\046\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\046\000\000\000\046\000\048\000\000\000\046\000\048\000\048\000\
\000\000\000\000\048\000\000\000\000\000\048\000\048\000\048\000\
\048\000\048\000\048\000\048\000\048\000\048\000\048\000\048\000\
\000\000\000\000\048\000\048\000\048\000\048\000\048\000\048\000\
\048\000\048\000\048\000\048\000\048\000\000\000\048\000\048\000\
\048\000\000\000\048\000\048\000\048\000\048\000\000\000\000\000\
\048\000\000\000\048\000\000\000\000\000\048\000\048\000\048\000\
\048\000\048\000\048\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\063\000\000\000\048\000\063\000\063\000\000\000\000\000\063\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\048\000\
\000\000\048\000\000\000\000\000\048\000\000\000\000\000\063\000\
\063\000\063\000\063\000\063\000\063\000\063\000\063\000\000\000\
\000\000\000\000\000\000\063\000\063\000\063\000\000\000\063\000\
\063\000\063\000\063\000\000\000\000\000\063\000\000\000\063\000\
\000\000\000\000\063\000\063\000\063\000\063\000\063\000\063\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\064\000\000\000\000\000\064\000\064\000\000\000\063\000\
\064\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\063\000\000\000\063\000\000\000\
\064\000\064\000\064\000\064\000\064\000\064\000\064\000\064\000\
\000\000\000\000\000\000\000\000\064\000\064\000\064\000\000\000\
\064\000\064\000\064\000\064\000\000\000\000\000\064\000\000\000\
\064\000\000\000\000\000\064\000\064\000\064\000\064\000\064\000\
\064\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\065\000\000\000\000\000\065\000\065\000\000\000\
\064\000\065\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\064\000\000\000\064\000\
\000\000\065\000\065\000\065\000\065\000\065\000\065\000\000\000\
\000\000\000\000\000\000\000\000\000\000\065\000\065\000\065\000\
\000\000\065\000\065\000\065\000\065\000\000\000\000\000\065\000\
\000\000\065\000\000\000\000\000\065\000\065\000\065\000\065\000\
\065\000\065\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\066\000\000\000\000\000\066\000\066\000\
\000\000\065\000\066\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\065\000\000\000\
\065\000\000\000\066\000\066\000\066\000\066\000\066\000\066\000\
\000\000\000\000\000\000\000\000\000\000\000\000\066\000\066\000\
\066\000\000\000\066\000\066\000\066\000\066\000\000\000\000\000\
\066\000\000\000\066\000\000\000\000\000\066\000\066\000\066\000\
\066\000\066\000\066\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\067\000\000\000\000\000\067\000\
\067\000\000\000\066\000\067\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\066\000\
\000\000\066\000\000\000\067\000\067\000\067\000\067\000\067\000\
\067\000\000\000\000\000\000\000\000\000\000\000\000\000\067\000\
\067\000\067\000\000\000\067\000\067\000\067\000\067\000\000\000\
\000\000\067\000\000\000\067\000\000\000\000\000\067\000\067\000\
\067\000\067\000\067\000\067\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\068\000\000\000\000\000\
\068\000\068\000\000\000\067\000\068\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\067\000\000\000\067\000\000\000\068\000\068\000\068\000\068\000\
\068\000\068\000\000\000\000\000\000\000\000\000\000\000\000\000\
\068\000\068\000\068\000\000\000\068\000\068\000\000\000\000\000\
\000\000\000\000\068\000\000\000\068\000\000\000\000\000\068\000\
\068\000\068\000\068\000\068\000\068\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\069\000\000\000\
\000\000\069\000\069\000\000\000\068\000\069\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\068\000\000\000\068\000\000\000\069\000\069\000\069\000\
\069\000\069\000\069\000\000\000\000\000\000\000\000\000\000\000\
\000\000\069\000\069\000\069\000\000\000\069\000\069\000\000\000\
\000\000\000\000\000\000\069\000\000\000\069\000\000\000\000\000\
\069\000\069\000\069\000\069\000\069\000\069\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\070\000\
\000\000\000\000\070\000\070\000\000\000\069\000\070\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\069\000\000\000\069\000\000\000\070\000\070\000\
\070\000\070\000\070\000\070\000\000\000\000\000\000\000\000\000\
\000\000\000\000\070\000\070\000\070\000\000\000\070\000\070\000\
\000\000\000\000\000\000\000\000\070\000\000\000\070\000\000\000\
\000\000\070\000\070\000\070\000\070\000\070\000\070\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\071\000\000\000\000\000\071\000\071\000\000\000\070\000\071\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\070\000\000\000\070\000\000\000\071\000\
\071\000\071\000\071\000\071\000\071\000\000\000\000\000\000\000\
\000\000\000\000\000\000\071\000\071\000\071\000\000\000\071\000\
\071\000\000\000\000\000\000\000\000\000\071\000\000\000\071\000\
\000\000\000\000\071\000\071\000\071\000\071\000\071\000\071\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\072\000\000\000\000\000\072\000\072\000\000\000\071\000\
\072\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\071\000\000\000\071\000\000\000\
\072\000\072\000\072\000\072\000\072\000\072\000\000\000\000\000\
\000\000\000\000\000\000\000\000\072\000\072\000\072\000\000\000\
\072\000\072\000\000\000\000\000\000\000\000\000\072\000\000\000\
\072\000\000\000\000\000\072\000\072\000\072\000\072\000\072\000\
\072\000\073\000\000\000\000\000\073\000\073\000\000\000\000\000\
\073\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\072\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\073\000\073\000\000\000\000\000\000\000\072\000\000\000\072\000\
\000\000\000\000\000\000\000\000\073\000\073\000\073\000\000\000\
\073\000\073\000\000\000\000\000\000\000\000\000\073\000\000\000\
\073\000\000\000\000\000\073\000\073\000\073\000\073\000\073\000\
\073\000\074\000\000\000\000\000\074\000\074\000\000\000\000\000\
\074\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\073\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\074\000\074\000\000\000\000\000\000\000\073\000\000\000\073\000\
\000\000\000\000\000\000\000\000\074\000\074\000\074\000\000\000\
\074\000\074\000\000\000\000\000\000\000\000\000\074\000\000\000\
\074\000\000\000\000\000\074\000\074\000\074\000\074\000\074\000\
\074\000\075\000\000\000\000\000\075\000\075\000\000\000\000\000\
\075\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\074\000\000\000\000\000\000\000\000\000\000\000\000\000\076\000\
\075\000\075\000\076\000\076\000\000\000\074\000\076\000\074\000\
\000\000\000\000\000\000\000\000\075\000\075\000\075\000\000\000\
\075\000\075\000\000\000\000\000\000\000\000\000\075\000\000\000\
\075\000\000\000\000\000\075\000\075\000\075\000\075\000\075\000\
\075\000\000\000\076\000\076\000\076\000\000\000\076\000\076\000\
\000\000\000\000\000\000\000\000\076\000\000\000\076\000\000\000\
\075\000\076\000\076\000\076\000\076\000\076\000\076\000\077\000\
\000\000\000\000\077\000\077\000\000\000\075\000\077\000\075\000\
\000\000\000\000\000\000\000\000\000\000\000\000\076\000\000\000\
\000\000\000\000\000\000\000\000\000\000\078\000\000\000\000\000\
\078\000\078\000\000\000\076\000\078\000\076\000\000\000\000\000\
\000\000\000\000\077\000\077\000\077\000\000\000\077\000\077\000\
\000\000\000\000\000\000\000\000\077\000\000\000\077\000\000\000\
\000\000\077\000\077\000\077\000\077\000\077\000\077\000\000\000\
\000\000\078\000\078\000\000\000\078\000\078\000\000\000\000\000\
\000\000\000\000\078\000\000\000\078\000\000\000\077\000\078\000\
\078\000\078\000\078\000\078\000\078\000\079\000\000\000\000\000\
\079\000\079\000\000\000\077\000\079\000\077\000\000\000\000\000\
\000\000\000\000\000\000\000\000\078\000\000\000\000\000\000\000\
\000\000\000\000\000\000\080\000\000\000\000\000\080\000\080\000\
\000\000\078\000\080\000\078\000\000\000\000\000\000\000\000\000\
\000\000\079\000\079\000\000\000\079\000\079\000\000\000\000\000\
\000\000\000\000\079\000\000\000\079\000\000\000\000\000\079\000\
\079\000\079\000\079\000\079\000\079\000\000\000\000\000\080\000\
\000\000\000\000\080\000\080\000\000\000\000\000\000\000\000\000\
\080\000\000\000\080\000\000\000\079\000\080\000\080\000\080\000\
\080\000\080\000\080\000\081\000\000\000\000\000\081\000\081\000\
\000\000\079\000\081\000\079\000\000\000\000\000\000\000\000\000\
\000\000\000\000\080\000\000\000\000\000\000\000\000\000\000\000\
\000\000\082\000\000\000\000\000\082\000\082\000\000\000\080\000\
\082\000\080\000\000\000\000\000\000\000\000\000\000\000\081\000\
\000\000\000\000\081\000\081\000\000\000\000\000\000\000\000\000\
\081\000\000\000\081\000\000\000\000\000\081\000\081\000\081\000\
\081\000\081\000\081\000\000\000\000\000\000\000\000\000\000\000\
\082\000\082\000\000\000\000\000\000\000\000\000\082\000\000\000\
\082\000\000\000\081\000\082\000\082\000\082\000\082\000\082\000\
\082\000\083\000\000\000\000\000\083\000\083\000\000\000\081\000\
\083\000\081\000\000\000\000\000\000\000\000\000\000\000\000\000\
\082\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\082\000\000\000\082\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\083\000\083\000\000\000\000\000\000\000\000\000\083\000\000\000\
\083\000\000\000\000\000\083\000\083\000\083\000\083\000\083\000\
\083\000\000\000\000\000\000\000\000\000\089\001\089\001\089\001\
\089\001\089\001\089\001\089\001\089\001\089\001\089\001\089\001\
\083\000\089\001\089\001\089\001\000\000\089\001\089\001\089\001\
\089\001\000\000\000\000\089\001\000\000\083\000\000\000\083\000\
\089\001\089\001\089\001\089\001\000\000\089\001\101\001\101\001\
\101\001\101\001\101\001\101\001\101\001\101\001\000\000\000\000\
\000\000\000\000\101\001\101\001\101\001\000\000\101\001\101\001\
\101\001\101\001\000\000\000\000\101\001\000\000\000\000\000\000\
\000\000\101\001\101\001\101\001\101\001\000\000\101\001\089\001\
\000\000\102\001\102\001\102\001\102\001\102\001\102\001\102\001\
\102\001\000\000\000\000\000\000\000\000\102\001\102\001\102\001\
\000\000\102\001\102\001\102\001\102\001\000\000\000\000\102\001\
\000\000\000\000\000\000\000\000\102\001\102\001\102\001\102\001\
\101\001\102\001\103\001\103\001\103\001\103\001\103\001\103\001\
\103\001\103\001\000\000\000\000\000\000\000\000\103\001\103\001\
\103\001\000\000\103\001\103\001\103\001\103\001\000\000\000\000\
\103\001\000\000\000\000\000\000\000\000\103\001\103\001\103\001\
\103\001\000\000\103\001\102\001\000\000\104\001\104\001\104\001\
\104\001\104\001\104\001\000\000\000\000\000\000\000\000\000\000\
\000\000\104\001\104\001\104\001\000\000\104\001\104\001\104\001\
\104\001\000\000\000\000\104\001\000\000\000\000\000\000\000\000\
\104\001\104\001\104\001\104\001\103\001\104\001\105\001\105\001\
\105\001\105\001\105\001\105\001\000\000\000\000\000\000\000\000\
\000\000\000\000\105\001\105\001\105\001\000\000\105\001\105\001\
\105\001\105\001\000\000\000\000\105\001\000\000\000\000\000\000\
\000\000\105\001\105\001\105\001\105\001\000\000\105\001\104\001\
\000\000\106\001\106\001\106\001\106\001\106\001\106\001\000\000\
\000\000\000\000\000\000\000\000\000\000\106\001\106\001\106\001\
\000\000\106\001\106\001\106\001\106\001\000\000\000\000\106\001\
\000\000\000\000\000\000\000\000\106\001\106\001\106\001\106\001\
\105\001\106\001\108\001\108\001\108\001\108\001\108\001\108\001\
\000\000\000\000\000\000\000\000\000\000\000\000\108\001\108\001\
\108\001\000\000\108\001\108\001\000\000\000\000\000\000\000\000\
\108\001\000\000\000\000\000\000\000\000\108\001\108\001\108\001\
\108\001\000\000\108\001\106\001\000\000\109\001\109\001\109\001\
\109\001\109\001\109\001\000\000\000\000\000\000\000\000\000\000\
\000\000\109\001\109\001\109\001\000\000\109\001\109\001\000\000\
\000\000\000\000\000\000\109\001\000\000\000\000\000\000\000\000\
\109\001\109\001\109\001\109\001\108\001\109\001\110\001\110\001\
\110\001\110\001\110\001\110\001\000\000\000\000\000\000\000\000\
\000\000\000\000\110\001\110\001\110\001\000\000\110\001\110\001\
\000\000\000\000\000\000\000\000\110\001\000\000\000\000\000\000\
\000\000\110\001\110\001\110\001\110\001\000\000\110\001\109\001\
\000\000\111\001\111\001\111\001\111\001\111\001\111\001\000\000\
\000\000\000\000\000\000\000\000\000\000\111\001\111\001\111\001\
\000\000\111\001\111\001\000\000\000\000\000\000\000\000\111\001\
\112\001\112\001\000\000\000\000\111\001\111\001\111\001\111\001\
\110\001\111\001\000\000\000\000\112\001\112\001\112\001\000\000\
\112\001\112\001\000\000\000\000\000\000\000\000\112\001\113\001\
\113\001\000\000\000\000\112\001\112\001\112\001\112\001\000\000\
\112\001\000\000\000\000\113\001\113\001\113\001\000\000\113\001\
\113\001\000\000\000\000\111\001\000\000\113\001\114\001\114\001\
\000\000\000\000\113\001\113\001\113\001\113\001\000\000\113\001\
\000\000\000\000\114\001\114\001\114\001\000\000\114\001\114\001\
\000\000\000\000\112\001\000\000\114\001\000\000\000\000\000\000\
\000\000\114\001\114\001\114\001\114\001\000\000\114\001\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\113\001\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\114\001\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
\023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
\023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
\023\000\000\000\023\000\023\000\023\000\000\000\023\000\023\000\
\023\000\023\000\023\000\023\000\000\000\023\000\023\000\000\000\
\023\000\000\000\018\000\000\000\023\000\000\000\023\000\023\000\
\023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
\023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
\023\000\023\000\023\000\023\000\023\000\023\000\023\000\000\000\
\023\000\023\000\023\000\000\000\023\000\023\000\023\000\023\000\
\023\000\023\000\000\000\023\000\000\000\000\000\023\000\000\000\
\000\000\023\000\023\000\000\000\023\000"

let yycheck = "\022\000\
\049\000\089\000\001\000\002\000\078\000\061\000\004\000\029\000\
\139\000\026\001\150\000\199\000\192\001\045\000\037\000\014\001\
\035\001\045\000\001\000\002\000\000\000\000\000\044\000\000\000\
\028\001\051\001\052\001\023\001\129\000\000\001\029\000\027\001\
\015\000\179\000\159\000\160\000\092\000\125\000\000\001\022\000\
\023\000\079\000\153\002\026\000\027\000\044\000\029\000\235\000\
\031\000\237\000\000\001\071\001\149\000\121\002\013\000\014\000\
\037\000\016\000\007\001\008\001\000\001\044\000\001\001\046\000\
\199\000\088\000\000\001\090\000\051\000\209\000\053\000\007\001\
\000\001\056\000\071\001\150\000\099\000\100\000\101\000\102\000\
\103\000\104\000\105\000\077\001\056\001\072\001\069\000\067\002\
\046\001\047\001\070\002\078\001\056\001\073\002\205\002\078\000\
\001\000\002\000\000\001\000\001\235\000\072\001\237\000\001\001\
\076\001\064\000\089\000\001\001\006\001\068\000\007\001\073\001\
\006\001\077\001\182\002\074\000\074\001\071\001\150\000\001\001\
\114\001\073\001\150\000\073\001\105\000\124\000\190\000\191\000\
\192\000\193\000\194\000\195\000\071\001\073\001\209\000\001\001\
\247\002\077\001\078\001\073\001\006\001\124\000\001\001\077\001\
\176\000\073\001\078\001\006\001\080\001\070\001\199\000\100\001\
\101\001\175\000\056\001\076\001\179\000\089\001\099\000\100\000\
\101\000\102\000\103\000\104\000\100\001\101\001\149\000\091\002\
\001\001\188\001\208\000\072\000\073\001\006\001\056\001\073\001\
\175\000\071\001\023\001\111\001\112\001\209\000\027\001\028\001\
\053\001\001\001\235\000\070\001\237\000\193\001\006\001\217\001\
\175\000\189\001\026\001\078\001\073\001\056\001\065\001\078\001\
\204\001\080\001\043\001\100\001\101\001\071\001\071\001\203\001\
\231\000\205\001\089\001\143\001\071\001\080\001\046\001\074\001\
\199\000\092\001\070\001\098\001\099\001\119\001\202\002\130\002\
\056\001\119\001\078\001\207\002\251\000\252\000\253\000\254\000\
\255\000\000\001\001\001\002\001\003\001\004\001\005\001\006\001\
\007\001\008\001\009\001\010\001\011\001\012\001\013\001\014\001\
\024\001\021\001\071\001\247\001\235\000\119\001\237\000\145\001\
\146\001\073\001\165\002\107\002\119\001\056\001\047\001\164\000\
\071\002\097\001\167\000\168\000\169\000\001\001\251\000\172\000\
\173\000\071\001\006\001\123\002\000\001\000\001\047\001\000\001\
\096\001\076\001\077\001\000\000\070\001\078\001\119\001\080\001\
\049\002\074\001\249\000\250\000\078\001\109\001\037\002\001\001\
\089\001\001\001\071\001\001\001\006\001\070\001\006\001\119\001\
\072\001\074\001\238\001\239\001\070\001\077\001\037\001\252\000\
\253\000\254\000\076\001\001\001\043\001\125\001\126\001\127\001\
\128\001\129\001\130\001\131\001\132\001\133\001\134\001\135\001\
\136\001\137\001\138\001\139\001\140\001\141\001\142\001\000\001\
\072\001\017\003\070\001\071\001\147\002\077\001\074\001\150\002\
\189\001\025\003\078\001\154\002\193\001\072\001\001\001\078\001\
\184\001\080\001\056\001\006\001\071\001\097\002\203\001\204\001\
\205\001\001\001\089\001\096\001\125\002\071\001\070\001\071\001\
\074\001\071\001\074\001\098\001\099\001\032\001\078\001\077\001\
\109\001\053\002\145\001\146\001\198\001\001\001\073\001\014\000\
\191\002\016\000\006\001\119\001\070\001\221\001\066\002\198\002\
\056\001\075\001\076\001\077\001\077\002\197\001\079\002\054\001\
\055\001\082\002\247\001\001\001\107\001\108\001\073\001\071\001\
\006\001\054\001\074\001\187\001\057\001\119\001\001\001\119\001\
\092\002\119\001\076\001\006\001\073\001\066\001\073\001\001\001\
\200\001\070\001\000\001\001\001\006\001\065\001\237\002\061\001\
\006\001\241\001\065\000\000\001\001\001\096\001\245\002\070\001\
\071\001\060\002\071\001\074\001\080\001\096\001\001\001\078\001\
\076\001\189\002\109\001\006\001\111\001\073\001\005\003\198\001\
\001\001\060\001\109\001\075\001\088\002\006\001\078\001\205\001\
\007\001\192\001\042\002\143\002\119\001\001\001\146\002\198\001\
\062\001\049\002\006\001\073\001\096\001\153\002\056\001\048\001\
\049\001\184\001\056\001\001\001\071\001\113\002\109\002\110\002\
\006\001\109\001\070\001\056\001\068\002\071\001\074\001\001\001\
\070\001\071\001\078\001\119\001\074\001\064\001\076\001\077\001\
\078\001\070\001\071\001\075\001\097\002\074\001\078\001\076\001\
\077\001\078\001\078\001\077\002\077\001\079\002\073\001\075\001\
\082\002\119\001\025\001\079\001\056\001\028\001\037\002\070\001\
\073\001\205\002\035\001\107\002\119\001\076\001\000\001\097\000\
\098\000\074\002\070\001\071\001\000\001\119\001\074\001\054\002\
\120\002\119\001\078\001\123\002\076\001\125\002\139\002\079\001\
\070\001\071\001\119\001\102\001\074\001\100\001\101\001\025\001\
\078\001\077\001\028\001\029\001\119\001\117\002\032\001\071\001\
\088\002\000\001\074\001\247\002\088\002\070\001\119\001\035\001\
\066\001\067\001\223\001\025\001\054\001\055\001\028\001\029\001\
\066\001\067\001\032\001\119\001\000\001\001\001\077\002\153\002\
\079\002\078\001\041\002\082\002\077\001\113\002\048\001\049\001\
\189\002\119\001\056\001\192\002\035\001\078\001\077\002\183\002\
\079\002\119\002\070\001\082\002\201\002\073\001\035\001\070\001\
\076\001\077\001\078\001\035\001\091\002\093\001\094\001\199\002\
\001\001\071\001\188\000\189\000\074\001\078\001\096\001\073\001\
\119\002\077\001\078\001\197\000\198\000\077\001\109\002\110\002\
\077\001\078\001\073\001\109\001\164\002\111\001\077\001\078\001\
\119\002\070\001\096\001\073\001\098\001\077\001\078\001\076\001\
\077\001\078\001\072\001\130\002\107\002\070\001\072\001\109\001\
\111\002\111\001\075\001\076\001\077\001\078\001\025\001\208\002\
\073\001\028\001\029\001\070\001\123\002\032\001\156\002\157\002\
\025\001\070\001\153\002\028\001\029\001\001\001\025\001\032\001\
\071\001\028\001\029\001\130\001\131\001\032\001\165\002\071\001\
\016\003\000\001\001\001\128\001\129\001\238\002\071\001\006\001\
\071\001\114\001\009\001\010\001\011\001\012\001\013\001\014\001\
\015\001\070\001\017\001\018\001\019\001\020\001\021\001\022\001\
\023\001\024\001\025\001\026\001\027\001\028\001\029\001\030\001\
\031\001\032\001\070\001\070\001\060\001\072\001\136\001\137\001\
\075\001\076\001\077\001\078\001\079\001\096\001\062\001\098\001\
\061\001\060\001\061\001\062\001\003\003\064\001\065\001\096\001\
\064\001\056\001\109\001\070\001\111\001\096\001\046\001\047\001\
\075\001\076\001\077\001\078\001\109\001\080\001\111\001\070\001\
\071\001\078\001\109\001\074\001\111\001\076\001\077\001\078\001\
\000\001\056\001\057\001\058\001\068\001\069\001\004\001\071\001\
\255\000\000\001\074\001\050\001\051\001\052\001\053\001\001\001\
\002\001\096\001\097\001\070\001\099\001\004\001\025\001\114\001\
\070\001\028\001\029\001\007\001\008\001\032\001\109\001\004\001\
\111\001\000\001\001\001\035\001\114\001\072\001\117\001\006\001\
\119\001\072\001\009\001\010\001\011\001\012\001\013\001\014\001\
\015\001\070\001\017\001\018\001\019\001\020\001\021\001\022\001\
\023\001\024\001\025\001\026\001\027\001\028\001\029\001\030\001\
\031\001\032\001\072\001\001\001\071\001\106\001\070\001\074\001\
\076\001\073\001\070\001\072\001\076\001\077\001\078\001\078\001\
\070\001\060\001\061\001\062\001\077\001\064\001\065\001\072\001\
\070\001\056\001\077\001\070\001\076\001\096\001\072\001\098\001\
\075\001\076\001\077\001\078\001\072\001\080\001\072\001\070\001\
\071\001\070\001\109\001\074\001\111\001\076\001\077\001\078\001\
\065\001\050\001\051\001\052\001\053\001\070\001\132\001\133\001\
\134\001\135\001\075\001\076\001\077\001\078\001\072\001\080\001\
\078\001\096\001\097\001\070\001\099\001\001\001\025\001\114\001\
\071\001\028\001\029\001\070\001\070\001\032\001\109\001\070\001\
\111\001\000\001\001\001\056\001\057\001\058\001\117\001\006\001\
\119\001\070\001\009\001\010\001\011\001\012\001\013\001\014\001\
\015\001\114\001\017\001\018\001\019\001\020\001\021\001\022\001\
\023\001\024\001\025\001\026\001\027\001\028\001\029\001\030\001\
\031\001\032\001\075\001\001\001\071\001\048\001\049\001\050\001\
\051\001\052\001\053\001\054\001\055\001\056\001\057\001\058\001\
\001\001\060\001\061\001\062\001\071\001\064\001\065\001\066\001\
\067\001\056\001\078\001\070\001\077\001\096\001\077\001\072\001\
\075\001\076\001\077\001\078\001\074\001\080\001\072\001\070\001\
\071\001\070\001\109\001\074\001\111\001\076\001\077\001\078\001\
\065\001\003\001\004\001\005\001\006\001\070\001\072\001\070\001\
\072\001\070\001\075\001\076\001\077\001\078\001\070\001\080\001\
\078\001\096\001\097\001\078\001\099\001\078\001\070\001\114\001\
\078\001\075\001\078\001\076\001\073\001\073\001\109\001\073\001\
\111\001\000\001\001\001\078\001\035\001\076\001\117\001\006\001\
\119\001\072\001\009\001\010\001\011\001\012\001\013\001\014\001\
\015\001\114\001\017\001\018\001\019\001\020\001\021\001\022\001\
\023\001\024\001\025\001\026\001\027\001\028\001\029\001\030\001\
\031\001\032\001\046\001\047\001\048\001\049\001\050\001\051\001\
\052\001\053\001\054\001\055\001\056\001\057\001\058\001\070\001\
\060\001\061\001\062\001\070\001\064\001\065\001\066\001\067\001\
\070\001\056\001\070\001\076\001\071\001\077\001\074\001\075\001\
\076\001\077\001\078\001\077\001\080\001\076\001\071\001\070\001\
\071\001\077\001\072\001\074\001\078\001\076\001\077\001\078\001\
\000\001\001\001\002\001\003\001\004\001\005\001\006\001\007\001\
\008\001\077\001\070\001\072\001\061\001\062\001\077\001\064\001\
\065\001\096\001\097\001\075\001\099\001\070\001\114\001\070\001\
\077\001\076\001\075\001\076\001\077\001\078\001\109\001\080\001\
\111\001\033\001\034\001\035\001\064\001\065\001\117\001\071\001\
\119\001\070\001\070\001\088\001\070\001\075\001\070\001\075\001\
\076\001\077\001\078\001\072\001\080\001\070\001\054\001\055\001\
\056\001\072\001\072\001\059\001\060\001\077\001\095\001\063\001\
\064\001\114\001\077\001\007\001\068\001\069\001\070\001\071\001\
\001\001\073\001\074\001\075\001\076\001\077\001\078\001\015\000\
\075\001\077\001\076\001\070\001\077\001\076\001\114\001\023\000\
\074\001\070\001\026\000\027\000\001\001\076\001\078\001\031\000\
\075\001\077\001\071\001\076\001\100\001\101\001\070\001\103\001\
\070\001\070\001\078\001\107\001\108\001\072\001\000\001\070\001\
\070\001\077\001\074\001\051\000\072\001\053\000\118\001\119\001\
\000\001\001\001\002\001\003\001\004\001\005\001\006\001\007\001\
\008\001\009\001\010\001\011\001\012\001\013\001\014\001\015\001\
\070\001\017\001\018\001\019\001\020\001\021\001\022\001\023\001\
\024\001\025\001\026\001\027\001\028\001\029\001\030\001\031\001\
\032\001\033\001\034\001\070\001\035\001\036\001\037\001\038\001\
\039\001\040\001\041\001\042\001\043\001\044\001\045\001\072\001\
\072\001\077\001\070\001\072\001\070\001\076\001\054\001\055\001\
\056\001\072\001\077\001\059\001\060\001\072\001\075\001\063\001\
\064\001\071\001\070\001\002\000\068\001\069\001\077\001\071\001\
\072\001\073\001\077\001\070\001\070\001\077\001\070\001\124\000\
\176\002\081\001\082\001\083\001\084\001\085\001\086\001\087\001\
\088\001\089\001\090\001\091\001\092\001\182\002\047\001\193\001\
\096\001\097\001\098\001\099\001\100\001\101\001\024\001\103\001\
\222\001\058\002\106\001\107\001\108\001\109\001\110\001\111\001\
\112\001\113\001\136\000\141\001\057\002\117\001\118\001\000\001\
\001\001\002\001\003\001\004\001\005\001\006\001\007\001\008\001\
\009\001\010\001\011\001\012\001\013\001\014\001\015\001\140\001\
\017\001\018\001\019\001\020\001\021\001\022\001\023\001\024\001\
\025\001\026\001\027\001\028\001\029\001\030\001\031\001\032\001\
\033\001\034\001\114\001\115\001\116\001\117\001\118\001\119\001\
\120\001\121\001\122\001\123\001\124\001\138\001\142\001\139\001\
\117\002\092\002\208\001\241\002\164\002\054\001\055\001\056\001\
\192\002\156\000\059\001\060\001\009\001\011\001\063\001\064\001\
\010\001\012\001\007\003\068\001\069\001\013\001\071\001\072\001\
\073\001\009\003\025\003\255\255\077\001\255\255\255\255\255\255\
\081\001\082\001\083\001\084\001\085\001\086\001\087\001\088\001\
\089\001\090\001\091\001\092\001\255\255\255\255\255\255\096\001\
\097\001\098\001\099\001\100\001\101\001\255\255\103\001\255\255\
\255\255\255\255\107\001\108\001\109\001\110\001\111\001\112\001\
\113\001\255\255\255\255\255\255\117\001\118\001\000\001\001\001\
\002\001\003\001\004\001\005\001\006\001\007\001\008\001\009\001\
\010\001\011\001\012\001\013\001\014\001\015\001\255\255\017\001\
\018\001\019\001\020\001\021\001\022\001\023\001\024\001\025\001\
\026\001\027\001\028\001\029\001\030\001\031\001\032\001\033\001\
\034\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\054\001\055\001\056\001\255\255\
\255\255\059\001\060\001\255\255\255\255\063\001\064\001\255\255\
\255\255\255\255\068\001\069\001\255\255\071\001\072\001\073\001\
\255\255\255\255\255\255\077\001\255\255\255\255\255\255\081\001\
\082\001\083\001\084\001\085\001\086\001\087\001\088\001\089\001\
\090\001\091\001\092\001\255\255\255\255\255\255\096\001\097\001\
\098\001\099\001\100\001\101\001\255\255\103\001\255\255\255\255\
\255\255\107\001\108\001\109\001\110\001\111\001\112\001\113\001\
\255\255\255\255\255\255\117\001\118\001\000\001\001\001\002\001\
\003\001\004\001\005\001\006\001\007\001\008\001\009\001\010\001\
\011\001\012\001\013\001\014\001\015\001\255\255\017\001\018\001\
\019\001\020\001\021\001\022\001\023\001\024\001\025\001\026\001\
\027\001\028\001\029\001\030\001\031\001\032\001\033\001\034\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\054\001\055\001\056\001\255\255\255\255\
\059\001\060\001\255\255\255\255\063\001\064\001\255\255\255\255\
\255\255\068\001\069\001\255\255\071\001\255\255\073\001\255\255\
\255\255\255\255\077\001\255\255\255\255\255\255\081\001\082\001\
\083\001\084\001\085\001\086\001\087\001\088\001\089\001\090\001\
\091\001\092\001\255\255\255\255\255\255\096\001\097\001\098\001\
\099\001\100\001\101\001\255\255\103\001\255\255\255\255\255\255\
\107\001\108\001\109\001\110\001\111\001\112\001\113\001\255\255\
\255\255\255\255\117\001\118\001\000\001\001\001\002\001\003\001\
\004\001\005\001\006\001\007\001\008\001\009\001\010\001\011\001\
\012\001\013\001\014\001\015\001\255\255\017\001\018\001\019\001\
\020\001\021\001\022\001\023\001\024\001\025\001\026\001\027\001\
\028\001\029\001\030\001\031\001\032\001\033\001\034\001\064\001\
\065\001\255\255\255\255\255\255\255\255\070\001\255\255\255\255\
\255\255\255\255\075\001\076\001\077\001\078\001\255\255\080\001\
\255\255\255\255\054\001\055\001\056\001\255\255\255\255\059\001\
\060\001\255\255\255\255\063\001\064\001\255\255\255\255\255\255\
\068\001\069\001\255\255\071\001\255\255\073\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\114\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\096\001\097\001\255\255\099\001\
\100\001\101\001\255\255\103\001\255\255\255\255\255\255\107\001\
\108\001\109\001\255\255\111\001\255\255\255\255\255\255\255\255\
\255\255\117\001\118\001\000\001\001\001\002\001\003\001\004\001\
\005\001\006\001\007\001\008\001\009\001\010\001\011\001\012\001\
\013\001\014\001\015\001\255\255\017\001\018\001\019\001\020\001\
\021\001\022\001\023\001\024\001\025\001\026\001\027\001\028\001\
\029\001\030\001\031\001\032\001\033\001\034\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\054\001\055\001\056\001\255\255\255\255\059\001\060\001\
\255\255\255\255\063\001\064\001\255\255\255\255\255\255\068\001\
\069\001\255\255\071\001\000\001\001\001\002\001\003\001\004\001\
\005\001\255\255\007\001\008\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\096\001\097\001\255\255\099\001\100\001\
\101\001\255\255\103\001\255\255\033\001\034\001\107\001\108\001\
\109\001\255\255\111\001\255\255\255\255\255\255\255\255\255\255\
\117\001\118\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\054\001\055\001\056\001\255\255\255\255\059\001\060\001\
\255\255\255\255\063\001\064\001\255\255\255\255\255\255\068\001\
\069\001\255\255\071\001\072\001\073\001\255\255\255\255\255\255\
\077\001\255\255\255\255\255\255\081\001\082\001\083\001\084\001\
\085\001\086\001\087\001\088\001\089\001\090\001\091\001\092\001\
\255\255\255\255\255\255\255\255\255\255\098\001\255\255\100\001\
\101\001\025\001\103\001\255\255\028\001\029\001\107\001\108\001\
\032\001\110\001\255\255\000\001\001\001\002\001\003\001\004\001\
\005\001\118\001\007\001\008\001\255\255\255\255\255\255\255\255\
\048\001\049\001\050\001\051\001\052\001\053\001\054\001\055\001\
\056\001\057\001\058\001\255\255\060\001\061\001\062\001\255\255\
\064\001\065\001\066\001\067\001\033\001\034\001\070\001\255\255\
\072\001\255\255\255\255\075\001\076\001\077\001\078\001\079\001\
\080\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\054\001\055\001\056\001\255\255\255\255\059\001\060\001\
\096\001\255\255\063\001\064\001\255\255\255\255\255\255\068\001\
\069\001\255\255\071\001\255\255\073\001\109\001\255\255\111\001\
\077\001\255\255\255\255\255\255\081\001\082\001\083\001\084\001\
\085\001\086\001\087\001\088\001\089\001\090\001\091\001\092\001\
\255\255\255\255\255\255\255\255\255\255\098\001\255\255\100\001\
\101\001\025\001\103\001\255\255\028\001\029\001\107\001\108\001\
\032\001\110\001\255\255\000\001\001\001\002\001\003\001\004\001\
\005\001\118\001\007\001\008\001\255\255\255\255\255\255\255\255\
\048\001\049\001\050\001\051\001\052\001\053\001\054\001\055\001\
\255\255\255\255\255\255\255\255\060\001\061\001\062\001\255\255\
\064\001\065\001\066\001\067\001\033\001\034\001\070\001\255\255\
\072\001\255\255\255\255\075\001\076\001\077\001\078\001\079\001\
\080\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\054\001\055\001\056\001\255\255\255\255\059\001\060\001\
\096\001\255\255\063\001\064\001\255\255\255\255\255\255\068\001\
\069\001\255\255\071\001\255\255\073\001\109\001\255\255\111\001\
\077\001\255\255\255\255\255\255\081\001\082\001\083\001\084\001\
\085\001\086\001\087\001\088\001\089\001\090\001\091\001\092\001\
\255\255\255\255\255\255\255\255\255\255\098\001\255\255\100\001\
\101\001\255\255\103\001\255\255\255\255\255\255\107\001\108\001\
\255\255\110\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\118\001\001\001\002\001\003\001\004\001\005\001\006\001\
\007\001\008\001\048\001\049\001\050\001\051\001\052\001\053\001\
\054\001\055\001\056\001\057\001\058\001\255\255\060\001\061\001\
\062\001\255\255\064\001\065\001\066\001\067\001\255\255\255\255\
\070\001\255\255\033\001\034\001\255\255\075\001\076\001\077\001\
\078\001\255\255\080\001\025\001\255\255\255\255\028\001\029\001\
\047\001\255\255\032\001\255\255\255\255\255\255\255\255\054\001\
\055\001\056\001\255\255\255\255\059\001\060\001\255\255\255\255\
\063\001\064\001\255\255\255\255\255\255\068\001\069\001\255\255\
\071\001\255\255\073\001\074\001\114\001\000\001\001\001\002\001\
\003\001\004\001\005\001\065\001\007\001\008\001\255\255\255\255\
\070\001\255\255\072\001\255\255\255\255\075\001\076\001\077\001\
\078\001\079\001\080\001\255\255\255\255\100\001\101\001\255\255\
\103\001\255\255\255\255\255\255\107\001\108\001\033\001\034\001\
\255\255\255\255\096\001\255\255\255\255\255\255\255\255\118\001\
\119\001\025\001\255\255\255\255\028\001\029\001\255\255\109\001\
\032\001\111\001\255\255\054\001\055\001\056\001\255\255\255\255\
\059\001\060\001\255\255\255\255\063\001\064\001\255\255\255\255\
\255\255\068\001\069\001\255\255\071\001\255\255\255\255\255\255\
\255\255\255\255\077\001\000\001\001\001\002\001\003\001\004\001\
\005\001\065\001\007\001\008\001\255\255\255\255\070\001\255\255\
\072\001\255\255\255\255\075\001\076\001\077\001\078\001\079\001\
\080\001\100\001\101\001\255\255\103\001\255\255\255\255\255\255\
\107\001\108\001\255\255\061\001\033\001\034\001\064\001\065\001\
\096\001\255\255\255\255\118\001\070\001\255\255\255\255\255\255\
\255\255\075\001\076\001\077\001\078\001\109\001\080\001\111\001\
\255\255\054\001\055\001\056\001\255\255\255\255\059\001\060\001\
\255\255\255\255\063\001\064\001\255\255\255\255\255\255\068\001\
\069\001\255\255\071\001\255\255\255\255\255\255\075\001\000\001\
\001\001\002\001\003\001\004\001\005\001\255\255\007\001\008\001\
\114\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\100\001\
\101\001\255\255\103\001\255\255\255\255\255\255\107\001\108\001\
\033\001\034\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\118\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\054\001\055\001\056\001\
\255\255\255\255\059\001\060\001\255\255\255\255\063\001\064\001\
\255\255\255\255\255\255\068\001\069\001\255\255\071\001\000\001\
\001\001\002\001\003\001\004\001\005\001\255\255\007\001\008\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\000\001\001\001\002\001\003\001\004\001\005\001\
\255\255\007\001\008\001\100\001\101\001\255\255\103\001\255\255\
\033\001\034\001\107\001\108\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\118\001\255\255\255\255\
\255\255\255\255\255\255\033\001\034\001\054\001\055\001\056\001\
\255\255\255\255\059\001\060\001\255\255\255\255\063\001\064\001\
\255\255\255\255\255\255\068\001\069\001\255\255\071\001\255\255\
\054\001\055\001\056\001\255\255\255\255\059\001\060\001\255\255\
\255\255\063\001\064\001\255\255\255\255\255\255\068\001\069\001\
\255\255\071\001\000\001\001\001\002\001\003\001\004\001\005\001\
\255\255\007\001\008\001\100\001\101\001\255\255\103\001\255\255\
\255\255\255\255\107\001\108\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\118\001\100\001\101\001\
\255\255\103\001\255\255\033\001\034\001\107\001\108\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\118\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\054\001\055\001\056\001\255\255\255\255\059\001\060\001\255\255\
\255\255\063\001\064\001\255\255\255\255\255\255\068\001\069\001\
\255\255\071\001\000\001\001\001\002\001\003\001\004\001\005\001\
\255\255\007\001\008\001\255\255\048\001\049\001\050\001\051\001\
\052\001\053\001\255\255\255\255\255\255\255\255\255\255\255\255\
\060\001\061\001\062\001\255\255\064\001\065\001\100\001\101\001\
\255\255\103\001\070\001\033\001\034\001\107\001\108\001\075\001\
\076\001\077\001\078\001\255\255\080\001\255\255\255\255\255\255\
\118\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\054\001\055\001\056\001\255\255\061\001\059\001\060\001\064\001\
\065\001\063\001\064\001\255\255\255\255\070\001\068\001\069\001\
\255\255\071\001\075\001\076\001\077\001\078\001\114\001\080\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\100\001\101\001\
\255\255\103\001\255\255\255\255\255\255\107\001\108\001\255\255\
\255\255\114\001\255\255\255\255\255\255\255\255\255\255\255\255\
\118\001\001\001\002\001\003\001\004\001\005\001\006\001\007\001\
\008\001\009\001\010\001\011\001\012\001\013\001\014\001\015\001\
\255\255\017\001\018\001\019\001\020\001\021\001\022\001\023\001\
\024\001\025\001\026\001\027\001\028\001\029\001\030\001\031\001\
\032\001\033\001\034\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\054\001\055\001\
\056\001\255\255\255\255\059\001\060\001\255\255\255\255\063\001\
\064\001\255\255\255\255\255\255\068\001\069\001\255\255\071\001\
\255\255\061\001\062\001\255\255\064\001\065\001\255\255\255\255\
\255\255\255\255\070\001\255\255\255\255\255\255\255\255\075\001\
\076\001\077\001\078\001\255\255\080\001\255\255\255\255\255\255\
\096\001\097\001\255\255\099\001\100\001\101\001\255\255\103\001\
\255\255\255\255\255\255\107\001\108\001\109\001\000\001\111\001\
\255\255\255\255\255\255\255\255\006\001\117\001\118\001\009\001\
\010\001\011\001\012\001\013\001\014\001\015\001\114\001\017\001\
\018\001\019\001\020\001\021\001\022\001\023\001\024\001\025\001\
\026\001\027\001\028\001\029\001\030\001\031\001\032\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\000\001\001\001\255\255\
\255\255\004\001\255\255\006\001\007\001\255\255\255\255\255\255\
\255\255\255\255\255\255\001\001\002\001\003\001\004\001\005\001\
\255\255\007\001\008\001\255\255\255\255\255\255\025\001\255\255\
\255\255\028\001\255\255\077\001\255\255\255\255\033\001\034\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\033\001\034\001\035\001\096\001\097\001\
\255\255\099\001\255\255\054\001\055\001\056\001\255\255\255\255\
\059\001\060\001\255\255\109\001\063\001\111\001\112\001\113\001\
\054\001\055\001\056\001\117\001\071\001\059\001\060\001\255\255\
\255\255\063\001\064\001\255\255\255\255\255\255\068\001\069\001\
\255\255\071\001\255\255\073\001\087\001\255\255\255\255\001\001\
\002\001\003\001\004\001\005\001\255\255\007\001\008\001\255\255\
\255\255\100\001\101\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\100\001\101\001\
\255\255\103\001\255\255\255\255\255\255\107\001\108\001\033\001\
\034\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\118\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\054\001\055\001\056\001\255\255\
\255\255\059\001\060\001\255\255\255\255\063\001\064\001\255\255\
\255\255\255\255\068\001\069\001\255\255\071\001\255\255\073\001\
\255\255\255\255\255\255\001\001\002\001\003\001\004\001\005\001\
\255\255\007\001\008\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\100\001\101\001\255\255\103\001\255\255\255\255\
\255\255\107\001\108\001\033\001\034\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\118\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\054\001\055\001\056\001\255\255\255\255\059\001\060\001\255\255\
\255\255\063\001\064\001\255\255\255\255\255\255\068\001\069\001\
\255\255\071\001\255\255\073\001\255\255\255\255\255\255\001\001\
\002\001\003\001\004\001\005\001\255\255\007\001\008\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\100\001\101\001\
\255\255\103\001\255\255\255\255\255\255\107\001\108\001\033\001\
\034\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\118\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\054\001\055\001\056\001\255\255\
\255\255\059\001\060\001\255\255\255\255\063\001\064\001\255\255\
\255\255\255\255\068\001\069\001\255\255\071\001\255\255\073\001\
\255\255\255\255\255\255\001\001\002\001\003\001\004\001\005\001\
\255\255\007\001\008\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\100\001\101\001\255\255\103\001\255\255\255\255\
\255\255\107\001\108\001\033\001\034\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\118\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\054\001\055\001\056\001\255\255\255\255\059\001\060\001\255\255\
\255\255\063\001\064\001\255\255\255\255\255\255\068\001\069\001\
\255\255\071\001\001\001\002\001\003\001\004\001\005\001\255\255\
\007\001\008\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\001\001\002\001\003\001\
\004\001\005\001\255\255\007\001\008\001\255\255\100\001\101\001\
\255\255\103\001\033\001\034\001\255\255\107\001\108\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\118\001\255\255\255\255\255\255\255\255\033\001\034\001\054\001\
\055\001\056\001\255\255\255\255\059\001\060\001\255\255\255\255\
\063\001\064\001\255\255\255\255\255\255\068\001\069\001\255\255\
\071\001\255\255\054\001\055\001\056\001\255\255\255\255\059\001\
\060\001\255\255\255\255\063\001\064\001\255\255\255\255\255\255\
\068\001\069\001\255\255\071\001\001\001\002\001\003\001\004\001\
\005\001\255\255\007\001\008\001\255\255\100\001\101\001\255\255\
\103\001\255\255\255\255\255\255\107\001\108\001\255\255\001\001\
\002\001\003\001\004\001\005\001\255\255\007\001\008\001\118\001\
\100\001\101\001\255\255\103\001\033\001\034\001\255\255\107\001\
\108\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\118\001\255\255\255\255\255\255\255\255\033\001\
\034\001\054\001\055\001\056\001\255\255\255\255\059\001\060\001\
\255\255\255\255\063\001\064\001\255\255\255\255\255\255\068\001\
\069\001\255\255\071\001\255\255\054\001\055\001\056\001\255\255\
\255\255\059\001\060\001\255\255\255\255\063\001\064\001\255\255\
\255\255\255\255\068\001\069\001\255\255\071\001\001\001\002\001\
\003\001\004\001\005\001\255\255\007\001\008\001\255\255\100\001\
\101\001\255\255\103\001\255\255\255\255\255\255\107\001\108\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\118\001\100\001\101\001\255\255\103\001\033\001\034\001\
\255\255\107\001\108\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\118\001\255\255\255\255\255\255\
\255\255\255\255\255\255\054\001\055\001\056\001\255\255\255\255\
\059\001\060\001\255\255\255\255\063\001\064\001\001\001\255\255\
\255\255\068\001\069\001\006\001\071\001\255\255\009\001\010\001\
\011\001\012\001\013\001\014\001\015\001\255\255\017\001\018\001\
\019\001\020\001\021\001\022\001\023\001\024\001\025\001\026\001\
\027\001\028\001\029\001\030\001\031\001\032\001\255\255\255\255\
\255\255\100\001\101\001\255\255\103\001\255\255\255\255\255\255\
\107\001\108\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\118\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\001\001\255\255\255\255\255\255\255\255\
\006\001\255\255\255\255\009\001\010\001\011\001\012\001\013\001\
\014\001\015\001\077\001\017\001\018\001\019\001\020\001\021\001\
\022\001\023\001\024\001\025\001\026\001\027\001\028\001\029\001\
\030\001\031\001\032\001\255\255\255\255\096\001\097\001\098\001\
\099\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\109\001\255\255\111\001\112\001\113\001\255\255\
\115\001\116\001\117\001\255\255\255\255\255\255\046\001\047\001\
\048\001\049\001\050\001\051\001\052\001\053\001\054\001\055\001\
\056\001\057\001\058\001\255\255\060\001\061\001\062\001\255\255\
\064\001\065\001\066\001\067\001\255\255\255\255\070\001\255\255\
\255\255\255\255\074\001\075\001\255\255\077\001\078\001\255\255\
\080\001\255\255\096\001\097\001\098\001\099\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\109\001\
\255\255\111\001\112\001\113\001\255\255\115\001\116\001\117\001\
\006\001\255\255\255\255\009\001\010\001\011\001\012\001\013\001\
\014\001\015\001\114\001\017\001\018\001\019\001\020\001\021\001\
\022\001\023\001\024\001\025\001\026\001\027\001\028\001\029\001\
\030\001\031\001\032\001\255\255\255\255\035\001\036\001\037\001\
\038\001\039\001\040\001\041\001\042\001\043\001\044\001\045\001\
\046\001\047\001\048\001\049\001\050\001\051\001\052\001\053\001\
\054\001\055\001\056\001\057\001\058\001\255\255\060\001\061\001\
\062\001\255\255\064\001\065\001\066\001\067\001\068\001\069\001\
\070\001\071\001\072\001\073\001\074\001\075\001\076\001\077\001\
\078\001\079\001\080\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\096\001\097\001\255\255\099\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\109\001\
\255\255\111\001\255\255\255\255\114\001\006\001\007\001\117\001\
\009\001\010\001\011\001\012\001\013\001\014\001\015\001\255\255\
\017\001\018\001\019\001\020\001\021\001\022\001\023\001\024\001\
\025\001\026\001\027\001\028\001\029\001\030\001\031\001\032\001\
\006\001\255\255\255\255\009\001\010\001\011\001\012\001\013\001\
\014\001\015\001\255\255\017\001\018\001\019\001\020\001\021\001\
\022\001\023\001\024\001\025\001\026\001\027\001\028\001\029\001\
\030\001\031\001\032\001\255\255\255\255\255\255\006\001\255\255\
\255\255\009\001\010\001\011\001\012\001\013\001\014\001\015\001\
\255\255\017\001\018\001\019\001\020\001\021\001\022\001\023\001\
\024\001\025\001\026\001\027\001\028\001\029\001\030\001\031\001\
\032\001\255\255\255\255\255\255\255\255\255\255\255\255\096\001\
\097\001\071\001\099\001\100\001\101\001\255\255\255\255\255\255\
\255\255\079\001\255\255\255\255\109\001\255\255\111\001\255\255\
\255\255\255\255\255\255\255\255\117\001\255\255\255\255\255\255\
\255\255\255\255\096\001\097\001\255\255\099\001\070\001\071\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\109\001\
\255\255\111\001\255\255\255\255\255\255\255\255\255\255\117\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\096\001\097\001\255\255\099\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\109\001\255\255\111\001\
\255\255\255\255\255\255\006\001\255\255\117\001\009\001\010\001\
\011\001\012\001\013\001\014\001\015\001\255\255\017\001\018\001\
\019\001\020\001\021\001\022\001\023\001\024\001\025\001\026\001\
\027\001\028\001\029\001\030\001\031\001\032\001\006\001\255\255\
\255\255\009\001\010\001\011\001\012\001\013\001\014\001\015\001\
\255\255\017\001\018\001\019\001\020\001\021\001\022\001\023\001\
\024\001\025\001\026\001\027\001\028\001\029\001\030\001\031\001\
\032\001\255\255\006\001\255\255\255\255\009\001\010\001\011\001\
\012\001\013\001\014\001\015\001\071\001\017\001\018\001\019\001\
\020\001\021\001\022\001\023\001\024\001\025\001\026\001\027\001\
\028\001\029\001\030\001\031\001\032\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\096\001\097\001\255\255\
\099\001\073\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\109\001\255\255\111\001\255\255\255\255\255\255\
\255\255\255\255\117\001\255\255\255\255\255\255\255\255\255\255\
\096\001\097\001\255\255\099\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\079\001\255\255\109\001\255\255\111\001\
\255\255\255\255\255\255\255\255\255\255\117\001\255\255\255\255\
\255\255\255\255\255\255\255\255\096\001\097\001\255\255\099\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\109\001\255\255\111\001\255\255\255\255\255\255\006\001\
\255\255\117\001\009\001\010\001\011\001\012\001\013\001\014\001\
\015\001\255\255\017\001\018\001\019\001\020\001\021\001\022\001\
\023\001\024\001\025\001\026\001\027\001\028\001\029\001\030\001\
\031\001\032\001\009\001\010\001\011\001\012\001\013\001\014\001\
\015\001\255\255\017\001\018\001\019\001\020\001\021\001\022\001\
\023\001\024\001\025\001\026\001\027\001\028\001\029\001\030\001\
\031\001\032\001\255\255\255\255\000\001\001\001\255\255\255\255\
\004\001\255\255\006\001\007\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\025\001\255\255\255\255\
\028\001\255\255\255\255\255\255\255\255\033\001\034\001\255\255\
\255\255\096\001\097\001\255\255\099\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\109\001\255\255\
\111\001\255\255\054\001\055\001\056\001\255\255\117\001\059\001\
\060\001\096\001\097\001\063\001\099\001\255\255\255\255\255\255\
\255\255\255\255\070\001\071\001\255\255\255\255\109\001\255\255\
\111\001\000\001\001\001\255\255\255\255\004\001\117\001\006\001\
\007\001\255\255\255\255\087\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\100\001\101\001\025\001\255\255\255\255\028\001\255\255\255\255\
\255\255\255\255\033\001\034\001\255\255\000\001\001\001\255\255\
\255\255\004\001\255\255\006\001\007\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\054\001\
\055\001\056\001\255\255\255\255\059\001\060\001\025\001\255\255\
\063\001\028\001\255\255\255\255\255\255\255\255\033\001\034\001\
\071\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\087\001\255\255\255\255\054\001\055\001\056\001\255\255\255\255\
\059\001\060\001\255\255\255\255\063\001\100\001\101\001\255\255\
\255\255\255\255\255\255\001\001\071\001\255\255\004\001\255\255\
\006\001\007\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\087\001\255\255\255\255\255\255\
\255\255\255\255\255\255\025\001\255\255\255\255\028\001\255\255\
\255\255\100\001\101\001\033\001\034\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\054\001\055\001\056\001\255\255\255\255\059\001\060\001\255\255\
\255\255\063\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\071\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\087\001\255\255\255\255\255\255\255\255\025\001\255\255\
\255\255\028\001\029\001\255\255\255\255\032\001\100\001\101\001\
\035\001\036\001\037\001\038\001\039\001\040\001\041\001\042\001\
\043\001\044\001\045\001\046\001\047\001\048\001\049\001\050\001\
\051\001\052\001\053\001\054\001\055\001\056\001\057\001\058\001\
\255\255\060\001\061\001\062\001\255\255\064\001\065\001\066\001\
\067\001\068\001\069\001\070\001\071\001\072\001\255\255\074\001\
\075\001\076\001\077\001\078\001\079\001\080\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\096\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\109\001\255\255\111\001\025\001\255\255\114\001\
\028\001\029\001\255\255\255\255\032\001\255\255\255\255\035\001\
\036\001\037\001\038\001\039\001\040\001\041\001\042\001\043\001\
\044\001\045\001\255\255\255\255\048\001\049\001\050\001\051\001\
\052\001\053\001\054\001\055\001\056\001\057\001\058\001\255\255\
\060\001\061\001\062\001\255\255\064\001\065\001\066\001\067\001\
\255\255\255\255\070\001\255\255\072\001\255\255\255\255\075\001\
\076\001\077\001\078\001\079\001\080\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\096\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\109\001\255\255\111\001\025\001\255\255\114\001\028\001\
\029\001\255\255\255\255\032\001\255\255\255\255\035\001\036\001\
\037\001\038\001\039\001\040\001\041\001\042\001\043\001\044\001\
\045\001\255\255\255\255\048\001\049\001\050\001\051\001\052\001\
\053\001\054\001\055\001\056\001\057\001\058\001\255\255\060\001\
\061\001\062\001\255\255\064\001\065\001\066\001\067\001\255\255\
\255\255\070\001\255\255\072\001\255\255\255\255\075\001\076\001\
\077\001\078\001\079\001\080\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\096\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\109\001\255\255\111\001\025\001\255\255\114\001\028\001\029\001\
\255\255\255\255\032\001\255\255\255\255\035\001\036\001\037\001\
\038\001\039\001\040\001\041\001\042\001\043\001\044\001\045\001\
\255\255\255\255\048\001\049\001\050\001\051\001\052\001\053\001\
\054\001\055\001\056\001\057\001\058\001\255\255\060\001\061\001\
\062\001\255\255\064\001\065\001\066\001\067\001\255\255\255\255\
\070\001\255\255\072\001\255\255\255\255\075\001\076\001\077\001\
\078\001\079\001\080\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\025\001\255\255\096\001\028\001\029\001\255\255\255\255\032\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\109\001\
\255\255\111\001\255\255\255\255\114\001\255\255\255\255\048\001\
\049\001\050\001\051\001\052\001\053\001\054\001\055\001\255\255\
\255\255\255\255\255\255\060\001\061\001\062\001\255\255\064\001\
\065\001\066\001\067\001\255\255\255\255\070\001\255\255\072\001\
\255\255\255\255\075\001\076\001\077\001\078\001\079\001\080\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\025\001\255\255\255\255\028\001\029\001\255\255\096\001\
\032\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\109\001\255\255\111\001\255\255\
\048\001\049\001\050\001\051\001\052\001\053\001\054\001\055\001\
\255\255\255\255\255\255\255\255\060\001\061\001\062\001\255\255\
\064\001\065\001\066\001\067\001\255\255\255\255\070\001\255\255\
\072\001\255\255\255\255\075\001\076\001\077\001\078\001\079\001\
\080\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\025\001\255\255\255\255\028\001\029\001\255\255\
\096\001\032\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\109\001\255\255\111\001\
\255\255\048\001\049\001\050\001\051\001\052\001\053\001\255\255\
\255\255\255\255\255\255\255\255\255\255\060\001\061\001\062\001\
\255\255\064\001\065\001\066\001\067\001\255\255\255\255\070\001\
\255\255\072\001\255\255\255\255\075\001\076\001\077\001\078\001\
\079\001\080\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\025\001\255\255\255\255\028\001\029\001\
\255\255\096\001\032\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\109\001\255\255\
\111\001\255\255\048\001\049\001\050\001\051\001\052\001\053\001\
\255\255\255\255\255\255\255\255\255\255\255\255\060\001\061\001\
\062\001\255\255\064\001\065\001\066\001\067\001\255\255\255\255\
\070\001\255\255\072\001\255\255\255\255\075\001\076\001\077\001\
\078\001\079\001\080\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\025\001\255\255\255\255\028\001\
\029\001\255\255\096\001\032\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\109\001\
\255\255\111\001\255\255\048\001\049\001\050\001\051\001\052\001\
\053\001\255\255\255\255\255\255\255\255\255\255\255\255\060\001\
\061\001\062\001\255\255\064\001\065\001\066\001\067\001\255\255\
\255\255\070\001\255\255\072\001\255\255\255\255\075\001\076\001\
\077\001\078\001\079\001\080\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\025\001\255\255\255\255\
\028\001\029\001\255\255\096\001\032\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\109\001\255\255\111\001\255\255\048\001\049\001\050\001\051\001\
\052\001\053\001\255\255\255\255\255\255\255\255\255\255\255\255\
\060\001\061\001\062\001\255\255\064\001\065\001\255\255\255\255\
\255\255\255\255\070\001\255\255\072\001\255\255\255\255\075\001\
\076\001\077\001\078\001\079\001\080\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\025\001\255\255\
\255\255\028\001\029\001\255\255\096\001\032\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\109\001\255\255\111\001\255\255\048\001\049\001\050\001\
\051\001\052\001\053\001\255\255\255\255\255\255\255\255\255\255\
\255\255\060\001\061\001\062\001\255\255\064\001\065\001\255\255\
\255\255\255\255\255\255\070\001\255\255\072\001\255\255\255\255\
\075\001\076\001\077\001\078\001\079\001\080\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\025\001\
\255\255\255\255\028\001\029\001\255\255\096\001\032\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\109\001\255\255\111\001\255\255\048\001\049\001\
\050\001\051\001\052\001\053\001\255\255\255\255\255\255\255\255\
\255\255\255\255\060\001\061\001\062\001\255\255\064\001\065\001\
\255\255\255\255\255\255\255\255\070\001\255\255\072\001\255\255\
\255\255\075\001\076\001\077\001\078\001\079\001\080\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\025\001\255\255\255\255\028\001\029\001\255\255\096\001\032\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\109\001\255\255\111\001\255\255\048\001\
\049\001\050\001\051\001\052\001\053\001\255\255\255\255\255\255\
\255\255\255\255\255\255\060\001\061\001\062\001\255\255\064\001\
\065\001\255\255\255\255\255\255\255\255\070\001\255\255\072\001\
\255\255\255\255\075\001\076\001\077\001\078\001\079\001\080\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\025\001\255\255\255\255\028\001\029\001\255\255\096\001\
\032\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\109\001\255\255\111\001\255\255\
\048\001\049\001\050\001\051\001\052\001\053\001\255\255\255\255\
\255\255\255\255\255\255\255\255\060\001\061\001\062\001\255\255\
\064\001\065\001\255\255\255\255\255\255\255\255\070\001\255\255\
\072\001\255\255\255\255\075\001\076\001\077\001\078\001\079\001\
\080\001\025\001\255\255\255\255\028\001\029\001\255\255\255\255\
\032\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\096\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\048\001\049\001\255\255\255\255\255\255\109\001\255\255\111\001\
\255\255\255\255\255\255\255\255\060\001\061\001\062\001\255\255\
\064\001\065\001\255\255\255\255\255\255\255\255\070\001\255\255\
\072\001\255\255\255\255\075\001\076\001\077\001\078\001\079\001\
\080\001\025\001\255\255\255\255\028\001\029\001\255\255\255\255\
\032\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\096\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\048\001\049\001\255\255\255\255\255\255\109\001\255\255\111\001\
\255\255\255\255\255\255\255\255\060\001\061\001\062\001\255\255\
\064\001\065\001\255\255\255\255\255\255\255\255\070\001\255\255\
\072\001\255\255\255\255\075\001\076\001\077\001\078\001\079\001\
\080\001\025\001\255\255\255\255\028\001\029\001\255\255\255\255\
\032\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\096\001\255\255\255\255\255\255\255\255\255\255\255\255\025\001\
\048\001\049\001\028\001\029\001\255\255\109\001\032\001\111\001\
\255\255\255\255\255\255\255\255\060\001\061\001\062\001\255\255\
\064\001\065\001\255\255\255\255\255\255\255\255\070\001\255\255\
\072\001\255\255\255\255\075\001\076\001\077\001\078\001\079\001\
\080\001\255\255\060\001\061\001\062\001\255\255\064\001\065\001\
\255\255\255\255\255\255\255\255\070\001\255\255\072\001\255\255\
\096\001\075\001\076\001\077\001\078\001\079\001\080\001\025\001\
\255\255\255\255\028\001\029\001\255\255\109\001\032\001\111\001\
\255\255\255\255\255\255\255\255\255\255\255\255\096\001\255\255\
\255\255\255\255\255\255\255\255\255\255\025\001\255\255\255\255\
\028\001\029\001\255\255\109\001\032\001\111\001\255\255\255\255\
\255\255\255\255\060\001\061\001\062\001\255\255\064\001\065\001\
\255\255\255\255\255\255\255\255\070\001\255\255\072\001\255\255\
\255\255\075\001\076\001\077\001\078\001\079\001\080\001\255\255\
\255\255\061\001\062\001\255\255\064\001\065\001\255\255\255\255\
\255\255\255\255\070\001\255\255\072\001\255\255\096\001\075\001\
\076\001\077\001\078\001\079\001\080\001\025\001\255\255\255\255\
\028\001\029\001\255\255\109\001\032\001\111\001\255\255\255\255\
\255\255\255\255\255\255\255\255\096\001\255\255\255\255\255\255\
\255\255\255\255\255\255\025\001\255\255\255\255\028\001\029\001\
\255\255\109\001\032\001\111\001\255\255\255\255\255\255\255\255\
\255\255\061\001\062\001\255\255\064\001\065\001\255\255\255\255\
\255\255\255\255\070\001\255\255\072\001\255\255\255\255\075\001\
\076\001\077\001\078\001\079\001\080\001\255\255\255\255\061\001\
\255\255\255\255\064\001\065\001\255\255\255\255\255\255\255\255\
\070\001\255\255\072\001\255\255\096\001\075\001\076\001\077\001\
\078\001\079\001\080\001\025\001\255\255\255\255\028\001\029\001\
\255\255\109\001\032\001\111\001\255\255\255\255\255\255\255\255\
\255\255\255\255\096\001\255\255\255\255\255\255\255\255\255\255\
\255\255\025\001\255\255\255\255\028\001\029\001\255\255\109\001\
\032\001\111\001\255\255\255\255\255\255\255\255\255\255\061\001\
\255\255\255\255\064\001\065\001\255\255\255\255\255\255\255\255\
\070\001\255\255\072\001\255\255\255\255\075\001\076\001\077\001\
\078\001\079\001\080\001\255\255\255\255\255\255\255\255\255\255\
\064\001\065\001\255\255\255\255\255\255\255\255\070\001\255\255\
\072\001\255\255\096\001\075\001\076\001\077\001\078\001\079\001\
\080\001\025\001\255\255\255\255\028\001\029\001\255\255\109\001\
\032\001\111\001\255\255\255\255\255\255\255\255\255\255\255\255\
\096\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\109\001\255\255\111\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\064\001\065\001\255\255\255\255\255\255\255\255\070\001\255\255\
\072\001\255\255\255\255\075\001\076\001\077\001\078\001\079\001\
\080\001\255\255\255\255\255\255\255\255\048\001\049\001\050\001\
\051\001\052\001\053\001\054\001\055\001\056\001\057\001\058\001\
\096\001\060\001\061\001\062\001\255\255\064\001\065\001\066\001\
\067\001\255\255\255\255\070\001\255\255\109\001\255\255\111\001\
\075\001\076\001\077\001\078\001\255\255\080\001\048\001\049\001\
\050\001\051\001\052\001\053\001\054\001\055\001\255\255\255\255\
\255\255\255\255\060\001\061\001\062\001\255\255\064\001\065\001\
\066\001\067\001\255\255\255\255\070\001\255\255\255\255\255\255\
\255\255\075\001\076\001\077\001\078\001\255\255\080\001\114\001\
\255\255\048\001\049\001\050\001\051\001\052\001\053\001\054\001\
\055\001\255\255\255\255\255\255\255\255\060\001\061\001\062\001\
\255\255\064\001\065\001\066\001\067\001\255\255\255\255\070\001\
\255\255\255\255\255\255\255\255\075\001\076\001\077\001\078\001\
\114\001\080\001\048\001\049\001\050\001\051\001\052\001\053\001\
\054\001\055\001\255\255\255\255\255\255\255\255\060\001\061\001\
\062\001\255\255\064\001\065\001\066\001\067\001\255\255\255\255\
\070\001\255\255\255\255\255\255\255\255\075\001\076\001\077\001\
\078\001\255\255\080\001\114\001\255\255\048\001\049\001\050\001\
\051\001\052\001\053\001\255\255\255\255\255\255\255\255\255\255\
\255\255\060\001\061\001\062\001\255\255\064\001\065\001\066\001\
\067\001\255\255\255\255\070\001\255\255\255\255\255\255\255\255\
\075\001\076\001\077\001\078\001\114\001\080\001\048\001\049\001\
\050\001\051\001\052\001\053\001\255\255\255\255\255\255\255\255\
\255\255\255\255\060\001\061\001\062\001\255\255\064\001\065\001\
\066\001\067\001\255\255\255\255\070\001\255\255\255\255\255\255\
\255\255\075\001\076\001\077\001\078\001\255\255\080\001\114\001\
\255\255\048\001\049\001\050\001\051\001\052\001\053\001\255\255\
\255\255\255\255\255\255\255\255\255\255\060\001\061\001\062\001\
\255\255\064\001\065\001\066\001\067\001\255\255\255\255\070\001\
\255\255\255\255\255\255\255\255\075\001\076\001\077\001\078\001\
\114\001\080\001\048\001\049\001\050\001\051\001\052\001\053\001\
\255\255\255\255\255\255\255\255\255\255\255\255\060\001\061\001\
\062\001\255\255\064\001\065\001\255\255\255\255\255\255\255\255\
\070\001\255\255\255\255\255\255\255\255\075\001\076\001\077\001\
\078\001\255\255\080\001\114\001\255\255\048\001\049\001\050\001\
\051\001\052\001\053\001\255\255\255\255\255\255\255\255\255\255\
\255\255\060\001\061\001\062\001\255\255\064\001\065\001\255\255\
\255\255\255\255\255\255\070\001\255\255\255\255\255\255\255\255\
\075\001\076\001\077\001\078\001\114\001\080\001\048\001\049\001\
\050\001\051\001\052\001\053\001\255\255\255\255\255\255\255\255\
\255\255\255\255\060\001\061\001\062\001\255\255\064\001\065\001\
\255\255\255\255\255\255\255\255\070\001\255\255\255\255\255\255\
\255\255\075\001\076\001\077\001\078\001\255\255\080\001\114\001\
\255\255\048\001\049\001\050\001\051\001\052\001\053\001\255\255\
\255\255\255\255\255\255\255\255\255\255\060\001\061\001\062\001\
\255\255\064\001\065\001\255\255\255\255\255\255\255\255\070\001\
\048\001\049\001\255\255\255\255\075\001\076\001\077\001\078\001\
\114\001\080\001\255\255\255\255\060\001\061\001\062\001\255\255\
\064\001\065\001\255\255\255\255\255\255\255\255\070\001\048\001\
\049\001\255\255\255\255\075\001\076\001\077\001\078\001\255\255\
\080\001\255\255\255\255\060\001\061\001\062\001\255\255\064\001\
\065\001\255\255\255\255\114\001\255\255\070\001\048\001\049\001\
\255\255\255\255\075\001\076\001\077\001\078\001\255\255\080\001\
\255\255\255\255\060\001\061\001\062\001\255\255\064\001\065\001\
\255\255\255\255\114\001\255\255\070\001\255\255\255\255\255\255\
\255\255\075\001\076\001\077\001\078\001\255\255\080\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\114\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\114\001\035\001\036\001\037\001\038\001\039\001\040\001\041\001\
\042\001\043\001\044\001\045\001\046\001\047\001\048\001\049\001\
\050\001\051\001\052\001\053\001\054\001\055\001\056\001\057\001\
\058\001\255\255\060\001\061\001\062\001\255\255\064\001\065\001\
\066\001\067\001\068\001\069\001\255\255\071\001\072\001\255\255\
\074\001\255\255\076\001\255\255\078\001\255\255\080\001\035\001\
\036\001\037\001\038\001\039\001\040\001\041\001\042\001\043\001\
\044\001\045\001\046\001\047\001\048\001\049\001\050\001\051\001\
\052\001\053\001\054\001\055\001\056\001\057\001\058\001\255\255\
\060\001\061\001\062\001\255\255\064\001\065\001\066\001\067\001\
\068\001\069\001\255\255\071\001\255\255\255\255\074\001\255\255\
\255\255\077\001\078\001\255\255\080\001"

let yynames_const = "\
  EOF\000\
  EQ\000\
  PLUS_EQ\000\
  MINUS_EQ\000\
  STAR_EQ\000\
  SLASH_EQ\000\
  PERCENT_EQ\000\
  AND_EQ\000\
  PIPE_EQ\000\
  CIRC_EQ\000\
  INF_INF_EQ\000\
  SUP_SUP_EQ\000\
  ARROW\000\
  DOT\000\
  EQ_EQ\000\
  EXCLAM_EQ\000\
  INF\000\
  SUP\000\
  INF_EQ\000\
  SUP_EQ\000\
  SLASH\000\
  PERCENT\000\
  PIPE\000\
  CIRC\000\
  PIPE_PIPE\000\
  INF_INF\000\
  SUP_SUP\000\
  RPAREN\000\
  LBRACKET\000\
  RBRACKET\000\
  COLON\000\
  COMMA\000\
  ELLIPSIS\000\
  QUEST\000\
  ELSE\000\
  LABEL__\000\
  BUILTIN_VA_LIST\000\
  BLOCKATTRIBUTE\000\
  PRAGMA_EOL\000\
  AT_NAME\000\
  "

let yynames_block = "\
  IDENT\000\
  CST_CHAR\000\
  CST_WCHAR\000\
  CST_INT\000\
  CST_FLOAT\000\
  NAMED_TYPE\000\
  CST_STRING\000\
  CST_WSTRING\000\
  CHAR\000\
  BOOL\000\
  INT\000\
  DOUBLE\000\
  FLOAT\000\
  VOID\000\
  INT64\000\
  INT32\000\
  ENUM\000\
  STRUCT\000\
  TYPEDEF\000\
  UNION\000\
  SIGNED\000\
  UNSIGNED\000\
  LONG\000\
  SHORT\000\
  VOLATILE\000\
  EXTERN\000\
  STATIC\000\
  CONST\000\
  RESTRICT\000\
  AUTO\000\
  REGISTER\000\
  THREAD\000\
  SIZEOF\000\
  ALIGNOF\000\
  PLUS\000\
  MINUS\000\
  STAR\000\
  TILDE\000\
  AND\000\
  EXCLAM\000\
  AND_AND\000\
  PLUS_PLUS\000\
  MINUS_MINUS\000\
  LPAREN\000\
  RBRACE\000\
  LBRACE\000\
  SEMICOLON\000\
  BREAK\000\
  CONTINUE\000\
  GOTO\000\
  RETURN\000\
  SWITCH\000\
  CASE\000\
  DEFAULT\000\
  WHILE\000\
  DO\000\
  FOR\000\
  IF\000\
  TRY\000\
  EXCEPT\000\
  FINALLY\000\
  ATTRIBUTE\000\
  INLINE\000\
  ASM\000\
  TYPEOF\000\
  FUNCTION__\000\
  PRETTY_FUNCTION__\000\
  BUILTIN_VA_ARG\000\
  ATTRIBUTE_USED\000\
  BUILTIN_TYPES_COMPAT\000\
  BUILTIN_OFFSETOF\000\
  DECLSPEC\000\
  MSASM\000\
  MSATTR\000\
  PRAGMA_LINE\000\
  PRAGMA\000\
  AT_TRANSFORM\000\
  AT_TRANSFORMEXPR\000\
  AT_SPECIFIER\000\
  AT_EXPR\000\
  "

let yyact = [|
  (fun _ -> failwith "parser")
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.definition list) in
    Obj.repr(
# 393 "cparser.mly"
              (_1)
# 2685 "cparser.ml"
               : Cabs.definition list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.definition list) in
    Obj.repr(
# 395 "cparser.mly"
                 (_1)
# 2692 "cparser.ml"
               : Cabs.definition list))
; (fun __caml_parser_env ->
    Obj.repr(
# 398 "cparser.mly"
                                        ( [] )
# 2698 "cparser.ml"
               : Cabs.definition list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.definition) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.definition list) in
    Obj.repr(
# 399 "cparser.mly"
                                        ( _1 :: _2 )
# 2706 "cparser.ml"
               : Cabs.definition list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.definition list) in
    Obj.repr(
# 400 "cparser.mly"
                                        ( _2 )
# 2714 "cparser.ml"
               : Cabs.definition list))
; (fun __caml_parser_env ->
    Obj.repr(
# 404 "cparser.mly"
                               ( currentLoc () )
# 2720 "cparser.ml"
               : Cabs.cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.definition) in
    Obj.repr(
# 409 "cparser.mly"
                                        ( _1 )
# 2727 "cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.definition) in
    Obj.repr(
# 410 "cparser.mly"
                                        ( _1 )
# 2734 "cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : string * cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.definition) in
    Obj.repr(
# 413 "cparser.mly"
                                        ( LINKAGE (fst _2, (*handleLoc*) (snd _2), [ _3 ]) )
# 2743 "cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : string * cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Cabs.definition list) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 415 "cparser.mly"
                                        ( LINKAGE (fst _2, (*handleLoc*) (snd _2), _4)  )
# 2754 "cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : string * cabsloc) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 417 "cparser.mly"
                                        ( GLOBASM (fst _3, (*handleLoc*) _1) )
# 2764 "cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'pragma) in
    Obj.repr(
# 418 "cparser.mly"
                                        ( _1 )
# 2771 "cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : string * Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : string list) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'old_pardef_list) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 423 "cparser.mly"
                           ( (* Convert pardecl to new style *)
                             let pardecl, isva = doOldParDecl _3 _5 in 
                             (* Make the function declarator *)
                             doDeclaration ((*handleLoc*) (snd _1)) []
                               [((fst _1, PROTO(JUSTBASE, pardecl,isva), [], cabslu),
                                 NO_INIT)]
                            )
# 2788 "cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : string * Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 432 "cparser.mly"
                           ( (* Make the function declarator *)
                             doDeclaration ((*handleLoc*)(snd _1)) []
                               [((fst _1, PROTO(JUSTBASE,[],false), [], cabslu),
                                 NO_INIT)]
                            )
# 2801 "cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 7 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 6 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 5 : Cabs.definition) in
    let _4 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _5 = (Parsing.peek_val __caml_parser_env 3 : string * Cabs.cabsloc) in
    let _6 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _7 = (Parsing.peek_val __caml_parser_env 1 : Cabs.definition list) in
    let _8 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 438 "cparser.mly"
                                                                        (
    checkConnective(fst _5);
    TRANSFORMER(_3, _7, _1)
  )
# 2818 "cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 7 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 6 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 5 : Cabs.expression * cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _5 = (Parsing.peek_val __caml_parser_env 3 : string * Cabs.cabsloc) in
    let _6 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _7 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression * cabsloc) in
    let _8 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 443 "cparser.mly"
                                                                                   (
    checkConnective(fst _5);
    EXPRTRANSFORMER(fst _3, fst _7, _1)
  )
# 2835 "cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 447 "cparser.mly"
                           ( PRAGMA (VARIABLE "parse_error", _1) )
# 2843 "cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 451 "cparser.mly"
             (fst _1)
# 2850 "cparser.ml"
               : 'id_or_typename))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 452 "cparser.mly"
                  (fst _1)
# 2857 "cparser.ml"
               : 'id_or_typename))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : string * Cabs.cabsloc) in
    Obj.repr(
# 453 "cparser.mly"
                                        ( "@name(" ^ fst _3 ^ ")" )
# 2865 "cparser.ml"
               : 'id_or_typename))
; (fun __caml_parser_env ->
    Obj.repr(
# 457 "cparser.mly"
                                        ( () )
# 2871 "cparser.ml"
               : 'maybecomma))
; (fun __caml_parser_env ->
    Obj.repr(
# 458 "cparser.mly"
                                        ( () )
# 2877 "cparser.ml"
               : 'maybecomma))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 465 "cparser.mly"
          (VARIABLE (fst _1), snd _1)
# 2884 "cparser.ml"
               : 'primary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.constant * cabsloc) in
    Obj.repr(
# 467 "cparser.mly"
          (CONSTANT (fst _1), snd _1)
# 2891 "cparser.ml"
               : 'primary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.expression list * cabsloc) in
    Obj.repr(
# 469 "cparser.mly"
          (PAREN (smooth_expression (fst _1)), snd _1)
# 2898 "cparser.ml"
               : 'primary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.block * cabsloc * cabsloc) in
    Obj.repr(
# 471 "cparser.mly"
          ( GNU_BODY (fst3 _2), _1 )
# 2906 "cparser.ml"
               : 'primary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : string * Cabs.cabsloc) in
    Obj.repr(
# 475 "cparser.mly"
                         ( EXPR_PATTERN(fst _3), _1 )
# 2915 "cparser.ml"
               : 'primary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'primary_expression) in
    Obj.repr(
# 480 "cparser.mly"
                        ( _1 )
# 2922 "cparser.ml"
               : 'postfix_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'postfix_expression) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.expression list) in
    Obj.repr(
# 482 "cparser.mly"
   (INDEX (fst _1, smooth_expression _2), snd _1)
# 2930 "cparser.ml"
               : 'postfix_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'postfix_expression) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression list) in
    Obj.repr(
# 484 "cparser.mly"
   (CALL (fst _1, _3), snd _1)
# 2939 "cparser.ml"
               : 'postfix_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : Cabs.expression * cabsloc) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : Cabs.spec_elem list * Cabs.decl_type) in
    Obj.repr(
# 486 "cparser.mly"
                        ( let b, d = _5 in
                          CALL (VARIABLE "__builtin_va_arg", 
                                [fst _3; TYPE_SIZEOF (b, d)]), _1 )
# 2951 "cparser.ml"
               : 'postfix_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : Cabs.spec_elem list * Cabs.decl_type) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : Cabs.spec_elem list * Cabs.decl_type) in
    Obj.repr(
# 490 "cparser.mly"
                        ( let b1,d1 = _3 in
                          let b2,d2 = _5 in
                          CALL (VARIABLE "__builtin_types_compatible_p", 
                                [TYPE_SIZEOF(b1,d1); TYPE_SIZEOF(b2,d2)]), _1 )
# 2964 "cparser.ml"
               : 'postfix_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : Cabs.spec_elem list * Cabs.decl_type) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'offsetof_member_designator) in
    Obj.repr(
# 495 "cparser.mly"
                        ( transformOffsetOf _3 _5, _1 )
# 2974 "cparser.ml"
               : 'postfix_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'postfix_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'id_or_typename) in
    Obj.repr(
# 497 "cparser.mly"
          (MEMBEROF (fst _1, _3), snd _1)
# 2982 "cparser.ml"
               : 'postfix_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'postfix_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'id_or_typename) in
    Obj.repr(
# 499 "cparser.mly"
          (MEMBEROFPTR (fst _1, _3), snd _1)
# 2990 "cparser.ml"
               : 'postfix_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'postfix_expression) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 501 "cparser.mly"
          (UNARY (POSINCR, fst _1), snd _1)
# 2998 "cparser.ml"
               : 'postfix_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'postfix_expression) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 503 "cparser.mly"
          (UNARY (POSDECR, fst _1), snd _1)
# 3006 "cparser.ml"
               : 'postfix_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Cabs.spec_elem list * Cabs.decl_type) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'initializer_list_opt) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 506 "cparser.mly"
          ( CAST(_2, COMPOUND_INIT _5), _1 )
# 3017 "cparser.ml"
               : 'postfix_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'id_or_typename) in
    Obj.repr(
# 511 "cparser.mly"
          ( VARIABLE (_1) )
# 3024 "cparser.ml"
               : 'offsetof_member_designator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'offsetof_member_designator) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 513 "cparser.mly"
   ( MEMBEROF (_1, fst _3) )
# 3032 "cparser.ml"
               : 'offsetof_member_designator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'offsetof_member_designator) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.expression list) in
    Obj.repr(
# 515 "cparser.mly"
   ( INDEX (_1, smooth_expression _2) )
# 3040 "cparser.ml"
               : 'offsetof_member_designator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'postfix_expression) in
    Obj.repr(
# 520 "cparser.mly"
                        ( _1 )
# 3047 "cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'unary_expression) in
    Obj.repr(
# 522 "cparser.mly"
          (UNARY (PREINCR, fst _2), _1)
# 3055 "cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'unary_expression) in
    Obj.repr(
# 524 "cparser.mly"
          (UNARY (PREDECR, fst _2), _1)
# 3063 "cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'unary_expression) in
    Obj.repr(
# 526 "cparser.mly"
          (EXPR_SIZEOF (fst _2), _1)
# 3071 "cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.spec_elem list * Cabs.decl_type) in
    Obj.repr(
# 528 "cparser.mly"
          (let b, d = _3 in TYPE_SIZEOF (b, d), _1)
# 3080 "cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'unary_expression) in
    Obj.repr(
# 530 "cparser.mly"
          (EXPR_ALIGNOF (fst _2), _1)
# 3088 "cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.spec_elem list * Cabs.decl_type) in
    Obj.repr(
# 532 "cparser.mly"
          (let b, d = _3 in TYPE_ALIGNOF (b, d), _1)
# 3097 "cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expression) in
    Obj.repr(
# 534 "cparser.mly"
          (UNARY (PLUS, fst _2), _1)
# 3105 "cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expression) in
    Obj.repr(
# 536 "cparser.mly"
          (UNARY (MINUS, fst _2), _1)
# 3113 "cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expression) in
    Obj.repr(
# 538 "cparser.mly"
          (UNARY (MEMOF, fst _2), _1)
# 3121 "cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expression) in
    Obj.repr(
# 540 "cparser.mly"
          (UNARY (ADDROF, fst _2), _1)
# 3129 "cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expression) in
    Obj.repr(
# 542 "cparser.mly"
          (UNARY (NOT, fst _2), _1)
# 3137 "cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expression) in
    Obj.repr(
# 544 "cparser.mly"
          (UNARY (BNOT, fst _2), _1)
# 3145 "cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 545 "cparser.mly"
                               ( LABELADDR (fst _2), _1 )
# 3153 "cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'unary_expression) in
    Obj.repr(
# 550 "cparser.mly"
                         ( _1 )
# 3160 "cparser.ml"
               : 'cast_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.spec_elem list * Cabs.decl_type) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expression) in
    Obj.repr(
# 552 "cparser.mly"
           ( CAST(_2, SINGLE_INIT (fst _4)), _1 )
# 3169 "cparser.ml"
               : 'cast_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expression) in
    Obj.repr(
# 557 "cparser.mly"
                         ( _1 )
# 3176 "cparser.ml"
               : 'multiplicative_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'multiplicative_expression) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expression) in
    Obj.repr(
# 559 "cparser.mly"
   (BINARY(MUL, fst _1, fst _3), snd _1)
# 3185 "cparser.ml"
               : 'multiplicative_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'multiplicative_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expression) in
    Obj.repr(
# 561 "cparser.mly"
   (BINARY(DIV, fst _1, fst _3), snd _1)
# 3193 "cparser.ml"
               : 'multiplicative_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'multiplicative_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expression) in
    Obj.repr(
# 563 "cparser.mly"
   (BINARY(MOD, fst _1, fst _3), snd _1)
# 3201 "cparser.ml"
               : 'multiplicative_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'multiplicative_expression) in
    Obj.repr(
# 568 "cparser.mly"
                        ( _1 )
# 3208 "cparser.ml"
               : 'additive_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'additive_expression) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'multiplicative_expression) in
    Obj.repr(
# 570 "cparser.mly"
   (BINARY(ADD, fst _1, fst _3), snd _1)
# 3217 "cparser.ml"
               : 'additive_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'additive_expression) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'multiplicative_expression) in
    Obj.repr(
# 572 "cparser.mly"
   (BINARY(SUB, fst _1, fst _3), snd _1)
# 3226 "cparser.ml"
               : 'additive_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'additive_expression) in
    Obj.repr(
# 577 "cparser.mly"
                         ( _1 )
# 3233 "cparser.ml"
               : 'shift_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'shift_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'additive_expression) in
    Obj.repr(
# 579 "cparser.mly"
   (BINARY(SHL, fst _1, fst _3), snd _1)
# 3241 "cparser.ml"
               : 'shift_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'shift_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'additive_expression) in
    Obj.repr(
# 581 "cparser.mly"
   (BINARY(SHR, fst _1, fst _3), snd _1)
# 3249 "cparser.ml"
               : 'shift_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'shift_expression) in
    Obj.repr(
# 587 "cparser.mly"
                        ( _1 )
# 3256 "cparser.ml"
               : 'relational_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'relational_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'shift_expression) in
    Obj.repr(
# 589 "cparser.mly"
   (BINARY(LT, fst _1, fst _3), snd _1)
# 3264 "cparser.ml"
               : 'relational_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'relational_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'shift_expression) in
    Obj.repr(
# 591 "cparser.mly"
   (BINARY(GT, fst _1, fst _3), snd _1)
# 3272 "cparser.ml"
               : 'relational_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'relational_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'shift_expression) in
    Obj.repr(
# 593 "cparser.mly"
   (BINARY(LE, fst _1, fst _3), snd _1)
# 3280 "cparser.ml"
               : 'relational_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'relational_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'shift_expression) in
    Obj.repr(
# 595 "cparser.mly"
   (BINARY(GE, fst _1, fst _3), snd _1)
# 3288 "cparser.ml"
               : 'relational_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'relational_expression) in
    Obj.repr(
# 600 "cparser.mly"
                        ( _1 )
# 3295 "cparser.ml"
               : 'equality_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'equality_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'relational_expression) in
    Obj.repr(
# 602 "cparser.mly"
   (BINARY(EQ, fst _1, fst _3), snd _1)
# 3303 "cparser.ml"
               : 'equality_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'equality_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'relational_expression) in
    Obj.repr(
# 604 "cparser.mly"
   (BINARY(NE, fst _1, fst _3), snd _1)
# 3311 "cparser.ml"
               : 'equality_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'equality_expression) in
    Obj.repr(
# 610 "cparser.mly"
                       ( _1 )
# 3318 "cparser.ml"
               : 'bitwise_and_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'bitwise_and_expression) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'equality_expression) in
    Obj.repr(
# 612 "cparser.mly"
   (BINARY(BAND, fst _1, fst _3), snd _1)
# 3327 "cparser.ml"
               : 'bitwise_and_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'bitwise_and_expression) in
    Obj.repr(
# 617 "cparser.mly"
                       ( _1 )
# 3334 "cparser.ml"
               : 'bitwise_xor_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'bitwise_xor_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'bitwise_and_expression) in
    Obj.repr(
# 619 "cparser.mly"
   (BINARY(XOR, fst _1, fst _3), snd _1)
# 3342 "cparser.ml"
               : 'bitwise_xor_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'bitwise_xor_expression) in
    Obj.repr(
# 624 "cparser.mly"
                        ( _1 )
# 3349 "cparser.ml"
               : 'bitwise_or_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'bitwise_or_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'bitwise_xor_expression) in
    Obj.repr(
# 626 "cparser.mly"
   (BINARY(BOR, fst _1, fst _3), snd _1)
# 3357 "cparser.ml"
               : 'bitwise_or_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'bitwise_or_expression) in
    Obj.repr(
# 631 "cparser.mly"
                        ( _1 )
# 3364 "cparser.ml"
               : 'logical_and_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'logical_and_expression) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'bitwise_or_expression) in
    Obj.repr(
# 633 "cparser.mly"
   (BINARY(AND, fst _1, fst _3), snd _1)
# 3373 "cparser.ml"
               : 'logical_and_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'logical_and_expression) in
    Obj.repr(
# 638 "cparser.mly"
                        ( _1 )
# 3380 "cparser.ml"
               : 'logical_or_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'logical_or_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'logical_and_expression) in
    Obj.repr(
# 640 "cparser.mly"
   (BINARY(OR, fst _1, fst _3), snd _1)
# 3388 "cparser.ml"
               : 'logical_or_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'logical_or_expression) in
    Obj.repr(
# 645 "cparser.mly"
                         ( _1 )
# 3395 "cparser.ml"
               : 'conditional_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : 'logical_or_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Cabs.expression) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'conditional_expression) in
    Obj.repr(
# 647 "cparser.mly"
   (QUESTION (fst _1, _3, fst _5), snd _1)
# 3404 "cparser.ml"
               : 'conditional_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'conditional_expression) in
    Obj.repr(
# 655 "cparser.mly"
                         ( _1 )
# 3411 "cparser.ml"
               : 'assignment_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cast_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'assignment_expression) in
    Obj.repr(
# 657 "cparser.mly"
   (BINARY(ASSIGN, fst _1, fst _3), snd _1)
# 3419 "cparser.ml"
               : 'assignment_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cast_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'assignment_expression) in
    Obj.repr(
# 659 "cparser.mly"
   (BINARY(ADD_ASSIGN, fst _1, fst _3), snd _1)
# 3427 "cparser.ml"
               : 'assignment_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cast_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'assignment_expression) in
    Obj.repr(
# 661 "cparser.mly"
   (BINARY(SUB_ASSIGN, fst _1, fst _3), snd _1)
# 3435 "cparser.ml"
               : 'assignment_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cast_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'assignment_expression) in
    Obj.repr(
# 663 "cparser.mly"
   (BINARY(MUL_ASSIGN, fst _1, fst _3), snd _1)
# 3443 "cparser.ml"
               : 'assignment_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cast_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'assignment_expression) in
    Obj.repr(
# 665 "cparser.mly"
   (BINARY(DIV_ASSIGN, fst _1, fst _3), snd _1)
# 3451 "cparser.ml"
               : 'assignment_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cast_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'assignment_expression) in
    Obj.repr(
# 667 "cparser.mly"
   (BINARY(MOD_ASSIGN, fst _1, fst _3), snd _1)
# 3459 "cparser.ml"
               : 'assignment_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cast_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'assignment_expression) in
    Obj.repr(
# 669 "cparser.mly"
   (BINARY(BAND_ASSIGN, fst _1, fst _3), snd _1)
# 3467 "cparser.ml"
               : 'assignment_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cast_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'assignment_expression) in
    Obj.repr(
# 671 "cparser.mly"
   (BINARY(BOR_ASSIGN, fst _1, fst _3), snd _1)
# 3475 "cparser.ml"
               : 'assignment_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cast_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'assignment_expression) in
    Obj.repr(
# 673 "cparser.mly"
   (BINARY(XOR_ASSIGN, fst _1, fst _3), snd _1)
# 3483 "cparser.ml"
               : 'assignment_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cast_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'assignment_expression) in
    Obj.repr(
# 675 "cparser.mly"
   (BINARY(SHL_ASSIGN, fst _1, fst _3), snd _1)
# 3491 "cparser.ml"
               : 'assignment_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cast_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'assignment_expression) in
    Obj.repr(
# 677 "cparser.mly"
   (BINARY(SHR_ASSIGN, fst _1, fst _3), snd _1)
# 3499 "cparser.ml"
               : 'assignment_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'assignment_expression) in
    Obj.repr(
# 682 "cparser.mly"
                        ( _1 )
# 3506 "cparser.ml"
               : Cabs.expression * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 687 "cparser.mly"
               (CONST_INT (fst _1), snd _1)
# 3513 "cparser.ml"
               : Cabs.constant * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 688 "cparser.mly"
                 (CONST_FLOAT (fst _1), snd _1)
# 3520 "cparser.ml"
               : Cabs.constant * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : int64 list * Cabs.cabsloc) in
    Obj.repr(
# 689 "cparser.mly"
                (CONST_CHAR (fst _1), snd _1)
# 3527 "cparser.ml"
               : Cabs.constant * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : int64 list * Cabs.cabsloc) in
    Obj.repr(
# 690 "cparser.mly"
                 (CONST_WCHAR (fst _1), snd _1)
# 3534 "cparser.ml"
               : Cabs.constant * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * cabsloc) in
    Obj.repr(
# 691 "cparser.mly"
                             (CONST_STRING (fst _1), snd _1)
# 3541 "cparser.ml"
               : Cabs.constant * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : int64 list * cabsloc) in
    Obj.repr(
# 692 "cparser.mly"
                   (CONST_WSTRING (fst _1), snd _1)
# 3548 "cparser.ml"
               : Cabs.constant * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : int64 list Queue.t * cabsloc) in
    Obj.repr(
# 698 "cparser.mly"
                                        (
     let queue, location = _1 in
     let buffer = Buffer.create (Queue.length queue) in
     Queue.iter
       (List.iter
	  (fun value ->
	    let char = int64_to_char value in
	    Buffer.add_char buffer char))
       queue;
     Buffer.contents buffer, location
   )
# 3565 "cparser.ml"
               : string * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : int64 list * Cabs.cabsloc) in
    Obj.repr(
# 712 "cparser.mly"
                                        (intlist_to_string (fst _1) )
# 3572 "cparser.ml"
               : 'one_string_constant))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'one_string) in
    Obj.repr(
# 715 "cparser.mly"
                                        (
      let queue = Queue.create () in
      Queue.add (fst _1) queue;
      queue, snd _1
    )
# 3583 "cparser.ml"
               : int64 list Queue.t * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : int64 list Queue.t * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'one_string) in
    Obj.repr(
# 720 "cparser.mly"
                                        (
      Queue.add (fst _2) (fst _1);
      _1
    )
# 3594 "cparser.ml"
               : int64 list Queue.t * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : int64 list * Cabs.cabsloc) in
    Obj.repr(
# 727 "cparser.mly"
                                        ( _1 )
# 3601 "cparser.ml"
               : int64 list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : int64 list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'one_string) in
    Obj.repr(
# 728 "cparser.mly"
                                        ( (fst _1) @ (fst _2), snd _1 )
# 3609 "cparser.ml"
               : int64 list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : int64 list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : int64 list * Cabs.cabsloc) in
    Obj.repr(
# 729 "cparser.mly"
                                        ( (fst _1) @ (fst _2), snd _1 )
# 3617 "cparser.ml"
               : int64 list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : int64 list * Cabs.cabsloc) in
    Obj.repr(
# 734 "cparser.mly"
                  (_1)
# 3624 "cparser.ml"
               : 'one_string))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 735 "cparser.mly"
                                        ((Cabshelper.explodeStringToInts 
					    !currentFunctionName), _1)
# 3632 "cparser.ml"
               : 'one_string))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 737 "cparser.mly"
                                        ((Cabshelper.explodeStringToInts 
					    !currentFunctionName), _1)
# 3640 "cparser.ml"
               : 'one_string))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.expression * cabsloc) in
    Obj.repr(
# 742 "cparser.mly"
                        ( SINGLE_INIT (fst _1) )
# 3647 "cparser.ml"
               : Cabs.init_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'initializer_list_opt) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 744 "cparser.mly"
   ( COMPOUND_INIT _2)
# 3656 "cparser.ml"
               : Cabs.init_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.initwhat * Cabs.init_expression) in
    Obj.repr(
# 747 "cparser.mly"
                                            ( [_1] )
# 3663 "cparser.ml"
               : (Cabs.initwhat * Cabs.init_expression) list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.initwhat * Cabs.init_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'initializer_list_opt) in
    Obj.repr(
# 748 "cparser.mly"
                                            ( _1 :: _3 )
# 3671 "cparser.ml"
               : (Cabs.initwhat * Cabs.init_expression) list))
; (fun __caml_parser_env ->
    Obj.repr(
# 751 "cparser.mly"
                                            ( [] )
# 3677 "cparser.ml"
               : 'initializer_list_opt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : (Cabs.initwhat * Cabs.init_expression) list) in
    Obj.repr(
# 752 "cparser.mly"
                                            ( _1 )
# 3684 "cparser.ml"
               : 'initializer_list_opt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.initwhat) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'eq_opt) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.init_expression) in
    Obj.repr(
# 755 "cparser.mly"
                                            ( (_1, _3) )
# 3693 "cparser.ml"
               : Cabs.initwhat * Cabs.init_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'gcc_init_designators) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.init_expression) in
    Obj.repr(
# 756 "cparser.mly"
                                         ( (_1, _2) )
# 3701 "cparser.ml"
               : Cabs.initwhat * Cabs.init_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.init_expression) in
    Obj.repr(
# 757 "cparser.mly"
                                        ( (NEXT_INIT, _1) )
# 3708 "cparser.ml"
               : Cabs.initwhat * Cabs.init_expression))
; (fun __caml_parser_env ->
    Obj.repr(
# 760 "cparser.mly"
                             ( () )
# 3714 "cparser.ml"
               : 'eq_opt))
; (fun __caml_parser_env ->
    Obj.repr(
# 762 "cparser.mly"
                                 ( () )
# 3720 "cparser.ml"
               : 'eq_opt))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'id_or_typename) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.initwhat) in
    Obj.repr(
# 765 "cparser.mly"
                                                 ( INFIELD_INIT(_2, _3) )
# 3728 "cparser.ml"
               : Cabs.initwhat))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.expression * cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Cabs.initwhat) in
    Obj.repr(
# 767 "cparser.mly"
                                        ( ATINDEX_INIT(fst _2, _4) )
# 3736 "cparser.ml"
               : Cabs.initwhat))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Cabs.expression * cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression * cabsloc) in
    Obj.repr(
# 769 "cparser.mly"
                                        ( ATINDEXRANGE_INIT(fst _2, fst _4) )
# 3744 "cparser.ml"
               : Cabs.initwhat))
; (fun __caml_parser_env ->
    Obj.repr(
# 772 "cparser.mly"
                                        ( NEXT_INIT )
# 3750 "cparser.ml"
               : Cabs.initwhat))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.initwhat) in
    Obj.repr(
# 773 "cparser.mly"
                                        ( _1 )
# 3757 "cparser.ml"
               : Cabs.initwhat))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'id_or_typename) in
    Obj.repr(
# 777 "cparser.mly"
                                        ( INFIELD_INIT(_1, NEXT_INIT) )
# 3764 "cparser.ml"
               : 'gcc_init_designators))
; (fun __caml_parser_env ->
    Obj.repr(
# 781 "cparser.mly"
                                    ( [] )
# 3770 "cparser.ml"
               : Cabs.expression list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.expression list * cabsloc) in
    Obj.repr(
# 782 "cparser.mly"
                                    ( fst _1 )
# 3777 "cparser.ml"
               : Cabs.expression list))
; (fun __caml_parser_env ->
    Obj.repr(
# 787 "cparser.mly"
          (NOTHING)
# 3783 "cparser.ml"
               : Cabs.expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.expression list * cabsloc) in
    Obj.repr(
# 789 "cparser.mly"
          (smooth_expression (fst _1))
# 3790 "cparser.ml"
               : Cabs.expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.expression * cabsloc) in
    Obj.repr(
# 793 "cparser.mly"
                                           ([fst _1], snd _1)
# 3797 "cparser.ml"
               : Cabs.expression list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.expression * cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.expression list * cabsloc) in
    Obj.repr(
# 794 "cparser.mly"
                                                  ( fst _1 :: fst _3, snd _1 )
# 3805 "cparser.ml"
               : Cabs.expression list * cabsloc))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.expression list * cabsloc) in
    Obj.repr(
# 795 "cparser.mly"
                                                  ( _3 )
# 3812 "cparser.ml"
               : Cabs.expression list * cabsloc))
; (fun __caml_parser_env ->
    Obj.repr(
# 799 "cparser.mly"
                                    ( NOTHING )
# 3818 "cparser.ml"
               : 'comma_expression_opt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.expression list * cabsloc) in
    Obj.repr(
# 800 "cparser.mly"
                                    ( smooth_expression (fst _1) )
# 3825 "cparser.ml"
               : 'comma_expression_opt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression list * cabsloc) in
    Obj.repr(
# 804 "cparser.mly"
                                                   ( _2 )
# 3833 "cparser.ml"
               : Cabs.expression list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    Obj.repr(
# 805 "cparser.mly"
                                                   ( [], _1 )
# 3840 "cparser.ml"
               : Cabs.expression list * cabsloc))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression list * cabsloc) in
    Obj.repr(
# 809 "cparser.mly"
                                                       ( fst _2 )
# 3847 "cparser.ml"
               : Cabs.expression list))
; (fun __caml_parser_env ->
    Obj.repr(
# 810 "cparser.mly"
                                                       ( [] )
# 3853 "cparser.ml"
               : Cabs.expression list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : 'block_begin) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : string list) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'block_attrs) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Cabs.statement list) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 817 "cparser.mly"
                                         (!Lexerhack.pop_context();
                                          { blabels = _2;
                                            battrs = _3;
                                            bstmts = _4 },
					    _1, _5
                                         )
# 3869 "cparser.ml"
               : Cabs.block * cabsloc * cabsloc))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 823 "cparser.mly"
                                         ( { blabels = [];
                                             battrs  = [];
                                             bstmts  = [] },
					     _2, _3
                                         )
# 3881 "cparser.ml"
               : Cabs.block * cabsloc * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 830 "cparser.mly"
                           (!Lexerhack.push_context (); _1)
# 3888 "cparser.ml"
               : 'block_begin))
; (fun __caml_parser_env ->
    Obj.repr(
# 834 "cparser.mly"
                                                            ( [] )
# 3894 "cparser.ml"
               : 'block_attrs))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'paren_attr_list_ne) in
    Obj.repr(
# 836 "cparser.mly"
                                        ( [("__blockattribute__", _2)] )
# 3901 "cparser.ml"
               : 'block_attrs))
; (fun __caml_parser_env ->
    Obj.repr(
# 841 "cparser.mly"
                                         ( [] )
# 3907 "cparser.ml"
               : Cabs.statement list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.definition) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.statement list) in
    Obj.repr(
# 842 "cparser.mly"
                                         ( DEFINITION(_1) :: _2 )
# 3915 "cparser.ml"
               : Cabs.statement list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.statement) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.statement list) in
    Obj.repr(
# 843 "cparser.mly"
                                         ( _1 :: _2 )
# 3923 "cparser.ml"
               : Cabs.statement list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : string * Cabs.cabsloc) in
    Obj.repr(
# 845 "cparser.mly"
                                         ( [ LABEL (fst _1, NOP (snd _1), 
                                                    snd _1)] )
# 3931 "cparser.ml"
               : Cabs.statement list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'pragma) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.statement list) in
    Obj.repr(
# 847 "cparser.mly"
                                         ( _2 )
# 3939 "cparser.ml"
               : Cabs.statement list))
; (fun __caml_parser_env ->
    Obj.repr(
# 851 "cparser.mly"
                                                     ( [] )
# 3945 "cparser.ml"
               : string list))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : string list) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : string list) in
    Obj.repr(
# 852 "cparser.mly"
                                                     ( _2 @ _4 )
# 3954 "cparser.ml"
               : string list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 855 "cparser.mly"
                                         ( [ fst _1 ] )
# 3961 "cparser.ml"
               : string list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string * Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : string list) in
    Obj.repr(
# 856 "cparser.mly"
                                         ( fst _1 :: _3 )
# 3969 "cparser.ml"
               : string list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 862 "cparser.mly"
               (NOP ((*handleLoc*) _1) )
# 3976 "cparser.ml"
               : Cabs.statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 864 "cparser.mly"
          (COMPUTATION (smooth_expression (fst _1), (*handleLoc*)(snd _1)))
# 3984 "cparser.ml"
               : Cabs.statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.block * cabsloc * cabsloc) in
    Obj.repr(
# 865 "cparser.mly"
                        (BLOCK (fst3 _1, (*handleLoc*)(snd3 _1)))
# 3991 "cparser.ml"
               : Cabs.statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression list * cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.statement) in
    Obj.repr(
# 867 "cparser.mly"
                 (IF (smooth_expression (fst _2), _3, NOP _1, _1))
# 4000 "cparser.ml"
               : Cabs.statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Cabs.expression list * cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Cabs.statement) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Cabs.statement) in
    Obj.repr(
# 869 "cparser.mly"
                 (IF (smooth_expression (fst _2), _3, _5, (*handleLoc*) _1))
# 4010 "cparser.ml"
               : Cabs.statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression list * cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.statement) in
    Obj.repr(
# 871 "cparser.mly"
                        (SWITCH (smooth_expression (fst _2), _3, (*handleLoc*) _1))
# 4019 "cparser.ml"
               : Cabs.statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression list * cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.statement) in
    Obj.repr(
# 873 "cparser.mly"
          (WHILE (smooth_expression (fst _2), _3, (*handleLoc*) _1))
# 4028 "cparser.ml"
               : Cabs.statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Cabs.statement) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression list * cabsloc) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 875 "cparser.mly"
                   (DOWHILE (smooth_expression (fst _4), _2, (*handleLoc*) _1))
# 4039 "cparser.ml"
               : Cabs.statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 7 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 6 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 5 : 'for_clause) in
    let _4 = (Parsing.peek_val __caml_parser_env 4 : Cabs.expression) in
    let _5 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _6 = (Parsing.peek_val __caml_parser_env 2 : Cabs.expression) in
    let _8 = (Parsing.peek_val __caml_parser_env 0 : Cabs.statement) in
    Obj.repr(
# 878 "cparser.mly"
                          (FOR (_3, _4, _6, _8, (*handleLoc*) _1))
# 4052 "cparser.ml"
               : Cabs.statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : string * Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'attribute_nocv_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Cabs.statement) in
    Obj.repr(
# 880 "cparser.mly"
                   ((* The only attribute that should appear here
                                     is "unused". For now, we drop this on the
                                     floor, since unused labels are usually
                                     removed anyways by Rmtmps. *)
                                  LABEL (fst _1, _4, (snd _1)))
# 4065 "cparser.ml"
               : Cabs.statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.expression * cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Cabs.statement) in
    Obj.repr(
# 886 "cparser.mly"
                          (CASE (fst _2, _4, (*handleLoc*) _1))
# 4074 "cparser.ml"
               : Cabs.statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Cabs.expression * cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Cabs.expression * cabsloc) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : Cabs.statement) in
    Obj.repr(
# 888 "cparser.mly"
                          (CASERANGE (fst _2, fst _4, _6, (*handleLoc*) _1))
# 4084 "cparser.ml"
               : Cabs.statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    Obj.repr(
# 890 "cparser.mly"
                          (DEFAULT (NOP _1, (*handleLoc*) _1))
# 4091 "cparser.ml"
               : Cabs.statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 891 "cparser.mly"
                       (RETURN (NOTHING, (*handleLoc*) _1))
# 4099 "cparser.ml"
               : Cabs.statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression list * cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 893 "cparser.mly"
                          (RETURN (smooth_expression (fst _2), (*handleLoc*) _1))
# 4108 "cparser.ml"
               : Cabs.statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 894 "cparser.mly"
                        (BREAK ((*handleLoc*) _1))
# 4116 "cparser.ml"
               : Cabs.statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 895 "cparser.mly"
                        (CONTINUE ((*handleLoc*) _1))
# 4124 "cparser.ml"
               : Cabs.statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : string * Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 897 "cparser.mly"
                   (GOTO (fst _2, (*handleLoc*) _1))
# 4133 "cparser.ml"
               : Cabs.statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression list * cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 899 "cparser.mly"
                                 ( COMPGOTO (smooth_expression (fst _3), (*handleLoc*) _1) )
# 4143 "cparser.ml"
               : Cabs.statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 6 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 5 : Cabs.attribute list) in
    let _3 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 3 : 'asmtemplate) in
    let _5 = (Parsing.peek_val __caml_parser_env 2 : 'asmoutputs) in
    let _7 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 901 "cparser.mly"
                        ( ASM (_2, _4, _5, (*handleLoc*) _1) )
# 4155 "cparser.ml"
               : Cabs.statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 902 "cparser.mly"
                        ( ASM ([], [fst _1], None, (*handleLoc*)(snd _1)))
# 4162 "cparser.ml"
               : Cabs.statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Cabs.block * cabsloc * cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression list * cabsloc) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Cabs.block * cabsloc * cabsloc) in
    Obj.repr(
# 904 "cparser.mly"
                        ( let b, _, _ = _2 in
                          let h, _, _ = _5 in
                          if not !Cprint.msvcMode then 
                            parse_error "try/except in GCC code";
                          TRY_EXCEPT (b, COMMA (fst _4), h, (*handleLoc*) _1) )
# 4177 "cparser.ml"
               : Cabs.statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.block * cabsloc * cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Cabs.block * cabsloc * cabsloc) in
    Obj.repr(
# 910 "cparser.mly"
                        ( let b, _, _ = _2 in
                          let h, _, _ = _4 in
                          if not !Cprint.msvcMode then 
                            parse_error "try/finally in GCC code";
                          TRY_FINALLY (b, h, (*handleLoc*) _1) )
# 4191 "cparser.ml"
               : Cabs.statement))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 916 "cparser.mly"
                                 ( (NOP _2))
# 4199 "cparser.ml"
               : Cabs.statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 921 "cparser.mly"
                                 ( FC_EXP _1 )
# 4207 "cparser.ml"
               : 'for_clause))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.definition) in
    Obj.repr(
# 922 "cparser.mly"
                                 ( FC_DECL _1 )
# 4214 "cparser.ml"
               : 'for_clause))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : spec_elem list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.init_name list) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 927 "cparser.mly"
                                       ( doDeclaration ((*handleLoc*)(snd _1)) (fst _1) _2 )
# 4223 "cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : spec_elem list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 929 "cparser.mly"
                                       ( doDeclaration ((*handleLoc*)(snd _1)) (fst _1) [] )
# 4231 "cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.init_name) in
    Obj.repr(
# 932 "cparser.mly"
                                                 ( [_1] )
# 4238 "cparser.ml"
               : Cabs.init_name list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.init_name) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.init_name list) in
    Obj.repr(
# 933 "cparser.mly"
                                                 ( _1 :: _3 )
# 4246 "cparser.ml"
               : Cabs.init_name list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.name) in
    Obj.repr(
# 937 "cparser.mly"
                                        ( (_1, NO_INIT) )
# 4253 "cparser.ml"
               : Cabs.init_name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.name) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.init_expression) in
    Obj.repr(
# 939 "cparser.mly"
                                        ( (_1, _3) )
# 4261 "cparser.ml"
               : Cabs.init_name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec_list_opt) in
    Obj.repr(
# 944 "cparser.mly"
                                        ( SpecTypedef :: _2, _1  )
# 4269 "cparser.ml"
               : spec_elem list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec_list_opt) in
    Obj.repr(
# 945 "cparser.mly"
                                        ( SpecStorage EXTERN :: _2, _1 )
# 4277 "cparser.ml"
               : spec_elem list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec_list_opt) in
    Obj.repr(
# 946 "cparser.mly"
                                        ( SpecStorage STATIC :: _2, _1 )
# 4285 "cparser.ml"
               : spec_elem list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec_list_opt) in
    Obj.repr(
# 947 "cparser.mly"
                                        ( SpecStorage AUTO :: _2, _1 )
# 4293 "cparser.ml"
               : spec_elem list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec_list_opt) in
    Obj.repr(
# 948 "cparser.mly"
                                        ( SpecStorage REGISTER :: _2, _1)
# 4301 "cparser.ml"
               : spec_elem list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : typeSpecifier * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec_list_opt_no_named) in
    Obj.repr(
# 950 "cparser.mly"
                                          ( SpecType (fst _1) :: _2, snd _1 )
# 4309 "cparser.ml"
               : spec_elem list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec_list_opt) in
    Obj.repr(
# 952 "cparser.mly"
                                        ( SpecInline :: _2, _1 )
# 4317 "cparser.ml"
               : spec_elem list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.spec_elem * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec_list_opt) in
    Obj.repr(
# 953 "cparser.mly"
                                        ( (fst _1) :: _2, snd _1 )
# 4325 "cparser.ml"
               : spec_elem list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'attribute_nocv) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec_list_opt) in
    Obj.repr(
# 954 "cparser.mly"
                                        ( SpecAttr (fst _1) :: _2, snd _1 )
# 4333 "cparser.ml"
               : spec_elem list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : string * Cabs.cabsloc) in
    Obj.repr(
# 956 "cparser.mly"
                                        ( [ SpecPattern(fst _3) ], _1 )
# 4342 "cparser.ml"
               : spec_elem list * cabsloc))
; (fun __caml_parser_env ->
    Obj.repr(
# 961 "cparser.mly"
                                        ( [] )
# 4348 "cparser.ml"
               : 'decl_spec_list_opt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : spec_elem list * cabsloc) in
    Obj.repr(
# 962 "cparser.mly"
                                        ( fst _1 )
# 4355 "cparser.ml"
               : 'decl_spec_list_opt))
; (fun __caml_parser_env ->
    Obj.repr(
# 969 "cparser.mly"
                                        ( [] )
# 4361 "cparser.ml"
               : 'decl_spec_list_opt_no_named))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : spec_elem list * cabsloc) in
    Obj.repr(
# 970 "cparser.mly"
                                        ( fst _1 )
# 4368 "cparser.ml"
               : 'decl_spec_list_opt_no_named))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 973 "cparser.mly"
                    ( Tvoid, _1)
# 4375 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 974 "cparser.mly"
                    ( Tchar, _1 )
# 4382 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 975 "cparser.mly"
                    ( Tshort, _1 )
# 4389 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 976 "cparser.mly"
                    ( Tbool, _1 )
# 4396 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 977 "cparser.mly"
                    ( Tint, _1 )
# 4403 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 978 "cparser.mly"
                    ( Tlong, _1 )
# 4410 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 979 "cparser.mly"
                    ( Tint64, _1 )
# 4417 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 980 "cparser.mly"
                    ( Tfloat, _1 )
# 4424 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 981 "cparser.mly"
                    ( Tdouble, _1 )
# 4431 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 982 "cparser.mly"
                    ( Tsigned, _1 )
# 4438 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 983 "cparser.mly"
                    ( Tunsigned, _1 )
# 4445 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'id_or_typename) in
    Obj.repr(
# 985 "cparser.mly"
                                                   ( Tstruct (_2, None,    []), _1 )
# 4453 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'just_attributes) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'id_or_typename) in
    Obj.repr(
# 987 "cparser.mly"
                                                   ( Tstruct (_3, None,    _2), _1 )
# 4462 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'id_or_typename) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Cabs.field_group list) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 989 "cparser.mly"
                                                   ( Tstruct (_2, Some _4, []), _1 )
# 4473 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.field_group list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 991 "cparser.mly"
                                                   ( Tstruct ("", Some _3, []), _1 )
# 4483 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'just_attributes) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'id_or_typename) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : Cabs.field_group list) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 993 "cparser.mly"
                                                   ( Tstruct (_3, Some _5, _2), _1 )
# 4495 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'just_attributes) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Cabs.field_group list) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 995 "cparser.mly"
                                                   ( Tstruct ("", Some _4, _2), _1 )
# 4506 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'id_or_typename) in
    Obj.repr(
# 997 "cparser.mly"
                                                   ( Tunion  (_2, None,    []), _1 )
# 4514 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'id_or_typename) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Cabs.field_group list) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 999 "cparser.mly"
                                                   ( Tunion  (_2, Some _4, []), _1 )
# 4525 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.field_group list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1001 "cparser.mly"
                                                   ( Tunion  ("", Some _3, []), _1 )
# 4535 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'just_attributes) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'id_or_typename) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : Cabs.field_group list) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1003 "cparser.mly"
                                                   ( Tunion  (_3, Some _5, _2), _1 )
# 4547 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'just_attributes) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Cabs.field_group list) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1005 "cparser.mly"
                                                   ( Tunion  ("", Some _4, _2), _1 )
# 4558 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'id_or_typename) in
    Obj.repr(
# 1007 "cparser.mly"
                                                   ( Tenum   (_2, None,    []), _1 )
# 4566 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'id_or_typename) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Cabs.enum_item list) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'maybecomma) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1009 "cparser.mly"
                                                   ( Tenum   (_2, Some _4, []), _1 )
# 4578 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Cabs.enum_item list) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'maybecomma) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1011 "cparser.mly"
                                                   ( Tenum   ("", Some _3, []), _1 )
# 4589 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 6 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 5 : 'just_attributes) in
    let _3 = (Parsing.peek_val __caml_parser_env 4 : 'id_or_typename) in
    let _4 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _5 = (Parsing.peek_val __caml_parser_env 2 : Cabs.enum_item list) in
    let _6 = (Parsing.peek_val __caml_parser_env 1 : 'maybecomma) in
    let _7 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1013 "cparser.mly"
                                                   ( Tenum   (_3, Some _5, _2), _1 )
# 4602 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'just_attributes) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Cabs.enum_item list) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'maybecomma) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1015 "cparser.mly"
                                                   ( Tenum   ("", Some _4, _2), _1 )
# 4614 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1016 "cparser.mly"
                    ( Tnamed (fst _1), snd _1 )
# 4621 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression * cabsloc) in
    Obj.repr(
# 1017 "cparser.mly"
                                        ( TtypeofE (fst _3), _1 )
# 4630 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.spec_elem list * Cabs.decl_type) in
    Obj.repr(
# 1018 "cparser.mly"
                                        ( let s, d = _3 in
                                          TtypeofT (s, d), _1 )
# 4640 "cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    Obj.repr(
# 1024 "cparser.mly"
                                         ( [] )
# 4646 "cparser.ml"
               : Cabs.field_group list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : spec_elem list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.field_group list) in
    Obj.repr(
# 1026 "cparser.mly"
                                         ( (fst _1, 
                                            [(missingFieldDecl, None)]) :: _3 )
# 4656 "cparser.ml"
               : Cabs.field_group list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.field_group list) in
    Obj.repr(
# 1030 "cparser.mly"
                                         ( _2 )
# 4664 "cparser.ml"
               : Cabs.field_group list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : spec_elem list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : (Cabs.name * expression option) list) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Cabs.field_group list) in
    Obj.repr(
# 1032 "cparser.mly"
                                          ( (fst _1, _2) 
                                            :: _4 )
# 4675 "cparser.ml"
               : Cabs.field_group list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'pragma) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.field_group list) in
    Obj.repr(
# 1035 "cparser.mly"
                                          ( _2 )
# 4683 "cparser.ml"
               : Cabs.field_group list))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.field_group list) in
    Obj.repr(
# 1038 "cparser.mly"
                                          ( _3 )
# 4691 "cparser.ml"
               : Cabs.field_group list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.name * expression option) in
    Obj.repr(
# 1041 "cparser.mly"
                                         ( [_1] )
# 4698 "cparser.ml"
               : (Cabs.name * expression option) list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.name * expression option) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : (Cabs.name * expression option) list) in
    Obj.repr(
# 1042 "cparser.mly"
                                         ( _1 :: _3 )
# 4706 "cparser.ml"
               : (Cabs.name * expression option) list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.name) in
    Obj.repr(
# 1045 "cparser.mly"
                                    ( (_1, None) )
# 4713 "cparser.ml"
               : Cabs.name * expression option))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.name) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression * cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Cabs.attribute list) in
    Obj.repr(
# 1047 "cparser.mly"
                                    ( let (n,decl,al,loc) = _1 in
                                      let al' = al @ _4 in
                                     ((n,decl,al',loc), Some (fst _3)) )
# 4724 "cparser.ml"
               : Cabs.name * expression option))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.expression * cabsloc) in
    Obj.repr(
# 1050 "cparser.mly"
                                    ( (missingFieldDecl, Some (fst _2)) )
# 4731 "cparser.ml"
               : Cabs.name * expression option))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.enum_item) in
    Obj.repr(
# 1054 "cparser.mly"
                  ([_1])
# 4738 "cparser.ml"
               : Cabs.enum_item list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.enum_item list) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.enum_item) in
    Obj.repr(
# 1055 "cparser.mly"
                                       (_1 @ [_3])
# 4746 "cparser.ml"
               : Cabs.enum_item list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.enum_item list) in
    Obj.repr(
# 1056 "cparser.mly"
                                        ( _1 )
# 4753 "cparser.ml"
               : Cabs.enum_item list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1059 "cparser.mly"
            ((fst _1, NOTHING, snd _1))
# 4760 "cparser.ml"
               : Cabs.enum_item))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string * Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.expression * cabsloc) in
    Obj.repr(
# 1060 "cparser.mly"
                         ((fst _1, fst _3, snd _1))
# 4768 "cparser.ml"
               : Cabs.enum_item))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : attribute list list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : string * Cabs.decl_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.attribute list) in
    Obj.repr(
# 1066 "cparser.mly"
                               ( let (n, decl) = _2 in
                                (n, applyPointer (fst _1) decl, _3, (snd _1)) )
# 4778 "cparser.ml"
               : Cabs.name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'id_or_typename) in
    Obj.repr(
# 1074 "cparser.mly"
                                   ( (_1, JUSTBASE) )
# 4785 "cparser.ml"
               : string * Cabs.decl_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.attribute list) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.name) in
    Obj.repr(
# 1077 "cparser.mly"
                                   ( let (n,decl,al,loc) = _3 in
                                     (n, PARENTYPE(_2,decl,al)) )
# 4795 "cparser.ml"
               : string * Cabs.decl_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : string * Cabs.decl_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Cabs.attribute list) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'comma_expression_opt) in
    Obj.repr(
# 1081 "cparser.mly"
                                   ( let (n, decl) = _1 in
                                     (n, ARRAY(decl, _3, _4)) )
# 4805 "cparser.ml"
               : string * Cabs.decl_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : string * Cabs.decl_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Cabs.attribute list) in
    Obj.repr(
# 1084 "cparser.mly"
                                   ( let (n, decl) = _1 in
                                     (n, ARRAY(decl, _3, NOTHING)) )
# 4814 "cparser.ml"
               : string * Cabs.decl_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : string * Cabs.decl_type) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'parameter_list_startscope) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'rest_par_list) in
    Obj.repr(
# 1087 "cparser.mly"
                                   ( let (n, decl) = _1 in
                                     let (params, isva) = _3 in
                                     !Lexerhack.pop_context ();
                                     (n, PROTO(decl, params, isva))
                                   )
# 4827 "cparser.ml"
               : string * Cabs.decl_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1094 "cparser.mly"
                                   ( !Lexerhack.push_context () )
# 4834 "cparser.ml"
               : 'parameter_list_startscope))
; (fun __caml_parser_env ->
    Obj.repr(
# 1097 "cparser.mly"
                                   ( ([], false) )
# 4840 "cparser.ml"
               : 'rest_par_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.single_name) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'rest_par_list1) in
    Obj.repr(
# 1098 "cparser.mly"
                                   ( let (params, isva) = _2 in 
                                     (_1 :: params, isva) 
                                   )
# 4850 "cparser.ml"
               : 'rest_par_list))
; (fun __caml_parser_env ->
    Obj.repr(
# 1103 "cparser.mly"
                                        ( ([], false) )
# 4856 "cparser.ml"
               : 'rest_par_list1))
; (fun __caml_parser_env ->
    Obj.repr(
# 1104 "cparser.mly"
                                        ( ([], true) )
# 4862 "cparser.ml"
               : 'rest_par_list1))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.single_name) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'rest_par_list1) in
    Obj.repr(
# 1105 "cparser.mly"
                                        ( let (params, isva) = _3 in 
                                          (_2 :: params, isva)
                                        )
# 4872 "cparser.ml"
               : 'rest_par_list1))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : spec_elem list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.name) in
    Obj.repr(
# 1112 "cparser.mly"
                                          ( (fst _1, _2) )
# 4880 "cparser.ml"
               : Cabs.single_name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : spec_elem list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.decl_type * Cabs.attribute list) in
    Obj.repr(
# 1113 "cparser.mly"
                                          ( let d, a = _2 in
                                            (fst _1, ("", d, a, cabslu)) )
# 4889 "cparser.ml"
               : Cabs.single_name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : spec_elem list * cabsloc) in
    Obj.repr(
# 1115 "cparser.mly"
                                          ( (fst _1, ("", JUSTBASE, [], cabslu)) )
# 4896 "cparser.ml"
               : Cabs.single_name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.single_name) in
    Obj.repr(
# 1116 "cparser.mly"
                                          ( _2 )
# 4904 "cparser.ml"
               : Cabs.single_name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : attribute list list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'direct_old_proto_decl) in
    Obj.repr(
# 1121 "cparser.mly"
                                      ( let (n, decl, a) = _2 in
					  (n, applyPointer (fst _1) decl, 
                                           a, snd _1) 
                                      )
# 4915 "cparser.ml"
               : Cabs.name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : string * Cabs.decl_type) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : string list) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'old_pardef_list) in
    Obj.repr(
# 1130 "cparser.mly"
                                   ( let par_decl, isva = doOldParDecl _3 _5 in
                                     let n, decl = _1 in
                                     (n, PROTO(decl, par_decl, isva), [])
                                   )
# 4928 "cparser.ml"
               : 'direct_old_proto_decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string * Cabs.decl_type) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    Obj.repr(
# 1135 "cparser.mly"
                                   ( let n, decl = _1 in
                                     (n, PROTO(decl, [], false), [])
                                   )
# 4938 "cparser.ml"
               : 'direct_old_proto_decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1150 "cparser.mly"
                                               ( [fst _1] )
# 4945 "cparser.ml"
               : string list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string * Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : string list) in
    Obj.repr(
# 1151 "cparser.mly"
                                               ( let rest = _3 in
                                                 (fst _1 :: rest) )
# 4954 "cparser.ml"
               : string list))
; (fun __caml_parser_env ->
    Obj.repr(
# 1156 "cparser.mly"
                                          ( ([], false) )
# 4960 "cparser.ml"
               : 'old_pardef_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : spec_elem list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'old_pardef) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    Obj.repr(
# 1158 "cparser.mly"
                                          ( ([(fst _1, _2)], true) )
# 4969 "cparser.ml"
               : 'old_pardef_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : spec_elem list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'old_pardef) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'old_pardef_list) in
    Obj.repr(
# 1160 "cparser.mly"
                                          ( let rest, isva = _4 in
                                            ((fst _1, _2) :: rest, isva) 
                                          )
# 4981 "cparser.ml"
               : 'old_pardef_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.name) in
    Obj.repr(
# 1166 "cparser.mly"
                                          ( [_1] )
# 4988 "cparser.ml"
               : 'old_pardef))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.name) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'old_pardef) in
    Obj.repr(
# 1167 "cparser.mly"
                                          ( _1 :: _3 )
# 4996 "cparser.ml"
               : 'old_pardef))
; (fun __caml_parser_env ->
    Obj.repr(
# 1168 "cparser.mly"
                                          ( [] )
# 5002 "cparser.ml"
               : 'old_pardef))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.attribute list) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : attribute list list * cabsloc) in
    Obj.repr(
# 1173 "cparser.mly"
                                ( _2 :: fst _3, _1 )
# 5011 "cparser.ml"
               : attribute list list * cabsloc))
; (fun __caml_parser_env ->
    Obj.repr(
# 1176 "cparser.mly"
                                 ( let l = currentLoc () in
                                   ([], l) )
# 5018 "cparser.ml"
               : attribute list list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : attribute list list * cabsloc) in
    Obj.repr(
# 1178 "cparser.mly"
                                 ( _1 )
# 5025 "cparser.ml"
               : attribute list list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : spec_elem list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.decl_type * Cabs.attribute list) in
    Obj.repr(
# 1182 "cparser.mly"
                               ( let d, a = _2 in
                                 if a <> [] then begin
                                   parse_error "attributes in type name";
                                   raise Parsing.Parse_error
                                 end;
                                 (fst _1, d) 
                               )
# 5039 "cparser.ml"
               : Cabs.spec_elem list * Cabs.decl_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : spec_elem list * cabsloc) in
    Obj.repr(
# 1189 "cparser.mly"
                               ( (fst _1, JUSTBASE) )
# 5046 "cparser.ml"
               : Cabs.spec_elem list * Cabs.decl_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : attribute list list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.decl_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.attribute list) in
    Obj.repr(
# 1192 "cparser.mly"
                                          ( applyPointer (fst _1) _2, _3 )
# 5055 "cparser.ml"
               : Cabs.decl_type * Cabs.attribute list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : attribute list list * cabsloc) in
    Obj.repr(
# 1193 "cparser.mly"
                                          ( applyPointer (fst _1) JUSTBASE, [] )
# 5062 "cparser.ml"
               : Cabs.decl_type * Cabs.attribute list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.attribute list) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.decl_type * Cabs.attribute list) in
    Obj.repr(
# 1200 "cparser.mly"
                                   ( let d, a = _3 in
                                     PARENTYPE (_2, d, a)
                                   )
# 5073 "cparser.ml"
               : Cabs.decl_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    Obj.repr(
# 1205 "cparser.mly"
                                   ( JUSTBASE )
# 5080 "cparser.ml"
               : Cabs.decl_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.decl_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'comma_expression_opt) in
    Obj.repr(
# 1208 "cparser.mly"
                                   ( ARRAY(_1, [], _3) )
# 5088 "cparser.ml"
               : Cabs.decl_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.decl_type) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'parameter_list_startscope) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'rest_par_list) in
    Obj.repr(
# 1211 "cparser.mly"
                                   ( let (params, isva) = _3 in
                                     !Lexerhack.pop_context ();
                                     PROTO (_1, params, isva)
                                   )
# 5100 "cparser.ml"
               : Cabs.decl_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.decl_type) in
    Obj.repr(
# 1217 "cparser.mly"
                                    ( _1 )
# 5107 "cparser.ml"
               : Cabs.decl_type))
; (fun __caml_parser_env ->
    Obj.repr(
# 1218 "cparser.mly"
                                    ( JUSTBASE )
# 5113 "cparser.ml"
               : Cabs.decl_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : cabsloc * spec_elem list * name) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.block * cabsloc * cabsloc) in
    Obj.repr(
# 1222 "cparser.mly"
          ( let (loc, specs, decl) = _1 in
            currentFunctionName := "<__FUNCTION__ used outside any functions>";
            !Lexerhack.pop_context (); (* The context pushed by 
                                    * announceFunctionName *)
            doFunctionDef ((*handleLoc*) loc) (trd3 _2) specs decl (fst3 _2)
          )
# 5126 "cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : spec_elem list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.name) in
    Obj.repr(
# 1232 "cparser.mly"
                            ( announceFunctionName _2;
                              (snd _1, fst _1, _2)
                            )
# 5136 "cparser.ml"
               : cabsloc * spec_elem list * name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : spec_elem list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.name) in
    Obj.repr(
# 1238 "cparser.mly"
                            ( announceFunctionName _2;
                              (snd _1, fst _1, _2)
                            )
# 5146 "cparser.ml"
               : cabsloc * spec_elem list * name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : string * Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'parameter_list_startscope) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'rest_par_list) in
    Obj.repr(
# 1243 "cparser.mly"
                           ( let (params, isva) = _3 in
                             let fdec = 
                               (fst _1, PROTO(JUSTBASE, params, isva), [], snd _1) in
                             announceFunctionName fdec;
                             (* Default is int type *)
                             let defSpec = [SpecType Tint] in
                             (snd _1, defSpec, fdec)
                           )
# 5162 "cparser.ml"
               : cabsloc * spec_elem list * name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : string * Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : string list) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'old_pardef_list) in
    Obj.repr(
# 1254 "cparser.mly"
                           ( (* Convert pardecl to new style *)
                             let pardecl, isva = doOldParDecl _3 _5 in
                             (* Make the function declarator *)
                             let fdec = (fst _1,
                                         PROTO(JUSTBASE, pardecl,isva), 
                                         [], snd _1) in
                             announceFunctionName fdec;
                             (* Default is int type *)
                             let defSpec = [SpecType Tint] in
                             (snd _1, defSpec, fdec) 
                            )
# 5182 "cparser.ml"
               : cabsloc * spec_elem list * name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string * Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    Obj.repr(
# 1267 "cparser.mly"
                           ( (* Make the function declarator *)
                             let fdec = (fst _1,
                                         PROTO(JUSTBASE, [], false), 
                                         [], snd _1) in
                             announceFunctionName fdec;
                             (* Default is int type *)
                             let defSpec = [SpecType Tint] in
                             (snd _1, defSpec, fdec)
                            )
# 5198 "cparser.ml"
               : cabsloc * spec_elem list * name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1280 "cparser.mly"
                                        ( SpecCV(CV_CONST), _1 )
# 5205 "cparser.ml"
               : Cabs.spec_elem * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1281 "cparser.mly"
                                        ( SpecCV(CV_VOLATILE), _1 )
# 5212 "cparser.ml"
               : Cabs.spec_elem * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1282 "cparser.mly"
                                        ( SpecCV(CV_RESTRICT), _1 )
# 5219 "cparser.ml"
               : Cabs.spec_elem * cabsloc))
; (fun __caml_parser_env ->
    Obj.repr(
# 1287 "cparser.mly"
                   ( [])
# 5225 "cparser.ml"
               : Cabs.attribute list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'attribute) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.attribute list) in
    Obj.repr(
# 1288 "cparser.mly"
                                 ( fst _1 :: _2 )
# 5233 "cparser.ml"
               : Cabs.attribute list))
; (fun __caml_parser_env ->
    Obj.repr(
# 1294 "cparser.mly"
                                        ( [] )
# 5239 "cparser.ml"
               : Cabs.attribute list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'attribute) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.attribute list) in
    Obj.repr(
# 1295 "cparser.mly"
                                        ( fst _1 :: _2 )
# 5247 "cparser.ml"
               : Cabs.attribute list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : string * cabsloc) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Cabs.attribute list) in
    Obj.repr(
# 1297 "cparser.mly"
                                        ( ("__asm__", 
					   [CONSTANT(CONST_STRING (fst _3))]) :: _5 )
# 5258 "cparser.ml"
               : Cabs.attribute list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'paren_attr_list) in
    Obj.repr(
# 1304 "cparser.mly"
                                        ( ("__attribute__", _3), _1 )
# 5267 "cparser.ml"
               : 'attribute_nocv))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'paren_attr_list_ne) in
    Obj.repr(
# 1309 "cparser.mly"
                                        ( ("__declspec", _2), _1 )
# 5275 "cparser.ml"
               : 'attribute_nocv))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1310 "cparser.mly"
                                        ( (fst _1, []), snd _1 )
# 5282 "cparser.ml"
               : 'attribute_nocv))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1312 "cparser.mly"
                                        ( ("__thread",[]), _1 )
# 5289 "cparser.ml"
               : 'attribute_nocv))
; (fun __caml_parser_env ->
    Obj.repr(
# 1316 "cparser.mly"
                   ( [])
# 5295 "cparser.ml"
               : 'attribute_nocv_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'attribute_nocv) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'attribute_nocv_list) in
    Obj.repr(
# 1317 "cparser.mly"
                                        ( fst _1 :: _2 )
# 5303 "cparser.ml"
               : 'attribute_nocv_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'attribute_nocv) in
    Obj.repr(
# 1322 "cparser.mly"
                                        ( _1 )
# 5310 "cparser.ml"
               : 'attribute))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1323 "cparser.mly"
                                        ( ("const", []), _1 )
# 5317 "cparser.ml"
               : 'attribute))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1324 "cparser.mly"
                                        ( ("restrict",[]), _1 )
# 5324 "cparser.ml"
               : 'attribute))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1325 "cparser.mly"
                                        ( ("volatile",[]), _1 )
# 5331 "cparser.ml"
               : 'attribute))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'paren_attr_list) in
    Obj.repr(
# 1333 "cparser.mly"
                                        ( ("__attribute__", _3) )
# 5340 "cparser.ml"
               : 'just_attribute))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'paren_attr_list_ne) in
    Obj.repr(
# 1334 "cparser.mly"
                                        ( ("__declspec", _2) )
# 5348 "cparser.ml"
               : 'just_attribute))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'just_attribute) in
    Obj.repr(
# 1340 "cparser.mly"
                                        ( [_1] )
# 5355 "cparser.ml"
               : 'just_attributes))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'just_attribute) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'just_attributes) in
    Obj.repr(
# 1341 "cparser.mly"
                                        ( _1 :: _2 )
# 5363 "cparser.ml"
               : 'just_attributes))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'attr) in
    Obj.repr(
# 1346 "cparser.mly"
                          ( PRAGMA (_2, _1) )
# 5371 "cparser.ml"
               : 'pragma))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    Obj.repr(
# 1347 "cparser.mly"
                                   ( PRAGMA (_2, _1) )
# 5380 "cparser.ml"
               : 'pragma))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1348 "cparser.mly"
                                        ( PRAGMA (VARIABLE (fst _1), 
                                                  snd _1) )
# 5388 "cparser.ml"
               : 'pragma))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1355 "cparser.mly"
             ( VARIABLE (fst _1) )
# 5395 "cparser.ml"
               : 'primary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1357 "cparser.mly"
                  ( VARIABLE (fst _1) )
# 5402 "cparser.ml"
               : 'primary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'attr) in
    Obj.repr(
# 1358 "cparser.mly"
                                        ( _2 )
# 5410 "cparser.ml"
               : 'primary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : string * Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1359 "cparser.mly"
                                         ( CALL(VARIABLE (fst _1), [VARIABLE (fst _2)]) )
# 5418 "cparser.ml"
               : 'primary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1360 "cparser.mly"
                                         ( CONSTANT(CONST_INT (fst _1)) )
# 5425 "cparser.ml"
               : 'primary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * cabsloc) in
    Obj.repr(
# 1361 "cparser.mly"
                                         ( CONSTANT(CONST_STRING (fst _1)) )
# 5432 "cparser.ml"
               : 'primary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1365 "cparser.mly"
                                         ( VARIABLE "aconst" )
# 5439 "cparser.ml"
               : 'primary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string * Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1367 "cparser.mly"
                                         ( VARIABLE (fst _1 ^ ":" ^ fst _3) )
# 5447 "cparser.ml"
               : 'primary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string * Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1371 "cparser.mly"
                                         ( VARIABLE (fst _1 ^ ":" ^ fst _3) )
# 5455 "cparser.ml"
               : 'primary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1373 "cparser.mly"
                                         ( VARIABLE ("default:" ^ fst _3) )
# 5463 "cparser.ml"
               : 'primary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1378 "cparser.mly"
                                         ( VARIABLE ("__noreturn__") )
# 5470 "cparser.ml"
               : 'primary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'primary_attr) in
    Obj.repr(
# 1382 "cparser.mly"
                                         ( _1 )
# 5477 "cparser.ml"
               : 'postfix_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string * Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    Obj.repr(
# 1385 "cparser.mly"
                                     ( CALL(VARIABLE (fst _1), [VARIABLE ""]) )
# 5485 "cparser.ml"
               : 'postfix_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : string * Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'paren_attr_list_ne) in
    Obj.repr(
# 1386 "cparser.mly"
                                     ( CALL(VARIABLE (fst _1), _2) )
# 5493 "cparser.ml"
               : 'postfix_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'postfix_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'id_or_typename) in
    Obj.repr(
# 1388 "cparser.mly"
                                         (MEMBEROFPTR (_1, _3))
# 5501 "cparser.ml"
               : 'postfix_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'postfix_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'id_or_typename) in
    Obj.repr(
# 1389 "cparser.mly"
                                         (MEMBEROF (_1, _3))
# 5509 "cparser.ml"
               : 'postfix_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'postfix_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'attr) in
    Obj.repr(
# 1390 "cparser.mly"
                                         (INDEX (_1, _3) )
# 5517 "cparser.ml"
               : 'postfix_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'postfix_attr) in
    Obj.repr(
# 1397 "cparser.mly"
                                         ( _1 )
# 5524 "cparser.ml"
               : 'unary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'unary_expression) in
    Obj.repr(
# 1398 "cparser.mly"
                                         (EXPR_SIZEOF (fst _2) )
# 5532 "cparser.ml"
               : 'unary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.spec_elem list * Cabs.decl_type) in
    Obj.repr(
# 1400 "cparser.mly"
                           (let b, d = _3 in TYPE_SIZEOF (b, d))
# 5541 "cparser.ml"
               : 'unary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'unary_expression) in
    Obj.repr(
# 1402 "cparser.mly"
                                         (EXPR_ALIGNOF (fst _2) )
# 5549 "cparser.ml"
               : 'unary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.spec_elem list * Cabs.decl_type) in
    Obj.repr(
# 1403 "cparser.mly"
                                         (let b, d = _3 in TYPE_ALIGNOF (b, d))
# 5558 "cparser.ml"
               : 'unary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cast_attr) in
    Obj.repr(
# 1404 "cparser.mly"
                                        (UNARY (PLUS, _2))
# 5566 "cparser.ml"
               : 'unary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cast_attr) in
    Obj.repr(
# 1405 "cparser.mly"
                                        (UNARY (MINUS, _2))
# 5574 "cparser.ml"
               : 'unary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cast_attr) in
    Obj.repr(
# 1406 "cparser.mly"
                            (UNARY (MEMOF, _2))
# 5582 "cparser.ml"
               : 'unary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cast_attr) in
    Obj.repr(
# 1408 "cparser.mly"
                                 (UNARY (ADDROF, _2))
# 5590 "cparser.ml"
               : 'unary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cast_attr) in
    Obj.repr(
# 1409 "cparser.mly"
                                 (UNARY (NOT, _2))
# 5598 "cparser.ml"
               : 'unary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cast_attr) in
    Obj.repr(
# 1410 "cparser.mly"
                                        (UNARY (BNOT, _2))
# 5606 "cparser.ml"
               : 'unary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'unary_attr) in
    Obj.repr(
# 1414 "cparser.mly"
                                         ( _1 )
# 5613 "cparser.ml"
               : 'cast_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'cast_attr) in
    Obj.repr(
# 1418 "cparser.mly"
                                        ( _1 )
# 5620 "cparser.ml"
               : 'multiplicative_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'multiplicative_attr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'cast_attr) in
    Obj.repr(
# 1419 "cparser.mly"
                                        (BINARY(MUL ,_1 , _3))
# 5629 "cparser.ml"
               : 'multiplicative_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'multiplicative_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'cast_attr) in
    Obj.repr(
# 1420 "cparser.mly"
                                          (BINARY(DIV ,_1 , _3))
# 5637 "cparser.ml"
               : 'multiplicative_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'multiplicative_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'cast_attr) in
    Obj.repr(
# 1421 "cparser.mly"
                                          (BINARY(MOD ,_1 , _3))
# 5645 "cparser.ml"
               : 'multiplicative_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'multiplicative_attr) in
    Obj.repr(
# 1426 "cparser.mly"
                                        ( _1 )
# 5652 "cparser.ml"
               : 'additive_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'additive_attr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'multiplicative_attr) in
    Obj.repr(
# 1427 "cparser.mly"
                                            (BINARY(ADD ,_1 , _3))
# 5661 "cparser.ml"
               : 'additive_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'additive_attr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'multiplicative_attr) in
    Obj.repr(
# 1428 "cparser.mly"
                                            (BINARY(SUB ,_1 , _3))
# 5670 "cparser.ml"
               : 'additive_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'additive_attr) in
    Obj.repr(
# 1432 "cparser.mly"
                                        ( _1 )
# 5677 "cparser.ml"
               : 'shift_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'shift_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'additive_attr) in
    Obj.repr(
# 1433 "cparser.mly"
                                     (BINARY(SHL ,_1 , _3))
# 5685 "cparser.ml"
               : 'shift_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'shift_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'additive_attr) in
    Obj.repr(
# 1434 "cparser.mly"
                                     (BINARY(SHR ,_1 , _3))
# 5693 "cparser.ml"
               : 'shift_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'shift_attr) in
    Obj.repr(
# 1438 "cparser.mly"
                                        ( _1 )
# 5700 "cparser.ml"
               : 'relational_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'relational_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'shift_attr) in
    Obj.repr(
# 1439 "cparser.mly"
                                   (BINARY(LT ,_1 , _3))
# 5708 "cparser.ml"
               : 'relational_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'relational_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'shift_attr) in
    Obj.repr(
# 1440 "cparser.mly"
                                   (BINARY(GT ,_1 , _3))
# 5716 "cparser.ml"
               : 'relational_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'relational_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'shift_attr) in
    Obj.repr(
# 1441 "cparser.mly"
                                      (BINARY(LE ,_1 , _3))
# 5724 "cparser.ml"
               : 'relational_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'relational_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'shift_attr) in
    Obj.repr(
# 1442 "cparser.mly"
                                      (BINARY(GE ,_1 , _3))
# 5732 "cparser.ml"
               : 'relational_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'relational_attr) in
    Obj.repr(
# 1446 "cparser.mly"
                                        ( _1 )
# 5739 "cparser.ml"
               : 'equality_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'equality_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'relational_attr) in
    Obj.repr(
# 1447 "cparser.mly"
                                            (BINARY(EQ ,_1 , _3))
# 5747 "cparser.ml"
               : 'equality_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'equality_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'relational_attr) in
    Obj.repr(
# 1448 "cparser.mly"
                                            (BINARY(NE ,_1 , _3))
# 5755 "cparser.ml"
               : 'equality_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'equality_attr) in
    Obj.repr(
# 1453 "cparser.mly"
                                        ( _1 )
# 5762 "cparser.ml"
               : 'bitwise_and_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'bitwise_and_attr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'equality_attr) in
    Obj.repr(
# 1454 "cparser.mly"
                                       (BINARY(BAND ,_1 , _3))
# 5771 "cparser.ml"
               : 'bitwise_and_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'bitwise_and_attr) in
    Obj.repr(
# 1458 "cparser.mly"
                                           ( _1 )
# 5778 "cparser.ml"
               : 'bitwise_xor_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'bitwise_xor_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'bitwise_and_attr) in
    Obj.repr(
# 1459 "cparser.mly"
                                           (BINARY(XOR ,_1 , _3))
# 5786 "cparser.ml"
               : 'bitwise_xor_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'bitwise_xor_attr) in
    Obj.repr(
# 1463 "cparser.mly"
                                          ( _1 )
# 5793 "cparser.ml"
               : 'bitwise_or_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'bitwise_or_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'bitwise_xor_attr) in
    Obj.repr(
# 1464 "cparser.mly"
                                          (BINARY(BOR ,_1 , _3))
# 5801 "cparser.ml"
               : 'bitwise_or_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'bitwise_or_attr) in
    Obj.repr(
# 1468 "cparser.mly"
                                                ( _1 )
# 5808 "cparser.ml"
               : 'logical_and_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'logical_and_attr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'bitwise_or_attr) in
    Obj.repr(
# 1469 "cparser.mly"
                                             (BINARY(AND ,_1 , _3))
# 5817 "cparser.ml"
               : 'logical_and_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'logical_and_attr) in
    Obj.repr(
# 1473 "cparser.mly"
                                               ( _1 )
# 5824 "cparser.ml"
               : 'logical_or_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'logical_or_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'logical_and_attr) in
    Obj.repr(
# 1474 "cparser.mly"
                                               (BINARY(OR ,_1 , _3))
# 5832 "cparser.ml"
               : 'logical_or_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'logical_or_attr) in
    Obj.repr(
# 1478 "cparser.mly"
                                           ( _1 )
# 5839 "cparser.ml"
               : 'conditional_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : 'logical_or_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'conditional_attr) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'conditional_attr) in
    Obj.repr(
# 1481 "cparser.mly"
                                          ( QUESTION(_1, _3, _5) )
# 5848 "cparser.ml"
               : 'conditional_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'conditional_attr) in
    Obj.repr(
# 1484 "cparser.mly"
                                          ( _1 )
# 5855 "cparser.ml"
               : 'attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'attr) in
    Obj.repr(
# 1488 "cparser.mly"
                                         ( [_1] )
# 5862 "cparser.ml"
               : 'attr_list_ne))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'attr_list_ne) in
    Obj.repr(
# 1489 "cparser.mly"
                                         ( _1 :: _3 )
# 5870 "cparser.ml"
               : 'attr_list_ne))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'attr_list_ne) in
    Obj.repr(
# 1490 "cparser.mly"
                                         ( _3 )
# 5877 "cparser.ml"
               : 'attr_list_ne))
; (fun __caml_parser_env ->
    Obj.repr(
# 1493 "cparser.mly"
                                         ( [] )
# 5883 "cparser.ml"
               : 'attr_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'attr_list_ne) in
    Obj.repr(
# 1494 "cparser.mly"
                                         ( _1 )
# 5890 "cparser.ml"
               : 'attr_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'attr_list_ne) in
    Obj.repr(
# 1497 "cparser.mly"
                                         ( _2 )
# 5898 "cparser.ml"
               : 'paren_attr_list_ne))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    Obj.repr(
# 1498 "cparser.mly"
                                         ( [] )
# 5905 "cparser.ml"
               : 'paren_attr_list_ne))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'attr_list) in
    Obj.repr(
# 1501 "cparser.mly"
                                         ( _2 )
# 5913 "cparser.ml"
               : 'paren_attr_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    Obj.repr(
# 1502 "cparser.mly"
                                         ( [] )
# 5920 "cparser.ml"
               : 'paren_attr_list))
; (fun __caml_parser_env ->
    Obj.repr(
# 1506 "cparser.mly"
                                        ( [] )
# 5926 "cparser.ml"
               : Cabs.attribute list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.attribute list) in
    Obj.repr(
# 1507 "cparser.mly"
                                        ( ("volatile", []) :: _2 )
# 5934 "cparser.ml"
               : Cabs.attribute list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.attribute list) in
    Obj.repr(
# 1508 "cparser.mly"
                                        ( ("const", []) :: _2 )
# 5942 "cparser.ml"
               : Cabs.attribute list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'one_string_constant) in
    Obj.repr(
# 1511 "cparser.mly"
                                                 ( [_1] )
# 5949 "cparser.ml"
               : 'asmtemplate))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'one_string_constant) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'asmtemplate) in
    Obj.repr(
# 1512 "cparser.mly"
                                                 ( _1 :: _2 )
# 5957 "cparser.ml"
               : 'asmtemplate))
; (fun __caml_parser_env ->
    Obj.repr(
# 1515 "cparser.mly"
                        ( None )
# 5963 "cparser.ml"
               : 'asmoutputs))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'asmoperands) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'asminputs) in
    Obj.repr(
# 1517 "cparser.mly"
                        ( let (ins, clobs) = _3 in
                          Some {aoutputs = _2; ainputs = ins; aclobbers = clobs} )
# 5972 "cparser.ml"
               : 'asmoutputs))
; (fun __caml_parser_env ->
    Obj.repr(
# 1521 "cparser.mly"
                                        ( [] )
# 5978 "cparser.ml"
               : 'asmoperands))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'asmoperandsne) in
    Obj.repr(
# 1522 "cparser.mly"
                                        ( List.rev _1 )
# 5985 "cparser.ml"
               : 'asmoperands))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'asmoperand) in
    Obj.repr(
# 1525 "cparser.mly"
                                        ( [_1] )
# 5992 "cparser.ml"
               : 'asmoperandsne))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'asmoperandsne) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'asmoperand) in
    Obj.repr(
# 1526 "cparser.mly"
                                        ( _3 :: _1 )
# 6000 "cparser.ml"
               : 'asmoperandsne))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : 'asmopname) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : string * cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression * cabsloc) in
    Obj.repr(
# 1529 "cparser.mly"
                                                           ( (_1, fst _2, fst _4) )
# 6010 "cparser.ml"
               : 'asmoperand))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : 'asmopname) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : string * cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    Obj.repr(
# 1530 "cparser.mly"
                                                           ( (_1, fst _2, NOTHING ) )
# 6019 "cparser.ml"
               : 'asmoperand))
; (fun __caml_parser_env ->
    Obj.repr(
# 1533 "cparser.mly"
                             ( ([], []) )
# 6025 "cparser.ml"
               : 'asminputs))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'asmoperands) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'asmclobber) in
    Obj.repr(
# 1535 "cparser.mly"
                        ( (_2, _3) )
# 6033 "cparser.ml"
               : 'asminputs))
; (fun __caml_parser_env ->
    Obj.repr(
# 1538 "cparser.mly"
                                        ( None )
# 6039 "cparser.ml"
               : 'asmopname))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : string * Cabs.cabsloc) in
    Obj.repr(
# 1539 "cparser.mly"
                                        ( Some (fst _2) )
# 6046 "cparser.ml"
               : 'asmopname))
; (fun __caml_parser_env ->
    Obj.repr(
# 1543 "cparser.mly"
                                        ( [] )
# 6052 "cparser.ml"
               : 'asmclobber))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'asmcloberlst_ne) in
    Obj.repr(
# 1544 "cparser.mly"
                                        ( _2 )
# 6059 "cparser.ml"
               : 'asmclobber))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'one_string_constant) in
    Obj.repr(
# 1547 "cparser.mly"
                                                 ( [_1] )
# 6066 "cparser.ml"
               : 'asmcloberlst_ne))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'one_string_constant) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'asmcloberlst_ne) in
    Obj.repr(
# 1548 "cparser.mly"
                                                 ( _1 :: _3 )
# 6074 "cparser.ml"
               : 'asmcloberlst_ne))
(* Entry interpret *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
(* Entry file *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
|]
let yytables =
  { Parsing.actions=yyact;
    Parsing.transl_const=yytransl_const;
    Parsing.transl_block=yytransl_block;
    Parsing.lhs=yylhs;
    Parsing.len=yylen;
    Parsing.defred=yydefred;
    Parsing.dgoto=yydgoto;
    Parsing.sindex=yysindex;
    Parsing.rindex=yyrindex;
    Parsing.gindex=yygindex;
    Parsing.tablesize=yytablesize;
    Parsing.table=yytable;
    Parsing.check=yycheck;
    Parsing.error_function=parse_error;
    Parsing.names_const=yynames_const;
    Parsing.names_block=yynames_block }
let interpret (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 1 lexfun lexbuf : Cabs.definition list)
let file (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 2 lexfun lexbuf : Cabs.definition list)
;;
# 1552 "cparser.mly"



# 6107 "cparser.ml"
