//
//  Extension_Banks.h
//  
//
//  Created by Pierre Peterlongo on 22/10/2012
//

#include <vector>
#include <stdint.h>
#include "Extension.h"
#include <iostream>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <algorithm> // for max
#include <vector>

#ifndef EXTENSION_BANK_
#define EXTENSION_BANK_

class Extension_Bank{
 public:
  vector<Extension> all_extensions;
  // The extension types could be
  // 1/ a strict sequence: any branching stops the extension
  // 2/ a consensus sequence: uses minia contiging approach
  // 3/ a strict graph: any branching is conserved in the graph
  // 4/ a consensus graph: "small" polymorphism is merged, but "large" structures are represented.
  char extension_type;
  string extension_direction;
  
 Extension_Bank(const char type):extension_type(type){};
 Extension_Bank(const string direction):extension_direction(direction){};
 Extension_Bank(){};
 ~Extension_Bank(){all_extensions.clear();};
  
 void perform_extensions(const string prefix, int limit);
 void set_extension_type(const char type);
 void get_extension_direction(const string direction);


  // returns the id of the position of the kmer in the set of kmers to be extended (maybe it was alread present, maybe its a new one).
  //  vector<Extension>::iterator maybe_add_a_new_extension(const char * kmer);
  int maybe_add_a_new_extension(const char * kmer, const string direction);
};

#endif// EXTENSION_BANK_
