C-----------------------------------------------------------------------
#include "pdf/pilot.h"
      Subroutine Ctq4RA2 (Iset)
#include "pdf/impdp.inc"
      PARAMETER (MXX = 105, MXQ = 25, MXF = 6)
      PARAMETER (MXPQX = (MXF *2 +2) * MXQ * MXX)
      PARAMETER (NxI = 90, NtI = 13, NfMxI = 5)
      COMMON / W5051IC / Al, XV(0:MXX), QL(0:MXQ), UPD(MXPQX)
      COMMON / W5051ID / Nx, Nt, NfMx
      COMMON / W5051IE / Qini, Qmax, Xmin
      DIMENSION Amass(6)
      PARAMETER (NSETS=10)
      DIMENSION 
     >  XVI(0:MXX),QLI(0:MXQ),UPDI(MXPQX),
     >  AmassI(6)
C
C-----------------------------------------------------------------------
C Parton Distribution Table : CTEQ4A2
C       PARAMETER (ISET=5)                                           
        DATA  DrI, FlI, AlI /             2.,   5.,  .1690 /
        DATA  (AmassI(I),I=1,6) /     .000,     .000,     .200,
     +                                 1.600,    5.000,  180.000 /
C        DATA  NXI,  NTI, NfMxI /    90,    13,     5 /
        DATA  QINII, QMAXI, (QLI(I), I =0, NTI) /
     +  .160000D+01, .100000D+05,
     +  .160000D+01, .203942D+01, .266851D+01, .359449D+01, .500000D+01,
     +  .802532D+01, .137613D+02, .254432D+02, .512588D+02, .113883D+03,
     +  .282862D+03, .797782D+03, .260074D+04, .100000D+05 /
        DATA  XMINI, (XVI(I), I =0, NXI) /
     +  .100000D-04,
     +  .000000D+00, .999983D-05, .124433D-04, .154836D-04, .192668D-04,
     +  .239740D-04, .298310D-04, .371184D-04, .461852D-04, .574656D-04,
     +  .714994D-04, .889575D-04, .110674D-03, .137686D-03, .171280D-03,
     +  .213055D-03, .264997D-03, .329564D-03, .409809D-03, .509508D-03,
     +  .633332D-03, .787053D-03, .977784D-03, .121428D-02, .150728D-02,
     +  .186993D-02, .231825D-02, .288037D-02, .356397D-02, .440443D-02,
     +  .543508D-02, .669508D-02, .822984D-02, .100851D-01, .123281D-01,
     +  .150167D-01, .182174D-01, .219985D-01, .264278D-01, .315720D-01,
     +  .374800D-01, .442088D-01, .517931D-01, .602576D-01, .696136D-01,
     +  .798586D-01, .909356D-01, .102935D+00, .115681D+00, .129293D+00,
     +  .143599D+00, .158606D+00, .174271D+00, .190550D+00, .207405D+00,
     +  .224796D+00, .242685D+00, .261038D+00, .279820D+00, .299001D+00,
     +  .318550D+00, .338442D+00, .358653D+00, .379067D+00, .399881D+00,
     +  .420953D+00, .442266D+00, .463806D+00, .485559D+00, .507513D+00,
     +  .529656D+00, .551978D+00, .574483D+00, .597187D+00, .619860D+00,
     +  .642828D+00, .665921D+00, .689135D+00, .712467D+00, .735911D+00,
     +  .759464D+00, .783080D+00, .806909D+00, .830741D+00, .854673D+00,
     +  .878696D+00, .902804D+00, .926992D+00, .951257D+00, .975603D+00,
     +  .100000D+01 /
C Parton Distribution Table:                                                     
        DATA (UPDI(I),I=1,52) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=53,104) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=105,156) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=157,208) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=209,260) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=261,312) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=313,364) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=365,416) /
     +  .240472D+06, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=417,468) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .103279D+06,
     +  .785852D+05, .588257D+05, .439999D+05, .328913D+05,
     +  .245652D+05, .183349D+05, .136716D+05, .101872D+05,
     +  .758300D+04, .564018D+04, .419047D+04, .311077D+04 /
        DATA (UPDI(I),I=469,520) /
     +  .230649D+04, .170859D+04, .126404D+04, .934221D+03,
     +  .689492D+03, .508317D+03, .374183D+03, .275123D+03,
     +  .201963D+03, .148067D+03, .108370D+03, .792042D+02,
     +  .577911D+02, .421217D+02, .305046D+02, .221642D+02,
     +  .160754D+02, .116478D+02, .842672D+01, .609181D+01,
     +  .440352D+01, .318085D+01, .229724D+01, .166105D+01,
     +  .120196D+01, .871802D+00, .633493D+00, .462176D+00,
     +  .338198D+00, .248575D+00, .183402D+00, .136023D+00,
     +  .101286D+00, .759004D-01, .569663D-01, .430572D-01,
     +  .325731D-01, .247616D-01, .188561D-01, .143988D-01,
     +  .110030D-01, .842071D-02, .643871D-02, .492180D-02,
     +  .375369D-02, .285909D-02, .216897D-02, .164051D-02,
     +  .123384D-02, .923191D-03, .686805D-03, .506088D-03 /
        DATA (UPDI(I),I=521,572) /
     +  .368803D-03, .265761D-03, .188611D-03, .131666D-03,
     +  .897929D-04, .595959D-04, .379724D-04, .228716D-04,
     +  .125123D-04, .576448D-05, .144873D-05, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .232070D+06, .176164D+06,
     +  .131502D+06, .980842D+05, .731115D+05, .544467D+05,
     +  .405184D+05, .301235D+05, .223782D+05, .166068D+05,
     +  .123136D+05, .911986D+04, .674833D+04, .498736D+04,
     +  .368227D+04, .271508D+04, .199977D+04, .147080D+04,
     +  .108048D+04, .792506D+03, .580556D+03, .424585D+03,
     +  .310091D+03, .226073D+03, .164572D+03, .119591D+03 /
        DATA (UPDI(I),I=573,624) /
     +  .868007D+02, .625907D+02, .452786D+02, .326946D+02,
     +  .235808D+02, .169804D+02, .122163D+02, .878761D+01,
     +  .631548D+01, .453769D+01, .326358D+01, .234888D+01,
     +  .169421D+01, .122420D+01, .887973D+00, .645988D+00,
     +  .471954D+00, .346122D+00, .255119D+00, .188788D+00,
     +  .140573D+00, .104836D+00, .787208D-01, .591644D-01,
     +  .446763D-01, .337964D-01, .256334D-01, .194568D-01,
     +  .147888D-01, .112317D-01, .852752D-02, .646066D-02,
     +  .488845D-02, .368509D-02, .277024D-02, .207178D-02,
     +  .154230D-02, .114249D-02, .839266D-03, .610814D-03,
     +  .440678D-03, .314264D-03, .221589D-03, .153855D-03,
     +  .105213D-03, .704550D-04, .460809D-04, .292215D-04,
     +  .179840D-04, .104881D-04, .572762D-05, .279523D-05 /
        DATA (UPDI(I),I=625,676) /
     +  .110547D-05, .195293D-06, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .390898D+06, .296000D+06, .220317D+06,
     +  .163850D+06, .121771D+06, .904130D+05, .670795D+05,
     +  .497175D+05, .368190D+05, .272373D+05, .201311D+05,
     +  .148615D+05, .109606D+05, .807349D+04, .594055D+04,
     +  .436516D+04, .320386D+04, .234803D+04, .171866D+04,
     +  .125598D+04, .916628D+03, .667822D+03, .485839D+03,
     +  .352805D+03, .255792D+03, .185111D+03, .133788D+03,
     +  .960522D+02, .691783D+02, .497286D+02, .357008D+02,
     +  .255875D+02, .183194D+02, .131132D+02, .937631D+01,
     +  .670223D+01, .479469D+01, .343229D+01, .246193D+01 /
        DATA (UPDI(I),I=677,728) /
     +  .176899D+01, .127574D+01, .922695D+00, .670099D+00,
     +  .488502D+00, .357859D+00, .263187D+00, .194742D+00,
     +  .144323D+00, .107674D+00, .804054D-01, .603188D-01,
     +  .453335D-01, .341562D-01, .257554D-01, .194449D-01,
     +  .146696D-01, .110629D-01, .832605D-02, .625770D-02,
     +  .468644D-02, .349997D-02, .260104D-02, .192437D-02,
     +  .141719D-02, .103537D-02, .749982D-03, .539009D-03,
     +  .383456D-03, .270208D-03, .188029D-03, .129359D-03,
     +  .876620D-04, .585090D-04, .383731D-04, .248848D-04,
     +  .157944D-04, .988499D-05, .608847D-05, .372338D-05,
     +  .226040D-05, .138598D-05, .856565D-06, .539050D-06,
     +  .339686D-06, .211140D-06, .123800D-06, .651677D-07,
     +  .279378D-07, .764683D-08, .507688D-09, .000000D+00 /
        DATA (UPDI(I),I=729,780) /
     +  .584830D+06, .441723D+06, .327794D+06, .243045D+06,
     +  .180074D+06, .133289D+06, .985795D+05, .728333D+05,
     +  .537644D+05, .396438D+05, .292041D+05, .214878D+05,
     +  .157940D+05, .115939D+05, .850124D+04, .622480D+04,
     +  .455239D+04, .332425D+04, .242422D+04, .176498D+04,
     +  .128319D+04, .931267D+03, .674819D+03, .488074D+03,
     +  .352418D+03, .253971D+03, .182770D+03, .130642D+03,
     +  .936717D+02, .670320D+02, .478994D+02, .341688D+02,
     +  .243443D+02, .173402D+02, .123357D+02, .877213D+01,
     +  .624209D+01, .444441D+01, .317028D+01, .226526D+01,
     +  .162428D+01, .116799D+01, .843232D+00, .611070D+00,
     +  .444930D+00, .325230D+00, .239159D+00, .176140D+00,
     +  .130578D+00, .968913D-01, .722183D-01, .539299D-01 /
        DATA (UPDI(I),I=781,832) /
     +  .403687D-01, .302428D-01, .226823D-01, .170001D-01,
     +  .127358D-01, .952261D-02, .710972D-02, .529004D-02,
     +  .392504D-02, .289850D-02, .213100D-02, .155987D-02,
     +  .113295D-02, .816304D-03, .583882D-03, .413792D-03,
     +  .290795D-03, .202174D-03, .139282D-03, .948409D-04,
     +  .639004D-04, .425921D-04, .282958D-04, .186173D-04,
     +  .122441D-04, .805765D-05, .534558D-05, .356908D-05,
     +  .241092D-05, .162950D-05, .109360D-05, .714635D-06,
     +  .445254D-06, .255043D-06, .128089D-06, .514140D-07,
     +  .131236D-07, .908238D-09, .000000D+00, .819256D+06,
     +  .617167D+06, .456574D+06, .337478D+06, .249252D+06,
     +  .183908D+06, .135580D+06, .998450D+05, .734612D+05,
     +  .539876D+05, .396366D+05, .290646D+05, .212893D+05 /
        DATA (UPDI(I),I=833,884) /
     +  .155733D+05, .113786D+05, .830180D+04, .604922D+04,
     +  .440099D+04, .319740D+04, .231906D+04, .167949D+04,
     +  .121410D+04, .876254D+03, .631195D+03, .453876D+03,
     +  .325705D+03, .233384D+03, .166080D+03, .118549D+03,
     +  .844495D+02, .600642D+02, .426439D+02, .302348D+02,
     +  .214299D+02, .151676D+02, .107304D+02, .759508D+01,
     +  .537877D+01, .381568D+01, .271128D+01, .193303D+01,
     +  .138203D+01, .991910D+00, .714582D+00, .517174D+00,
     +  .375757D+00, .274623D+00, .201018D+00, .148089D+00,
     +  .109198D+00, .808752D-01, .600144D-01, .446358D-01,
     +  .332268D-01, .247591D-01, .184375D-01, .137232D-01,
     +  .101953D-01, .756268D-02, .559129D-02, .412207D-02,
     +  .302507D-02, .221032D-02, .160825D-02, .116130D-02 /
        DATA (UPDI(I),I=885,936) /
     +  .832244D-03, .592371D-03, .418087D-03, .292876D-03,
     +  .203275D-03, .140050D-03, .956212D-04, .648212D-04,
     +  .436703D-04, .294674D-04, .198209D-04, .134059D-04,
     +  .912320D-05, .627301D-05, .433977D-05, .301873D-05,
     +  .208450D-05, .141275D-05, .923103D-06, .569095D-06,
     +  .319951D-06, .156362D-06, .605049D-07, .148353D-07,
     +  .104911D-08, .000000D+00, .109982D+07, .826315D+06,
     +  .609371D+06, .448988D+06, .330544D+06, .243099D+06,
     +  .178627D+06, .131111D+06, .961419D+05, .704170D+05,
     +  .515213D+05, .376487D+05, .274801D+05, .200307D+05,
     +  .145827D+05, .106008D+05, .769589D+04, .557809D+04,
     +  .403719D+04, .291691D+04, .210421D+04, .151511D+04,
     +  .108909D+04, .781301D+03, .559475D+03, .399778D+03 /
        DATA (UPDI(I),I=937,988) /
     +  .285220D+03, .202064D+03, .143587D+03, .101821D+03,
     +  .720816D+02, .509337D+02, .359368D+02, .253462D+02,
     +  .178485D+02, .125622D+02, .884473D+01, .623035D+01,
     +  .439563D+01, .310613D+01, .220204D+01, .156539D+01,
     +  .111699D+01, .800000D+00, .575555D+00, .415677D+00,
     +  .301963D+00, .219689D+00, .160847D+00, .117874D+00,
     +  .867569D-01, .639799D-01, .472863D-01, .349796D-01,
     +  .258999D-01, .191657D-01, .141748D-01, .104648D-01,
     +  .771353D-02, .566737D-02, .415213D-02, .302866D-02,
     +  .219962D-02, .159115D-02, .114246D-02, .814483D-03,
     +  .576972D-03, .405589D-03, .283230D-03, .196231D-03,
     +  .135171D-03, .924836D-04, .630058D-04, .428092D-04,
     +  .292331D-04, .199817D-04, .137737D-04, .957156D-05 /
        DATA (UPDI(I),I=989,1040) /
     +  .671452D-05, .472761D-05, .332779D-05, .231206D-05,
     +  .156527D-05, .101574D-05, .618111D-06, .341279D-06,
     +  .162822D-06, .610688D-07, .144755D-07, .104200D-08,
     +  .000000D+00, .143233D+07, .107322D+07, .788915D+06,
     +  .579403D+06, .425163D+06, .311658D+06, .228241D+06,
     +  .166966D+06, .122017D+06, .890624D+05, .649371D+05,
     +  .472858D+05, .343917D+05, .249788D+05, .181189D+05,
     +  .131231D+05, .949145D+04, .685362D+04, .494139D+04,
     +  .355639D+04, .255542D+04, .183267D+04, .131202D+04,
     +  .937364D+03, .668424D+03, .475591D+03, .337837D+03,
     +  .238273D+03, .168558D+03, .118984D+03, .838397D+02,
     +  .589621D+02, .413999D+02, .290561D+02, .203578D+02,
     +  .142550D+02, .998403D+01, .699559D+01, .490877D+01 /
        DATA (UPDI(I),I=1041,1092) /
     +  .344973D+01, .243195D+01, .171907D+01, .121961D+01,
     +  .868448D+00, .621132D+00, .445945D+00, .322021D+00,
     +  .232878D+00, .169468D+00, .123437D+00, .902949D-01,
     +  .661831D-01, .486129D-01, .357400D-01, .262985D-01,
     +  .193407D-01, .142157D-01, .104307D-01, .764096D-02,
     +  .558004D-02, .406341D-02, .294650D-02, .212748D-02,
     +  .153033D-02, .109284D-02, .775237D-03, .546703D-03,
     +  .382875D-03, .266601D-03, .184426D-03, .127035D-03,
     +  .870964D-04, .596085D-04, .408040D-04, .281437D-04,
     +  .194830D-04, .136193D-04, .959968D-05, .681709D-05,
     +  .484450D-05, .342496D-05, .237930D-05, .160216D-05,
     +  .102979D-05, .617936D-06, .335096D-06, .156245D-06,
     +  .569242D-07, .130832D-07, .957251D-09, .000000D+00 /
        DATA (UPDI(I),I=1093,1144) /
     +  .182261D+07, .136194D+07, .997898D+06, .730497D+06,
     +  .534266D+06, .390333D+06, .284898D+06, .207705D+06,
     +  .151269D+06, .110032D+06, .799453D+05, .580090D+05,
     +  .420398D+05, .304234D+05, .219874D+05, .158661D+05,
     +  .114324D+05, .822387D+04, .590654D+04, .423450D+04,
     +  .303066D+04, .216482D+04, .154351D+04, .109821D+04,
     +  .779846D+03, .552502D+03, .390770D+03, .274378D+03,
     +  .193230D+03, .135781D+03, .952311D+02, .666582D+02,
     +  .465781D+02, .325308D+02, .226782D+02, .157991D+02,
     +  .110080D+02, .767246D+01, .535481D+01, .374275D+01,
     +  .262391D+01, .184440D+01, .130109D+01, .921179D+00,
     +  .655027D+00, .467538D+00, .335630D+00, .241284D+00,
     +  .174537D+00, .126369D+00, .918826D-01, .669431D-01 /
        DATA (UPDI(I),I=1145,1196) /
     +  .488736D-01, .357151D-01, .261203D-01, .190937D-01,
     +  .139493D-01, .101740D-01, .740815D-02, .537813D-02,
     +  .389339D-02, .280715D-02, .201547D-02, .144197D-02,
     +  .102443D-02, .723311D-03, .507955D-03, .354532D-03,
     +  .246250D-03, .170148D-03, .117234D-03, .805593D-04,
     +  .553840D-04, .381731D-04, .265598D-04, .185788D-04,
     +  .131266D-04, .934451D-05, .668569D-05, .477231D-05,
     +  .337465D-05, .233626D-05, .156123D-05, .992559D-06,
     +  .586969D-06, .312618D-06, .142530D-06, .505028D-07,
     +  .112767D-07, .837987D-09, .000000D+00, .227643D+07,
     +  .169640D+07, .123890D+07, .903943D+06, .658926D+06,
     +  .479799D+06, .349014D+06, .253582D+06, .184043D+06,
     +  .133407D+06, .965877D+05, .698362D+05, .504294D+05 /
        DATA (UPDI(I),I=1197,1248) /
     +  .363625D+05, .261832D+05, .188237D+05, .135125D+05,
     +  .968332D+04, .692797D+04, .494746D+04, .352694D+04,
     +  .250924D+04, .178183D+04, .126256D+04, .892806D+03,
     +  .629837D+03, .443541D+03, .310048D+03, .217378D+03,
     +  .152060D+03, .106156D+03, .739572D+02, .514310D+02,
     +  .357461D+02, .247959D+02, .171874D+02, .119135D+02,
     +  .826034D+01, .573445D+01, .398655D+01, .277953D+01,
     +  .194299D+01, .136295D+01, .959531D+00, .678396D+00,
     +  .481432D+00, .343603D+00, .245576D+00, .176598D+00,
     +  .127108D+00, .918736D-01, .665424D-01, .482928D-01,
     +  .350820D-01, .255047D-01, .185336D-01, .134601D-01,
     +  .975989D-02, .706513D-02, .509973D-02, .367089D-02,
     +  .263217D-02, .187966D-02, .133790D-02, .945871D-03 /
        DATA (UPDI(I),I=1249,1300) /
     +  .664924D-03, .465168D-03, .323692D-03, .224363D-03,
     +  .154908D-03, .106807D-03, .735802D-04, .508152D-04,
     +  .352492D-04, .247149D-04, .174376D-04, .124211D-04,
     +  .890261D-05, .639640D-05, .457164D-05, .322496D-05,
     +  .222031D-05, .147047D-05, .923874D-06, .538245D-06,
     +  .281536D-06, .125551D-06, .433033D-07, .940789D-08,
     +  .709709D-09, .000000D+00, .755795D+05, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=1301,1352) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=1353,1404) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .333373D+05, .257325D+05, .195868D+05,
     +  .149004D+05, .113325D+05, .861336D+04, .654477D+04,
     +  .496948D+04, .377211D+04, .286105D+04, .216921D+04,
     +  .164329D+04, .124434D+04, .941387D+03, .711846D+03,
     +  .537732D+03, .405985D+03, .306177D+03, .230765D+03,
     +  .173718D+03, .130689D+03, .981920D+02, .737219D+02,
     +  .552747D+02, .414094D+02, .309825D+02, .231695D+02,
     +  .172296D+02, .128584D+02, .958258D+01, .713957D+01,
     +  .531334D+01, .395439D+01, .294360D+01, .219160D+01,
     +  .163193D+01, .121764D+01, .909421D+00, .681379D+00 /
        DATA (UPDI(I),I=1405,1456) /
     +  .511537D+00, .385856D+00, .291944D+00, .222023D+00,
     +  .169484D+00, .130139D+00, .100310D+00, .778448D-01,
     +  .605018D-01, .473712D-01, .371183D-01, .292343D-01,
     +  .230560D-01, .182407D-01, .144366D-01, .114472D-01,
     +  .906556D-02, .717924D-02, .567099D-02, .447581D-02,
     +  .351782D-02, .275816D-02, .215085D-02, .167000D-02,
     +  .129028D-02, .988912D-03, .750685D-03, .564870D-03,
     +  .420045D-03, .308807D-03, .223414D-03, .159084D-03,
     +  .110716D-03, .752304D-04, .491862D-04, .309941D-04,
     +  .181812D-04, .961151D-05, .406524D-05, .709335D-06,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=1457,1508) /
     +  .751007D+05, .578440D+05, .439194D+05, .333270D+05,
     +  .252813D+05, .191651D+05, .145233D+05, .109978D+05,
     +  .832471D+04, .629637D+04, .476006D+04, .359551D+04,
     +  .271448D+04, .204742D+04, .154340D+04, .116226D+04,
     +  .874687D+03, .657525D+03, .493931D+03, .370586D+03,
     +  .277835D+03, .208026D+03, .155627D+03, .116266D+03,
     +  .867793D+02, .646850D+02, .481864D+02, .356915D+02,
     +  .265289D+02, .196903D+02, .146085D+02, .108257D+02,
     +  .802125D+01, .594448D+01, .440531D+01, .326505D+01,
     +  .242431D+01, .180183D+01, .134315D+01, .100324D+01,
     +  .752746D+00, .566535D+00, .428486D+00, .325313D+00,
     +  .248381D+00, .190379D+00, .146886D+00, .113511D+00,
     +  .883491D-01, .688233D-01, .538801D-01, .422440D-01 /
        DATA (UPDI(I),I=1509,1560) /
     +  .332200D-01, .261369D-01, .205995D-01, .162174D-01,
     +  .127666D-01, .100266D-01, .786759D-02, .614951D-02,
     +  .479547D-02, .372059D-02, .287510D-02, .221181D-02,
     +  .168898D-02, .127870D-02, .960838D-03, .714787D-03,
     +  .526949D-03, .383624D-03, .276155D-03, .195749D-03,
     +  .136743D-03, .934852D-04, .630426D-04, .413246D-04,
     +  .264470D-04, .163596D-04, .977556D-05, .556076D-05,
     +  .299859D-05, .149281D-05, .669183D-06, .248165D-06,
     +  .620127D-07, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .126626D+06,
     +  .973160D+05, .737016D+05, .557830D+05, .422049D+05,
     +  .319096D+05, .241156D+05, .182115D+05, .137465D+05,
     +  .103677D+05, .781533D+04, .588610D+04, .443052D+04 /
        DATA (UPDI(I),I=1561,1612) /
     +  .333169D+04, .250376D+04, .187960D+04, .141003D+04,
     +  .105656D+04, .791068D+03, .591553D+03, .441987D+03,
     +  .329797D+03, .245856D+03, .183020D+03, .136105D+03,
     +  .101076D+03, .750086D+02, .553417D+02, .409713D+02,
     +  .302881D+02, .223780D+02, .165139D+02, .121828D+02,
     +  .898926D+01, .663142D+01, .489251D+01, .361541D+01,
     +  .267429D+01, .198362D+01, .147429D+01, .110050D+01,
     +  .824007D+00, .619909D+00, .468162D+00, .355498D+00,
     +  .271007D+00, .207929D+00, .159799D+00, .123669D+00,
     +  .957957D-01, .745641D-01, .581308D-01, .454482D-01,
     +  .355540D-01, .278576D-01, .218057D-01, .170658D-01,
     +  .133269D-01, .103967D-01, .808068D-02, .626568D-02,
     +  .483459D-02, .371562D-02, .284330D-02, .216001D-02 /
        DATA (UPDI(I),I=1613,1664) /
     +  .162755D-02, .121763D-02, .902464D-03, .663298D-03,
     +  .482012D-03, .346829D-03, .246302D-03, .172825D-03,
     +  .119236D-03, .815500D-04, .546812D-04, .361968D-04,
     +  .235415D-04, .151274D-04, .955847D-05, .599278D-05,
     +  .370384D-05, .226687D-05, .135820D-05, .791495D-06,
     +  .433846D-06, .215509D-06, .892032D-07, .244622D-07,
     +  .157836D-08, .000000D+00, .201809D+06, .145276D+06,
     +  .109738D+06, .828412D+05, .625097D+05, .471341D+05,
     +  .355236D+05, .267523D+05, .201361D+05, .151435D+05,
     +  .113821D+05, .854726D+04, .641430D+04, .480887D+04,
     +  .360270D+04, .269616D+04, .201615D+04, .150587D+04,
     +  .112378D+04, .837566D+03, .623677D+03, .463774D+03,
     +  .344520D+03, .255559D+03, .189359D+03, .140107D+03 /
        DATA (UPDI(I),I=1665,1716) /
     +  .103581D+03, .761262D+02, .561371D+02, .413350D+02,
     +  .304147D+02, .223518D+02, .164191D+02, .120629D+02,
     +  .885903D+01, .650656D+01, .478567D+01, .352333D+01,
     +  .260070D+01, .192353D+01, .142862D+01, .106432D+01,
     +  .796556D+00, .598471D+00, .452036D+00, .342783D+00,
     +  .261577D+00, .199952D+00, .153890D+00, .118555D+00,
     +  .917641D-01, .711476D-01, .553128D-01, .430314D-01,
     +  .335252D-01, .260956D-01, .203077D-01, .157706D-01,
     +  .122334D-01, .945564D-02, .729073D-02, .559481D-02,
     +  .427630D-02, .325469D-02, .245926D-02, .184357D-02,
     +  .137245D-02, .101259D-02, .741112D-03, .536666D-03,
     +  .385068D-03, .273022D-03, .191528D-03, .132431D-03,
     +  .909800D-04, .615243D-04, .412570D-04, .273484D-04 /
        DATA (UPDI(I),I=1717,1768) /
     +  .180280D-04, .117768D-04, .768198D-05, .496580D-05,
     +  .318049D-05, .198965D-05, .120012D-05, .674183D-06,
     +  .338489D-06, .139366D-06, .374176D-07, .248550D-08,
     +  .000000D+00, .288684D+06, .220731D+06, .166179D+06,
     +  .125028D+06, .940195D+05, .706498D+05, .530592D+05,
     +  .398171D+05, .298615D+05, .223761D+05, .167558D+05,
     +  .125356D+05, .937140D+04, .699890D+04, .522281D+04,
     +  .389318D+04, .289949D+04, .215685D+04, .160287D+04,
     +  .118964D+04, .882036D+03, .653061D+03, .482979D+03,
     +  .356666D+03, .263064D+03, .193737D+03, .142547D+03,
     +  .104253D+03, .764973D+02, .560465D+02, .410265D+02,
     +  .299943D+02, .219144D+02, .160135D+02, .116944D+02,
     +  .854067D+01, .624501D+01, .457089D+01, .335347D+01 /
        DATA (UPDI(I),I=1769,1820) /
     +  .246530D+01, .181953D+01, .134711D+01, .100171D+01,
     +  .747812D+00, .561118D+00, .422731D+00, .320431D+00,
     +  .243321D+00, .185994D+00, .142326D+00, .109406D+00,
     +  .842539D-01, .650477D-01, .502597D-01, .388812D-01,
     +  .300554D-01, .232232D-01, .179085D-01, .137910D-01,
     +  .105831D-01, .809898D-02, .616863D-02, .467775D-02,
     +  .353149D-02, .264521D-02, .196499D-02, .144832D-02,
     +  .105705D-02, .764171D-03, .545696D-03, .385120D-03,
     +  .267715D-03, .183277D-03, .122958D-03, .813042D-04,
     +  .523378D-04, .329128D-04, .200657D-04, .118586D-04,
     +  .672347D-05, .365859D-05, .188321D-05, .916027D-06,
     +  .412541D-06, .173619D-06, .670387D-07, .252846D-07,
     +  .942045D-08, .282142D-08, .124076D-09, .000000D+00 /
        DATA (UPDI(I),I=1821,1872) /
     +  .413508D+06, .315244D+06, .236520D+06, .177337D+06,
     +  .132887D+06, .995037D+05, .744605D+05, .556749D+05,
     +  .416006D+05, .310569D+05, .231684D+05, .172671D+05,
     +  .128587D+05, .956583D+04, .710996D+04, .527867D+04,
     +  .391529D+04, .290049D+04, .214647D+04, .158636D+04,
     +  .117109D+04, .863295D+03, .635618D+03, .467274D+03,
     +  .343062D+03, .251475D+03, .184147D+03, .134020D+03,
     +  .978534D+02, .713361D+02, .519510D+02, .377846D+02,
     +  .274590D+02, .199575D+02, .144937D+02, .105260D+02,
     +  .765229D+01, .556849D+01, .406100D+01, .296760D+01,
     +  .217680D+01, .160170D+01, .118351D+01, .877983D+00,
     +  .654543D+00, .489949D+00, .368951D+00, .278339D+00,
     +  .211343D+00, .160652D+00, .122660D+00, .938324D-01 /
        DATA (UPDI(I),I=1873,1924) /
     +  .719504D-01, .552194D-01, .424246D-01, .325721D-01,
     +  .249947D-01, .191440D-01, .146405D-01, .111588D-01,
     +  .848076D-02, .641584D-02, .483203D-02, .362348D-02,
     +  .269580D-02, .198959D-02, .145714D-02, .105718D-02,
     +  .759976D-03, .540072D-03, .379607D-03, .263194D-03,
     +  .180001D-03, .121029D-03, .804908D-04, .524305D-04,
     +  .336245D-04, .211630D-04, .131230D-04, .799651D-05,
     +  .482412D-05, .287280D-05, .169577D-05, .983775D-06,
     +  .556763D-06, .297250D-06, .143816D-06, .573489D-07,
     +  .149090D-07, .985592D-09, .000000D+00, .568445D+06,
     +  .432074D+06, .323046D+06, .241362D+06, .180222D+06,
     +  .134463D+06, .100255D+06, .746867D+05, .555987D+05,
     +  .413512D+05, .307304D+05, .228150D+05, .169238D+05 /
        DATA (UPDI(I),I=1925,1976) /
     +  .125404D+05, .928354D+04, .686457D+04, .507069D+04,
     +  .374086D+04, .275670D+04, .202868D+04, .149114D+04,
     +  .109441D+04, .802190D+03, .587069D+03, .429033D+03,
     +  .313025D+03, .228127D+03, .165216D+03, .120038D+03,
     +  .870734D+02, .630883D+02, .456481D+02, .329980D+02,
     +  .238552D+02, .172290D+02, .124429D+02, .899432D+01,
     +  .650746D+01, .471783D+01, .342717D+01, .249866D+01,
     +  .182734D+01, .134185D+01, .989267D+00, .732832D+00,
     +  .545074D+00, .407824D+00, .305688D+00, .230591D+00,
     +  .174141D+00, .132080D+00, .100377D+00, .764568D-01,
     +  .582902D-01, .444829D-01, .339251D-01, .258580D-01,
     +  .196735D-01, .149439D-01, .113143D-01, .854112D-02,
     +  .641880D-02, .480205D-02, .357730D-02, .264392D-02 /
        DATA (UPDI(I),I=1977,2028) /
     +  .193890D-02, .141122D-02, .101788D-02, .727697D-03,
     +  .514641D-03, .360258D-03, .249079D-03, .170131D-03,
     +  .114559D-03, .765236D-04, .503060D-04, .327457D-04,
     +  .210870D-04, .134989D-04, .858409D-05, .545531D-05,
     +  .344929D-05, .216389D-05, .132947D-05, .786702D-06,
     +  .432755D-06, .211393D-06, .834578D-07, .211696D-07,
     +  .144708D-08, .000000D+00, .758556D+06, .574847D+06,
     +  .428278D+06, .318849D+06, .237225D+06, .176350D+06,
     +  .131004D+06, .972316D+05, .721100D+05, .534282D+05,
     +  .395531D+05, .292513D+05, .216129D+05, .159514D+05,
     +  .117612D+05, .866132D+04, .637153D+04, .468097D+04,
     +  .343490D+04, .251697D+04, .184201D+04, .134600D+04,
     +  .982193D+03, .715551D+03, .520526D+03, .378002D+03 /
        DATA (UPDI(I),I=2029,2080) /
     +  .274171D+03, .197593D+03, .142857D+03, .103111D+03,
     +  .743288D+02, .535047D+02, .384737D+02, .276659D+02,
     +  .198722D+02, .142726D+02, .102586D+02, .737983D+01,
     +  .531911D+01, .384128D+01, .278382D+01, .202362D+01,
     +  .147688D+01, .108213D+01, .796619D+00, .588811D+00,
     +  .437763D+00, .326049D+00, .244368D+00, .183360D+00,
     +  .138171D+00, .104329D+00, .789485D-01, .597989D-01,
     +  .453338D-01, .343482D-01, .260083D-01, .196587D-01,
     +  .148342D-01, .111581D-01, .836789D-02, .624799D-02,
     +  .464389D-02, .343729D-02, .252419D-02, .183969D-02,
     +  .133098D-02, .954597D-03, .678847D-03, .477882D-03,
     +  .333235D-03, .229786D-03, .156776D-03, .105704D-03,
     +  .708840D-04, .469659D-04, .309465D-04, .202836D-04 /
        DATA (UPDI(I),I=2081,2132) /
     +  .132835D-04, .868502D-05, .568721D-05, .370548D-05,
     +  .238452D-05, .149348D-05, .892393D-06, .491281D-06,
     +  .237625D-06, .918766D-07, .226706D-07, .158186D-08,
     +  .000000D+00, .989232D+06, .747396D+06, .554854D+06,
     +  .411606D+06, .305128D+06, .226000D+06, .167266D+06,
     +  .123683D+06, .913810D+05, .674487D+05, .497400D+05,
     +  .366417D+05, .269667D+05, .198235D+05, .145572D+05,
     +  .106767D+05, .782162D+04, .572231D+04, .418126D+04,
     +  .305076D+04, .222296D+04, .161722D+04, .117484D+04,
     +  .852029D+03, .616961D+03, .445939D+03, .321912D+03,
     +  .230869D+03, .166099D+03, .119293D+03, .855593D+02,
     +  .612735D+02, .438296D+02, .313507D+02, .223969D+02,
     +  .159977D+02, .114341D+02, .817899D+01, .586114D+01 /
        DATA (UPDI(I),I=2133,2184) /
     +  .420812D+01, .303162D+01, .219063D+01, .158910D+01,
     +  .115729D+01, .846702D+00, .621963D+00, .459530D+00,
     +  .340121D+00, .253303D+00, .188862D+00, .141409D+00,
     +  .106098D+00, .797726D-01, .600374D-01, .452208D-01,
     +  .340429D-01, .256110D-01, .192347D-01, .144206D-01,
     +  .107778D-01, .803095D-02, .595859D-02, .440078D-02,
     +  .323704D-02, .236242D-02, .171153D-02, .123114D-02,
     +  .878234D-03, .621428D-03, .435581D-03, .302671D-03,
     +  .208230D-03, .141962D-03, .958579D-04, .645300D-04,
     +  .430659D-04, .286797D-04, .190711D-04, .127068D-04,
     +  .847016D-05, .565075D-05, .374258D-05, .243560D-05,
     +  .153413D-05, .915364D-06, .499982D-06, .238131D-06,
     +  .899016D-07, .215632D-07, .153121D-08, .000000D+00 /
        DATA (UPDI(I),I=2185,2236) /
     +  .126611D+07, .953701D+06, .705487D+06, .521470D+06,
     +  .385167D+06, .284239D+06, .209590D+06, .154399D+06,
     +  .113644D+06, .835607D+05, .613838D+05, .450430D+05,
     +  .330188D+05, .241757D+05, .176815D+05, .129152D+05,
     +  .942246D+04, .686470D+04, .499478D+04, .362873D+04,
     +  .263262D+04, .190684D+04, .137907D+04, .995632D+03,
     +  .717644D+03, .516296D+03, .370939D+03, .264739D+03,
     +  .189540D+03, .135459D+03, .966653D+02, .688748D+02,
     +  .490111D+02, .348730D+02, .247794D+02, .176033D+02,
     +  .125119D+02, .889982D+01, .634132D+01, .452669D+01,
     +  .324206D+01, .232889D+01, .167931D+01, .121566D+01,
     +  .884005D+00, .645407D+00, .473926D+00, .348612D+00,
     +  .258012D+00, .191174D+00, .142244D+00, .106059D+00 /
        DATA (UPDI(I),I=2237,2288) /
     +  .792412D-01, .592633D-01, .443552D-01, .331813D-01,
     +  .248052D-01, .185128D-01, .137919D-01, .102437D-01,
     +  .758528D-02, .559333D-02, .410561D-02, .300166D-02,
     +  .217756D-02, .156856D-02, .112211D-02, .796379D-03,
     +  .560888D-03, .391604D-03, .271271D-03, .186280D-03,
     +  .126961D-03, .858855D-04, .580487D-04, .390078D-04,
     +  .262253D-04, .176509D-04, .119193D-04, .805535D-05,
     +  .543749D-05, .363302D-05, .237349D-05, .149366D-05,
     +  .885410D-06, .478016D-06, .223653D-06, .823600D-07,
     +  .192079D-07, .138634D-08, .000000D+00, .159500D+07,
     +  .119781D+07, .882906D+06, .650268D+06, .478556D+06,
     +  .351863D+06, .258494D+06, .189713D+06, .139109D+06,
     +  .101895D+06, .745630D+05, .545007D+05, .397943D+05 /
        DATA (UPDI(I),I=2289,2340) /
     +  .290206D+05, .211394D+05, .153781D+05, .111731D+05,
     +  .810620D+04, .587321D+04, .424872D+04, .306909D+04,
     +  .221325D+04, .159357D+04, .114533D+04, .821781D+03,
     +  .588473D+03, .420809D+03, .298882D+03, .212951D+03,
     +  .151445D+03, .107534D+03, .762323D+02, .539675D+02,
     +  .381998D+02, .269989D+02, .190768D+02, .134848D+02,
     +  .953867D+01, .675822D+01, .479684D+01, .341571D+01,
     +  .243935D+01, .174860D+01, .125833D+01, .909553D+00,
     +  .660066D+00, .481761D+00, .352220D+00, .259087D+00,
     +  .190794D+00, .141086D+00, .104550D+00, .776317D-01,
     +  .577019D-01, .429185D-01, .319085D-01, .237063D-01,
     +  .175841D-01, .130193D-01, .961099D-02, .707345D-02,
     +  .518469D-02, .378294D-02, .274958D-02, .198322D-02 /
        DATA (UPDI(I),I=2341,2392) /
     +  .142075D-02, .101107D-02, .714143D-03, .500813D-03,
     +  .348430D-03, .240727D-03, .165080D-03, .112536D-03,
     +  .762954D-04, .517832D-04, .350280D-04, .237520D-04,
     +  .161493D-04, .110195D-04, .751990D-05, .511213D-05,
     +  .342899D-05, .223902D-05, .140248D-05, .823618D-06,
     +  .438603D-06, .201345D-06, .722983D-07, .164058D-07,
     +  .120271D-08, .000000D+00, .198172D+07, .148378D+07,
     +  .108980D+07, .799773D+06, .586452D+06, .429619D+06,
     +  .314452D+06, .229923D+06, .167957D+06, .122558D+06,
     +  .893391D+05, .650476D+05, .473087D+05, .343639D+05,
     +  .249312D+05, .180630D+05, .130699D+05, .944308D+04,
     +  .681310D+04, .490772D+04, .352988D+04, .253447D+04,
     +  .181681D+04, .129994D+04, .928493D+03, .661826D+03 /
        DATA (UPDI(I),I=2393,2444) /
     +  .471055D+03, .332967D+03, .236099D+03, .167093D+03,
     +  .118059D+03, .832746D+02, .586525D+02, .413020D+02,
     +  .290380D+02, .204082D+02, .143477D+02, .100934D+02,
     +  .711146D+01, .501919D+01, .355367D+01, .252329D+01,
     +  .179826D+01, .128651D+01, .924435D+00, .666888D+00,
     +  .483844D+00, .351623D+00, .257091D+00, .188181D+00,
     +  .138312D+00, .101877D+00, .751874D-01, .555469D-01,
     +  .410643D-01, .303453D-01, .224086D-01, .165217D-01,
     +  .121591D-01, .892258D-02, .652788D-02, .475695D-02,
     +  .345076D-02, .249398D-02, .178894D-02, .127487D-02,
     +  .902790D-03, .634823D-03, .443450D-03, .307565D-03,
     +  .212035D-03, .145278D-03, .991073D-04, .673628D-04,
     +  .459185D-04, .312570D-04, .213575D-04, .146442D-04 /
        DATA (UPDI(I),I=2445,2496) /
     +  .100721D-04, .691869D-05, .472080D-05, .316825D-05,
     +  .206168D-05, .128231D-05, .744738D-06, .390713D-06,
     +  .175858D-06, .615718D-07, .136052D-07, .101262D-08,
     +  .000000D+00, .243205D+07, .181555D+07, .132875D+07,
     +  .971659D+06, .709925D+06, .518184D+06, .377882D+06,
     +  .275279D+06, .200337D+06, .145633D+06, .105754D+06,
     +  .767019D+05, .555671D+05, .402035D+05, .290515D+05,
     +  .209635D+05, .151068D+05, .108698D+05, .780977D+04,
     +  .560194D+04, .401200D+04, .286819D+04, .204704D+04,
     +  .145818D+04, .103684D+04, .735680D+03, .521199D+03,
     +  .366664D+03, .258759D+03, .182250D+03, .128138D+03,
     +  .899367D+02, .630255D+02, .441553D+02, .308826D+02,
     +  .215903D+02, .150974D+02, .105634D+02, .740169D+01 /
        DATA (UPDI(I),I=2497,2548) /
     +  .519505D+01, .365749D+01, .258229D+01, .182976D+01,
     +  .130151D+01, .929776D+00, .666821D+00, .480962D+00,
     +  .347465D+00, .252546D+00, .183757D+00, .134257D+00,
     +  .983038D-01, .721185D-01, .529632D-01, .389207D-01,
     +  .285908D-01, .209879D-01, .153833D-01, .112547D-01,
     +  .821106D-02, .597267D-02, .432776D-02, .312183D-02,
     +  .224398D-02, .160111D-02, .113534D-02, .800271D-03,
     +  .560417D-03, .390097D-03, .269838D-03, .185712D-03,
     +  .127193D-03, .868705D-04, .592135D-04, .405403D-04,
     +  .277593D-04, .190952D-04, .131829D-04, .912002D-05,
     +  .628995D-05, .429656D-05, .287808D-05, .186263D-05,
     +  .114847D-05, .658886D-06, .340268D-06, .150099D-06,
     +  .512502D-07, .110369D-07, .833710D-09, .000000D+00 /
        DATA (UPDI(I),I=2549,2600) /
     +  .631669D+05, .376362D+05, .292283D+05, .226989D+05,
     +  .176282D+05, .136904D+05, .106323D+05, .825744D+04,
     +  .641313D+04, .498084D+04, .386853D+04, .300471D+04,
     +  .233386D+04, .181287D+04, .140826D+04, .109403D+04,
     +  .849984D+03, .660446D+03, .513237D+03, .398902D+03,
     +  .310096D+03, .241117D+03, .187534D+03, .145909D+03,
     +  .113571D+03, .884453D+02, .689206D+02, .535570D+02,
     +  .418074D+02, .326704D+02, .255626D+02, .200312D+02,
     +  .157241D+02, .123771D+02, .975988D+01, .771737D+01,
     +  .612103D+01, .487105D+01, .388995D+01, .311737D+01,
     +  .250781D+01, .202415D+01, .163891D+01, .133059D+01,
     +  .108265D+01, .882323D+00, .720293D+00, .587419D+00,
     +  .479421D+00, .390328D+00, .317437D+00, .257507D+00 /
        DATA (UPDI(I),I=2601,2652) /
     +  .208232D+00, .167749D+00, .134544D+00, .107375D+00,
     +  .852166D-01, .672170D-01, .526647D-01, .409629D-01,
     +  .316102D-01, .241849D-01, .183332D-01, .137771D-01,
     +  .102240D-01, .749858D-02, .542988D-02, .387758D-02,
     +  .272732D-02, .188664D-02, .128145D-02, .853006D-03,
     +  .555096D-03, .352042D-03, .217936D-03, .130311D-03,
     +  .751816D-04, .416286D-04, .219755D-04, .109681D-04,
     +  .512050D-05, .220812D-05, .857790D-06, .294623D-06,
     +  .856987D-07, .198691D-07, .331692D-08, .329487D-09,
     +  .126929D-10, .482159D-13, .000000D+00, .807309D+05,
     +  .629527D+05, .484918D+05, .373484D+05, .287657D+05,
     +  .221523D+05, .170594D+05, .131355D+05, .101142D+05,
     +  .778670D+04, .599481D+04, .461465D+04, .355225D+04 /
        DATA (UPDI(I),I=2653,2704) /
     +  .273409D+04, .210440D+04, .161954D+04, .124645D+04,
     +  .959209D+03, .738216D+03, .568107D+03, .437256D+03,
     +  .336549D+03, .259092D+03, .199485D+03, .153643D+03,
     +  .118371D+03, .912525D+02, .701228D+02, .541350D+02,
     +  .418269D+02, .323576D+02, .250644D+02, .194487D+02,
     +  .151308D+02, .117930D+02, .921597D+01, .722536D+01,
     +  .568338D+01, .448736D+01, .355579D+01, .282951D+01,
     +  .225955D+01, .181086D+01, .145567D+01, .117335D+01,
     +  .947623D+00, .767099D+00, .620498D+00, .502635D+00,
     +  .406289D+00, .328224D+00, .264580D+00, .212708D+00,
     +  .170419D+00, .136002D+00, .108029D+00, .853672D-01,
     +  .670668D-01, .523605D-01, .405935D-01, .312368D-01,
     +  .238405D-01, .180347D-01, .135310D-01, .100295D-01 /
        DATA (UPDI(I),I=2705,2756) /
     +  .734958D-02, .531996D-02, .379907D-02, .267353D-02,
     +  .185092D-02, .125874D-02, .838809D-03, .546477D-03,
     +  .346370D-03, .213908D-03, .126899D-03, .719416D-04,
     +  .383555D-04, .186865D-04, .778310D-05, .216709D-05,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .121987D+06, .946656D+05,
     +  .725147D+05, .555346D+05, .425276D+05, .325590D+05,
     +  .249251D+05, .190763D+05, .145987D+05, .111691D+05,
     +  .854451D+04, .653490D+04, .499752D+04, .382078D+04,
     +  .292089D+04, .223235D+04, .170602D+04, .130344D+04,
     +  .995827D+03, .760638D+03, .581010D+03, .443729D+03,
     +  .338915D+03, .258840D+03, .197723D+03, .151053D+03 /
        DATA (UPDI(I),I=2757,2808) /
     +  .115460D+03, .879425D+02, .672916D+02, .515214D+02,
     +  .394920D+02, .303043D+02, .232918D+02, .179465D+02,
     +  .138521D+02, .107190D+02, .832144D+01, .648106D+01,
     +  .506729D+01, .397632D+01, .313409D+01, .247936D+01,
     +  .196897D+01, .156875D+01, .125377D+01, .100426D+01,
     +  .806628D+00, .647549D+00, .520854D+00, .418154D+00,
     +  .335655D+00, .268923D+00, .214966D+00, .171295D+00,
     +  .136009D+00, .107516D+00, .845810D-01, .661683D-01,
     +  .514585D-01, .397493D-01, .304872D-01, .231995D-01,
     +  .175040D-01, .131038D-01, .969544D-02, .709506D-02,
     +  .513176D-02, .366421D-02, .258070D-02, .178993D-02,
     +  .122138D-02, .818254D-03, .537462D-03, .344760D-03,
     +  .216799D-03, .132161D-03, .781936D-04, .446405D-04 /
        DATA (UPDI(I),I=2809,2860) /
     +  .244982D-04, .128043D-04, .632738D-05, .290541D-05,
     +  .120813D-05, .429887D-06, .113785D-06, .618901D-08,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .173024D+06, .133753D+06, .101998D+06,
     +  .777586D+05, .592709D+05, .451635D+05, .344085D+05,
     +  .262055D+05, .199547D+05, .151894D+05, .115601D+05,
     +  .879463D+04, .668954D+04, .508637D+04, .386672D+04,
     +  .293838D+04, .223254D+04, .169559D+04, .128760D+04,
     +  .977412D+03, .741882D+03, .562930D+03, .427126D+03,
     +  .324008D+03, .245797D+03, .186453D+03, .141496D+03,
     +  .106968D+03, .812330D+02, .617158D+02, .469344D+02,
     +  .357259D+02, .272342D+02, .208097D+02, .159265D+02,
     +  .122186D+02, .940395D+01, .726055D+01, .562754D+01 /
        DATA (UPDI(I),I=2861,2912) /
     +  .437770D+01, .342097D+01, .268345D+01, .211343D+01,
     +  .167022D+01, .132443D+01, .105279D+01, .839457D+00,
     +  .669135D+00, .534617D+00, .426424D+00, .340190D+00,
     +  .270951D+00, .215377D+00, .170706D+00, .134856D+00,
     +  .106089D+00, .830757D-01, .647070D-01, .501156D-01,
     +  .385613D-01, .294689D-01, .223489D-01, .168096D-01,
     +  .125484D-01, .926112D-02, .676221D-02, .488225D-02,
     +  .348144D-02, .245031D-02, .169958D-02, .116101D-02,
     +  .779696D-03, .514355D-03, .332206D-03, .211126D-03,
     +  .130779D-03, .792773D-04, .469344D-04, .272220D-04,
     +  .154668D-04, .868687D-05, .483795D-05, .269572D-05,
     +  .150147D-05, .831893D-06, .442924D-06, .216974D-06,
     +  .893446D-07, .244676D-07, .157839D-08, .000000D+00 /
        DATA (UPDI(I),I=2913,2964) /
     +  .189917D+06, .181341D+06, .137746D+06, .104592D+06,
     +  .794010D+05, .602523D+05, .457111D+05, .346643D+05,
     +  .262807D+05, .199157D+05, .150884D+05, .114259D+05,
     +  .865004D+04, .654544D+04, .495155D+04, .374394D+04,
     +  .283009D+04, .213823D+04, .161509D+04, .121935D+04,
     +  .920380D+03, .694406D+03, .523825D+03, .395000D+03,
     +  .297831D+03, .224516D+03, .169298D+03, .127140D+03,
     +  .959079D+02, .723669D+02, .546499D+02, .413016D+02,
     +  .312547D+02, .237043D+02, .180045D+02, .137066D+02,
     +  .104671D+02, .801796D+01, .616564D+01, .475847D+01,
     +  .368942D+01, .287157D+01, .224429D+01, .176033D+01,
     +  .138568D+01, .109362D+01, .866029D+00, .685688D+00,
     +  .544338D+00, .431481D+00, .342179D+00, .270977D+00 /
        DATA (UPDI(I),I=2965,3016) /
     +  .214217D+00, .168895D+00, .132753D+00, .103929D+00,
     +  .810067D-01, .628148D-01, .484436D-01, .371234D-01,
     +  .282607D-01, .213544D-01, .160061D-01, .119100D-01,
     +  .876345D-02, .638111D-02, .459581D-02, .327033D-02,
     +  .229799D-02, .159224D-02, .108737D-02, .730757D-03,
     +  .483078D-03, .313243D-03, .200374D-03, .125395D-03,
     +  .771945D-04, .467389D-04, .279860D-04, .166073D-04,
     +  .986788D-05, .587875D-05, .352271D-05, .210294D-05,
     +  .123175D-05, .681218D-06, .339611D-06, .139473D-06,
     +  .374217D-07, .248552D-08, .000000D+00, .334022D+06,
     +  .256336D+06, .193829D+06, .146501D+06, .110695D+06,
     +  .836005D+05, .631166D+05, .476279D+05, .359274D+05,
     +  .270872D+05, .204145D+05, .153772D+05, .115784D+05 /
        DATA (UPDI(I),I=3017,3068) /
     +  .871309D+04, .655423D+04, .492739D+04, .370284D+04,
     +  .278095D+04, .208773D+04, .156638D+04, .117478D+04,
     +  .880590D+03, .659845D+03, .494185D+03, .370016D+03,
     +  .276942D+03, .207306D+03, .154503D+03, .115654D+03,
     +  .865827D+02, .648591D+02, .486148D+02, .364788D+02,
     +  .274299D+02, .206515D+02, .155821D+02, .117918D+02,
     +  .895039D+01, .681935D+01, .521454D+01, .400584D+01,
     +  .308940D+01, .239269D+01, .186006D+01, .145141D+01,
     +  .113574D+01, .891946D+00, .700503D+00, .551775D+00,
     +  .434069D+00, .341720D+00, .268711D+00, .210983D+00,
     +  .165257D+00, .129072D+00, .100430D+00, .778163D-01,
     +  .599964D-01, .460136D-01, .350723D-01, .265602D-01,
     +  .199682D-01, .148926D-01, .110277D-01, .807483D-02 /
        DATA (UPDI(I),I=3069,3120) /
     +  .585111D-02, .419323D-02, .296861D-02, .207462D-02,
     +  .142890D-02, .969164D-03, .646010D-03, .422710D-03,
     +  .270474D-03, .169956D-03, .103737D-03, .616239D-04,
     +  .354407D-04, .196922D-04, .104922D-04, .534903D-05,
     +  .258280D-05, .117567D-05, .497612D-06, .197103D-06,
     +  .722036D-07, .260992D-07, .949753D-08, .282433D-08,
     +  .124090D-09, .000000D+00, .458269D+06, .350396D+06,
     +  .263818D+06, .198537D+06, .149351D+06, .112289D+06,
     +  .843897D+05, .633861D+05, .475891D+05, .357077D+05,
     +  .267803D+05, .200724D+05, .150373D+05, .112579D+05,
     +  .842418D+04, .629947D+04, .470819D+04, .351643D+04,
     +  .262494D+04, .195810D+04, .145992D+04, .108775D+04,
     +  .810067D+03, .602887D+03, .448506D+03, .333481D+03 /
        DATA (UPDI(I),I=3121,3172) /
     +  .247951D+03, .183508D+03, .136398D+03, .101377D+03,
     +  .753804D+02, .560750D+02, .417513D+02, .311478D+02,
     +  .232618D+02, .174082D+02, .130640D+02, .983262D+01,
     +  .742780D+01, .563134D+01, .428902D+01, .327963D+01,
     +  .251849D+01, .194148D+01, .150244D+01, .116616D+01,
     +  .908598D+00, .708045D+00, .553522D+00, .432243D+00,
     +  .337854D+00, .263834D+00, .205759D+00, .160114D+00,
     +  .124261D+00, .960915D-01, .740072D-01, .567271D-01,
     +  .432591D-01, .327910D-01, .246992D-01, .184727D-01,
     +  .137072D-01, .101003D-01, .736038D-02, .530896D-02,
     +  .378807D-02, .267083D-02, .185953D-02, .127658D-02,
     +  .863571D-03, .574644D-03, .375829D-03, .240852D-03,
     +  .151994D-03, .935831D-04, .564355D-04, .332809D-04 /
        DATA (UPDI(I),I=3173,3224) /
     +  .192450D-04, .109158D-04, .612111D-05, .340422D-05,
     +  .189087D-05, .104697D-05, .573991D-06, .300990D-06,
     +  .144398D-06, .574033D-07, .149110D-07, .985602D-09,
     +  .000000D+00, .612638D+06, .466779D+06, .349998D+06,
     +  .262293D+06, .196476D+06, .147086D+06, .110058D+06,
     +  .822997D+05, .615108D+05, .459427D+05, .342962D+05,
     +  .255843D+05, .190744D+05, .142107D+05, .105808D+05,
     +  .787213D+04, .585326D+04, .434872D+04, .322887D+04,
     +  .239548D+04, .177610D+04, .131582D+04, .974240D+03,
     +  .720787D+03, .532976D+03, .393837D+03, .290978D+03,
     +  .213943D+03, .157969D+03, .116618D+03, .861135D+02,
     +  .636072D+02, .470169D+02, .348183D+02, .258071D+02,
     +  .191651D+02, .142704D+02, .106559D+02, .798548D+01 /
        DATA (UPDI(I),I=3225,3276) /
     +  .600557D+01, .453718D+01, .344147D+01, .262156D+01,
     +  .200488D+01, .153930D+01, .118551D+01, .916657D+00,
     +  .708977D+00, .550209D+00, .426580D+00, .331101D+00,
     +  .256805D+00, .198948D+00, .153813D+00, .118616D+00,
     +  .911600D-01, .697854D-01, .531764D-01, .403175D-01,
     +  .303894D-01, .227643D-01, .169343D-01, .124995D-01,
     +  .916322D-02, .664396D-02, .476898D-02, .338693D-02,
     +  .237750D-02, .164855D-02, .112764D-02, .760519D-03,
     +  .504996D-03, .329980D-03, .211693D-03, .134078D-03,
     +  .831865D-04, .508313D-04, .306174D-04, .182731D-04,
     +  .108404D-04, .644819D-05, .385204D-05, .231013D-05,
     +  .137630D-05, .799310D-06, .435457D-06, .211808D-06,
     +  .834961D-07, .211711D-07, .144709D-08, .000000D+00 /
        DATA (UPDI(I),I=3277,3328) /
     +  .802189D+06, .609112D+06, .454887D+06, .339514D+06,
     +  .253272D+06, .188813D+06, .140682D+06, .104748D+06,
     +  .779467D+05, .579610D+05, .430732D+05, .319851D+05,
     +  .237359D+05, .176002D+05, .130417D+05, .965579D+04,
     +  .714388D+04, .528084D+04, .390082D+04, .287887D+04,
     +  .212313D+04, .156438D+04, .115186D+04, .847384D+03,
     +  .622973D+03, .457624D+03, .336071D+03, .245559D+03,
     +  .180175D+03, .132158D+03, .969484D+02, .711310D+02,
     +  .522179D+02, .384005D+02, .282592D+02, .208339D+02,
     +  .153984D+02, .114124D+02, .848763D+01, .633459D+01,
     +  .474909D+01, .357460D+01, .270210D+01, .205077D+01,
     +  .156264D+01, .119450D+01, .916837D+00, .703973D+00,
     +  .542450D+00, .417627D+00, .321937D+00, .248029D+00 /
        DATA (UPDI(I),I=3329,3380) /
     +  .190891D+00, .146639D+00, .112372D+00, .858306D-01,
     +  .653090D-01, .494713D-01, .372905D-01, .279480D-01,
     +  .208186D-01, .154023D-01, .113075D-01, .824582D-02,
     +  .594789D-02, .424798D-02, .300239D-02, .209795D-02,
     +  .144853D-02, .987079D-03, .663607D-03, .439647D-03,
     +  .286990D-03, .184283D-03, .117115D-03, .731816D-04,
     +  .452550D-04, .277628D-04, .169983D-04, .104251D-04,
     +  .644560D-05, .401002D-05, .249391D-05, .152810D-05,
     +  .901599D-06, .493228D-06, .237920D-06, .919036D-07,
     +  .226716D-07, .158186D-08, .000000D+00, .103231D+07,
     +  .781227D+06, .581126D+06, .432008D+06, .320971D+06,
     +  .238304D+06, .176821D+06, .131103D+06, .971432D+05,
     +  .719236D+05, .532150D+05, .393404D+05, .290624D+05 /
        DATA (UPDI(I),I=3381,3432) /
     +  .214510D+05, .158211D+05, .116582D+05, .858384D+04,
     +  .631426D+04, .464098D+04, .340780D+04, .250025D+04,
     +  .183260D+04, .134213D+04, .981984D+03, .717918D+03,
     +  .524372D+03, .382862D+03, .278074D+03, .202802D+03,
     +  .147841D+03, .107771D+03, .785652D+02, .572975D+02,
     +  .418555D+02, .305917D+02, .223974D+02, .164373D+02,
     +  .120954D+02, .893060D+01, .661665D+01, .492417D+01,
     +  .367915D+01, .276068D+01, .207989D+01, .157329D+01,
     +  .119397D+01, .909913D+00, .693731D+00, .530860D+00,
     +  .405912D+00, .310810D+00, .237884D+00, .181900D+00,
     +  .138847D+00, .105738D+00, .802688D-01, .607092D-01,
     +  .457153D-01, .342587D-01, .255290D-01, .189097D-01,
     +  .139130D-01, .101585D-01, .736844D-02, .528715D-02 /
        DATA (UPDI(I),I=3433,3484) /
     +  .375691D-02, .264232D-02, .183781D-02, .126346D-02,
     +  .857692D-03, .574800D-03, .379968D-03, .247812D-03,
     +  .159292D-03, .101585D-03, .639224D-04, .399751D-04,
     +  .249276D-04, .155910D-04, .980904D-05, .622871D-05,
     +  .397233D-05, .251723D-05, .155967D-05, .922071D-06,
     +  .501383D-06, .238340D-06, .899205D-07, .215639D-07,
     +  .153121D-08, .000000D+00, .130864D+07, .987102D+06,
     +  .731425D+06, .541613D+06, .400810D+06, .296386D+06,
     +  .219023D+06, .161725D+06, .119332D+06, .879783D+05,
     +  .648142D+05, .477069D+05, .350874D+05, .257821D+05,
     +  .189289D+05, .138839D+05, .101746D+05, .744880D+04,
     +  .544834D+04, .398094D+04, .290612D+04, .211923D+04,
     +  .154400D+04, .112371D+04, .817113D+03, .593541D+03 /
        DATA (UPDI(I),I=3485,3536) /
     +  .430938D+03, .311181D+03, .225627D+03, .163505D+03,
     +  .118468D+03, .858302D+02, .622011D+02, .451466D+02,
     +  .327811D+02, .238407D+02, .173780D+02, .127000D+02,
     +  .931189D+01, .685085D+01, .506250D+01, .375573D+01,
     +  .279816D+01, .209323D+01, .157222D+01, .118481D+01,
     +  .896693D+00, .678955D+00, .516043D+00, .391943D+00,
     +  .298140D+00, .226713D+00, .172254D+00, .130660D+00,
     +  .988882D-01, .746128D-01, .560936D-01, .419909D-01,
     +  .312846D-01, .231796D-01, .170727D-01, .124919D-01,
     +  .907102D-02, .654441D-02, .467116D-02, .330229D-02,
     +  .231121D-02, .160010D-02, .109536D-02, .740804D-03,
     +  .494959D-03, .326526D-03, .212824D-03, .136984D-03,
     +  .876851D-04, .555643D-04, .351223D-04, .222265D-04 /
        DATA (UPDI(I),I=3537,3588) /
     +  .141534D-04, .908317D-05, .587693D-05, .380595D-05,
     +  .243427D-05, .151246D-05, .890286D-06, .479021D-06,
     +  .223801D-06, .823732D-07, .192084D-07, .138635D-08,
     +  .000000D+00, .163699D+07, .123079D+07, .908514D+06,
     +  .670154D+06, .493999D+06, .363855D+06, .267806D+06,
     +  .196945D+06, .144724D+06, .106255D+06, .779493D+05,
     +  .571302D+05, .418361D+05, .306061D+05, .223705D+05,
     +  .163341D+05, .119153D+05, .868251D+04, .632067D+04,
     +  .459613D+04, .333882D+04, .242266D+04, .175615D+04,
     +  .127154D+04, .919762D+03, .664530D+03, .479855D+03,
     +  .344559D+03, .248418D+03, .178988D+03, .128926D+03,
     +  .928494D+02, .668778D+02, .482410D+02, .348065D+02,
     +  .251512D+02, .182136D+02, .132226D+02, .963018D+01 /
        DATA (UPDI(I),I=3589,3640) /
     +  .703715D+01, .516475D+01, .380538D+01, .281569D+01,
     +  .209192D+01, .156050D+01, .116797D+01, .877999D+00,
     +  .660341D+00, .498578D+00, .376196D+00, .284314D+00,
     +  .214824D+00, .162195D+00, .122269D+00, .919715D-01,
     +  .689759D-01, .515475D-01, .383617D-01, .284153D-01,
     +  .209337D-01, .153318D-01, .111562D-01, .805684D-02,
     +  .578165D-02, .410508D-02, .288740D-02, .201105D-02,
     +  .138596D-02, .944836D-03, .636719D-03, .424217D-03,
     +  .279369D-03, .182039D-03, .117369D-03, .754347D-04,
     +  .481421D-04, .307444D-04, .197160D-04, .127462D-04,
     +  .830711D-05, .544548D-05, .355884D-05, .228416D-05,
     +  .141628D-05, .827154D-06, .439323D-06, .201450D-06,
     +  .723075D-07, .164061D-07, .120271D-08, .000000D+00 /
        DATA (UPDI(I),I=3641,3692) /
     +  .202318D+07, .151634D+07, .111508D+07, .819406D+06,
     +  .601697D+06, .441458D+06, .323645D+06, .237062D+06,
     +  .173501D+06, .126863D+06, .926817D+05, .676431D+05,
     +  .493240D+05, .359287D+05, .261461D+05, .190063D+05,
     +  .138023D+05, .100116D+05, .725448D+04, .525035D+04,
     +  .379584D+04, .274091D+04, .197703D+04, .142428D+04,
     +  .102499D+04, .736694D+03, .529146D+03, .377877D+03,
     +  .270946D+03, .194130D+03, .139037D+03, .995515D+02,
     +  .712817D+02, .511096D+02, .366505D+02, .263191D+02,
     +  .189390D+02, .136613D+02, .988522D+01, .717628D+01,
     +  .523213D+01, .382947D+01, .281466D+01, .207724D+01,
     +  .153924D+01, .114442D+01, .854644D+00, .638561D+00,
     +  .479014D+00, .359109D+00, .269678D+00, .202490D+00 /
        DATA (UPDI(I),I=3693,3744) /
     +  .151936D+00, .113835D+00, .851093D-01, .634486D-01,
     +  .471373D-01, .348757D-01, .256846D-01, .188148D-01,
     +  .137029D-01, .991610D-02, .712239D-02, .508397D-02,
     +  .359095D-02, .251314D-02, .174205D-02, .119526D-02,
     +  .811584D-03, .545082D-03, .362239D-03, .238220D-03,
     +  .155248D-03, .100307D-03, .647531D-04, .416218D-04,
     +  .268408D-04, .174183D-04, .114037D-04, .752025D-05,
     +  .497310D-05, .326554D-05, .209513D-05, .129241D-05,
     +  .747296D-06, .391227D-06, .175931D-06, .615782D-07,
     +  .136055D-07, .101262D-08, .000000D+00, .247297D+07,
     +  .184769D+07, .135371D+07, .991041D+06, .724976D+06,
     +  .529871D+06, .386958D+06, .282326D+06, .205809D+06,
     +  .149882D+06, .109053D+06, .792637D+05, .575561D+05 /
        DATA (UPDI(I),I=3745,3796) /
     +  .417478D+05, .302505D+05, .218943D+05, .158294D+05,
     +  .114307D+05, .824511D+04, .593983D+04, .427422D+04,
     +  .307168D+04, .220492D+04, .158066D+04, .113185D+04,
     +  .809358D+03, .578335D+03, .410805D+03, .292982D+03,
     +  .208779D+03, .148700D+03, .105872D+03, .753722D+02,
     +  .537282D+02, .382995D+02, .273375D+02, .195512D+02,
     +  .140155D+02, .100778D+02, .726968D+01, .526629D+01,
     +  .382965D+01, .279658D+01, .205053D+01, .150960D+01,
     +  .111512D+01, .827422D+00, .614253D+00, .457857D+00,
     +  .341081D+00, .254542D+00, .189946D+00, .141654D+00,
     +  .105490D+00, .783989D-01, .581010D-01, .429124D-01,
     +  .315668D-01, .231152D-01, .168375D-01, .121948D-01,
     +  .877668D-02, .627006D-02, .445209D-02, .312853D-02 /
        DATA (UPDI(I),I=3797,3848) /
     +  .217877D-02, .150326D-02, .102701D-02, .694701D-03,
     +  .465129D-03, .308418D-03, .202620D-03, .132123D-03,
     +  .855824D-04, .555071D-04, .359337D-04, .233858D-04,
     +  .153359D-04, .101445D-04, .674862D-05, .448708D-05,
     +  .295080D-05, .188737D-05, .115586D-05, .660733D-06,
     +  .340634D-06, .150151D-06, .512547D-07, .110371D-07,
     +  .833712D-09, .000000D+00, .506631D+05, .752999D+05,
     +  .584793D+05, .454166D+05, .352721D+05, .273939D+05,
     +  .212757D+05, .165242D+05, .128342D+05, .996850D+04,
     +  .774292D+04, .601447D+04, .467209D+04, .362954D+04,
     +  .281984D+04, .219096D+04, .170252D+04, .132313D+04,
     +  .102846D+04, .799558D+03, .621749D+03, .483618D+03,
     +  .376304D+03, .292923D+03, .228132D+03, .177780D+03 /
        DATA (UPDI(I),I=3849,3900) /
     +  .138643D+03, .107837D+03, .842710D+02, .659382D+02,
     +  .516714D+02, .405639D+02, .319112D+02, .251838D+02,
     +  .199203D+02, .158102D+02, .125957D+02, .100767D+02,
     +  .809755D+01, .653706D+01, .530368D+01, .432275D+01,
     +  .353884D+01, .290870D+01, .239901D+01, .198412D+01,
     +  .164544D+01, .136458D+01, .113330D+01, .939645D+00,
     +  .778547D+00, .643675D+00, .530614D+00, .435815D+00,
     +  .356395D+00, .289984D+00, .234612D+00, .188620D+00,
     +  .150597D+00, .119335D+00, .937913D-01, .730651D-01,
     +  .563765D-01, .431063D-01, .325408D-01, .242699D-01,
     +  .178656D-01, .129653D-01, .926438D-02, .650860D-02,
     +  .448834D-02, .303243D-02, .200233D-02, .128818D-02,
     +  .808636D-03, .490197D-03, .286649D-03, .160829D-03 /
        DATA (UPDI(I),I=3901,3952) /
     +  .860074D-04, .434756D-04, .205514D-04, .897138D-05,
     +  .352738D-05, .122591D-05, .360746D-06, .845968D-07,
     +  .142814D-07, .143435D-08, .558570D-10, .214453D-12,
     +  .000000D+00, .128158D+06, .100200D+06, .774196D+05,
     +  .598152D+05, .462146D+05, .357045D+05, .275851D+05,
     +  .213110D+05, .164643D+05, .127193D+05, .982637D+04,
     +  .759116D+04, .586463D+04, .453069D+04, .350036D+04,
     +  .270434D+04, .208954D+04, .161456D+04, .124772D+04,
     +  .964319D+03, .745446D+03, .576353D+03, .445755D+03,
     +  .344855D+03, .266918D+03, .206697D+03, .160182D+03,
     +  .123782D+03, .961074D+02, .747054D+02, .581560D+02,
     +  .453485D+02, .354349D+02, .277739D+02, .218188D+02,
     +  .171969D+02, .136058D+02, .108086D+02, .862529D+01 /
        DATA (UPDI(I),I=3953,4004) /
     +  .691429D+01, .557089D+01, .450905D+01, .366608D+01,
     +  .299274D+01, .245183D+01, .201436D+01, .165975D+01,
     +  .136760D+01, .112878D+01, .930143D+00, .766084D+00,
     +  .629667D+00, .516116D+00, .421550D+00, .342865D+00,
     +  .277499D+00, .223350D+00, .178658D+00, .141941D+00,
     +  .111934D+00, .875620D-01, .679024D-01, .521580D-01,
     +  .397084D-01, .298479D-01, .221682D-01, .162515D-01,
     +  .117465D-01, .836028D-02, .585036D-02, .401858D-02,
     +  .270403D-02, .177812D-02, .113842D-02, .710714D-03,
     +  .427721D-03, .247563D-03, .136695D-03, .711408D-04,
     +  .342210D-04, .146178D-04, .503962D-05, .849348D-06,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=4005,4056) /
     +  .168907D+06, .131515D+06, .101133D+06, .777611D+05,
     +  .597898D+05, .459662D+05, .353382D+05, .271643D+05,
     +  .208808D+05, .160489D+05, .123351D+05, .947956D+04,
     +  .728513D+04, .559814D+04, .430189D+04, .330553D+04,
     +  .254007D+04, .195176D+04, .149986D+04, .115259D+04,
     +  .885880D+03, .680945D+03, .523558D+03, .402632D+03,
     +  .309763D+03, .238410D+03, .183628D+03, .141003D+03,
     +  .108790D+03, .840240D+02, .649901D+02, .503475D+02,
     +  .390830D+02, .304304D+02, .237466D+02, .185905D+02,
     +  .146095D+02, .115273D+02, .913670D+01, .727462D+01,
     +  .582187D+01, .468061D+01, .378033D+01, .306569D+01,
     +  .249536D+01, .203698D+01, .166790D+01, .136577D+01,
     +  .112048D+01, .917806D+00, .751538D+00, .614195D+00 /
        DATA (UPDI(I),I=4057,4108) /
     +  .500637D+00, .406682D+00, .329016D+00, .264905D+00,
     +  .212127D+00, .168833D+00, .133482D+00, .104760D+00,
     +  .815676D-01, .629673D-01, .481514D-01, .365003D-01,
     +  .273206D-01, .202080D-01, .147559D-01, .106253D-01,
     +  .753569D-02, .525630D-02, .360039D-02, .241718D-02,
     +  .158733D-02, .101596D-02, .635280D-03, .383981D-03,
     +  .224247D-03, .125873D-03, .675168D-04, .343260D-04,
     +  .163807D-04, .724007D-05, .288806D-05, .100502D-05,
     +  .280110D-06, .445152D-07, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .219455D+06,
     +  .170218D+06, .130318D+06, .997534D+05, .763531D+05,
     +  .584310D+05, .447130D+05, .342092D+05, .261714D+05,
     +  .200183D+05, .153111D+05, .117086D+05, .895328D+04 /
        DATA (UPDI(I),I=4109,4160) /
     +  .684518D+04, .523330D+04, .400034D+04, .305787D+04,
     +  .233713D+04, .178635D+04, .136525D+04, .104355D+04,
     +  .797647D+03, .609817D+03, .466274D+03, .356642D+03,
     +  .272872D+03, .208925D+03, .159448D+03, .122272D+03,
     +  .938530D+02, .721403D+02, .555340D+02, .428347D+02,
     +  .331376D+02, .256921D+02, .199825D+02, .156009D+02,
     +  .122287D+02, .962918D+01, .761643D+01, .605574D+01,
     +  .483704D+01, .388157D+01, .312773D+01, .252988D+01,
     +  .205233D+01, .167027D+01, .135946D+01, .110878D+01,
     +  .902951D+00, .735192D+00, .597500D+00, .484384D+00,
     +  .391386D+00, .314991D+00, .252316D+00, .201032D+00,
     +  .159215D+00, .125271D+00, .978504D-01, .758347D-01,
     +  .582769D-01, .443656D-01, .334847D-01, .249562D-01 /
        DATA (UPDI(I),I=4161,4212) /
     +  .183821D-01, .133683D-01, .958856D-02, .677523D-02,
     +  .470950D-02, .321577D-02, .215321D-02, .141125D-02,
     +  .902323D-03, .564498D-03, .342124D-03, .201073D-03,
     +  .114228D-03, .626095D-04, .330422D-04, .168319D-04,
     +  .832123D-05, .403350D-05, .195517D-05, .961735D-06,
     +  .472528D-06, .221819D-06, .898188D-07, .244859D-07,
     +  .157847D-08, .000000D+00, .177906D+06, .217433D+06,
     +  .165776D+06, .126362D+06, .963087D+05, .733843D+05,
     +  .559103D+05, .425863D+05, .324338D+05, .246953D+05,
     +  .188011D+05, .143100D+05, .108906D+05, .828626D+04,
     +  .630414D+04, .479504D+04, .364696D+04, .277319D+04,
     +  .210872D+04, .160320D+04, .121894D+04, .926697D+03,
     +  .704622D+03, .535784D+03, .407515D+03, .310022D+03 /
        DATA (UPDI(I),I=4213,4264) /
     +  .236009D+03, .179055D+03, .136499D+03, .104147D+03,
     +  .795695D+02, .608789D+02, .466676D+02, .358785D+02,
     +  .276428D+02, .213639D+02, .165738D+02, .129086D+02,
     +  .101000D+02, .793803D+01, .627156D+01, .497791D+01,
     +  .396969D+01, .317896D+01, .255563D+01, .206072D+01,
     +  .166719D+01, .134898D+01, .109395D+01, .885839D+00,
     +  .717272D+00, .579771D+00, .467510D+00, .375779D+00,
     +  .300881D+00, .239800D+00, .190116D+00, .149837D+00,
     +  .117330D+00, .912173D-01, .703683D-01, .538321D-01,
     +  .407989D-01, .306586D-01, .227515D-01, .166873D-01,
     +  .120857D-01, .863402D-02, .607738D-02, .420909D-02,
     +  .286446D-02, .191233D-02, .125046D-02, .798286D-03,
     +  .499282D-03, .303095D-03, .178960D-03, .102600D-03 /
        DATA (UPDI(I),I=4265,4316) /
     +  .571598D-04, .309932D-04, .164832D-04, .868520D-05,
     +  .459103D-05, .246193D-05, .133344D-05, .704166D-06,
     +  .343325D-06, .139833D-06, .374356D-07, .248558D-08,
     +  .000000D+00, .379394D+06, .291969D+06, .221502D+06,
     +  .167994D+06, .127388D+06, .965653D+05, .731860D+05,
     +  .554490D+05, .420022D+05, .318059D+05, .240799D+05,
     +  .182246D+05, .137904D+05, .104317D+05, .788956D+04,
     +  .596506D+04, .450927D+04, .340778D+04, .257503D+04,
     +  .194530D+04, .146950D+04, .110988D+04, .838298D+03,
     +  .633135D+03, .478261D+03, .361315D+03, .273124D+03,
     +  .205714D+03, .155686D+03, .117917D+03, .894209D+02,
     +  .679030D+02, .516564D+02, .394105D+02, .301293D+02,
     +  .231047D+02, .177841D+02, .137428D+02, .106683D+02 /
        DATA (UPDI(I),I=4317,4368) /
     +  .831905D+01, .652133D+01, .513604D+01, .406423D+01,
     +  .322988D+01, .257700D+01, .206249D+01, .165643D+01,
     +  .133057D+01, .107139D+01, .861503D+00, .692790D+00,
     +  .556219D+00, .445557D+00, .355813D+00, .283081D+00,
     +  .224202D+00, .176653D+00, .138383D+00, .107713D+00,
     +  .832482D-01, .638477D-01, .485645D-01, .365967D-01,
     +  .273461D-01, .201785D-01, .147164D-01, .105976D-01,
     +  .752736D-02, .526723D-02, .362578D-02, .245162D-02,
     +  .162535D-02, .105460D-02, .667171D-03, .412734D-03,
     +  .247035D-03, .143077D-03, .798080D-04, .426766D-04,
     +  .217310D-04, .104709D-04, .473547D-05, .198689D-05,
     +  .767357D-06, .272657D-06, .890570D-07, .287944D-07,
     +  .975608D-08, .283424D-08, .124138D-09, .000000D+00 /
        DATA (UPDI(I),I=4369,4420) /
     +  .503065D+06, .385576D+06, .291140D+06, .219757D+06,
     +  .165831D+06, .125090D+06, .943313D+05, .711079D+05,
     +  .535867D+05, .403665D+05, .303991D+05, .228836D+05,
     +  .172212D+05, .129547D+05, .974252D+04, .732393D+04,
     +  .550434D+04, .413526D+04, .310601D+04, .233216D+04,
     +  .175084D+04, .131408D+04, .986204D+03, .740022D+03,
     +  .555326D+03, .416733D+03, .312884D+03, .234020D+03,
     +  .175874D+03, .132266D+03, .995848D+02, .750739D+02,
     +  .566926D+02, .429338D+02, .325777D+02, .247947D+02,
     +  .189406D+02, .145256D+02, .111903D+02, .865993D+01,
     +  .673719D+01, .526612D+01, .413596D+01, .326251D+01,
     +  .258391D+01, .205298D+01, .163701D+01, .130563D+01,
     +  .104400D+01, .833695D+00, .665892D+00, .531067D+00 /
        DATA (UPDI(I),I=4421,4472) /
     +  .422620D+00, .335321D+00, .265082D+00, .208632D+00,
     +  .163370D+00, .127199D+00, .984118D-01, .756083D-01,
     +  .576485D-01, .435961D-01, .326639D-01, .242694D-01,
     +  .178073D-01, .129148D-01, .924914D-02, .653410D-02,
     +  .454810D-02, .311481D-02, .209591D-02, .138332D-02,
     +  .894060D-03, .563897D-03, .348267D-03, .208559D-03,
     +  .121277D-03, .683109D-04, .372361D-04, .196338D-04,
     +  .100557D-04, .504117D-05, .250094D-05, .124748D-05,
     +  .629447D-06, .313200D-06, .146324D-06, .575858D-07,
     +  .149180D-07, .985638D-09, .000000D+00, .656866D+06,
     +  .501514D+06, .376974D+06, .283244D+06, .212748D+06,
     +  .159724D+06, .119874D+06, .899236D+05, .674324D+05,
     +  .505424D+05, .378691D+05, .283598D+05, .212306D+05 /
        DATA (UPDI(I),I=4473,4524) /
     +  .158859D+05, .118824D+05, .888355D+04, .663926D+04,
     +  .495965D+04, .370378D+04, .276475D+04, .206327D+04,
     +  .153923D+04, .114809D+04, .856127D+03, .638385D+03,
     +  .475976D+03, .355033D+03, .263760D+03, .196891D+03,
     +  .147064D+03, .109960D+03, .823159D+02, .617209D+02,
     +  .464083D+02, .349596D+02, .264141D+02, .200299D+02,
     +  .152482D+02, .116605D+02, .895735D+01, .691738D+01,
     +  .536740D+01, .418478D+01, .327716D+01, .257690D+01,
     +  .203286D+01, .160962D+01, .127484D+01, .101241D+01,
     +  .802986D+00, .637084D+00, .504752D+00, .399073D+00,
     +  .314614D+00, .247142D+00, .193301D+00, .150433D+00,
     +  .116414D+00, .895262D-01, .683729D-01, .518254D-01,
     +  .389649D-01, .290252D-01, .214427D-01, .156437D-01 /
        DATA (UPDI(I),I=4525,4576) /
     +  .112817D-01, .803462D-02, .564504D-02, .390824D-02,
     +  .266275D-02, .178291D-02, .117141D-02, .754138D-03,
     +  .474223D-03, .292428D-03, .175245D-03, .102339D-03,
     +  .582156D-04, .323250D-04, .175879D-04, .946387D-05,
     +  .509393D-05, .276786D-05, .152499D-05, .839915D-06,
     +  .444280D-06, .213181D-06, .836247D-07, .211759D-07,
     +  .144712D-08, .000000D+00, .845857D+06, .643408D+06,
     +  .481522D+06, .360200D+06, .269338D+06, .201291D+06,
     +  .150373D+06, .112275D+06, .837932D+05, .625024D+05,
     +  .466008D+05, .347254D+05, .258647D+05, .192542D+05,
     +  .143267D+05, .106543D+05, .791986D+04, .588396D+04,
     +  .436965D+04, .324339D+04, .240660D+04, .178489D+04,
     +  .132344D+04, .980943D+03, .726982D+03, .538658D+03 /
        DATA (UPDI(I),I=4577,4628) /
     +  .399251D+03, .294684D+03, .218544D+03, .162160D+03,
     +  .120437D+03, .895482D+02, .666829D+02, .497928D+02,
     +  .372466D+02, .279437D+02, .210395D+02, .159027D+02,
     +  .120740D+02, .920872D+01, .706071D+01, .543960D+01,
     +  .421096D+01, .327441D+01, .255670D+01, .200291D+01,
     +  .157502D+01, .123891D+01, .977259D+00, .769930D+00,
     +  .606838D+00, .477665D+00, .375234D+00, .293945D+00,
     +  .229458D+00, .178358D+00, .137953D+00, .106109D+00,
     +  .811115D-01, .615785D-01, .464008D-01, .346833D-01,
     +  .256858D-01, .188668D-01, .136856D-01, .981364D-02,
     +  .694994D-02, .485607D-02, .334391D-02, .226643D-02,
     +  .151008D-02, .987699D-03, .633428D-03, .397185D-03,
     +  .244596D-03, .146732D-03, .860826D-04, .494583D-04 /
        DATA (UPDI(I),I=4629,4680) /
     +  .279494D-04, .156357D-04, .875184D-05, .495007D-05,
     +  .283656D-05, .163811D-05, .931265D-06, .499590D-06,
     +  .238896D-06, .919939D-07, .226750D-07, .158188D-08,
     +  .000000D+00, .107543D+07, .815088D+06, .607423D+06,
     +  .452432D+06, .336834D+06, .250624D+06, .186390D+06,
     +  .138535D+06, .102916D+06, .764074D+05, .566979D+05,
     +  .420460D+05, .311642D+05, .230839D+05, .170898D+05,
     +  .126440D+05, .934992D+04, .690967D+04, .510379D+04,
     +  .376762D+04, .278005D+04, .205023D+04, .151146D+04,
     +  .111378D+04, .820534D+03, .604306D+03, .445170D+03,
     +  .326507D+03, .240618D+03, .177399D+03, .130900D+03,
     +  .966893D+02, .715217D+02, .530482D+02, .394124D+02,
     +  .293663D+02, .219583D+02, .164824D+02, .124273D+02 /
        DATA (UPDI(I),I=4681,4732) /
     +  .941233D+01, .716669D+01, .548295D+01, .421516D+01,
     +  .325512D+01, .252424D+01, .196401D+01, .153404D+01,
     +  .119858D+01, .939194D+00, .735071D+00, .575601D+00,
     +  .450170D+00, .351388D+00, .273536D+00, .212198D+00,
     +  .163926D+00, .126018D+00, .963437D-01, .732058D-01,
     +  .552470D-01, .413851D-01, .307540D-01, .226435D-01,
     +  .165365D-01, .119264D-01, .850356D-02, .598837D-02,
     +  .416113D-02, .284998D-02, .192167D-02, .127414D-02,
     +  .829723D-03, .530165D-03, .331574D-03, .203992D-03,
     +  .122556D-03, .722651D-04, .419445D-04, .241061D-04,
     +  .138237D-04, .798835D-05, .468225D-05, .277315D-05,
     +  .164087D-05, .943696D-06, .505960D-06, .239034D-06,
     +  .899838D-07, .215663D-07, .153122D-08, .000000D+00 /
        DATA (UPDI(I),I=4733,4784) /
     +  .135121D+07, .102053D+07, .757389D+06, .561778D+06,
     +  .416471D+06, .308550D+06, .228471D+06, .169063D+06,
     +  .125032D+06, .924053D+05, .682529D+05, .503781D+05,
     +  .371625D+05, .273942D+05, .201814D+05, .148571D+05,
     +  .109309D+05, .803657D+04, .590520D+04, .433611D+04,
     +  .318229D+04, .233402D+04, .171109D+04, .125375D+04,
     +  .918344D+03, .672380D+03, .492376D+03, .358923D+03,
     +  .262890D+03, .192617D+03, .141235D+03, .103659D+03,
     +  .761825D+02, .561378D+02, .414330D+02, .306670D+02,
     +  .227775D+02, .169825D+02, .127180D+02, .956738D+01,
     +  .723549D+01, .549819D+01, .419835D+01, .322035D+01,
     +  .248055D+01, .191715D+01, .148756D+01, .115459D+01,
     +  .898842D+00, .698928D+00, .543792D+00, .422595D+00 /
        DATA (UPDI(I),I=4785,4836) /
     +  .327791D+00, .253579D+00, .195502D+00, .150105D+00,
     +  .114693D+00, .871588D-01, .658318D-01, .493883D-01,
     +  .367793D-01, .271723D-01, .198902D-01, .144423D-01,
     +  .103563D-01, .734216D-02, .514156D-02, .355311D-02,
     +  .242057D-02, .162380D-02, .107153D-02, .694825D-03,
     +  .442450D-03, .276092D-03, .169769D-03, .102203D-03,
     +  .606027D-04, .355434D-04, .207593D-04, .121692D-04,
     +  .721639D-05, .434081D-05, .262496D-05, .157226D-05,
     +  .906013D-06, .482307D-06, .224292D-06, .824176D-07,
     +  .192100D-07, .138636D-08, .000000D+00, .167902D+07,
     +  .126380D+07, .934149D+06, .690064D+06, .509462D+06,
     +  .375865D+06, .277134D+06, .204190D+06, .150351D+06,
     +  .110626D+06, .813443D+05, .597675D+05, .438848D+05 /
        DATA (UPDI(I),I=4837,4888) /
     +  .321977D+05, .236071D+05, .172949D+05, .126619D+05,
     +  .926272D+04, .677163D+04, .494669D+04, .361137D+04,
     +  .263462D+04, .192102D+04, .139983D+04, .101961D+04,
     +  .742277D+03, .540425D+03, .391610D+03, .285127D+03,
     +  .207653D+03, .151330D+03, .110381D+03, .806144D+02,
     +  .590284D+02, .432877D+02, .318332D+02, .234900D+02,
     +  .173994D+02, .129447D+02, .967394D+01, .726790D+01,
     +  .548643D+01, .416178D+01, .317133D+01, .242678D+01,
     +  .186334D+01, .143645D+01, .110769D+01, .856809D+00,
     +  .661985D+00, .511792D+00, .395234D+00, .304661D+00,
     +  .234232D+00, .179481D+00, .136967D+00, .104024D+00,
     +  .785792D-01, .589993D-01, .440017D-01, .325764D-01,
     +  .239275D-01, .174136D-01, .125716D-01, .896329D-02 /
        DATA (UPDI(I),I=4889,4940) /
     +  .631868D-02, .440024D-02, .302427D-02, .204945D-02,
     +  .136798D-02, .898550D-03, .580319D-03, .368380D-03,
     +  .229445D-03, .141083D-03, .851568D-04, .508059D-04,
     +  .301138D-04, .178591D-04, .106738D-04, .646272D-05,
     +  .396087D-05, .242592D-05, .146021D-05, .838566D-06,
     +  .441676D-06, .201797D-06, .723385D-07, .164073D-07,
     +  .120272D-08, .000000D+00, .206467D+07, .154893D+07,
     +  .114039D+07, .839063D+06, .616964D+06, .453316D+06,
     +  .332854D+06, .244215D+06, .179057D+06, .131178D+06,
     +  .960335D+05, .702468D+05, .513466D+05, .374999D+05,
     +  .273668D+05, .199548D+05, .145393D+05, .105844D+05,
     +  .769959D+04, .559634D+04, .406482D+04, .295007D+04,
     +  .213970D+04, .155083D+04, .112347D+04, .813350D+03 /
        DATA (UPDI(I),I=4941,4992) /
     +  .588849D+03, .424237D+03, .307099D+03, .222345D+03,
     +  .161075D+03, .116784D+03, .847709D+02, .616912D+02,
     +  .449591D+02, .328552D+02, .240910D+02, .177313D+02,
     +  .131075D+02, .973285D+01, .726524D+01, .544918D+01,
     +  .410695D+01, .310944D+01, .236416D+01, .180363D+01,
     +  .138157D+01, .105859D+01, .813661D+00, .624687D+00,
     +  .479942D+00, .368341D+00, .282184D+00, .215625D+00,
     +  .164220D+00, .124566D+00, .940402D-01, .706153D-01,
     +  .527068D-01, .390784D-01, .287631D-01, .210045D-01,
     +  .151982D-01, .109096D-01, .773410D-02, .542157D-02,
     +  .375470D-02, .256674D-02, .173042D-02, .114941D-02,
     +  .751643D-03, .483613D-03, .306138D-03, .190410D-03,
     +  .117142D-03, .709335D-04, .426007D-04, .255185D-04 /
        DATA (UPDI(I),I=4993,5044) /
     +  .153521D-04, .933109D-05, .574386D-05, .356702D-05,
     +  .220026D-05, .132462D-05, .755559D-06, .392909D-06,
     +  .176176D-06, .615998D-07, .136063D-07, .101262D-08,
     +  .000000D+00, .251394D+07, .187986D+07, .137870D+07,
     +  .101045D+07, .740048D+06, .541578D+06, .396050D+06,
     +  .289388D+06, .211294D+06, .154142D+06, .112362D+06,
     +  .818341D+05, .595528D+05, .432989D+05, .314555D+05,
     +  .228305D+05, .165568D+05, .119960D+05, .868442D+04,
     +  .628128D+04, .453964D+04, .327804D+04, .236539D+04,
     +  .170548D+04, .122896D+04, .884925D+03, .637170D+03,
     +  .456471D+03, .328577D+03, .236542D+03, .170370D+03,
     +  .122802D+03, .886117D+02, .641018D+02, .464335D+02,
     +  .337260D+02, .245776D+02, .179777D+02, .132071D+02 /
        DATA (UPDI(I),I=5045,5096) /
     +  .974568D+01, .722930D+01, .538822D+01, .403549D+01,
     +  .303614D+01, .229392D+01, .173904D+01, .132378D+01,
     +  .100794D+01, .769923D+00, .587432D+00, .448538D+00,
     +  .342131D+00, .260508D+00, .197857D+00, .149781D+00,
     +  .112935D+00, .847525D-01, .632655D-01, .469439D-01,
     +  .346028D-01, .253214D-01, .183848D-01, .132264D-01,
     +  .944037D-02, .665477D-02, .463903D-02, .319527D-02,
     +  .217277D-02, .145742D-02, .963518D-03, .627432D-03,
     +  .402292D-03, .254049D-03, .157864D-03, .972243D-04,
     +  .590948D-04, .357392D-04, .216322D-04, .131868D-04,
     +  .813104D-05, .506975D-05, .317637D-05, .196517D-05,
     +  .117942D-05, .666702D-06, .341833D-06, .150323D-06,
     +  .512697D-07, .110376D-07, .833716D-09, .000000D+00 /
        DATA (UPDI(I),I=5097,5148) /
     +  .506081D+05, .752777D+05, .584594D+05, .453988D+05,
     +  .352561D+05, .273796D+05, .212628D+05, .165127D+05,
     +  .128239D+05, .995921D+04, .773459D+04, .600700D+04,
     +  .466539D+04, .362353D+04, .281444D+04, .218611D+04,
     +  .169816D+04, .131922D+04, .102494D+04, .796397D+03,
     +  .618906D+03, .481058D+03, .373996D+03, .290842D+03,
     +  .226252D+03, .176078D+03, .137100D+03, .106437D+03,
     +  .829952D+02, .647719D+02, .506014D+02, .395782D+02,
     +  .309991D+02, .243356D+02, .191278D+02, .150661D+02,
     +  .118938D+02, .941177D+01, .746565D+01, .593516D+01,
     +  .472973D+01, .377564D+01, .301822D+01, .241482D+01,
     +  .193253D+01, .154594D+01, .123636D+01, .985606D+00,
     +  .784797D+00, .622006D+00, .491479D+00, .386578D+00 /
        DATA (UPDI(I),I=5149,5200) /
     +  .302495D+00, .235329D+00, .181900D+00, .139610D+00,
     +  .106329D+00, .803069D-01, .601077D-01, .445525D-01,
     +  .326769D-01, .236956D-01, .169722D-01, .120143D-01,
     +  .836419D-02, .573101D-02, .385869D-02, .254836D-02,
     +  .164728D-02, .103958D-02, .638568D-03, .380341D-03,
     +  .218540D-03, .120298D-03, .632966D-04, .311596D-04,
     +  .141435D-04, .572195D-05, .191399D-05, .406392D-06,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .128131D+06,
     +  .100176D+06, .773980D+05, .597959D+05, .461972D+05,
     +  .356890D+05, .275712D+05, .212985D+05, .164531D+05,
     +  .127092D+05, .981733D+04, .758305D+04, .585736D+04 /
        DATA (UPDI(I),I=5201,5252) /
     +  .452416D+04, .349450D+04, .269908D+04, .208482D+04,
     +  .161032D+04, .124391D+04, .960891D+03, .742362D+03,
     +  .573577D+03, .443254D+03, .342599D+03, .264881D+03,
     +  .204854D+03, .158512D+03, .122267D+03, .947286D+02,
     +  .734464D+02, .570025D+02, .442878D+02, .344556D+02,
     +  .268657D+02, .209730D+02, .164057D+02, .128626D+02,
     +  .101081D+02, .796315D+01, .628731D+01, .497675D+01,
     +  .394643D+01, .313432D+01, .249180D+01, .198200D+01,
     +  .157613D+01, .125347D+01, .993819D+00, .787378D+00,
     +  .621072D+00, .488587D+00, .382739D+00, .298398D+00,
     +  .231384D+00, .178354D+00, .136569D+00, .103827D+00,
     +  .783201D-01, .585904D-01, .434359D-01, .318934D-01,
     +  .231766D-01, .166551D-01, .118456D-01, .829997D-02 /
        DATA (UPDI(I),I=5253,5304) /
     +  .573444D-02, .390273D-02, .261267D-02, .171829D-02,
     +  .110790D-02, .699155D-03, .430408D-03, .257736D-03,
     +  .148948D-03, .830874D-04, .436085D-04, .210350D-04,
     +  .862630D-05, .220223D-05, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .168878D+06, .131489D+06,
     +  .101110D+06, .777402D+05, .597710D+05, .459494D+05,
     +  .353231D+05, .271508D+05, .208687D+05, .160380D+05,
     +  .123253D+05, .947081D+04, .727728D+04, .559109D+04,
     +  .429557D+04, .329985D+04, .253497D+04, .194719D+04,
     +  .149575D+04, .114889D+04, .882555D+03, .677953D+03,
     +  .520863D+03, .400202D+03, .307569D+03, .236427D+03 /
        DATA (UPDI(I),I=5305,5356) /
     +  .181832D+03, .139376D+03, .107310D+03, .826738D+02,
     +  .637549D+02, .492137D+02, .380384D+02, .294643D+02,
     +  .228496D+02, .177544D+02, .138274D+02, .107934D+02,
     +  .844656D+01, .662473D+01, .520962D+01, .410441D+01,
     +  .323922D+01, .255927D+01, .202352D+01, .159979D+01,
     +  .126527D+01, .997776D+00, .786544D+00, .617425D+00,
     +  .483537D+00, .377187D+00, .292932D+00, .226342D+00,
     +  .173917D+00, .132802D+00, .100724D+00, .758348D-01,
     +  .566545D-01, .419671D-01, .308122D-01, .224063D-01,
     +  .161270D-01, .115005D-01, .809016D-02, .561993D-02,
     +  .385307D-02, .260453D-02, .173500D-02, .113740D-02,
     +  .733661D-03, .464881D-03, .289379D-03, .176328D-03,
     +  .105966D-03, .620930D-04, .356785D-04, .199947D-04 /
        DATA (UPDI(I),I=5357,5408) /
     +  .109378D-04, .577610D-05, .293456D-05, .139717D-05,
     +  .606562D-06, .218350D-06, .510504D-07, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .219423D+06, .170190D+06, .130293D+06,
     +  .997309D+05, .763329D+05, .584129D+05, .446968D+05,
     +  .341947D+05, .261583D+05, .200066D+05, .153006D+05,
     +  .116992D+05, .894484D+04, .683761D+04, .522650D+04,
     +  .399424D+04, .305239D+04, .233222D+04, .178193D+04,
     +  .136129D+04, .103998D+04, .794437D+03, .606928D+03,
     +  .463670D+03, .354292D+03, .270748D+03, .207003D+03,
     +  .157708D+03, .120691D+03, .924126D+02, .708245D+02,
     +  .543285D+02, .417265D+02, .321151D+02, .247456D+02,
     +  .191034D+02, .147818D+02, .114635D+02, .891302D+01 /
        DATA (UPDI(I),I=5409,5460) /
     +  .694556D+01, .542724D+01, .424902D+01, .333269D+01,
     +  .261724D+01, .205725D+01, .161719D+01, .127205D+01,
     +  .997799D+00, .782624D+00, .611385D+00, .476632D+00,
     +  .370204D+00, .286359D+00, .220439D+00, .168806D+00,
     +  .128500D+00, .971936D-01, .730022D-01, .544317D-01,
     +  .402594D-01, .295293D-01, .214647D-01, .154529D-01,
     +  .110308D-01, .777434D-02, .541606D-02, .372863D-02,
     +  .253451D-02, .170095D-02, .112585D-02, .735317D-03,
     +  .473436D-03, .300814D-03, .188216D-03, .117019D-03,
     +  .716945D-04, .436798D-04, .264472D-04, .160343D-04,
     +  .971308D-05, .593236D-05, .362390D-05, .221602D-05,
     +  .133441D-05, .782879D-06, .431484D-06, .215060D-06,
     +  .891533D-07, .244600D-07, .157835D-08, .000000D+00 /
        DATA (UPDI(I),I=5461,5512) /
     +  .177839D+06, .217403D+06, .165749D+06, .126338D+06,
     +  .962870D+05, .733649D+05, .558929D+05, .425707D+05,
     +  .324198D+05, .246828D+05, .187898D+05, .142999D+05,
     +  .108816D+05, .827815D+04, .629687D+04, .478851D+04,
     +  .364110D+04, .276793D+04, .210400D+04, .159896D+04,
     +  .121512D+04, .923268D+03, .701535D+03, .533004D+03,
     +  .405007D+03, .307757D+03, .233961D+03, .177202D+03,
     +  .134817D+03, .102617D+03, .781741D+02, .596029D+02,
     +  .454971D+02, .348012D+02, .266485D+02, .204435D+02,
     +  .157194D+02, .121139D+02, .935961D+01, .724795D+01,
     +  .562852D+01, .437966D+01, .341451D+01, .266569D+01,
     +  .208331D+01, .162851D+01, .127407D+01, .994136D+00,
     +  .775864D+00, .603184D+00, .468088D+00, .361987D+00 /
        DATA (UPDI(I),I=5513,5564) /
     +  .278854D+00, .213835D+00, .163160D+00, .123789D+00,
     +  .933456D-01, .699198D-01, .520085D-01, .383884D-01,
     +  .281109D-01, .204095D-01, .146828D-01, .104794D-01,
     +  .738926D-02, .515387D-02, .355538D-02, .242407D-02,
     +  .163373D-02, .108747D-02, .715502D-03, .465049D-03,
     +  .299049D-03, .189981D-03, .120349D-03, .754908D-04,
     +  .473357D-04, .296758D-04, .187366D-04, .118865D-04,
     +  .762623D-05, .489900D-05, .313912D-05, .197063D-05,
     +  .119333D-05, .672345D-06, .338144D-06, .139328D-06,
     +  .374160D-07, .248549D-08, .000000D+00, .379357D+06,
     +  .291936D+06, .221473D+06, .167968D+06, .127364D+06,
     +  .965442D+05, .731670D+05, .554321D+05, .419869D+05,
     +  .317922D+05, .240676D+05, .182137D+05, .137806D+05 /
        DATA (UPDI(I),I=5565,5616) /
     +  .104229D+05, .788166D+04, .595798D+04, .450291D+04,
     +  .340208D+04, .256991D+04, .194070D+04, .146536D+04,
     +  .110617D+04, .834956D+03, .630127D+03, .475550D+03,
     +  .358869D+03, .270915D+03, .203718D+03, .153877D+03,
     +  .116274D+03, .879253D+02, .665386D+02, .504082D+02,
     +  .382655D+02, .290763D+02, .221341D+02, .168874D+02,
     +  .129131D+02, .989968D+01, .760705D+01, .586218D+01,
     +  .452701D+01, .350306D+01, .271485D+01, .210658D+01,
     +  .163524D+01, .127073D+01, .985025D+00, .763930D+00,
     +  .590301D+00, .455431D+00, .350249D+00, .268387D+00,
     +  .204781D+00, .155514D+00, .117465D+00, .882096D-01,
     +  .658197D-01, .487862D-01, .358954D-01, .262106D-01,
     +  .189828D-01, .136269D-01, .970833D-02, .683510D-02 /
        DATA (UPDI(I),I=5617,5668) /
     +  .476137D-02, .328100D-02, .223463D-02, .150406D-02,
     +  .999215D-03, .655304D-03, .423593D-03, .269894D-03,
     +  .168937D-03, .104558D-03, .632833D-04, .376176D-04,
     +  .218368D-04, .123817D-04, .679428D-05, .360958D-05,
     +  .182991D-05, .883976D-06, .398080D-06, .168538D-06,
     +  .656840D-07, .250336D-07, .939314D-08, .282024D-08,
     +  .124069D-09, .000000D+00, .503025D+06, .385541D+06,
     +  .291108D+06, .219728D+06, .165806D+06, .125067D+06,
     +  .943107D+05, .710895D+05, .535702D+05, .403517D+05,
     +  .303858D+05, .228717D+05, .172105D+05, .129452D+05,
     +  .973396D+04, .731625D+04, .549745D+04, .412908D+04,
     +  .310047D+04, .232719D+04, .174638D+04, .131007D+04,
     +  .982599D+03, .736780D+03, .552407D+03, .414101D+03 /
        DATA (UPDI(I),I=5669,5720) /
     +  .310510D+03, .231878D+03, .173935D+03, .130509D+03,
     +  .979888D+02, .736214D+02, .553677D+02, .417223D+02,
     +  .314677D+02, .237757D+02, .180036D+02, .136630D+02,
     +  .103957D+02, .792826D+01, .606416D+01, .464841D+01,
     +  .357074D+01, .274746D+01, .211688D+01, .163193D+01,
     +  .125967D+01, .970063D+00, .747584D+00, .574129D+00,
     +  .440340D+00, .336720D+00, .256613D+00, .194775D+00,
     +  .147177D+00, .110639D+00, .827085D-01, .614525D-01,
     +  .453672D-01, .332561D-01, .242006D-01, .174733D-01,
     +  .125086D-01, .889038D-02, .624664D-02, .434475D-02,
     +  .299086D-02, .203624D-02, .137101D-02, .912011D-03,
     +  .599581D-03, .389139D-03, .249424D-03, .157558D-03,
     +  .987884D-04, .609482D-04, .372361D-04, .224972D-04 /
        DATA (UPDI(I),I=5721,5772) /
     +  .135032D-04, .803909D-05, .478166D-05, .283058D-05,
     +  .167114D-05, .972889D-06, .553005D-06, .296264D-06,
     +  .143636D-06, .573296D-07, .149082D-07, .985587D-09,
     +  .000000D+00, .656823D+06, .501476D+06, .376939D+06,
     +  .283213D+06, .212720D+06, .159699D+06, .119851D+06,
     +  .899037D+05, .674145D+05, .505264D+05, .378547D+05,
     +  .283470D+05, .212191D+05, .158756D+05, .118731D+05,
     +  .887526D+04, .663183D+04, .495299D+04, .369781D+04,
     +  .275939D+04, .205847D+04, .153491D+04, .114421D+04,
     +  .852643D+03, .635252D+03, .473155D+03, .352490D+03,
     +  .261470D+03, .194822D+03, .145192D+03, .108264D+03,
     +  .807757D+02, .603200D+02, .451315D+02, .337941D+02,
     +  .253486D+02, .190547D+02, .143550D+02, .108422D+02 /
        DATA (UPDI(I),I=5773,5824) /
     +  .820830D+01, .623266D+01, .474308D+01, .361740D+01,
     +  .276375D+01, .211468D+01, .161914D+01, .124152D+01,
     +  .949859D+00, .727405D+00, .555196D+00, .423285D+00,
     +  .321817D+00, .243891D+00, .184127D+00, .138412D+00,
     +  .103534D+00, .770277D-01, .569717D-01, .418770D-01,
     +  .305720D-01, .221616D-01, .159437D-01, .113754D-01,
     +  .806029D-02, .564776D-02, .391884D-02, .269236D-02,
     +  .183037D-02, .123135D-02, .819079D-03, .538997D-03,
     +  .350632D-03, .225657D-03, .143517D-03, .908883D-04,
     +  .569178D-04, .355102D-04, .220883D-04, .137735D-04,
     +  .860765D-05, .541912D-05, .341599D-05, .214502D-05,
     +  .132130D-05, .783929D-06, .432040D-06, .211265D-06,
     +  .834442D-07, .211690D-07, .144708D-08, .000000D+00 /
        DATA (UPDI(I),I=5825,5876) /
     +  .845810D+06, .643366D+06, .481485D+06, .360167D+06,
     +  .269308D+06, .201264D+06, .150349D+06, .112253D+06,
     +  .837739D+05, .624852D+05, .465853D+05, .347116D+05,
     +  .258523D+05, .192430D+05, .143168D+05, .106454D+05,
     +  .791186D+04, .587680D+04, .436323D+04, .323763D+04,
     +  .240143D+04, .178026D+04, .131928D+04, .977211D+03,
     +  .723629D+03, .535642D+03, .396537D+03, .292243D+03,
     +  .216343D+03, .160173D+03, .118640D+03, .879209D+02,
     +  .652072D+02, .484523D+02, .360275D+02, .268338D+02,
     +  .200281D+02, .149810D+02, .112343D+02, .844456D+01,
     +  .636649D+01, .481070D+01, .364326D+01, .276424D+01,
     +  .210061D+01, .159757D+01, .121694D+01, .925034D+00,
     +  .703945D+00, .533984D+00, .404680D+00, .305888D+00 /
        DATA (UPDI(I),I=5877,5928) /
     +  .230511D+00, .173076D+00, .129415D+00, .963082D-01,
     +  .712977D-01, .524827D-01, .384005D-01, .279113D-01,
     +  .201482D-01, .144379D-01, .102622D-01, .724596D-02,
     +  .506052D-02, .350100D-02, .239908D-02, .162753D-02,
     +  .109317D-02, .726566D-03, .478170D-03, .311498D-03,
     +  .201090D-03, .128609D-03, .821347D-04, .520852D-04,
     +  .330566D-04, .210323D-04, .134803D-04, .869608D-05,
     +  .565680D-05, .367933D-05, .237011D-05, .148736D-05,
     +  .890352D-06, .490763D-06, .237533D-06, .918671D-07,
     +  .226702D-07, .158186D-08, .000000D+00, .107537D+07,
     +  .815042D+06, .607383D+06, .452396D+06, .336801D+06,
     +  .250595D+06, .186364D+06, .138512D+06, .102895D+06,
     +  .763888D+05, .566812D+05, .420311D+05, .311508D+05 /
        DATA (UPDI(I),I=5929,5980) /
     +  .230720D+05, .170790D+05, .126344D+05, .934133D+04,
     +  .690197D+04, .509690D+04, .376145D+04, .277452D+04,
     +  .204527D+04, .150702D+04, .110979D+04, .816956D+03,
     +  .601092D+03, .442282D+03, .323914D+03, .238284D+03,
     +  .175295D+03, .129003D+03, .949757D+02, .699723D+02,
     +  .516455D+02, .381414D+02, .282141D+02, .209132D+02,
     +  .155348D+02, .115686D+02, .863535D+01, .646513D+01,
     +  .485145D+01, .364888D+01, .274968D+01, .207551D+01,
     +  .156800D+01, .118666D+01, .896235D+00, .677767D+00,
     +  .510968D+00, .384920D+00, .289255D+00, .216738D+00,
     +  .161834D+00, .120357D+00, .890987D-01, .656252D-01,
     +  .480696D-01, .350039D-01, .253257D-01, .182010D-01,
     +  .129875D-01, .919385D-02, .646665D-02, .449988D-02 /
        DATA (UPDI(I),I=5981,6032) /
     +  .310278D-02, .211986D-02, .143446D-02, .961571D-03,
     +  .638301D-03, .419947D-03, .273836D-03, .177249D-03,
     +  .113933D-03, .733203D-04, .470193D-04, .302855D-04,
     +  .196288D-04, .128467D-04, .847329D-05, .562551D-05,
     +  .372213D-05, .242463D-05, .152956D-05, .913865D-06,
     +  .499608D-06, .238066D-06, .898949D-07, .215629D-07,
     +  .153120D-08, .000000D+00, .135116D+07, .102049D+07,
     +  .757345D+06, .561739D+06, .416436D+06, .308519D+06,
     +  .228443D+06, .169038D+06, .125009D+06, .923852D+05,
     +  .682349D+05, .503621D+05, .371481D+05, .273814D+05,
     +  .201699D+05, .148468D+05, .109217D+05, .802833D+04,
     +  .589782D+04, .432951D+04, .317638D+04, .232872D+04,
     +  .170635D+04, .124950D+04, .914536D+03, .668964D+03 /
        DATA (UPDI(I),I=6033,6084) /
     +  .489311D+03, .356176D+03, .260421D+03, .190398D+03,
     +  .139238D+03, .101860D+03, .745610D+02, .546747D+02,
     +  .401124D+02, .294748D+02, .217011D+02, .160113D+02,
     +  .118426D+02, .877988D+01, .652872D+01, .486601D+01,
     +  .363517D+01, .272105D+01, .204030D+01, .153132D+01,
     +  .115146D+01, .864118D+00, .649420D+00, .486601D+00,
     +  .364373D+00, .272215D+00, .202805D+00, .150586D+00,
     +  .111381D+00, .820158D-01, .600956D-01, .437978D-01,
     +  .317371D-01, .228533D-01, .163488D-01, .116144D-01,
     +  .818685D-02, .573499D-02, .397537D-02, .273136D-02,
     +  .186010D-02, .125521D-02, .839556D-03, .556507D-03,
     +  .365963D-03, .238840D-03, .154998D-03, .100116D-03,
     +  .648999D-04, .420528D-04, .274437D-04, .180646D-04 /
        DATA (UPDI(I),I=6085,6136) /
     +  .120179D-04, .805368D-05, .541675D-05, .361709D-05,
     +  .236517D-05, .149026D-05, .884313D-06, .477746D-06,
     +  .223607D-06, .823553D-07, .192077D-07, .138634D-08,
     +  .000000D+00, .167896D+07, .126375D+07, .934102D+06,
     +  .690022D+06, .509424D+06, .375831D+06, .277104D+06,
     +  .204163D+06, .150327D+06, .110605D+06, .813250D+05,
     +  .597503D+05, .438694D+05, .321839D+05, .235947D+05,
     +  .172838D+05, .126520D+05, .925390D+04, .676374D+04,
     +  .493964D+04, .360507D+04, .262898D+04, .191598D+04,
     +  .139531D+04, .101557D+04, .738654D+03, .537181D+03,
     +  .388707D+03, .282524D+03, .205317D+03, .149233D+03,
     +  .108498D+03, .789224D+02, .575071D+02, .419197D+02,
     +  .306034D+02, .223848D+02, .164071D+02, .120552D+02 /
        DATA (UPDI(I),I=6137,6188) /
     +  .887821D+01, .655801D+01, .485544D+01, .360330D+01,
     +  .267949D+01, .199605D+01, .148844D+01, .111211D+01,
     +  .829334D+00, .619435D+00, .461307D+00, .343374D+00,
     +  .255030D+00, .188914D+00, .139486D+00, .102604D+00,
     +  .751478D-01, .547748D-01, .397161D-01, .286359D-01,
     +  .205204D-01, .146110D-01, .103328D-01, .725145D-02,
     +  .505843D-02, .349241D-02, .239068D-02, .162267D-02,
     +  .109186D-02, .728645D-03, .482289D-03, .317021D-03,
     +  .207095D-03, .134761D-03, .874730D-04, .571098D-04,
     +  .373669D-04, .246735D-04, .164548D-04, .110882D-04,
     +  .751555D-05, .509523D-05, .341664D-05, .223272D-05,
     +  .139995D-05, .822816D-06, .438409D-06, .201313D-06,
     +  .722950D-07, .164057D-07, .120271D-08, .000000D+00 /
        DATA (UPDI(I),I=6189,6240) /
     +  .206461D+07, .154887D+07, .114034D+07, .839018D+06,
     +  .616924D+06, .453279D+06, .332822D+06, .244186D+06,
     +  .179031D+06, .131155D+06, .960128D+05, .702283D+05,
     +  .513301D+05, .374852D+05, .273537D+05, .199430D+05,
     +  .145287D+05, .105750D+05, .769118D+04, .558883D+04,
     +  .405811D+04, .294407D+04, .213434D+04, .154604D+04,
     +  .111918D+04, .809519D+03, .585423D+03, .421177D+03,
     +  .304360D+03, .219894D+03, .158880D+03, .114818D+03,
     +  .830105D+02, .601138D+02, .435463D+02, .315904D+02,
     +  .229595D+02, .167205D+02, .122061D+02, .893115D+01,
     +  .655428D+01, .482116D+01, .355467D+01, .262628D+01,
     +  .194387D+01, .144030D+01, .106940D+01, .792506D+00,
     +  .588309D+00, .435476D+00, .322224D+00, .237928D+00 /
        DATA (UPDI(I),I=6241,6292) /
     +  .175237D+00, .128661D+00, .941208D-01, .685627D-01,
     +  .497112D-01, .358588D-01, .257244D-01, .183437D-01,
     +  .129988D-01, .915034D-02, .639293D-02, .444051D-02,
     +  .305337D-02, .208233D-02, .140864D-02, .945140D-03,
     +  .629336D-03, .415997D-03, .273374D-03, .178790D-03,
     +  .116686D-03, .761216D-04, .500496D-04, .330487D-04,
     +  .220523D-04, .148688D-04, .101195D-04, .691305D-05,
     +  .470716D-05, .315871D-05, .205692D-05, .128043D-05,
     +  .744153D-06, .390574D-06, .175834D-06, .615695D-07,
     +  .136051D-07, .101261D-08, .000000D+00, .251387D+07,
     +  .187980D+07, .137865D+07, .101040D+07, .740005D+06,
     +  .541539D+06, .396015D+06, .289357D+06, .211266D+06,
     +  .154117D+06, .112340D+06, .818144D+05, .595352D+05 /
        DATA (UPDI(I),I=6293,6344) /
     +  .432831D+05, .314414D+05, .228179D+05, .165456D+05,
     +  .119859D+05, .867547D+04, .627329D+04, .453251D+04,
     +  .327167D+04, .235971D+04, .170040D+04, .122443D+04,
     +  .880881D+03, .633560D+03, .453254D+03, .325703D+03,
     +  .233976D+03, .168079D+03, .120756D+03, .867851D+02,
     +  .624708D+02, .449784D+02, .324289D+02, .234226D+02,
     +  .169510D+02, .122964D+02, .894025D+01, .651927D+01,
     +  .476489D+01, .349083D+01, .256276D+01, .188488D+01,
     +  .138783D+01, .102406D+01, .754226D+00, .556500D+00,
     +  .409457D+00, .301184D+00, .221103D+00, .161916D+00,
     +  .118215D+00, .860021D-01, .623101D-01, .449386D-01,
     +  .322482D-01, .230169D-01, .163321D-01, .115177D-01,
     +  .807009D-02, .561282D-02, .388193D-02, .265844D-02 /
        DATA (UPDI(I),I=6345,6396) /
     +  .180624D-02, .121782D-02, .814849D-03, .541452D-03,
     +  .357492D-03, .234923D-03, .153866D-03, .100743D-03,
     +  .660612D-04, .437364D-04, .291282D-04, .196173D-04,
     +  .133473D-04, .915215D-05, .628392D-05, .428562D-05,
     +  .287073D-05, .185906D-05, .114709D-05, .658461D-06,
     +  .340168D-06, .150083D-06, .512486D-07, .110369D-07,
     +  .833710D-09, .000000D+00, .168722D+07, .131115D+07,
     +  .100606D+07, .771969D+06, .592349D+06, .454525D+06,
     +  .348772D+06, .267627D+06, .205363D+06, .157587D+06,
     +  .120928D+06, .927993D+05, .712152D+05, .546531D+05,
     +  .419445D+05, .321926D+05, .247094D+05, .189672D+05,
     +  .145607D+05, .111791D+05, .858408D+04, .659252D+04,
     +  .506405D+04, .389091D+04, .299045D+04, .229924D+04 /
        DATA (UPDI(I),I=6397,6448) /
     +  .176859D+04, .135611D+04, .104452D+04, .805181D+03,
     +  .621289D+03, .479962D+03, .371311D+03, .287966D+03,
     +  .223655D+03, .174152D+03, .136013D+03, .106594D+03,
     +  .838662D+02, .662672D+02, .526267D+02, .420058D+02,
     +  .337113D+02, .272073D+02, .220839D+02, .180277D+02,
     +  .148094D+02, .122158D+02, .101381D+02, .844264D+01,
     +  .706408D+01, .593146D+01, .499514D+01, .421645D+01,
     +  .356521D+01, .301776D+01, .255547D+01, .216355D+01,
     +  .183021D+01, .154598D+01, .130316D+01, .109550D+01,
     +  .917834D+00, .766523D+00, .636450D+00, .525585D+00,
     +  .431347D+00, .351526D+00, .284214D+00, .227754D+00,
     +  .180695D+00, .141759D+00, .109801D+00, .838048D-01,
     +  .630841D-01, .465380D-01, .336235D-01, .237145D-01 /
        DATA (UPDI(I),I=6449,6500) /
     +  .162624D-01, .107890D-01, .688036D-02, .418609D-02,
     +  .239381D-02, .127230D-02, .612585D-03, .257708D-03,
     +  .891593D-04, .226441D-04, .327138D-05, .118915D-06,
     +  .000000D+00, .253468D+07, .196483D+07, .150313D+07,
     +  .114959D+07, .879195D+06, .672199D+06, .513933D+06,
     +  .392806D+06, .300220D+06, .229382D+06, .175253D+06,
     +  .133852D+06, .102227D+06, .780472D+05, .595837D+05,
     +  .454720D+05, .347009D+05, .264719D+05, .201936D+05,
     +  .153991D+05, .117428D+05, .895186D+04, .682448D+04,
     +  .520139D+04, .396477D+04, .302160D+04, .230340D+04,
     +  .174932D+04, .133436D+04, .101813D+04, .777444D+03,
     +  .594073D+03, .454510D+03, .348449D+03, .267483D+03,
     +  .205784D+03, .158782D+03, .122906D+03, .955133D+02 /
        DATA (UPDI(I),I=6501,6552) /
     +  .745311D+02, .584592D+02, .460823D+02, .365298D+02,
     +  .291210D+02, .233523D+02, .188336D+02, .152890D+02,
     +  .124622D+02, .102226D+02, .841425D+01, .695975D+01,
     +  .577734D+01, .481039D+01, .401484D+01, .335675D+01,
     +  .280966D+01, .235282D+01, .196993D+01, .164799D+01,
     +  .137669D+01, .114765D+01, .954166D+00, .790541D+00,
     +  .652909D+00, .536031D+00, .437673D+00, .355102D+00,
     +  .286065D+00, .228587D+00, .181011D+00, .141871D+00,
     +  .109928D+00, .840767D-01, .633377D-01, .470412D-01,
     +  .342228D-01, .243678D-01, .169280D-01, .114235D-01,
     +  .745228D-02, .466645D-02, .278490D-02, .155890D-02,
     +  .809633D-03, .379771D-03, .155196D-03, .519001D-04,
     +  .126879D-04, .177268D-05, .650142D-07, .000000D+00 /
        DATA (UPDI(I),I=6553,6604) /
     +  .365609D+07, .282529D+07, .215348D+07, .164067D+07,
     +  .124988D+07, .951714D+06, .724606D+06, .551421D+06,
     +  .419576D+06, .319090D+06, .242635D+06, .184399D+06,
     +  .140118D+06, .106410D+06, .807961D+05, .613119D+05,
     +  .465173D+05, .352715D+05, .267391D+05, .202585D+05,
     +  .153456D+05, .116172D+05, .879327D+04, .665215D+04,
     +  .503188D+04, .380426D+04, .287631D+04, .216565D+04,
     +  .163751D+04, .123815D+04, .936685D+03, .708904D+03,
     +  .537055D+03, .407594D+03, .309680D+03, .235751D+03,
     +  .179976D+03, .137811D+03, .105937D+03, .817618D+02,
     +  .634307D+02, .494536D+02, .387749D+02, .305742D+02,
     +  .242528D+02, .193489D+02, .155400D+02, .125313D+02,
     +  .101708D+02, .828303D+01, .677931D+01, .556869D+01 /
        DATA (UPDI(I),I=6605,6656) /
     +  .458827D+01, .378958D+01, .313546D+01, .259718D+01,
     +  .215228D+01, .178331D+01, .147634D+01, .122046D+01,
     +  .100678D+01, .828311D+00, .679026D+00, .554891D+00,
     +  .450680D+00, .364013D+00, .292112D+00, .232721D+00,
     +  .183871D+00, .143939D+00, .111496D+00, .853625D-01,
     +  .644926D-01, .479710D-01, .351662D-01, .252384D-01,
     +  .177169D-01, .121265D-01, .805582D-02, .516907D-02,
     +  .317932D-02, .186163D-02, .102041D-02, .517975D-03,
     +  .236775D-03, .940090D-04, .303987D-04, .715664D-05,
     +  .966727D-06, .353515D-07, .000000D+00, .509532D+07,
     +  .392432D+07, .297952D+07, .226091D+07, .171531D+07,
     +  .130062D+07, .985974D+06, .746992D+06, .565801D+06,
     +  .428284D+06, .324105D+06, .245101D+06, .185300D+06 /
        DATA (UPDI(I),I=6657,6708) /
     +  .139990D+06, .105726D+06, .797885D+05, .601935D+05,
     +  .453758D+05, .341934D+05, .257464D+05, .193790D+05,
     +  .145748D+05, .109578D+05, .823219D+04, .618267D+04,
     +  .463979D+04, .348152D+04, .260063D+04, .195067D+04,
     +  .146278D+04, .109726D+04, .823227D+03, .618118D+03,
     +  .464859D+03, .349911D+03, .263860D+03, .199503D+03,
     +  .151279D+03, .115150D+03, .879942D+02, .675893D+02,
     +  .521720D+02, .404997D+02, .316171D+02, .248317D+02,
     +  .196146D+02, .155988D+02, .124545D+02, .100095D+02,
     +  .807166D+01, .654170D+01, .532100D+01, .434133D+01,
     +  .355059D+01, .290896D+01, .238596D+01, .195782D+01,
     +  .160623D+01, .131661D+01, .107764D+01, .880131D+00,
     +  .716895D+00, .581768D+00, .470613D+00, .378310D+00 /
        DATA (UPDI(I),I=6709,6760) /
     +  .302398D+00, .240122D+00, .189269D+00, .147925D+00,
     +  .114526D+00, .877150D-01, .663842D-01, .495647D-01,
     +  .364184D-01, .263635D-01, .186742D-01, .129307D-01,
     +  .872466D-02, .570902D-02, .360520D-02, .217965D-02,
     +  .125312D-02, .673182D-03, .334312D-03, .149116D-03,
     +  .576068D-04, .180505D-04, .410421D-05, .537143D-06,
     +  .192310D-07, .000000D+00, .689968D+07, .529597D+07,
     +  .400500D+07, .302679D+07, .228687D+07, .172668D+07,
     +  .130331D+07, .983060D+06, .741247D+06, .558501D+06,
     +  .420649D+06, .316575D+06, .238151D+06, .179007D+06,
     +  .134491D+06, .100957D+06, .757483D+05, .567827D+05,
     +  .425439D+05, .318459D+05, .238254D+05, .178080D+05,
     +  .133035D+05, .992924D+04, .740721D+04, .552036D+04 /
        DATA (UPDI(I),I=6761,6812) /
     +  .411299D+04, .304972D+04, .227047D+04, .168959D+04,
     +  .125746D+04, .935858D+03, .696911D+03, .519733D+03,
     +  .387868D+03, .289939D+03, .217283D+03, .163289D+03,
     +  .123168D+03, .932634D+02, .709804D+02, .542862D+02,
     +  .417524D+02, .322947D+02, .251300D+02, .196672D+02,
     +  .154970D+02, .122588D+02, .976183D+01, .779921D+01,
     +  .626261D+01, .504700D+01, .407968D+01, .330569D+01,
     +  .268314D+01, .218024D+01, .177228D+01, .144036D+01,
     +  .116952D+01, .948187D+00, .767033D+00, .618800D+00,
     +  .497307D+00, .398387D+00, .317093D+00, .250940D+00,
     +  .197250D+00, .153885D+00, .119017D+00, .911679D-01,
     +  .690677D-01, .516925D-01, .381573D-01, .277069D-01,
     +  .198153D-01, .138593D-01, .947076D-02, .630258D-02 /
        DATA (UPDI(I),I=6813,6864) /
     +  .406458D-02, .252758D-02, .150315D-02, .849133D-03,
     +  .447477D-03, .217628D-03, .948414D-04, .357058D-04,
     +  .108651D-04, .239262D-05, .303916D-06, .103972D-07,
     +  .000000D+00, .962470D+07, .735671D+07, .553624D+07,
     +  .416330D+07, .312959D+07, .235081D+07, .176505D+07,
     +  .132421D+07, .993002D+06, .744019D+06, .557175D+06,
     +  .416887D+06, .311745D+06, .232904D+06, .173896D+06,
     +  .129711D+06, .966899D+05, .720010D+05, .535792D+05,
     +  .398281D+05, .295849D+05, .219521D+05, .162768D+05,
     +  .120556D+05, .892286D+04, .659636D+04, .487418D+04,
     +  .358322D+04, .264456D+04, .195057D+04, .143852D+04,
     +  .106069D+04, .782371D+03, .577842D+03, .426974D+03,
     +  .315972D+03, .234377D+03, .174318D+03, .130114D+03 /
        DATA (UPDI(I),I=6865,6916) /
     +  .974862D+02, .734073D+02, .555444D+02, .422625D+02,
     +  .323388D+02, .248936D+02, .192721D+02, .150223D+02,
     +  .117543D+02, .925881D+01, .731670D+01, .581109D+01,
     +  .463194D+01, .370306D+01, .296747D+01, .238196D+01,
     +  .191401D+01, .153849D+01, .123633D+01, .992521D+00,
     +  .795566D+00, .636230D+00, .507387D+00, .403037D+00,
     +  .319108D+00, .250984D+00, .196246D+00, .152388D+00,
     +  .117425D+00, .896832D-01, .678235D-01, .507147D-01,
     +  .374529D-01, .272707D-01, .195238D-01, .137620D-01,
     +  .948133D-02, .637823D-02, .417566D-02, .264706D-02,
     +  .161654D-02, .942992D-03, .521888D-03, .268986D-03,
     +  .127718D-03, .542139D-04, .198285D-04, .584365D-05,
     +  .124320D-05, .152688D-06, .471814D-08, .000000D+00 /
        DATA (UPDI(I),I=6917,6968) /
     +  .131204D+08, .998651D+07, .747826D+07, .559565D+07,
     +  .418487D+07, .312725D+07, .233564D+07, .174292D+07,
     +  .129984D+07, .968523D+06, .721190D+06, .536501D+06,
     +  .398830D+06, .296184D+06, .219791D+06, .162925D+06,
     +  .120675D+06, .892792D+05, .659958D+05, .487263D+05,
     +  .359440D+05, .264822D+05, .194937D+05, .143316D+05,
     +  .105270D+05, .772190D+04, .566066D+04, .412723D+04,
     +  .302079D+04, .220921D+04, .161512D+04, .118039D+04,
     +  .862779D+03, .631378D+03, .462147D+03, .338741D+03,
     +  .248829D+03, .183252D+03, .135423D+03, .100448D+03,
     +  .748735D+02, .560789D+02, .422333D+02, .319855D+02,
     +  .243684D+02, .186708D+02, .144034D+02, .111526D+02,
     +  .869361D+01, .679803D+01, .534246D+01, .421353D+01 /
        DATA (UPDI(I),I=6969,7020) /
     +  .333287D+01, .264241D+01, .209834D+01, .166799D+01,
     +  .132624D+01, .105418D+01, .837033D+00, .663550D+00,
     +  .524774D+00, .413832D+00, .325011D+00, .254411D+00,
     +  .197791D+00, .152849D+00, .117285D+00, .892903D-01,
     +  .673626D-01, .503093D-01, .371405D-01, .270719D-01,
     +  .194496D-01, .137327D-01, .954345D-02, .647833D-02,
     +  .429151D-02, .276477D-02, .172337D-02, .103390D-02,
     +  .591820D-03, .321014D-03, .161896D-03, .750860D-04,
     +  .310647D-04, .110458D-04, .315585D-05, .649163D-06,
     +  .769298D-07, .196247D-08, .000000D+00, .175005D+08,
     +  .132653D+08, .988523D+07, .736023D+07, .547692D+07,
     +  .407195D+07, .302543D+07, .224580D+07, .166590D+07,
     +  .123453D+07, .914167D+06, .676231D+06, .499816D+06 /
        DATA (UPDI(I),I=7021,7072) /
     +  .369013D+06, .272203D+06, .200554D+06, .147626D+06,
     +  .108531D+06, .797105D+05, .584665D+05, .428399D+05,
     +  .313472D+05, .229135D+05, .167257D+05, .121958D+05,
     +  .887916D+04, .645938D+04, .467238D+04, .339254D+04,
     +  .246093D+04, .178418D+04, .129290D+04, .936816D+03,
     +  .679528D+03, .492916D+03, .357995D+03, .260531D+03,
     +  .190068D+03, .139124D+03, .102203D+03, .754443D+02,
     +  .559562D+02, .417276D+02, .312916D+02, .236039D+02,
     +  .179054D+02, .136757D+02, .104828D+02, .808960D+01,
     +  .626172D+01, .487111D+01, .380269D+01, .297713D+01,
     +  .233612D+01, .183594D+01, .144425D+01, .113634D+01,
     +  .893754D+00, .702157D+00, .550714D+00, .430877D+00,
     +  .336124D+00, .261107D+00, .202152D+00, .155415D+00 /
        DATA (UPDI(I),I=7073,7124) /
     +  .118751D+00, .900836D-01, .677895D-01, .505419D-01,
     +  .372961D-01, .271985D-01, .195787D-01, .138873D-01,
     +  .967675D-02, .663462D-02, .444102D-02, .289948D-02,
     +  .183995D-02, .112895D-02, .666162D-03, .374717D-03,
     +  .199534D-03, .986621D-04, .448025D-04, .181196D-04,
     +  .628672D-05, .174956D-05, .349903D-06, .401047D-07,
     +  .719211D-09, .000000D+00, .228804D+08, .172732D+08,
     +  .128104D+08, .949213D+07, .702857D+07, .519954D+07,
     +  .384364D+07, .283850D+07, .209454D+07, .154394D+07,
     +  .113710D+07, .836527D+06, .614835D+06, .451355D+06,
     +  .331013D+06, .242449D+06, .177393D+06, .129618D+06,
     +  .946035D+05, .689497D+05, .501934D+05, .364853D+05,
     +  .264890D+05, .192024D+05, .139031D+05, .100491D+05 /
        DATA (UPDI(I),I=7125,7176) /
     +  .725676D+04, .520922D+04, .375330D+04, .270132D+04,
     +  .194279D+04, .139637D+04, .100335D+04, .721635D+03,
     +  .518933D+03, .373583D+03, .269449D+03, .194800D+03,
     +  .141284D+03, .102831D+03, .752010D+02, .552529D+02,
     +  .408138D+02, .303160D+02, .226498D+02, .170169D+02,
     +  .128725D+02, .977138D+01, .746763D+01, .572379D+01,
     +  .440906D+01, .340816D+01, .264190D+01, .205250D+01,
     +  .159697D+01, .124368D+01, .968683D+00, .754178D+00,
     +  .586476D+00, .455280D+00, .352546D+00, .272172D+00,
     +  .209218D+00, .160280D+00, .121912D+00, .921499D-01,
     +  .691441D-01, .514592D-01, .379382D-01, .276780D-01,
     +  .199517D-01, .141934D-01, .994673D-02, .684550D-02,
     +  .463455D-02, .306195D-02, .197237D-02, .123431D-02 /
        DATA (UPDI(I),I=7177,7228) /
     +  .746474D-03, .433890D-03, .240254D-03, .125844D-03,
     +  .611539D-04, .272666D-04, .108171D-04, .367742D-05,
     +  .100199D-05, .195961D-06, .217812D-07, .184495D-09,
     +  .000000D+00, .293706D+08, .220855D+08, .163029D+08,
     +  .120229D+08, .885978D+07, .652235D+07, .479764D+07,
     +  .352527D+07, .258804D+07, .189786D+07, .139040D+07,
     +  .101741D+07, .743713D+06, .542952D+06, .395947D+06,
     +  .288353D+06, .209749D+06, .152352D+06, .110523D+06,
     +  .800571D+05, .579130D+05, .418273D+05, .301689D+05,
     +  .217243D+05, .156218D+05, .112127D+05, .803955D+04,
     +  .572873D+04, .409705D+04, .292647D+04, .208847D+04,
     +  .148928D+04, .106151D+04, .757242D+03, .539999D+03,
     +  .385461D+03, .275625D+03, .197531D+03, .142001D+03 /
        DATA (UPDI(I),I=7229,7280) /
     +  .102433D+03, .742362D+02, .540504D+02, .395613D+02,
     +  .291163D+02, .215530D+02, .160429D+02, .120232D+02,
     +  .904113D+01, .684495D+01, .519699D+01, .396543D+01,
     +  .303618D+01, .233114D+01, .179377D+01, .138227D+01,
     +  .106611D+01, .822342D+00, .634027D+00, .488235D+00,
     +  .375305D+00, .287759D+00, .219959D+00, .167397D+00,
     +  .126961D+00, .955922D-01, .715189D-01, .531118D-01,
     +  .391166D-01, .285356D-01, .205967D-01, .146870D-01,
     +  .103336D-01, .716117D-02, .487226D-02, .326056D-02,
     +  .212860D-02, .135447D-02, .837048D-03, .499727D-03,
     +  .286620D-03, .156540D-03, .808366D-04, .387077D-04,
     +  .169973D-04, .663819D-05, .222050D-05, .595256D-06,
     +  .114430D-06, .123692D-07, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=7281,7332) /
     +  .370730D+08, .277706D+08, .204061D+08, .149795D+08,
     +  .109868D+08, .804983D+07, .589264D+07, .430873D+07,
     +  .314750D+07, .229650D+07, .167383D+07, .121845D+07,
     +  .885959D+06, .643329D+06, .466582D+06, .337907D+06,
     +  .244403D+06, .176502D+06, .127292D+06, .916531D+05,
     +  .658976D+05, .472991D+05, .338995D+05, .242531D+05,
     +  .173252D+05, .123515D+05, .879523D+04, .622266D+04,
     +  .441843D+04, .313300D+04, .221919D+04, .157047D+04,
     +  .111069D+04, .786086D+03, .556055D+03, .393679D+03,
     +  .279163D+03, .198384D+03, .141398D+03, .101120D+03,
     +  .726485D+02, .524315D+02, .380379D+02, .277471D+02,
     +  .203564D+02, .150165D+02, .111532D+02, .831095D+01,
     +  .623535D+01, .469104D+01, .354678D+01, .269084D+01 /
        DATA (UPDI(I),I=7333,7384) /
     +  .204707D+01, .156072D+01, .119161D+01, .910579D+00,
     +  .695877D+00, .531547D+00, .405515D+00, .308813D+00,
     +  .234564D+00, .177617D+00, .133899D+00, .100598D+00,
     +  .750213D-01, .555910D-01, .408858D-01, .298201D-01,
     +  .215412D-01, .153949D-01, .108684D-01, .756995D-02,
     +  .519255D-02, .349628D-02, .231535D-02, .149543D-02,
     +  .941285D-03, .575295D-03, .339609D-03, .192556D-03,
     +  .103942D-03, .530381D-04, .250898D-04, .108821D-04,
     +  .419744D-05, .138648D-05, .367095D-06, .696348D-07,
     +  .734032D-08, .000000D+00, .000000D+00, .460774D+08,
     +  .343871D+08, .251555D+08, .183829D+08, .134213D+08,
     +  .978811D+07, .713141D+07, .518972D+07, .377271D+07,
     +  .273918D+07, .198652D+07, .143876D+07, .104077D+07 /
        DATA (UPDI(I),I=7385,7436) /
     +  .751798D+06, .542352D+06, .390662D+06, .281006D+06,
     +  .201802D+06, .144709D+06, .103590D+06, .740399D+05,
     +  .528237D+05, .376265D+05, .267511D+05, .189874D+05,
     +  .134480D+05, .951233D+04, .668368D+04, .471287D+04,
     +  .331818D+04, .233338D+04, .163914D+04, .115054D+04,
     +  .808090D+03, .567168D+03, .398372D+03, .280221D+03,
     +  .197515D+03, .139619D+03, .990159D+02, .705389D+02,
     +  .504779D+02, .363083D+02, .262583D+02, .190983D+02,
     +  .139664D+02, .102836D+02, .759600D+01, .564938D+01,
     +  .421292D+01, .315740D+01, .237443D+01, .179050D+01,
     +  .135311D+01, .102401D+01, .775619D+00, .587518D+00,
     +  .444824D+00, .336365D+00, .253895D+00, .191150D+00,
     +  .143466D+00, .107197D+00, .798268D-01, .590025D-01 /
        DATA (UPDI(I),I=7437,7488) /
     +  .433319D-01, .315853D-01, .228306D-01, .163441D-01,
     +  .115754D-01, .809796D-02, .558888D-02, .379852D-02,
     +  .253396D-02, .166255D-02, .106372D-02, .663221D-03,
     +  .401482D-03, .234727D-03, .131798D-03, .704516D-04,
     +  .355959D-04, .166725D-04, .715949D-05, .273430D-05,
     +  .894135D-06, .234389D-06, .439695D-07, .453122D-08,
     +  .000000D+00, .000000D+00, .564582D+08, .419815D+08,
     +  .305778D+08, .222472D+08, .161702D+08, .117396D+08,
     +  .851405D+07, .616715D+07, .446212D+07, .322425D+07,
     +  .232696D+07, .167703D+07, .120705D+07, .867482D+06,
     +  .622570D+06, .446090D+06, .319159D+06, .227957D+06,
     +  .162559D+06, .115713D+06, .822296D+05, .583238D+05,
     +  .412965D+05, .291819D+05, .205842D+05, .144864D+05 /
        DATA (UPDI(I),I=7489,7540) /
     +  .101807D+05, .710555D+04, .497667D+04, .347991D+04,
     +  .242999D+04, .169485D+04, .118098D+04, .823345D+03,
     +  .573516D+03, .399746D+03, .278999D+03, .195104D+03,
     +  .136814D+03, .962447D+02, .680071D+02, .482675D+02,
     +  .344319D+02, .246950D+02, .178119D+02, .129168D+02,
     +  .943142D+01, .690794D+01, .509467D+01, .376725D+01,
     +  .279969D+01, .208775D+01, .156112D+01, .116988D+01,
     +  .877938D+00, .659425D+00, .495340D+00, .371914D+00,
     +  .278898D+00, .208775D+00, .155883D+00, .116033D+00,
     +  .859858D-01, .635078D-01, .465555D-01, .339106D-01,
     +  .245160D-01, .175761D-01, .124799D-01, .876661D-02,
     +  .608306D-02, .416407D-02, .280709D-02, .185727D-02,
     +  .120868D-02, .767010D-03, .474320D-03, .284782D-03 /
        DATA (UPDI(I),I=7541,7592) /
     +  .165137D-03, .919636D-04, .487567D-04, .244322D-04,
     +  .113495D-04, .483314D-05, .183040D-05, .593344D-06,
     +  .154145D-06, .286173D-07, .288924D-08, .000000D+00,
     +  .000000D+00, .682710D+08, .505865D+08, .366892D+08,
     +  .265790D+08, .192347D+08, .139030D+08, .100379D+08,
     +  .723806D+07, .521287D+07, .374919D+07, .269300D+07,
     +  .193152D+07, .138344D+07, .989329D+06, .706441D+06,
     +  .503599D+06, .358429D+06, .254652D+06, .180617D+06,
     +  .127863D+06, .903565D+05, .637240D+05, .448586D+05,
     +  .315119D+05, .220936D+05, .154529D+05, .107919D+05,
     +  .748328D+04, .520703D+04, .361679D+04, .250842D+04,
     +  .173746D+04, .120213D+04, .832090D+03, .575369D+03,
     +  .398061D+03, .275729D+03, .191346D+03, .133142D+03 /
        DATA (UPDI(I),I=7593,7644) /
     +  .929303D+02, .651485D+02, .458723D+02, .324624D+02,
     +  .230962D+02, .165250D+02, .118871D+02, .860990D+01,
     +  .625523D+01, .457627D+01, .335663D+01, .247451D+01,
     +  .183050D+01, .135784D+01, .100945D+01, .751547D+00,
     +  .560040D+00, .417383D+00, .310935D+00, .231359D+00,
     +  .171851D+00, .127328D+00, .940546D-01, .691695D-01,
     +  .507033D-01, .368897D-01, .266693D-01, .191377D-01,
     +  .136189D-01, .959915D-02, .669376D-02, .461103D-02,
     +  .313359D-02, .209724D-02, .137764D-02, .890199D-03,
     +  .560888D-03, .344403D-03, .205319D-03, .118221D-03,
     +  .653714D-04, .344137D-04, .171215D-04, .789565D-05,
     +  .333713D-05, .125400D-05, .403068D-06, .103763D-06,
     +  .190592D-07, .188843D-08, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=7645,7696) /
     +  .506081D+05, .757076D+05, .588450D+05, .457445D+05,
     +  .355662D+05, .276577D+05, .215123D+05, .167365D+05,
     +  .130246D+05, .101392D+05, .789607D+04, .615186D+04,
     +  .479535D+04, .374013D+04, .291906D+04, .228000D+04,
     +  .178243D+04, .139487D+04, .109286D+04, .857392D+03,
     +  .673699D+03, .530298D+03, .418264D+03, .330659D+03,
     +  .262088D+03, .208354D+03, .166194D+03, .132651D+03,
     +  .106677D+03, .861958D+02, .700132D+02, .571988D+02,
     +  .470266D+02, .389516D+02, .324876D+02, .273120D+02,
     +  .231522D+02, .197945D+02, .170708D+02, .148479D+02,
     +  .130247D+02, .115157D+02, .102568D+02, .919671D+01,
     +  .829504D+01, .751988D+01, .684847D+01, .625461D+01,
     +  .573010D+01, .525633D+01, .482861D+01, .443772D+01 /
        DATA (UPDI(I),I=7697,7748) /
     +  .407791D+01, .374467D+01, .343454D+01, .314484D+01,
     +  .287351D+01, .261901D+01, .238013D+01, .215597D+01,
     +  .194580D+01, .174907D+01, .156530D+01, .139488D+01,
     +  .123566D+01, .108840D+01, .952776D+00, .828453D+00,
     +  .715082D+00, .612293D+00, .519688D+00, .436842D+00,
     +  .363253D+00, .298384D+00, .242265D+00, .193517D+00,
     +  .151989D+00, .117084D+00, .881954D-01, .647110D-01,
     +  .460196D-01, .315359D-01, .205853D-01, .126881D-01,
     +  .723909D-02, .371723D-02, .163888D-02, .567934D-03,
     +  .126856D-03, .968234D-05, .000000D+00, .128645D+06,
     +  .100638D+06, .778116D+05, .601667D+05, .465298D+05,
     +  .359872D+05, .278386D+05, .215384D+05, .166682D+05,
     +  .129021D+05, .999036D+04, .773823D+04, .599655D+04 /
        DATA (UPDI(I),I=7749,7800) /
     +  .464901D+04, .360650D+04, .279956D+04, .217497D+04,
     +  .169122D+04, .131653D+04, .102608D+04, .800900D+03,
     +  .626157D+03, .490503D+03, .385075D+03, .303087D+03,
     +  .239244D+03, .189490D+03, .150155D+03, .119901D+03,
     +  .961945D+02, .775908D+02, .629510D+02, .514065D+02,
     +  .422973D+02, .350517D+02, .292825D+02, .246728D+02,
     +  .209702D+02, .179822D+02, .155538D+02, .135708D+02,
     +  .119352D+02, .105758D+02, .943449D+01, .846691D+01,
     +  .763751D+01, .692148D+01, .629020D+01, .573479D+01,
     +  .523500D+01, .478583D+01, .437722D+01, .400304D+01,
     +  .365834D+01, .333937D+01, .304314D+01, .276738D+01,
     +  .251030D+01, .227051D+01, .204690D+01, .183858D+01,
     +  .164483D+01, .146497D+01, .129922D+01, .114533D+01 /
        DATA (UPDI(I),I=7801,7852) /
     +  .100390D+01, .874454D+00, .756545D+00, .649694D+00,
     +  .553429D+00, .467246D+00, .390639D+00, .323046D+00,
     +  .263842D+00, .212966D+00, .169075D+00, .131947D+00,
     +  .100969D+00, .755215D-01, .550022D-01, .388034D-01,
     +  .263650D-01, .170488D-01, .104007D-01, .586547D-02,
     +  .297236D-02, .129021D-02, .438827D-03, .961628D-04,
     +  .741416D-05, .000000D+00, .169427D+06, .131982D+06,
     +  .101552D+06, .781366D+05, .601265D+05, .462681D+05,
     +  .356089D+05, .274070D+05, .210985D+05, .162441D+05,
     +  .125100D+05, .963645D+04, .742582D+04, .572429D+04,
     +  .441503D+04, .340699D+04, .263107D+04, .203340D+04,
     +  .157310D+04, .121831D+04, .944859D+03, .733888D+03,
     +  .571101D+03, .445339D+03, .348145D+03, .272925D+03 /
        DATA (UPDI(I),I=7853,7904) /
     +  .214684D+03, .168926D+03, .133958D+03, .106730D+03,
     +  .855011D+02, .688997D+02, .558917D+02, .456896D+02,
     +  .376245D+02, .312391D+02, .261659D+02, .221116D+02,
     +  .188563D+02, .162223D+02, .140807D+02, .123208D+02,
     +  .108634D+02, .964375D+01, .861316D+01, .773246D+01,
     +  .697464D+01, .630871D+01, .572497D+01, .520168D+01,
     +  .473339D+01, .430927D+01, .392277D+01, .356851D+01,
     +  .324244D+01, .294127D+01, .266249D+01, .240409D+01,
     +  .216447D+01, .194235D+01, .173663D+01, .154646D+01,
     +  .137095D+01, .121018D+01, .106179D+01, .926242D+00,
     +  .802915D+00, .691254D+00, .590672D+00, .500605D+00,
     +  .420458D+00, .349657D+00, .287588D+00, .233560D+00,
     +  .187434D+00, .147906D+00, .114698D+00, .871889D-01 /
        DATA (UPDI(I),I=7905,7956) /
     +  .647582D-01, .468133D-01, .327603D-01, .220675D-01,
     +  .141341D-01, .853238D-02, .475485D-02, .237689D-02,
     +  .101515D-02, .338570D-03, .727048D-04, .566684D-05,
     +  .000000D+00, .220009D+06, .170716D+06, .130764D+06,
     +  .100154D+06, .767118D+05, .587526D+05, .450013D+05,
     +  .344676D+05, .264030D+05, .202260D+05, .154973D+05,
     +  .118755D+05, .910291D+04, .697931D+04, .535355D+04,
     +  .410815D+04, .315454D+04, .242381D+04, .186408D+04,
     +  .143497D+04, .110609D+04, .853759D+03, .660178D+03,
     +  .511485D+03, .397247D+03, .309361D+03, .241731D+03,
     +  .188917D+03, .148807D+03, .117766D+03, .937164D+02,
     +  .750231D+02, .604660D+02, .491169D+02, .401982D+02,
     +  .331766D+02, .276288D+02, .232176D+02, .196932D+02 /
        DATA (UPDI(I),I=7957,8008) /
     +  .168541D+02, .145556D+02, .126739D+02, .111214D+02,
     +  .982631D+01, .873560D+01, .780644D+01, .700951D+01,
     +  .631153D+01, .570189D+01, .515741D+01, .467216D+01,
     +  .423455D+01, .383760D+01, .347551D+01, .314391D+01,
     +  .283922D+01, .255869D+01, .230009D+01, .206161D+01,
     +  .184178D+01, .163934D+01, .145327D+01, .128250D+01,
     +  .112697D+01, .984229D+00, .854585D+00, .737308D+00,
     +  .631739D+00, .537194D+00, .453029D+00, .378572D+00,
     +  .313191D+00, .256230D+00, .206946D+00, .165137D+00,
     +  .129541D+00, .998349D-01, .753988D-01, .556176D-01,
     +  .399137D-01, .277128D-01, .185106D-01, .117459D-01,
     +  .701830D-02, .386595D-02, .190703D-02, .801745D-03,
     +  .262403D-03, .552795D-04, .435408D-05, .000000D+00 /
        DATA (UPDI(I),I=8009,8060) /
     +  .177839D+06, .217963D+06, .166251D+06, .126788D+06,
     +  .966900D+05, .737260D+05, .562166D+05, .428608D+05,
     +  .326799D+05, .249158D+05, .189987D+05, .144872D+05,
     +  .110494D+05, .842854D+04, .643166D+04, .490932D+04,
     +  .374940D+04, .286500D+04, .219102D+04, .167698D+04,
     +  .128509D+04, .986017D+03, .757831D+03, .583522D+03,
     +  .450359D+03, .348496D+03, .270571D+03, .210072D+03,
     +  .164400D+03, .129263D+03, .102203D+03, .812951D+02,
     +  .651098D+02, .525646D+02, .427626D+02, .350881D+02,
     +  .290569D+02, .242856D+02, .204917D+02, .174491D+02,
     +  .149961D+02, .129956D+02, .113509D+02, .998352D+01,
     +  .883564D+01, .786086D+01, .702747D+01, .629995D+01,
     +  .566673D+01, .510327D+01, .460307D+01, .415387D+01 /
        DATA (UPDI(I),I=8061,8112) /
     +  .374819D+01, .337985D+01, .304415D+01, .273723D+01,
     +  .245608D+01, .219826D+01, .196177D+01, .174494D+01,
     +  .154634D+01, .136481D+01, .119909D+01, .104899D+01,
     +  .911997D+00, .788257D+00, .676940D+00, .577296D+00,
     +  .488559D+00, .410012D+00, .340921D+00, .280607D+00,
     +  .228375D+00, .183450D+00, .145574D+00, .113530D+00,
     +  .869640D-01, .652596D-01, .478141D-01, .340683D-01,
     +  .234718D-01, .155482D-01, .977613D-02, .578269D-02,
     +  .314924D-02, .153337D-02, .634821D-03, .204019D-03,
     +  .422052D-04, .335835D-05, .000000D+00, .380030D+06,
     +  .292540D+06, .222014D+06, .168453D+06, .127799D+06,
     +  .969337D+05, .735161D+05, .557448D+05, .422672D+05,
     +  .320433D+05, .242926D+05, .184152D+05, .139612D+05 /
        DATA (UPDI(I),I=8113,8164) /
     +  .105847D+05, .802660D+04, .608782D+04, .461924D+04,
     +  .350630D+04, .266329D+04, .202437D+04, .154034D+04,
     +  .117337D+04, .895196D+03, .684138D+03, .523995D+03,
     +  .402343D+03, .309939D+03, .238712D+03, .185329D+03,
     +  .144562D+03, .113393D+03, .894875D+02, .711154D+02,
     +  .569786D+02, .460103D+02, .374821D+02, .308240D+02,
     +  .255903D+02, .214534D+02, .181544D+02, .155085D+02,
     +  .133611D+02, .116036D+02, .101487D+02, .893228D+01,
     +  .790348D+01, .702743D+01, .626587D+01, .560588D+01,
     +  .502132D+01, .450489D+01, .404352D+01, .362910D+01,
     +  .325495D+01, .291596D+01, .260792D+01, .232750D+01,
     +  .207199D+01, .183912D+01, .162701D+01, .143403D+01,
     +  .125880D+01, .109989D+01, .956923D+00, .827308D+00 /
        DATA (UPDI(I),I=8165,8216) /
     +  .711029D+00, .607135D+00, .514772D+00, .433085D+00,
     +  .361280D+00, .298563D+00, .244204D+00, .197476D+00,
     +  .157576D+00, .124191D+00, .961656D-01, .731166D-01,
     +  .544425D-01, .395627D-01, .279451D-01, .190743D-01,
     +  .125097D-01, .778008D-02, .454719D-02, .244340D-02,
     +  .117177D-02, .476655D-03, .150110D-03, .304570D-04,
     +  .245085D-05, .000000D+00, .503751D+06, .386192D+06,
     +  .291692D+06, .220251D+06, .166274D+06, .125486D+06,
     +  .946865D+05, .714261D+05, .538717D+05, .406218D+05,
     +  .306277D+05, .230883D+05, .174045D+05, .131189D+05,
     +  .988953D+04, .745555D+04, .562218D+04, .424076D+04,
     +  .320048D+04, .241673D+04, .182657D+04, .138188D+04,
     +  .104692D+04, .794396D+03, .604033D+03, .460382D+03 /
        DATA (UPDI(I),I=8217,8268) /
     +  .352005D+03, .269039D+03, .207288D+03, .160459D+03,
     +  .124906D+03, .978311D+02, .771671D+02, .613775D+02,
     +  .492095D+02, .398117D+02, .325212D+02, .268255D+02,
     +  .223493D+02, .187993D+02, .159663D+02, .136780D+02,
     +  .118132D+02, .102761D+02, .899596D+01, .791757D+01,
     +  .700291D+01, .621104D+01, .552769D+01, .492516D+01,
     +  .439538D+01, .392445D+01, .350366D+01, .312585D+01,
     +  .278548D+01, .247802D+01, .219981D+01, .194787D+01,
     +  .171971D+01, .151320D+01, .132651D+01, .115811D+01,
     +  .100637D+01, .870743D+00, .748593D+00, .639741D+00,
     +  .543132D+00, .457825D+00, .382892D+00, .317478D+00,
     +  .260740D+00, .211915D+00, .170250D+00, .134933D+00,
     +  .105606D+00, .811793D-01, .612527D-01, .452444D-01 /
        DATA (UPDI(I),I=8269,8320) /
     +  .326009D-01, .228209D-01, .154261D-01, .100119D-01,
     +  .615534D-02, .355218D-02, .188161D-02, .887699D-03,
     +  .354246D-03, .109088D-03, .216579D-04, .176514D-05,
     +  .000000D+00, .657604D+06, .502177D+06, .377567D+06,
     +  .283775D+06, .213224D+06, .160150D+06, .120255D+06,
     +  .902654D+05, .677384D+05, .508164D+05, .381144D+05,
     +  .285794D+05, .214272D+05, .160618D+05, .120398D+05,
     +  .902444D+04, .676533D+04, .507245D+04, .380471D+04,
     +  .285504D+04, .214406D+04, .161150D+04, .121274D+04,
     +  .913977D+03, .690152D+03, .522316D+03, .396512D+03,
     +  .300840D+03, .230105D+03, .176824D+03, .136642D+03,
     +  .106250D+03, .832085D+02, .657205D+02, .523310D+02,
     +  .420563D+02, .341342D+02, .279818D+02, .231734D+02 /
        DATA (UPDI(I),I=8321,8372) /
     +  .193801D+02, .163675D+02, .139453D+02, .119797D+02,
     +  .103661D+02, .902746D+01, .790414D+01, .695504D+01,
     +  .613663D+01, .543332D+01, .481594D+01, .427561D+01,
     +  .379766D+01, .337278D+01, .299335D+01, .265342D+01,
     +  .234812D+01, .207349D+01, .182629D+01, .160378D+01,
     +  .140365D+01, .122387D+01, .106272D+01, .918441D+00,
     +  .790306D+00, .675651D+00, .574146D+00, .484652D+00,
     +  .406154D+00, .337665D+00, .278285D+00, .227136D+00,
     +  .183431D+00, .146407D+00, .115249D+00, .895724D-01,
     +  .683521D-01, .511807D-01, .375018D-01, .267931D-01,
     +  .185864D-01, .124418D-01, .799071D-02, .485625D-02,
     +  .276698D-02, .144478D-02, .670514D-03, .262498D-03,
     +  .790575D-04, .153656D-04, .126840D-05, .000000D+00 /
        DATA (UPDI(I),I=8373,8424) /
     +  .846650D+06, .644119D+06, .482160D+06, .360771D+06,
     +  .269849D+06, .201749D+06, .150783D+06, .112642D+06,
     +  .841215D+05, .627962D+05, .468637D+05, .349607D+05,
     +  .260752D+05, .194424D+05, .144951D+05, .108049D+05,
     +  .805452D+04, .600437D+04, .447730D+04, .333963D+04,
     +  .249263D+04, .186178D+04, .139217D+04, .104238D+04,
     +  .781895D+03, .587755D+03, .443142D+03, .333863D+03,
     +  .253584D+03, .193504D+03, .148488D+03, .114660D+03,
     +  .891793D+02, .699644D+02, .553446D+02, .441951D+02,
     +  .356491D+02, .290500D+02, .239199D+02, .198933D+02,
     +  .167103D+02, .141625D+02, .121033D+02, .104194D+02,
     +  .902785D+01, .786445D+01, .688520D+01, .604411D+01,
     +  .532424D+01, .469509D+01, .414694D+01, .366442D+01 /
        DATA (UPDI(I),I=8425,8476) /
     +  .323763D+01, .285851D+01, .252069D+01, .221900D+01,
     +  .194919D+01, .170776D+01, .149175D+01, .129864D+01,
     +  .112624D+01, .972682D+00, .836044D+00, .715465D+00,
     +  .608260D+00, .513963D+00, .431367D+00, .359397D+00,
     +  .297022D+00, .243307D+00, .197356D+00, .158368D+00,
     +  .125577D+00, .981815D-01, .757746D-01, .574001D-01,
     +  .426513D-01, .310008D-01, .219603D-01, .150961D-01,
     +  .100070D-01, .635964D-02, .382044D-02, .214913D-02,
     +  .110614D-02, .504996D-03, .193967D-03, .571516D-04,
     +  .108823D-04, .909745D-06, .000000D+00, .107628D+07,
     +  .815852D+06, .608108D+06, .453045D+06, .337382D+06,
     +  .251115D+06, .186829D+06, .138928D+06, .103267D+06,
     +  .767220D+05, .569792D+05, .422976D+05, .313892D+05 /
        DATA (UPDI(I),I=8477,8528) /
     +  .232851D+05, .172696D+05, .128047D+05, .949355D+04,
     +  .703800D+04, .521845D+04, .387004D+04, .287153D+04,
     +  .213192D+04, .158440D+04, .117890D+04, .878678D+03,
     +  .656228D+03, .491523D+03, .367822D+03, .277509D+03,
     +  .210341D+03, .160326D+03, .122978D+03, .950201D+02,
     +  .740676D+02, .582217D+02, .462090D+02, .370533D+02,
     +  .300222D+02, .245841D+02, .203365D+02, .169938D+02,
     +  .143294D+02, .121845D+02, .104372D+02, .899840D+01,
     +  .779994D+01, .679489D+01, .593497D+01, .520193D+01,
     +  .456401D+01, .401071D+01, .352597D+01, .309933D+01,
     +  .272231D+01, .238816D+01, .209140D+01, .182750D+01,
     +  .159273D+01, .138392D+01, .119838D+01, .103374D+01,
     +  .887982D+00, .759090D+00, .646055D+00, .546193D+00 /
        DATA (UPDI(I),I=8529,8580) /
     +  .458915D+00, .382961D+00, .317209D+00, .260601D+00,
     +  .212178D+00, .171038D+00, .136375D+00, .107430D+00,
     +  .834219D-01, .639327D-01, .480744D-01, .354477D-01,
     +  .255571D-01, .179497D-01, .122271D-01, .802602D-02,
     +  .504704D-02, .299685D-02, .166435D-02, .844376D-03,
     +  .379215D-03, .142919D-03, .412114D-04, .769326D-05,
     +  .651243D-06, .000000D+00, .135213D+07, .102135D+07,
     +  .758123D+06, .562435D+06, .417059D+06, .309076D+06,
     +  .228941D+06, .169483D+06, .125408D+06, .927417D+05,
     +  .685536D+05, .506469D+05, .374027D+05, .276089D+05,
     +  .203732D+05, .150284D+05, .110839D+05, .817316D+04,
     +  .602714D+04, .444494D+04, .327940D+04, .242065D+04,
     +  .178837D+04, .132267D+04, .979802D+03, .727190D+03 /
        DATA (UPDI(I),I=8581,8632) /
     +  .541238D+03, .402407D+03, .301652D+03, .227169D+03,
     +  .172039D+03, .131121D+03, .100673D+03, .779910D+02,
     +  .609363D+02, .480809D+02, .383361D+02, .308920D+02,
     +  .251625D+02, .207082D+02, .172176D+02, .144467D+02,
     +  .122243D+02, .104206D+02, .894059D+01, .771215D+01,
     +  .668570D+01, .581077D+01, .506789D+01, .442413D+01,
     +  .386823D+01, .338350D+01, .295894D+01, .258568D+01,
     +  .225662D+01, .196597D+01, .170894D+01, .148161D+01,
     +  .128059D+01, .110302D+01, .946402D+00, .808592D+00,
     +  .687465D+00, .581895D+00, .489211D+00, .408719D+00,
     +  .339119D+00, .279258D+00, .228060D+00, .184557D+00,
     +  .147847D+00, .117132D+00, .916652D-01, .706945D-01,
     +  .537983D-01, .401560D-01, .293812D-01, .210118D-01 /
        DATA (UPDI(I),I=8633,8684) /
     +  .146311D-01, .987559D-02, .641895D-02, .399385D-02,
     +  .234398D-02, .128513D-02, .642646D-03, .283920D-03,
     +  .105005D-03, .296421D-04, .542881D-05, .465277D-06,
     +  .000000D+00, .168000D+07, .126468D+07, .934935D+06,
     +  .690768D+06, .510091D+06, .376427D+06, .277637D+06,
     +  .204640D+06, .150754D+06, .110986D+06, .816654D+05,
     +  .600544D+05, .441410D+05, .324265D+05, .238114D+05,
     +  .174772D+05, .128246D+05, .940791D+04, .690112D+04,
     +  .506216D+04, .371431D+04, .272637D+04, .200277D+04,
     +  .147264D+04, .108447D+04, .800035D+03, .591840D+03,
     +  .437292D+03, .325779D+03, .243822D+03, .183510D+03,
     +  .139008D+03, .106085D+03, .816988D+02, .634652D+02,
     +  .497964D+02, .394890D+02, .316546D+02, .256528D+02 /
        DATA (UPDI(I),I=8685,8736) /
     +  .210075D+02, .173821D+02, .145152D+02, .122242D+02,
     +  .103713D+02, .885608D+01, .760279D+01, .655928D+01,
     +  .567310D+01, .492361D+01, .427684D+01, .372077D+01,
     +  .323815D+01, .281748D+01, .244951D+01, .212680D+01,
     +  .184330D+01, .159399D+01, .137473D+01, .118196D+01,
     +  .101268D+01, .864257D+00, .734442D+00, .621028D+00,
     +  .522785D+00, .437068D+00, .363094D+00, .299536D+00,
     +  .245223D+00, .199074D+00, .160120D+00, .127471D+00,
     +  .100343D+00, .780101D-01, .597517D-01, .451507D-01,
     +  .334524D-01, .242872D-01, .172278D-01, .118931D-01,
     +  .795410D-02, .511917D-02, .315139D-02, .182802D-02,
     +  .989403D-03, .487669D-03, .211949D-03, .769318D-04,
     +  .212674D-04, .382388D-05, .331763D-06, .000000D+00 /
        DATA (UPDI(I),I=8737,8788) /
     +  .206572D+07, .154987D+07, .114123D+07, .839816D+06,
     +  .617637D+06, .453917D+06, .333392D+06, .244695D+06,
     +  .179486D+06, .131562D+06, .963761D+05, .705527D+05,
     +  .516196D+05, .377436D+05, .275842D+05, .201487D+05,
     +  .147122D+05, .107385D+05, .783694D+04, .571870D+04,
     +  .417379D+04, .304707D+04, .222604D+04, .162765D+04,
     +  .119179D+04, .874114D+03, .642856D+03, .472142D+03,
     +  .349653D+03, .260135D+03, .194628D+03, .146566D+03,
     +  .111205D+03, .851593D+02, .657885D+02, .513437D+02,
     +  .405052D+02, .323067D+02, .260540D+02, .212348D+02,
     +  .174882D+02, .145365D+02, .121857D+02, .102910D+02,
     +  .874667D+01, .747360D+01, .641731D+01, .552355D+01,
     +  .477058D+01, .412349D+01, .356956D+01, .309101D+01 /
        DATA (UPDI(I),I=8789,8840) /
     +  .267588D+01, .231458D+01, .199936D+01, .172392D+01,
     +  .148303D+01, .127236D+01, .108820D+01, .927414D+00,
     +  .787274D+00, .665429D+00, .559613D+00, .468508D+00,
     +  .389508D+00, .321754D+00, .263910D+00, .214794D+00,
     +  .173332D+00, .138566D+00, .109624D+00, .857407D-01,
     +  .662177D-01, .503714D-01, .377937D-01, .277941D-01,
     +  .200228D-01, .140871D-01, .964115D-02, .638876D-02,
     +  .407117D-02, .247959D-02, .142154D-02, .759520D-03,
     +  .368988D-03, .157765D-03, .562079D-04, .152214D-04,
     +  .268860D-05, .236104D-06, .000000D+00, .251507D+07,
     +  .188087D+07, .137960D+07, .101125D+07, .740768D+06,
     +  .542221D+06, .396624D+06, .289901D+06, .211752D+06,
     +  .154551D+06, .112727D+06, .821599D+05, .598434D+05 /
        DATA (UPDI(I),I=8841,8892) /
     +  .435581D+05, .316866D+05, .230364D+05, .167403D+05,
     +  .121594D+05, .882990D+04, .641075D+04, .465483D+04,
     +  .338047D+04, .245644D+04, .178638D+04, .130082D+04,
     +  .948746D+03, .693804D+03, .506620D+03, .373044D+03,
     +  .275953D+03, .205288D+03, .153725D+03, .115991D+03,
     +  .883452D+02, .678903D+02, .527136D+02, .413803D+02,
     +  .328467D+02, .263660D+02, .213911D+02, .175376D+02,
     +  .145123D+02, .121110D+02, .101817D+02, .861429D+01,
     +  .732642D+01, .626152D+01, .536372D+01, .461025D+01,
     +  .396539D+01, .341575D+01, .294308D+01, .253501D+01,
     +  .218161D+01, .187488D+01, .160828D+01, .137638D+01,
     +  .117471D+01, .999407D+00, .847242D+00, .715385D+00,
     +  .601418D+00, .503031D+00, .418832D+00, .346267D+00 /
        DATA (UPDI(I),I=8893,8944) /
     +  .284417D+00, .231944D+00, .187674D+00, .150543D+00,
     +  .119613D+00, .940375D-01, .730775D-01, .560645D-01,
     +  .423545D-01, .315535D-01, .230326D-01, .164636D-01,
     +  .114883D-01, .779452D-02, .511748D-02, .322878D-02,
     +  .194555D-02, .110233D-02, .581388D-03, .278392D-03,
     +  .117100D-03, .409559D-04, .108685D-04, .188709D-05,
     +  .167710D-06, .000000D+00, .506631D+05, .755231D+05,
     +  .586802D+05, .455974D+05, .354349D+05, .275406D+05,
     +  .214078D+05, .166434D+05, .129416D+05, .100654D+05,
     +  .783033D+04, .609338D+04, .474336D+04, .369394D+04,
     +  .287806D+04, .224362D+04, .175018D+04, .136630D+04,
     +  .106758D+04, .835035D+03, .653944D+03, .512855D+03,
     +  .402875D+03, .317092D+03, .250133D+03, .197824D+03 /
        DATA (UPDI(I),I=8945,8996) /
     +  .156919D+03, .124495D+03, .994862D+02, .798476D+02,
     +  .643972D+02, .522156D+02, .425868D+02, .349734D+02,
     +  .289001D+02, .240506D+02, .201597D+02, .170203D+02,
     +  .144711D+02, .123853D+02, .106674D+02, .923816D+01,
     +  .803878D+01, .702309D+01, .615527D+01, .540760D+01,
     +  .476078D+01, .419192D+01, .369493D+01, .325342D+01,
     +  .286376D+01, .251769D+01, .220988D+01, .193590D+01,
     +  .169203D+01, .147508D+01, .128228D+01, .111122D+01,
     +  .959750D+00, .825923D+00, .707989D+00, .604352D+00,
     +  .513555D+00, .434610D+00, .365491D+00, .305607D+00,
     +  .253941D+00, .209571D+00, .171660D+00, .139449D+00,
     +  .112250D+00, .894416D-01, .704523D-01, .547669D-01,
     +  .420535D-01, .317127D-01, .234738D-01, .170056D-01 /
        DATA (UPDI(I),I=8997,9048) /
     +  .120142D-01, .824008D-02, .545497D-02, .346206D-02,
     +  .207823D-02, .116819D-02, .600822D-03, .273690D-03,
     +  .104562D-03, .302482D-04, .526694D-05, .264960D-06,
     +  .000000D+00, .128425D+06, .100442D+06, .776366D+05,
     +  .600105D+05, .463905D+05, .358630D+05, .277279D+05,
     +  .214397D+05, .165803D+05, .128239D+05, .992076D+04,
     +  .767636D+04, .594156D+04, .460017D+04, .356316D+04,
     +  .276113D+04, .214091D+04, .166106D+04, .128983D+04,
     +  .100247D+04, .780041D+03, .607738D+03, .474248D+03,
     +  .370738D+03, .290446D+03, .228100D+03, .179665D+03,
     +  .141504D+03, .112262D+03, .894389D+02, .716024D+02,
     +  .576261D+02, .466513D+02, .380270D+02, .311925D+02,
     +  .257680D+02, .214439D+02, .179754D+02, .151768D+02 /
        DATA (UPDI(I),I=9049,9100) /
     +  .129001D+02, .110370D+02, .949572D+01, .821053D+01,
     +  .712863D+01, .621019D+01, .542375D+01, .474784D+01,
     +  .415710D+01, .364442D+01, .319185D+01, .279501D+01,
     +  .244477D+01, .213521D+01, .186137D+01, .161909D+01,
     +  .140483D+01, .121553D+01, .104852D+01, .901463D+00,
     +  .772251D+00, .658995D+00, .560015D+00, .473734D+00,
     +  .399113D+00, .334113D+00, .278090D+00, .230003D+00,
     +  .188924D+00, .154007D+00, .124498D+00, .997128D-01,
     +  .790433D-01, .619347D-01, .478813D-01, .365587D-01,
     +  .274058D-01, .201598D-01, .145095D-01, .101796D-01,
     +  .693062D-02, .455140D-02, .286392D-02, .170282D-02,
     +  .947766D-03, .482181D-03, .216927D-03, .816603D-04,
     +  .232203D-04, .397942D-05, .203041D-06, .000000D+00 /
        DATA (UPDI(I),I=9101,9152) /
     +  .169195D+06, .131774D+06, .101366D+06, .779712D+05,
     +  .599790D+05, .461367D+05, .354918D+05, .273027D+05,
     +  .210056D+05, .161614D+05, .124365D+05, .957113D+04,
     +  .736780D+04, .567278D+04, .436933D+04, .336647D+04,
     +  .259517D+04, .200161D+04, .154497D+04, .119344D+04,
     +  .922882D+03, .714480D+03, .553968D+03, .430222D+03,
     +  .334809D+03, .261159D+03, .204301D+03, .159773D+03,
     +  .125865D+03, .995621D+02, .791370D+02, .632307D+02,
     +  .508200D+02, .411271D+02, .334947D+02, .274736D+02,
     +  .227039D+02, .189006D+02, .158508D+02, .133840D+02,
     +  .113776D+02, .972737D+01, .835956D+01, .721482D+01,
     +  .624894D+01, .542679D+01, .472453D+01, .411442D+01,
     +  .358823D+01, .312651D+01, .272413D+01, .237111D+01 /
        DATA (UPDI(I),I=9153,9204) /
     +  .206095D+01, .178816D+01, .154820D+01, .133718D+01,
     +  .115177D+01, .989083D+00, .846589D+00, .722050D+00,
     +  .613454D+00, .519044D+00, .437147D+00, .366679D+00,
     +  .305598D+00, .253219D+00, .208483D+00, .170461D+00,
     +  .138306D+00, .111272D+00, .886829D-01, .699463D-01,
     +  .545251D-01, .419267D-01, .318355D-01, .237272D-01,
     +  .173479D-01, .124063D-01, .864545D-02, .584423D-02,
     +  .380835D-02, .237671D-02, .140035D-02, .771244D-03,
     +  .387601D-03, .172004D-03, .637289D-04, .177937D-04,
     +  .299787D-05, .155313D-06, .000000D+00, .219763D+06,
     +  .170496D+06, .130568D+06, .999787D+05, .765560D+05,
     +  .586138D+05, .448777D+05, .343576D+05, .263051D+05,
     +  .201389D+05, .154198D+05, .118067D+05, .904180D+04 /
        DATA (UPDI(I),I=9205,9256) /
     +  .692508D+04, .530545D+04, .406552D+04, .311677D+04,
     +  .239038D+04, .183450D+04, .140881D+04, .108297D+04,
     +  .833342D+03, .642151D+03, .495572D+03, .383202D+03,
     +  .296961D+03, .230780D+03, .179254D+03, .140254D+03,
     +  .110181D+03, .869717D+02, .690063D+02, .550753D+02,
     +  .442609D+02, .357979D+02, .291613D+02, .239361D+02,
     +  .197939D+02, .164920D+02, .138368D+02, .116896D+02,
     +  .993372D+01, .848668D+01, .728250D+01, .627237D+01,
     +  .541746D+01, .469149D+01, .406440D+01, .352676D+01,
     +  .305770D+01, .265128D+01, .229676D+01, .198703D+01,
     +  .171614D+01, .147915D+01, .127187D+01, .109069D+01,
     +  .932564D+00, .794766D+00, .674943D+00, .570980D+00,
     +  .481053D+00, .403416D+00, .336939D+00, .279595D+00 /
        DATA (UPDI(I),I=9257,9308) /
     +  .230660D+00, .189069D+00, .153893D+00, .124292D+00,
     +  .995302D-01, .789449D-01, .619594D-01, .480561D-01,
     +  .367582D-01, .277602D-01, .205726D-01, .149522D-01,
     +  .106265D-01, .735628D-02, .493805D-02, .319356D-02,
     +  .197699D-02, .115452D-02, .629718D-03, .313061D-03,
     +  .137256D-03, .501496D-04, .137867D-04, .229478D-05,
     +  .120962D-06, .000000D+00, .177906D+06, .217731D+06,
     +  .166044D+06, .126603D+06, .965257D+05, .735797D+05,
     +  .560864D+05, .427449D+05, .325767D+05, .248241D+05,
     +  .189172D+05, .144148D+05, .109851D+05, .837153D+04,
     +  .638111D+04, .486452D+04, .370972D+04, .282988D+04,
     +  .215995D+04, .164951D+04, .126081D+04, .964571D+03,
     +  .738890D+03, .566797D+03, .435590D+03, .335449D+03 /
        DATA (UPDI(I),I=9309,9360) /
     +  .259040D+03, .199888D+03, .155376D+03, .121252D+03,
     +  .950720D+02, .749261D+02, .593970D+02, .474134D+02,
     +  .380912D+02, .308238D+02, .251355D+02, .206522D+02,
     +  .170990D+02, .142578D+02, .119732D+02, .101152D+02,
     +  .859252D+01, .733241D+01, .628124D+01, .539651D+01,
     +  .464941D+01, .400764D+01, .346049D+01, .298579D+01,
     +  .257675D+01, .222188D+01, .191353D+01, .164530D+01,
     +  .141185D+01, .120873D+01, .103210D+01, .878714D+00,
     +  .745711D+00, .630626D+00, .531257D+00, .445721D+00,
     +  .372217D+00, .309579D+00, .255799D+00, .210123D+00,
     +  .171486D+00, .138966D+00, .111732D+00, .890621D-01,
     +  .703092D-01, .549152D-01, .423818D-01, .322505D-01,
     +  .242264D-01, .178538D-01, .129003D-01, .911205D-02 /
        DATA (UPDI(I),I=9361,9412) /
     +  .626699D-02, .417793D-02, .268191D-02, .164710D-02,
     +  .953494D-03, .515134D-03, .253383D-03, .109779D-03,
     +  .395718D-04, .107199D-04, .176396D-05, .946019D-07,
     +  .000000D+00, .379753D+06, .292292D+06, .221793D+06,
     +  .168256D+06, .127623D+06, .967775D+05, .733771D+05,
     +  .556212D+05, .421572D+05, .319456D+05, .242058D+05,
     +  .183382D+05, .138928D+05, .105240D+05, .797283D+04,
     +  .604019D+04, .457706D+04, .346897D+04, .263027D+04,
     +  .199518D+04, .151454D+04, .115057D+04, .875057D+03,
     +  .666348D+03, .508276D+03, .388448D+03, .297648D+03,
     +  .227847D+03, .175693D+03, .135997D+03, .105760D+03,
     +  .826625D+02, .649872D+02, .514483D+02, .409926D+02,
     +  .329016D+02, .266142D+02, .216944D+02, .178228D+02 /
        DATA (UPDI(I),I=9413,9464) /
     +  .147489D+02, .122943D+02, .103118D+02, .869815D+01,
     +  .737190D+01, .627304D+01, .535447D+01, .458406D+01,
     +  .392676D+01, .337018D+01, .289057D+01, .248008D+01,
     +  .212633D+01, .182098D+01, .155709D+01, .132890D+01,
     +  .113161D+01, .961115D+00, .813974D+00, .687162D+00,
     +  .578095D+00, .484483D+00, .404382D+00, .335942D+00,
     +  .277959D+00, .228464D+00, .186673D+00, .151529D+00,
     +  .122123D+00, .976441D-01, .773908D-01, .607397D-01,
     +  .471575D-01, .361714D-01, .273487D-01, .204088D-01,
     +  .149364D-01, .107141D-01, .751013D-02, .512349D-02,
     +  .338622D-02, .215345D-02, .130931D-02, .749553D-03,
     +  .400000D-03, .194026D-03, .827259D-04, .292590D-04,
     +  .774793D-05, .124499D-05, .674507D-07, .000000D+00 /
        DATA (UPDI(I),I=9465,9516) /
     +  .503454D+06, .385927D+06, .291456D+06, .220041D+06,
     +  .166087D+06, .125320D+06, .945383D+05, .712944D+05,
     +  .537546D+05, .405178D+05, .305353D+05, .230063D+05,
     +  .173318D+05, .130544D+05, .983239D+04, .740494D+04,
     +  .557738D+04, .420112D+04, .316541D+04, .238573D+04,
     +  .179916D+04, .135767D+04, .102552D+04, .775488D+03,
     +  .587321D+03, .445599D+03, .338920D+03, .257463D+03,
     +  .197012D+03, .151319D+03, .116753D+03, .905356D+02,
     +  .706122D+02, .554597D+02, .438399D+02, .349117D+02,
     +  .280219D+02, .226685D+02, .184842D+02, .151847D+02,
     +  .125674D+02, .104677D+02, .876968D+01, .738330D+01,
     +  .624210D+01, .529436D+01, .450465D+01, .383529D+01,
     +  .327219D+01, .279014D+01, .238022D+01, .202925D+01 /
        DATA (UPDI(I),I=9517,9568) /
     +  .172822D+01, .146971D+01, .124757D+01, .105670D+01,
     +  .892757D+00, .752125D+00, .631644D+00, .528635D+00,
     +  .440743D+00, .365974D+00, .302454D+00, .248949D+00,
     +  .203539D+00, .165421D+00, .133551D+00, .107043D+00,
     +  .851077D-01, .670687D-01, .523293D-01, .403828D-01,
     +  .307832D-01, .231244D-01, .171417D-01, .124577D-01,
     +  .887078D-02, .617023D-02, .417518D-02, .273563D-02,
     +  .172354D-02, .103749D-02, .587467D-03, .309773D-03,
     +  .148274D-03, .622898D-04, .216683D-04, .563678D-05,
     +  .893726D-06, .494969D-07, .000000D+00, .657287D+06,
     +  .501894D+06, .377315D+06, .283551D+06, .213024D+06,
     +  .159973D+06, .120097D+06, .901252D+05, .676138D+05,
     +  .507058D+05, .380162D+05, .284923D+05, .213499D+05 /
        DATA (UPDI(I),I=9569,9620) /
     +  .159933D+05, .119791D+05, .897071D+04, .671777D+04,
     +  .503037D+04, .376750D+04, .282214D+04, .211497D+04,
     +  .158579D+04, .119003D+04, .893899D+03, .672398D+03,
     +  .506604D+03, .382599D+03, .288524D+03, .219165D+03,
     +  .167086D+03, .127951D+03, .984690D+02, .762156D+02,
     +  .594070D+02, .466041D+02, .368342D+02, .293453D+02,
     +  .235655D+02, .190776D+02, .155619D+02, .127910D+02,
     +  .105822D+02, .880726D+01, .736723D+01, .618926D+01,
     +  .521713D+01, .441218D+01, .373418D+01, .316741D+01,
     +  .268528D+01, .227786D+01, .193122D+01, .163574D+01,
     +  .138356D+01, .116818D+01, .984229D+00, .827176D+00,
     +  .693251D+00, .579189D+00, .482236D+00, .399989D+00,
     +  .330425D+00, .271659D+00, .222440D+00, .180907D+00 /
        DATA (UPDI(I),I=9621,9672) /
     +  .146244D+00, .117431D+00, .936058D-01, .740071D-01,
     +  .579869D-01, .449775D-01, .344999D-01, .261356D-01,
     +  .195061D-01, .143631D-01, .103653D-01, .732680D-02,
     +  .505704D-02, .339405D-02, .220458D-02, .137603D-02,
     +  .820053D-03, .459283D-03, .239303D-03, .113037D-03,
     +  .467943D-04, .160147D-04, .409522D-05, .641379D-06,
     +  .363194D-07, .000000D+00, .846312D+06, .643818D+06,
     +  .481891D+06, .360532D+06, .269637D+06, .201560D+06,
     +  .150615D+06, .112492D+06, .839890D+05, .626786D+05,
     +  .467593D+05, .348681D+05, .259931D+05, .193697D+05,
     +  .144307D+05, .107479D+05, .800407D+04, .595974D+04,
     +  .443784D+04, .330474D+04, .246179D+04, .183453D+04,
     +  .136807D+04, .102107D+04, .763052D+03, .571074D+03 /
        DATA (UPDI(I),I=9673,9724) /
     +  .428364D+03, .320775D+03, .241954D+03, .183148D+03,
     +  .139242D+03, .106381D+03, .817382D+02, .632479D+02,
     +  .492560D+02, .386491D+02, .305711D+02, .243772D+02,
     +  .195981D+02, .158780D+02, .129640D+02, .106555D+02,
     +  .881156D+01, .732470D+01, .611573D+01, .512406D+01,
     +  .430788D+01, .362461D+01, .305691D+01, .257694D+01,
     +  .217382D+01, .183292D+01, .154409D+01, .129906D+01,
     +  .109103D+01, .914416D+00, .764505D+00, .637415D+00,
     +  .529799D+00, .438848D+00, .362134D+00, .297618D+00,
     +  .243420D+00, .198284D+00, .160412D+00, .128985D+00,
     +  .103013D+00, .816617D-01, .642019D-01, .500158D-01,
     +  .385665D-01, .294035D-01, .221363D-01, .164141D-01,
     +  .120056D-01, .860326D-02, .603661D-02, .413436D-02 /
        DATA (UPDI(I),I=9725,9776) /
     +  .275214D-02, .177212D-02, .109579D-02, .646527D-03,
     +  .358150D-03, .184393D-03, .859584D-04, .350686D-04,
     +  .118100D-04, .296973D-05, .459581D-06, .266021D-07,
     +  .000000D+00, .107592D+07, .815531D+06, .607822D+06,
     +  .452791D+06, .337156D+06, .250914D+06, .186650D+06,
     +  .138770D+06, .103127D+06, .765970D+05, .568684D+05,
     +  .421993D+05, .313021D+05, .232079D+05, .172013D+05,
     +  .127442D+05, .944006D+04, .699069D+04, .517662D+04,
     +  .383306D+04, .283884D+04, .210302D+04, .155886D+04,
     +  .115631D+04, .858697D+03, .638535D+03, .475843D+03,
     +  .353932D+03, .265163D+03, .199346D+03, .150508D+03,
     +  .114187D+03, .871213D+02, .669420D+02, .517682D+02,
     +  .403385D+02, .316881D+02, .250967D+02, .200420D+02 /
        DATA (UPDI(I),I=9777,9828) /
     +  .161313D+02, .130861D+02, .106879D+02, .878359D+01,
     +  .725699D+01, .602290D+01, .501652D+01, .419309D+01,
     +  .350779D+01, .294177D+01, .246605D+01, .206887D+01,
     +  .173499D+01, .145377D+01, .121660D+01, .101641D+01,
     +  .847444D+00, .704850D+00, .584654D+00, .483454D+00,
     +  .398410D+00, .327084D+00, .267434D+00, .217603D+00,
     +  .176335D+00, .141905D+00, .113495D+00, .901520D-01,
     +  .710732D-01, .555637D-01, .430376D-01, .329901D-01,
     +  .249996D-01, .187036D-01, .137786D-01, .100104D-01,
     +  .712302D-02, .496117D-02, .337150D-02, .222596D-02,
     +  .142084D-02, .870376D-03, .508399D-03, .278561D-03,
     +  .141715D-03, .652004D-04, .262167D-04, .868980D-05,
     +  .214943D-05, .328779D-06, .194475D-07, .000000D+00 /
        DATA (UPDI(I),I=9829,9880) /
     +  .135174D+07, .102101D+07, .757819D+06, .562164D+06,
     +  .416818D+06, .308862D+06, .228751D+06, .169315D+06,
     +  .125258D+06, .926090D+05, .684360D+05, .505427D+05,
     +  .373104D+05, .275271D+05, .203008D+05, .149643D+05,
     +  .110272D+05, .812304D+04, .598282D+04, .440577D+04,
     +  .324478D+04, .239005D+04, .176132D+04, .129874D+04,
     +  .958634D+03, .708442D+03, .524622D+03, .387686D+03,
     +  .288566D+03, .215514D+03, .161633D+03, .121807D+03,
     +  .923087D+02, .704514D+02, .541159D+02, .418866D+02,
     +  .326867D+02, .257189D+02, .204068D+02, .163211D+02,
     +  .131577D+02, .106807D+02, .872476D+01, .716564D+01,
     +  .591232D+01, .489600D+01, .406915D+01, .338492D+01,
     +  .282302D+01, .235350D+01, .196375D+01, .163802D+01 /
        DATA (UPDI(I),I=9881,9932) /
     +  .136524D+01, .113652D+01, .944560D+00, .783463D+00,
     +  .648282D+00, .534979D+00, .440118D+00, .360847D+00,
     +  .294733D+00, .239749D+00, .194069D+00, .156449D+00,
     +  .125239D+00, .996317D-01, .787115D-01, .617119D-01,
     +  .479739D-01, .369450D-01, .281526D-01, .212042D-01,
     +  .157648D-01, .115380D-01, .832622D-02, .588283D-02,
     +  .406712D-02, .274246D-02, .179580D-02, .113627D-02,
     +  .689545D-03, .398742D-03, .216095D-03, .108633D-03,
     +  .493298D-04, .195514D-04, .637961D-05, .155273D-05,
     +  .234821D-06, .141901D-07, .000000D+00, .167959D+07,
     +  .126431D+07, .934612D+06, .690480D+06, .509835D+06,
     +  .376200D+06, .277435D+06, .204461D+06, .150595D+06,
     +  .110845D+06, .815407D+05, .599438D+05, .440431D+05 /
        DATA (UPDI(I),I=9933,9984) /
     +  .323398D+05, .237347D+05, .174094D+05, .127646D+05,
     +  .935484D+04, .685421D+04, .502070D+04, .367767D+04,
     +  .269398D+04, .197413D+04, .144732D+04, .106206D+04,
     +  .780191D+03, .574251D+03, .421710D+03, .311929D+03,
     +  .231489D+03, .172503D+03, .129160D+03, .972478D+02,
     +  .737417D+02, .562773D+02, .432802D+02, .335595D+02,
     +  .262399D+02, .206912D+02, .164475D+02, .131798D+02,
     +  .106353D+02, .863677D+01, .705240D+01, .578565D+01,
     +  .476404D+01, .393744D+01, .325721D+01, .270170D+01,
     +  .224014D+01, .185916D+01, .154255D+01, .127891D+01,
     +  .105910D+01, .875667D+00, .722583D+00, .594846D+00,
     +  .488378D+00, .399733D+00, .326067D+00, .264968D+00,
     +  .214435D+00, .172682D+00, .138486D+00, .110275D+00 /
        DATA (UPDI(I),I=9985,10036) /
     +  .872592D-01, .685633D-01, .534587D-01, .413239D-01,
     +  .316401D-01, .239674D-01, .179421D-01, .132559D-01,
     +  .963826D-02, .690845D-02, .484658D-02, .332589D-02,
     +  .222519D-02, .144510D-02, .906368D-03, .544881D-03,
     +  .311930D-03, .167205D-03, .830606D-04, .372285D-04,
     +  .145454D-04, .467324D-05, .111955D-05, .167446D-06,
     +  .103346D-07, .000000D+00, .206529D+07, .154948D+07,
     +  .114089D+07, .839510D+06, .617365D+06, .453676D+06,
     +  .333178D+06, .244505D+06, .179318D+06, .131412D+06,
     +  .962438D+05, .704355D+05, .515159D+05, .376518D+05,
     +  .275030D+05, .200768D+05, .146486D+05, .106823D+05,
     +  .778730D+04, .567483D+04, .413503D+04, .301282D+04,
     +  .219576D+04, .160087D+04, .116810D+04, .853131D+03 /
        DATA (UPDI(I),I=10037,10088) /
     +  .624261D+03, .455671D+03, .335016D+03, .247106D+03,
     +  .183006D+03, .136175D+03, .101891D+03, .767826D+02,
     +  .582340D+02, .445089D+02, .343012D+02, .266577D+02,
     +  .208951D+02, .165117D+02, .131542D+02, .105535D+02,
     +  .852159D+01, .691915D+01, .564465D+01, .462220D+01,
     +  .379933D+01, .312581D+01, .257877D+01, .212675D+01,
     +  .175570D+01, .144906D+01, .119514D+01, .984606D+00,
     +  .809884D+00, .664879D+00, .544552D+00, .444812D+00,
     +  .362225D+00, .293970D+00, .237669D+00, .191358D+00,
     +  .153303D+00, .122307D+00, .968784D-01, .762487D-01,
     +  .595866D-01, .462027D-01, .355132D-01, .270339D-01,
     +  .203566D-01, .151460D-01, .111197D-01, .803203D-02,
     +  .571823D-02, .398312D-02, .271306D-02, .180100D-02 /
        DATA (UPDI(I),I=10089,10140) /
     +  .115997D-02, .721161D-03, .429475D-03, .243397D-03,
     +  .129047D-03, .633479D-04, .280267D-04, .107957D-04,
     +  .341590D-05, .805714D-06, .119217D-06, .751280D-08,
     +  .000000D+00, .251460D+07, .188046D+07, .137923D+07,
     +  .101093D+07, .740479D+06, .541965D+06, .396397D+06,
     +  .289699D+06, .211573D+06, .154393D+06, .112587D+06,
     +  .820357D+05, .597335D+05, .434608D+05, .316006D+05,
     +  .229604D+05, .166731D+05, .121000D+05, .877741D+04,
     +  .636438D+04, .461385D+04, .334426D+04, .242444D+04,
     +  .175809D+04, .127579D+04, .926582D+03, .674167D+03,
     +  .489232D+03, .357598D+03, .262211D+03, .193039D+03,
     +  .142784D+03, .106195D+03, .795485D+02, .599714D+02,
     +  .455650D+02, .349084D+02, .269718D+02, .210196D+02 /
        DATA (UPDI(I),I=10141,10192) /
     +  .165155D+02, .130830D+02, .104378D+02, .838141D+01,
     +  .676791D+01, .549111D+01, .447204D+01, .365615D+01,
     +  .299184D+01, .245515D+01, .201407D+01, .165396D+01,
     +  .135798D+01, .111422D+01, .913219D+00, .747319D+00,
     +  .610389D+00, .497383D+00, .404222D+00, .327503D+00,
     +  .264441D+00, .212708D+00, .170385D+00, .135796D+00,
     +  .107778D+00, .849189D-01, .664781D-01, .516686D-01,
     +  .398410D-01, .304501D-01, .230452D-01, .172499D-01,
     +  .127559D-01, .930586D-02, .667766D-02, .472179D-02,
     +  .326562D-02, .220778D-02, .145411D-02, .928809D-03,
     +  .572377D-03, .337669D-03, .189448D-03, .993495D-04,
     +  .481946D-04, .210486D-04, .799430D-05, .249163D-05,
     +  .578811D-06, .847519D-07, .545175D-08, .000000D+00 /
C-----------------------------------------------------------------------
C
      Dr = DrI
      Fl = FlI
      Al = AlI
      DO I=1,6
         Amass(I) = AmassI(I)
      ENDDO
      Iorder = Nint(Dr)
      Nfl = Nint(Fl)
      Alambda = Al
C
      NX = NxI
      NT = NTI
      NfMx = NfMxI
C
      QINI = QINII
      QMAX = QMAXI
      DO I=0,NT
         QL(I) = QLI(I)
      ENDDO
C
      XMIN = XMINI
      DO I=0,NX
         XV(I) = XVI(I)
      ENDDO
C
      Do 11 Iq = 0, NT
         QL(Iq) = Log (QL(Iq) /Al)
   11 Continue
C
C                  Since quark = anti-quark for nfl>2 at this stage, 
C                  we Read  out only the non-redundent data points
C     No of flavors = NfMx (sea) + 1 (gluon) + 2 (valence) 

      Nblk = (NX+1) * (NT+1)
      Npts =  Nblk  * (NfMx+3)
      DO I=1,Npts
         UPD(I) = UPDI(I)
      ENDDO
C
      Return
C                        ****************************
      End
