C-----------------------------------------------------------------------
#include "pdf/pilot.h"
      Subroutine CTQ5M (Iset)
#include "pdf/impdp.inc"
      PARAMETER (MXX = 105, MXQ = 25, MXF = 6)
      PARAMETER (MXPQX = (MXF *2 +2) * MXQ * MXX)
      PARAMETER (NxI = 90, NtI = 13, NfMxI = 5)
      COMMON / W5051IC / Al, XV(0:MXX), QL(0:MXQ), UPD(MXPQX)
      COMMON / W5051ID / Nx, Nt, NfMx
      COMMON / W5051IE / Qini, Qmax, Xmin
      DIMENSION Amass(6)
      PARAMETER (NSETS=9)
      DIMENSION 
     >  XVI(0:MXX),QLI(0:MXQ),UPDI(MXPQX),
     >  AmassI(6)
C
C-----------------------------------------------------------------------
C Parton Distribution Table : CTEQ5M
C       PARAMETER (ISET = 1)
        DATA  DrI, FlI, AlI /   2.,   5.,  .2260 /
        DATA  (AmassI(I),I=1,6) /     .000,     .000,     .200,
     +                               1.300,    4.500,  180.000 /
C        DATA  NXI,  NTI, NfMxI /    90,    13,     5 /
        DATA  QINII, QMAXI, (QLI(I), I =0, NTI) /
     +  .100000E+01, .100000E+05,
     +  .100000E+01, .130000E+01, .167097E+01, .222659E+01, .309171E+01,
     +  .450000E+01, .754288E+01, .138228E+02, .281243E+02, .646894E+02,
     +  .171811E+03, .540159E+03, .206963E+04, .100000E+05 /
        DATA  XMINI, (XVI(I), I =0, NXI) /
     +  .100000E-04,
     +  .000000E+00, .999983E-05, .124433E-04, .154836E-04, .192668E-04,
     +  .239740E-04, .298310E-04, .371184E-04, .461852E-04, .574656E-04,
     +  .714994E-04, .889575E-04, .110674E-03, .137686E-03, .171280E-03,
     +  .213055E-03, .264997E-03, .329564E-03, .409809E-03, .509508E-03,
     +  .633332E-03, .787053E-03, .977784E-03, .121428E-02, .150728E-02,
     +  .186993E-02, .231825E-02, .288037E-02, .356397E-02, .440443E-02,
     +  .543508E-02, .669508E-02, .822984E-02, .100851E-01, .123281E-01,
     +  .150167E-01, .182174E-01, .219985E-01, .264278E-01, .315720E-01,
     +  .374800E-01, .442088E-01, .517931E-01, .602576E-01, .696136E-01,
     +  .798586E-01, .909356E-01, .102935E+00, .115681E+00, .129293E+00,
     +  .143599E+00, .158606E+00, .174271E+00, .190550E+00, .207405E+00,
     +  .224796E+00, .242685E+00, .261038E+00, .279820E+00, .299001E+00,
     +  .318550E+00, .338442E+00, .358653E+00, .379067E+00, .399881E+00,
     +  .420953E+00, .442266E+00, .463806E+00, .485559E+00, .507513E+00,
     +  .529656E+00, .551978E+00, .574483E+00, .597187E+00, .619860E+00,
     +  .642828E+00, .665921E+00, .689135E+00, .712467E+00, .735911E+00,
     +  .759464E+00, .783080E+00, .806909E+00, .830741E+00, .854673E+00,
     +  .878696E+00, .902804E+00, .926992E+00, .951257E+00, .975603E+00,
     +  .100000E+01 /
C Parton Distribution Table:                                                   
        DATA (UPDI(I),I=1,52) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=53,104) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=105,156) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=157,208) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=209,260) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=261,312) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=313,364) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=365,416) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=417,468) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .214422E+06,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=469,520) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=521,572) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .120235E+06, .917837E+05,
     +  .689611E+05, .517675E+05, .388340E+05, .291028E+05,
     +  .217938E+05, .163031E+05, .121859E+05, .909812E+04,
     +  .678678E+04, .505647E+04, .376371E+04, .279779E+04,
     +  .207761E+04, .154063E+04, .114116E+04, .843969E+03,
     +  .623415E+03, .459738E+03, .338594E+03, .248934E+03,
     +  .182756E+03, .133922E+03, .979833E+02, .715576E+02 /
        DATA (UPDI(I),I=573,624) /
     +  .521947E+02, .378210E+02, .274907E+02, .199425E+02,
     +  .144499E+02, .104518E+02, .755278E+01, .545613E+01,
     +  .393778E+01, .284064E+01, .205103E+01, .148148E+01,
     +  .107221E+01, .777075E+00, .565179E+00, .412066E+00,
     +  .301594E+00, .221449E+00, .163357E+00, .120909E+00,
     +  .900184E-01, .670868E-01, .503364E-01, .377875E-01,
     +  .285026E-01, .215350E-01, .163188E-01, .123776E-01,
     +  .940681E-02, .714575E-02, .543053E-02, .412031E-02,
     +  .312503E-02, .236245E-02, .178246E-02, .133828E-02,
     +  .100060E-02, .744226E-03, .548660E-03, .400014E-03,
     +  .288352E-03, .204464E-03, .142317E-03, .963436E-04,
     +  .630042E-04, .389680E-04, .220802E-04, .104630E-04,
     +  .291420E-05, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=625,676) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .278758E+06, .212089E+06, .158735E+06,
     +  .118696E+06, .886902E+05, .662028E+05, .493777E+05,
     +  .367887E+05, .273856E+05, .203624E+05, .151260E+05,
     +  .112223E+05, .831754E+04, .615639E+04, .455173E+04,
     +  .336045E+04, .247798E+04, .182439E+04, .134143E+04,
     +  .984658E+03, .721767E+03, .528109E+03, .385824E+03,
     +  .281333E+03, .204802E+03, .148800E+03, .107966E+03,
     +  .778122E+02, .562505E+02, .405805E+02, .292364E+02,
     +  .210254E+02, .151031E+02, .108449E+02, .777814E+01,
     +  .557560E+01, .399948E+01, .286986E+01, .206296E+01 /
        DATA (UPDI(I),I=677,728) /
     +  .148490E+01, .107242E+01, .776373E+00, .564138E+00,
     +  .411244E+00, .301132E+00, .221248E+00, .163495E+00,
     +  .120943E+00, .900589E-01, .670988E-01, .502259E-01,
     +  .376618E-01, .283209E-01, .213179E-01, .160767E-01,
     +  .121199E-01, .914113E-02, .688483E-02, .518410E-02,
     +  .389252E-02, .291826E-02, .217893E-02, .162175E-02,
     +  .120252E-02, .885640E-03, .647065E-03, .469418E-03,
     +  .337072E-03, .239707E-03, .168080E-03, .116262E-03,
     +  .788337E-04, .522707E-04, .336362E-04, .210162E-04,
     +  .124421E-04, .688921E-05, .339363E-05, .133392E-05,
     +  .198351E-06, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=729,780) /
     +  .483773E+06, .366824E+06, .273454E+06, .203664E+06,
     +  .151566E+06, .112678E+06, .836973E+05, .621016E+05,
     +  .460357E+05, .340858E+05, .252127E+05, .186257E+05,
     +  .137448E+05, .101290E+05, .745564E+04, .547975E+04,
     +  .402237E+04, .294787E+04, .215740E+04, .157617E+04,
     +  .114982E+04, .837243E+03, .608654E+03, .441601E+03,
     +  .319838E+03, .231177E+03, .166849E+03, .119597E+03,
     +  .859821E+02, .616856E+02, .441876E+02, .315937E+02,
     +  .225593E+02, .161013E+02, .114761E+02, .817453E+01,
     +  .582558E+01, .415276E+01, .296499E+01, .211970E+01,
     +  .152021E+01, .109285E+01, .788435E+00, .570660E+00,
     +  .414831E+00, .302581E+00, .221958E+00, .162997E+00,
     +  .120474E+00, .891006E-01, .661988E-01, .492753E-01 /
        DATA (UPDI(I),I=781,832) /
     +  .367779E-01, .274798E-01, .205681E-01, .153912E-01,
     +  .115219E-01, .861461E-02, .643875E-02, .480016E-02,
     +  .357329E-02, .265021E-02, .195990E-02, .144480E-02,
     +  .105862E-02, .770463E-03, .557617E-03, .400387E-03,
     +  .285556E-03, .201706E-03, .141368E-03, .979748E-04,
     +  .672048E-04, .455647E-04, .307413E-04, .204716E-04,
     +  .135622E-04, .893357E-05, .589274E-05, .389027E-05,
     +  .259190E-05, .173341E-05, .116034E-05, .766148E-06,
     +  .489782E-06, .292867E-06, .156397E-06, .681959E-07,
     +  .196672E-07, .176857E-08, .000000E+00, .744573E+06,
     +  .562628E+06, .417718E+06, .309842E+06, .229635E+06,
     +  .170011E+06, .125756E+06, .929161E+05, .685854E+05,
     +  .505648E+05, .372399E+05, .273908E+05, .201236E+05 /
        DATA (UPDI(I),I=833,884) /
     +  .147638E+05, .108182E+05, .791503E+04, .578318E+04,
     +  .421860E+04, .307282E+04, .223426E+04, .162200E+04,
     +  .117528E+04, .850138E+03, .613696E+03, .442201E+03,
     +  .317949E+03, .228252E+03, .162715E+03, .116336E+03,
     +  .829969E+02, .591130E+02, .420200E+02, .298252E+02,
     +  .211588E+02, .149870E+02, .106082E+02, .751097E+01,
     +  .531922E+01, .377238E+01, .267872E+01, .190787E+01,
     +  .136204E+01, .975709E+00, .701234E+00, .506102E+00,
     +  .366520E+00, .266923E+00, .194613E+00, .142794E+00,
     +  .104847E+00, .773297E-01, .571468E-01, .423418E-01,
     +  .314087E-01, .233363E-01, .173363E-01, .128832E-01,
     +  .956339E-02, .709601E-02, .525282E-02, .388264E-02,
     +  .286020E-02, .210119E-02, .153936E-02, .112137E-02 /
        DATA (UPDI(I),I=885,936) /
     +  .812135E-03, .585461E-03, .419376E-03, .298926E-03,
     +  .211621E-03, .149138E-03, .104429E-03, .728049E-04,
     +  .505649E-04, .352360E-04, .245026E-04, .171245E-04,
     +  .120213E-04, .849848E-05, .602559E-05, .427911E-05,
     +  .301329E-05, .208135E-05, .139018E-05, .879764E-06,
     +  .511741E-06, .261336E-06, .107404E-06, .291025E-07,
     +  .269703E-08, .000000E+00, .107111E+07, .806542E+06,
     +  .596343E+06, .440509E+06, .325114E+06, .239690E+06,
     +  .176545E+06, .129885E+06, .954607E+05, .700734E+05,
     +  .513811E+05, .376251E+05, .275190E+05, .200986E+05,
     +  .146600E+05, .106766E+05, .776458E+04, .563734E+04,
     +  .408664E+04, .295713E+04, .213629E+04, .154028E+04,
     +  .110857E+04, .796189E+03, .570736E+03, .408210E+03 /
        DATA (UPDI(I),I=937,988) /
     +  .291482E+03, .206649E+03, .146932E+03, .104239E+03,
     +  .738166E+02, .521675E+02, .368074E+02, .259552E+02,
     +  .182706E+02, .128513E+02, .904066E+01, .636099E+01,
     +  .448126E+01, .316082E+01, .223589E+01, .158526E+01,
     +  .112772E+01, .804847E+00, .576786E+00, .414770E+00,
     +  .299921E+00, .217128E+00, .158175E+00, .115316E+00,
     +  .844435E-01, .619633E-01, .455824E-01, .335733E-01,
     +  .247655E-01, .182677E-01, .134786E-01, .993510E-02,
     +  .731958E-02, .538089E-02, .394985E-02, .289043E-02,
     +  .210959E-02, .153604E-02, .111250E-02, .801699E-03,
     +  .575537E-03, .411101E-03, .292636E-03, .207359E-03,
     +  .146638E-03, .103390E-03, .728735E-04, .514106E-04,
     +  .365405E-04, .260384E-04, .186990E-04, .135062E-04 /
        DATA (UPDI(I),I=989,1040) /
     +  .980562E-05, .711385E-05, .513303E-05, .364606E-05,
     +  .251802E-05, .166874E-05, .103948E-05, .590936E-06,
     +  .292563E-06, .115525E-06, .299674E-07, .282689E-08,
     +  .000000E+00, .147374E+07, .110583E+07, .814233E+06,
     +  .598953E+06, .440190E+06, .323156E+06, .237004E+06,
     +  .173616E+06, .127046E+06, .928510E+05, .677816E+05,
     +  .494138E+05, .359784E+05, .261578E+05, .189920E+05,
     +  .137675E+05, .996551E+04, .720109E+04, .519523E+04,
     +  .374113E+04, .268940E+04, .192946E+04, .138169E+04,
     +  .987291E+03, .704064E+03, .500918E+03, .355766E+03,
     +  .250839E+03, .177369E+03, .125129E+03, .881044E+02,
     +  .619051E+02, .434193E+02, .304345E+02, .212919E+02,
     +  .148833E+02, .104034E+02, .727276E+01, .508996E+01 /
        DATA (UPDI(I),I=1041,1092) /
     +  .356642E+01, .250580E+01, .176461E+01, .124669E+01,
     +  .883654E+00, .628868E+00, .449086E+00, .322473E+00,
     +  .231831E+00, .167702E+00, .121409E+00, .882817E-01,
     +  .643306E-01, .469928E-01, .343719E-01, .251768E-01,
     +  .184423E-01, .135128E-01, .989208E-02, .723766E-02,
     +  .528492E-02, .385346E-02, .280183E-02, .203209E-02,
     +  .147091E-02, .105947E-02, .759879E-03, .543383E-03,
     +  .387108E-03, .275216E-03, .195172E-03, .138429E-03,
     +  .981701E-04, .698097E-04, .498433E-04, .359347E-04,
     +  .260282E-04, .190031E-04, .139408E-04, .102483E-04,
     +  .749978E-05, .542937E-05, .385009E-05, .263962E-05,
     +  .172826E-05, .105811E-05, .588252E-06, .283053E-06,
     +  .107837E-06, .269161E-07, .257749E-08, .000000E+00 /
        DATA (UPDI(I),I=1093,1144) /
     +  .196300E+07, .146777E+07, .107622E+07, .788360E+06,
     +  .576943E+06, .421750E+06, .307986E+06, .224639E+06,
     +  .163666E+06, .119090E+06, .865502E+05, .628146E+05,
     +  .455291E+05, .329509E+05, .238141E+05, .171830E+05,
     +  .123794E+05, .890300E+04, .639226E+04, .458084E+04,
     +  .327689E+04, .233928E+04, .166673E+04, .118491E+04,
     +  .840628E+03, .594934E+03, .420286E+03, .294709E+03,
     +  .207245E+03, .145394E+03, .101792E+03, .711115E+02,
     +  .495835E+02, .345488E+02, .240232E+02, .166890E+02,
     +  .115921E+02, .805216E+01, .559891E+01, .389740E+01,
     +  .272017E+01, .190278E+01, .133523E+01, .940013E+00,
     +  .664409E+00, .471228E+00, .336057E+00, .239943E+00,
     +  .172376E+00, .123938E+00, .895015E-01, .647760E-01 /
        DATA (UPDI(I),I=1145,1196) /
     +  .469939E-01, .341391E-01, .248349E-01, .180688E-01,
     +  .131493E-01, .956181E-02, .694925E-02, .504131E-02,
     +  .365217E-02, .263913E-02, .190266E-02, .136958E-02,
     +  .981441E-03, .700875E-03, .499457E-03, .355035E-03,
     +  .252212E-03, .179056E-03, .127387E-03, .908342E-04,
     +  .650998E-04, .469427E-04, .342173E-04, .250735E-04,
     +  .185014E-04, .136916E-04, .101209E-04, .742156E-05,
     +  .536047E-05, .377809E-05, .256372E-05, .165528E-05,
     +  .995337E-06, .541181E-06, .253315E-06, .932840E-07,
     +  .224700E-07, .218178E-08, .000000E+00, .254918E+07,
     +  .189941E+07, .138691E+07, .101170E+07, .737260E+06,
     +  .536653E+06, .390214E+06, .283387E+06, .205569E+06,
     +  .148923E+06, .107753E+06, .778534E+05, .561749E+05 /
        DATA (UPDI(I),I=1197,1248) /
     +  .404709E+05, .291145E+05, .209101E+05, .149940E+05,
     +  .107324E+05, .766888E+04, .546916E+04, .389320E+04,
     +  .276551E+04, .196055E+04, .138672E+04, .978746E+03,
     +  .689059E+03, .484200E+03, .337679E+03, .236169E+03,
     +  .164772E+03, .114710E+03, .796795E+02, .552347E+02,
     +  .382601E+02, .264437E+02, .182585E+02, .126034E+02,
     +  .869968E+01, .601050E+01, .415695E+01, .288235E+01,
     +  .200297E+01, .139619E+01, .976393E+00, .685493E+00,
     +  .482918E+00, .342081E+00, .242601E+00, .173109E+00,
     +  .123628E+00, .886769E-01, .637511E-01, .459402E-01,
     +  .331517E-01, .239553E-01, .173137E-01, .125167E-01,
     +  .904276E-02, .652953E-02, .470707E-02, .338898E-02,
     +  .243459E-02, .174530E-02, .124982E-02, .891436E-03 /
        DATA (UPDI(I),I=1249,1300) /
     +  .634162E-03, .450600E-03, .319783E-03, .227116E-03,
     +  .161492E-03, .115272E-03, .826350E-04, .596449E-04,
     +  .433696E-04, .318856E-04, .235589E-04, .174996E-04,
     +  .130071E-04, .962747E-05, .704669E-05, .506217E-05,
     +  .353746E-05, .237191E-05, .150860E-05, .890534E-06,
     +  .473530E-06, .215712E-06, .768745E-07, .179106E-07,
     +  .176218E-08, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1301,1352) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1353,1404) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .271895E+05, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1405,1456) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1457,1508) /
     +  .282254E+05, .220920E+05, .170848E+05, .132037E+05,
     +  .101993E+05, .787273E+04, .607358E+04, .468190E+04,
     +  .360696E+04, .277643E+04, .213574E+04, .164136E+04,
     +  .126052E+04, .967045E+03, .741328E+03, .567649E+03,
     +  .434298E+03, .331857E+03, .253349E+03, .193151E+03,
     +  .147118E+03, .111895E+03, .850174E+02, .644969E+02,
     +  .488760E+02, .369845E+02, .279646E+02, .210258E+02,
     +  .158590E+02, .119433E+02, .899039E+01, .675906E+01,
     +  .508085E+01, .381954E+01, .287152E+01, .215874E+01,
     +  .162585E+01, .122540E+01, .926237E+00, .701201E+00,
     +  .533104E+00, .406284E+00, .311009E+00, .238772E+00,
     +  .184243E+00, .142575E+00, .110990E+00, .864523E-01,
     +  .677980E-01, .531689E-01, .418947E-01, .330419E-01 /
        DATA (UPDI(I),I=1509,1560) /
     +  .261421E-01, .206908E-01, .164139E-01, .130088E-01,
     +  .103178E-01, .816837E-02, .646901E-02, .510668E-02,
     +  .402746E-02, .316293E-02, .247738E-02, .193364E-02,
     +  .149982E-02, .115377E-02, .881273E-03, .666098E-03,
     +  .498438E-03, .367366E-03, .266629E-03, .189098E-03,
     +  .130747E-03, .866058E-04, .548858E-04, .317713E-04,
     +  .157753E-04, .506605E-05, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .688052E+05,
     +  .536001E+05, .412288E+05, .316912E+05, .243477E+05,
     +  .186918E+05, .143418E+05, .109952E+05, .842446E+04,
     +  .644910E+04, .493363E+04, .377068E+04, .287977E+04 /
        DATA (UPDI(I),I=1561,1612) /
     +  .219707E+04, .167488E+04, .127535E+04, .970290E+03,
     +  .737273E+03, .559687E+03, .424300E+03, .321347E+03,
     +  .243023E+03, .183592E+03, .138481E+03, .104335E+03,
     +  .784916E+02, .590000E+02, .440950E+02, .330593E+02,
     +  .247470E+02, .185134E+02, .138324E+02, .103316E+02,
     +  .771717E+01, .576326E+01, .430385E+01, .321902E+01,
     +  .240936E+01, .180804E+01, .135892E+01, .102546E+01,
     +  .775712E+00, .589254E+00, .448966E+00, .343732E+00,
     +  .263952E+00, .203862E+00, .157571E+00, .122593E+00,
     +  .953981E-01, .745780E-01, .583698E-01, .458221E-01,
     +  .359931E-01, .283340E-01, .222895E-01, .175480E-01,
     +  .137947E-01, .108487E-01, .850890E-02, .666969E-02,
     +  .520982E-02, .406180E-02, .315886E-02, .244471E-02 /
        DATA (UPDI(I),I=1613,1664) /
     +  .188032E-02, .143962E-02, .109449E-02, .827453E-03,
     +  .620010E-03, .461279E-03, .339461E-03, .247422E-03,
     +  .177528E-03, .126420E-03, .882201E-04, .606213E-04,
     +  .407370E-04, .268017E-04, .171262E-04, .106388E-04,
     +  .636839E-05, .365101E-05, .198629E-05, .101929E-05,
     +  .481255E-06, .206413E-06, .762546E-07, .201626E-07,
     +  .835994E-09, .000000E+00, .124286E+06, .963969E+05,
     +  .737765E+05, .564247E+05, .431314E+05, .329446E+05,
     +  .251493E+05, .191827E+05, .146225E+05, .111364E+05,
     +  .847559E+04, .644427E+04, .489612E+04, .371597E+04,
     +  .281797E+04, .213451E+04, .161538E+04, .122096E+04,
     +  .921936E+03, .695199E+03, .523684E+03, .393909E+03,
     +  .295959E+03, .222021E+03, .166353E+03, .124453E+03 /
        DATA (UPDI(I),I=1665,1716) /
     +  .930218E+02, .691232E+02, .515252E+02, .383468E+02,
     +  .285176E+02, .211801E+02, .157228E+02, .116720E+02,
     +  .866129E+01, .642666E+01, .477494E+01, .355022E+01,
     +  .264587E+01, .197501E+01, .147981E+01, .111152E+01,
     +  .838229E+00, .634094E+00, .481903E+00, .367378E+00,
     +  .281651E+00, .216126E+00, .166908E+00, .128945E+00,
     +  .100064E+00, .777590E-01, .606002E-01, .472646E-01,
     +  .369382E-01, .288543E-01, .225552E-01, .176095E-01,
     +  .137523E-01, .107144E-01, .834235E-02, .647506E-02,
     +  .501691E-02, .387873E-02, .298514E-02, .228493E-02,
     +  .174221E-02, .132057E-02, .996545E-03, .746738E-03,
     +  .556711E-03, .411795E-03, .302687E-03, .220219E-03,
     +  .159808E-03, .114582E-03, .816392E-04, .575750E-04 /
        DATA (UPDI(I),I=1717,1768) /
     +  .403122E-04, .278936E-04, .191340E-04, .129238E-04,
     +  .856175E-05, .551300E-05, .341056E-05, .197297E-05,
     +  .103083E-05, .451291E-06, .135517E-06, .113833E-07,
     +  .000000E+00, .170868E+06, .152767E+06, .116363E+06,
     +  .885703E+05, .673793E+05, .512180E+05, .389099E+05,
     +  .295347E+05, .224037E+05, .169791E+05, .128587E+05,
     +  .972863E+04, .735476E+04, .555417E+04, .419083E+04,
     +  .315845E+04, .237817E+04, .178837E+04, .134347E+04,
     +  .100786E+04, .755271E+03, .565149E+03, .422386E+03,
     +  .315189E+03, .234899E+03, .174787E+03, .129930E+03,
     +  .960107E+02, .711669E+02, .526670E+02, .389417E+02,
     +  .287545E+02, .212185E+02, .156577E+02, .115473E+02,
     +  .851488E+01, .628596E+01, .464366E+01, .343789E+01 /
        DATA (UPDI(I),I=1769,1820) /
     +  .254922E+01, .189707E+01, .141527E+01, .105989E+01,
     +  .796269E+00, .600910E+00, .454932E+00, .346327E+00,
     +  .263922E+00, .202387E+00, .155276E+00, .119657E+00,
     +  .923523E-01, .714763E-01, .553706E-01, .429751E-01,
     +  .333443E-01, .258881E-01, .200779E-01, .155744E-01,
     +  .120550E-01, .932428E-02, .719125E-02, .553644E-02,
     +  .425400E-02, .325408E-02, .247681E-02, .187849E-02,
     +  .141721E-02, .106504E-02, .795557E-03, .591794E-03,
     +  .437435E-03, .321795E-03, .234909E-03, .171356E-03,
     +  .123909E-03, .892915E-04, .639197E-04, .455569E-04,
     +  .321890E-04, .225770E-04, .156032E-04, .105612E-04,
     +  .692930E-05, .434384E-05, .253076E-05, .131953E-05,
     +  .569363E-06, .166453E-06, .145059E-07, .000000E+00 /
        DATA (UPDI(I),I=1821,1872) /
     +  .313432E+06, .240970E+06, .182565E+06, .138218E+06,
     +  .104580E+06, .790668E+05, .597386E+05, .450971E+05,
     +  .340200E+05, .256403E+05, .193097E+05, .145278E+05,
     +  .109209E+05, .820066E+04, .615234E+04, .461025E+04,
     +  .345122E+04, .258027E+04, .192700E+04, .143714E+04,
     +  .107055E+04, .796288E+03, .591533E+03, .438732E+03,
     +  .324955E+03, .240297E+03, .177500E+03, .130319E+03,
     +  .959719E+02, .705631E+02, .518262E+02, .380125E+02,
     +  .278571E+02, .204149E+02, .149483E+02, .109440E+02,
     +  .801954E+01, .588061E+01, .432051E+01, .317940E+01,
     +  .234758E+01, .173779E+01, .129111E+01, .962391E+00,
     +  .720468E+00, .541159E+00, .408685E+00, .309007E+00,
     +  .235072E+00, .178949E+00, .136810E+00, .104781E+00 /
        DATA (UPDI(I),I=1873,1924) /
     +  .804600E-01, .618530E-01, .476289E-01, .366711E-01,
     +  .282465E-01, .217370E-01, .167250E-01, .128418E-01,
     +  .984900E-02, .753145E-02, .574576E-02, .437328E-02,
     +  .331096E-02, .249275E-02, .186788E-02, .139070E-02,
     +  .102952E-02, .756125E-03, .551500E-03, .398475E-03,
     +  .285358E-03, .201881E-03, .141929E-03, .982626E-04,
     +  .672888E-04, .454137E-04, .302676E-04, .198458E-04,
     +  .128358E-04, .815010E-05, .506845E-05, .306636E-05,
     +  .178921E-05, .981617E-06, .490558E-06, .206317E-06,
     +  .596740E-07, .495448E-08, .000000E+00, .467471E+06,
     +  .357777E+06, .269645E+06, .203075E+06, .152842E+06,
     +  .114942E+06, .863803E+05, .648594E+05, .486637E+05,
     +  .364780E+05, .273214E+05, .204425E+05, .152820E+05 /
        DATA (UPDI(I),I=1925,1976) /
     +  .114117E+05, .851326E+04, .634345E+04, .472166E+04,
     +  .350993E+04, .260616E+04, .193238E+04, .143102E+04,
     +  .105813E+04, .781358E+03, .576044E+03, .424064E+03,
     +  .311659E+03, .228779E+03, .166898E+03, .122126E+03,
     +  .892162E+02, .650963E+02, .474300E+02, .345235E+02,
     +  .251283E+02, .182709E+02, .132824E+02, .966278E+01,
     +  .703421E+01, .512970E+01, .374681E+01, .274554E+01,
     +  .201698E+01, .148698E+01, .109991E+01, .817021E+00,
     +  .608960E+00, .456320E+00, .342376E+00, .258433E+00,
     +  .195225E+00, .148099E+00, .112568E+00, .857759E-01,
     +  .654410E-01, .500042E-01, .382090E-01, .292062E-01,
     +  .223067E-01, .170319E-01, .129794E-01, .987882E-02,
     +  .749810E-02, .567727E-02, .428925E-02, .322328E-02 /
        DATA (UPDI(I),I=1977,2028) /
     +  .240958E-02, .179311E-02, .132649E-02, .976066E-03,
     +  .713157E-03, .517878E-03, .373057E-03, .266732E-03,
     +  .188896E-03, .133250E-03, .929195E-04, .643370E-04,
     +  .441401E-04, .300591E-04, .202645E-04, .135388E-04,
     +  .891917E-05, .575909E-05, .361257E-05, .216887E-05,
     +  .121164E-05, .605165E-06, .248027E-06, .680466E-07,
     +  .598517E-08, .000000E+00, .668093E+06, .509087E+06,
     +  .381728E+06, .286016E+06, .214158E+06, .160219E+06,
     +  .119778E+06, .894647E+05, .667701E+05, .497844E+05,
     +  .370878E+05, .276004E+05, .205208E+05, .152400E+05,
     +  .113066E+05, .837810E+04, .620123E+04, .458385E+04,
     +  .338421E+04, .249492E+04, .183693E+04, .135036E+04,
     +  .991278E+03, .726467E+03, .531590E+03, .388308E+03 /
        DATA (UPDI(I),I=2029,2080) /
     +  .283290E+03, .205362E+03, .149325E+03, .108393E+03,
     +  .785762E+02, .568772E+02, .411238E+02, .297312E+02,
     +  .214688E+02, .154988E+02, .111951E+02, .809150E+01,
     +  .585775E+01, .424732E+01, .308915E+01, .225251E+01,
     +  .164810E+01, .120995E+01, .891932E+00, .659779E+00,
     +  .490657E+00, .365370E+00, .273698E+00, .205205E+00,
     +  .154497E+00, .116560E+00, .881525E-01, .667564E-01,
     +  .506272E-01, .383992E-01, .291333E-01, .220876E-01,
     +  .167392E-01, .126631E-01, .956691E-02, .720884E-02,
     +  .541847E-02, .406442E-02, .303253E-02, .225154E-02,
     +  .166445E-02, .122377E-02, .895348E-03, .650989E-03,
     +  .470810E-03, .338214E-03, .241504E-03, .171199E-03,
     +  .121138E-03, .849997E-04, .593976E-04, .412807E-04 /
        DATA (UPDI(I),I=2081,2132) /
     +  .285644E-04, .196282E-04, .133843E-04, .900427E-05,
     +  .592495E-05, .377540E-05, .228850E-05, .128221E-05,
     +  .635900E-06, .255774E-06, .682184E-07, .617645E-08,
     +  .000000E+00, .924585E+06, .701534E+06, .523408E+06,
     +  .390207E+06, .290699E+06, .216378E+06, .160934E+06,
     +  .119586E+06, .887874E+05, .658548E+05, .488014E+05,
     +  .361251E+05, .267154E+05, .197336E+05, .145609E+05,
     +  .107306E+05, .789865E+04, .580611E+04, .426255E+04,
     +  .312469E+04, .228747E+04, .167189E+04, .122016E+04,
     +  .888953E+03, .646625E+03, .469493E+03, .340432E+03,
     +  .245248E+03, .177216E+03, .127829E+03, .920726E+02,
     +  .662155E+02, .475602E+02, .341561E+02, .244965E+02,
     +  .175632E+02, .125977E+02, .904109E+01, .649834E+01 /
        DATA (UPDI(I),I=2133,2184) /
     +  .467788E+01, .337747E+01, .244472E+01, .177552E+01,
     +  .129388E+01, .946714E+00, .695118E+00, .513105E+00,
     +  .379265E+00, .282000E+00, .209874E+00, .156848E+00,
     +  .117473E+00, .881923E-01, .663020E-01, .499147E-01,
     +  .375851E-01, .283087E-01, .213084E-01, .160318E-01,
     +  .120415E-01, .903210E-02, .675804E-02, .504385E-02,
     +  .375728E-02, .278422E-02, .205373E-02, .150876E-02,
     +  .110292E-02, .802695E-03, .581041E-03, .418722E-03,
     +  .300107E-03, .214117E-03, .151968E-03, .107857E-03,
     +  .761028E-04, .535932E-04, .376238E-04, .263359E-04,
     +  .183261E-04, .126462E-04, .859776E-05, .569887E-05,
     +  .364392E-05, .220442E-05, .122562E-05, .598481E-06,
     +  .234857E-06, .607809E-07, .561580E-08, .000000E+00 /
        DATA (UPDI(I),I=2185,2236) /
     +  .124689E+07, .942152E+06, .699497E+06, .518925E+06,
     +  .384679E+06, .284904E+06, .210838E+06, .155876E+06,
     +  .115141E+06, .849629E+05, .626354E+05, .461238E+05,
     +  .339301E+05, .249300E+05, .182968E+05, .134110E+05,
     +  .981800E+04, .717741E+04, .524012E+04, .381986E+04,
     +  .278061E+04, .202075E+04, .146628E+04, .106206E+04,
     +  .768007E+03, .554303E+03, .399508E+03, .286031E+03,
     +  .205413E+03, .147246E+03, .105388E+03, .753067E+02,
     +  .537383E+02, .383398E+02, .273129E+02, .194500E+02,
     +  .138549E+02, .987443E+01, .704733E+01, .503715E+01,
     +  .361078E+01, .259480E+01, .187085E+01, .135348E+01,
     +  .983099E+00, .716586E+00, .525110E+00, .385325E+00,
     +  .284424E+00, .210150E+00, .155921E+00, .115945E+00 /
        DATA (UPDI(I),I=2237,2288) /
     +  .864216E-01, .645087E-01, .482172E-01, .360499E-01,
     +  .269599E-01, .201508E-01, .150540E-01, .112285E-01,
     +  .836371E-02, .621530E-02, .460725E-02, .340926E-02,
     +  .250988E-02, .183996E-02, .134383E-02, .977140E-03,
     +  .707775E-03, .510342E-03, .366681E-03, .262364E-03,
     +  .187148E-03, .133039E-03, .947250E-04, .671842E-04,
     +  .476300E-04, .337069E-04, .237931E-04, .166930E-04,
     +  .115949E-04, .791732E-05, .525238E-05, .334863E-05,
     +  .201014E-05, .110335E-05, .528323E-06, .201685E-06,
     +  .505777E-07, .475370E-08, .000000E+00, .164537E+07,
     +  .123820E+07, .914898E+06, .675454E+06, .498283E+06,
     +  .367239E+06, .270428E+06, .198939E+06, .146214E+06,
     +  .107348E+06, .787346E+05, .576815E+05, .422126E+05 /
        DATA (UPDI(I),I=2289,2340) /
     +  .308537E+05, .225250E+05, .164225E+05, .119582E+05,
     +  .869471E+04, .631321E+04, .457676E+04, .331304E+04,
     +  .239415E+04, .172736E+04, .124399E+04, .894350E+03,
     +  .641690E+03, .459741E+03, .327151E+03, .233515E+03,
     +  .166362E+03, .118326E+03, .840186E+02, .595706E+02,
     +  .422258E+02, .298828E+02, .211381E+02, .149555E+02,
     +  .105860E+02, .750285E+01, .532538E+01, .379050E+01,
     +  .270469E+01, .193620E+01, .139079E+01, .100298E+01,
     +  .725856E+00, .528115E+00, .384771E+00, .281994E+00,
     +  .206878E+00, .152408E+00, .112539E+00, .832941E-01,
     +  .617407E-01, .458253E-01, .340241E-01, .252688E-01,
     +  .187573E-01, .139167E-01, .103100E-01, .762780E-02,
     +  .563106E-02, .414684E-02, .304907E-02, .223084E-02 /
        DATA (UPDI(I),I=2341,2392) /
     +  .162592E-02, .118107E-02, .854644E-03, .616445E-03,
     +  .443023E-03, .317570E-03, .226987E-03, .161976E-03,
     +  .115375E-03, .824231E-04, .587426E-04, .418852E-04,
     +  .298281E-04, .211794E-04, .149320E-04, .104001E-04,
     +  .710305E-05, .469710E-05, .297438E-05, .176580E-05,
     +  .954109E-06, .447022E-06, .165790E-06, .402861E-07,
     +  .384545E-08, .000000E+00, .213054E+07, .159696E+07,
     +  .117444E+07, .862982E+06, .633592E+06, .464723E+06,
     +  .340558E+06, .249308E+06, .182332E+06, .133201E+06,
     +  .972077E+05, .708558E+05, .515897E+05, .375139E+05,
     +  .272454E+05, .197602E+05, .143125E+05, .103511E+05,
     +  .747550E+04, .538995E+04, .388028E+04, .278854E+04,
     +  .200064E+04, .143265E+04, .102409E+04, .730513E+03 /
        DATA (UPDI(I),I=2393,2444) /
     +  .520309E+03, .368028E+03, .261117E+03, .184899E+03,
     +  .130702E+03, .922295E+02, .649791E+02, .457660E+02,
     +  .321779E+02, .226122E+02, .158918E+02, .111732E+02,
     +  .786518E+01, .554432E+01, .391904E+01, .277699E+01,
     +  .197407E+01, .140809E+01, .100833E+01, .724614E+00,
     +  .523529E+00, .378763E+00, .275654E+00, .200820E+00,
     +  .146920E+00, .107742E+00, .791949E-01, .583010E-01,
     +  .429759E-01, .316921E-01, .233777E-01, .172374E-01,
     +  .127035E-01, .934931E-02, .687188E-02, .504072E-02,
     +  .368878E-02, .269584E-02, .196089E-02, .142143E-02,
     +  .102741E-02, .740222E-03, .531971E-03, .381284E-03,
     +  .272851E-03, .194941E-03, .139237E-03, .994077E-04,
     +  .712565E-04, .510079E-04, .365438E-04, .261458E-04 /
        DATA (UPDI(I),I=2445,2496) /
     +  .186339E-04, .131666E-04, .916893E-05, .624494E-05,
     +  .410488E-05, .257519E-05, .150870E-05, .801026E-06,
     +  .366743E-06, .132075E-06, .311179E-07, .301356E-08,
     +  .000000E+00, .271272E+07, .202548E+07, .148273E+07,
     +  .108447E+07, .792489E+06, .578536E+06, .421949E+06,
     +  .307413E+06, .223741E+06, .162656E+06, .118120E+06,
     +  .856723E+05, .620653E+05, .449035E+05, .324460E+05,
     +  .234110E+05, .168688E+05, .121360E+05, .871809E+04,
     +  .625229E+04, .447678E+04, .319967E+04, .228295E+04,
     +  .162571E+04, .115555E+04, .819568E+03, .580369E+03,
     +  .408082E+03, .287827E+03, .202598E+03, .142346E+03,
     +  .998317E+02, .698982E+02, .489219E+02, .341772E+02,
     +  .238623E+02, .166606E+02, .116364E+02, .813655E+01 /
        DATA (UPDI(I),I=2497,2548) /
     +  .569705E+01, .399966E+01, .281480E+01, .198723E+01,
     +  .140775E+01, .100115E+01, .714510E+00, .512693E+00,
     +  .368377E+00, .266261E+00, .192655E+00, .139989E+00,
     +  .101967E+00, .744448E-01, .544370E-01, .398586E-01,
     +  .291984E-01, .213958E-01, .156730E-01, .114754E-01,
     +  .839156E-02, .612899E-02, .446821E-02, .325014E-02,
     +  .236161E-02, .170837E-02, .123217E-02, .886593E-03,
     +  .636320E-03, .455894E-03, .326070E-03, .233085E-03,
     +  .166551E-03, .119122E-03, .852588E-04, .613133E-04,
     +  .440582E-04, .316822E-04, .227382E-04, .162342E-04,
     +  .114709E-04, .796853E-05, .540021E-05, .352111E-05,
     +  .218448E-05, .126108E-05, .657128E-06, .293769E-06,
     +  .102718E-06, .234881E-07, .230613E-08, .000000E+00 /
        DATA (UPDI(I),I=2549,2600) /
     +  .857730E+04, .291927E+04, .240499E+04, .198131E+04,
     +  .163227E+04, .134472E+04, .110784E+04, .912684E+03,
     +  .751912E+03, .619465E+03, .510352E+03, .420461E+03,
     +  .346408E+03, .285401E+03, .235142E+03, .193737E+03,
     +  .159627E+03, .131526E+03, .108376E+03, .893039E+02,
     +  .735919E+02, .606479E+02, .499840E+02, .411987E+02,
     +  .339608E+02, .279978E+02, .230850E+02, .189853E+02,
     +  .156607E+02, .129211E+02, .106634E+02, .880266E+01,
     +  .726893E+01, .600804E+01, .496569E+01, .410646E+01,
     +  .339793E+01, .281339E+01, .233084E+01, .193200E+01,
     +  .160251E+01, .132954E+01, .110322E+01, .915302E+00,
     +  .759064E+00, .629009E+00, .521010E+00, .430373E+00,
     +  .355206E+00, .292106E+00, .239692E+00, .196028E+00 /
        DATA (UPDI(I),I=2601,2652) /
     +  .159711E+00, .129569E+00, .104618E+00, .840318E-01,
     +  .671115E-01, .532660E-01, .419931E-01, .328660E-01,
     +  .255216E-01, .196513E-01, .149934E-01, .113419E-01,
     +  .847421E-02, .625870E-02, .456465E-02, .328383E-02,
     +  .232734E-02, .162264E-02, .111112E-02, .745879E-03,
     +  .489644E-03, .313375E-03, .195836E-03, .118265E-03,
     +  .689465E-04, .385977E-04, .206139E-04, .104167E-04,
     +  .492817E-05, .215592E-05, .850828E-06, .297368E-06,
     +  .882149E-07, .209225E-07, .358885E-08, .368880E-09,
     +  .148929E-10, .611719E-13, .000000E+00, .200975E+05,
     +  .191415E+05, .151250E+05, .119486E+05, .943938E+04,
     +  .745535E+04, .588844E+04, .464972E+04, .367171E+04,
     +  .289869E+04, .228853E+04, .180635E+04, .142588E+04 /
        DATA (UPDI(I),I=2653,2704) /
     +  .112526E+04, .888128E+03, .700797E+03, .553073E+03,
     +  .436390E+03, .344402E+03, .271756E+03, .214507E+03,
     +  .169301E+03, .133680E+03, .105553E+03, .833911E+02,
     +  .658969E+02, .521160E+02, .410953E+02, .325480E+02,
     +  .257911E+02, .204651E+02, .162514E+02, .129266E+02,
     +  .102998E+02, .821910E+01, .656820E+01, .526173E+01,
     +  .422202E+01, .339658E+01, .273692E+01, .221149E+01,
     +  .178950E+01, .145107E+01, .117786E+01, .957555E+00,
     +  .778683E+00, .634152E+00, .515458E+00, .419454E+00,
     +  .340361E+00, .276044E+00, .223331E+00, .180292E+00,
     +  .145068E+00, .116366E+00, .929439E-01, .739321E-01,
     +  .585093E-01, .460808E-01, .360734E-01, .280775E-01,
     +  .217043E-01, .166624E-01, .127092E-01, .959994E-02 /
        DATA (UPDI(I),I=2705,2756) /
     +  .718229E-02, .532129E-02, .389760E-02, .282047E-02,
     +  .201103E-02, .141067E-02, .968503E-03, .648697E-03,
     +  .418253E-03, .258145E-03, .146734E-03, .718602E-04,
     +  .234990E-04, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .520207E+05, .410700E+05,
     +  .320794E+05, .250490E+05, .195562E+05, .152627E+05,
     +  .119099E+05, .929032E+04, .724571E+04, .564899E+04,
     +  .440342E+04, .343118E+04, .267320E+04, .208184E+04,
     +  .162109E+04, .126181E+04, .982060E+03, .764028E+03,
     +  .594366E+03, .462213E+03, .359457E+03, .279462E+03,
     +  .217295E+03, .168922E+03, .131349E+03, .102135E+03 /
        DATA (UPDI(I),I=2757,2808) /
     +  .794662E+02, .616170E+02, .479860E+02, .373837E+02,
     +  .291580E+02, .227586E+02, .177904E+02, .139324E+02,
     +  .109271E+02, .858410E+01, .676117E+01, .533581E+01,
     +  .422334E+01, .334976E+01, .266562E+01, .212550E+01,
     +  .169934E+01, .136094E+01, .109231E+01, .877551E+00,
     +  .706558E+00, .568108E+00, .457668E+00, .367849E+00,
     +  .295705E+00, .237269E+00, .190084E+00, .151872E+00,
     +  .121038E+00, .961050E-01, .760352E-01, .598829E-01,
     +  .469615E-01, .366252E-01, .284164E-01, .219083E-01,
     +  .167833E-01, .127817E-01, .964368E-02, .720947E-02,
     +  .533912E-02, .391000E-02, .282942E-02, .201723E-02,
     +  .141443E-02, .970133E-03, .648326E-03, .416217E-03,
     +  .255127E-03, .143162E-03, .685240E-04, .213575E-04 /
        DATA (UPDI(I),I=2809,2860) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .924115E+05, .724258E+05, .561021E+05,
     +  .434402E+05, .336279E+05, .260209E+05, .201296E+05,
     +  .155651E+05, .120325E+05, .929730E+04, .718189E+04,
     +  .554509E+04, .428015E+04, .330209E+04, .254684E+04,
     +  .196331E+04, .151309E+04, .116549E+04, .897534E+03,
     +  .690831E+03, .531648E+03, .408956E+03, .314547E+03,
     +  .241838E+03, .185938E+03, .142933E+03, .109917E+03,
     +  .842046E+02, .647836E+02, .498507E+02, .383954E+02,
     +  .295893E+02, .228322E+02, .176499E+02, .136616E+02,
     +  .105919E+02, .823321E+01, .641304E+01, .501042E+01 /
        DATA (UPDI(I),I=2861,2912) /
     +  .392364E+01, .308341E+01, .242886E+01, .191895E+01,
     +  .151934E+01, .120606E+01, .958742E+00, .764175E+00,
     +  .608512E+00, .485749E+00, .387020E+00, .308549E+00,
     +  .245646E+00, .195344E+00, .154996E+00, .122722E+00,
     +  .968479E-01, .761850E-01, .596843E-01, .465778E-01,
     +  .361656E-01, .279487E-01, .214736E-01, .164020E-01,
     +  .124624E-01, .938695E-02, .701122E-02, .519266E-02,
     +  .380771E-02, .276341E-02, .198013E-02, .139962E-02,
     +  .972161E-03, .662138E-03, .438261E-03, .282217E-03,
     +  .172922E-03, .993111E-04, .519365E-04, .268039E-04,
     +  .171262E-04, .106388E-04, .636839E-05, .365101E-05,
     +  .198629E-05, .101929E-05, .481255E-06, .206413E-06,
     +  .762546E-07, .201626E-07, .835994E-09, .000000E+00 /
        DATA (UPDI(I),I=2913,2964) /
     +  .147713E+06, .115078E+06, .885349E+05, .680825E+05,
     +  .523390E+05, .402160E+05, .308912E+05, .237161E+05,
     +  .182015E+05, .139615E+05, .107054E+05, .820404E+04,
     +  .628482E+04, .481171E+04, .368251E+04, .281657E+04,
     +  .215345E+04, .164541E+04, .125676E+04, .959311E+03,
     +  .732037E+03, .558275E+03, .425645E+03, .324351E+03,
     +  .247117E+03, .188209E+03, .143372E+03, .108765E+03,
     +  .828578E+02, .631221E+02, .481208E+02, .366997E+02,
     +  .280192E+02, .214284E+02, .164061E+02, .125807E+02,
     +  .967130E+01, .745030E+01, .575670E+01, .445894E+01,
     +  .346629E+01, .270161E+01, .211228E+01, .165556E+01,
     +  .130129E+01, .102465E+01, .809259E+00, .638734E+00,
     +  .505578E+00, .399555E+00, .316071E+00, .249777E+00 /
        DATA (UPDI(I),I=2965,3016) /
     +  .197224E+00, .155437E+00, .122281E+00, .959129E-01,
     +  .750115E-01, .584440E-01, .453734E-01, .350600E-01,
     +  .269714E-01, .206363E-01, .157019E-01, .118893E-01,
     +  .892784E-02, .665123E-02, .491631E-02, .360067E-02,
     +  .261237E-02, .187371E-02, .132790E-02, .927130E-03,
     +  .636882E-03, .427687E-03, .281778E-03, .179418E-03,
     +  .110235E-03, .653778E-04, .403146E-04, .278936E-04,
     +  .191340E-04, .129238E-04, .856175E-05, .551300E-05,
     +  .341056E-05, .197297E-05, .103083E-05, .451291E-06,
     +  .135517E-06, .113833E-07, .000000E+00, .164009E+06,
     +  .171310E+06, .131011E+06, .100141E+06, .765171E+05,
     +  .584341E+05, .446077E+05, .340330E+05, .259548E+05,
     +  .197820E+05, .150708E+05, .114743E+05, .873223E+04 /
        DATA (UPDI(I),I=3017,3068) /
     +  .664098E+04, .504824E+04, .383481E+04, .291169E+04,
     +  .220918E+04, .167538E+04, .126963E+04, .961737E+03,
     +  .727995E+03, .550838E+03, .416517E+03, .314844E+03,
     +  .237871E+03, .179724E+03, .135192E+03, .102114E+03,
     +  .771182E+02, .582698E+02, .440396E+02, .333133E+02,
     +  .252401E+02, .191406E+02, .145369E+02, .110666E+02,
     +  .844223E+01, .645938E+01, .495461E+01, .381439E+01,
     +  .294461E+01, .228062E+01, .177110E+01, .137960E+01,
     +  .107684E+01, .843279E+00, .660122E+00, .518373E+00,
     +  .406533E+00, .319219E+00, .250483E+00, .196432E+00,
     +  .153802E+00, .120232E+00, .937366E-01, .728834E-01,
     +  .564714E-01, .436081E-01, .335253E-01, .256659E-01,
     +  .195478E-01, .148091E-01, .111677E-01, .835393E-02 /
        DATA (UPDI(I),I=3069,3120) /
     +  .620219E-02, .457037E-02, .333881E-02, .241769E-02,
     +  .173221E-02, .122763E-02, .858544E-03, .592019E-03,
     +  .400568E-03, .267192E-03, .173733E-03, .110529E-03,
     +  .694117E-04, .455592E-04, .321890E-04, .225770E-04,
     +  .156032E-04, .105612E-04, .692930E-05, .434384E-05,
     +  .253076E-05, .131953E-05, .569363E-06, .166453E-06,
     +  .145059E-07, .000000E+00, .336489E+06, .259355E+06,
     +  .197088E+06, .149688E+06, .113639E+06, .862194E+05,
     +  .653858E+05, .495552E+05, .375390E+05, .284177E+05,
     +  .215016E+05, .162573E+05, .122855E+05, .927719E+04,
     +  .700154E+04, .528006E+04, .397949E+04, .299688E+04,
     +  .225553E+04, .169620E+04, .127483E+04, .957367E+03,
     +  .718549E+03, .538891E+03, .403944E+03, .302594E+03 /
        DATA (UPDI(I),I=3121,3172) /
     +  .226642E+03, .168958E+03, .126465E+03, .946316E+02,
     +  .708293E+02, .530203E+02, .397135E+02, .297915E+02,
     +  .223631E+02, .168107E+02, .126644E+02, .956049E+01,
     +  .723800E+01, .549375E+01, .418517E+01, .319747E+01,
     +  .245105E+01, .188437E+01, .145332E+01, .112348E+01,
     +  .871557E+00, .676036E+00, .526172E+00, .409112E+00,
     +  .318572E+00, .247977E+00, .192955E+00, .149951E+00,
     +  .116366E+00, .900863E-01, .695655E-01, .535446E-01,
     +  .410796E-01, .313830E-01, .238763E-01, .180742E-01,
     +  .136087E-01, .101995E-01, .758114E-02, .559172E-02,
     +  .409195E-02, .296716E-02, .213087E-02, .151261E-02,
     +  .106044E-02, .732181E-03, .497006E-03, .329836E-03,
     +  .214662E-03, .135186E-03, .824941E-04, .491666E-04 /
        DATA (UPDI(I),I=3173,3224) /
     +  .302696E-04, .198458E-04, .128358E-04, .815010E-05,
     +  .506845E-05, .306636E-05, .178921E-05, .981617E-06,
     +  .490558E-06, .206317E-06, .596740E-07, .495448E-08,
     +  .000000E+00, .490333E+06, .376005E+06, .284043E+06,
     +  .214446E+06, .161822E+06, .122032E+06, .919776E+05,
     +  .692778E+05, .521511E+05, .392303E+05, .294931E+05,
     +  .221560E+05, .166338E+05, .124780E+05, .935431E+04,
     +  .700675E+04, .524472E+04, .392236E+04, .293133E+04,
     +  .218873E+04, .163311E+04, .121744E+04, .906933E+03,
     +  .675027E+03, .502087E+03, .373159E+03, .277260E+03,
     +  .204987E+03, .152157E+03, .112895E+03, .837683E+02,
     +  .621553E+02, .461373E+02, .342958E+02, .255045E+02,
     +  .189919E+02, .141708E+02, .105948E+02, .794319E+01 /
        DATA (UPDI(I),I=3225,3276) /
     +  .597055E+01, .450420E+01, .340807E+01, .258743E+01,
     +  .197047E+01, .150556E+01, .115325E+01, .886666E+00,
     +  .681743E+00, .526089E+00, .405646E+00, .313310E+00,
     +  .241967E+00, .186832E+00, .144112E+00, .111019E+00,
     +  .853390E-01, .654432E-01, .500335E-01, .381325E-01,
     +  .289453E-01, .218833E-01, .164647E-01, .123224E-01,
     +  .918146E-02, .678516E-02, .497695E-02, .362264E-02,
     +  .261366E-02, .186819E-02, .132067E-02, .922710E-03,
     +  .635653E-03, .431189E-03, .286823E-03, .187845E-03,
     +  .119909E-03, .750237E-04, .466333E-04, .300607E-04,
     +  .202645E-04, .135388E-04, .891917E-05, .575909E-05,
     +  .361257E-05, .216887E-05, .121164E-05, .605165E-06,
     +  .248027E-06, .680466E-07, .598517E-08, .000000E+00 /
        DATA (UPDI(I),I=3277,3328) /
     +  .690762E+06, .527160E+06, .396002E+06, .297289E+06,
     +  .223059E+06, .167247E+06, .125326E+06, .938437E+05,
     +  .702262E+05, .525116E+05, .392396E+05, .292981E+05,
     +  .218600E+05, .162962E+05, .121395E+05, .903491E+04,
     +  .671909E+04, .499210E+04, .370602E+04, .274856E+04,
     +  .203682E+04, .150789E+04, .111540E+04, .824262E+03,
     +  .608635E+03, .449000E+03, .331099E+03, .242892E+03,
     +  .178886E+03, .131674E+03, .969106E+02, .713144E+02,
     +  .524904E+02, .386859E+02, .285186E+02, .210490E+02,
     +  .155650E+02, .115323E+02, .856718E+01, .638082E+01,
     +  .476964E+01, .357605E+01, .269033E+01, .203048E+01,
     +  .153765E+01, .116755E+01, .889976E+00, .678525E+00,
     +  .519291E+00, .397171E+00, .304342E+00, .233236E+00 /
        DATA (UPDI(I),I=3329,3380) /
     +  .178733E+00, .136851E+00, .104664E+00, .798875E-01,
     +  .608392E-01, .462001E-01, .349769E-01, .263781E-01,
     +  .198151E-01, .148158E-01, .110200E-01, .816166E-02,
     +  .599568E-02, .437267E-02, .316515E-02, .227164E-02,
     +  .161576E-02, .113728E-02, .791715E-03, .544087E-03,
     +  .368781E-03, .245813E-03, .161918E-03, .104621E-03,
     +  .668674E-04, .429295E-04, .285657E-04, .196282E-04,
     +  .133843E-04, .900427E-05, .592495E-05, .377540E-05,
     +  .228850E-05, .128221E-05, .635900E-06, .255774E-06,
     +  .682184E-07, .617645E-08, .000000E+00, .947063E+06,
     +  .719453E+06, .537560E+06, .401383E+06, .299523E+06,
     +  .223344E+06, .166433E+06, .123926E+06, .922122E+05,
     +  .685572E+05, .509335E+05, .378070E+05, .280419E+05 /
        DATA (UPDI(I),I=3381,3432) /
     +  .207797E+05, .153858E+05, .113809E+05, .841131E+04,
     +  .621019E+04, .458099E+04, .337561E+04, .248516E+04,
     +  .182762E+04, .134282E+04, .985546E+03, .722680E+03,
     +  .529365E+03, .387558E+03, .282207E+03, .206297E+03,
     +  .150705E+03, .110062E+03, .803586E+02, .586750E+02,
     +  .428942E+02, .313597E+02, .229524E+02, .168283E+02,
     +  .123615E+02, .910377E+01, .672166E+01, .498065E+01,
     +  .370183E+01, .276083E+01, .206583E+01, .155109E+01,
     +  .116787E+01, .882872E+00, .667623E+00, .506861E+00,
     +  .384616E+00, .292450E+00, .222435E+00, .169193E+00,
     +  .128608E+00, .976568E-01, .740183E-01, .559820E-01,
     +  .422254E-01, .317553E-01, .237926E-01, .177582E-01,
     +  .131944E-01, .975298E-02, .717925E-02, .524231E-02 /
        DATA (UPDI(I),I=3433,3484) /
     +  .380108E-02, .273603E-02, .195331E-02, .138255E-02,
     +  .968961E-03, .672175E-03, .460881E-03, .312210E-03,
     +  .208561E-03, .138168E-03, .902915E-04, .587879E-04,
     +  .387110E-04, .263369E-04, .183261E-04, .126462E-04,
     +  .859776E-05, .569887E-05, .364392E-05, .220442E-05,
     +  .122562E-05, .598481E-06, .234857E-06, .607809E-07,
     +  .561580E-08, .000000E+00, .126918E+07, .959919E+06,
     +  .713528E+06, .530004E+06, .393425E+06, .291809E+06,
     +  .216288E+06, .160177E+06, .118535E+06, .876406E+05,
     +  .647477E+05, .477899E+05, .352440E+05, .259661E+05,
     +  .191136E+05, .140549E+05, .103255E+05, .757729E+04,
     +  .555517E+04, .406804E+04, .297607E+04, .217466E+04,
     +  .158745E+04, .115743E+04, .843056E+03, .613339E+03 /
        DATA (UPDI(I),I=3485,3536) /
     +  .445937E+03, .322409E+03, .234004E+03, .169708E+03,
     +  .123026E+03, .891499E+02, .645965E+02, .468577E+02,
     +  .339868E+02, .246763E+02, .179453E+02, .130741E+02,
     +  .954897E+01, .699182E+01, .513763E+01, .378670E+01,
     +  .280063E+01, .207831E+01, .154766E+01, .115583E+01,
     +  .866786E+00, .650270E+00, .489846E+00, .368853E+00,
     +  .278350E+00, .210147E+00, .158683E+00, .119756E+00,
     +  .902938E-01, .679639E-01, .510522E-01, .382491E-01,
     +  .285744E-01, .212703E-01, .157737E-01, .116463E-01,
     +  .855506E-02, .625907E-02, .454302E-02, .327505E-02,
     +  .234436E-02, .166503E-02, .117291E-02, .818688E-03,
     +  .566106E-03, .387415E-03, .262423E-03, .175764E-03,
     +  .117140E-03, .773888E-04, .512242E-04, .344217E-04 /
        DATA (UPDI(I),I=3537,3588) /
     +  .237939E-04, .166930E-04, .115949E-04, .791732E-05,
     +  .525238E-05, .334863E-05, .201014E-05, .110335E-05,
     +  .528323E-06, .201685E-06, .505777E-07, .475370E-08,
     +  .000000E+00, .166747E+07, .125582E+07, .928808E+06,
     +  .686437E+06, .506954E+06, .374083E+06, .275830E+06,
     +  .203201E+06, .149577E+06, .110001E+06, .808272E+05,
     +  .593319E+05, .435139E+05, .318796E+05, .233338E+05,
     +  .170599E+05, .124604E+05, .909037E+04, .662485E+04,
     +  .482218E+04, .350625E+04, .254623E+04, .184703E+04,
     +  .133813E+04, .968374E+03, .699875E+03, .505460E+03,
     +  .362935E+03, .261605E+03, .188400E+03, .135605E+03,
     +  .975559E+02, .701675E+02, .505200E+02, .363649E+02,
     +  .262000E+02, .189048E+02, .136649E+02, .990109E+01 /
        DATA (UPDI(I),I=3589,3640) /
     +  .719176E+01, .524213E+01, .383271E+01, .281192E+01,
     +  .207004E+01, .152927E+01, .113311E+01, .843153E+00,
     +  .627665E+00, .469231E+00, .350680E+00, .262684E+00,
     +  .196882E+00, .147601E+00, .110608E+00, .828156E-01,
     +  .619083E-01, .461893E-01, .343757E-01, .255120E-01,
     +  .188681E-01, .139030E-01, .102009E-01, .744698E-02,
     +  .541547E-02, .390747E-02, .280092E-02, .199417E-02,
     +  .140925E-02, .988272E-03, .687229E-03, .473885E-03,
     +  .323856E-03, .219489E-03, .147477E-03, .989141E-04,
     +  .660423E-04, .443597E-04, .302966E-04, .211799E-04,
     +  .149320E-04, .104001E-04, .710305E-05, .469710E-05,
     +  .297438E-05, .176580E-05, .954109E-06, .447022E-06,
     +  .165790E-06, .402861E-07, .384545E-08, .000000E+00 /
        DATA (UPDI(I),I=3641,3692) /
     +  .215245E+07, .161443E+07, .118823E+07, .873869E+06,
     +  .642186E+06, .471506E+06, .345910E+06, .253531E+06,
     +  .185664E+06, .135829E+06, .992806E+05, .724904E+05,
     +  .528784E+05, .385298E+05, .280460E+05, .203910E+05,
     +  .148095E+05, .107425E+05, .778370E+04, .563257E+04,
     +  .407122E+04, .293875E+04, .211878E+04, .152553E+04,
     +  .109707E+04, .787830E+03, .565303E+03, .403205E+03,
     +  .288696E+03, .206506E+03, .147614E+03, .105455E+03,
     +  .753104E+02, .538333E+02, .384661E+02, .275084E+02,
     +  .196997E+02, .141314E+02, .101606E+02, .732340E+01,
     +  .529673E+01, .384258E+01, .279729E+01, .204336E+01,
     +  .149794E+01, .110141E+01, .813372E+00, .600944E+00,
     +  .445926E+00, .330817E+00, .246013E+00, .183074E+00 /
        DATA (UPDI(I),I=3693,3744) /
     +  .136283E+00, .101418E+00, .754127E-01, .559929E-01,
     +  .414969E-01, .306802E-01, .226212E-01, .166231E-01,
     +  .121715E-01, .887520E-02, .643959E-02, .465506E-02,
     +  .333937E-02, .238051E-02, .168606E-02, .118588E-02,
     +  .828175E-03, .573986E-03, .394902E-03, .269671E-03,
     +  .182987E-03, .123415E-03, .833279E-04, .562022E-04,
     +  .382392E-04, .264520E-04, .186343E-04, .131666E-04,
     +  .916893E-05, .624494E-05, .410488E-05, .257519E-05,
     +  .150870E-05, .801026E-06, .366743E-06, .132075E-06,
     +  .311179E-07, .301356E-08, .000000E+00, .273444E+07,
     +  .204279E+07, .149640E+07, .109526E+07, .801007E+06,
     +  .585259E+06, .427253E+06, .311598E+06, .227043E+06,
     +  .165260E+06, .120173E+06, .872912E+05, .633414E+05 /
        DATA (UPDI(I),I=3745,3796) /
     +  .459093E+05, .332385E+05, .240353E+05, .173605E+05,
     +  .125231E+05, .902282E+04, .649209E+04, .466542E+04,
     +  .334800E+04, .239954E+04, .171730E+04, .122746E+04,
     +  .876000E+03, .624623E+03, .442640E+03, .314885E+03,
     +  .223763E+03, .158885E+03, .112740E+03, .799596E+02,
     +  .567594E+02, .402698E+02, .285919E+02, .203267E+02,
     +  .144742E+02, .103301E+02, .739002E+01, .530482E+01,
     +  .381953E+01, .275959E+01, .200070E+01, .145569E+01,
     +  .106237E+01, .778770E+00, .571154E+00, .420751E+00,
     +  .309896E+00, .228821E+00, .169088E+00, .125000E+00,
     +  .923848E-01, .682306E-01, .503221E-01, .370482E-01,
     +  .272130E-01, .199357E-01, .145571E-01, .105924E-01,
     +  .767663E-02, .553652E-02, .397898E-02, .283832E-02 /
        DATA (UPDI(I),I=3797,3848) /
     +  .201259E-02, .141844E-02, .993240E-03, .691039E-03,
     +  .477577E-03, .328017E-03, .223968E-03, .152258E-03,
     +  .103128E-03, .701055E-04, .477353E-04, .328385E-04,
     +  .229377E-04, .162345E-04, .114709E-04, .796853E-05,
     +  .540021E-05, .352111E-05, .218448E-05, .126108E-05,
     +  .657128E-06, .293769E-06, .102718E-06, .234881E-07,
     +  .230613E-08, .000000E+00, .644000E+04, .730682E+04,
     +  .602053E+04, .496077E+04, .408765E+04, .336828E+04,
     +  .277559E+04, .228726E+04, .188492E+04, .155341E+04,
     +  .128026E+04, .105519E+04, .869743E+03, .716932E+03,
     +  .591012E+03, .487247E+03, .401737E+03, .331269E+03,
     +  .273193E+03, .225328E+03, .185877E+03, .153359E+03,
     +  .126554E+03, .104457E+03, .862386E+02, .712176E+02 /
        DATA (UPDI(I),I=3849,3900) /
     +  .588312E+02, .484848E+02, .400855E+02, .331561E+02,
     +  .274382E+02, .227193E+02, .188238E+02, .156163E+02,
     +  .129603E+02, .107671E+02, .895530E+01, .745792E+01,
     +  .621964E+01, .519443E+01, .434613E+01, .364228E+01,
     +  .305781E+01, .257168E+01, .216658E+01, .182820E+01,
     +  .154560E+01, .130619E+01, .110465E+01, .931584E+00,
     +  .783143E+00, .654240E+00, .541678E+00, .443369E+00,
     +  .358098E+00, .285138E+00, .223847E+00, .173393E+00,
     +  .132672E+00, .100385E+00, .751721E-01, .557349E-01,
     +  .409162E-01, .297762E-01, .213948E-01, .151939E-01,
     +  .106533E-01, .736515E-02, .501327E-02, .335397E-02,
     +  .220117E-02, .141397E-02, .886485E-03, .540498E-03,
     +  .320975E-03, .183490E-03, .100837E-03, .529431E-04 /
        DATA (UPDI(I),I=3901,3952) /
     +  .263554E-04, .123204E-04, .534187E-05, .211694E-05,
     +  .744978E-06, .227623E-06, .573960E-07, .111031E-07,
     +  .145378E-08, .100821E-09, .200727E-11, .000000E+00,
     +  .000000E+00, .179126E+05, .236078E+05, .188054E+05,
     +  .149814E+05, .119388E+05, .951508E+04, .758599E+04,
     +  .604879E+04, .482486E+04, .384917E+04, .307204E+04,
     +  .245223E+04, .195837E+04, .156428E+04, .125013E+04,
     +  .999315E+03, .799272E+03, .639456E+03, .511918E+03,
     +  .409962E+03, .328551E+03, .263421E+03, .211374E+03,
     +  .169699E+03, .136365E+03, .109655E+03, .882720E+02,
     +  .708981E+02, .571915E+02, .461757E+02, .373346E+02,
     +  .302184E+02, .244972E+02, .198964E+02, .161813E+02,
     +  .131807E+02, .107596E+02, .879920E+01, .721301E+01 /
        DATA (UPDI(I),I=3953,4004) /
     +  .592421E+01, .487896E+01, .402641E+01, .333110E+01,
     +  .276161E+01, .229473E+01, .190998E+01, .159334E+01,
     +  .132836E+01, .110849E+01, .922102E+00, .764748E+00,
     +  .630336E+00, .515246E+00, .416726E+00, .333055E+00,
     +  .262820E+00, .204844E+00, .157801E+00, .120296E+00,
     +  .908239E-01, .679773E-01, .504527E-01, .371359E-01,
     +  .271445E-01, .196287E-01, .140566E-01, .996283E-02,
     +  .698026E-02, .482972E-02, .329354E-02, .220984E-02,
     +  .145315E-02, .933392E-03, .579288E-03, .345768E-03,
     +  .191795E-03, .935565E-04, .330906E-04, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .135525E-19,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=4005,4056) /
     +  .574804E+05, .455936E+05, .358071E+05, .281207E+05,
     +  .220876E+05, .173488E+05, .136291E+05, .107071E+05,
     +  .841347E+04, .661146E+04, .519677E+04, .408513E+04,
     +  .321229E+04, .252627E+04, .198751E+04, .156392E+04,
     +  .123118E+04, .969465E+03, .763801E+03, .601963E+03,
     +  .474739E+03, .374569E+03, .295770E+03, .233679E+03,
     +  .184797E+03, .146256E+03, .115893E+03, .916156E+02,
     +  .727658E+02, .578567E+02, .460779E+02, .367457E+02,
     +  .293578E+02, .235079E+02, .188547E+02, .151522E+02,
     +  .122079E+02, .985746E+01, .798182E+01, .647820E+01,
     +  .527448E+01, .430490E+01, .352352E+01, .289088E+01,
     +  .237790E+01, .195957E+01, .161875E+01, .133631E+01,
     +  .110429E+01, .909596E+00, .747038E+00, .609852E+00 /
        DATA (UPDI(I),I=4057,4108) /
     +  .493927E+00, .396062E+00, .314090E+00, .246175E+00,
     +  .190763E+00, .146253E+00, .111064E+00, .835997E-01,
     +  .624273E-01, .462603E-01, .340159E-01, .248559E-01,
     +  .179781E-01, .128853E-01, .914575E-02, .642092E-02,
     +  .445443E-02, .304693E-02, .205117E-02, .135320E-02,
     +  .871475E-03, .541287E-03, .322504E-03, .177385E-03,
     +  .847574E-04, .280067E-04, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .979373E+05,
     +  .770042E+05, .598748E+05, .465490E+05, .361898E+05,
     +  .281320E+05, .218694E+05, .169989E+05, .132142E+05,
     +  .102712E+05, .798458E+04, .620669E+04, .482551E+04 /
        DATA (UPDI(I),I=4109,4160) /
     +  .375163E+04, .291743E+04, .226882E+04, .176497E+04,
     +  .137316E+04, .106877E+04, .832024E+03, .648083E+03,
     +  .504976E+03, .393740E+03, .307155E+03, .239815E+03,
     +  .187378E+03, .146583E+03, .114372E+03, .896772E+02,
     +  .703934E+02, .553502E+02, .435840E+02, .343863E+02,
     +  .271963E+02, .215485E+02, .171111E+02, .136257E+02,
     +  .108773E+02, .871004E+01, .699313E+01, .563424E+01,
     +  .455187E+01, .368885E+01, .299739E+01, .244229E+01,
     +  .199396E+01, .163210E+01, .133496E+01, .109312E+01,
     +  .892140E+00, .726031E+00, .587404E+00, .471647E+00,
     +  .375139E+00, .295296E+00, .229921E+00, .177143E+00,
     +  .135143E+00, .102201E+00, .766616E-01, .570833E-01,
     +  .422053E-01, .309811E-01, .226140E-01, .163494E-01 /
        DATA (UPDI(I),I=4161,4212) /
     +  .117219E-01, .833084E-02, .586350E-02, .408436E-02,
     +  .281097E-02, .190939E-02, .127633E-02, .837799E-03,
     +  .535773E-03, .334198E-03, .198968E-03, .111458E-03,
     +  .565071E-04, .268048E-04, .171262E-04, .106388E-04,
     +  .636839E-05, .365101E-05, .198629E-05, .101929E-05,
     +  .481255E-06, .206413E-06, .762546E-07, .201626E-07,
     +  .835994E-09, .000000E+00, .153303E+06, .119710E+06,
     +  .923514E+05, .712272E+05, .549304E+05, .423514E+05,
     +  .326509E+05, .251663E+05, .193966E+05, .149464E+05,
     +  .115171E+05, .887303E+04, .683621E+04, .526617E+04,
     +  .405711E+04, .312533E+04, .240796E+04, .185520E+04,
     +  .142970E+04, .110187E+04, .849559E+03, .655154E+03,
     +  .505509E+03, .390186E+03, .301389E+03, .232948E+03 /
        DATA (UPDI(I),I=4213,4264) /
     +  .180250E+03, .139079E+03, .107846E+03, .837181E+02,
     +  .650967E+02, .506907E+02, .395506E+02, .309382E+02,
     +  .242463E+02, .190465E+02, .150061E+02, .118547E+02,
     +  .939598E+01, .746876E+01, .595899E+01, .476864E+01,
     +  .382873E+01, .308291E+01, .248965E+01, .201483E+01,
     +  .163490E+01, .132563E+01, .107613E+01, .870654E+00,
     +  .702458E+00, .563542E+00, .448810E+00, .354246E+00,
     +  .276885E+00, .214219E+00, .164117E+00, .124590E+00,
     +  .938149E-01, .701081E-01, .520335E-01, .383641E-01,
     +  .280938E-01, .204662E-01, .147740E-01, .105819E-01,
     +  .751793E-02, .529367E-02, .369271E-02, .254837E-02,
     +  .173873E-02, .117033E-02, .776157E-03, .504283E-03,
     +  .322185E-03, .199399E-03, .119365E-03, .685618E-04 /
        DATA (UPDI(I),I=4265,4316) /
     +  .403155E-04, .278936E-04, .191340E-04, .129238E-04,
     +  .856175E-05, .551300E-05, .341056E-05, .197297E-05,
     +  .103083E-05, .451291E-06, .135517E-06, .113833E-07,
     +  .000000E+00, .161689E+06, .175994E+06, .134870E+06,
     +  .103320E+06, .791375E+05, .605932E+05, .463869E+05,
     +  .354992E+05, .271630E+05, .207776E+05, .158914E+05,
     +  .121505E+05, .928949E+04, .710022E+04, .542672E+04,
     +  .414672E+04, .316875E+04, .242102E+04, .184996E+04,
     +  .141350E+04, .108029E+04, .825685E+03, .631333E+03,
     +  .482835E+03, .369479E+03, .282877E+03, .216792E+03,
     +  .165633E+03, .127179E+03, .977529E+02, .752543E+02,
     +  .580163E+02, .448132E+02, .347060E+02, .269284E+02,
     +  .209447E+02, .163403E+02, .127844E+02, .100366E+02 /
        DATA (UPDI(I),I=4317,4368) /
     +  .790375E+01, .624853E+01, .495573E+01, .394410E+01,
     +  .314858E+01, .252120E+01, .202332E+01, .162823E+01,
     +  .130928E+01, .105410E+01, .845773E+00, .676792E+00,
     +  .538594E+00, .425617E+00, .333482E+00, .258889E+00,
     +  .199063E+00, .151662E+00, .114567E+00, .858874E-01,
     +  .639306E-01, .472801E-01, .347483E-01, .253723E-01,
     +  .184361E-01, .132785E-01, .949299E-02, .673479E-02,
     +  .473820E-02, .330469E-02, .228228E-02, .156014E-02,
     +  .105387E-02, .702957E-03, .461026E-03, .298753E-03,
     +  .189137E-03, .117406E-03, .716526E-04, .455601E-04,
     +  .321890E-04, .225770E-04, .156032E-04, .105612E-04,
     +  .692930E-05, .434384E-05, .253076E-05, .131953E-05,
     +  .569363E-06, .166453E-06, .145059E-07, .000000E+00 /
        DATA (UPDI(I),I=4369,4420) /
     +  .342216E+06, .264099E+06, .200997E+06, .152909E+06,
     +  .116293E+06, .884063E+05, .671879E+05, .510401E+05,
     +  .387625E+05, .294259E+05, .223323E+05, .169419E+05,
     +  .128495E+05, .974196E+04, .738450E+04, .559560E+04,
     +  .423947E+04, .321107E+04, .243198E+04, .184155E+04,
     +  .139455E+04, .105597E+04, .799744E+03, .605740E+03,
     +  .458972E+03, .347883E+03, .263905E+03, .199523E+03,
     +  .151599E+03, .115293E+03, .878072E+02, .669658E+02,
     +  .511642E+02, .391956E+02, .300805E+02, .231432E+02,
     +  .178607E+02, .138250E+02, .107390E+02, .836921E+01,
     +  .654892E+01, .514199E+01, .405196E+01, .320340E+01,
     +  .254057E+01, .201959E+01, .160999E+01, .128245E+01,
     +  .102286E+01, .813033E+00, .644577E+00, .508323E+00 /
        DATA (UPDI(I),I=4421,4472) /
     +  .398194E+00, .309428E+00, .238376E+00, .182007E+00,
     +  .137784E+00, .103483E+00, .771674E-01, .571603E-01,
     +  .420799E-01, .307930E-01, .223897E-01, .162020E-01,
     +  .116210E-01, .827292E-02, .584319E-02, .409132E-02,
     +  .283819E-02, .194790E-02, .132148E-02, .884236E-03,
     +  .582602E-03, .376025E-03, .238500E-03, .146653E-03,
     +  .874739E-04, .506978E-04, .302703E-04, .198458E-04,
     +  .128358E-04, .815010E-05, .506845E-05, .306636E-05,
     +  .178921E-05, .981617E-06, .490558E-06, .206317E-06,
     +  .596740E-07, .495448E-08, .000000E+00, .496134E+06,
     +  .380811E+06, .288003E+06, .217708E+06, .164510E+06,
     +  .124247E+06, .938025E+05, .707814E+05, .533900E+05,
     +  .402510E+05, .303341E+05, .228489E+05, .172046E+05 /
        DATA (UPDI(I),I=4473,4524) /
     +  .129483E+05, .974173E+04, .732587E+04, .550757E+04,
     +  .413885E+04, .310961E+04, .233553E+04, .175396E+04,
     +  .131691E+04, .988792E+03, .742372E+03, .557477E+03,
     +  .418703E+03, .314691E+03, .235652E+03, .177339E+03,
     +  .133563E+03, .100723E+03, .760548E+02, .575259E+02,
     +  .436270E+02, .331425E+02, .252415E+02, .192833E+02,
     +  .147767E+02, .113641E+02, .876939E+01, .679547E+01,
     +  .528461E+01, .412503E+01, .323084E+01, .253871E+01,
     +  .199965E+01, .157961E+01, .124675E+01, .985335E+00,
     +  .776065E+00, .609709E+00, .476570E+00, .370119E+00,
     +  .285269E+00, .218084E+00, .165337E+00, .124348E+00,
     +  .928331E-01, .688409E-01, .507284E-01, .371622E-01,
     +  .270684E-01, .195936E-01, .141181E-01, .100845E-01 /
        DATA (UPDI(I),I=4525,4576) /
     +  .715110E-02, .503230E-02, .351174E-02, .242884E-02,
     +  .166290E-02, .112618E-02, .753108E-03, .496667E-03,
     +  .321773E-03, .205654E-03, .128335E-03, .785691E-04,
     +  .476504E-04, .300614E-04, .202645E-04, .135388E-04,
     +  .891917E-05, .575909E-05, .361257E-05, .216887E-05,
     +  .121164E-05, .605165E-06, .248027E-06, .680466E-07,
     +  .598517E-08, .000000E+00, .696639E+06, .532028E+06,
     +  .400013E+06, .300593E+06, .225782E+06, .169490E+06,
     +  .127174E+06, .953662E+05, .714805E+05, .535449E+05,
     +  .400909E+05, .299993E+05, .224376E+05, .167719E+05,
     +  .125314E+05, .935759E+04, .698479E+04, .521085E+04,
     +  .388609E+04, .289676E+04, .215877E+04, .160820E+04,
     +  .119789E+04, .892071E+03, .664357E+03, .494769E+03 /
        DATA (UPDI(I),I=4577,4628) /
     +  .368672E+03, .273633E+03, .204094E+03, .152330E+03,
     +  .113824E+03, .851529E+02, .638040E+02, .479331E+02,
     +  .360677E+02, .272081E+02, .205875E+02, .156265E+02,
     +  .119041E+02, .910017E+01, .698641E+01, .538332E+01,
     +  .416393E+01, .323204E+01, .251699E+01, .196495E+01,
     +  .153847E+01, .120348E+01, .942692E+00, .735868E+00,
     +  .573030E+00, .444028E+00, .341953E+00, .261453E+00,
     +  .198369E+00, .149333E+00, .111578E+00, .827933E-01,
     +  .610457E-01, .447422E-01, .326087E-01, .236349E-01,
     +  .170264E-01, .122116E-01, .868345E-02, .613111E-02,
     +  .429690E-02, .298718E-02, .205895E-02, .140558E-02,
     +  .949859E-03, .634540E-03, .418710E-03, .272167E-03,
     +  .175171E-03, .110781E-03, .693752E-04, .436021E-04 /
        DATA (UPDI(I),I=4629,4680) /
     +  .285662E-04, .196282E-04, .133843E-04, .900427E-05,
     +  .592495E-05, .377540E-05, .228850E-05, .128221E-05,
     +  .635900E-06, .255774E-06, .682184E-07, .617645E-08,
     +  .000000E+00, .953015E+06, .724384E+06, .541622E+06,
     +  .404730E+06, .302280E+06, .225615E+06, .168304E+06,
     +  .125467E+06, .934821E+05, .696032E+05, .517950E+05,
     +  .385165E+05, .286263E+05, .212610E+05, .157820E+05,
     +  .117071E+05, .867982E+04, .643116E+04, .476281E+04,
     +  .352517E+04, .260815E+04, .192872E+04, .142589E+04,
     +  .105378E+04, .778699E+03, .575328E+03, .425245E+03,
     +  .312999E+03, .231507E+03, .171328E+03, .126918E+03,
     +  .941208E+02, .699003E+02, .520464E+02, .388106E+02,
     +  .290132E+02, .217547E+02, .163633E+02, .123531E+02 /
        DATA (UPDI(I),I=4681,4732) /
     +  .935885E+01, .712111E+01, .543874E+01, .416996E+01,
     +  .320862E+01, .247712E+01, .191712E+01, .148808E+01,
     +  .115395E+01, .896062E+00, .693379E+00, .535288E+00,
     +  .411272E+00, .314124E+00, .238287E+00, .179445E+00,
     +  .134144E+00, .995737E-01, .734328E-01, .538297E-01,
     +  .392356E-01, .284436E-01, .205105E-01, .147017E-01,
     +  .104930E-01, .742602E-02, .521943E-02, .364214E-02,
     +  .252181E-02, .173186E-02, .117868E-02, .794714E-03,
     +  .530320E-03, .350155E-03, .228363E-03, .147991E-03,
     +  .947721E-04, .605505E-04, .391545E-04, .263373E-04,
     +  .183261E-04, .126462E-04, .859776E-05, .569887E-05,
     +  .364392E-05, .220442E-05, .122562E-05, .598481E-06,
     +  .234857E-06, .607809E-07, .561580E-08, .000000E+00 /
        DATA (UPDI(I),I=4733,4784) /
     +  .127521E+07, .964913E+06, .717642E+06, .533393E+06,
     +  .396218E+06, .294109E+06, .218182E+06, .161737E+06,
     +  .119820E+06, .886993E+05, .656195E+05, .485078E+05,
     +  .358352E+05, .264527E+05, .195142E+05, .143846E+05,
     +  .105967E+05, .780043E+04, .573868E+04, .421891E+04,
     +  .310006E+04, .227651E+04, .167108E+04, .122606E+04,
     +  .899335E+03, .659464E+03, .483709E+03, .353224E+03,
     +  .259194E+03, .190278E+03, .139805E+03, .102820E+03,
     +  .757204E+02, .559037E+02, .413304E+02, .306314E+02,
     +  .227697E+02, .169790E+02, .127072E+02, .954446E+01,
     +  .720021E+01, .545239E+01, .414503E+01, .316258E+01,
     +  .242104E+01, .185794E+01, .143002E+01, .109950E+01,
     +  .846540E+00, .649474E+00, .497160E+00, .378809E+00 /
        DATA (UPDI(I),I=4785,4836) /
     +  .286996E+00, .216024E+00, .161484E+00, .119880E+00,
     +  .884046E-01, .647939E-01, .472180E-01, .342229E-01,
     +  .246751E-01, .176994E-01, .126213E-01, .896310E-02,
     +  .631227E-02, .441584E-02, .306772E-02, .211537E-02,
     +  .144741E-02, .982113E-03, .660756E-03, .440546E-03,
     +  .291160E-03, .190585E-03, .124389E-03, .806310E-04,
     +  .524555E-04, .347132E-04, .237942E-04, .166930E-04,
     +  .115949E-04, .791732E-05, .525238E-05, .334863E-05,
     +  .201014E-05, .110335E-05, .528323E-06, .201685E-06,
     +  .505777E-07, .475370E-08, .000000E+00, .167358E+07,
     +  .126088E+07, .932975E+06, .689870E+06, .509781E+06,
     +  .376412E+06, .277748E+06, .204781E+06, .150878E+06,
     +  .111072E+06, .817093E+05, .600581E+05, .441118E+05 /
        DATA (UPDI(I),I=4837,4888) /
     +  .323717E+05, .237386E+05, .173930E+05, .127344E+05,
     +  .931563E+04, .681001E+04, .497431E+04, .363119E+04,
     +  .264878E+04, .193116E+04, .140710E+04, .102488E+04,
     +  .746128E+03, .543285E+03, .393746E+03, .286750E+03,
     +  .208896E+03, .152289E+03, .111118E+03, .811767E+02,
     +  .594488E+02, .435923E+02, .320423E+02, .236215E+02,
     +  .174684E+02, .129652E+02, .965772E+01, .722555E+01,
     +  .542661E+01, .409159E+01, .309626E+01, .235086E+01,
     +  .178926E+01, .136584E+01, .104142E+01, .795152E+00,
     +  .604951E+00, .459245E+00, .347073E+00, .260869E+00,
     +  .194863E+00, .144608E+00, .106614E+00, .781100E-01,
     +  .568949E-01, .412164E-01, .297032E-01, .212983E-01,
     +  .151955E-01, .107791E-01, .761578E-02, .533686E-02 /
        DATA (UPDI(I),I=4889,4940) /
     +  .371582E-02, .256993E-02, .176491E-02, .120332E-02,
     +  .814178E-03, .546755E-03, .364372E-03, .241176E-03,
     +  .158529E-03, .104242E-03, .683760E-04, .452147E-04,
     +  .304876E-04, .211802E-04, .149320E-04, .104001E-04,
     +  .710305E-05, .469710E-05, .297438E-05, .176580E-05,
     +  .954109E-06, .447022E-06, .165790E-06, .402861E-07,
     +  .384545E-08, .000000E+00, .215864E+07, .161955E+07,
     +  .119245E+07, .877345E+06, .645049E+06, .473864E+06,
     +  .347852E+06, .255131E+06, .186981E+06, .136913E+06,
     +  .100173E+06, .732250E+05, .534829E+05, .390271E+05,
     +  .284551E+05, .207275E+05, .150861E+05, .109699E+05,
     +  .797044E+04, .578590E+04, .419705E+04, .304196E+04,
     +  .220337E+04, .159480E+04, .115376E+04, .834173E+03 /
        DATA (UPDI(I),I=4941,4992) /
     +  .603148E+03, .433984E+03, .313771E+03, .226905E+03,
     +  .164185E+03, .118894E+03, .861917E+02, .626341E+02,
     +  .455684E+02, .332308E+02, .243033E+02, .178297E+02,
     +  .131278E+02, .970089E+01, .720000E+01, .536438E+01,
     +  .401248E+01, .301222E+01, .226879E+01, .171292E+01,
     +  .129704E+01, .980899E+00, .742837E+00, .560516E+00,
     +  .422056E+00, .316420E+00, .235979E+00, .174949E+00,
     +  .128899E+00, .943850E-01, .687028E-01, .497336E-01,
     +  .358149E-01, .256629E-01, .182991E-01, .129852E-01,
     +  .916252E-02, .644050E-02, .449090E-02, .311213E-02,
     +  .214300E-02, .146593E-02, .996128E-03, .672288E-03,
     +  .450822E-03, .300463E-03, .199295E-03, .131624E-03,
     +  .872257E-04, .578732E-04, .388297E-04, .265768E-04 /
        DATA (UPDI(I),I=4993,5044) /
     +  .186345E-04, .131666E-04, .916893E-05, .624494E-05,
     +  .410488E-05, .257519E-05, .150870E-05, .801026E-06,
     +  .366743E-06, .132075E-06, .311179E-07, .301356E-08,
     +  .000000E+00, .274071E+07, .204798E+07, .150067E+07,
     +  .109878E+07, .803906E+06, .587646E+06, .429219E+06,
     +  .313216E+06, .228375E+06, .166357E+06, .121076E+06,
     +  .880340E+05, .639525E+05, .464119E+05, .336518E+05,
     +  .243751E+05, .176397E+05, .127524E+05, .921107E+04,
     +  .664656E+04, .479208E+04, .345179E+04, .248453E+04,
     +  .178683E+04, .128429E+04, .922397E+03, .662455E+03,
     +  .473357E+03, .339864E+03, .244044E+03, .175323E+03,
     +  .126040E+03, .906999E+02, .654215E+02, .472384E+02,
     +  .341878E+02, .248123E+02, .180637E+02, .131979E+02 /
        DATA (UPDI(I),I=5045,5096) /
     +  .967757E+01, .712730E+01, .526921E+01, .391080E+01,
     +  .291312E+01, .217703E+01, .163073E+01, .122507E+01,
     +  .919052E+00, .690430E+00, .516777E+00, .386017E+00,
     +  .287130E+00, .212497E+00, .156377E+00, .114401E+00,
     +  .832036E-01, .601742E-01, .432916E-01, .309909E-01,
     +  .220791E-01, .156561E-01, .110497E-01, .775558E-02,
     +  .542375E-02, .376339E-02, .259596E-02, .178001E-02,
     +  .121309E-02, .821809E-03, .553459E-03, .370790E-03,
     +  .247290E-03, .164477E-03, .109202E-03, .729449E-04,
     +  .489256E-04, .332441E-04, .230190E-04, .162346E-04,
     +  .114709E-04, .796853E-05, .540021E-05, .352111E-05,
     +  .218448E-05, .126108E-05, .657128E-06, .293769E-06,
     +  .102718E-06, .234881E-07, .230613E-08, .000000E+00 /
        DATA (UPDI(I),I=5097,5148) /
     +  .640992E+04, .728695E+04, .600228E+04, .494401E+04,
     +  .407225E+04, .335415E+04, .276261E+04, .227535E+04,
     +  .187398E+04, .154337E+04, .127105E+04, .104674E+04,
     +  .861990E+03, .709820E+03, .584489E+03, .481267E+03,
     +  .396256E+03, .326245E+03, .268590E+03, .221113E+03,
     +  .182018E+03, .149827E+03, .123322E+03, .101500E+03,
     +  .835354E+02, .687467E+02, .565734E+02, .464250E+02,
     +  .382043E+02, .314381E+02, .258693E+02, .212862E+02,
     +  .175144E+02, .144186E+02, .118638E+02, .976159E+01,
     +  .803133E+01, .660653E+01, .543250E+01, .446386E+01,
     +  .366500E+01, .300426E+01, .245731E+01, .200402E+01,
     +  .162807E+01, .131629E+01, .105899E+01, .845293E+00,
     +  .671063E+00, .528685E+00, .415106E+00, .325726E+00 /
        DATA (UPDI(I),I=5149,5200) /
     +  .256736E+00, .204361E+00, .164900E+00, .134947E+00,
     +  .111651E+00, .928897E-01, .772561E-01, .639157E-01,
     +  .524134E-01, .425042E-01, .340377E-01, .269233E-01,
     +  .209687E-01, .160940E-01, .121659E-01, .905111E-02,
     +  .662136E-02, .475778E-02, .335346E-02, .231476E-02,
     +  .156130E-02, .102610E-02, .658030E-03, .407729E-03,
     +  .243835E-03, .140011E-03, .766957E-04, .397542E-04,
     +  .192946E-04, .866073E-05, .350841E-05, .125896E-05,
     +  .383601E-06, .934908E-07, .164873E-07, .174325E-08,
     +  .724440E-10, .306493E-12, .000000E+00, .178789E+05,
     +  .235829E+05, .187826E+05, .149606E+05, .119196E+05,
     +  .949758E+04, .756996E+04, .603411E+04, .481143E+04,
     +  .383688E+04, .306079E+04, .244195E+04, .194896E+04 /
        DATA (UPDI(I),I=5201,5252) /
     +  .155568E+04, .124227E+04, .992132E+03, .792711E+03,
     +  .633465E+03, .506450E+03, .404973E+03, .324002E+03,
     +  .259274E+03, .207596E+03, .166258E+03, .133233E+03,
     +  .106805E+03, .856803E+02, .685453E+02, .550532E+02,
     +  .442330E+02, .355696E+02, .286149E+02, .230399E+02,
     +  .185709E+02, .149747E+02, .120809E+02, .975524E+01,
     +  .787976E+01, .636879E+01, .514650E+01, .415969E+01,
     +  .335866E+01, .270877E+01, .217977E+01, .174951E+01,
     +  .139882E+01, .111479E+01, .882685E+00, .696775E+00,
     +  .546941E+00, .428951E+00, .336770E+00, .265848E+00,
     +  .211730E+00, .170555E+00, .138824E+00, .113873E+00,
     +  .936770E-01, .769642E-01, .628796E-01, .509649E-01,
     +  .408902E-01, .324435E-01, .254629E-01, .197063E-01 /
        DATA (UPDI(I),I=5253,5304) /
     +  .150477E-01, .113329E-01, .840965E-02, .614406E-02,
     +  .441204E-02, .310966E-02, .214460E-02, .144346E-02,
     +  .941044E-03, .593418E-03, .354331E-03, .195805E-03,
     +  .945082E-04, .324805E-04, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .574489E+05, .455648E+05,
     +  .357807E+05, .280966E+05, .220655E+05, .173286E+05,
     +  .136107E+05, .106903E+05, .839809E+04, .659742E+04,
     +  .518395E+04, .407342E+04, .320161E+04, .251652E+04,
     +  .197862E+04, .155582E+04, .122380E+04, .962743E+03,
     +  .757680E+03, .596394E+03, .469674E+03, .369965E+03,
     +  .291587E+03, .229881E+03, .181350E+03, .143129E+03 /
        DATA (UPDI(I),I=5305,5356) /
     +  .113059E+03, .890509E+02, .704426E+02, .557533E+02,
     +  .441736E+02, .350221E+02, .277970E+02, .220938E+02,
     +  .175726E+02, .139885E+02, .111497E+02, .889324E+01,
     +  .710080E+01, .567088E+01, .453209E+01, .362005E+01,
     +  .288972E+01, .230296E+01, .183180E+01, .145255E+01,
     +  .114916E+01, .904127E+00, .710099E+00, .555268E+00,
     +  .434351E+00, .340420E+00, .268325E+00, .213242E+00,
     +  .171151E+00, .138543E+00, .112816E+00, .920192E-01,
     +  .749157E-01, .606457E-01, .487210E-01, .387664E-01,
     +  .305224E-01, .237884E-01, .182921E-01, .138853E-01,
     +  .104009E-01, .767940E-02, .558434E-02, .399199E-02,
     +  .280081E-02, .192220E-02, .128645E-02, .832381E-03,
     +  .519536E-03, .305139E-03, .163868E-03, .744284E-04 /
        DATA (UPDI(I),I=5357,5408) /
     +  .208139E-04, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .979014E+05, .769714E+05, .598448E+05,
     +  .465216E+05, .361648E+05, .281092E+05, .218486E+05,
     +  .169799E+05, .131969E+05, .102554E+05, .797019E+04,
     +  .619358E+04, .481356E+04, .374076E+04, .290753E+04,
     +  .225981E+04, .175678E+04, .136572E+04, .106201E+04,
     +  .825889E+03, .642516E+03, .499929E+03, .389166E+03,
     +  .303013E+03, .236066E+03, .183987E+03, .143517E+03,
     +  .111606E+03, .871794E+02, .681389E+02, .533157E+02,
     +  .417486E+02, .327300E+02, .257010E+02, .201977E+02,
     +  .158898E+02, .125196E+02, .987367E+01, .779725E+01 /
        DATA (UPDI(I),I=5409,5460) /
     +  .616086E+01, .487306E+01, .385388E+01, .304717E+01,
     +  .240657E+01, .189800E+01, .149324E+01, .117299E+01,
     +  .917079E+00, .716487E+00, .557863E+00, .434916E+00,
     +  .339935E+00, .267236E+00, .211700E+00, .169176E+00,
     +  .136159E+00, .110094E+00, .890880E-01, .719249E-01,
     +  .577392E-01, .460132E-01, .363353E-01, .284078E-01,
     +  .220000E-01, .168198E-01, .127032E-01, .947474E-02,
     +  .697191E-02, .505819E-02, .361235E-02, .253649E-02,
     +  .174662E-02, .117692E-02, .771028E-03, .491590E-03,
     +  .299746E-03, .172804E-03, .916018E-04, .421460E-04,
     +  .171292E-04, .106387E-04, .636838E-05, .365100E-05,
     +  .198629E-05, .101929E-05, .481254E-06, .206413E-06,
     +  .762545E-07, .201626E-07, .835991E-09, .000000E+00 /
        DATA (UPDI(I),I=5461,5512) /
     +  .153262E+06, .119673E+06, .923177E+05, .711965E+05,
     +  .549024E+05, .423259E+05, .326277E+05, .251451E+05,
     +  .193773E+05, .149288E+05, .115012E+05, .885850E+04,
     +  .682300E+04, .525416E+04, .404619E+04, .311542E+04,
     +  .239897E+04, .184704E+04, .142231E+04, .109518E+04,
     +  .843497E+03, .649670E+03, .500552E+03, .385707E+03,
     +  .297345E+03, .229299E+03, .176960E+03, .136119E+03,
     +  .105181E+03, .813194E+02, .629385E+02, .487498E+02,
     +  .378047E+02, .293672E+02, .228321E+02, .177724E+02,
     +  .138567E+02, .108162E+02, .845556E+01, .661540E+01,
     +  .518263E+01, .406086E+01, .318223E+01, .249190E+01,
     +  .194951E+01, .152227E+01, .118762E+01, .922805E+00,
     +  .717139E+00, .555858E+00, .431718E+00, .336319E+00 /
        DATA (UPDI(I),I=5513,5564) /
     +  .263520E+00, .207964E+00, .165401E+00, .132342E+00,
     +  .106275E+00, .853515E-01, .683688E-01, .544563E-01,
     +  .430684E-01, .337656E-01, .262202E-01, .201788E-01,
     +  .153378E-01, .115228E-01, .855385E-02, .626877E-02,
     +  .453308E-02, .322972E-02, .226524E-02, .156073E-02,
     +  .105465E-02, .695420E-03, .448631E-03, .279344E-03,
     +  .167223E-03, .951523E-04, .509556E-04, .278968E-04,
     +  .191340E-04, .129238E-04, .856174E-05, .551300E-05,
     +  .341056E-05, .197297E-05, .103083E-05, .451291E-06,
     +  .135517E-06, .113833E-07, .000000E+00, .161644E+06,
     +  .175953E+06, .134833E+06, .103286E+06, .791064E+05,
     +  .605649E+05, .463612E+05, .354758E+05, .271417E+05,
     +  .207583E+05, .158738E+05, .121345E+05, .927499E+04 /
        DATA (UPDI(I),I=5565,5616) /
     +  .708706E+04, .541478E+04, .413590E+04, .315895E+04,
     +  .241215E+04, .184193E+04, .140625E+04, .107374E+04,
     +  .819769E+03, .625995E+03, .478024E+03, .365145E+03,
     +  .278976E+03, .213283E+03, .162484E+03, .124352E+03,
     +  .952151E+02, .729774E+02, .559746E+02, .429824E+02,
     +  .330638E+02, .254551E+02, .196221E+02, .151516E+02,
     +  .117146E+02, .907212E+01, .703267E+01, .546014E+01,
     +  .424106E+01, .329542E+01, .255971E+01, .198719E+01,
     +  .154052E+01, .119389E+01, .922074E+00, .712766E+00,
     +  .549904E+00, .425364E+00, .330144E+00, .257712E+00,
     +  .202529E+00, .160274E+00, .127485E+00, .101690E+00,
     +  .810822E-01, .644655E-01, .509671E-01, .400178E-01,
     +  .311575E-01, .240361E-01, .183839E-01, .138923E-01 /
        DATA (UPDI(I),I=5617,5668) /
     +  .103806E-01, .766793E-02, .559462E-02, .402999E-02,
     +  .286228E-02, .200305E-02, .137873E-02, .932317E-03,
     +  .616800E-03, .400678E-03, .252759E-03, .154863E-03,
     +  .918078E-04, .530182E-04, .321920E-04, .225770E-04,
     +  .156032E-04, .105612E-04, .692929E-05, .434384E-05,
     +  .253076E-05, .131953E-05, .569362E-06, .166453E-06,
     +  .145059E-07, .000000E+00, .342165E+06, .264053E+06,
     +  .200955E+06, .152871E+06, .116258E+06, .883746E+05,
     +  .671590E+05, .510139E+05, .387388E+05, .294043E+05,
     +  .223128E+05, .169241E+05, .128334E+05, .972741E+04,
     +  .737133E+04, .558368E+04, .422870E+04, .320134E+04,
     +  .242320E+04, .183363E+04, .138741E+04, .104953E+04,
     +  .793956E+03, .600536E+03, .454297E+03, .343686E+03 /
        DATA (UPDI(I),I=5669,5720) /
     +  .260141E+03, .196156E+03, .148584E+03, .112595E+03,
     +  .853950E+02, .648101E+02, .492380E+02, .374742E+02,
     +  .285422E+02, .217680E+02, .166300E+02, .127227E+02,
     +  .975028E+01, .748117E+01, .575006E+01, .442266E+01,
     +  .340390E+01, .261989E+01, .201620E+01, .155020E+01,
     +  .119226E+01, .914401E+00, .702425E+00, .538914E+00,
     +  .414773E+00, .320414E+00, .248912E+00, .194578E+00,
     +  .153040E+00, .120883E+00, .956775E-01, .756622E-01,
     +  .596470E-01, .467600E-01, .364094E-01, .281198E-01,
     +  .215220E-01, .163358E-01, .122516E-01, .908682E-02,
     +  .666228E-02, .482420E-02, .344768E-02, .242822E-02,
     +  .168363E-02, .114677E-02, .765879E-03, .499076E-03,
     +  .318043E-03, .195596E-03, .115748E-03, .653593E-04 /
        DATA (UPDI(I),I=5721,5772) /
     +  .353489E-04, .198484E-04, .128358E-04, .815009E-05,
     +  .506845E-05, .306636E-05, .178921E-05, .981616E-06,
     +  .490557E-06, .206317E-06, .596740E-07, .495447E-08,
     +  .000000E+00, .496077E+06, .380759E+06, .287955E+06,
     +  .217665E+06, .164471E+06, .124211E+06, .937705E+05,
     +  .707523E+05, .533636E+05, .402271E+05, .303125E+05,
     +  .228293E+05, .171869E+05, .129323E+05, .972726E+04,
     +  .731281E+04, .549579E+04, .412823E+04, .310004E+04,
     +  .232691E+04, .174622E+04, .130996E+04, .982546E+03,
     +  .736771E+03, .552458E+03, .414209E+03, .310672E+03,
     +  .232067E+03, .174138E+03, .130709E+03, .981784E+02,
     +  .737885E+02, .555080E+02, .418303E+02, .315432E+02,
     +  .238176E+02, .180148E+02, .136459E+02, .103550E+02 /
        DATA (UPDI(I),I=5773,5824) /
     +  .786811E+01, .598967E+01, .456392E+01, .348058E+01,
     +  .265535E+01, .202620E+01, .154541E+01, .117967E+01,
     +  .898460E+00, .685815E+00, .523142E+00, .400499E+00,
     +  .307823E+00, .237889E+00, .184917E+00, .144522E+00,
     +  .113353E+00, .890303E-01, .698394E-01, .546024E-01,
     +  .424542E-01, .327896E-01, .251262E-01, .190846E-01,
     +  .143800E-01, .107085E-01, .788851E-02, .574623E-02,
     +  .413538E-02, .293834E-02, .205857E-02, .142066E-02,
     +  .963993E-03, .642156E-03, .418260E-03, .267211E-03,
     +  .165614E-03, .996499E-04, .581402E-04, .334207E-04,
     +  .202667E-04, .135388E-04, .891917E-05, .575908E-05,
     +  .361257E-05, .216887E-05, .121164E-05, .605165E-06,
     +  .248026E-06, .680465E-07, .598517E-08, .000000E+00 /
        DATA (UPDI(I),I=5825,5876) /
     +  .696575E+06, .531970E+06, .399961E+06, .300545E+06,
     +  .225739E+06, .169451E+06, .127139E+06, .953340E+05,
     +  .714513E+05, .535186E+05, .400671E+05, .299778E+05,
     +  .224182E+05, .167544E+05, .125156E+05, .934334E+04,
     +  .697196E+04, .519931E+04, .387571E+04, .288744E+04,
     +  .215040E+04, .160070E+04, .119118E+04, .886066E+03,
     +  .658989E+03, .489976E+03, .364397E+03, .269831E+03,
     +  .200709E+03, .149321E+03, .111151E+03, .827795E+02,
     +  .616982E+02, .460651E+02, .344114E+02, .257396E+02,
     +  .192851E+02, .144711E+02, .108784E+02, .818932E+01,
     +  .617713E+01, .466448E+01, .352597E+01, .266706E+01,
     +  .201842E+01, .152742E+01, .115736E+01, .875402E+00,
     +  .663982E+00, .503524E+00, .383371E+00, .293098E+00 /
        DATA (UPDI(I),I=5877,5928) /
     +  .225278E+00, .174093E+00, .135186E+00, .105284E+00,
     +  .820669E-01, .638694E-01, .495326E-01, .382038E-01,
     +  .292736E-01, .222595E-01, .167803E-01, .125521E-01,
     +  .928134E-02, .679086E-02, .491444E-02, .351487E-02,
     +  .248286E-02, .173016E-02, .118836E-02, .803297E-03,
     +  .533760E-03, .347525E-03, .222604E-03, .139038E-03,
     +  .849931E-04, .510520E-04, .307779E-04, .196299E-04,
     +  .133843E-04, .900426E-05, .592495E-05, .377540E-05,
     +  .228850E-05, .128221E-05, .635900E-06, .255774E-06,
     +  .682184E-07, .617645E-08, .000000E+00, .952944E+06,
     +  .724320E+06, .541564E+06, .404677E+06, .302232E+06,
     +  .225572E+06, .168265E+06, .125432E+06, .934500E+05,
     +  .695742E+05, .517689E+05, .384930E+05, .286050E+05 /
        DATA (UPDI(I),I=5929,5980) /
     +  .212418E+05, .157648E+05, .116916E+05, .866590E+04,
     +  .641866E+04, .475160E+04, .351512E+04, .259915E+04,
     +  .192067E+04, .141871E+04, .104737E+04, .772980E+03,
     +  .570234E+03, .420715E+03, .308980E+03, .227941E+03,
     +  .168167E+03, .124118E+03, .916440E+02, .677106E+02,
     +  .501112E+02, .371015E+02, .275044E+02, .204226E+02,
     +  .151873E+02, .113147E+02, .844206E+01, .631172E+01,
     +  .472480E+01, .354120E+01, .265644E+01, .199431E+01,
     +  .149763E+01, .112658E+01, .846324E+00, .637871E+00,
     +  .480866E+00, .364074E+00, .276825E+00, .211575E+00,
     +  .162526E+00, .125382E+00, .969622E-01, .750148E-01,
     +  .579288E-01, .445714E-01, .341077E-01, .259325E-01,
     +  .195700E-01, .146437E-01, .108754E-01, .798526E-02 /
        DATA (UPDI(I),I=5981,6032) /
     +  .580321E-02, .417251E-02, .296586E-02, .208292E-02,
     +  .144381E-02, .987109E-03, .664831E-03, .440772E-03,
     +  .286974E-03, .184375E-03, .116080E-03, .720473E-04,
     +  .444074E-04, .277894E-04, .183274E-04, .126462E-04,
     +  .859775E-05, .569886E-05, .364392E-05, .220442E-05,
     +  .122562E-05, .598480E-06, .234857E-06, .607809E-07,
     +  .561580E-08, .000000E+00, .127513E+07, .964842E+06,
     +  .717578E+06, .533335E+06, .396165E+06, .294061E+06,
     +  .218139E+06, .161698E+06, .119785E+06, .886676E+05,
     +  .655910E+05, .484821E+05, .358120E+05, .264319E+05,
     +  .194955E+05, .143678E+05, .105817E+05, .778695E+04,
     +  .572661E+04, .420812E+04, .309041E+04, .226791E+04,
     +  .166341E+04, .121923E+04, .893262E+03, .654069E+03 /
        DATA (UPDI(I),I=6033,6084) /
     +  .478923E+03, .348992E+03, .255449E+03, .186968E+03,
     +  .136883E+03, .100244E+03, .734510E+02, .539057E+02,
     +  .395730E+02, .290866E+02, .214121E+02, .157865E+02,
     +  .116600E+02, .862532E+01, .639399E+01, .474628E+01,
     +  .352799E+01, .262528E+01, .195556E+01, .145754E+01,
     +  .108865E+01, .812333E+00, .608406E+00, .455932E+00,
     +  .343240E+00, .259528E+00, .197217E+00, .150576E+00,
     +  .115401E+00, .886181E-01, .680529E-01, .521526E-01,
     +  .398171E-01, .302353E-01, .228137E-01, .170885E-01,
     +  .126937E-01, .936049E-02, .682551E-02, .492738E-02,
     +  .352017E-02, .248703E-02, .173677E-02, .119775E-02,
     +  .815317E-03, .547327E-03, .362240E-03, .235976E-03,
     +  .152169E-03, .966144E-04, .608640E-04, .383915E-04 /
        DATA (UPDI(I),I=6085,6136) /
     +  .247448E-04, .166940E-04, .115949E-04, .791732E-05,
     +  .525238E-05, .334863E-05, .201014E-05, .110335E-05,
     +  .528323E-06, .201685E-06, .505777E-07, .475370E-08,
     +  .000000E+00, .167349E+07, .126080E+07, .932904E+06,
     +  .689805E+06, .509723E+06, .376359E+06, .277701E+06,
     +  .204739E+06, .150840E+06, .111038E+06, .816782E+05,
     +  .600302E+05, .440866E+05, .323491E+05, .237184E+05,
     +  .173749E+05, .127181E+05, .930113E+04, .679705E+04,
     +  .496274E+04, .362088E+04, .263961E+04, .192300E+04,
     +  .139985E+04, .101845E+04, .740430E+03, .538244E+03,
     +  .389302E+03, .282829E+03, .205441E+03, .149249E+03,
     +  .108448E+03, .788324E+02, .573927E+02, .417912E+02,
     +  .304660E+02, .222428E+02, .162635E+02, .119129E+02 /
        DATA (UPDI(I),I=6137,6188) /
     +  .873974E+01, .642566E+01, .473108E+01, .348857E+01,
     +  .257566E+01, .190404E+01, .140875E+01, .104489E+01,
     +  .774512E+00, .576462E+00, .429430E+00, .321442E+00,
     +  .241670E+00, .182576E+00, .138541E+00, .105480E+00,
     +  .804350E-01, .613181E-01, .466394E-01, .353379E-01,
     +  .266316E-01, .199448E-01, .148305E-01, .109374E-01,
     +  .800931E-02, .580060E-02, .416014E-02, .295349E-02,
     +  .207439E-02, .144074E-02, .988811E-03, .670412E-03,
     +  .448793E-03, .296698E-03, .193528E-03, .125352E-03,
     +  .803008E-04, .513249E-04, .330466E-04, .218006E-04,
     +  .149328E-04, .104001E-04, .710305E-05, .469710E-05,
     +  .297438E-05, .176580E-05, .954108E-06, .447022E-06,
     +  .165790E-06, .402861E-07, .384545E-08, .000000E+00 /
        DATA (UPDI(I),I=6189,6240) /
     +  .215854E+07, .161947E+07, .119238E+07, .877275E+06,
     +  .644985E+06, .473807E+06, .347801E+06, .255084E+06,
     +  .186939E+06, .136876E+06, .100139E+06, .731947E+05,
     +  .534558E+05, .390028E+05, .284333E+05, .207080E+05,
     +  .150687E+05, .109543E+05, .795657E+04, .577355E+04,
     +  .418607E+04, .303220E+04, .219471E+04, .158713E+04,
     +  .114697E+04, .828174E+03, .597856E+03, .429330E+03,
     +  .309678E+03, .223310E+03, .161032E+03, .116134E+03,
     +  .837774E+02, .605249E+02, .437284E+02, .316277E+02,
     +  .229079E+02, .166165E+02, .120743E+02, .878752E+01,
     +  .640946E+01, .468200E+01, .342557E+01, .250991E+01,
     +  .184169E+01, .135287E+01, .996599E+00, .733889E+00,
     +  .542853E+00, .401998E+00, .299182E+00, .223649E+00 /
        DATA (UPDI(I),I=6241,6292) /
     +  .167967E+00, .126667E+00, .958059E-01, .725519E-01,
     +  .549099E-01, .414573E-01, .311777E-01, .233224E-01,
     +  .173387E-01, .128003E-01, .937366E-02, .681729E-02,
     +  .490446E-02, .349500E-02, .246622E-02, .172234E-02,
     +  .119006E-02, .813120E-03, .549350E-03, .366935E-03,
     +  .242484E-03, .158492E-03, .103191E-03, .667217E-04,
     +  .432416E-04, .283461E-04, .190382E-04, .131671E-04,
     +  .916893E-05, .624494E-05, .410487E-05, .257519E-05,
     +  .150870E-05, .801026E-06, .366743E-06, .132075E-06,
     +  .311179E-07, .301356E-08, .000000E+00, .274060E+07,
     +  .204789E+07, .150059E+07, .109871E+07, .803837E+06,
     +  .587584E+06, .429163E+06, .313166E+06, .228330E+06,
     +  .166316E+06, .121039E+06, .880013E+05, .639232E+05 /
        DATA (UPDI(I),I=6293,6344) /
     +  .463857E+05, .336284E+05, .243541E+05, .176210E+05,
     +  .127358E+05, .919627E+04, .663340E+04, .478041E+04,
     +  .344144E+04, .247537E+04, .177873E+04, .127714E+04,
     +  .916097E+03, .656913E+03, .468498E+03, .335603E+03,
     +  .240314E+03, .172063E+03, .123195E+03, .882211E+02,
     +  .632644E+02, .453648E+02, .325627E+02, .234048E+02,
     +  .168465E+02, .121470E+02, .877212E+01, .634896E+01,
     +  .460235E+01, .334186E+01, .243044E+01, .177048E+01,
     +  .129146E+01, .944996E+00, .691412E+00, .508306E+00,
     +  .374195E+00, .276890E+00, .205794E+00, .153643E+00,
     +  .115145E+00, .865202E-01, .650698E-01, .488966E-01,
     +  .366492E-01, .273601E-01, .203179E-01, .149965E-01,
     +  .109932E-01, .799479E-02, .577557E-02, .412805E-02 /
        DATA (UPDI(I),I=6345,6396) /
     +  .292348E-02, .205085E-02, .142452E-02, .979521E-03,
     +  .666562E-03, .448979E-03, .299418E-03, .197933E-03,
     +  .129738E-03, .849612E-04, .554562E-04, .364102E-04,
     +  .242352E-04, .164966E-04, .114713E-04, .796853E-05,
     +  .540021E-05, .352111E-05, .218448E-05, .126108E-05,
     +  .657128E-06, .293769E-06, .102718E-06, .234881E-07,
     +  .230613E-08, .000000E+00, .359538E+05, .301386E+05,
     +  .251494E+05, .209861E+05, .175122E+05, .146133E+05,
     +  .121944E+05, .101759E+05, .849167E+04, .708624E+04,
     +  .591349E+04, .493490E+04, .411834E+04, .343696E+04,
     +  .286840E+04, .239398E+04, .199811E+04, .166779E+04,
     +  .139216E+04, .116217E+04, .970273E+03, .810152E+03,
     +  .676548E+03, .565073E+03, .472062E+03, .394458E+03 /
        DATA (UPDI(I),I=6397,6448) /
     +  .329709E+03, .274989E+03, .230052E+03, .192557E+03,
     +  .161271E+03, .135167E+03, .113385E+03, .952590E+02,
     +  .800930E+02, .674402E+02, .568813E+02, .480657E+02,
     +  .407006E+02, .345390E+02, .293855E+02, .250609E+02,
     +  .214266E+02, .183651E+02, .157793E+02, .135891E+02,
     +  .117348E+02, .101442E+02, .879200E+01, .762469E+01,
     +  .662385E+01, .575977E+01, .501172E+01, .436241E+01,
     +  .379748E+01, .330496E+01, .287483E+01, .249866E+01,
     +  .216932E+01, .188076E+01, .162782E+01, .140606E+01,
     +  .121165E+01, .104203E+01, .892592E+00, .761930E+00,
     +  .647851E+00, .548434E+00, .461988E+00, .387023E+00,
     +  .322221E+00, .266412E+00, .218529E+00, .177614E+00,
     +  .143170E+00, .113941E+00, .895130E-01, .692769E-01 /
        DATA (UPDI(I),I=6449,6500) /
     +  .526860E-01, .392499E-01, .285278E-01, .201354E-01,
     +  .136692E-01, .886556E-02, .540498E-02, .302815E-02,
     +  .150098E-02, .613039E-03, .175848E-03, .212537E-04,
     +  .000000E+00, .489425E+06, .390169E+06, .308096E+06,
     +  .243207E+06, .192024E+06, .151562E+06, .119652E+06,
     +  .944281E+05, .745386E+05, .588188E+05, .464251E+05,
     +  .366306E+05, .289097E+05, .228086E+05, .179999E+05,
     +  .142004E+05, .112062E+05, .884059E+04, .697666E+04,
     +  .550414E+04, .434400E+04, .342753E+04, .270561E+04,
     +  .213540E+04, .168624E+04, .133150E+04, .105205E+04,
     +  .828702E+03, .655550E+03, .518769E+03, .411036E+03,
     +  .325913E+03, .258858E+03, .205988E+03, .164205E+03,
     +  .131164E+03, .105096E+03, .844440E+02, .681101E+02 /
        DATA (UPDI(I),I=6501,6552) /
     +  .551228E+02, .448169E+02, .365793E+02, .299944E+02,
     +  .246962E+02, .204257E+02, .169598E+02, .141496E+02,
     +  .118326E+02, .993924E+01, .836349E+01, .706049E+01,
     +  .597270E+01, .506159E+01, .429489E+01, .364783E+01,
     +  .309978E+01, .263449E+01, .223847E+01, .190079E+01,
     +  .161247E+01, .136599E+01, .115524E+01, .974781E+00,
     +  .821068E+00, .688764E+00, .575801E+00, .479418E+00,
     +  .397378E+00, .327666E+00, .268628E+00, .218766E+00,
     +  .176858E+00, .141776E+00, .112528E+00, .885204E-01,
     +  .686816E-01, .525400E-01, .395475E-01, .292014E-01,
     +  .210864E-01, .148160E-01, .100856E-01, .657644E-02,
     +  .408040E-02, .236466E-02, .124964E-02, .577066E-03,
     +  .215913E-03, .560795E-04, .688920E-05, .000000E+00 /
        DATA (UPDI(I),I=6553,6604) /
     +  .114807E+07, .905663E+06, .706691E+06, .551152E+06,
     +  .429859E+06, .335085E+06, .261213E+06, .203516E+06,
     +  .158567E+06, .123476E+06, .961522E+05, .748320E+05,
     +  .582394E+05, .452993E+05, .352345E+05, .273895E+05,
     +  .212913E+05, .165408E+05, .128506E+05, .997755E+04,
     +  .774712E+04, .601177E+04, .466555E+04, .361890E+04,
     +  .280748E+04, .217702E+04, .168860E+04, .130489E+04,
     +  .101253E+04, .785681E+03, .610168E+03, .474053E+03,
     +  .368791E+03, .287384E+03, .224268E+03, .175340E+03,
     +  .137491E+03, .108111E+03, .853366E+02, .675976E+02,
     +  .538034E+02, .430030E+02, .345421E+02, .278720E+02,
     +  .226018E+02, .184088E+02, .150744E+02, .123775E+02,
     +  .102148E+02, .844805E+01, .701317E+01, .583649E+01 /
        DATA (UPDI(I),I=6605,6656) /
     +  .486780E+01, .406651E+01, .340140E+01, .284731E+01,
     +  .238439E+01, .199664E+01, .167115E+01, .139755E+01,
     +  .116722E+01, .973295E+00, .809707E+00, .672469E+00,
     +  .556119E+00, .458288E+00, .376081E+00, .307184E+00,
     +  .249545E+00, .201499E+00, .161566E+00, .128555E+00,
     +  .101386E+00, .791193E-01, .611634E-01, .465980E-01,
     +  .349720E-01, .258012E-01, .186509E-01, .131672E-01,
     +  .902906E-02, .598741E-02, .379280E-02, .227938E-02,
     +  .127405E-02, .645959E-03, .283970E-03, .100257E-03,
     +  .245502E-04, .304347E-05, .000000E+00, .218804E+07,
     +  .171184E+07, .132323E+07, .102221E+07, .789582E+06,
     +  .609507E+06, .470442E+06, .362865E+06, .279848E+06,
     +  .215675E+06, .166191E+06, .127968E+06, .985184E+05 /
        DATA (UPDI(I),I=6657,6708) /
     +  .757895E+05, .582925E+05, .448004E+05, .344236E+05,
     +  .264295E+05, .202873E+05, .155600E+05, .119316E+05,
     +  .914192E+04, .700317E+04, .536069E+04, .410286E+04,
     +  .313786E+04, .239983E+04, .182768E+04, .139753E+04,
     +  .106834E+04, .817103E+03, .625046E+03, .478609E+03,
     +  .367030E+03, .281777E+03, .216695E+03, .167103E+03,
     +  .129207E+03, .100280E+03, .781056E+02, .611288E+02,
     +  .480485E+02, .379599E+02, .301332E+02, .240444E+02,
     +  .192758E+02, .155413E+02, .125670E+02, .102174E+02,
     +  .832679E+01, .681363E+01, .559089E+01, .459855E+01,
     +  .378940E+01, .312708E+01, .258301E+01, .213465E+01,
     +  .176425E+01, .145751E+01, .120317E+01, .991931E+00,
     +  .816478E+00, .670436E+00, .549577E+00, .448501E+00 /
        DATA (UPDI(I),I=6709,6760) /
     +  .364682E+00, .295223E+00, .237830E+00, .190498E+00,
     +  .151619E+00, .119785E+00, .938722E-01, .728805E-01,
     +  .559530E-01, .425308E-01, .318328E-01, .234493E-01,
     +  .169631E-01, .120082E-01, .829010E-02, .554874E-02,
     +  .358427E-02, .220536E-02, .128317E-02, .691256E-03,
     +  .335831E-03, .140302E-03, .466437E-04, .107506E-04,
     +  .134385E-05, .000000E+00, .370078E+07, .287531E+07,
     +  .220496E+07, .168972E+07, .129457E+07, .991120E+06,
     +  .758602E+06, .580195E+06, .443619E+06, .338925E+06,
     +  .258857E+06, .197540E+06, .150696E+06, .114861E+06,
     +  .875141E+05, .666181E+05, .506910E+05, .385357E+05,
     +  .292827E+05, .222301E+05, .168686E+05, .127877E+05,
     +  .969002E+04, .733573E+04, .555128E+04, .419686E+04 /
        DATA (UPDI(I),I=6761,6812) /
     +  .317218E+04, .238667E+04, .180271E+04, .136099E+04,
     +  .102773E+04, .776041E+03, .586403E+03, .443708E+03,
     +  .336011E+03, .254850E+03, .193785E+03, .147736E+03,
     +  .113036E+03, .867927E+02, .669622E+02, .518891E+02,
     +  .404154E+02, .316341E+02, .248921E+02, .196823E+02,
     +  .156551E+02, .124898E+02, .100216E+02, .806118E+01,
     +  .651201E+01, .527613E+01, .428560E+01, .348806E+01,
     +  .284327E+01, .232018E+01, .189435E+01, .154688E+01,
     +  .126264E+01, .102985E+01, .838865E+00, .682188E+00,
     +  .553368E+00, .448089E+00, .361144E+00, .289962E+00,
     +  .231736E+00, .184255E+00, .145622E+00, .114322E+00,
     +  .890523E-01, .687802E-01, .526027E-01, .397565E-01,
     +  .297330E-01, .218768E-01, .158279E-01, .112341E-01 /
        DATA (UPDI(I),I=6813,6864) /
     +  .779333E-02, .526485E-02, .344216E-02, .216760E-02,
     +  .129658E-02, .731111E-03, .380069E-03, .177221E-03,
     +  .705492E-04, .221942E-04, .485566E-05, .609857E-06,
     +  .000000E+00, .578771E+07, .446938E+07, .340334E+07,
     +  .258960E+07, .196975E+07, .149708E+07, .113741E+07,
     +  .863430E+06, .655176E+06, .496718E+06, .376413E+06,
     +  .284985E+06, .215657E+06, .163038E+06, .123191E+06,
     +  .929891E+05, .701513E+05, .528666E+05, .398167E+05,
     +  .299551E+05, .225219E+05, .169142E+05, .126948E+05,
     +  .951745E+04, .713100E+04, .533673E+04, .399225E+04,
     +  .297176E+04, .222060E+04, .165823E+04, .123825E+04,
     +  .924428E+03, .690452E+03, .516329E+03, .386333E+03,
     +  .289476E+03, .217412E+03, .163699E+03, .123685E+03 /
        DATA (UPDI(I),I=6865,6916) /
     +  .937782E+02, .714405E+02, .546636E+02, .420411E+02,
     +  .324959E+02, .252526E+02, .197215E+02, .154956E+02,
     +  .122129E+02, .968264E+01, .769637E+01, .614461E+01,
     +  .492090E+01, .395118E+01, .317931E+01, .256227E+01,
     +  .206734E+01, .166896E+01, .134757E+01, .108761E+01,
     +  .877118E+00, .706392E+00, .567934E+00, .455398E+00,
     +  .364496E+00, .290309E+00, .230298E+00, .181809E+00,
     +  .142758E+00, .111387E+00, .863007E-01, .663188E-01,
     +  .505090E-01, .380724E-01, .283415E-01, .208653E-01,
     +  .150995E-01, .107352E-01, .747975E-02, .508747E-02,
     +  .336491E-02, .215014E-02, .132069E-02, .768487E-03,
     +  .420247E-03, .211007E-03, .945469E-04, .359386E-04,
     +  .107379E-04, .224222E-05, .281765E-06, .000000E+00 /
        DATA (UPDI(I),I=6917,6968) /
     +  .894472E+07, .686365E+07, .518831E+07, .391869E+07,
     +  .295836E+07, .223147E+07, .168231E+07, .126716E+07,
     +  .953929E+06, .717445E+06, .539259E+06, .404922E+06,
     +  .303851E+06, .227767E+06, .170614E+06, .127660E+06,
     +  .954476E+05, .712801E+05, .531893E+05, .396414E+05,
     +  .295196E+05, .219545E+05, .163144E+05, .121079E+05,
     +  .897843E+04, .664874E+04, .492048E+04, .362223E+04,
     +  .267651E+04, .197606E+04, .145848E+04, .107605E+04,
     +  .794028E+03, .586564E+03, .433424E+03, .320674E+03,
     +  .237761E+03, .176711E+03, .131773E+03, .985999E+02,
     +  .741222E+02, .559668E+02, .424735E+02, .323976E+02,
     +  .248452E+02, .191498E+02, .148516E+02, .115540E+02,
     +  .904342E+01, .709686E+01, .559462E+01, .442447E+01 /
        DATA (UPDI(I),I=6969,7020) /
     +  .350843E+01, .278818E+01, .221937E+01, .176869E+01,
     +  .141033E+01, .112476E+01, .896604E+00, .714144E+00,
     +  .567986E+00, .450936E+00, .356994E+00, .282080E+00,
     +  .221733E+00, .173562E+00, .135163E+00, .104662E+00,
     +  .805040E-01, .614633E-01, .465225E-01, .348816E-01,
     +  .258698E-01, .189339E-01, .136963E-01, .972919E-02,
     +  .678311E-02, .462922E-02, .307995E-02, .198952E-02,
     +  .123922E-02, .740377E-03, .417848E-03, .220910E-03,
     +  .106794E-03, .458428E-04, .166014E-04, .470752E-05,
     +  .939038E-06, .117199E-06, .000000E+00, .132434E+08,
     +  .101016E+08, .758288E+07, .568716E+07, .426287E+07,
     +  .319236E+07, .238917E+07, .178633E+07, .133469E+07,
     +  .996215E+06, .743028E+06, .553589E+06, .412119E+06 /
        DATA (UPDI(I),I=7021,7072) /
     +  .306450E+06, .227679E+06, .168951E+06, .125256E+06,
     +  .927429E+05, .686027E+05, .506777E+05, .373982E+05,
     +  .275600E+05, .202888E+05, .149148E+05, .109528E+05,
     +  .803072E+04, .588350E+04, .428624E+04, .313406E+04,
     +  .228931E+04, .167135E+04, .121952E+04, .889763E+03,
     +  .649800E+03, .474561E+03, .346973E+03, .254182E+03,
     +  .186634E+03, .137471E+03, .101599E+03, .754323E+02,
     +  .562506E+02, .421584E+02, .317588E+02, .240540E+02,
     +  .183115E+02, .140279E+02, .107797E+02, .833540E+01,
     +  .646227E+01, .503335E+01, .393322E+01, .308190E+01,
     +  .242028E+01, .190380E+01, .149933E+01, .118143E+01,
     +  .931065E+00, .733383E+00, .577159E+00, .453507E+00,
     +  .355670E+00, .278099E+00, .217002E+00, .168403E+00 /
        DATA (UPDI(I),I=7073,7124) /
     +  .130104E+00, .999732E-01, .763594E-01, .579125E-01,
     +  .435776E-01, .324930E-01, .239861E-01, .175034E-01,
     +  .125947E-01, .895078E-02, .624000E-02, .426490E-02,
     +  .284973E-02, .185354E-02, .116841E-02, .708675E-03,
     +  .411261E-03, .224709E-03, .114577E-03, .531584E-04,
     +  .217668E-04, .746651E-05, .199352E-05, .376107E-06,
     +  .461013E-07, .000000E+00, .188908E+08, .143285E+08,
     +  .106852E+08, .796081E+07, .592696E+07, .440842E+07,
     +  .327651E+07, .243271E+07, .180477E+07, .133745E+07,
     +  .990281E+06, .732375E+06, .541135E+06, .399337E+06,
     +  .294402E+06, .216757E+06, .159419E+06, .117086E+06,
     +  .858974E+05, .629244E+05, .460408E+05, .336360E+05,
     +  .245435E+05, .178809E+05, .130108E+05, .945065E+04 /
        DATA (UPDI(I),I=7125,7176) /
     +  .685805E+04, .494722E+04, .358167E+04, .259002E+04,
     +  .187151E+04, .135136E+04, .975458E+03, .704716E+03,
     +  .509006E+03, .368013E+03, .266544E+03, .193476E+03,
     +  .140863E+03, .102896E+03, .755004E+02, .556408E+02,
     +  .412102E+02, .306797E+02, .229638E+02, .172769E+02,
     +  .130816E+02, .993544E+01, .759419E+01, .581987E+01,
     +  .448122E+01, .346198E+01, .268191E+01, .208238E+01,
     +  .161951E+01, .126105E+01, .982440E+00, .765465E+00,
     +  .596071E+00, .463717E+00, .360154E+00, .279155E+00,
     +  .215682E+00, .166280E+00, .127456E+00, .972367E-01,
     +  .737614E-01, .555993E-01, .415984E-01, .308660E-01,
     +  .226834E-01, .164943E-01, .118492E-01, .838691E-02,
     +  .585897E-02, .401081E-02, .268888E-02, .176006E-02 /
        DATA (UPDI(I),I=7177,7228) /
     +  .111980E-02, .689249E-03, .407330E-03, .229750E-03,
     +  .121614E-03, .598485E-04, .266707E-04, .104281E-04,
     +  .339299E-05, .854118E-06, .152142E-06, .179554E-07,
     +  .000000E+00, .260947E+08, .196879E+08, .145903E+08,
     +  .108018E+08, .799069E+07, .590505E+07, .436010E+07,
     +  .321582E+07, .236969E+07, .174415E+07, .128249E+07,
     +  .941850E+06, .690961E+06, .506233E+06, .370474E+06,
     +  .270740E+06, .197618E+06, .144029E+06, .104838E+06,
     +  .761906E+05, .552969E+05, .400666E+05, .289910E+05,
     +  .209413E+05, .151051E+05, .108746E+05, .782016E+04,
     +  .558869E+04, .400814E+04, .287078E+04, .205418E+04,
     +  .146857E+04, .104935E+04, .750338E+03, .536292E+03,
     +  .383633E+03, .274869E+03, .197350E+03, .142105E+03 /
        DATA (UPDI(I),I=7229,7280) /
     +  .102653E+03, .744835E+02, .542780E+02, .397501E+02,
     +  .292614E+02, .216571E+02, .161119E+02, .120643E+02,
     +  .906112E+01, .684987E+01, .519178E+01, .395402E+01,
     +  .302155E+01, .231540E+01, .177840E+01, .136820E+01,
     +  .105388E+01, .812177E+00, .625953E+00, .482128E+00,
     +  .370966E+00, .284935E+00, .218388E+00, .166821E+00,
     +  .127138E+00, .963126E-01, .725993E-01, .543996E-01,
     +  .404913E-01, .299049E-01, .218948E-01, .158695E-01,
     +  .113750E-01, .805032E-02, .560927E-02, .385494E-02,
     +  .259347E-02, .170696E-02, .109560E-02, .682521E-03,
     +  .410650E-03, .236744E-03, .129954E-03, .667396E-04,
     +  .317516E-04, .136177E-04, .509608E-05, .157709E-05,
     +  .375089E-06, .628481E-07, .692347E-08, .000000E+00 /
        DATA (UPDI(I),I=7281,7332) /
     +  .350495E+08, .263112E+08, .193825E+08, .142634E+08,
     +  .104871E+08, .770210E+07, .565141E+07, .414188E+07,
     +  .303250E+07, .221751E+07, .161979E+07, .118162E+07,
     +  .860978E+06, .626460E+06, .455253E+06, .330339E+06,
     +  .239380E+06, .173189E+06, .125124E+06, .902453E+05,
     +  .649922E+05, .467226E+05, .335369E+05, .240280E+05,
     +  .171877E+05, .122691E+05, .874701E+04, .619544E+04,
     +  .440353E+04, .312525E+04, .221547E+04, .156891E+04,
     +  .111022E+04, .786107E+03, .556248E+03, .393884E+03,
     +  .279315E+03, .198461E+03, .141404E+03, .101068E+03,
     +  .725529E+02, .523069E+02, .378965E+02, .275986E+02,
     +  .202082E+02, .148738E+02, .110195E+02, .818869E+01,
     +  .612552E+01, .459412E+01, .346248E+01, .261857E+01 /
        DATA (UPDI(I),I=7333,7384) /
     +  .198592E+01, .150967E+01, .114954E+01, .876378E+00,
     +  .668453E+00, .509884E+00, .388673E+00, .295951E+00,
     +  .224937E+00, .170580E+00, .128906E+00, .971792E-01,
     +  .728029E-01, .542592E-01, .401891E-01, .295611E-01,
     +  .215680E-01, .155938E-01, .111567E-01, .788998E-02,
     +  .550621E-02, .378063E-02, .255879E-02, .169377E-02,
     +  .109583E-02, .690610E-03, .421892E-03, .248537E-03,
     +  .140037E-03, .749653E-04, .374428E-04, .172696E-04,
     +  .715211E-05, .257190E-05, .760452E-06, .171481E-06,
     +  .268935E-07, .264088E-08, .000000E+00, .459258E+08,
     +  .343107E+08, .251311E+08, .183870E+08, .134399E+08,
     +  .981244E+07, .715670E+07, .521331E+07, .379346E+07,
     +  .275670E+07, .200091E+07, .145030E+07, .104988E+07 /
        DATA (UPDI(I),I=7385,7436) /
     +  .758872E+06, .547781E+06, .394779E+06, .284098E+06,
     +  .204102E+06, .146404E+06, .104828E+06, .749362E+05,
     +  .534667E+05, .380839E+05, .270732E+05, .192120E+05,
     +  .136028E+05, .961784E+04, .675417E+04, .475950E+04,
     +  .334841E+04, .235253E+04, .165088E+04, .115743E+04,
     +  .811859E+03, .568980E+03, .398996E+03, .280157E+03,
     +  .197081E+03, .139011E+03, .983518E+02, .698848E+02,
     +  .498691E+02, .357607E+02, .257770E+02, .186819E+02,
     +  .136104E+02, .998187E+01, .734266E+01, .543786E+01,
     +  .403769E+01, .301304E+01, .225628E+01, .169442E+01,
     +  .127553E+01, .961821E+00, .726154E+00, .548501E+00,
     +  .414325E+00, .312756E+00, .235815E+00, .177467E+00,
     +  .133246E+00, .996818E-01, .743870E-01, .551520E-01 /
        DATA (UPDI(I),I=7437,7488) /
     +  .406720E-01, .298024E-01, .216808E-01, .156408E-01,
     +  .111777E-01, .790194E-02, .551926E-02, .380247E-02,
     +  .257589E-02, .171920E-02, .112130E-02, .714229E-03,
     +  .442731E-03, .265732E-03, .153603E-03, .847922E-04,
     +  .443910E-04, .216341E-04, .971087E-05, .390151E-05,
     +  .135560E-05, .385371E-06, .828458E-07, .121174E-07,
     +  .995135E-09, .000000E+00, .588612E+08, .437728E+08,
     +  .318856E+08, .231995E+08, .168621E+08, .122410E+08,
     +  .887646E+07, .642838E+07, .464992E+07, .335885E+07,
     +  .242315E+07, .174554E+07, .125569E+07, .901892E+06,
     +  .646823E+06, .463113E+06, .331059E+06, .236236E+06,
     +  .168290E+06, .119659E+06, .849308E+05, .601605E+05,
     +  .425365E+05, .300121E+05, .211348E+05, .148475E+05 /
        DATA (UPDI(I),I=7489,7540) /
     +  .104147E+05, .725389E+04, .506955E+04, .353665E+04,
     +  .246353E+04, .171375E+04, .119085E+04, .827789E+03,
     +  .574823E+03, .399346E+03, .277759E+03, .193533E+03,
     +  .135194E+03, .947243E+02, .666518E+02, .470976E+02,
     +  .334429E+02, .238710E+02, .171321E+02, .123602E+02,
     +  .897792E+01, .654066E+01, .479800E+01, .352886E+01,
     +  .260867E+01, .193530E+01, .143994E+01, .107400E+01,
     +  .802443E+00, .600300E+00, .449309E+00, .336309E+00,
     +  .251552E+00, .187936E+00, .140137E+00, .104246E+00,
     +  .772602E-01, .571141E-01, .419412E-01, .306297E-01,
     +  .222227E-01, .160041E-01, .114269E-01, .808014E-02,
     +  .565025E-02, .390237E-02, .265743E-02, .177852E-02,
     +  .117224E-02, .754542E-03, .474008E-03, .289560E-03 /
        DATA (UPDI(I),I=7541,7592) /
     +  .171126E-03, .972954E-04, .527662E-04, .271014E-04,
     +  .129356E-04, .567558E-05, .222372E-05, .751199E-06,
     +  .206799E-06, .426879E-07, .582787E-08, .369428E-09,
     +  .000000E+00, .739523E+08, .547532E+08, .396727E+08,
     +  .287107E+08, .207545E+08, .149841E+08, .108051E+08,
     +  .778111E+07, .559628E+07, .401911E+07, .288247E+07,
     +  .206409E+07, .147590E+07, .105357E+07, .750915E+06,
     +  .534256E+06, .379469E+06, .269020E+06, .190378E+06,
     +  .134454E+06, .947794E+05, .666698E+05, .468049E+05,
     +  .327855E+05, .229181E+05, .159793E+05, .111232E+05,
     +  .768623E+04, .532914E+04, .368777E+04, .254767E+04,
     +  .175746E+04, .121080E+04, .834388E+03, .574301E+03,
     +  .395422E+03, .272541E+03, .188161E+03, .130229E+03 /
        DATA (UPDI(I),I=7593,7644) /
     +  .903985E+02, .630151E+02, .441120E+02, .310303E+02,
     +  .219426E+02, .156020E+02, .111524E+02, .802670E+01,
     +  .579433E+01, .421236E+01, .307038E+01, .224968E+01,
     +  .165434E+01, .122020E+01, .902244E+00, .668334E+00,
     +  .495708E+00, .367872E+00, .273019E+00, .202484E+00,
     +  .149995E+00, .110896E+00, .817916E-01, .600980E-01,
     +  .440443E-01, .320606E-01, .232065E-01, .166858E-01,
     +  .119068E-01, .842228E-02, .589887E-02, .408475E-02,
     +  .279287E-02, .188225E-02, .124623E-02, .812365E-03,
     +  .516867E-03, .320793E-03, .193491E-03, .112832E-03,
     +  .632506E-04, .337912E-04, .170792E-04, .801218E-05,
     +  .345036E-05, .132473E-05, .437556E-06, .117416E-06,
     +  .234488E-07, .300799E-08, .134340E-09, .000000E+00 /
        DATA (UPDI(I),I=7645,7696) /
     +  .640992E+04, .760848E+04, .629054E+04, .520245E+04,
     +  .430396E+04, .356190E+04, .294889E+04, .244238E+04,
     +  .202376E+04, .167769E+04, .139151E+04, .115479E+04,
     +  .958908E+03, .796770E+03, .662509E+03, .551287E+03,
     +  .459111E+03, .382685E+03, .319286E+03, .266668E+03,
     +  .222974E+03, .186670E+03, .156488E+03, .131381E+03,
     +  .110483E+03, .930778E+02, .785722E+02, .663194E+02,
     +  .562559E+02, .478532E+02, .408334E+02, .349661E+02,
     +  .300596E+02, .259661E+02, .225309E+02, .196554E+02,
     +  .172463E+02, .152258E+02, .135281E+02, .120974E+02,
     +  .108893E+02, .986240E+01, .898463E+01, .822855E+01,
     +  .757154E+01, .699508E+01, .648597E+01, .602733E+01,
     +  .561532E+01, .523747E+01, .489177E+01, .457200E+01 /
        DATA (UPDI(I),I=7697,7748) /
     +  .427408E+01, .399426E+01, .372918E+01, .347592E+01,
     +  .323229E+01, .299690E+01, .276912E+01, .254889E+01,
     +  .233652E+01, .213248E+01, .193725E+01, .175212E+01,
     +  .157554E+01, .140897E+01, .125259E+01, .110655E+01,
     +  .970867E+00, .845531E+00, .730446E+00, .625458E+00,
     +  .530298E+00, .444628E+00, .368863E+00, .301506E+00,
     +  .242697E+00, .191952E+00, .148758E+00, .112565E+00,
     +  .827975E-01, .588868E-01, .400752E-01, .258903E-01,
     +  .155945E-01, .853746E-02, .407070E-02, .156036E-02,
     +  .401710E-03, .390832E-04, .000000E+00, .178789E+05,
     +  .239555E+05, .191167E+05, .152601E+05, .121882E+05,
     +  .973832E+04, .778583E+04, .622766E+04, .498500E+04,
     +  .399252E+04, .320038E+04, .256714E+04, .206126E+04 /
        DATA (UPDI(I),I=7749,7800) /
     +  .165643E+04, .133267E+04, .107325E+04, .865530E+03,
     +  .698843E+03, .565172E+03, .457731E+03, .371428E+03,
     +  .301926E+03, .245982E+03, .200829E+03, .164397E+03,
     +  .134930E+03, .111091E+03, .915038E+02, .758624E+02,
     +  .631276E+02, .527645E+02, .442985E+02, .373853E+02,
     +  .317324E+02, .270873E+02, .232645E+02, .201184E+02,
     +  .175155E+02, .153600E+02, .135625E+02, .120620E+02,
     +  .107968E+02, .972523E+01, .880822E+01, .801798E+01,
     +  .732928E+01, .672619E+01, .618707E+01, .570731E+01,
     +  .527099E+01, .487565E+01, .451309E+01, .417855E+01,
     +  .386729E+01, .357570E+01, .330046E+01, .303936E+01,
     +  .279081E+01, .255402E+01, .232860E+01, .211455E+01,
     +  .191194E+01, .172080E+01, .154206E+01, .137381E+01 /
        DATA (UPDI(I),I=7801,7852) /
     +  .121716E+01, .107196E+01, .938055E+00, .815187E+00,
     +  .703085E+00, .601397E+00, .509778E+00, .427783E+00,
     +  .354867E+00, .291205E+00, .235338E+00, .187204E+00,
     +  .146244E+00, .111870E+00, .835020E-01, .605404E-01,
     +  .424013E-01, .283734E-01, .179971E-01, .106199E-01,
     +  .568119E-02, .263677E-02, .979407E-03, .244359E-03,
     +  .240346E-04, .000000E+00, .579087E+05, .459776E+05,
     +  .361508E+05, .284283E+05, .223630E+05, .175953E+05,
     +  .138497E+05, .109047E+05, .859029E+04, .676975E+04,
     +  .533849E+04, .421200E+04, .332591E+04, .262801E+04,
     +  .207865E+04, .164556E+04, .130434E+04, .103504E+04,
     +  .822598E+03, .654701E+03, .522072E+03, .417070E+03,
     +  .333964E+03, .268026E+03, .215718E+03, .174124E+03 /
        DATA (UPDI(I),I=7853,7904) /
     +  .141041E+03, .114309E+03, .933108E+02, .764896E+02,
     +  .630153E+02, .521756E+02, .434536E+02, .364221E+02,
     +  .307211E+02, .260882E+02, .223200E+02, .192358E+02,
     +  .167070E+02, .146170E+02, .128864E+02, .114379E+02,
     +  .102194E+02, .918316E+01, .829563E+01, .752678E+01,
     +  .685760E+01, .626308E+01, .573740E+01, .526234E+01,
     +  .483465E+01, .444491E+01, .408764E+01, .375751E+01,
     +  .345055E+01, .316322E+01, .289312E+01, .263850E+01,
     +  .239836E+01, .217206E+01, .195930E+01, .175989E+01,
     +  .157352E+01, .140085E+01, .123977E+01, .109112E+01,
     +  .954528E+00, .829651E+00, .716045E+00, .613280E+00,
     +  .520855E+00, .438304E+00, .365079E+00, .300526E+00,
     +  .244672E+00, .196110E+00, .154663E+00, .119742E+00 /
        DATA (UPDI(I),I=7905,7956) /
     +  .907327E-01, .670568E-01, .480983E-01, .333033E-01,
     +  .220063E-01, .137674E-01, .799915E-02, .420451E-02,
     +  .191147E-02, .692815E-03, .168540E-03, .167267E-04,
     +  .000000E+00, .984065E+05, .774248E+05, .602513E+05,
     +  .468859E+05, .364914E+05, .284020E+05, .221110E+05,
     +  .172152E+05, .134078E+05, .104445E+05, .813975E+04,
     +  .634560E+04, .494988E+04, .386300E+04, .301718E+04,
     +  .235816E+04, .184502E+04, .144490E+04, .113309E+04,
     +  .889710E+03, .699845E+03, .551443E+03, .435485E+03,
     +  .344682E+03, .273583E+03, .217797E+03, .174014E+03,
     +  .139105E+03, .112047E+03, .906564E+02, .737431E+02,
     +  .603110E+02, .496363E+02, .411351E+02, .343216E+02,
     +  .288461E+02, .244385E+02, .208662E+02, .179633E+02 /
        DATA (UPDI(I),I=7957,8008) /
     +  .155841E+02, .136289E+02, .120038E+02, .106455E+02,
     +  .949735E+01, .851964E+01, .767751E+01, .694866E+01,
     +  .630483E+01, .573882E+01, .523027E+01, .477507E+01,
     +  .436267E+01, .398686E+01, .364178E+01, .332310E+01,
     +  .302703E+01, .275096E+01, .249294E+01, .225175E+01,
     +  .202648E+01, .181656E+01, .162153E+01, .144077E+01,
     +  .127470E+01, .112104E+01, .980380E+00, .852168E+00,
     +  .735885E+00, .630938E+00, .536764E+00, .452741E+00,
     +  .378306E+00, .312833E+00, .255588E+00, .206484E+00,
     +  .164165E+00, .128376E+00, .985084E-01, .739413E-01,
     +  .540976E-01, .383802E-01, .262630E-01, .171288E-01,
     +  .105621E-01, .603662E-02, .311319E-02, .138345E-02,
     +  .487700E-03, .115151E-03, .115512E-04, .000000E+00 /
        DATA (UPDI(I),I=8009,8060) /
     +  .153814E+06, .120168E+06, .927614E+05, .715941E+05,
     +  .552588E+05, .426454E+05, .329140E+05, .254017E+05,
     +  .196073E+05, .151350E+05, .116860E+05, .902417E+04,
     +  .697153E+04, .538732E+04, .416560E+04, .322249E+04,
     +  .249501E+04, .193319E+04, .149961E+04, .116455E+04,
     +  .905784E+03, .705609E+03, .550819E+03, .430897E+03,
     +  .338002E+03, .265909E+03, .209951E+03, .165832E+03,
     +  .132016E+03, .105584E+03, .849147E+02, .686818E+02,
     +  .559196E+02, .458647E+02, .378878E+02, .315413E+02,
     +  .264801E+02, .224147E+02, .191381E+02, .164735E+02,
     +  .142993E+02, .125040E+02, .110125E+02, .975907E+01,
     +  .869750E+01, .778812E+01, .700516E+01, .631727E+01,
     +  .571570E+01, .517812E+01, .469948E+01, .426822E+01 /
        DATA (UPDI(I),I=8061,8112) /
     +  .387740E+01, .352066E+01, .319330E+01, .289127E+01,
     +  .261174E+01, .235254E+01, .211219E+01, .188953E+01,
     +  .168371E+01, .149402E+01, .131958E+01, .116054E+01,
     +  .101449E+01, .881827E+00, .761803E+00, .653762E+00,
     +  .556984E+00, .470795E+00, .394480E+00, .327396E+00,
     +  .268856E+00, .218076E+00, .174873E+00, .137953E+00,
     +  .107002E+00, .814057E-01, .605515E-01, .438755E-01,
     +  .308040E-01, .208424E-01, .134249E-01, .816466E-02,
     +  .459377E-02, .232659E-02, .101184E-02, .347555E-03,
     +  .798558E-04, .809202E-05, .000000E+00, .161644E+06,
     +  .176490E+06, .135315E+06, .103718E+06, .794935E+05,
     +  .609118E+05, .466721E+05, .357543E+05, .273914E+05,
     +  .209820E+05, .160743E+05, .123142E+05, .943603E+04 /
        DATA (UPDI(I),I=8113,8164) /
     +  .723139E+04, .554416E+04, .425188E+04, .326293E+04,
     +  .250538E+04, .192556E+04, .148126E+04, .114105E+04,
     +  .880184E+03, .680249E+03, .526763E+03, .408959E+03,
     +  .318393E+03, .248766E+03, .194404E+03, .153142E+03,
     +  .121208E+03, .964789E+02, .772493E+02, .622757E+02,
     +  .505922E+02, .414082E+02, .341678E+02, .284428E+02,
     +  .238824E+02, .202346E+02, .172898E+02, .149026E+02,
     +  .129440E+02, .113259E+02, .997373E+01, .883435E+01,
     +  .786334E+01, .703144E+01, .630423E+01, .567141E+01,
     +  .510878E+01, .461033E+01, .416356E+01, .376080E+01,
     +  .339525E+01, .306181E+01, .275619E+01, .247531E+01,
     +  .221676E+01, .197880E+01, .176003E+01, .155932E+01,
     +  .137571E+01, .120809E+01, .105638E+01, .918061E+00 /
        DATA (UPDI(I),I=8165,8216) /
     +  .793314E+00, .681262E+00, .581118E+00, .492056E+00,
     +  .413311E+00, .344095E+00, .283704E+00, .231405E+00,
     +  .186383E+00, .148382E+00, .116171E+00, .893941E-01,
     +  .674449E-01, .497263E-01, .356945E-01, .248069E-01,
     +  .166017E-01, .105648E-01, .633969E-02, .351325E-02,
     +  .174853E-02, .744870E-03, .249651E-03, .559506E-04,
     +  .572394E-05, .000000E+00, .342824E+06, .264644E+06,
     +  .201484E+06, .153345E+06, .116683E+06, .887555E+05,
     +  .675003E+05, .513196E+05, .390127E+05, .296497E+05,
     +  .225326E+05, .171211E+05, .130099E+05, .988547E+04,
     +  .751296E+04, .571057E+04, .434241E+04, .330324E+04,
     +  .251454E+04, .191550E+04, .146083E+04, .111538E+04,
     +  .853035E+03, .653558E+03, .501910E+03, .386471E+03 /
        DATA (UPDI(I),I=8217,8268) /
     +  .298604E+03, .230704E+03, .179692E+03, .140629E+03,
     +  .110688E+03, .876529E+02, .698990E+02, .561910E+02,
     +  .455218E+02, .371947E+02, .306712E+02, .255225E+02,
     +  .214385E+02, .181686E+02, .155371E+02, .133934E+02,
     +  .116336E+02, .101724E+02, .894812E+01, .791089E+01,
     +  .702717E+01, .625907E+01, .559435E+01, .500676E+01,
     +  .448914E+01, .402792E+01, .361463E+01, .324196E+01,
     +  .290435E+01, .259721E+01, .231712E+01, .206142E+01,
     +  .182803E+01, .161526E+01, .142169E+01, .124609E+01,
     +  .108708E+01, .944332E+00, .815236E+00, .699745E+00,
     +  .596842E+00, .505616E+00, .425143E+00, .354572E+00,
     +  .293054E+00, .239829E+00, .194131E+00, .155130E+00,
     +  .122503E+00, .951002E-01, .725365E-01, .542224E-01 /
        DATA (UPDI(I),I=8269,8320) /
     +  .395901E-01, .281267E-01, .193321E-01, .127852E-01,
     +  .803121E-02, .475142E-02, .259171E-02, .126700E-02,
     +  .528765E-03, .173154E-03, .379777E-04, .391896E-05,
     +  .000000E+00, .496800E+06, .381407E+06, .288536E+06,
     +  .218185E+06, .164937E+06, .124629E+06, .941441E+05,
     +  .710870E+05, .536634E+05, .404955E+05, .305529E+05,
     +  .230446E+05, .173797E+05, .131049E+05, .988184E+04,
     +  .745123E+04, .561976E+04, .423925E+04, .319949E+04,
     +  .241599E+04, .182603E+04, .138147E+04, .104665E+04,
     +  .794238E+03, .604002E+03, .460466E+03, .352196E+03,
     +  .269304E+03, .207608E+03, .160810E+03, .125277E+03,
     +  .982025E+02, .775303E+02, .617210E+02, .495284E+02,
     +  .400993E+02, .327759E+02, .270449E+02, .225342E+02 /
        DATA (UPDI(I),I=8321,8372) /
     +  .189501E+02, .160854E+02, .137672E+02, .118755E+02,
     +  .103140E+02, .901288E+01, .791655E+01, .698738E+01,
     +  .618410E+01, .549260E+01, .488469E+01, .435207E+01,
     +  .388021E+01, .345985E+01, .308319E+01, .274423E+01,
     +  .243807E+01, .216097E+01, .190996E+01, .168268E+01,
     +  .147715E+01, .129167E+01, .112474E+01, .974783E+00,
     +  .841217E+00, .721376E+00, .615011E+00, .520988E+00,
     +  .438298E+00, .365937E+00, .302994E+00, .248575E+00,
     +  .201888E+00, .162146E+00, .128522E+00, .100645E+00,
     +  .774481E-01, .585319E-01, .433324E-01, .313165E-01,
     +  .220070E-01, .149485E-01, .976098E-02, .604596E-02,
     +  .352169E-02, .188748E-02, .904295E-03, .368586E-03,
     +  .117438E-03, .250880E-04, .261661E-05, .000000E+00 /
        DATA (UPDI(I),I=8373,8424) /
     +  .697366E+06, .532680E+06, .400596E+06, .301114E+06,
     +  .226248E+06, .169907E+06, .127547E+06, .956995E+05,
     +  .717786E+05, .538115E+05, .403293E+05, .302125E+05,
     +  .226282E+05, .169424E+05, .126838E+05, .949394E+04,
     +  .710674E+04, .531993E+04, .398367E+04, .298407E+04,
     +  .223690E+04, .167813E+04, .126050E+04, .948145E+03,
     +  .714599E+03, .539813E+03, .409065E+03, .309817E+03,
     +  .236582E+03, .181517E+03, .140068E+03, .108767E+03,
     +  .850740E+02, .671142E+02, .533801E+02, .428491E+02,
     +  .347352E+02, .284356E+02, .235133E+02, .196298E+02,
     +  .165456E+02, .140652E+02, .120525E+02, .104003E+02,
     +  .903062E+01, .788251E+01, .691430E+01, .608155E+01,
     +  .536830E+01, .474459E+01, .420101E+01, .372214E+01 /
        DATA (UPDI(I),I=8425,8476) /
     +  .329797E+01, .292026E+01, .258256E+01, .227968E+01,
     +  .200753E+01, .176289E+01, .154307E+01, .134583E+01,
     +  .116922E+01, .101151E+01, .870918E+00, .746658E+00,
     +  .636029E+00, .538599E+00, .453146E+00, .378580E+00,
     +  .313846E+00, .257987E+00, .210087E+00, .169333E+00,
     +  .134937E+00, .106086E+00, .823807E-01, .628370E-01,
     +  .470530E-01, .344973E-01, .246760E-01, .171509E-01,
     +  .115126E-01, .742159E-02, .453234E-02, .259895E-02,
     +  .136847E-02, .642431E-03, .255704E-03, .792666E-04,
     +  .164985E-04, .173949E-05, .000000E+00, .953809E+06,
     +  .725094E+06, .542257E+06, .405298E+06, .302788E+06,
     +  .226069E+06, .168710E+06, .125830E+06, .938066E+05,
     +  .698933E+05, .520543E+05, .387483E+05, .288334E+05 /
        DATA (UPDI(I),I=8477,8528) /
     +  .214461E+05, .159476E+05, .118551E+05, .881207E+04,
     +  .654938E+04, .486850E+04, .361966E+04, .269263E+04,
     +  .200426E+04, .149346E+04, .111423E+04, .832791E+03,
     +  .623757E+03, .468607E+03, .351775E+03, .266257E+03,
     +  .202481E+03, .154864E+03, .119202E+03, .924282E+02,
     +  .722991E+02, .570282E+02, .454114E+02, .365279E+02,
     +  .296814E+02, .243683E+02, .202039E+02, .169163E+02,
     +  .142877E+02, .121658E+02, .104331E+02, .900373E+01,
     +  .781135E+01, .681061E+01, .595408E+01, .522405E+01,
     +  .458894E+01, .403829E+01, .355586E+01, .313097E+01,
     +  .275492E+01, .242087E+01, .212331E+01, .185785E+01,
     +  .162098E+01, .140973E+01, .122163E+01, .105446E+01,
     +  .906333E+00, .775267E+00, .660303E+00, .558728E+00 /
        DATA (UPDI(I),I=8529,8580) /
     +  .469955E+00, .392693E+00, .325797E+00, .268177E+00,
     +  .218852E+00, .176897E+00, .141495E+00, .111870E+00,
     +  .872344E-01, .671721E-01, .507847E-01, .376769E-01,
     +  .273545E-01, .193653E-01, .133118E-01, .882959E-02,
     +  .561907E-02, .338308E-02, .190961E-02, .987786E-03,
     +  .454363E-03, .176621E-03, .532934E-04, .108196E-04,
     +  .115298E-05, .000000E+00, .127607E+07, .965687E+06,
     +  .718334E+06, .534011E+06, .396770E+06, .294603E+06,
     +  .218624E+06, .162132E+06, .120173E+06, .890144E+05,
     +  .659011E+05, .487594E+05, .360599E+05, .266535E+05,
     +  .196936E+05, .145448E+05, .107398E+05, .792829E+04,
     +  .585289E+04, .432093E+04, .319119E+04, .235792E+04,
     +  .174381E+04, .129104E+04, .957408E+03, .711380E+03 /
        DATA (UPDI(I),I=8581,8632) /
     +  .530115E+03, .394647E+03, .296241E+03, .223417E+03,
     +  .169461E+03, .129365E+03, .994938E+02, .772085E+02,
     +  .604279E+02, .477573E+02, .381360E+02, .307719E+02,
     +  .250934E+02, .206700E+02, .171974E+02, .144358E+02,
     +  .122176E+02, .104151E+02, .893492E+01, .770589E+01,
     +  .667912E+01, .580441E+01, .506245E+01, .442020E+01,
     +  .386620E+01, .338346E+01, .296070E+01, .258881E+01,
     +  .226054E+01, .197011E+01, .171282E+01, .148489E+01,
     +  .128311E+01, .110477E+01, .947463E+00, .809101E+00,
     +  .687584E+00, .581789E+00, .489016E+00, .408547E+00,
     +  .339047E+00, .279333E+00, .228299E+00, .184957E+00,
     +  .148388E+00, .117784E+00, .923909E-01, .714546E-01,
     +  .545570E-01, .408816E-01, .300484E-01, .216027E-01 /
        DATA (UPDI(I),I=8633,8684) /
     +  .151350E-01, .102888E-01, .674308E-02, .423593E-02,
     +  .251411E-02, .139682E-02, .709757E-03, .319883E-03,
     +  .121454E-03, .356884E-04, .707539E-05, .761930E-06,
     +  .000000E+00, .167452E+07, .126172E+07, .933727E+06,
     +  .690542E+06, .510382E+06, .376948E+06, .278227E+06,
     +  .205209E+06, .151261E+06, .111414E+06, .820146E+05,
     +  .603307E+05, .443552E+05, .325890E+05, .239327E+05,
     +  .175662E+05, .128890E+05, .945362E+04, .693316E+04,
     +  .508421E+04, .372926E+04, .273630E+04, .200925E+04,
     +  .147678E+04, .108706E+04, .801627E+03, .592807E+03,
     +  .437865E+03, .326125E+03, .244037E+03, .183657E+03,
     +  .139119E+03, .106178E+03, .817814E+02, .635403E+02,
     +  .498628E+02, .395456E+02, .316997E+02, .256857E+02 /
        DATA (UPDI(I),I=8685,8736) /
     +  .210277E+02, .173900E+02, .145117E+02, .122105E+02,
     +  .103491E+02, .882722E+01, .756912E+01, .652271E+01,
     +  .563532E+01, .488612E+01, .424078E+01, .368693E+01,
     +  .320693E+01, .278893E+01, .242343E+01, .210284E+01,
     +  .182109E+01, .157322E+01, .135519E+01, .116356E+01,
     +  .995424E+00, .848200E+00, .719656E+00, .607585E+00,
     +  .510731E+00, .426429E+00, .353854E+00, .291646E+00,
     +  .238604E+00, .193624E+00, .155723E+00, .124002E+00,
     +  .976722E-01, .760091E-01, .583014E-01, .441367E-01,
     +  .327787E-01, .238678E-01, .169906E-01, .117797E-01,
     +  .791877E-02, .512756E-02, .317931E-02, .186004E-02,
     +  .101711E-02, .507646E-03, .224169E-03, .831448E-04,
     +  .238036E-04, .461355E-05, .501958E-06, .000000E+00 /
        DATA (UPDI(I),I=8737,8788) /
     +  .215966E+07, .162047E+07, .119327E+07, .878075E+06,
     +  .645701E+06, .474446E+06, .348372E+06, .255595E+06,
     +  .187396E+06, .137284E+06, .100503E+06, .735199E+05,
     +  .537461E+05, .392619E+05, .286646E+05, .209143E+05,
     +  .152528E+05, .111185E+05, .810296E+04, .590404E+04,
     +  .430236E+04, .313582E+04, .228701E+04, .166933E+04,
     +  .122016E+04, .893345E+03, .655850E+03, .480840E+03,
     +  .355497E+03, .264055E+03, .197260E+03, .148335E+03,
     +  .112398E+03, .859651E+02, .663331E+02, .517092E+02,
     +  .407469E+02, .324604E+02, .261442E+02, .212781E+02,
     +  .174966E+02, .145184E+02, .121478E+02, .102385E+02,
     +  .868390E+01, .740420E+01, .634437E+01, .544958E+01,
     +  .469760E+01, .405300E+01, .350259E+01, .302812E+01 /
        DATA (UPDI(I),I=8789,8840) /
     +  .261726E+01, .226015E+01, .194890E+01, .167715E+01,
     +  .143970E+01, .123231E+01, .105131E+01, .893645E+00,
     +  .756583E+00, .637778E+00, .534945E+00, .446721E+00,
     +  .370496E+00, .305361E+00, .249949E+00, .203061E+00,
     +  .163605E+00, .130619E+00, .103232E+00, .806861E-01,
     +  .622918E-01, .473848E-01, .355666E-01, .261775E-01,
     +  .188823E-01, .133088E-01, .913039E-02, .606906E-02,
     +  .388243E-02, .237588E-02, .137004E-02, .737281E-03,
     +  .361434E-03, .156377E-03, .566680E-04, .158141E-04,
     +  .299962E-05, .329670E-06, .000000E+00, .274182E+07,
     +  .204898E+07, .150156E+07, .109957E+07, .804613E+06,
     +  .588277E+06, .429782E+06, .313719E+06, .228824E+06,
     +  .166757E+06, .121433E+06, .883526E+05, .642366E+05 /
        DATA (UPDI(I),I=8841,8892) /
     +  .466652E+05, .338776E+05, .245763E+05, .178190E+05,
     +  .129122E+05, .935340E+04, .677331E+04, .490493E+04,
     +  .355224E+04, .257392E+04, .186636E+04, .135504E+04,
     +  .985323E+03, .718393E+03, .522983E+03, .383956E+03,
     +  .283204E+03, .210093E+03, .156899E+03, .118082E+03,
     +  .897165E+02, .687817E+02, .532838E+02, .417341E+02,
     +  .330528E+02, .264703E+02, .214242E+02, .175205E+02,
     +  .144596E+02, .120332E+02, .100868E+02, .850842E+01,
     +  .721435E+01, .614710E+01, .524993E+01, .449939E+01,
     +  .385913E+01, .331517E+01, .284877E+01, .244717E+01,
     +  .210020E+01, .179967E+01, .153900E+01, .131278E+01,
     +  .111654E+01, .946493E+00, .799404E+00, .672451E+00,
     +  .563194E+00, .469302E+00, .389331E+00, .320740E+00 /
        DATA (UPDI(I),I=8893,8944) /
     +  .262560E+00, .213435E+00, .172180E+00, .137731E+00,
     +  .109156E+00, .856205E-01, .664032E-01, .508562E-01,
     +  .383646E-01, .285495E-01, .208237E-01, .148789E-01,
     +  .103828E-01, .704796E-02, .463209E-02, .292724E-02,
     +  .176786E-02, .100472E-02, .532070E-03, .256179E-03,
     +  .108598E-03, .384560E-04, .104660E-04, .194479E-05,
     +  .215863E-06, .000000E+00, .644000E+04, .749755E+04,
     +  .619153E+04, .511410E+04, .422513E+04, .349156E+04,
     +  .288614E+04, .238641E+04, .197384E+04, .163317E+04,
     +  .135181E+04, .111939E+04, .927348E+03, .768631E+03,
     +  .637422E+03, .528920E+03, .439168E+03, .364902E+03,
     +  .303426E+03, .252519E+03, .210347E+03, .175396E+03,
     +  .146416E+03, .122375E+03, .102422E+03, .858535E+02 /
        DATA (UPDI(I),I=8945,8996) /
     +  .720870E+02, .604949E+02, .510040E+02, .431038E+02,
     +  .365238E+02, .310398E+02, .264660E+02, .226592E+02,
     +  .194708E+02, .168059E+02, .145756E+02, .127056E+02,
     +  .111342E+02, .980914E+01, .868900E+01, .773590E+01,
     +  .692041E+01, .621770E+01, .560726E+01, .507228E+01,
     +  .460061E+01, .417645E+01, .379583E+01, .344673E+01,
     +  .312689E+01, .283070E+01, .255524E+01, .229882E+01,
     +  .206067E+01, .184054E+01, .163823E+01, .145334E+01,
     +  .128513E+01, .113260E+01, .994609E+00, .869991E+00,
     +  .757648E+00, .657017E+00, .566159E+00, .484912E+00,
     +  .412544E+00, .348381E+00, .291799E+00, .242210E+00,
     +  .199052E+00, .161788E+00, .129878E+00, .102800E+00,
     +  .802841E-01, .615224E-01, .462292E-01, .339634E-01 /
        DATA (UPDI(I),I=8997,9048) /
     +  .243079E-01, .168716E-01, .112904E-01, .723492E-02,
     +  .437978E-02, .247922E-02, .128201E-02, .585989E-03,
     +  .224051E-03, .646126E-04, .111397E-04, .546004E-06,
     +  .000000E+00, .179126E+05, .238287E+05, .190035E+05,
     +  .151590E+05, .120980E+05, .965784E+04, .771400E+04,
     +  .616358E+04, .492782E+04, .394150E+04, .315486E+04,
     +  .252653E+04, .202503E+04, .162410E+04, .130382E+04,
     +  .104751E+04, .842553E+03, .678332E+03, .546855E+03,
     +  .441369E+03, .356803E+03, .288848E+03, .234277E+03,
     +  .190343E+03, .154993E+03, .126484E+03, .103493E+03,
     +  .846654E+02, .696834E+02, .575297E+02, .476764E+02,
     +  .396577E+02, .331346E+02, .278210E+02, .234706E+02,
     +  .199030E+02, .169765E+02, .145628E+02, .125696E+02 /
        DATA (UPDI(I),I=9049,9100) /
     +  .109121E+02, .953201E+01, .837169E+01, .739197E+01,
     +  .655677E+01, .584009E+01, .521863E+01, .467732E+01,
     +  .419601E+01, .376983E+01, .338399E+01, .303580E+01,
     +  .271826E+01, .242788E+01, .216199E+01, .191909E+01,
     +  .169794E+01, .149752E+01, .131665E+01, .115402E+01,
     +  .100814E+01, .877544E+00, .760854E+00, .656715E+00,
     +  .564422E+00, .481955E+00, .409008E+00, .344729E+00,
     +  .288369E+00, .239216E+00, .196624E+00, .159972E+00,
     +  .128694E+00, .102231E+00, .800366E-01, .618101E-01,
     +  .468130E-01, .347455E-01, .251987E-01, .177904E-01,
     +  .121878E-01, .804134E-02, .507621E-02, .302259E-02,
     +  .168076E-02, .852008E-03, .380996E-03, .142040E-03,
     +  .398547E-04, .671223E-05, .336279E-06, .000000E+00 /
        DATA (UPDI(I),I=9101,9152) /
     +  .577528E+05, .458382E+05, .360263E+05, .283173E+05,
     +  .222638E+05, .175068E+05, .137708E+05, .108342E+05,
     +  .852737E+04, .671360E+04, .528837E+04, .416728E+04,
     +  .328599E+04, .259238E+04, .204683E+04, .161716E+04,
     +  .127898E+04, .101238E+04, .802348E+03, .636599E+03,
     +  .505880E+03, .402577E+03, .320981E+03, .256386E+03,
     +  .205267E+03, .164729E+03, .132582E+03, .106689E+03,
     +  .864201E+02, .702434E+02, .573359E+02, .469953E+02,
     +  .387100E+02, .320605E+02, .266932E+02, .223515E+02,
     +  .188361E+02, .159722E+02, .136346E+02, .117118E+02,
     +  .101272E+02, .880788E+01, .770409E+01, .677135E+01,
     +  .597785E+01, .529552E+01, .470625E+01, .418676E+01,
     +  .373095E+01, .332215E+01, .295695E+01, .262738E+01 /
        DATA (UPDI(I),I=9153,9204) /
     +  .232928E+01, .205933E+01, .181532E+01, .159539E+01,
     +  .139793E+01, .122125E+01, .106363E+01, .923333E+00,
     +  .798658E+00, .688082E+00, .590104E+00, .503920E+00,
     +  .427480E+00, .360380E+00, .301706E+00, .250662E+00,
     +  .206496E+00, .168533E+00, .136127E+00, .108702E+00,
     +  .856974E-01, .665661E-01, .509937E-01, .382964E-01,
     +  .281747E-01, .202459E-01, .141582E-01, .960335E-02,
     +  .626862E-02, .391242E-02, .230068E-02, .126210E-02,
     +  .630144E-03, .277054E-03, .101285E-03, .278049E-04,
     +  .459299E-05, .234340E-06, .000000E+00, .982364E+05,
     +  .772727E+05, .601155E+05, .467647E+05, .363832E+05,
     +  .283054E+05, .220248E+05, .171382E+05, .133391E+05,
     +  .103831E+05, .808498E+04, .629671E+04, .490623E+04 /
        DATA (UPDI(I),I=9205,9256) /
     +  .382403E+04, .298237E+04, .232707E+04, .181724E+04,
     +  .142008E+04, .111089E+04, .869856E+03, .682075E+03,
     +  .535529E+03, .421220E+03, .331883E+03, .262087E+03,
     +  .207455E+03, .164697E+03, .130708E+03, .104451E+03,
     +  .837707E+02, .674826E+02, .546028E+02, .444130E+02,
     +  .363375E+02, .298978E+02, .247505E+02, .206298E+02,
     +  .173093E+02, .146270E+02, .124426E+02, .106592E+02,
     +  .918748E+01, .796655E+01, .694328E+01, .607960E+01,
     +  .534272E+01, .471125E+01, .415898E+01, .367836E+01,
     +  .325099E+01, .287260E+01, .253434E+01, .223132E+01,
     +  .195955E+01, .171621E+01, .149884E+01, .130528E+01,
     +  .113344E+01, .981249E+00, .846728E+00, .728006E+00,
     +  .623438E+00, .531404E+00, .451012E+00, .380206E+00 /
        DATA (UPDI(I),I=9257,9308) /
     +  .318499E+00, .264929E+00, .218670E+00, .178942E+00,
     +  .145053E+00, .116347E+00, .922452E-01, .721935E-01,
     +  .556523E-01, .423021E-01, .315115E-01, .229872E-01,
     +  .163729E-01, .113435E-01, .761520E-02, .491573E-02,
     +  .303168E-02, .175941E-02, .951324E-03, .467283E-03,
     +  .201689E-03, .721581E-04, .193322E-04, .312729E-05,
     +  .162916E-06, .000000E+00, .153629E+06, .120003E+06,
     +  .926139E+05, .714625E+05, .551413E+05, .425404E+05,
     +  .328203E+05, .253181E+05, .195326E+05, .150684E+05,
     +  .116265E+05, .897102E+04, .692406E+04, .534493E+04,
     +  .412773E+04, .318865E+04, .246476E+04, .190615E+04,
     +  .147542E+04, .114291E+04, .886405E+03, .688247E+03,
     +  .535250E+03, .416924E+03, .325445E+03, .254609E+03 /
        DATA (UPDI(I),I=9309,9360) /
     +  .199769E+03, .156655E+03, .123715E+03, .980595E+02,
     +  .780759E+02, .624503E+02, .502228E+02, .406392E+02,
     +  .330776E+02, .270975E+02, .223583E+02, .185774E+02,
     +  .155516E+02, .131099E+02, .111335E+02, .951610E+01,
     +  .818470E+01, .707742E+01, .614966E+01, .536391E+01,
     +  .469540E+01, .411506E+01, .361383E+01, .317166E+01,
     +  .278337E+01, .243925E+01, .213365E+01, .186198E+01,
     +  .162079E+01, .140708E+01, .121822E+01, .105175E+01,
     +  .905322E+00, .776741E+00, .663997E+00, .565339E+00,
     +  .479063E+00, .404197E+00, .338698E+00, .282003E+00,
     +  .233124E+00, .191212E+00, .155472E+00, .125206E+00,
     +  .997565E-01, .785502E-01, .610444E-01, .467152E-01,
     +  .352437E-01, .260488E-01, .188478E-01, .133109E-01 /
        DATA (UPDI(I),I=9361,9412) /
     +  .914043E-02, .607809E-02, .388372E-02, .236947E-02,
     +  .135905E-02, .725650E-03, .351587E-03, .149559E-03,
     +  .527113E-04, .139532E-04, .226673E-05, .124950E-06,
     +  .000000E+00, .161689E+06, .176312E+06, .135155E+06,
     +  .103576E+06, .793664E+05, .607983E+05, .465707E+05,
     +  .356638E+05, .273106E+05, .209098E+05, .160098E+05,
     +  .122567E+05, .938462E+04, .718547E+04, .550313E+04,
     +  .421520E+04, .323014E+04, .247607E+04, .189932E+04,
     +  .145778E+04, .112002E+04, .861339E+03, .663345E+03,
     +  .511588E+03, .395321E+03, .306118E+03, .237705E+03,
     +  .184436E+03, .144127E+03, .113040E+03, .890602E+02,
     +  .704953E+02, .561086E+02, .449435E+02, .362182E+02,
     +  .293839E+02, .240174E+02, .197750E+02, .164090E+02 /
        DATA (UPDI(I),I=9413,9464) /
     +  .137159E+02, .115532E+02, .979709E+01, .836204E+01,
     +  .717718E+01, .619123E+01, .536197E+01, .466121E+01,
     +  .405711E+01, .353905E+01, .308542E+01, .269011E+01,
     +  .234255E+01, .203639E+01, .176641E+01, .152859E+01,
     +  .131946E+01, .113594E+01, .975268E+00, .834839E+00,
     +  .712303E+00, .605524E+00, .512668E+00, .431966E+00,
     +  .362380E+00, .301890E+00, .249874E+00, .205327E+00,
     +  .167387E+00, .135256E+00, .108235E+00, .856754E-01,
     +  .670140E-01, .517243E-01, .393028E-01, .294362E-01,
     +  .215915E-01, .154993E-01, .108560E-01, .739038E-02,
     +  .486904E-02, .308050E-02, .185976E-02, .105459E-02,
     +  .556221E-03, .265929E-03, .111522E-03, .387300E-04,
     +  .101244E-04, .164430E-05, .948653E-07, .000000E+00 /
        DATA (UPDI(I),I=9465,9516) /
     +  .342606E+06, .264449E+06, .201310E+06, .153189E+06,
     +  .116544E+06, .886313E+05, .673894E+05, .512206E+05,
     +  .389242E+05, .295707E+05, .224620E+05, .170580E+05,
     +  .129536E+05, .983517E+04, .746800E+04, .567038E+04,
     +  .430647E+04, .327110E+04, .248578E+04, .188976E+04,
     +  .143777E+04, .109471E+04, .834491E+03, .636910E+03,
     +  .486948E+03, .373006E+03, .286474E+03, .219776E+03,
     +  .169816E+03, .131687E+03, .102575E+03, .802763E+02,
     +  .631743E+02, .500438E+02, .398872E+02, .320155E+02,
     +  .258956E+02, .211064E+02, .173423E+02, .143591E+02,
     +  .119844E+02, .100730E+02, .852368E+01, .725489E+01,
     +  .620719E+01, .533286E+01, .459963E+01, .397251E+01,
     +  .343896E+01, .297567E+01, .257536E+01, .222653E+01 /
        DATA (UPDI(I),I=9517,9568) /
     +  .192197E+01, .165579E+01, .142333E+01, .122060E+01,
     +  .104410E+01, .890729E+00, .757648E+00, .642347E+00,
     +  .542580E+00, .456435E+00, .382093E+00, .318452E+00,
     +  .263534E+00, .216661E+00, .176821E+00, .143149E+00,
     +  .114855E+00, .912479E-01, .716970E-01, .556573E-01,
     +  .426265E-01, .321299E-01, .238657E-01, .173547E-01,
     +  .123461E-01, .856623E-02, .577388E-02, .376362E-02,
     +  .235389E-02, .140358E-02, .785075E-03, .407819E-03,
     +  .191624E-03, .787490E-04, .266826E-04, .676057E-05,
     +  .105609E-05, .601164E-07, .000000E+00, .496561E+06,
     +  .381194E+06, .288345E+06, .218015E+06, .164785E+06,
     +  .124493E+06, .940229E+05, .709788E+05, .535667E+05,
     +  .404092E+05, .304757E+05, .229757E+05, .173181E+05 /
        DATA (UPDI(I),I=9569,9620) /
     +  .130499E+05, .983268E+04, .740729E+04, .558047E+04,
     +  .420410E+04, .316803E+04, .238783E+04, .180080E+04,
     +  .135886E+04, .102637E+04, .776037E+03, .587647E+03,
     +  .445754E+03, .338948E+03, .257377E+03, .196837E+03,
     +  .151069E+03, .116450E+03, .901891E+02, .702388E+02,
     +  .550702E+02, .434478E+02, .345266E+02, .276547E+02,
     +  .223269E+02, .181762E+02, .149155E+02, .123411E+02,
     +  .102858E+02, .863252E+01, .728898E+01, .618759E+01,
     +  .527521E+01, .451560E+01, .387075E+01, .332625E+01,
     +  .285719E+01, .245515E+01, .210775E+01, .180696E+01,
     +  .154630E+01, .132050E+01, .112513E+01, .956313E+00,
     +  .810686E+00, .685212E+00, .577258E+00, .484495E+00,
     +  .404956E+00, .336793E+00, .278857E+00, .229226E+00 /
        DATA (UPDI(I),I=9621,9672) /
     +  .187177E+00, .151706E+00, .121956E+00, .971515E-01,
     +  .766192E-01, .597522E-01, .460287E-01, .349744E-01,
     +  .261464E-01, .192580E-01, .138810E-01, .978447E-02,
     +  .672395E-02, .448656E-02, .289308E-02, .178867E-02,
     +  .105352E-02, .581468E-03, .297740E-03, .137734E-03,
     +  .556604E-04, .185337E-04, .462275E-05, .718673E-06,
     +  .428396E-07, .000000E+00, .697105E+06, .532447E+06,
     +  .400388E+06, .300928E+06, .226082E+06, .169759E+06,
     +  .127415E+06, .955815E+05, .716731E+05, .537173E+05,
     +  .402451E+05, .301373E+05, .225611E+05, .168824E+05,
     +  .126302E+05, .944599E+04, .706387E+04, .528158E+04,
     +  .394935E+04, .295335E+04, .220938E+04, .165347E+04,
     +  .123839E+04, .928307E+03, .696782E+03, .523793E+03 /
        DATA (UPDI(I),I=9673,9724) /
     +  .394650E+03, .296851E+03, .224885E+03, .170951E+03,
     +  .130508E+03, .100103E+03, .772069E+02, .599552E+02,
     +  .468529E+02, .368854E+02, .292737E+02, .234233E+02,
     +  .189030E+02, .153809E+02, .126216E+02, .104355E+02,
     +  .868965E+01, .728109E+01, .613438E+01, .519107E+01,
     +  .441113E+01, .375372E+01, .320263E+01, .273147E+01,
     +  .233075E+01, .198725E+01, .169221E+01, .143857E+01,
     +  .122056E+01, .103336E+01, .872779E+00, .735231E+00,
     +  .617532E+00, .516960E+00, .431131E+00, .358045E+00,
     +  .295844E+00, .243348E+00, .198702E+00, .161153E+00,
     +  .129715E+00, .103547E+00, .818964E-01, .641160E-01,
     +  .496270E-01, .379353E-01, .285973E-01, .212037E-01,
     +  .154859E-01, .110638E-01, .772717E-02, .525927E-02 /
        DATA (UPDI(I),I=9725,9776) /
     +  .347385E-02, .221594E-02, .135430E-02, .787927E-03,
     +  .429139E-03, .216623E-03, .986781E-04, .392303E-04,
     +  .128492E-04, .316096E-05, .490837E-06, .306876E-07,
     +  .000000E+00, .953525E+06, .724841E+06, .542031E+06,
     +  .405095E+06, .302607E+06, .225908E+06, .168566E+06,
     +  .125702E+06, .936917E+05, .697906E+05, .519627E+05,
     +  .386664E+05, .287603E+05, .213808E+05, .158892E+05,
     +  .118029E+05, .876538E+04, .650762E+04, .483113E+04,
     +  .358622E+04, .266269E+04, .197744E+04, .146943E+04,
     +  .109267E+04, .813439E+03, .606369E+03, .452974E+03,
     +  .337728E+03, .253601E+03, .191065E+03, .144552E+03,
     +  .109875E+03, .839781E+02, .646291E+02, .500550E+02,
     +  .390607E+02, .307326E+02, .243836E+02, .195160E+02 /
        DATA (UPDI(I),I=9777,9828) /
     +  .157525E+02, .128254E+02, .105230E+02, .869684E+01,
     +  .723352E+01, .605005E+01, .508294E+01, .428863E+01,
     +  .362367E+01, .307010E+01, .260028E+01, .220365E+01,
     +  .186626E+01, .157868E+01, .133335E+01, .112407E+01,
     +  .945666E+00, .793708E+00, .664445E+00, .554584E+00,
     +  .461341E+00, .382307E+00, .315465E+00, .258970E+00,
     +  .211622E+00, .171643E+00, .138264E+00, .110524E+00,
     +  .876086E-01, .687948E-01, .534646E-01, .410723E-01,
     +  .311544E-01, .232998E-01, .171340E-01, .124080E-01,
     +  .878656E-02, .608030E-02, .409862E-02, .267983E-02,
     +  .169102E-02, .102163E-02, .587122E-03, .315563E-03,
     +  .157045E-03, .704578E-04, .275648E-04, .888536E-05,
     +  .215713E-05, .334482E-06, .218682E-07, .000000E+00 /
        DATA (UPDI(I),I=9829,9880) /
     +  .127576E+07, .965411E+06, .718087E+06, .533791E+06,
     +  .396574E+06, .294427E+06, .218467E+06, .161992E+06,
     +  .120048E+06, .889027E+05, .658014E+05, .486703E+05,
     +  .359804E+05, .265824E+05, .196301E+05, .144880E+05,
     +  .106891E+05, .788290E+04, .581229E+04, .428461E+04,
     +  .315868E+04, .232881E+04, .171773E+04, .126767E+04,
     +  .936448E+03, .692564E+03, .513216E+03, .379481E+03,
     +  .282596E+03, .211129E+03, .158382E+03, .119366E+03,
     +  .904555E+02, .690265E+02, .530116E+02, .410253E+02,
     +  .320154E+02, .251989E+02, .200112E+02, .160291E+02,
     +  .129532E+02, .105502E+02, .865658E+01, .714899E+01,
     +  .593735E+01, .495351E+01, .415059E+01, .348282E+01,
     +  .293066E+01, .246531E+01, .207527E+01, .174592E+01 /
        DATA (UPDI(I),I=9881,9932) /
     +  .146727E+01, .123131E+01, .103148E+01, .862336E+00,
     +  .719258E+00, .598370E+00, .496313E+00, .410272E+00,
     +  .337831E+00, .276981E+00, .225901E+00, .183390E+00,
     +  .147750E+00, .118210E+00, .938421E-01, .738624E-01,
     +  .575846E-01, .444242E-01, .338709E-01, .254937E-01,
     +  .189151E-01, .137950E-01, .990549E-02, .695239E-02,
     +  .476674E-02, .318222E-02, .205954E-02, .128558E-02,
     +  .767765E-03, .435848E-03, .231185E-03, .113441E-03,
     +  .501351E-04, .193075E-04, .612810E-05, .146890E-05,
     +  .227317E-06, .154968E-07, .000000E+00, .167418E+07,
     +  .126142E+07, .933459E+06, .690302E+06, .510168E+06,
     +  .376758E+06, .278057E+06, .205057E+06, .151125E+06,
     +  .111292E+06, .819062E+05, .602339E+05, .442687E+05 /
        DATA (UPDI(I),I=9933,9984) /
     +  .325118E+05, .238637E+05, .175045E+05, .128339E+05,
     +  .940438E+04, .688913E+04, .504484E+04, .369404E+04,
     +  .270478E+04, .198104E+04, .145151E+04, .106442E+04,
     +  .781323E+03, .574594E+03, .421543E+03, .311462E+03,
     +  .230856E+03, .171797E+03, .128438E+03, .965486E+02,
     +  .730887E+02, .556856E+02, .427573E+02, .331096E+02,
     +  .258633E+02, .203865E+02, .162112E+02, .130070E+02,
     +  .105198E+02, .857193E+01, .703062E+01, .579930E+01,
     +  .480554E+01, .399952E+01, .333341E+01, .278619E+01,
     +  .232814E+01, .194689E+01, .162725E+01, .135875E+01,
     +  .113301E+01, .943174E+00, .783601E+00, .649529E+00,
     +  .537003E+00, .442632E+00, .363597E+00, .297499E+00,
     +  .242351E+00, .196371E+00, .158372E+00, .126740E+00 /
        DATA (UPDI(I),I=9985,10036) /
     +  .100712E+00, .793982E-01, .620536E-01, .480306E-01,
     +  .367812E-01, .278323E-01, .207865E-01, .153000E-01,
     +  .110664E-01, .787873E-02, .548081E-02, .372308E-02,
     +  .246148E-02, .157686E-02, .973658E-03, .574806E-03,
     +  .322335E-03, .168741E-03, .816482E-04, .355525E-04,
     +  .134818E-04, .421535E-05, .998032E-06, .154072E-06,
     +  .109243E-07, .000000E+00, .215930E+07, .162014E+07,
     +  .119298E+07, .877815E+06, .645468E+06, .474239E+06,
     +  .348187E+06, .255430E+06, .187248E+06, .137152E+06,
     +  .100386E+06, .734149E+05, .536523E+05, .391782E+05,
     +  .285898E+05, .208475E+05, .151931E+05, .110652E+05,
     +  .805531E+04, .586145E+04, .426429E+04, .310177E+04,
     +  .225656E+04, .164208E+04, .119577E+04, .871496E+03 /
        DATA (UPDI(I),I=10037,10088) /
     +  .636278E+03, .463326E+03, .339791E+03, .249963E+03,
     +  .184607E+03, .136968E+03, .102177E+03, .767653E+02,
     +  .580471E+02, .442401E+02, .340074E+02, .263740E+02,
     +  .206425E+02, .163012E+02, .129901E+02, .104355E+02,
     +  .844646E+01, .688181E+01, .563904E+01, .464187E+01,
     +  .383790E+01, .317755E+01, .263850E+01, .219026E+01,
     +  .181970E+01, .151117E+01, .125380E+01, .103892E+01,
     +  .859455E+00, .709618E+00, .584561E+00, .480290E+00,
     +  .393415E+00, .321136E+00, .261089E+00, .211325E+00,
     +  .170118E+00, .136297E+00, .108343E+00, .855066E-01,
     +  .669441E-01, .519508E-01, .399211E-01, .303458E-01,
     +  .227892E-01, .168881E-01, .123314E-01, .884533E-02,
     +  .624389E-02, .430490E-02, .289722E-02, .189692E-02 /
        DATA (UPDI(I),I=10089,10140) /
     +  .120280E-02, .734659E-03, .428735E-03, .237501E-03,
     +  .122714E-03, .585579E-04, .251274E-04, .938550E-05,
     +  .289218E-05, .676604E-06, .104155E-06, .766311E-08,
     +  .000000E+00, .274142E+07, .204862E+07, .150124E+07,
     +  .109929E+07, .804361E+06, .588052E+06, .429581E+06,
     +  .313540E+06, .228664E+06, .166614E+06, .121306E+06,
     +  .882387E+05, .641350E+05, .465745E+05, .337966E+05,
     +  .245040E+05, .177544E+05, .128545E+05, .930191E+04,
     +  .672731E+04, .486384E+04, .351553E+04, .254112E+04,
     +  .183704E+04, .132882E+04, .961873E+03, .697417E+03,
     +  .504246E+03, .367183E+03, .268186E+03, .196640E+03,
     +  .144843E+03, .107272E+03, .800160E+02, .600740E+02,
     +  .454628E+02, .347048E+02, .267315E+02, .207819E+02 /
        DATA (UPDI(I),I=10141,10192) /
     +  .163028E+02, .129065E+02, .103012E+02, .828409E+01,
     +  .670615E+01, .545976E+01, .446530E+01, .366814E+01,
     +  .301727E+01, .248925E+01, .205301E+01, .169474E+01,
     +  .139845E+01, .115297E+01, .949408E+00, .780529E+00,
     +  .640467E+00, .524335E+00, .428134E+00, .348504E+00,
     +  .282685E+00, .228368E+00, .183653E+00, .146877E+00,
     +  .116902E+00, .923022E-01, .723496E-01, .562503E-01,
     +  .433432E-01, .330662E-01, .249493E-01, .185947E-01,
     +  .136725E-01, .990365E-02, .704490E-02, .493056E-02,
     +  .336911E-02, .224639E-02, .145652E-02, .914118E-03,
     +  .552293E-03, .318616E-03, .174360E-03, .889248E-04,
     +  .418537E-04, .177021E-04, .651489E-05, .197942E-05,
     +  .457695E-06, .702326E-07, .535055E-08, .000000E+00 /
C-----------------------------------------------------------------------
C
      Dr = DrI
      Fl = FlI
      Al = AlI
      DO I=1,6
         Amass(I) = AmassI(I)
      ENDDO
      Iorder = Nint(Dr)
      Nfl = Nint(Fl)
      Alambda = Al
C
      NX = NxI
      NT = NTI
      NfMx = NfMxI
C
      QINI = QINII
      QMAX = QMAXI
      DO I=0,NT
         QL(I) = QLI(I)
      ENDDO
C
      XMIN = XMINI
      DO I=0,NX
         XV(I) = XVI(I)
      ENDDO
C
      Do 11 Iq = 0, NT
         QL(Iq) = Log (QL(Iq) /Al)
   11 Continue
C
C                  Since quark = anti-quark for nfl>2 at this stage, 
C                  we Read  out only the non-redundent data points
C     No of flavors = NfMx (sea) + 1 (gluon) + 2 (valence) 

      Nblk = (NX+1) * (NT+1)
      Npts =  Nblk  * (NfMx+3)
      DO I=1,Npts
         UPD(I) = UPDI(I)
      ENDDO
C
      Return
C                        ****************************
      End
