#include "pdf/pilot.h"
*********************************************************************
*                                                                   *
*    POLARIZED RADIATIVELY GENERATED LO AND NLO PARTON DENSITIES    *
*                         AND DIS ASYMMETRIES                       *
*                                                                   *
*         M. GLUCK, E. REYA, M. STRATMANN AND W. VOGELSANG,         *
*                  (PHYS. REV. D53 (1996) 4775)                     *       
*          PROBLEMS/QUESTIONS TO VOGELSANG@V2.RL.AC.UK              *
*            OR TO STRAT@HAL1.PHYSIK.UNI-DORTMUND.DE                *
*                                                                   *
*   INPUT:   ISET = number of the parton set :                      *
*              ISET = 1  'STANDARD' SCENARIO, NEXT-TO-LEADING ORDER *
*                        (MS-bar)                                   * 
*                        (DATA FILE 'STDNLOA1.GRID' UNIT=11, TO BE  *
*                         DEFINED BY THE USER )                     *
*              ISET = 2  'VALENCE' SCENARIO,  NEXT-TO-LEADING ORDER *
*                        (MS-bar)                                   *  
*                        (DATA FILE 'VALNLOA1.GRID' UNIT=22, TO BE  *
*                         DEFINED BY THE USER )                     *
*              ISET = 3  'STANDARD' SCENARIO, LEADING ORDER         *
*                        (DATA FILE 'STDLOA1.GRID' UNIT=33, TO BE   *
*                         DEFINED BY THE USER )                     *
*              ISET = 4  'VALENCE' SCENARIO,  LEADING ORDER         *
*                        (DATA FILE 'VALLOA1.GRID' UNIT=44, TO BE   *
*                         DEFINED BY THE USER )                     *
*                                                                   *
*            X  = Bjorken-x       (between  1.E-4  and  1)          *
*            Q2 = scale in GeV**2 (between  0.4  and   1.E4)        *
*             (for values outside the allowed range the program     *
*              writes a warning and extrapolates to the x and       *
*              Q2 values requested)                                 *
*                                                                   *
*   OUTPUT:  UV = x * ( DELTA u - DELTA u(bar) ),                   *
*            DV = x * ( DELTA d - DELTA d(bar) ),                   *        
*            QB = x * POLARIZED LIGHT SEA,                          *   
*                 QB= x * ( (DELTA U(BAR) + DELTA D(BAR))/2 )       * 
*            ST = x * DELTA STRANGE = x * DELTA STRANGE(BAR)        *     
*            GL = x * DELTA GLUON                                   *
*                                                                   *
*          (  For the parton distributions always x times           *
*                   the distribution is returned   )                *
*                                                                   *
*            A1P = A1-Proton                                        *
*            A1N = A1-Neutron                                       *
*            A1D = A1-Deuteron                                      *
*                                                                   *
*            The sets are the result of a combined fit to           *
*            data for the spin asymmetries A_1 (p,n,d)              *
*                                                                   *
*            Note: No charm is included                             *
*                                                                   *
*   COMMON:  The main program or the calling routine has to have    *
*            a common block  COMMON / INTINI / IINI , and  IINI     *
*            has always to be zero when PARPOL is called for the    *
*            first time or when 'ISET' has been changed.            *
*                                                                   *
*********************************************************************
*
      SUBROUTINE GRSVL1 (DX,DQ,DUV,DDV,DSEA,DSTR,DCHM,DBOT,DTOP,DGL)
C      SUBROUTINE GRSVL1 (X, Q2, UV, DV, QB, ST, GL, A1P, A1N, A1D)
#include "pdf/impdp.inc"
      PARAMETER (NPART=8, NX=42, NQ=25, NARG=2)
      DIMENSION
     +          XUVF(NX,NQ), XDVF(NX,NQ), XQBF(NX,NQ), 
     1          XSF(NX,NQ), XGF(NX,NQ), 
     2          XAPF(NX,NQ), XANF(NX,NQ), XADF(NX,NQ),
     3          QS(NQ), XB(NX), XT(NARG), NA(NARG), ARRF(NX+NQ)
      DIMENSION
     +       PARTON (NPART,NQ,NX-1)
      COMMON / GRSVA1 / A1P, A1N, A1D
C      COMMON / INTINI / IINI
      SAVE XUVF, XDVF, XQBF, XSF, XGF, XAPF, XANF, XADF, NA, ARRF
       DATA ZEROD/0.D0/
*...BJORKEN-X AND Q**2 VALUES OF THE GRID :
       DATA QS / 0.4D0, 0.5d0, 0.6d0, 0.75D0, 1.0D0,
     1           1.25d0, 1.5D0, 2.d0, 2.5D0, 
     1           4.0D0, 6.4D0, 1.0D1, 1.5D1, 2.5D1, 4.0D1, 6.4D1,
     2           1.0D2, 1.8D2, 3.2D2, 5.8D2, 1.0D3, 1.8D3,
     3           3.2D3, 5.8D3, 1.0D4 /
       DATA XB / 1.D-4, 1.5D-4, 2.2D-4, 3.2D-4, 4.8D-4, 7.D-4,
     2           1.D-3, 1.5D-3, 2.2D-3, 3.2D-3, 4.8D-3, 7.D-3,
     3           1.D-2, 1.5D-2, 2.2D-2, 3.2D-2, 5.0D-2, 7.5D-2,
     4           0.1D0, 0.125D0, 0.15D0, 0.175D0, 0.2D0, 0.225D0, 
     +           0.25D0, 0.275D0,
     5           0.3D0, 0.325D0, 0.35D0, 0.375D0, 0.4D0, 0.45D0,  
     +           0.5D0, 0.55D0,
     6           0.6D0, 0.65D0,  0.7D0,  0.75D0,  0.8D0, 0.85D0,  
     +           0.9D0, 1.0D0 /
       DATA IINI/0/
C
        DATA ((PARTON(I,N,1),I=1,8),N=1,8)/
     +   .1731D-02, -.4278D-02, -.7126D-04, -.7126D-04,  .5943D-03,
     +   .2201D-02, -.1951D-01, -.8012D-02,
     +   .1897D-02, -.4422D-02, -.1137D-03, -.1137D-03,  .1483D-02,
     +   .1544D-02, -.1447D-01, -.5957D-02,
     +   .2029D-02, -.4533D-02, -.1558D-03, -.1558D-03,  .2529D-02,
     +   .1118D-02, -.1159D-01, -.4815D-02,
     +   .2186D-02, -.4661D-02, -.2158D-03, -.2158D-03,  .4216D-02,
     +   .7223D-03, -.9133D-02, -.3859D-02,
     +   .2382D-02, -.4816D-02, -.3053D-03, -.3053D-03,  .7051D-02,
     +   .3617D-03, -.7058D-02, -.3067D-02,
     +   .2529D-02, -.4930D-02, -.3831D-03, -.3831D-03,  .9753D-02,
     +   .1619D-03, -.5972D-02, -.2659D-02,
     +   .2646D-02, -.5018D-02, -.4513D-03, -.4513D-03,  .1228D-01,
     +   .3490D-04, -.5302D-02, -.2409D-02,
     +   .2826D-02, -.5151D-02, -.5663D-03, -.5663D-03,  .1681D-01,
     +  -.1184D-03, -.4513D-02, -.2117D-02 /
        DATA ((PARTON(I,N,1),I=1,8),N=9,16)/
     +   .2961D-02, -.5249D-02, -.6599D-03, -.6599D-03,  .2075D-01,
     +  -.2075D-03, -.4055D-02, -.1948D-02,
     +   .3239D-02, -.5445D-02, -.8714D-03, -.8714D-03,  .3033D-01,
     +  -.3435D-03, -.3373D-02, -.1698D-02,
     +   .3506D-02, -.5629D-02, -.1096D-02, -.1096D-02,  .4147D-01,
     +  -.4325D-03, -.2922D-02, -.1532D-02,
     +   .3751D-02, -.5793D-02, -.1316D-02, -.1316D-02,  .5333D-01,
     +  -.4898D-03, -.2618D-02, -.1419D-02,
     +   .3967D-02, -.5934D-02, -.1519D-02, -.1519D-02,  .6508D-01,
     +  -.5264D-03, -.2408D-02, -.1340D-02,
     +   .4228D-02, -.6101D-02, -.1774D-02, -.1774D-02,  .8088D-01,
     +  -.5569D-03, -.2201D-02, -.1259D-02,
     +   .4464D-02, -.6250D-02, -.2012D-02, -.2012D-02,  .9667D-01,
     +  -.5766D-03, -.2054D-02, -.1201D-02,
     +   .4694D-02, -.6392D-02, -.2247D-02, -.2247D-02,  .1134D+00,
     +  -.5896D-03, -.1933D-02, -.1152D-02 /
        DATA ((PARTON(I,N,1),I=1,8),N=17,25)/
     +   .4908D-02, -.6522D-02, -.2467D-02, -.2467D-02,  .1301D+00,
     +  -.5971D-03, -.1838D-02, -.1112D-02,
     +   .5183D-02, -.6687D-02, -.2750D-02, -.2750D-02,  .1531D+00,
     +  -.6017D-03, -.1731D-02, -.1065D-02,
     +   .5445D-02, -.6842D-02, -.3017D-02, -.3017D-02,  .1766D+00,
     +  -.6016D-03, -.1644D-02, -.1025D-02,
     +   .5708D-02, -.6995D-02, -.3281D-02, -.3281D-02,  .2018D+00,
     +  -.5980D-03, -.1566D-02, -.9878D-03,
     +   .5944D-02, -.7130D-02, -.3512D-02, -.3512D-02,  .2255D+00,
     +  -.5921D-03, -.1503D-02, -.9563D-03,
     +   .6192D-02, -.7270D-02, -.3748D-02, -.3748D-02,  .2517D+00,
     +  -.5838D-03, -.1442D-02, -.9246D-03,
     +   .6430D-02, -.7403D-02, -.3965D-02, -.3965D-02,  .2779D+00,
     +  -.5739D-03, -.1388D-02, -.8955D-03,
     +   .6670D-02, -.7536D-02, -.4175D-02, -.4175D-02,  .3054D+00,
     +  -.5624D-03, -.1336D-02, -.8669D-03,
     +   .6885D-02, -.7654D-02, -.4354D-02, -.4354D-02,  .3309D+00,
     +  -.5509D-03, -.1293D-02, -.8418D-03 /
        DATA ((PARTON(I,N,2),I=1,8),N=1,8)/
     +   .2303D-02, -.4980D-02, -.1013D-03, -.1013D-03,  .9912D-03,
     +   .3502D-02, -.2140D-01, -.8297D-02,
     +   .2520D-02, -.5150D-02, -.1571D-03, -.1571D-03,  .2218D-02,
     +   .2560D-02, -.1652D-01, -.6439D-02,
     +   .2693D-02, -.5280D-02, -.2111D-03, -.2111D-03,  .3613D-02,
     +   .1939D-02, -.1359D-01, -.5359D-02,
     +   .2897D-02, -.5431D-02, -.2867D-03, -.2867D-03,  .5805D-02,
     +   .1352D-02, -.1098D-01, -.4420D-02,
     +   .3151D-02, -.5613D-02, -.3973D-03, -.3973D-03,  .9405D-02,
     +   .8092D-03, -.8696D-02, -.3614D-02,
     +   .3342D-02, -.5746D-02, -.4916D-03, -.4916D-03,  .1278D-01,
     +   .5062D-03, -.7465D-02, -.3186D-02,
     +   .3494D-02, -.5850D-02, -.5733D-03, -.5733D-03,  .1589D-01,
     +   .3126D-03, -.6692D-02, -.2919D-02,
     +   .3727D-02, -.6006D-02, -.7091D-03, -.7091D-03,  .2141D-01,
     +   .7848D-04, -.5765D-02, -.2600D-02 /
        DATA ((PARTON(I,N,2),I=1,8),N=9,16)/
     +   .3900D-02, -.6121D-02, -.8182D-03, -.8182D-03,  .2614D-01,
     +  -.5813D-04, -.5217D-02, -.2411D-02,
     +   .4258D-02, -.6351D-02, -.1061D-02, -.1061D-02,  .3752D-01,
     +  -.2658D-03, -.4388D-02, -.2126D-02,
     +   .4601D-02, -.6566D-02, -.1313D-02, -.1313D-02,  .5054D-01,
     +  -.4009D-03, -.3828D-02, -.1932D-02,
     +   .4915D-02, -.6758D-02, -.1556D-02, -.1556D-02,  .6423D-01,
     +  -.4873D-03, -.3444D-02, -.1795D-02,
     +   .5191D-02, -.6924D-02, -.1776D-02, -.1776D-02,  .7764D-01,
     +  -.5423D-03, -.3174D-02, -.1697D-02,
     +   .5523D-02, -.7120D-02, -.2049D-02, -.2049D-02,  .9548D-01,
     +  -.5881D-03, -.2906D-02, -.1595D-02,
     +   .5823D-02, -.7294D-02, -.2298D-02, -.2298D-02,  .1131D+00,
     +  -.6169D-03, -.2711D-02, -.1520D-02,
     +   .6116D-02, -.7460D-02, -.2542D-02, -.2542D-02,  .1317D+00,
     +  -.6354D-03, -.2551D-02, -.1455D-02 /
        DATA ((PARTON(I,N,2),I=1,8),N=17,25)/
     +   .6387D-02, -.7613D-02, -.2766D-02, -.2766D-02,  .1501D+00,
     +  -.6458D-03, -.2423D-02, -.1401D-02,
     +   .6734D-02, -.7805D-02, -.3049D-02, -.3049D-02,  .1752D+00,
     +  -.6515D-03, -.2279D-02, -.1338D-02,
     +   .7064D-02, -.7985D-02, -.3311D-02, -.3311D-02,  .2006D+00,
     +  -.6504D-03, -.2159D-02, -.1282D-02,
     +   .7396D-02, -.8164D-02, -.3565D-02, -.3565D-02,  .2276D+00,
     +  -.6440D-03, -.2051D-02, -.1230D-02,
     +   .7693D-02, -.8321D-02, -.3783D-02, -.3783D-02,  .2529D+00,
     +  -.6347D-03, -.1963D-02, -.1186D-02,
     +   .8004D-02, -.8485D-02, -.4000D-02, -.4000D-02,  .2806D+00,
     +  -.6217D-03, -.1878D-02, -.1141D-02,
     +   .8302D-02, -.8639D-02, -.4196D-02, -.4196D-02,  .3081D+00,
     +  -.6067D-03, -.1802D-02, -.1100D-02,
     +   .8602D-02, -.8794D-02, -.4380D-02, -.4380D-02,  .3369D+00,
     +  -.5893D-03, -.1730D-02, -.1059D-02,
     +   .8871D-02, -.8931D-02, -.4533D-02, -.4533D-02,  .3634D+00,
     +  -.5722D-03, -.1669D-02, -.1023D-02 /
        DATA ((PARTON(I,N,3),I=1,8),N=1,8)/
     +   .3015D-02, -.5753D-02, -.1415D-03, -.1415D-03,  .1505D-02,
     +   .5037D-02, -.2323D-01, -.8438D-02,
     +   .3295D-02, -.5951D-02, -.2133D-03, -.2133D-03,  .3143D-02,
     +   .3819D-02, -.1859D-01, -.6821D-02,
     +   .3516D-02, -.6103D-02, -.2815D-03, -.2815D-03,  .4951D-02,
     +   .2994D-02, -.1568D-01, -.5839D-02,
     +   .3778D-02, -.6279D-02, -.3750D-03, -.3750D-03,  .7731D-02,
     +   .2196D-02, -.1298D-01, -.4955D-02,
     +   .4103D-02, -.6491D-02, -.5092D-03, -.5092D-03,  .1220D-01,
     +   .1444D-02, -.1053D-01, -.4167D-02,
     +   .4346D-02, -.6646D-02, -.6217D-03, -.6217D-03,  .1632D-01,
     +   .1017D-02, -.9172D-02, -.3734D-02,
     +   .4539D-02, -.6767D-02, -.7178D-03, -.7178D-03,  .2008D-01,
     +   .7427D-03, -.8300D-02, -.3459D-02,
     +   .4835D-02, -.6949D-02, -.8756D-03, -.8756D-03,  .2668D-01,
     +   .4083D-03, -.7234D-02, -.3122D-02 /
        DATA ((PARTON(I,N,3),I=1,8),N=9,16)/
     +   .5055D-02, -.7083D-02, -.1001D-02, -.1001D-02,  .3227D-01,
     +   .2117D-03, -.6594D-02, -.2918D-02,
     +   .5507D-02, -.7351D-02, -.1274D-02, -.1274D-02,  .4555D-01,
     +  -.8722D-04, -.5605D-02, -.2601D-02,
     +   .5940D-02, -.7601D-02, -.1552D-02, -.1552D-02,  .6050D-01,
     +  -.2819D-03, -.4922D-02, -.2377D-02,
     +   .6335D-02, -.7824D-02, -.1815D-02, -.1815D-02,  .7603D-01,
     +  -.4063D-03, -.4445D-02, -.2216D-02,
     +   .6681D-02, -.8016D-02, -.2051D-02, -.2051D-02,  .9109D-01,
     +  -.4852D-03, -.4106D-02, -.2097D-02,
     +   .7098D-02, -.8244D-02, -.2336D-02, -.2336D-02,  .1109D+00,
     +  -.5512D-03, -.3764D-02, -.1970D-02,
     +   .7473D-02, -.8445D-02, -.2593D-02, -.2593D-02,  .1304D+00,
     +  -.5919D-03, -.3513D-02, -.1874D-02,
     +   .7838D-02, -.8638D-02, -.2839D-02, -.2839D-02,  .1506D+00,
     +  -.6178D-03, -.3304D-02, -.1791D-02 /
        DATA ((PARTON(I,N,3),I=1,8),N=17,25)/
     +   .8175D-02, -.8815D-02, -.3062D-02, -.3062D-02,  .1705D+00,
     +  -.6320D-03, -.3135D-02, -.1720D-02,
     +   .8607D-02, -.9037D-02, -.3339D-02, -.3339D-02,  .1975D+00,
     +  -.6391D-03, -.2943D-02, -.1636D-02,
     +   .9016D-02, -.9246D-02, -.3589D-02, -.3589D-02,  .2245D+00,
     +  -.6367D-03, -.2782D-02, -.1561D-02,
     +   .9427D-02, -.9452D-02, -.3826D-02, -.3826D-02,  .2531D+00,
     +  -.6269D-03, -.2637D-02, -.1490D-02,
     +   .9793D-02, -.9633D-02, -.4024D-02, -.4024D-02,  .2796D+00,
     +  -.6130D-03, -.2518D-02, -.1429D-02,
     +   .1018D-01, -.9822D-02, -.4217D-02, -.4217D-02,  .3085D+00,
     +  -.5940D-03, -.2402D-02, -.1368D-02,
     +   .1054D-01, -.1000D-01, -.4385D-02, -.4385D-02,  .3370D+00,
     +  -.5724D-03, -.2298D-02, -.1310D-02,
     +   .1091D-01, -.1018D-01, -.4537D-02, -.4537D-02,  .3666D+00,
     +  -.5476D-03, -.2200D-02, -.1254D-02,
     +   .1124D-01, -.1034D-01, -.4659D-02, -.4659D-02,  .3938D+00,
     +  -.5233D-03, -.2116D-02, -.1205D-02 /
        DATA ((PARTON(I,N,4),I=1,8),N=1,8)/
     +   .3923D-02, -.6631D-02, -.1965D-03, -.1965D-03,  .2180D-02,
     +   .6857D-02, -.2505D-01, -.8441D-02,
     +   .4281D-02, -.6861D-02, -.2882D-03, -.2882D-03,  .4325D-02,
     +   .5377D-02, -.2075D-01, -.7101D-02,
     +   .4562D-02, -.7038D-02, -.3734D-03, -.3734D-03,  .6631D-02,
     +   .4344D-02, -.1792D-01, -.6254D-02,
     +   .4895D-02, -.7243D-02, -.4881D-03, -.4881D-03,  .1011D-01,
     +   .3320D-02, -.1521D-01, -.5461D-02,
     +   .5307D-02, -.7489D-02, -.6493D-03, -.6493D-03,  .1559D-01,
     +   .2331D-02, -.1264D-01, -.4725D-02,
     +   .5614D-02, -.7670D-02, -.7820D-03, -.7820D-03,  .2056D-01,
     +   .1759D-02, -.1116D-01, -.4306D-02,
     +   .5858D-02, -.7810D-02, -.8940D-03, -.8940D-03,  .2505D-01,
     +   .1387D-02, -.1020D-01, -.4031D-02,
     +   .6231D-02, -.8022D-02, -.1075D-02, -.1075D-02,  .3284D-01,
     +   .9303D-03, -.8992D-02, -.3687D-02 /
        DATA ((PARTON(I,N,4),I=1,8),N=9,16)/
     +   .6508D-02, -.8177D-02, -.1217D-02, -.1217D-02,  .3937D-01,
     +   .6593D-03, -.8254D-02, -.3472D-02,
     +   .7075D-02, -.8488D-02, -.1521D-02, -.1521D-02,  .5468D-01,
     +   .2453D-03, -.7093D-02, -.3129D-02,
     +   .7616D-02, -.8778D-02, -.1824D-02, -.1824D-02,  .7167D-01,
     +  -.2557D-04, -.6270D-02, -.2876D-02,
     +   .8109D-02, -.9036D-02, -.2105D-02, -.2105D-02,  .8908D-01,
     +  -.1989D-03, -.5685D-02, -.2687D-02,
     +   .8539D-02, -.9259D-02, -.2352D-02, -.2352D-02,  .1058D+00,
     +  -.3089D-03, -.5263D-02, -.2544D-02,
     +   .9056D-02, -.9522D-02, -.2646D-02, -.2646D-02,  .1276D+00,
     +  -.4015D-03, -.4830D-02, -.2389D-02,
     +   .9521D-02, -.9755D-02, -.2905D-02, -.2905D-02,  .1487D+00,
     +  -.4579D-03, -.4510D-02, -.2268D-02,
     +   .9972D-02, -.9977D-02, -.3149D-02, -.3149D-02,  .1706D+00,
     +  -.4933D-03, -.4240D-02, -.2161D-02 /
        DATA ((PARTON(I,N,4),I=1,8),N=17,25)/
     +   .1039D-01, -.1018D-01, -.3366D-02, -.3366D-02,  .1918D+00,
     +  -.5124D-03, -.4018D-02, -.2069D-02,
     +   .1092D-01, -.1044D-01, -.3628D-02, -.3628D-02,  .2204D+00,
     +  -.5216D-03, -.3767D-02, -.1958D-02,
     +   .1142D-01, -.1068D-01, -.3859D-02, -.3859D-02,  .2489D+00,
     +  -.5174D-03, -.3553D-02, -.1858D-02,
     +   .1193D-01, -.1091D-01, -.4072D-02, -.4072D-02,  .2787D+00,
     +  -.5031D-03, -.3359D-02, -.1763D-02,
     +   .1237D-01, -.1112D-01, -.4243D-02, -.4243D-02,  .3062D+00,
     +  -.4834D-03, -.3200D-02, -.1681D-02,
     +   .1284D-01, -.1134D-01, -.4404D-02, -.4404D-02,  .3360D+00,
     +  -.4567D-03, -.3044D-02, -.1598D-02,
     +   .1329D-01, -.1154D-01, -.4537D-02, -.4537D-02,  .3651D+00,
     +  -.4265D-03, -.2904D-02, -.1520D-02,
     +   .1374D-01, -.1175D-01, -.4652D-02, -.4652D-02,  .3952D+00,
     +  -.3921D-03, -.2771D-02, -.1444D-02,
     +   .1414D-01, -.1193D-01, -.4736D-02, -.4736D-02,  .4226D+00,
     +  -.3585D-03, -.2657D-02, -.1377D-02 /
        DATA ((PARTON(I,N,5),I=1,8),N=1,8)/
     +   .5216D-02, -.7740D-02, -.2812D-03, -.2812D-03,  .3158D-02,
     +   .9210D-02, -.2709D-01, -.8289D-02,
     +   .5680D-02, -.8012D-02, -.4001D-03, -.4001D-03,  .5996D-02,
     +   .7473D-02, -.2325D-01, -.7281D-02,
     +   .6044D-02, -.8220D-02, -.5080D-03, -.5080D-03,  .8969D-02,
     +   .6220D-02, -.2059D-01, -.6615D-02,
     +   .6474D-02, -.8462D-02, -.6502D-03, -.6502D-03,  .1336D-01,
     +   .4942D-02, -.1792D-01, -.5962D-02,
     +   .7004D-02, -.8753D-02, -.8454D-03, -.8454D-03,  .2013D-01,
     +   .3672D-02, -.1529D-01, -.5324D-02,
     +   .7399D-02, -.8965D-02, -.1003D-02, -.1003D-02,  .2617D-01,
     +   .2922D-02, -.1371D-01, -.4941D-02,
     +   .7711D-02, -.9131D-02, -.1134D-02, -.1134D-02,  .3156D-01,
     +   .2427D-02, -.1266D-01, -.4682D-02,
     +   .8187D-02, -.9380D-02, -.1342D-02, -.1342D-02,  .4079D-01,
     +   .1812D-02, -.1131D-01, -.4344D-02 /
        DATA ((PARTON(I,N,5),I=1,8),N=9,16)/
     +   .8541D-02, -.9562D-02, -.1503D-02, -.1503D-02,  .4845D-01,
     +   .1442D-02, -.1047D-01, -.4124D-02,
     +   .9263D-02, -.9927D-02, -.1840D-02, -.1840D-02,  .6613D-01,
     +   .8739D-03, -.9100D-02, -.3758D-02,
     +   .9949D-02, -.1027D-01, -.2168D-02, -.2168D-02,  .8543D-01,
     +   .4990D-03, -.8106D-02, -.3474D-02,
     +   .1057D-01, -.1057D-01, -.2464D-02, -.2464D-02,  .1049D+00,
     +   .2580D-03, -.7382D-02, -.3253D-02,
     +   .1111D-01, -.1083D-01, -.2720D-02, -.2720D-02,  .1234D+00,
     +   .1047D-03, -.6850D-02, -.3080D-02,
     +   .1176D-01, -.1114D-01, -.3016D-02, -.3016D-02,  .1473D+00,
     +  -.2529D-04, -.6298D-02, -.2887D-02,
     +   .1235D-01, -.1141D-01, -.3271D-02, -.3271D-02,  .1701D+00,
     +  -.1035D-03, -.5882D-02, -.2732D-02,
     +   .1291D-01, -.1167D-01, -.3505D-02, -.3505D-02,  .1935D+00,
     +  -.1523D-03, -.5528D-02, -.2593D-02 /
        DATA ((PARTON(I,N,5),I=1,8),N=17,25)/
     +   .1343D-01, -.1191D-01, -.3708D-02, -.3708D-02,  .2161D+00,
     +  -.1782D-03, -.5235D-02, -.2471D-02,
     +   .1409D-01, -.1221D-01, -.3945D-02, -.3945D-02,  .2462D+00,
     +  -.1899D-03, -.4898D-02, -.2323D-02,
     +   .1472D-01, -.1248D-01, -.4147D-02, -.4147D-02,  .2759D+00,
     +  -.1831D-03, -.4611D-02, -.2188D-02,
     +   .1534D-01, -.1276D-01, -.4323D-02, -.4323D-02,  .3067D+00,
     +  -.1622D-03, -.4348D-02, -.2059D-02,
     +   .1590D-01, -.1300D-01, -.4457D-02, -.4457D-02,  .3348D+00,
     +  -.1340D-03, -.4131D-02, -.1947D-02,
     +   .1648D-01, -.1325D-01, -.4575D-02, -.4575D-02,  .3650D+00,
     +  -.9626D-04, -.3918D-02, -.1832D-02,
     +   .1703D-01, -.1349D-01, -.4663D-02, -.4663D-02,  .3944D+00,
     +  -.5383D-04, -.3726D-02, -.1725D-02,
     +   .1758D-01, -.1372D-01, -.4729D-02, -.4729D-02,  .4245D+00,
     +  -.5745D-05, -.3543D-02, -.1620D-02,
     +   .1807D-01, -.1393D-01, -.4767D-02, -.4767D-02,  .4518D+00,
     +   .4108D-04, -.3387D-02, -.1527D-02 /
        DATA ((PARTON(I,N,6),I=1,8),N=1,8)/
     +   .6793D-02, -.8947D-02, -.3938D-03, -.3938D-03,  .4368D-02,
     +   .1178D-01, -.2908D-01, -.8006D-02,
     +   .7383D-02, -.9265D-02, -.5447D-03, -.5447D-03,  .8016D-02,
     +   .9842D-02, -.2573D-01, -.7325D-02,
     +   .7845D-02, -.9509D-02, -.6783D-03, -.6783D-03,  .1175D-01,
     +   .8404D-02, -.2331D-01, -.6851D-02,
     +   .8388D-02, -.9791D-02, -.8509D-03, -.8509D-03,  .1715D-01,
     +   .6899D-02, -.2077D-01, -.6361D-02,
     +   .9057D-02, -.1013D-01, -.1083D-02, -.1083D-02,  .2533D-01,
     +   .5365D-02, -.1814D-01, -.5849D-02,
     +   .9552D-02, -.1038D-01, -.1266D-02, -.1266D-02,  .3250D-01,
     +   .4438D-02, -.1651D-01, -.5522D-02,
     +   .9944D-02, -.1057D-01, -.1416D-02, -.1416D-02,  .3883D-01,
     +   .3818D-02, -.1539D-01, -.5289D-02,
     +   .1054D-01, -.1086D-01, -.1651D-02, -.1651D-02,  .4955D-01,
     +   .3037D-02, -.1392D-01, -.4971D-02 /
        DATA ((PARTON(I,N,6),I=1,8),N=9,16)/
     +   .1098D-01, -.1107D-01, -.1829D-02, -.1829D-02,  .5834D-01,
     +   .2563D-02, -.1297D-01, -.4755D-02,
     +   .1188D-01, -.1150D-01, -.2196D-02, -.2196D-02,  .7836D-01,
     +   .1827D-02, -.1141D-01, -.4375D-02,
     +   .1273D-01, -.1189D-01, -.2542D-02, -.2542D-02,  .9986D-01,
     +   .1336D-02, -.1024D-01, -.4063D-02,
     +   .1350D-01, -.1224D-01, -.2848D-02, -.2848D-02,  .1213D+00,
     +   .1019D-02, -.9362D-02, -.3808D-02,
     +   .1417D-01, -.1254D-01, -.3106D-02, -.3106D-02,  .1414D+00,
     +   .8173D-03, -.8710D-02, -.3602D-02,
     +   .1497D-01, -.1290D-01, -.3397D-02, -.3397D-02,  .1670D+00,
     +   .6447D-03, -.8022D-02, -.3367D-02,
     +   .1569D-01, -.1321D-01, -.3641D-02, -.3641D-02,  .1913D+00,
     +   .5419D-03, -.7496D-02, -.3173D-02,
     +   .1638D-01, -.1351D-01, -.3858D-02, -.3858D-02,  .2159D+00,
     +   .4784D-03, -.7043D-02, -.2996D-02 /
        DATA ((PARTON(I,N,6),I=1,8),N=17,25)/
     +   .1701D-01, -.1378D-01, -.4040D-02, -.4040D-02,  .2394D+00,
     +   .4453D-03, -.6666D-02, -.2838D-02,
     +   .1782D-01, -.1413D-01, -.4245D-02, -.4245D-02,  .2706D+00,
     +   .4316D-03, -.6229D-02, -.2645D-02,
     +   .1858D-01, -.1445D-01, -.4409D-02, -.4409D-02,  .3009D+00,
     +   .4424D-03, -.5853D-02, -.2469D-02,
     +   .1934D-01, -.1476D-01, -.4543D-02, -.4543D-02,  .3322D+00,
     +   .4718D-03, -.5506D-02, -.2297D-02,
     +   .2001D-01, -.1504D-01, -.4635D-02, -.4635D-02,  .3605D+00,
     +   .5107D-03, -.5219D-02, -.2148D-02,
     +   .2071D-01, -.1532D-01, -.4704D-02, -.4704D-02,  .3907D+00,
     +   .5622D-03, -.4937D-02, -.1996D-02,
     +   .2137D-01, -.1559D-01, -.4744D-02, -.4744D-02,  .4198D+00,
     +   .6196D-03, -.4682D-02, -.1854D-02,
     +   .2204D-01, -.1586D-01, -.4758D-02, -.4758D-02,  .4494D+00,
     +   .6844D-03, -.4439D-02, -.1713D-02,
     +   .2263D-01, -.1610D-01, -.4747D-02, -.4747D-02,  .4761D+00,
     +   .7472D-03, -.4231D-02, -.1590D-02 /
        DATA ((PARTON(I,N,7),I=1,8),N=1,8)/
     +   .8715D-02, -.1027D-01, -.5433D-03, -.5433D-03,  .5854D-02,
     +   .1455D-01, -.3110D-01, -.7632D-02,
     +   .9452D-02, -.1064D-01, -.7313D-03, -.7313D-03,  .1044D-01,
     +   .1247D-01, -.2827D-01, -.7260D-02,
     +   .1003D-01, -.1093D-01, -.8941D-03, -.8941D-03,  .1503D-01,
     +   .1089D-01, -.2611D-01, -.6979D-02,
     +   .1070D-01, -.1125D-01, -.1100D-02, -.1100D-02,  .2156D-01,
     +   .9203D-02, -.2376D-01, -.6662D-02,
     +   .1153D-01, -.1165D-01, -.1370D-02, -.1370D-02,  .3126D-01,
     +   .7437D-02, -.2121D-01, -.6293D-02,
     +   .1214D-01, -.1193D-01, -.1579D-02, -.1579D-02,  .3963D-01,
     +   .6348D-02, -.1956D-01, -.6033D-02,
     +   .1263D-01, -.1216D-01, -.1748D-02, -.1748D-02,  .4693D-01,
     +   .5611D-02, -.1840D-01, -.5836D-02,
     +   .1336D-01, -.1249D-01, -.2009D-02, -.2009D-02,  .5917D-01,
     +   .4670D-02, -.1683D-01, -.5549D-02 /
        DATA ((PARTON(I,N,7),I=1,8),N=9,16)/
     +   .1390D-01, -.1274D-01, -.2203D-02, -.2203D-02,  .6908D-01,
     +   .4091D-02, -.1580D-01, -.5341D-02,
     +   .1501D-01, -.1322D-01, -.2595D-02, -.2595D-02,  .9138D-01,
     +   .3185D-02, -.1405D-01, -.4954D-02,
     +   .1605D-01, -.1368D-01, -.2954D-02, -.2954D-02,  .1149D+00,
     +   .2575D-02, -.1269D-01, -.4614D-02,
     +   .1698D-01, -.1408D-01, -.3263D-02, -.3263D-02,  .1381D+00,
     +   .2179D-02, -.1166D-01, -.4323D-02,
     +   .1780D-01, -.1443D-01, -.3516D-02, -.3516D-02,  .1596D+00,
     +   .1926D-02, -.1087D-01, -.4080D-02,
     +   .1876D-01, -.1483D-01, -.3795D-02, -.3795D-02,  .1866D+00,
     +   .1709D-02, -.1003D-01, -.3796D-02,
     +   .1963D-01, -.1519D-01, -.4020D-02, -.4020D-02,  .2120D+00,
     +   .1581D-02, -.9383D-02, -.3558D-02,
     +   .2046D-01, -.1553D-01, -.4213D-02, -.4213D-02,  .2375D+00,
     +   .1503D-02, -.8817D-02, -.3335D-02 /
        DATA ((PARTON(I,N,7),I=1,8),N=17,25)/
     +   .2122D-01, -.1584D-01, -.4369D-02, -.4369D-02,  .2617D+00,
     +   .1464D-02, -.8341D-02, -.3136D-02,
     +   .2219D-01, -.1623D-01, -.4534D-02, -.4534D-02,  .2934D+00,
     +   .1450D-02, -.7786D-02, -.2889D-02,
     +   .2310D-01, -.1659D-01, -.4654D-02, -.4654D-02,  .3240D+00,
     +   .1468D-02, -.7305D-02, -.2661D-02,
     +   .2400D-01, -.1695D-01, -.4740D-02, -.4740D-02,  .3551D+00,
     +   .1509D-02, -.6860D-02, -.2439D-02,
     +   .2480D-01, -.1726D-01, -.4786D-02, -.4786D-02,  .3832D+00,
     +   .1562D-02, -.6490D-02, -.2247D-02,
     +   .2563D-01, -.1758D-01, -.4804D-02, -.4804D-02,  .4129D+00,
     +   .1631D-02, -.6124D-02, -.2048D-02,
     +   .2642D-01, -.1789D-01, -.4793D-02, -.4793D-02,  .4413D+00,
     +   .1707D-02, -.5795D-02, -.1863D-02,
     +   .2721D-01, -.1819D-01, -.4753D-02, -.4753D-02,  .4699D+00,
     +   .1792D-02, -.5479D-02, -.1681D-02,
     +   .2790D-01, -.1845D-01, -.4694D-02, -.4694D-02,  .4956D+00,
     +   .1874D-02, -.5210D-02, -.1520D-02 /
        DATA ((PARTON(I,N,8),I=1,8),N=1,8)/
     +   .1155D-01, -.1205D-01, -.7889D-03, -.7889D-03,  .8099D-02,
     +   .1808D-01, -.3370D-01, -.7149D-02,
     +   .1250D-01, -.1249D-01, -.1028D-02, -.1028D-02,  .1400D-01,
     +   .1593D-01, -.3148D-01, -.7102D-02,
     +   .1324D-01, -.1282D-01, -.1229D-02, -.1229D-02,  .1975D-01,
     +   .1425D-01, -.2967D-01, -.7032D-02,
     +   .1410D-01, -.1321D-01, -.1478D-02, -.1478D-02,  .2777D-01,
     +   .1242D-01, -.2759D-01, -.6910D-02,
     +   .1516D-01, -.1368D-01, -.1796D-02, -.1796D-02,  .3942D-01,
     +   .1045D-01, -.2519D-01, -.6712D-02,
     +   .1593D-01, -.1401D-01, -.2036D-02, -.2036D-02,  .4929D-01,
     +   .9208D-02, -.2357D-01, -.6536D-02,
     +   .1655D-01, -.1428D-01, -.2227D-02, -.2227D-02,  .5779D-01,
     +   .8354D-02, -.2239D-01, -.6385D-02,
     +   .1747D-01, -.1467D-01, -.2515D-02, -.2515D-02,  .7184D-01,
     +   .7250D-02, -.2074D-01, -.6138D-02 /
        DATA ((PARTON(I,N,8),I=1,8),N=9,16)/
     +   .1815D-01, -.1496D-01, -.2725D-02, -.2725D-02,  .8308D-01,
     +   .6561D-02, -.1962D-01, -.5943D-02,
     +   .1953D-01, -.1553D-01, -.3138D-02, -.3138D-02,  .1079D+00,
     +   .5471D-02, -.1766D-01, -.5547D-02,
     +   .2083D-01, -.1606D-01, -.3504D-02, -.3504D-02,  .1337D+00,
     +   .4730D-02, -.1609D-01, -.5168D-02,
     +   .2199D-01, -.1653D-01, -.3807D-02, -.3807D-02,  .1587D+00,
     +   .4247D-02, -.1485D-01, -.4827D-02,
     +   .2300D-01, -.1693D-01, -.4046D-02, -.4046D-02,  .1815D+00,
     +   .3937D-02, -.1390D-01, -.4533D-02,
     +   .2420D-01, -.1740D-01, -.4299D-02, -.4299D-02,  .2098D+00,
     +   .3671D-02, -.1286D-01, -.4181D-02,
     +   .2526D-01, -.1782D-01, -.4493D-02, -.4493D-02,  .2361D+00,
     +   .3518D-02, -.1204D-01, -.3877D-02,
     +   .2628D-01, -.1821D-01, -.4649D-02, -.4649D-02,  .2622D+00,
     +   .3429D-02, -.1132D-01, -.3590D-02 /
        DATA ((PARTON(I,N,8),I=1,8),N=17,25)/
     +   .2721D-01, -.1857D-01, -.4765D-02, -.4765D-02,  .2866D+00,
     +   .3387D-02, -.1070D-01, -.3330D-02,
     +   .2839D-01, -.1902D-01, -.4874D-02, -.4874D-02,  .3183D+00,
     +   .3380D-02, -.9984D-02, -.3005D-02,
     +   .2950D-01, -.1943D-01, -.4936D-02, -.4936D-02,  .3485D+00,
     +   .3412D-02, -.9356D-02, -.2704D-02,
     +   .3059D-01, -.1984D-01, -.4959D-02, -.4959D-02,  .3790D+00,
     +   .3474D-02, -.8772D-02, -.2409D-02,
     +   .3156D-01, -.2020D-01, -.4946D-02, -.4946D-02,  .4061D+00,
     +   .3550D-02, -.8284D-02, -.2153D-02,
     +   .3256D-01, -.2057D-01, -.4900D-02, -.4900D-02,  .4346D+00,
     +   .3646D-02, -.7801D-02, -.1888D-02,
     +   .3351D-01, -.2091D-01, -.4826D-02, -.4826D-02,  .4615D+00,
     +   .3751D-02, -.7364D-02, -.1642D-02,
     +   .3445D-01, -.2125D-01, -.4722D-02, -.4722D-02,  .4885D+00,
     +   .3867D-02, -.6946D-02, -.1398D-02,
     +   .3528D-01, -.2155D-01, -.4606D-02, -.4606D-02,  .5125D+00,
     +   .3978D-02, -.6588D-02, -.1184D-02 /
        DATA ((PARTON(I,N,9),I=1,8),N=1,8)/
     +   .1508D-01, -.1403D-01, -.1121D-02, -.1121D-02,  .1089D-01,
     +   .2187D-01, -.3651D-01, -.6619D-02,
     +   .1627D-01, -.1455D-01, -.1419D-02, -.1419D-02,  .1830D-01,
     +   .1971D-01, -.3489D-01, -.6856D-02,
     +   .1720D-01, -.1495D-01, -.1663D-02, -.1663D-02,  .2536D-01,
     +   .1801D-01, -.3344D-01, -.6973D-02,
     +   .1828D-01, -.1540D-01, -.1957D-02, -.1957D-02,  .3499D-01,
     +   .1611D-01, -.3167D-01, -.7028D-02,
     +   .1959D-01, -.1595D-01, -.2323D-02, -.2323D-02,  .4870D-01,
     +   .1404D-01, -.2949D-01, -.6985D-02,
     +   .2056D-01, -.1634D-01, -.2593D-02, -.2593D-02,  .6010D-01,
     +   .1271D-01, -.2793D-01, -.6887D-02,
     +   .2131D-01, -.1665D-01, -.2803D-02, -.2803D-02,  .6979D-01,
     +   .1178D-01, -.2676D-01, -.6777D-02,
     +   .2246D-01, -.1711D-01, -.3114D-02, -.3114D-02,  .8560D-01,
     +   .1057D-01, -.2507D-01, -.6567D-02 /
        DATA ((PARTON(I,N,9),I=1,8),N=9,16)/
     +   .2330D-01, -.1744D-01, -.3336D-02, -.3336D-02,  .9808D-01,
     +   .9800D-02, -.2389D-01, -.6380D-02,
     +   .2499D-01, -.1810D-01, -.3760D-02, -.3760D-02,  .1253D+00,
     +   .8579D-02, -.2175D-01, -.5965D-02,
     +   .2658D-01, -.1872D-01, -.4120D-02, -.4120D-02,  .1529D+00,
     +   .7745D-02, -.1996D-01, -.5537D-02,
     +   .2800D-01, -.1926D-01, -.4406D-02, -.4406D-02,  .1792D+00,
     +   .7200D-02, -.1853D-01, -.5134D-02,
     +   .2922D-01, -.1972D-01, -.4622D-02, -.4622D-02,  .2029D+00,
     +   .6854D-02, -.1739D-01, -.4776D-02,
     +   .3066D-01, -.2026D-01, -.4838D-02, -.4838D-02,  .2320D+00,
     +   .6559D-02, -.1614D-01, -.4341D-02,
     +   .3195D-01, -.2073D-01, -.4991D-02, -.4991D-02,  .2586D+00,
     +   .6397D-02, -.1513D-01, -.3958D-02,
     +   .3317D-01, -.2118D-01, -.5103D-02, -.5103D-02,  .2847D+00,
     +   .6310D-02, -.1424D-01, -.3592D-02 /
        DATA ((PARTON(I,N,9),I=1,8),N=17,25)/
     +   .3429D-01, -.2159D-01, -.5173D-02, -.5173D-02,  .3089D+00,
     +   .6278D-02, -.1347D-01, -.3258D-02,
     +   .3570D-01, -.2209D-01, -.5219D-02, -.5219D-02,  .3399D+00,
     +   .6292D-02, -.1256D-01, -.2839D-02,
     +   .3701D-01, -.2256D-01, -.5217D-02, -.5217D-02,  .3691D+00,
     +   .6352D-02, -.1177D-01, -.2449D-02,
     +   .3831D-01, -.2302D-01, -.5173D-02, -.5173D-02,  .3982D+00,
     +   .6448D-02, -.1102D-01, -.2066D-02,
     +   .3945D-01, -.2342D-01, -.5100D-02, -.5100D-02,  .4239D+00,
     +   .6557D-02, -.1040D-01, -.1732D-02,
     +   .4064D-01, -.2384D-01, -.4990D-02, -.4990D-02,  .4505D+00,
     +   .6691D-02, -.9778D-02, -.1389D-02,
     +   .4175D-01, -.2422D-01, -.4855D-02, -.4855D-02,  .4755D+00,
     +   .6835D-02, -.9217D-02, -.1068D-02,
     +   .4286D-01, -.2460D-01, -.4690D-02, -.4690D-02,  .5003D+00,
     +   .6991D-02, -.8679D-02, -.7518D-03,
     +   .4384D-01, -.2494D-01, -.4519D-02, -.4519D-02,  .5221D+00,
     +   .7140D-02, -.8219D-02, -.4744D-03 /
        DATA ((PARTON(I,N,10),I=1,8),N=1,8)/
     +   .1954D-01, -.1633D-01, -.1585D-02, -.1585D-02,  .1444D-01,
     +   .2595D-01, -.3977D-01, -.6133D-02,
     +   .2103D-01, -.1694D-01, -.1949D-02, -.1949D-02,  .2364D-01,
     +   .2389D-01, -.3873D-01, -.6603D-02,
     +   .2218D-01, -.1741D-01, -.2239D-02, -.2239D-02,  .3217D-01,
     +   .2224D-01, -.3765D-01, -.6869D-02,
     +   .2351D-01, -.1794D-01, -.2581D-02, -.2581D-02,  .4359D-01,
     +   .2038D-01, -.3620D-01, -.7062D-02,
     +   .2514D-01, -.1857D-01, -.2994D-02, -.2994D-02,  .5947D-01,
     +   .1832D-01, -.3427D-01, -.7137D-02,
     +   .2632D-01, -.1903D-01, -.3291D-02, -.3291D-02,  .7244D-01,
     +   .1698D-01, -.3281D-01, -.7092D-02,
     +   .2725D-01, -.1939D-01, -.3517D-02, -.3517D-02,  .8332D-01,
     +   .1604D-01, -.3167D-01, -.7007D-02,
     +   .2865D-01, -.1992D-01, -.3845D-02, -.3845D-02,  .1008D+00,
     +   .1480D-01, -.2997D-01, -.6809D-02 /
        DATA ((PARTON(I,N,10),I=1,8),N=9,16)/
     +   .2967D-01, -.2030D-01, -.4073D-02, -.4073D-02,  .1145D+00,
     +   .1401D-01, -.2874D-01, -.6616D-02,
     +   .3173D-01, -.2107D-01, -.4494D-02, -.4494D-02,  .1437D+00,
     +   .1275D-01, -.2644D-01, -.6152D-02,
     +   .3364D-01, -.2177D-01, -.4834D-02, -.4834D-02,  .1728D+00,
     +   .1190D-01, -.2446D-01, -.5648D-02,
     +   .3535D-01, -.2239D-01, -.5091D-02, -.5091D-02,  .2000D+00,
     +   .1134D-01, -.2281D-01, -.5158D-02,
     +   .3681D-01, -.2291D-01, -.5272D-02, -.5272D-02,  .2241D+00,
     +   .1100D-01, -.2149D-01, -.4715D-02,
     +   .3853D-01, -.2353D-01, -.5438D-02, -.5438D-02,  .2533D+00,
     +   .1072D-01, -.2000D-01, -.4172D-02,
     +   .4006D-01, -.2406D-01, -.5540D-02, -.5540D-02,  .2797D+00,
     +   .1058D-01, -.1879D-01, -.3689D-02,
     +   .4151D-01, -.2457D-01, -.5598D-02, -.5598D-02,  .3052D+00,
     +   .1052D-01, -.1771D-01, -.3222D-02 /
        DATA ((PARTON(I,N,10),I=1,8),N=17,25)/
     +   .4283D-01, -.2502D-01, -.5615D-02, -.5615D-02,  .3286D+00,
     +   .1052D-01, -.1677D-01, -.2796D-02,
     +   .4449D-01, -.2559D-01, -.5590D-02, -.5590D-02,  .3581D+00,
     +   .1059D-01, -.1565D-01, -.2258D-02,
     +   .4603D-01, -.2612D-01, -.5520D-02, -.5520D-02,  .3857D+00,
     +   .1070D-01, -.1466D-01, -.1758D-02,
     +   .4755D-01, -.2663D-01, -.5407D-02, -.5407D-02,  .4128D+00,
     +   .1085D-01, -.1373D-01, -.1267D-02,
     +   .4889D-01, -.2707D-01, -.5272D-02, -.5272D-02,  .4364D+00,
     +   .1101D-01, -.1295D-01, -.8385D-03,
     +   .5026D-01, -.2753D-01, -.5099D-02, -.5099D-02,  .4606D+00,
     +   .1120D-01, -.1217D-01, -.3979D-03,
     +   .5155D-01, -.2795D-01, -.4904D-02, -.4904D-02,  .4831D+00,
     +   .1140D-01, -.1147D-01,  .1293D-04,
     +   .5283D-01, -.2837D-01, -.4681D-02, -.4681D-02,  .5051D+00,
     +   .1161D-01, -.1079D-01,  .4178D-03,
     +   .5396D-01, -.2874D-01, -.4461D-02, -.4461D-02,  .5244D+00,
     +   .1181D-01, -.1021D-01,  .7721D-03 /
        DATA ((PARTON(I,N,11),I=1,8),N=1,8)/
     +   .2582D-01, -.1932D-01, -.2305D-02, -.2305D-02,  .1949D-01,
     +   .3079D-01, -.4413D-01, -.5753D-02,
     +   .2770D-01, -.2004D-01, -.2750D-02, -.2750D-02,  .3098D-01,
     +   .2894D-01, -.4367D-01, -.6402D-02,
     +   .2914D-01, -.2059D-01, -.3094D-02, -.3094D-02,  .4135D-01,
     +   .2745D-01, -.4297D-01, -.6770D-02,
     +   .3082D-01, -.2122D-01, -.3487D-02, -.3487D-02,  .5489D-01,
     +   .2578D-01, -.4186D-01, -.7047D-02,
     +   .3283D-01, -.2197D-01, -.3946D-02, -.3946D-02,  .7327D-01,
     +   .2391D-01, -.4022D-01, -.7173D-02,
     +   .3430D-01, -.2251D-01, -.4265D-02, -.4265D-02,  .8795D-01,
     +   .2269D-01, -.3888D-01, -.7137D-02,
     +   .3545D-01, -.2292D-01, -.4502D-02, -.4502D-02,  .1001D+00,
     +   .2182D-01, -.3778D-01, -.7042D-02,
     +   .3717D-01, -.2354D-01, -.4836D-02, -.4836D-02,  .1193D+00,
     +   .2069D-01, -.3610D-01, -.6807D-02 /
        DATA ((PARTON(I,N,11),I=1,8),N=9,16)/
     +   .3842D-01, -.2399D-01, -.5061D-02, -.5061D-02,  .1340D+00,
     +   .1997D-01, -.3483D-01, -.6571D-02,
     +   .4093D-01, -.2487D-01, -.5458D-02, -.5458D-02,  .1649D+00,
     +   .1883D-01, -.3237D-01, -.5990D-02,
     +   .4325D-01, -.2568D-01, -.5756D-02, -.5756D-02,  .1949D+00,
     +   .1808D-01, -.3017D-01, -.5346D-02,
     +   .4531D-01, -.2639D-01, -.5962D-02, -.5962D-02,  .2225D+00,
     +   .1762D-01, -.2830D-01, -.4714D-02,
     +   .4707D-01, -.2699D-01, -.6091D-02, -.6091D-02,  .2465D+00,
     +   .1736D-01, -.2676D-01, -.4141D-02,
     +   .4914D-01, -.2768D-01, -.6187D-02, -.6187D-02,  .2751D+00,
     +   .1716D-01, -.2501D-01, -.3438D-02,
     +   .5095D-01, -.2829D-01, -.6220D-02, -.6220D-02,  .3004D+00,
     +   .1712D-01, -.2356D-01, -.2807D-02,
     +   .5267D-01, -.2886D-01, -.6209D-02, -.6209D-02,  .3245D+00,
     +   .1715D-01, -.2224D-01, -.2198D-02 /
        DATA ((PARTON(I,N,11),I=1,8),N=17,25)/
     +   .5424D-01, -.2937D-01, -.6161D-02, -.6161D-02,  .3463D+00,
     +   .1724D-01, -.2110D-01, -.1640D-02,
     +   .5619D-01, -.3000D-01, -.6052D-02, -.6052D-02,  .3735D+00,
     +   .1741D-01, -.1972D-01, -.9377D-03,
     +   .5800D-01, -.3058D-01, -.5903D-02, -.5903D-02,  .3984D+00,
     +   .1763D-01, -.1850D-01, -.2847D-03,
     +   .5977D-01, -.3115D-01, -.5712D-02, -.5712D-02,  .4225D+00,
     +   .1788D-01, -.1734D-01,  .3557D-03,
     +   .6132D-01, -.3164D-01, -.5511D-02, -.5511D-02,  .4432D+00,
     +   .1814D-01, -.1637D-01,  .9131D-03,
     +   .6291D-01, -.3214D-01, -.5270D-02, -.5270D-02,  .4641D+00,
     +   .1843D-01, -.1540D-01,  .1485D-02,
     +   .6440D-01, -.3260D-01, -.5015D-02, -.5015D-02,  .4833D+00,
     +   .1872D-01, -.1451D-01,  .2018D-02,
     +   .6588D-01, -.3305D-01, -.4735D-02, -.4735D-02,  .5019D+00,
     +   .1902D-01, -.1367D-01,  .2541D-02,
     +   .6717D-01, -.3345D-01, -.4467D-02, -.4467D-02,  .5178D+00,
     +   .1930D-01, -.1294D-01,  .2998D-02 /
        DATA ((PARTON(I,N,12),I=1,8),N=1,8)/
     +   .3341D-01, -.2268D-01, -.3262D-02, -.3262D-02,  .2566D-01,
     +   .3568D-01, -.4926D-01, -.5665D-02,
     +   .3572D-01, -.2353D-01, -.3785D-02, -.3785D-02,  .3965D-01,
     +   .3416D-01, -.4927D-01, -.6382D-02,
     +   .3749D-01, -.2417D-01, -.4176D-02, -.4176D-02,  .5193D-01,
     +   .3295D-01, -.4887D-01, -.6766D-02,
     +   .3953D-01, -.2490D-01, -.4610D-02, -.4610D-02,  .6759D-01,
     +   .3159D-01, -.4804D-01, -.7027D-02,
     +   .4198D-01, -.2577D-01, -.5099D-02, -.5099D-02,  .8831D-01,
     +   .3010D-01, -.4662D-01, -.7093D-02,
     +   .4376D-01, -.2639D-01, -.5426D-02, -.5426D-02,  .1045D+00,
     +   .2913D-01, -.4538D-01, -.6990D-02,
     +   .4514D-01, -.2687D-01, -.5663D-02, -.5663D-02,  .1177D+00,
     +   .2846D-01, -.4432D-01, -.6831D-02,
     +   .4721D-01, -.2757D-01, -.5985D-02, -.5985D-02,  .1382D+00,
     +   .2759D-01, -.4264D-01, -.6483D-02 /
        DATA ((PARTON(I,N,12),I=1,8),N=9,16)/
     +   .4871D-01, -.2808D-01, -.6194D-02, -.6194D-02,  .1536D+00,
     +   .2704D-01, -.4134D-01, -.6156D-02,
     +   .5170D-01, -.2909D-01, -.6541D-02, -.6541D-02,  .1854D+00,
     +   .2623D-01, -.3874D-01, -.5367D-02,
     +   .5445D-01, -.3000D-01, -.6776D-02, -.6776D-02,  .2156D+00,
     +   .2576D-01, -.3634D-01, -.4511D-02,
     +   .5687D-01, -.3079D-01, -.6913D-02, -.6913D-02,  .2427D+00,
     +   .2553D-01, -.3425D-01, -.3681D-02,
     +   .5893D-01, -.3146D-01, -.6977D-02, -.6977D-02,  .2659D+00,
     +   .2546D-01, -.3250D-01, -.2933D-02,
     +   .6134D-01, -.3223D-01, -.6991D-02, -.6991D-02,  .2930D+00,
     +   .2547D-01, -.3049D-01, -.2023D-02,
     +   .6344D-01, -.3290D-01, -.6949D-02, -.6949D-02,  .3165D+00,
     +   .2561D-01, -.2881D-01, -.1206D-02,
     +   .6544D-01, -.3352D-01, -.6863D-02, -.6863D-02,  .3386D+00,
     +   .2581D-01, -.2727D-01, -.4200D-03 /
        DATA ((PARTON(I,N,12),I=1,8),N=17,25)/
     +   .6723D-01, -.3408D-01, -.6748D-02, -.6748D-02,  .3583D+00,
     +   .2604D-01, -.2592D-01,  .2970D-03,
     +   .6947D-01, -.3477D-01, -.6556D-02, -.6556D-02,  .3823D+00,
     +   .2640D-01, -.2429D-01,  .1198D-02,
     +   .7154D-01, -.3539D-01, -.6331D-02, -.6331D-02,  .4040D+00,
     +   .2679D-01, -.2283D-01,  .2032D-02,
     +   .7355D-01, -.3600D-01, -.6069D-02, -.6069D-02,  .4246D+00,
     +   .2721D-01, -.2145D-01,  .2847D-02,
     +   .7530D-01, -.3652D-01, -.5809D-02, -.5809D-02,  .4420D+00,
     +   .2760D-01, -.2028D-01,  .3555D-02,
     +   .7710D-01, -.3705D-01, -.5511D-02, -.5511D-02,  .4594D+00,
     +   .2803D-01, -.1912D-01,  .4279D-02,
     +   .7877D-01, -.3754D-01, -.5206D-02, -.5206D-02,  .4750D+00,
     +   .2845D-01, -.1806D-01,  .4951D-02,
     +   .8041D-01, -.3802D-01, -.4880D-02, -.4880D-02,  .4899D+00,
     +   .2888D-01, -.1704D-01,  .5610D-02,
     +   .8185D-01, -.3843D-01, -.4576D-02, -.4576D-02,  .5025D+00,
     +   .2927D-01, -.1617D-01,  .6183D-02 /
        DATA ((PARTON(I,N,13),I=1,8),N=1,8)/
     +   .4254D-01, -.2651D-01, -.4510D-02, -.4510D-02,  .3321D-01,
     +   .4069D-01, -.5537D-01, -.5936D-02,
     +   .4533D-01, -.2749D-01, -.5100D-02, -.5100D-02,  .4989D-01,
     +   .3963D-01, -.5572D-01, -.6594D-02,
     +   .4746D-01, -.2823D-01, -.5526D-02, -.5526D-02,  .6412D-01,
     +   .3881D-01, -.5552D-01, -.6894D-02,
     +   .4991D-01, -.2907D-01, -.5983D-02, -.5983D-02,  .8183D-01,
     +   .3793D-01, -.5487D-01, -.7024D-02,
     +   .5282D-01, -.3006D-01, -.6477D-02, -.6477D-02,  .1047D+00,
     +   .3699D-01, -.5359D-01, -.6899D-02,
     +   .5493D-01, -.3076D-01, -.6794D-02, -.6794D-02,  .1221D+00,
     +   .3642D-01, -.5240D-01, -.6639D-02,
     +   .5656D-01, -.3130D-01, -.7016D-02, -.7016D-02,  .1360D+00,
     +   .3604D-01, -.5135D-01, -.6351D-02,
     +   .5899D-01, -.3210D-01, -.7304D-02, -.7304D-02,  .1574D+00,
     +   .3560D-01, -.4964D-01, -.5799D-02 /
        DATA ((PARTON(I,N,13),I=1,8),N=9,16)/
     +   .6075D-01, -.3267D-01, -.7481D-02, -.7481D-02,  .1732D+00,
     +   .3535D-01, -.4829D-01, -.5318D-02,
     +   .6424D-01, -.3379D-01, -.7748D-02, -.7748D-02,  .2050D+00,
     +   .3509D-01, -.4553D-01, -.4211D-02,
     +   .6742D-01, -.3479D-01, -.7894D-02, -.7894D-02,  .2345D+00,
     +   .3509D-01, -.4293D-01, -.3053D-02,
     +   .7021D-01, -.3566D-01, -.7945D-02, -.7945D-02,  .2603D+00,
     +   .3525D-01, -.4063D-01, -.1955D-02,
     +   .7258D-01, -.3639D-01, -.7932D-02, -.7932D-02,  .2819D+00,
     +   .3548D-01, -.3869D-01, -.9780D-03,
     +   .7532D-01, -.3722D-01, -.7853D-02, -.7853D-02,  .3067D+00,
     +   .3584D-01, -.3644D-01,  .1961D-03,
     +   .7771D-01, -.3794D-01, -.7730D-02, -.7730D-02,  .3278D+00,
     +   .3626D-01, -.3453D-01,  .1243D-02,
     +   .7996D-01, -.3860D-01, -.7567D-02, -.7567D-02,  .3473D+00,
     +   .3673D-01, -.3278D-01,  .2245D-02 /
        DATA ((PARTON(I,N,13),I=1,8),N=17,25)/
     +   .8197D-01, -.3919D-01, -.7385D-02, -.7385D-02,  .3643D+00,
     +   .3719D-01, -.3123D-01,  .3155D-02,
     +   .8448D-01, -.3992D-01, -.7111D-02, -.7111D-02,  .3847D+00,
     +   .3783D-01, -.2935D-01,  .4291D-02,
     +   .8677D-01, -.4058D-01, -.6816D-02, -.6816D-02,  .4027D+00,
     +   .3846D-01, -.2767D-01,  .5338D-02,
     +   .8900D-01, -.4121D-01, -.6490D-02, -.6490D-02,  .4194D+00,
     +   .3911D-01, -.2608D-01,  .6357D-02,
     +   .9093D-01, -.4175D-01, -.6179D-02, -.6179D-02,  .4333D+00,
     +   .3970D-01, -.2473D-01,  .7238D-02,
     +   .9290D-01, -.4229D-01, -.5834D-02, -.5834D-02,  .4469D+00,
     +   .4033D-01, -.2338D-01,  .8136D-02,
     +   .9473D-01, -.4279D-01, -.5490D-02, -.5490D-02,  .4589D+00,
     +   .4093D-01, -.2215D-01,  .8966D-02,
     +   .9652D-01, -.4327D-01, -.5131D-02, -.5131D-02,  .4701D+00,
     +   .4153D-01, -.2097D-01,  .9777D-02,
     +   .9808D-01, -.4369D-01, -.4802D-02, -.4802D-02,  .4793D+00,
     +   .4207D-01, -.1996D-01,  .1048D-01 /
        DATA ((PARTON(I,N,14),I=1,8),N=1,8)/
     +   .5584D-01, -.3187D-01, -.6458D-02, -.6458D-02,  .4457D-01,
     +   .4704D-01, -.6423D-01, -.6762D-02,
     +   .5927D-01, -.3302D-01, -.7094D-02, -.7094D-02,  .6464D-01,
     +   .4675D-01, -.6476D-01, -.7140D-02,
     +   .6187D-01, -.3388D-01, -.7531D-02, -.7531D-02,  .8115D-01,
     +   .4657D-01, -.6464D-01, -.7179D-02,
     +   .6484D-01, -.3484D-01, -.7978D-02, -.7978D-02,  .1011D+00,
     +   .4645D-01, -.6404D-01, -.6976D-02,
     +   .6836D-01, -.3597D-01, -.8432D-02, -.8432D-02,  .1259D+00,
     +   .4643D-01, -.6275D-01, -.6421D-02,
     +   .7088D-01, -.3677D-01, -.8703D-02, -.8703D-02,  .1443D+00,
     +   .4652D-01, -.6152D-01, -.5838D-02,
     +   .7283D-01, -.3738D-01, -.8880D-02, -.8880D-02,  .1588D+00,
     +   .4665D-01, -.6042D-01, -.5295D-02,
     +   .7571D-01, -.3827D-01, -.9091D-02, -.9091D-02,  .1803D+00,
     +   .4692D-01, -.5860D-01, -.4361D-02 /
        DATA ((PARTON(I,N,14),I=1,8),N=9,16)/
     +   .7778D-01, -.3891D-01, -.9204D-02, -.9204D-02,  .1960D+00,
     +   .4718D-01, -.5716D-01, -.3604D-02,
     +   .8186D-01, -.4014D-01, -.9332D-02, -.9332D-02,  .2266D+00,
     +   .4787D-01, -.5416D-01, -.1951D-02,
     +   .8556D-01, -.4123D-01, -.9340D-02, -.9340D-02,  .2539D+00,
     +   .4869D-01, -.5130D-01, -.3011D-03,
     +   .8877D-01, -.4217D-01, -.9265D-02, -.9265D-02,  .2771D+00,
     +   .4951D-01, -.4875D-01,  .1221D-02,
     +   .9148D-01, -.4294D-01, -.9144D-02, -.9144D-02,  .2960D+00,
     +   .5029D-01, -.4658D-01,  .2548D-02,
     +   .9459D-01, -.4382D-01, -.8942D-02, -.8942D-02,  .3171D+00,
     +   .5124D-01, -.4405D-01,  .4119D-02,
     +   .9729D-01, -.4456D-01, -.8715D-02, -.8715D-02,  .3345D+00,
     +   .5216D-01, -.4190D-01,  .5505D-02,
     +   .9980D-01, -.4525D-01, -.8460D-02, -.8460D-02,  .3501D+00,
     +   .5307D-01, -.3991D-01,  .6819D-02 /
        DATA ((PARTON(I,N,14),I=1,8),N=17,25)/
     +   .1021D+00, -.4586D-01, -.8198D-02, -.8198D-02,  .3634D+00,
     +   .5392D-01, -.3815D-01,  .8003D-02,
     +   .1048D+00, -.4659D-01, -.7834D-02, -.7834D-02,  .3789D+00,
     +   .5501D-01, -.3601D-01,  .9470D-02,
     +   .1073D+00, -.4725D-01, -.7464D-02, -.7464D-02,  .3921D+00,
     +   .5605D-01, -.3409D-01,  .1081D-01,
     +   .1098D+00, -.4788D-01, -.7074D-02, -.7074D-02,  .4040D+00,
     +   .5709D-01, -.3227D-01,  .1211D-01,
     +   .1119D+00, -.4840D-01, -.6714D-02, -.6714D-02,  .4135D+00,
     +   .5800D-01, -.3073D-01,  .1323D-01,
     +   .1140D+00, -.4893D-01, -.6327D-02, -.6327D-02,  .4225D+00,
     +   .5894D-01, -.2918D-01,  .1436D-01,
     +   .1159D+00, -.4941D-01, -.5951D-02, -.5951D-02,  .4302D+00,
     +   .5983D-01, -.2778D-01,  .1541D-01,
     +   .1178D+00, -.4987D-01, -.5568D-02, -.5568D-02,  .4371D+00,
     +   .6070D-01, -.2643D-01,  .1642D-01,
     +   .1195D+00, -.5026D-01, -.5224D-02, -.5224D-02,  .4425D+00,
     +   .6147D-01, -.2528D-01,  .1730D-01 /
        DATA ((PARTON(I,N,15),I=1,8),N=1,8)/
     +   .7205D-01, -.3821D-01, -.8925D-02, -.8925D-02,  .5920D-01,
     +   .5420D-01, -.7486D-01, -.7985D-02,
     +   .7617D-01, -.3952D-01, -.9540D-02, -.9540D-02,  .8261D-01,
     +   .5497D-01, -.7525D-01, -.7796D-02,
     +   .7927D-01, -.4049D-01, -.9936D-02, -.9936D-02,  .1011D+00,
     +   .5564D-01, -.7499D-01, -.7366D-02,
     +   .8279D-01, -.4157D-01, -.1031D-01, -.1031D-01,  .1228D+00,
     +   .5651D-01, -.7420D-01, -.6606D-02,
     +   .8693D-01, -.4282D-01, -.1066D-01, -.1066D-01,  .1488D+00,
     +   .5769D-01, -.7268D-01, -.5378D-02,
     +   .8987D-01, -.4369D-01, -.1084D-01, -.1084D-01,  .1674D+00,
     +   .5862D-01, -.7126D-01, -.4312D-02,
     +   .9213D-01, -.4435D-01, -.1094D-01, -.1094D-01,  .1817D+00,
     +   .5938D-01, -.7002D-01, -.3400D-02,
     +   .9545D-01, -.4531D-01, -.1103D-01, -.1103D-01,  .2025D+00,
     +   .6059D-01, -.6798D-01, -.1929D-02 /
        DATA ((PARTON(I,N,15),I=1,8),N=9,16)/
     +   .9783D-01, -.4599D-01, -.1105D-01, -.1105D-01,  .2171D+00,
     +   .6149D-01, -.6638D-01, -.7933D-03,
     +   .1025D+00, -.4728D-01, -.1098D-01, -.1098D-01,  .2450D+00,
     +   .6341D-01, -.6306D-01,  .1584D-02,
     +   .1066D+00, -.4841D-01, -.1082D-01, -.1082D-01,  .2688D+00,
     +   .6527D-01, -.5990D-01,  .3864D-02,
     +   .1102D+00, -.4936D-01, -.1060D-01, -.1060D-01,  .2882D+00,
     +   .6696D-01, -.5708D-01,  .5913D-02,
     +   .1132D+00, -.5014D-01, -.1036D-01, -.1036D-01,  .3035D+00,
     +   .6843D-01, -.5469D-01,  .7668D-02,
     +   .1166D+00, -.5101D-01, -.1003D-01, -.1003D-01,  .3199D+00,
     +   .7014D-01, -.5191D-01,  .9713D-02,
     +   .1195D+00, -.5174D-01, -.9698D-02, -.9698D-02,  .3330D+00,
     +   .7169D-01, -.4955D-01,  .1150D-01,
     +   .1223D+00, -.5240D-01, -.9354D-02, -.9354D-02,  .3442D+00,
     +   .7317D-01, -.4735D-01,  .1317D-01 /
        DATA ((PARTON(I,N,15),I=1,8),N=17,25)/
     +   .1247D+00, -.5298D-01, -.9020D-02, -.9020D-02,  .3535D+00,
     +   .7451D-01, -.4542D-01,  .1467D-01,
     +   .1276D+00, -.5367D-01, -.8578D-02, -.8578D-02,  .3637D+00,
     +   .7619D-01, -.4307D-01,  .1651D-01,
     +   .1302D+00, -.5427D-01, -.8147D-02, -.8147D-02,  .3721D+00,
     +   .7774D-01, -.4096D-01,  .1818D-01,
     +   .1328D+00, -.5484D-01, -.7708D-02, -.7708D-02,  .3791D+00,
     +   .7925D-01, -.3896D-01,  .1979D-01,
     +   .1349D+00, -.5531D-01, -.7316D-02, -.7316D-02,  .3844D+00,
     +   .8056D-01, -.3727D-01,  .2117D-01,
     +   .1371D+00, -.5577D-01, -.6903D-02, -.6903D-02,  .3891D+00,
     +   .8189D-01, -.3558D-01,  .2256D-01,
     +   .1391D+00, -.5618D-01, -.6511D-02, -.6511D-02,  .3927D+00,
     +   .8313D-01, -.3404D-01,  .2383D-01,
     +   .1410D+00, -.5657D-01, -.6120D-02, -.6120D-02,  .3957D+00,
     +   .8435D-01, -.3257D-01,  .2507D-01,
     +   .1426D+00, -.5690D-01, -.5774D-02, -.5774D-02,  .3978D+00,
     +   .8541D-01, -.3131D-01,  .2614D-01 /
        DATA ((PARTON(I,N,16),I=1,8),N=1,8)/
     +   .9237D-01, -.4600D-01, -.1196D-01, -.1196D-01,  .7913D-01,
     +   .6344D-01, -.8754D-01, -.9144D-02,
     +   .9724D-01, -.4744D-01, -.1245D-01, -.1245D-01,  .1055D+00,
     +   .6566D-01, -.8738D-01, -.7995D-02,
     +   .1009D+00, -.4849D-01, -.1273D-01, -.1273D-01,  .1254D+00,
     +   .6746D-01, -.8671D-01, -.6827D-02,
     +   .1050D+00, -.4965D-01, -.1296D-01, -.1296D-01,  .1479D+00,
     +   .6961D-01, -.8545D-01, -.5232D-02,
     +   .1097D+00, -.5096D-01, -.1310D-01, -.1310D-01,  .1737D+00,
     +   .7228D-01, -.8341D-01, -.3041D-02,
     +   .1131D+00, -.5186D-01, -.1313D-01, -.1313D-01,  .1915D+00,
     +   .7425D-01, -.8164D-01, -.1309D-02,
     +   .1156D+00, -.5254D-01, -.1312D-01, -.1312D-01,  .2047D+00,
     +   .7580D-01, -.8014D-01,  .9907D-04,
     +   .1194D+00, -.5351D-01, -.1303D-01, -.1303D-01,  .2234D+00,
     +   .7812D-01, -.7774D-01,  .2277D-02 /
        DATA ((PARTON(I,N,16),I=1,8),N=9,16)/
     +   .1220D+00, -.5419D-01, -.1292D-01, -.1292D-01,  .2362D+00,
     +   .7981D-01, -.7590D-01,  .3901D-02,
     +   .1271D+00, -.5545D-01, -.1263D-01, -.1263D-01,  .2593D+00,
     +   .8319D-01, -.7214D-01,  .7187D-02,
     +   .1317D+00, -.5653D-01, -.1226D-01, -.1226D-01,  .2781D+00,
     +   .8629D-01, -.6862D-01,  .1024D-01,
     +   .1355D+00, -.5742D-01, -.1187D-01, -.1187D-01,  .2925D+00,
     +   .8900D-01, -.6552D-01,  .1291D-01,
     +   .1387D+00, -.5813D-01, -.1151D-01, -.1151D-01,  .3033D+00,
     +   .9128D-01, -.6291D-01,  .1517D-01,
     +   .1423D+00, -.5891D-01, -.1105D-01, -.1105D-01,  .3142D+00,
     +   .9390D-01, -.5990D-01,  .1776D-01,
     +   .1453D+00, -.5955D-01, -.1062D-01, -.1062D-01,  .3224D+00,
     +   .9618D-01, -.5735D-01,  .1999D-01,
     +   .1481D+00, -.6011D-01, -.1020D-01, -.1020D-01,  .3289D+00,
     +   .9832D-01, -.5499D-01,  .2207D-01 /
        DATA ((PARTON(I,N,16),I=1,8),N=17,25)/
     +   .1505D+00, -.6059D-01, -.9800D-02, -.9800D-02,  .3338D+00,
     +   .1002D+00, -.5291D-01,  .2391D-01,
     +   .1534D+00, -.6114D-01, -.9294D-02, -.9294D-02,  .3387D+00,
     +   .1026D+00, -.5040D-01,  .2616D-01,
     +   .1561D+00, -.6162D-01, -.8819D-02, -.8819D-02,  .3422D+00,
     +   .1047D+00, -.4815D-01,  .2819D-01,
     +   .1585D+00, -.6204D-01, -.8350D-02, -.8350D-02,  .3446D+00,
     +   .1068D+00, -.4602D-01,  .3014D-01,
     +   .1606D+00, -.6239D-01, -.7940D-02, -.7940D-02,  .3459D+00,
     +   .1086D+00, -.4423D-01,  .3179D-01,
     +   .1627D+00, -.6271D-01, -.7518D-02, -.7518D-02,  .3466D+00,
     +   .1103D+00, -.4244D-01,  .3346D-01,
     +   .1645D+00, -.6299D-01, -.7125D-02, -.7125D-02,  .3467D+00,
     +   .1120D+00, -.4082D-01,  .3498D-01,
     +   .1663D+00, -.6325D-01, -.6740D-02, -.6740D-02,  .3463D+00,
     +   .1136D+00, -.3926D-01,  .3645D-01,
     +   .1678D+00, -.6345D-01, -.6404D-02, -.6404D-02,  .3456D+00,
     +   .1150D+00, -.3794D-01,  .3772D-01 /
        DATA ((PARTON(I,N,17),I=1,8),N=1,8)/
     +   .1245D+00, -.5791D-01, -.1619D-01, -.1619D-01,  .1142D+00,
     +   .8068D-01, -.1050D+00, -.8590D-02,
     +   .1303D+00, -.5938D-01, -.1633D-01, -.1633D-01,  .1421D+00,
     +   .8530D-01, -.1035D+00, -.5630D-02,
     +   .1346D+00, -.6043D-01, -.1633D-01, -.1633D-01,  .1620D+00,
     +   .8885D-01, -.1019D+00, -.3153D-02,
     +   .1393D+00, -.6155D-01, -.1623D-01, -.1623D-01,  .1831D+00,
     +   .9292D-01, -.9963D-01, -.1451D-03,
     +   .1447D+00, -.6278D-01, -.1601D-01, -.1601D-01,  .2057D+00,
     +   .9774D-01, -.9655D-01,  .3604D-02,
     +   .1484D+00, -.6360D-01, -.1578D-01, -.1578D-01,  .2204D+00,
     +   .1012D+00, -.9412D-01,  .6374D-02,
     +   .1513D+00, -.6420D-01, -.1557D-01, -.1557D-01,  .2307D+00,
     +   .1038D+00, -.9216D-01,  .8537D-02,
     +   .1553D+00, -.6504D-01, -.1522D-01, -.1522D-01,  .2445D+00,
     +   .1076D+00, -.8916D-01,  .1176D-01 /
        DATA ((PARTON(I,N,17),I=1,8),N=9,16)/
     +   .1582D+00, -.6560D-01, -.1493D-01, -.1493D-01,  .2533D+00,
     +   .1104D+00, -.8693D-01,  .1409D-01,
     +   .1636D+00, -.6662D-01, -.1430D-01, -.1430D-01,  .2681D+00,
     +   .1156D+00, -.8251D-01,  .1866D-01,
     +   .1682D+00, -.6743D-01, -.1368D-01, -.1368D-01,  .2785D+00,
     +   .1203D+00, -.7849D-01,  .2275D-01,
     +   .1721D+00, -.6806D-01, -.1310D-01, -.1310D-01,  .2854D+00,
     +   .1243D+00, -.7503D-01,  .2626D-01,
     +   .1752D+00, -.6853D-01, -.1259D-01, -.1259D-01,  .2898D+00,
     +   .1276D+00, -.7217D-01,  .2917D-01,
     +   .1786D+00, -.6901D-01, -.1200D-01, -.1200D-01,  .2933D+00,
     +   .1314D+00, -.6891D-01,  .3246D-01,
     +   .1815D+00, -.6937D-01, -.1147D-01, -.1147D-01,  .2951D+00,
     +   .1346D+00, -.6616D-01,  .3526D-01,
     +   .1840D+00, -.6966D-01, -.1097D-01, -.1097D-01,  .2958D+00,
     +   .1375D+00, -.6365D-01,  .3785D-01 /
        DATA ((PARTON(I,N,17),I=1,8),N=17,25)/
     +   .1862D+00, -.6989D-01, -.1052D-01, -.1052D-01,  .2956D+00,
     +   .1401D+00, -.6145D-01,  .4012D-01,
     +   .1888D+00, -.7011D-01, -.9973D-02, -.9973D-02,  .2945D+00,
     +   .1433D+00, -.5881D-01,  .4287D-01,
     +   .1910D+00, -.7027D-01, -.9473D-02, -.9473D-02,  .2926D+00,
     +   .1462D+00, -.5646D-01,  .4534D-01,
     +   .1930D+00, -.7038D-01, -.8992D-02, -.8992D-02,  .2901D+00,
     +   .1489D+00, -.5425D-01,  .4770D-01,
     +   .1947D+00, -.7044D-01, -.8583D-02, -.8583D-02,  .2875D+00,
     +   .1513D+00, -.5239D-01,  .4969D-01,
     +   .1963D+00, -.7047D-01, -.8170D-02, -.8170D-02,  .2844D+00,
     +   .1536D+00, -.5054D-01,  .5169D-01,
     +   .1977D+00, -.7047D-01, -.7795D-02, -.7795D-02,  .2811D+00,
     +   .1558D+00, -.4888D-01,  .5352D-01,
     +   .1990D+00, -.7044D-01, -.7432D-02, -.7432D-02,  .2776D+00,
     +   .1579D+00, -.4728D-01,  .5528D-01,
     +   .2000D+00, -.7040D-01, -.7122D-02, -.7122D-02,  .2744D+00,
     +   .1597D+00, -.4592D-01,  .5680D-01 /
        DATA ((PARTON(I,N,18),I=1,8),N=1,8)/
     +   .1644D+00, -.7159D-01, -.1993D-01, -.1993D-01,  .1611D+00,
     +   .1083D+00, -.1207D+00, -.2088D-02,
     +   .1709D+00, -.7281D-01, -.1954D-01, -.1954D-01,  .1859D+00,
     +   .1156D+00, -.1173D+00,  .3121D-02,
     +   .1755D+00, -.7363D-01, -.1916D-01, -.1916D-01,  .2021D+00,
     +   .1210D+00, -.1145D+00,  .7133D-02,
     +   .1805D+00, -.7446D-01, -.1867D-01, -.1867D-01,  .2179D+00,
     +   .1269D+00, -.1110D+00,  .1172D-01,
     +   .1862D+00, -.7531D-01, -.1802D-01, -.1802D-01,  .2331D+00,
     +   .1338D+00, -.1067D+00,  .1714D-01,
     +   .1900D+00, -.7584D-01, -.1751D-01, -.1751D-01,  .2419D+00,
     +   .1385D+00, -.1035D+00,  .2097D-01,
     +   .1928D+00, -.7620D-01, -.1711D-01, -.1711D-01,  .2475D+00,
     +   .1421D+00, -.1011D+00,  .2388D-01,
     +   .1967D+00, -.7666D-01, -.1649D-01, -.1649D-01,  .2540D+00,
     +   .1472D+00, -.9743D-01,  .2812D-01 /
        DATA ((PARTON(I,N,18),I=1,8),N=9,16)/
     +   .1994D+00, -.7694D-01, -.1604D-01, -.1604D-01,  .2575D+00,
     +   .1508D+00, -.9481D-01,  .3112D-01,
     +   .2044D+00, -.7736D-01, -.1513D-01, -.1513D-01,  .2618D+00,
     +   .1576D+00, -.8975D-01,  .3686D-01,
     +   .2085D+00, -.7761D-01, -.1431D-01, -.1431D-01,  .2630D+00,
     +   .1636D+00, -.8528D-01,  .4188D-01,
     +   .2118D+00, -.7772D-01, -.1359D-01, -.1359D-01,  .2622D+00,
     +   .1685D+00, -.8152D-01,  .4611D-01,
     +   .2143D+00, -.7774D-01, -.1299D-01, -.1299D-01,  .2604D+00,
     +   .1726D+00, -.7844D-01,  .4957D-01,
     +   .2170D+00, -.7769D-01, -.1232D-01, -.1232D-01,  .2572D+00,
     +   .1772D+00, -.7501D-01,  .5346D-01,
     +   .2191D+00, -.7758D-01, -.1174D-01, -.1174D-01,  .2536D+00,
     +   .1810D+00, -.7213D-01,  .5673D-01,
     +   .2209D+00, -.7741D-01, -.1121D-01, -.1121D-01,  .2496D+00,
     +   .1846D+00, -.6951D-01,  .5973D-01 /
        DATA ((PARTON(I,N,18),I=1,8),N=17,25)/
     +   .2223D+00, -.7722D-01, -.1075D-01, -.1075D-01,  .2455D+00,
     +   .1877D+00, -.6724D-01,  .6236D-01,
     +   .2239D+00, -.7693D-01, -.1019D-01, -.1019D-01,  .2401D+00,
     +   .1914D+00, -.6452D-01,  .6553D-01,
     +   .2252D+00, -.7660D-01, -.9696D-02, -.9696D-02,  .2347D+00,
     +   .1948D+00, -.6212D-01,  .6837D-01,
     +   .2262D+00, -.7624D-01, -.9230D-02, -.9230D-02,  .2291D+00,
     +   .1981D+00, -.5986D-01,  .7106D-01,
     +   .2270D+00, -.7589D-01, -.8839D-02, -.8839D-02,  .2241D+00,
     +   .2008D+00, -.5797D-01,  .7334D-01,
     +   .2277D+00, -.7550D-01, -.8450D-02, -.8450D-02,  .2189D+00,
     +   .2036D+00, -.5609D-01,  .7564D-01,
     +   .2282D+00, -.7510D-01, -.8101D-02, -.8101D-02,  .2139D+00,
     +   .2061D+00, -.5440D-01,  .7773D-01,
     +   .2286D+00, -.7469D-01, -.7768D-02, -.7768D-02,  .2090D+00,
     +   .2086D+00, -.5278D-01,  .7976D-01,
     +   .2288D+00, -.7430D-01, -.7484D-02, -.7484D-02,  .2046D+00,
     +   .2107D+00, -.5140D-01,  .8150D-01 /
        DATA ((PARTON(I,N,19),I=1,8),N=1,8)/
     +   .2016D+00, -.8269D-01, -.2183D-01, -.2183D-01,  .2016D+00,
     +   .1400D+00, -.1289D+00,  .1019D-01,
     +   .2081D+00, -.8343D-01, -.2099D-01, -.2099D-01,  .2192D+00,
     +   .1490D+00, -.1241D+00,  .1711D-01,
     +   .2126D+00, -.8386D-01, -.2032D-01, -.2032D-01,  .2294D+00,
     +   .1556D+00, -.1203D+00,  .2223D-01,
     +   .2174D+00, -.8424D-01, -.1954D-01, -.1954D-01,  .2380D+00,
     +   .1626D+00, -.1159D+00,  .2792D-01,
     +   .2226D+00, -.8453D-01, -.1859D-01, -.1859D-01,  .2447D+00,
     +   .1706D+00, -.1107D+00,  .3443D-01,
     +   .2260D+00, -.8464D-01, -.1791D-01, -.1791D-01,  .2474D+00,
     +   .1760D+00, -.1070D+00,  .3894D-01,
     +   .2284D+00, -.8467D-01, -.1739D-01, -.1739D-01,  .2485D+00,
     +   .1801D+00, -.1042D+00,  .4232D-01,
     +   .2318D+00, -.8464D-01, -.1662D-01, -.1662D-01,  .2485D+00,
     +   .1858D+00, -.1002D+00,  .4717D-01 /
        DATA ((PARTON(I,N,19),I=1,8),N=9,16)/
     +   .2340D+00, -.8456D-01, -.1608D-01, -.1608D-01,  .2476D+00,
     +   .1898D+00, -.9729D-01,  .5056D-01,
     +   .2379D+00, -.8426D-01, -.1503D-01, -.1503D-01,  .2437D+00,
     +   .1972D+00, -.9183D-01,  .5697D-01,
     +   .2408D+00, -.8384D-01, -.1411D-01, -.1411D-01,  .2384D+00,
     +   .2037D+00, -.8709D-01,  .6251D-01,
     +   .2430D+00, -.8337D-01, -.1335D-01, -.1335D-01,  .2326D+00,
     +   .2090D+00, -.8314D-01,  .6713D-01,
     +   .2446D+00, -.8290D-01, -.1272D-01, -.1272D-01,  .2270D+00,
     +   .2133D+00, -.7995D-01,  .7088D-01,
     +   .2460D+00, -.8227D-01, -.1202D-01, -.1202D-01,  .2200D+00,
     +   .2182D+00, -.7640D-01,  .7509D-01,
     +   .2470D+00, -.8166D-01, -.1144D-01, -.1144D-01,  .2136D+00,
     +   .2223D+00, -.7344D-01,  .7862D-01,
     +   .2477D+00, -.8104D-01, -.1091D-01, -.1091D-01,  .2073D+00,
     +   .2260D+00, -.7076D-01,  .8183D-01 /
        DATA ((PARTON(I,N,19),I=1,8),N=17,25)/
     +   .2482D+00, -.8043D-01, -.1046D-01, -.1046D-01,  .2015D+00,
     +   .2293D+00, -.6844D-01,  .8465D-01,
     +   .2485D+00, -.7963D-01, -.9915D-02, -.9915D-02,  .1943D+00,
     +   .2332D+00, -.6566D-01,  .8805D-01,
     +   .2486D+00, -.7885D-01, -.9437D-02, -.9437D-02,  .1876D+00,
     +   .2368D+00, -.6320D-01,  .9109D-01,
     +   .2485D+00, -.7804D-01, -.8992D-02, -.8992D-02,  .1811D+00,
     +   .2402D+00, -.6090D-01,  .9398D-01,
     +   .2482D+00, -.7731D-01, -.8621D-02, -.8621D-02,  .1755D+00,
     +   .2431D+00, -.5897D-01,  .9643D-01,
     +   .2478D+00, -.7653D-01, -.8255D-02, -.8255D-02,  .1698D+00,
     +   .2460D+00, -.5705D-01,  .9890D-01,
     +   .2472D+00, -.7579D-01, -.7927D-02, -.7927D-02,  .1646D+00,
     +   .2487D+00, -.5531D-01,  .1012D+00,
     +   .2466D+00, -.7503D-01, -.7615D-02, -.7615D-02,  .1595D+00,
     +   .2514D+00, -.5365D-01,  .1033D+00,
     +   .2459D+00, -.7435D-01, -.7351D-02, -.7351D-02,  .1552D+00,
     +   .2537D+00, -.5224D-01,  .1052D+00 /
        DATA ((PARTON(I,N,20),I=1,8),N=1,8)/
     +   .2368D+00, -.9150D-01, -.2240D-01, -.2240D-01,  .2312D+00,
     +   .1741D+00, -.1314D+00,  .2697D-01,
     +   .2427D+00, -.9161D-01, -.2124D-01, -.2124D-01,  .2397D+00,
     +   .1841D+00, -.1255D+00,  .3501D-01,
     +   .2467D+00, -.9156D-01, -.2037D-01, -.2037D-01,  .2432D+00,
     +   .1911D+00, -.1211D+00,  .4083D-01,
     +   .2508D+00, -.9138D-01, -.1940D-01, -.1940D-01,  .2446D+00,
     +   .1987D+00, -.1161D+00,  .4718D-01,
     +   .2550D+00, -.9101D-01, -.1828D-01, -.1828D-01,  .2433D+00,
     +   .2071D+00, -.1103D+00,  .5432D-01,
     +   .2576D+00, -.9064D-01, -.1751D-01, -.1751D-01,  .2407D+00,
     +   .2127D+00, -.1063D+00,  .5921D-01,
     +   .2594D+00, -.9031D-01, -.1692D-01, -.1692D-01,  .2380D+00,
     +   .2169D+00, -.1033D+00,  .6283D-01,
     +   .2617D+00, -.8973D-01, -.1608D-01, -.1608D-01,  .2330D+00,
     +   .2228D+00, -.9893D-01,  .6800D-01 /
        DATA ((PARTON(I,N,20),I=1,8),N=9,16)/
     +   .2632D+00, -.8926D-01, -.1550D-01, -.1550D-01,  .2287D+00,
     +   .2268D+00, -.9591D-01,  .7159D-01,
     +   .2654D+00, -.8821D-01, -.1440D-01, -.1440D-01,  .2193D+00,
     +   .2344D+00, -.9020D-01,  .7832D-01,
     +   .2668D+00, -.8712D-01, -.1345D-01, -.1345D-01,  .2098D+00,
     +   .2408D+00, -.8530D-01,  .8409D-01,
     +   .2676D+00, -.8606D-01, -.1268D-01, -.1268D-01,  .2011D+00,
     +   .2462D+00, -.8124D-01,  .8888D-01,
     +   .2679D+00, -.8511D-01, -.1205D-01, -.1205D-01,  .1935D+00,
     +   .2505D+00, -.7797D-01,  .9277D-01,
     +   .2679D+00, -.8394D-01, -.1136D-01, -.1136D-01,  .1847D+00,
     +   .2553D+00, -.7434D-01,  .9711D-01,
     +   .2675D+00, -.8286D-01, -.1080D-01, -.1080D-01,  .1771D+00,
     +   .2594D+00, -.7132D-01,  .1007D+00,
     +   .2670D+00, -.8181D-01, -.1029D-01, -.1029D-01,  .1700D+00,
     +   .2630D+00, -.6858D-01,  .1041D+00 /
        DATA ((PARTON(I,N,20),I=1,8),N=17,25)/
     +   .2663D+00, -.8083D-01, -.9846D-02, -.9846D-02,  .1637D+00,
     +   .2663D+00, -.6620D-01,  .1070D+00,
     +   .2652D+00, -.7957D-01, -.9326D-02, -.9326D-02,  .1561D+00,
     +   .2702D+00, -.6336D-01,  .1105D+00,
     +   .2640D+00, -.7838D-01, -.8870D-02, -.8870D-02,  .1493D+00,
     +   .2737D+00, -.6084D-01,  .1136D+00,
     +   .2626D+00, -.7719D-01, -.8447D-02, -.8447D-02,  .1429D+00,
     +   .2770D+00, -.5847D-01,  .1166D+00,
     +   .2612D+00, -.7614D-01, -.8095D-02, -.8095D-02,  .1375D+00,
     +   .2799D+00, -.5648D-01,  .1191D+00,
     +   .2596D+00, -.7504D-01, -.7749D-02, -.7749D-02,  .1322D+00,
     +   .2828D+00, -.5450D-01,  .1217D+00,
     +   .2580D+00, -.7401D-01, -.7439D-02, -.7439D-02,  .1273D+00,
     +   .2856D+00, -.5271D-01,  .1240D+00,
     +   .2563D+00, -.7297D-01, -.7146D-02, -.7146D-02,  .1227D+00,
     +   .2882D+00, -.5098D-01,  .1263D+00,
     +   .2548D+00, -.7205D-01, -.6898D-02, -.6898D-02,  .1188D+00,
     +   .2906D+00, -.4951D-01,  .1283D+00 /
        DATA ((PARTON(I,N,21),I=1,8),N=1,8)/
     +   .2700D+00, -.9816D-01, -.2202D-01, -.2202D-01,  .2477D+00,
     +   .2089D+00, -.1293D+00,  .4698D-01,
     +   .2748D+00, -.9755D-01, -.2066D-01, -.2066D-01,  .2471D+00,
     +   .2191D+00, -.1227D+00,  .5564D-01,
     +   .2778D+00, -.9697D-01, -.1968D-01, -.1968D-01,  .2443D+00,
     +   .2263D+00, -.1178D+00,  .6182D-01,
     +   .2807D+00, -.9619D-01, -.1861D-01, -.1861D-01,  .2394D+00,
     +   .2339D+00, -.1125D+00,  .6848D-01,
     +   .2835D+00, -.9512D-01, -.1741D-01, -.1741D-01,  .2315D+00,
     +   .2422D+00, -.1064D+00,  .7590D-01,
     +   .2850D+00, -.9426D-01, -.1659D-01, -.1659D-01,  .2250D+00,
     +   .2478D+00, -.1022D+00,  .8093D-01,
     +   .2859D+00, -.9355D-01, -.1599D-01, -.1599D-01,  .2195D+00,
     +   .2519D+00, -.9902D-01,  .8464D-01,
     +   .2869D+00, -.9244D-01, -.1513D-01, -.1513D-01,  .2110D+00,
     +   .2576D+00, -.9454D-01,  .8991D-01 /
        DATA ((PARTON(I,N,21),I=1,8),N=9,16)/
     +   .2874D+00, -.9158D-01, -.1453D-01, -.1453D-01,  .2047D+00,
     +   .2616D+00, -.9144D-01,  .9356D-01,
     +   .2876D+00, -.8979D-01, -.1343D-01, -.1343D-01,  .1919D+00,
     +   .2689D+00, -.8561D-01,  .1004D+00,
     +   .2871D+00, -.8806D-01, -.1250D-01, -.1250D-01,  .1802D+00,
     +   .2750D+00, -.8061D-01,  .1062D+00,
     +   .2862D+00, -.8647D-01, -.1174D-01, -.1174D-01,  .1702D+00,
     +   .2801D+00, -.7648D-01,  .1110D+00,
     +   .2851D+00, -.8508D-01, -.1114D-01, -.1114D-01,  .1620D+00,
     +   .2842D+00, -.7315D-01,  .1149D+00,
     +   .2835D+00, -.8342D-01, -.1048D-01, -.1048D-01,  .1527D+00,
     +   .2889D+00, -.6946D-01,  .1193D+00,
     +   .2818D+00, -.8193D-01, -.9932D-02, -.9932D-02,  .1450D+00,
     +   .2927D+00, -.6638D-01,  .1229D+00,
     +   .2799D+00, -.8051D-01, -.9444D-02, -.9444D-02,  .1380D+00,
     +   .2962D+00, -.6358D-01,  .1262D+00 /
        DATA ((PARTON(I,N,21),I=1,8),N=17,25)/
     +   .2780D+00, -.7921D-01, -.9027D-02, -.9027D-02,  .1319D+00,
     +   .2993D+00, -.6115D-01,  .1291D+00,
     +   .2754D+00, -.7757D-01, -.8533D-02, -.8533D-02,  .1247D+00,
     +   .3030D+00, -.5823D-01,  .1326D+00,
     +   .2728D+00, -.7604D-01, -.8102D-02, -.8102D-02,  .1184D+00,
     +   .3063D+00, -.5564D-01,  .1358D+00,
     +   .2701D+00, -.7454D-01, -.7703D-02, -.7703D-02,  .1126D+00,
     +   .3095D+00, -.5320D-01,  .1388D+00,
     +   .2676D+00, -.7323D-01, -.7372D-02, -.7372D-02,  .1078D+00,
     +   .3123D+00, -.5114D-01,  .1414D+00,
     +   .2650D+00, -.7188D-01, -.7047D-02, -.7047D-02,  .1031D+00,
     +   .3151D+00, -.4909D-01,  .1440D+00,
     +   .2624D+00, -.7062D-01, -.6756D-02, -.6756D-02,  .9885D-01,
     +   .3177D+00, -.4723D-01,  .1464D+00,
     +   .2597D+00, -.6937D-01, -.6481D-02, -.6481D-02,  .9489D-01,
     +   .3203D+00, -.4544D-01,  .1487D+00,
     +   .2573D+00, -.6828D-01, -.6249D-02, -.6249D-02,  .9156D-01,
     +   .3226D+00, -.4390D-01,  .1508D+00 /
        DATA ((PARTON(I,N,22),I=1,8),N=1,8)/
     +   .3007D+00, -.1028D+00, -.2097D-01, -.2097D-01,  .2510D+00,
     +   .2430D+00, -.1235D+00,  .6913D-01,
     +   .3039D+00, -.1014D+00, -.1952D-01, -.1952D-01,  .2425D+00,
     +   .2531D+00, -.1165D+00,  .7801D-01,
     +   .3056D+00, -.1003D+00, -.1850D-01, -.1850D-01,  .2347D+00,
     +   .2600D+00, -.1114D+00,  .8429D-01,
     +   .3071D+00, -.9891D-01, -.1739D-01, -.1739D-01,  .2249D+00,
     +   .2674D+00, -.1058D+00,  .9100D-01,
     +   .3080D+00, -.9715D-01, -.1618D-01, -.1618D-01,  .2125D+00,
     +   .2753D+00, -.9955D-01,  .9843D-01,
     +   .3081D+00, -.9582D-01, -.1536D-01, -.1536D-01,  .2033D+00,
     +   .2806D+00, -.9527D-01,  .1034D+00,
     +   .3080D+00, -.9475D-01, -.1476D-01, -.1476D-01,  .1962D+00,
     +   .2845D+00, -.9208D-01,  .1071D+00,
     +   .3074D+00, -.9312D-01, -.1391D-01, -.1391D-01,  .1857D+00,
     +   .2899D+00, -.8755D-01,  .1123D+00 /
        DATA ((PARTON(I,N,22),I=1,8),N=9,16)/
     +   .3067D+00, -.9191D-01, -.1333D-01, -.1333D-01,  .1783D+00,
     +   .2936D+00, -.8441D-01,  .1160D+00,
     +   .3047D+00, -.8945D-01, -.1226D-01, -.1226D-01,  .1641D+00,
     +   .3005D+00, -.7852D-01,  .1227D+00,
     +   .3022D+00, -.8714D-01, -.1137D-01, -.1137D-01,  .1518D+00,
     +   .3062D+00, -.7347D-01,  .1284D+00,
     +   .2995D+00, -.8508D-01, -.1065D-01, -.1065D-01,  .1417D+00,
     +   .3110D+00, -.6929D-01,  .1331D+00,
     +   .2969D+00, -.8331D-01, -.1007D-01, -.1007D-01,  .1336D+00,
     +   .3148D+00, -.6592D-01,  .1369D+00,
     +   .2936D+00, -.8123D-01, -.9446D-02, -.9446D-02,  .1247D+00,
     +   .3191D+00, -.6219D-01,  .1413D+00,
     +   .2904D+00, -.7941D-01, -.8932D-02, -.8932D-02,  .1175D+00,
     +   .3226D+00, -.5905D-01,  .1448D+00,
     +   .2872D+00, -.7768D-01, -.8474D-02, -.8474D-02,  .1110D+00,
     +   .3259D+00, -.5620D-01,  .1481D+00 /
        DATA ((PARTON(I,N,22),I=1,8),N=17,25)/
     +   .2841D+00, -.7612D-01, -.8083D-02, -.8083D-02,  .1056D+00,
     +   .3287D+00, -.5372D-01,  .1510D+00,
     +   .2801D+00, -.7418D-01, -.7621D-02, -.7621D-02,  .9916D-01,
     +   .3321D+00, -.5073D-01,  .1544D+00,
     +   .2762D+00, -.7240D-01, -.7219D-02, -.7219D-02,  .9365D-01,
     +   .3352D+00, -.4808D-01,  .1575D+00,
     +   .2723D+00, -.7066D-01, -.6847D-02, -.6847D-02,  .8860D-01,
     +   .3382D+00, -.4557D-01,  .1605D+00,
     +   .2687D+00, -.6916D-01, -.6539D-02, -.6539D-02,  .8447D-01,
     +   .3408D+00, -.4344D-01,  .1631D+00,
     +   .2650D+00, -.6762D-01, -.6237D-02, -.6237D-02,  .8047D-01,
     +   .3434D+00, -.4132D-01,  .1656D+00,
     +   .2615D+00, -.6620D-01, -.5968D-02, -.5968D-02,  .7693D-01,
     +   .3459D+00, -.3939D-01,  .1680D+00,
     +   .2579D+00, -.6480D-01, -.5713D-02, -.5713D-02,  .7363D-01,
     +   .3484D+00, -.3753D-01,  .1704D+00,
     +   .2547D+00, -.6359D-01, -.5499D-02, -.5499D-02,  .7087D-01,
     +   .3505D+00, -.3593D-01,  .1724D+00 /
        DATA ((PARTON(I,N,23),I=1,8),N=1,8)/
     +   .3284D+00, -.1055D+00, -.1947D-01, -.1947D-01,  .2428D+00,
     +   .2756D+00, -.1146D+00,  .9250D-01,
     +   .3296D+00, -.1034D+00, -.1801D-01, -.1801D-01,  .2283D+00,
     +   .2851D+00, -.1075D+00,  .1013D+00,
     +   .3298D+00, -.1017D+00, -.1699D-01, -.1699D-01,  .2170D+00,
     +   .2917D+00, -.1023D+00,  .1075D+00,
     +   .3294D+00, -.9978D-01, -.1590D-01, -.1590D-01,  .2040D+00,
     +   .2985D+00, -.9668D-01,  .1141D+00,
     +   .3282D+00, -.9737D-01, -.1472D-01, -.1472D-01,  .1889D+00,
     +   .3060D+00, -.9037D-01,  .1213D+00,
     +   .3268D+00, -.9560D-01, -.1392D-01, -.1392D-01,  .1784D+00,
     +   .3109D+00, -.8607D-01,  .1262D+00,
     +   .3255D+00, -.9421D-01, -.1335D-01, -.1335D-01,  .1706D+00,
     +   .3145D+00, -.8288D-01,  .1298D+00,
     +   .3232D+00, -.9212D-01, -.1254D-01, -.1254D-01,  .1594D+00,
     +   .3195D+00, -.7834D-01,  .1349D+00 /
        DATA ((PARTON(I,N,23),I=1,8),N=9,16)/
     +   .3213D+00, -.9059D-01, -.1199D-01, -.1199D-01,  .1517D+00,
     +   .3229D+00, -.7520D-01,  .1384D+00,
     +   .3169D+00, -.8754D-01, -.1098D-01, -.1098D-01,  .1375D+00,
     +   .3292D+00, -.6930D-01,  .1449D+00,
     +   .3122D+00, -.8474D-01, -.1014D-01, -.1014D-01,  .1257D+00,
     +   .3345D+00, -.6424D-01,  .1504D+00,
     +   .3077D+00, -.8229D-01, -.9463D-02, -.9463D-02,  .1162D+00,
     +   .3388D+00, -.6004D-01,  .1550D+00,
     +   .3037D+00, -.8021D-01, -.8927D-02, -.8927D-02,  .1087D+00,
     +   .3423D+00, -.5664D-01,  .1587D+00,
     +   .2986D+00, -.7780D-01, -.8344D-02, -.8344D-02,  .1007D+00,
     +   .3463D+00, -.5288D-01,  .1629D+00,
     +   .2940D+00, -.7571D-01, -.7868D-02, -.7868D-02,  .9432D-01,
     +   .3495D+00, -.4971D-01,  .1663D+00,
     +   .2895D+00, -.7375D-01, -.7444D-02, -.7444D-02,  .8870D-01,
     +   .3524D+00, -.4682D-01,  .1695D+00 /
        DATA ((PARTON(I,N,23),I=1,8),N=17,25)/
     +   .2853D+00, -.7199D-01, -.7082D-02, -.7082D-02,  .8398D-01,
     +   .3550D+00, -.4429D-01,  .1723D+00,
     +   .2799D+00, -.6983D-01, -.6657D-02, -.6657D-02,  .7851D-01,
     +   .3581D+00, -.4125D-01,  .1756D+00,
     +   .2749D+00, -.6786D-01, -.6287D-02, -.6287D-02,  .7386D-01,
     +   .3609D+00, -.3854D-01,  .1786D+00,
     +   .2698D+00, -.6596D-01, -.5946D-02, -.5946D-02,  .6963D-01,
     +   .3636D+00, -.3597D-01,  .1815D+00,
     +   .2654D+00, -.6433D-01, -.5665D-02, -.5665D-02,  .6620D-01,
     +   .3659D+00, -.3379D-01,  .1840D+00,
     +   .2607D+00, -.6267D-01, -.5389D-02, -.5389D-02,  .6290D-01,
     +   .3684D+00, -.3161D-01,  .1865D+00,
     +   .2564D+00, -.6115D-01, -.5144D-02, -.5144D-02,  .6000D-01,
     +   .3706D+00, -.2962D-01,  .1889D+00,
     +   .2520D+00, -.5966D-01, -.4912D-02, -.4912D-02,  .5729D-01,
     +   .3729D+00, -.2770D-01,  .1912D+00,
     +   .2482D+00, -.5837D-01, -.4718D-02, -.4718D-02,  .5505D-01,
     +   .3750D+00, -.2604D-01,  .1932D+00 /
        DATA ((PARTON(I,N,24),I=1,8),N=1,8)/
     +   .3527D+00, -.1064D+00, -.1769D-01, -.1769D-01,  .2256D+00,
     +   .3060D+00, -.1034D+00,  .1164D+00,
     +   .3515D+00, -.1037D+00, -.1628D-01, -.1628D-01,  .2074D+00,
     +   .3148D+00, -.9621D-01,  .1249D+00,
     +   .3499D+00, -.1015D+00, -.1530D-01, -.1530D-01,  .1940D+00,
     +   .3209D+00, -.9105D-01,  .1308D+00,
     +   .3476D+00, -.9902D-01, -.1426D-01, -.1426D-01,  .1796D+00,
     +   .3272D+00, -.8546D-01,  .1372D+00,
     +   .3440D+00, -.9603D-01, -.1314D-01, -.1314D-01,  .1635D+00,
     +   .3340D+00, -.7920D-01,  .1441D+00,
     +   .3410D+00, -.9387D-01, -.1239D-01, -.1239D-01,  .1527D+00,
     +   .3385D+00, -.7493D-01,  .1488D+00,
     +   .3385D+00, -.9219D-01, -.1185D-01, -.1185D-01,  .1448D+00,
     +   .3418D+00, -.7177D-01,  .1522D+00,
     +   .3344D+00, -.8971D-01, -.1110D-01, -.1110D-01,  .1339D+00,
     +   .3464D+00, -.6726D-01,  .1571D+00 /
        DATA ((PARTON(I,N,24),I=1,8),N=9,16)/
     +   .3311D+00, -.8791D-01, -.1059D-01, -.1059D-01,  .1266D+00,
     +   .3495D+00, -.6415D-01,  .1605D+00,
     +   .3243D+00, -.8438D-01, -.9651D-02, -.9651D-02,  .1133D+00,
     +   .3552D+00, -.5828D-01,  .1667D+00,
     +   .3175D+00, -.8119D-01, -.8876D-02, -.8876D-02,  .1025D+00,
     +   .3600D+00, -.5324D-01,  .1720D+00,
     +   .3113D+00, -.7842D-01, -.8253D-02, -.8253D-02,  .9409D-01,
     +   .3639D+00, -.4905D-01,  .1763D+00,
     +   .3058D+00, -.7611D-01, -.7761D-02, -.7761D-02,  .8758D-01,
     +   .3670D+00, -.4565D-01,  .1799D+00,
     +   .2991D+00, -.7345D-01, -.7228D-02, -.7228D-02,  .8068D-01,
     +   .3706D+00, -.4186D-01,  .1839D+00,
     +   .2932D+00, -.7117D-01, -.6794D-02, -.6794D-02,  .7521D-01,
     +   .3735D+00, -.3867D-01,  .1872D+00,
     +   .2875D+00, -.6904D-01, -.6408D-02, -.6408D-02,  .7047D-01,
     +   .3761D+00, -.3576D-01,  .1902D+00 /
        DATA ((PARTON(I,N,24),I=1,8),N=17,25)/
     +   .2823D+00, -.6716D-01, -.6080D-02, -.6080D-02,  .6652D-01,
     +   .3784D+00, -.3321D-01,  .1929D+00,
     +   .2757D+00, -.6485D-01, -.5695D-02, -.5695D-02,  .6198D-01,
     +   .3811D+00, -.3013D-01,  .1961D+00,
     +   .2696D+00, -.6277D-01, -.5362D-02, -.5362D-02,  .5815D-01,
     +   .3836D+00, -.2738D-01,  .1990D+00,
     +   .2635D+00, -.6077D-01, -.5055D-02, -.5055D-02,  .5469D-01,
     +   .3861D+00, -.2476D-01,  .2018D+00,
     +   .2583D+00, -.5906D-01, -.4802D-02, -.4802D-02,  .5189D-01,
     +   .3882D+00, -.2255D-01,  .2042D+00,
     +   .2529D+00, -.5734D-01, -.4555D-02, -.4555D-02,  .4921D-01,
     +   .3904D+00, -.2032D-01,  .2066D+00,
     +   .2478D+00, -.5576D-01, -.4336D-02, -.4336D-02,  .4687D-01,
     +   .3925D+00, -.1828D-01,  .2089D+00,
     +   .2428D+00, -.5423D-01, -.4130D-02, -.4130D-02,  .4469D-01,
     +   .3946D+00, -.1631D-01,  .2111D+00,
     +   .2385D+00, -.5292D-01, -.3956D-02, -.3956D-02,  .4288D-01,
     +   .3965D+00, -.1461D-01,  .2131D+00 /
        DATA ((PARTON(I,N,25),I=1,8),N=1,8)/
     +   .3731D+00, -.1058D+00, -.1577D-01, -.1577D-01,  .2024D+00,
     +   .3339D+00, -.9022D-01,  .1401D+00,
     +   .3693D+00, -.1024D+00, -.1444D-01, -.1444D-01,  .1824D+00,
     +   .3420D+00, -.8313D-01,  .1483D+00,
     +   .3658D+00, -.9981D-01, -.1352D-01, -.1352D-01,  .1685D+00,
     +   .3475D+00, -.7805D-01,  .1539D+00,
     +   .3613D+00, -.9685D-01, -.1256D-01, -.1256D-01,  .1538D+00,
     +   .3533D+00, -.7255D-01,  .1599D+00,
     +   .3553D+00, -.9337D-01, -.1152D-01, -.1152D-01,  .1380D+00,
     +   .3595D+00, -.6639D-01,  .1665D+00,
     +   .3507D+00, -.9088D-01, -.1084D-01, -.1084D-01,  .1278D+00,
     +   .3635D+00, -.6220D-01,  .1709D+00,
     +   .3468D+00, -.8897D-01, -.1034D-01, -.1034D-01,  .1204D+00,
     +   .3665D+00, -.5908D-01,  .1742D+00,
     +   .3409D+00, -.8616D-01, -.9649D-02, -.9649D-02,  .1104D+00,
     +   .3706D+00, -.5465D-01,  .1788D+00 /
        DATA ((PARTON(I,N,25),I=1,8),N=9,16)/
     +   .3364D+00, -.8415D-01, -.9183D-02, -.9183D-02,  .1038D+00,
     +   .3735D+00, -.5158D-01,  .1820D+00,
     +   .3272D+00, -.8025D-01, -.8332D-02, -.8332D-02,  .9199D-01,
     +   .3786D+00, -.4578D-01,  .1879D+00,
     +   .3184D+00, -.7676D-01, -.7630D-02, -.7630D-02,  .8264D-01,
     +   .3829D+00, -.4078D-01,  .1929D+00,
     +   .3105D+00, -.7377D-01, -.7067D-02, -.7067D-02,  .7542D-01,
     +   .3864D+00, -.3661D-01,  .1970D+00,
     +   .3036D+00, -.7129D-01, -.6624D-02, -.6624D-02,  .6993D-01,
     +   .3892D+00, -.3323D-01,  .2004D+00,
     +   .2956D+00, -.6847D-01, -.6145D-02, -.6145D-02,  .6417D-01,
     +   .3924D+00, -.2945D-01,  .2042D+00,
     +   .2885D+00, -.6606D-01, -.5756D-02, -.5756D-02,  .5964D-01,
     +   .3950D+00, -.2626D-01,  .2073D+00,
     +   .2817D+00, -.6384D-01, -.5412D-02, -.5412D-02,  .5574D-01,
     +   .3973D+00, -.2334D-01,  .2102D+00 /
        DATA ((PARTON(I,N,25),I=1,8),N=17,25)/
     +   .2756D+00, -.6188D-01, -.5120D-02, -.5120D-02,  .5251D-01,
     +   .3993D+00, -.2078D-01,  .2127D+00,
     +   .2679D+00, -.5950D-01, -.4778D-02, -.4778D-02,  .4883D-01,
     +   .4017D+00, -.1769D-01,  .2158D+00,
     +   .2609D+00, -.5736D-01, -.4483D-02, -.4483D-02,  .4572D-01,
     +   .4039D+00, -.1491D-01,  .2185D+00,
     +   .2541D+00, -.5532D-01, -.4212D-02, -.4212D-02,  .4293D-01,
     +   .4061D+00, -.1228D-01,  .2211D+00,
     +   .2482D+00, -.5359D-01, -.3989D-02, -.3989D-02,  .4069D-01,
     +   .4080D+00, -.1003D-01,  .2234D+00,
     +   .2421D+00, -.5185D-01, -.3772D-02, -.3772D-02,  .3854D-01,
     +   .4099D+00, -.7778D-02,  .2257D+00,
     +   .2365D+00, -.5027D-01, -.3580D-02, -.3580D-02,  .3666D-01,
     +   .4118D+00, -.5713D-02,  .2279D+00,
     +   .2310D+00, -.4874D-01, -.3400D-02, -.3400D-02,  .3491D-01,
     +   .4137D+00, -.3709D-02,  .2301D+00,
     +   .2263D+00, -.4743D-01, -.3249D-02, -.3249D-02,  .3347D-01,
     +   .4155D+00, -.1977D-02,  .2320D+00 /
        DATA ((PARTON(I,N,26),I=1,8),N=1,8)/
     +   .3891D+00, -.1037D+00, -.1381D-01, -.1381D-01,  .1758D+00,
     +   .3593D+00, -.7553D-01,  .1635D+00,
     +   .3826D+00, -.9979D-01, -.1259D-01, -.1259D-01,  .1559D+00,
     +   .3667D+00, -.6860D-01,  .1711D+00,
     +   .3772D+00, -.9683D-01, -.1175D-01, -.1175D-01,  .1424D+00,
     +   .3717D+00, -.6365D-01,  .1764D+00,
     +   .3705D+00, -.9350D-01, -.1088D-01, -.1088D-01,  .1286D+00,
     +   .3768D+00, -.5828D-01,  .1821D+00,
     +   .3621D+00, -.8961D-01, -.9934D-02, -.9934D-02,  .1141D+00,
     +   .3824D+00, -.5227D-01,  .1883D+00,
     +   .3558D+00, -.8686D-01, -.9316D-02, -.9316D-02,  .1048D+00,
     +   .3861D+00, -.4817D-01,  .1924D+00,
     +   .3507D+00, -.8477D-01, -.8868D-02, -.8868D-02,  .9830D-01,
     +   .3887D+00, -.4512D-01,  .1955D+00,
     +   .3430D+00, -.8172D-01, -.8248D-02, -.8248D-02,  .8953D-01,
     +   .3925D+00, -.4077D-01,  .1998D+00 /
        DATA ((PARTON(I,N,26),I=1,8),N=9,16)/
     +   .3374D+00, -.7955D-01, -.7829D-02, -.7829D-02,  .8378D-01,
     +   .3951D+00, -.3776D-01,  .2028D+00,
     +   .3259D+00, -.7538D-01, -.7069D-02, -.7069D-02,  .7376D-01,
     +   .3997D+00, -.3206D-01,  .2083D+00,
     +   .3152D+00, -.7169D-01, -.6444D-02, -.6444D-02,  .6593D-01,
     +   .4035D+00, -.2713D-01,  .2130D+00,
     +   .3058D+00, -.6856D-01, -.5944D-02, -.5944D-02,  .5996D-01,
     +   .4066D+00, -.2301D-01,  .2169D+00,
     +   .2978D+00, -.6599D-01, -.5552D-02, -.5552D-02,  .5545D-01,
     +   .4090D+00, -.1966D-01,  .2200D+00,
     +   .2884D+00, -.6308D-01, -.5130D-02, -.5130D-02,  .5076D-01,
     +   .4119D+00, -.1591D-01,  .2237D+00,
     +   .2803D+00, -.6061D-01, -.4788D-02, -.4788D-02,  .4709D-01,
     +   .4142D+00, -.1274D-01,  .2266D+00,
     +   .2726D+00, -.5835D-01, -.4486D-02, -.4486D-02,  .4395D-01,
     +   .4162D+00, -.9835D-02,  .2293D+00 /
        DATA ((PARTON(I,N,26),I=1,8),N=17,25)/
     +   .2658D+00, -.5637D-01, -.4231D-02, -.4231D-02,  .4135D-01,
     +   .4180D+00, -.7286D-02,  .2317D+00,
     +   .2573D+00, -.5397D-01, -.3933D-02, -.3933D-02,  .3840D-01,
     +   .4201D+00, -.4197D-02,  .2345D+00,
     +   .2495D+00, -.5183D-01, -.3676D-02, -.3676D-02,  .3592D-01,
     +   .4220D+00, -.1424D-02,  .2371D+00,
     +   .2421D+00, -.4980D-01, -.3442D-02, -.3442D-02,  .3370D-01,
     +   .4239D+00,  .1218D-02,  .2396D+00,
     +   .2357D+00, -.4809D-01, -.3250D-02, -.3250D-02,  .3191D-01,
     +   .4256D+00,  .3467D-02,  .2418D+00,
     +   .2291D+00, -.4638D-01, -.3063D-02, -.3063D-02,  .3019D-01,
     +   .4273D+00,  .5734D-02,  .2440D+00,
     +   .2231D+00, -.4483D-01, -.2899D-02, -.2899D-02,  .2870D-01,
     +   .4290D+00,  .7813D-02,  .2460D+00,
     +   .2173D+00, -.4334D-01, -.2745D-02, -.2745D-02,  .2731D-01,
     +   .4307D+00,  .9833D-02,  .2480D+00,
     +   .2122D+00, -.4206D-01, -.2616D-02, -.2616D-02,  .2616D-01,
     +   .4323D+00,  .1158D-01,  .2499D+00 /
        DATA ((PARTON(I,N,27),I=1,8),N=1,8)/
     +   .4007D+00, -.1005D+00, -.1189D-01, -.1189D-01,  .1485D+00,
     +   .3824D+00, -.5965D-01,  .1861D+00,
     +   .3914D+00, -.9605D-01, -.1079D-01, -.1079D-01,  .1298D+00,
     +   .3890D+00, -.5294D-01,  .1932D+00,
     +   .3840D+00, -.9279D-01, -.1004D-01, -.1004D-01,  .1175D+00,
     +   .3934D+00, -.4814D-01,  .1981D+00,
     +   .3752D+00, -.8916D-01, -.9259D-02, -.9259D-02,  .1051D+00,
     +   .3981D+00, -.4294D-01,  .2034D+00,
     +   .3644D+00, -.8496D-01, -.8422D-02, -.8422D-02,  .9244D-01,
     +   .4031D+00, -.3710D-01,  .2092D+00,
     +   .3565D+00, -.8203D-01, -.7874D-02, -.7874D-02,  .8449D-01,
     +   .4064D+00, -.3311D-01,  .2130D+00,
     +   .3503D+00, -.7981D-01, -.7478D-02, -.7478D-02,  .7895D-01,
     +   .4087D+00, -.3014D-01,  .2159D+00,
     +   .3410D+00, -.7659D-01, -.6931D-02, -.6931D-02,  .7157D-01,
     +   .4121D+00, -.2590D-01,  .2199D+00 /
        DATA ((PARTON(I,N,27),I=1,8),N=9,16)/
     +   .3342D+00, -.7433D-01, -.6562D-02, -.6562D-02,  .6679D-01,
     +   .4144D+00, -.2296D-01,  .2227D+00,
     +   .3207D+00, -.6999D-01, -.5895D-02, -.5895D-02,  .5854D-01,
     +   .4185D+00, -.1738D-01,  .2279D+00,
     +   .3084D+00, -.6620D-01, -.5348D-02, -.5348D-02,  .5217D-01,
     +   .4219D+00, -.1255D-01,  .2323D+00,
     +   .2976D+00, -.6301D-01, -.4912D-02, -.4912D-02,  .4734D-01,
     +   .4246D+00, -.8504D-02,  .2359D+00,
     +   .2886D+00, -.6040D-01, -.4572D-02, -.4572D-02,  .4373D-01,
     +   .4268D+00, -.5204D-02,  .2388D+00,
     +   .2782D+00, -.5747D-01, -.4206D-02, -.4206D-02,  .3998D-01,
     +   .4295D+00, -.1497D-02,  .2423D+00,
     +   .2692D+00, -.5500D-01, -.3911D-02, -.3911D-02,  .3706D-01,
     +   .4314D+00,  .1635D-02,  .2450D+00,
     +   .2608D+00, -.5276D-01, -.3652D-02, -.3652D-02,  .3456D-01,
     +   .4332D+00,  .4508D-02,  .2475D+00 /
        DATA ((PARTON(I,N,27),I=1,8),N=17,25)/
     +   .2534D+00, -.5079D-01, -.3433D-02, -.3433D-02,  .3251D-01,
     +   .4347D+00,  .7032D-02,  .2497D+00,
     +   .2443D+00, -.4844D-01, -.3178D-02, -.3178D-02,  .3017D-01,
     +   .4366D+00,  .1010D-01,  .2524D+00,
     +   .2360D+00, -.4634D-01, -.2960D-02, -.2960D-02,  .2820D-01,
     +   .4383D+00,  .1285D-01,  .2548D+00,
     +   .2281D+00, -.4437D-01, -.2761D-02, -.2761D-02,  .2644D-01,
     +   .4399D+00,  .1548D-01,  .2572D+00,
     +   .2213D+00, -.4271D-01, -.2598D-02, -.2598D-02,  .2502D-01,
     +   .4414D+00,  .1772D-01,  .2592D+00,
     +   .2145D+00, -.4106D-01, -.2441D-02, -.2441D-02,  .2365D-01,
     +   .4429D+00,  .1998D-01,  .2612D+00,
     +   .2082D+00, -.3957D-01, -.2303D-02, -.2303D-02,  .2247D-01,
     +   .4444D+00,  .2206D-01,  .2632D+00,
     +   .2021D+00, -.3814D-01, -.2174D-02, -.2174D-02,  .2136D-01,
     +   .4459D+00,  .2408D-01,  .2651D+00,
     +   .1969D+00, -.3693D-01, -.2067D-02, -.2067D-02,  .2045D-01,
     +   .4473D+00,  .2583D-01,  .2668D+00 /
        DATA ((PARTON(I,N,28),I=1,8),N=1,8)/
     +   .4075D+00, -.9611D-01, -.1006D-01, -.1006D-01,  .1220D+00,
     +   .4032D+00, -.4290D-01,  .2078D+00,
     +   .3955D+00, -.9137D-01, -.9095D-02, -.9095D-02,  .1055D+00,
     +   .4091D+00, -.3643D-01,  .2144D+00,
     +   .3862D+00, -.8789D-01, -.8437D-02, -.8437D-02,  .9485D-01,
     +   .4131D+00, -.3180D-01,  .2189D+00,
     +   .3754D+00, -.8405D-01, -.7753D-02, -.7753D-02,  .8429D-01,
     +   .4172D+00, -.2677D-01,  .2238D+00,
     +   .3624D+00, -.7964D-01, -.7023D-02, -.7023D-02,  .7364D-01,
     +   .4217D+00, -.2113D-01,  .2291D+00,
     +   .3530D+00, -.7659D-01, -.6545D-02, -.6545D-02,  .6707D-01,
     +   .4246D+00, -.1727D-01,  .2327D+00,
     +   .3458D+00, -.7430D-01, -.6201D-02, -.6201D-02,  .6252D-01,
     +   .4267D+00, -.1439D-01,  .2354D+00,
     +   .3350D+00, -.7099D-01, -.5726D-02, -.5726D-02,  .5652D-01,
     +   .4297D+00, -.1027D-01,  .2391D+00 /
        DATA ((PARTON(I,N,28),I=1,8),N=9,16)/
     +   .3272D+00, -.6867D-01, -.5407D-02, -.5407D-02,  .5266D-01,
     +   .4318D+00, -.7399D-02,  .2417D+00,
     +   .3120D+00, -.6428D-01, -.4831D-02, -.4831D-02,  .4606D-01,
     +   .4355D+00, -.1964D-02,  .2465D+00,
     +   .2983D+00, -.6046D-01, -.4361D-02, -.4361D-02,  .4100D-01,
     +   .4385D+00,  .2750D-02,  .2506D+00,
     +   .2864D+00, -.5728D-01, -.3989D-02, -.3989D-02,  .3719D-01,
     +   .4409D+00,  .6702D-02,  .2540D+00,
     +   .2766D+00, -.5469D-01, -.3698D-02, -.3698D-02,  .3434D-01,
     +   .4428D+00,  .9934D-02,  .2567D+00,
     +   .2653D+00, -.5180D-01, -.3387D-02, -.3387D-02,  .3139D-01,
     +   .4452D+00,  .1358D-01,  .2600D+00,
     +   .2557D+00, -.4939D-01, -.3138D-02, -.3138D-02,  .2910D-01,
     +   .4469D+00,  .1666D-01,  .2625D+00,
     +   .2468D+00, -.4720D-01, -.2919D-02, -.2919D-02,  .2713D-01,
     +   .4485D+00,  .1948D-01,  .2649D+00 /
        DATA ((PARTON(I,N,28),I=1,8),N=17,25)/
     +   .2390D+00, -.4529D-01, -.2735D-02, -.2735D-02,  .2551D-01,
     +   .4498D+00,  .2197D-01,  .2669D+00,
     +   .2294D+00, -.4302D-01, -.2522D-02, -.2522D-02,  .2367D-01,
     +   .4514D+00,  .2499D-01,  .2694D+00,
     +   .2208D+00, -.4101D-01, -.2339D-02, -.2339D-02,  .2212D-01,
     +   .4529D+00,  .2771D-01,  .2716D+00,
     +   .2126D+00, -.3912D-01, -.2174D-02, -.2174D-02,  .2072D-01,
     +   .4543D+00,  .3030D-01,  .2738D+00,
     +   .2056D+00, -.3754D-01, -.2040D-02, -.2040D-02,  .1960D-01,
     +   .4556D+00,  .3252D-01,  .2757D+00,
     +   .1986D+00, -.3598D-01, -.1910D-02, -.1910D-02,  .1852D-01,
     +   .4569D+00,  .3477D-01,  .2776D+00,
     +   .1922D+00, -.3457D-01, -.1796D-02, -.1796D-02,  .1758D-01,
     +   .4582D+00,  .3683D-01,  .2794D+00,
     +   .1861D+00, -.3323D-01, -.1690D-02, -.1690D-02,  .1670D-01,
     +   .4596D+00,  .3884D-01,  .2813D+00,
     +   .1808D+00, -.3209D-01, -.1602D-02, -.1602D-02,  .1597D-01,
     +   .4609D+00,  .4059D-01,  .2829D+00 /
        DATA ((PARTON(I,N,29),I=1,8),N=1,8)/
     +   .4097D+00, -.9092D-01, -.8376D-02, -.8376D-02,  .9787D-01,
     +   .4219D+00, -.2550D-01,  .2285D+00,
     +   .3951D+00, -.8594D-01, -.7541D-02, -.7541D-02,  .8392D-01,
     +   .4272D+00, -.1929D-01,  .2345D+00,
     +   .3840D+00, -.8232D-01, -.6973D-02, -.6973D-02,  .7505D-01,
     +   .4307D+00, -.1484D-01,  .2388D+00,
     +   .3714D+00, -.7834D-01, -.6385D-02, -.6385D-02,  .6639D-01,
     +   .4344D+00, -.1000D-01,  .2432D+00,
     +   .3564D+00, -.7383D-01, -.5758D-02, -.5758D-02,  .5779D-01,
     +   .4384D+00, -.4559D-02,  .2481D+00,
     +   .3457D+00, -.7073D-01, -.5349D-02, -.5349D-02,  .5253D-01,
     +   .4410D+00, -.8327D-03,  .2514D+00,
     +   .3375D+00, -.6841D-01, -.5055D-02, -.5055D-02,  .4892D-01,
     +   .4428D+00,  .1948D-02,  .2539D+00,
     +   .3255D+00, -.6508D-01, -.4650D-02, -.4650D-02,  .4418D-01,
     +   .4455D+00,  .5933D-02,  .2573D+00 /
        DATA ((PARTON(I,N,29),I=1,8),N=9,16)/
     +   .3169D+00, -.6276D-01, -.4379D-02, -.4379D-02,  .4116D-01,
     +   .4474D+00,  .8718D-02,  .2598D+00,
     +   .3002D+00, -.5839D-01, -.3891D-02, -.3891D-02,  .3600D-01,
     +   .4507D+00,  .1399D-01,  .2642D+00,
     +   .2853D+00, -.5463D-01, -.3495D-02, -.3495D-02,  .3206D-01,
     +   .4533D+00,  .1857D-01,  .2680D+00,
     +   .2727D+00, -.5152D-01, -.3182D-02, -.3182D-02,  .2910D-01,
     +   .4555D+00,  .2242D-01,  .2711D+00,
     +   .2622D+00, -.4900D-01, -.2939D-02, -.2939D-02,  .2688D-01,
     +   .4572D+00,  .2557D-01,  .2737D+00,
     +   .2504D+00, -.4620D-01, -.2680D-02, -.2680D-02,  .2458D-01,
     +   .4594D+00,  .2914D-01,  .2767D+00,
     +   .2403D+00, -.4388D-01, -.2473D-02, -.2473D-02,  .2279D-01,
     +   .4609D+00,  .3215D-01,  .2791D+00,
     +   .2311D+00, -.4178D-01, -.2292D-02, -.2292D-02,  .2126D-01,
     +   .4623D+00,  .3492D-01,  .2813D+00 /
        DATA ((PARTON(I,N,29),I=1,8),N=17,25)/
     +   .2230D+00, -.3997D-01, -.2140D-02, -.2140D-02,  .1999D-01,
     +   .4634D+00,  .3735D-01,  .2832D+00,
     +   .2131D+00, -.3781D-01, -.1965D-02, -.1965D-02,  .1854D-01,
     +   .4648D+00,  .4031D-01,  .2855D+00,
     +   .2044D+00, -.3592D-01, -.1816D-02, -.1816D-02,  .1732D-01,
     +   .4661D+00,  .4298D-01,  .2876D+00,
     +   .1961D+00, -.3414D-01, -.1681D-02, -.1681D-02,  .1622D-01,
     +   .4673D+00,  .4554D-01,  .2896D+00,
     +   .1890D+00, -.3267D-01, -.1572D-02, -.1572D-02,  .1533D-01,
     +   .4685D+00,  .4773D-01,  .2914D+00,
     +   .1820D+00, -.3121D-01, -.1467D-02, -.1467D-02,  .1447D-01,
     +   .4696D+00,  .4994D-01,  .2932D+00,
     +   .1756D+00, -.2990D-01, -.1375D-02, -.1375D-02,  .1373D-01,
     +   .4708D+00,  .5198D-01,  .2949D+00,
     +   .1695D+00, -.2866D-01, -.1290D-02, -.1290D-02,  .1303D-01,
     +   .4720D+00,  .5397D-01,  .2966D+00,
     +   .1643D+00, -.2761D-01, -.1219D-02, -.1219D-02,  .1245D-01,
     +   .4731D+00,  .5570D-01,  .2981D+00 /
        DATA ((PARTON(I,N,30),I=1,8),N=1,8)/
     +   .4072D+00, -.8504D-01, -.6858D-02, -.6858D-02,  .7668D-01,
     +   .4389D+00, -.7657D-02,  .2481D+00,
     +   .3903D+00, -.7993D-01, -.6149D-02, -.6149D-02,  .6539D-01,
     +   .4435D+00, -.1705D-02,  .2537D+00,
     +   .3776D+00, -.7625D-01, -.5668D-02, -.5668D-02,  .5831D-01,
     +   .4467D+00,  .2563D-02,  .2575D+00,
     +   .3633D+00, -.7223D-01, -.5170D-02, -.5170D-02,  .5148D-01,
     +   .4499D+00,  .7203D-02,  .2617D+00,
     +   .3466D+00, -.6770D-01, -.4641D-02, -.4641D-02,  .4476D-01,
     +   .4534D+00,  .1243D-01,  .2662D+00,
     +   .3348D+00, -.6461D-01, -.4297D-02, -.4297D-02,  .4069D-01,
     +   .4557D+00,  .1602D-01,  .2692D+00,
     +   .3258D+00, -.6230D-01, -.4050D-02, -.4050D-02,  .3791D-01,
     +   .4574D+00,  .1869D-01,  .2714D+00,
     +   .3128D+00, -.5902D-01, -.3711D-02, -.3711D-02,  .3426D-01,
     +   .4598D+00,  .2254D-01,  .2746D+00 /
        DATA ((PARTON(I,N,30),I=1,8),N=9,16)/
     +   .3035D+00, -.5675D-01, -.3485D-02, -.3485D-02,  .3194D-01,
     +   .4615D+00,  .2523D-01,  .2769D+00,
     +   .2857D+00, -.5248D-01, -.3079D-02, -.3079D-02,  .2799D-01,
     +   .4644D+00,  .3033D-01,  .2810D+00,
     +   .2701D+00, -.4884D-01, -.2751D-02, -.2751D-02,  .2497D-01,
     +   .4668D+00,  .3476D-01,  .2845D+00,
     +   .2568D+00, -.4585D-01, -.2493D-02, -.2493D-02,  .2269D-01,
     +   .4687D+00,  .3849D-01,  .2874D+00,
     +   .2460D+00, -.4344D-01, -.2294D-02, -.2294D-02,  .2098D-01,
     +   .4702D+00,  .4155D-01,  .2898D+00,
     +   .2338D+00, -.4078D-01, -.2082D-02, -.2082D-02,  .1921D-01,
     +   .4722D+00,  .4504D-01,  .2926D+00,
     +   .2235D+00, -.3859D-01, -.1913D-02, -.1913D-02,  .1782D-01,
     +   .4736D+00,  .4797D-01,  .2948D+00,
     +   .2141D+00, -.3661D-01, -.1766D-02, -.1766D-02,  .1663D-01,
     +   .4748D+00,  .5067D-01,  .2969D+00 /
        DATA ((PARTON(I,N,30),I=1,8),N=17,25)/
     +   .2059D+00, -.3491D-01, -.1644D-02, -.1644D-02,  .1563D-01,
     +   .4758D+00,  .5305D-01,  .2986D+00,
     +   .1960D+00, -.3290D-01, -.1503D-02, -.1503D-02,  .1450D-01,
     +   .4770D+00,  .5594D-01,  .3008D+00,
     +   .1872D+00, -.3113D-01, -.1383D-02, -.1383D-02,  .1354D-01,
     +   .4781D+00,  .5855D-01,  .3027D+00,
     +   .1790D+00, -.2950D-01, -.1276D-02, -.1276D-02,  .1267D-01,
     +   .4792D+00,  .6106D-01,  .3046D+00,
     +   .1720D+00, -.2814D-01, -.1189D-02, -.1189D-02,  .1196D-01,
     +   .4802D+00,  .6321D-01,  .3062D+00,
     +   .1651D+00, -.2680D-01, -.1105D-02, -.1105D-02,  .1128D-01,
     +   .4812D+00,  .6539D-01,  .3079D+00,
     +   .1588D+00, -.2560D-01, -.1033D-02, -.1033D-02,  .1069D-01,
     +   .4823D+00,  .6740D-01,  .3095D+00,
     +   .1529D+00, -.2447D-01, -.9660D-03, -.9660D-03,  .1013D-01,
     +   .4833D+00,  .6936D-01,  .3111D+00,
     +   .1478D+00, -.2352D-01, -.9107D-03, -.9107D-03,  .9669D-02,
     +   .4843D+00,  .7107D-01,  .3125D+00 /
        DATA ((PARTON(I,N,31),I=1,8),N=1,8)/
     +   .4003D+00, -.7867D-01, -.5521D-02, -.5521D-02,  .5878D-01,
     +   .4542D+00,  .1048D-01,  .2667D+00,
     +   .3813D+00, -.7353D-01, -.4928D-02, -.4928D-02,  .5002D-01,
     +   .4583D+00,  .1617D-01,  .2718D+00,
     +   .3672D+00, -.6985D-01, -.4528D-02, -.4528D-02,  .4458D-01,
     +   .4611D+00,  .2025D-01,  .2754D+00,
     +   .3515D+00, -.6587D-01, -.4114D-02, -.4114D-02,  .3938D-01,
     +   .4639D+00,  .2469D-01,  .2791D+00,
     +   .3334D+00, -.6141D-01, -.3676D-02, -.3676D-02,  .3430D-01,
     +   .4670D+00,  .2970D-01,  .2832D+00,
     +   .3207D+00, -.5838D-01, -.3392D-02, -.3392D-02,  .3123D-01,
     +   .4690D+00,  .3314D-01,  .2860D+00,
     +   .3112D+00, -.5613D-01, -.3188D-02, -.3188D-02,  .2914D-01,
     +   .4705D+00,  .3571D-01,  .2880D+00,
     +   .2973D+00, -.5295D-01, -.2910D-02, -.2910D-02,  .2640D-01,
     +   .4726D+00,  .3941D-01,  .2910D+00 /
        DATA ((PARTON(I,N,31),I=1,8),N=9,16)/
     +   .2876D+00, -.5076D-01, -.2724D-02, -.2724D-02,  .2465D-01,
     +   .4742D+00,  .4201D-01,  .2931D+00,
     +   .2690D+00, -.4667D-01, -.2393D-02, -.2393D-02,  .2167D-01,
     +   .4768D+00,  .4692D-01,  .2969D+00,
     +   .2529D+00, -.4320D-01, -.2127D-02, -.2127D-02,  .1939D-01,
     +   .4789D+00,  .5120D-01,  .3001D+00,
     +   .2393D+00, -.4037D-01, -.1918D-02, -.1918D-02,  .1765D-01,
     +   .4806D+00,  .5481D-01,  .3028D+00,
     +   .2283D+00, -.3810D-01, -.1758D-02, -.1758D-02,  .1634D-01,
     +   .4820D+00,  .5777D-01,  .3050D+00,
     +   .2160D+00, -.3561D-01, -.1588D-02, -.1588D-02,  .1498D-01,
     +   .4838D+00,  .6117D-01,  .3077D+00,
     +   .2056D+00, -.3357D-01, -.1453D-02, -.1453D-02,  .1390D-01,
     +   .4851D+00,  .6402D-01,  .3098D+00,
     +   .1963D+00, -.3174D-01, -.1336D-02, -.1336D-02,  .1297D-01,
     +   .4861D+00,  .6664D-01,  .3116D+00 /
        DATA ((PARTON(I,N,31),I=1,8),N=17,25)/
     +   .1881D+00, -.3017D-01, -.1239D-02, -.1239D-02,  .1219D-01,
     +   .4870D+00,  .6895D-01,  .3133D+00,
     +   .1784D+00, -.2832D-01, -.1128D-02, -.1128D-02,  .1130D-01,
     +   .4881D+00,  .7178D-01,  .3153D+00,
     +   .1697D+00, -.2671D-01, -.1034D-02, -.1034D-02,  .1054D-01,
     +   .4891D+00,  .7433D-01,  .3171D+00,
     +   .1617D+00, -.2521D-01, -.9498D-03, -.9498D-03,  .9856D-02,
     +   .4901D+00,  .7678D-01,  .3188D+00,
     +   .1549D+00, -.2398D-01, -.8821D-03, -.8821D-03,  .9298D-02,
     +   .4909D+00,  .7888D-01,  .3204D+00,
     +   .1482D+00, -.2277D-01, -.8175D-03, -.8175D-03,  .8759D-02,
     +   .4919D+00,  .8102D-01,  .3219D+00,
     +   .1422D+00, -.2169D-01, -.7614D-03, -.7614D-03,  .8286D-02,
     +   .4928D+00,  .8300D-01,  .3234D+00,
     +   .1364D+00, -.2068D-01, -.7097D-03, -.7097D-03,  .7844D-02,
     +   .4938D+00,  .8493D-01,  .3249D+00,
     +   .1316D+00, -.1983D-01, -.6672D-03, -.6672D-03,  .7477D-02,
     +   .4947D+00,  .8661D-01,  .3263D+00 /
        DATA ((PARTON(I,N,32),I=1,8),N=1,8)/
     +   .3742D+00, -.6511D-01, -.3392D-02, -.3392D-02,  .3258D-01,
     +   .4808D+00,  .4719D-01,  .3010D+00,
     +   .3521D+00, -.6018D-01, -.3001D-02, -.3001D-02,  .2791D-01,
     +   .4839D+00,  .5237D-01,  .3052D+00,
     +   .3361D+00, -.5670D-01, -.2737D-02, -.2737D-02,  .2505D-01,
     +   .4860D+00,  .5609D-01,  .3081D+00,
     +   .3185D+00, -.5297D-01, -.2467D-02, -.2467D-02,  .2233D-01,
     +   .4882D+00,  .6013D-01,  .3112D+00,
     +   .2986D+00, -.4886D-01, -.2182D-02, -.2182D-02,  .1966D-01,
     +   .4905D+00,  .6470D-01,  .3146D+00,
     +   .2849D+00, -.4610D-01, -.1999D-02, -.1999D-02,  .1805D-01,
     +   .4921D+00,  .6785D-01,  .3169D+00,
     +   .2747D+00, -.4407D-01, -.1869D-02, -.1869D-02,  .1694D-01,
     +   .4932D+00,  .7020D-01,  .3186D+00,
     +   .2601D+00, -.4123D-01, -.1691D-02, -.1691D-02,  .1547D-01,
     +   .4949D+00,  .7359D-01,  .3211D+00 /
        DATA ((PARTON(I,N,32),I=1,8),N=9,16)/
     +   .2500D+00, -.3928D-01, -.1573D-02, -.1573D-02,  .1453D-01,
     +   .4962D+00,  .7601D-01,  .3230D+00,
     +   .2310D+00, -.3569D-01, -.1365D-02, -.1365D-02,  .1288D-01,
     +   .4983D+00,  .8054D-01,  .3262D+00,
     +   .2147D+00, -.3270D-01, -.1200D-02, -.1200D-02,  .1159D-01,
     +   .5000D+00,  .8449D-01,  .3289D+00,
     +   .2012D+00, -.3027D-01, -.1071D-02, -.1071D-02,  .1059D-01,
     +   .5013D+00,  .8784D-01,  .3312D+00,
     +   .1904D+00, -.2836D-01, -.9736D-03, -.9736D-03,  .9828D-02,
     +   .5025D+00,  .9061D-01,  .3331D+00,
     +   .1785D+00, -.2628D-01, -.8710D-03, -.8710D-03,  .9016D-02,
     +   .5042D+00,  .9383D-01,  .3355D+00,
     +   .1686D+00, -.2458D-01, -.7903D-03, -.7903D-03,  .8367D-02,
     +   .5052D+00,  .9650D-01,  .3373D+00,
     +   .1597D+00, -.2308D-01, -.7210D-03, -.7210D-03,  .7801D-02,
     +   .5061D+00,  .9897D-01,  .3390D+00 /
        DATA ((PARTON(I,N,32),I=1,8),N=17,25)/
     +   .1521D+00, -.2180D-01, -.6638D-03, -.6638D-03,  .7325D-02,
     +   .5068D+00,  .1012D+00,  .3404D+00,
     +   .1430D+00, -.2030D-01, -.5987D-03, -.5987D-03,  .6774D-02,
     +   .5077D+00,  .1038D+00,  .3422D+00,
     +   .1351D+00, -.1901D-01, -.5444D-03, -.5444D-03,  .6303D-02,
     +   .5086D+00,  .1062D+00,  .3438D+00,
     +   .1278D+00, -.1782D-01, -.4960D-03, -.4960D-03,  .5874D-02,
     +   .5094D+00,  .1086D+00,  .3453D+00,
     +   .1217D+00, -.1685D-01, -.4574D-03, -.4574D-03,  .5525D-02,
     +   .5101D+00,  .1106D+00,  .3467D+00,
     +   .1157D+00, -.1590D-01, -.4208D-03, -.4208D-03,  .5188D-02,
     +   .5109D+00,  .1127D+00,  .3481D+00,
     +   .1103D+00, -.1507D-01, -.3893D-03, -.3893D-03,  .4891D-02,
     +   .5117D+00,  .1146D+00,  .3495D+00,
     +   .1052D+00, -.1428D-01, -.3604D-03, -.3604D-03,  .4614D-02,
     +   .5125D+00,  .1164D+00,  .3508D+00,
     +   .1010D+00, -.1363D-01, -.3369D-03, -.3369D-03,  .4384D-02,
     +   .5132D+00,  .1181D+00,  .3520D+00 /
        DATA ((PARTON(I,N,33),I=1,8),N=1,8)/
     +   .3344D+00, -.5141D-01, -.1931D-02, -.1931D-02,  .1694D-01,
     +   .5030D+00,  .8407D-01,  .3318D+00,
     +   .3108D+00, -.4700D-01, -.1691D-02, -.1691D-02,  .1486D-01,
     +   .5053D+00,  .8877D-01,  .3352D+00,
     +   .2941D+00, -.4391D-01, -.1530D-02, -.1530D-02,  .1357D-01,
     +   .5069D+00,  .9214D-01,  .3376D+00,
     +   .2759D+00, -.4065D-01, -.1367D-02, -.1367D-02,  .1232D-01,
     +   .5084D+00,  .9580D-01,  .3401D+00,
     +   .2557D+00, -.3709D-01, -.1196D-02, -.1196D-02,  .1106D-01,
     +   .5102D+00,  .9994D-01,  .3428D+00,
     +   .2420D+00, -.3473D-01, -.1087D-02, -.1087D-02,  .1027D-01,
     +   .5113D+00,  .1028D+00,  .3447D+00,
     +   .2319D+00, -.3301D-01, -.1010D-02, -.1010D-02,  .9716D-02,
     +   .5122D+00,  .1049D+00,  .3462D+00,
     +   .2176D+00, -.3061D-01, -.9060D-03, -.9060D-03,  .8962D-02,
     +   .5135D+00,  .1080D+00,  .3482D+00 /
        DATA ((PARTON(I,N,33),I=1,8),N=9,16)/
     +   .2078D+00, -.2899D-01, -.8375D-03, -.8376D-03,  .8461D-02,
     +   .5146D+00,  .1103D+00,  .3498D+00,
     +   .1896D+00, -.2603D-01, -.7174D-03, -.7174D-03,  .7565D-02,
     +   .5163D+00,  .1144D+00,  .3525D+00,
     +   .1742D+00, -.2360D-01, -.6229D-03, -.6229D-03,  .6836D-02,
     +   .5177D+00,  .1181D+00,  .3549D+00,
     +   .1617D+00, -.2165D-01, -.5505D-03, -.5505D-03,  .6257D-02,
     +   .5188D+00,  .1211D+00,  .3569D+00,
     +   .1518D+00, -.2012D-01, -.4958D-03, -.4958D-03,  .5804D-02,
     +   .5198D+00,  .1237D+00,  .3585D+00,
     +   .1410D+00, -.1848D-01, -.4390D-03, -.4390D-03,  .5318D-02,
     +   .5214D+00,  .1268D+00,  .3608D+00,
     +   .1321D+00, -.1716D-01, -.3948D-03, -.3948D-03,  .4925D-02,
     +   .5223D+00,  .1293D+00,  .3624D+00,
     +   .1242D+00, -.1599D-01, -.3571D-03, -.3571D-03,  .4579D-02,
     +   .5231D+00,  .1316D+00,  .3639D+00 /
        DATA ((PARTON(I,N,33),I=1,8),N=17,25)/
     +   .1175D+00, -.1501D-01, -.3262D-03, -.3262D-03,  .4288D-02,
     +   .5238D+00,  .1337D+00,  .3652D+00,
     +   .1096D+00, -.1387D-01, -.2915D-03, -.2915D-03,  .3949D-02,
     +   .5246D+00,  .1362D+00,  .3667D+00,
     +   .1028D+00, -.1289D-01, -.2627D-03, -.2627D-03,  .3658D-02,
     +   .5254D+00,  .1385D+00,  .3682D+00,
     +   .9645D-01, -.1200D-01, -.2373D-03, -.2373D-03,  .3394D-02,
     +   .5262D+00,  .1408D+00,  .3696D+00,
     +   .9127D-01, -.1128D-01, -.2172D-03, -.2172D-03,  .3179D-02,
     +   .5269D+00,  .1427D+00,  .3709D+00,
     +   .8622D-01, -.1058D-01, -.1983D-03, -.1983D-03,  .2971D-02,
     +   .5276D+00,  .1447D+00,  .3722D+00,
     +   .8174D-01, -.9968D-02, -.1821D-03, -.1821D-03,  .2789D-02,
     +   .5283D+00,  .1465D+00,  .3734D+00,
     +   .7754D-01, -.9396D-02, -.1674D-03, -.1674D-03,  .2620D-02,
     +   .5291D+00,  .1484D+00,  .3747D+00,
     +   .7402D-01, -.8921D-02, -.1555D-03, -.1555D-03,  .2479D-02,
     +   .5297D+00,  .1499D+00,  .3757D+00 /
        DATA ((PARTON(I,N,34),I=1,8),N=1,8)/
     +   .2848D+00, -.3857D-01, -.1007D-02, -.1007D-02,  .8444D-02,
     +   .5219D+00,  .1210D+00,  .3596D+00,
     +   .2616D+00, -.3485D-01, -.8724D-03, -.8724D-03,  .7716D-02,
     +   .5236D+00,  .1252D+00,  .3623D+00,
     +   .2452D+00, -.3229D-01, -.7831D-03, -.7831D-03,  .7228D-02,
     +   .5246D+00,  .1283D+00,  .3642D+00,
     +   .2278D+00, -.2961D-01, -.6926D-03, -.6926D-03,  .6717D-02,
     +   .5257D+00,  .1316D+00,  .3662D+00,
     +   .2086D+00, -.2672D-01, -.5991D-03, -.5991D-03,  .6160D-02,
     +   .5269D+00,  .1353D+00,  .3685D+00,
     +   .1958D+00, -.2483D-01, -.5399D-03, -.5399D-03,  .5786D-02,
     +   .5278D+00,  .1379D+00,  .3700D+00,
     +   .1864D+00, -.2346D-01, -.4984D-03, -.4984D-03,  .5510D-02,
     +   .5284D+00,  .1398D+00,  .3712D+00,
     +   .1733D+00, -.2157D-01, -.4426D-03, -.4426D-03,  .5119D-02,
     +   .5294D+00,  .1426D+00,  .3729D+00 /
        DATA ((PARTON(I,N,34),I=1,8),N=9,16)/
     +   .1644D+00, -.2030D-01, -.4063D-03, -.4063D-03,  .4851D-02,
     +   .5304D+00,  .1447D+00,  .3743D+00,
     +   .1481D+00, -.1801D-01, -.3431D-03, -.3431D-03,  .4352D-02,
     +   .5318D+00,  .1485D+00,  .3766D+00,
     +   .1346D+00, -.1614D-01, -.2941D-03, -.2941D-03,  .3933D-02,
     +   .5329D+00,  .1519D+00,  .3786D+00,
     +   .1237D+00, -.1467D-01, -.2570D-03, -.2570D-03,  .3592D-02,
     +   .5339D+00,  .1547D+00,  .3803D+00,
     +   .1152D+00, -.1353D-01, -.2293D-03, -.2293D-03,  .3323D-02,
     +   .5348D+00,  .1571D+00,  .3818D+00,
     +   .1059D+00, -.1231D-01, -.2008D-03, -.2008D-03,  .3032D-02,
     +   .5364D+00,  .1600D+00,  .3840D+00,
     +   .9846D-01, -.1134D-01, -.1788D-03, -.1788D-03,  .2795D-02,
     +   .5373D+00,  .1624D+00,  .3854D+00,
     +   .9188D-01, -.1049D-01, -.1602D-03, -.1602D-03,  .2587D-02,
     +   .5381D+00,  .1646D+00,  .3868D+00 /
        DATA ((PARTON(I,N,34),I=1,8),N=17,25)/
     +   .8631D-01, -.9785D-02, -.1452D-03, -.1452D-03,  .2411D-02,
     +   .5387D+00,  .1666D+00,  .3880D+00,
     +   .7983D-01, -.8969D-02, -.1284D-03, -.1284D-03,  .2207D-02,
     +   .5396D+00,  .1690D+00,  .3895D+00,
     +   .7427D-01, -.8275D-02, -.1146D-03, -.1146D-03,  .2033D-02,
     +   .5403D+00,  .1712D+00,  .3909D+00,
     +   .6919D-01, -.7650D-02, -.1025D-03, -.1025D-03,  .1875D-02,
     +   .5411D+00,  .1734D+00,  .3922D+00,
     +   .6506D-01, -.7144D-02, -.9307D-04, -.9307D-04,  .1747D-02,
     +   .5419D+00,  .1753D+00,  .3935D+00,
     +   .6105D-01, -.6659D-02, -.8425D-04, -.8425D-04,  .1624D-02,
     +   .5426D+00,  .1772D+00,  .3947D+00,
     +   .5753D-01, -.6235D-02, -.7676D-04, -.7677D-04,  .1517D-02,
     +   .5434D+00,  .1790D+00,  .3959D+00,
     +   .5425D-01, -.5844D-02, -.7001D-04, -.7001D-04,  .1417D-02,
     +   .5441D+00,  .1808D+00,  .3971D+00,
     +   .5152D-01, -.5520D-02, -.6457D-04, -.6457D-04,  .1335D-02,
     +   .5448D+00,  .1824D+00,  .3981D+00 /
        DATA ((PARTON(I,N,35),I=1,8),N=1,8)/
     +   .2300D+00, -.2727D-01, -.4743D-03, -.4743D-03,  .4145D-02,
     +   .5384D+00,  .1581D+00,  .3850D+00,
     +   .2086D+00, -.2435D-01, -.4059D-03, -.4059D-03,  .3978D-02,
     +   .5395D+00,  .1620D+00,  .3873D+00,
     +   .1937D+00, -.2237D-01, -.3609D-03, -.3609D-03,  .3825D-02,
     +   .5402D+00,  .1647D+00,  .3888D+00,
     +   .1781D+00, -.2031D-01, -.3158D-03, -.3158D-03,  .3630D-02,
     +   .5409D+00,  .1677D+00,  .3903D+00,
     +   .1611D+00, -.1812D-01, -.2696D-03, -.2696D-03,  .3382D-02,
     +   .5417D+00,  .1710D+00,  .3921D+00,
     +   .1500D+00, -.1670D-01, -.2408D-03, -.2408D-03,  .3199D-02,
     +   .5422D+00,  .1734D+00,  .3933D+00,
     +   .1419D+00, -.1568D-01, -.2206D-03, -.2206D-03,  .3056D-02,
     +   .5427D+00,  .1751D+00,  .3943D+00,
     +   .1306D+00, -.1428D-01, -.1938D-03, -.1938D-03,  .2846D-02,
     +   .5435D+00,  .1777D+00,  .3957D+00 /
        DATA ((PARTON(I,N,35),I=1,8),N=9,16)/
     +   .1231D+00, -.1336D-01, -.1765D-03, -.1765D-03,  .2696D-02,
     +   .5444D+00,  .1796D+00,  .3970D+00,
     +   .1094D+00, -.1170D-01, -.1468D-03, -.1468D-03,  .2413D-02,
     +   .5455D+00,  .1831D+00,  .3990D+00,
     +   .9823D-01, -.1037D-01, -.1241D-03, -.1241D-03,  .2169D-02,
     +   .5464D+00,  .1862D+00,  .4007D+00,
     +   .8938D-01, -.9332D-02, -.1071D-03, -.1071D-03,  .1970D-02,
     +   .5473D+00,  .1888D+00,  .4022D+00,
     +   .8249D-01, -.8535D-02, -.9450D-04, -.9450D-04,  .1812D-02,
     +   .5481D+00,  .1911D+00,  .4035D+00,
     +   .7514D-01, -.7695D-02, -.8172D-04, -.8172D-04,  .1642D-02,
     +   .5498D+00,  .1939D+00,  .4056D+00,
     +   .6925D-01, -.7030D-02, -.7199D-04, -.7199D-04,  .1504D-02,
     +   .5506D+00,  .1962D+00,  .4070D+00,
     +   .6410D-01, -.6455D-02, -.6386D-04, -.6386D-04,  .1383D-02,
     +   .5514D+00,  .1983D+00,  .4083D+00 /
        DATA ((PARTON(I,N,35),I=1,8),N=17,25)/
     +   .5979D-01, -.5977D-02, -.5731D-04, -.5731D-04,  .1281D-02,
     +   .5521D+00,  .2001D+00,  .4094D+00,
     +   .5482D-01, -.5432D-02, -.5008D-04, -.5008D-04,  .1164D-02,
     +   .5530D+00,  .2025D+00,  .4109D+00,
     +   .5059D-01, -.4974D-02, -.4422D-04, -.4422D-04,  .1064D-02,
     +   .5539D+00,  .2046D+00,  .4122D+00,
     +   .4677D-01, -.4563D-02, -.3913D-04, -.3913D-04,  .9749D-03,
     +   .5548D+00,  .2068D+00,  .4136D+00,
     +   .4368D-01, -.4234D-02, -.3519D-04, -.3519D-04,  .9028D-03,
     +   .5556D+00,  .2087D+00,  .4148D+00,
     +   .4071D-01, -.3920D-02, -.3154D-04, -.3154D-04,  .8339D-03,
     +   .5565D+00,  .2106D+00,  .4161D+00,
     +   .3812D-01, -.3648D-02, -.2847D-04, -.2847D-04,  .7740D-03,
     +   .5573D+00,  .2124D+00,  .4173D+00,
     +   .3572D-01, -.3398D-02, -.2572D-04, -.2572D-04,  .7189D-03,
     +   .5581D+00,  .2141D+00,  .4185D+00,
     +   .3374D-01, -.3193D-02, -.2352D-04, -.2352D-04,  .6736D-03,
     +   .5588D+00,  .2157D+00,  .4195D+00 /
        DATA ((PARTON(I,N,36),I=1,8),N=1,8)/
     +   .1746D+00, -.1796D-01, -.1970D-03, -.1970D-03,  .2037D-02,
     +   .5530D+00,  .1959D+00,  .4088D+00,
     +   .1562D+00, -.1584D-01, -.1663D-03, -.1663D-03,  .2038D-02,
     +   .5537D+00,  .1994D+00,  .4106D+00,
     +   .1437D+00, -.1441D-01, -.1463D-03, -.1463D-03,  .1995D-02,
     +   .5541D+00,  .2019D+00,  .4118D+00,
     +   .1306D+00, -.1295D-01, -.1265D-03, -.1265D-03,  .1916D-02,
     +   .5545D+00,  .2046D+00,  .4130D+00,
     +   .1167D+00, -.1141D-01, -.1064D-03, -.1064D-03,  .1795D-02,
     +   .5550D+00,  .2077D+00,  .4144D+00,
     +   .1076D+00, -.1043D-01, -.9405D-04, -.9405D-04,  .1698D-02,
     +   .5554D+00,  .2098D+00,  .4154D+00,
     +   .1011D+00, -.9729D-02, -.8548D-04, -.8548D-04,  .1620D-02,
     +   .5557D+00,  .2114D+00,  .4162D+00,
     +   .9220D-01, -.8779D-02, -.7418D-04, -.7418D-04,  .1504D-02,
     +   .5563D+00,  .2137D+00,  .4174D+00 /
        DATA ((PARTON(I,N,36),I=1,8),N=9,16)/
     +   .8625D-01, -.8152D-02, -.6696D-04, -.6696D-04,  .1420D-02,
     +   .5571D+00,  .2155D+00,  .4185D+00,
     +   .7559D-01, -.7045D-02, -.5471D-04, -.5470D-04,  .1259D-02,
     +   .5580D+00,  .2187D+00,  .4202D+00,
     +   .6703D-01, -.6170D-02, -.4548D-04, -.4548D-04,  .1121D-02,
     +   .5588D+00,  .2215D+00,  .4217D+00,
     +   .6033D-01, -.5495D-02, -.3868D-04, -.3868D-04,  .1009D-02,
     +   .5596D+00,  .2240D+00,  .4230D+00,
     +   .5517D-01, -.4982D-02, -.3372D-04, -.3372D-04,  .9211D-03,
     +   .5603D+00,  .2261D+00,  .4242D+00,
     +   .4973D-01, -.4446D-02, -.2873D-04, -.2873D-04,  .8265D-03,
     +   .5621D+00,  .2289D+00,  .4263D+00,
     +   .4542D-01, -.4026D-02, -.2498D-04, -.2498D-04,  .7508D-03,
     +   .5629D+00,  .2310D+00,  .4276D+00,
     +   .4170D-01, -.3667D-02, -.2189D-04, -.2189D-04,  .6850D-03,
     +   .5638D+00,  .2331D+00,  .4288D+00 /
        DATA ((PARTON(I,N,36),I=1,8),N=17,25)/
     +   .3860D-01, -.3371D-02, -.1942D-04, -.1942D-04,  .6302D-03,
     +   .5645D+00,  .2349D+00,  .4299D+00,
     +   .3506D-01, -.3036D-02, -.1673D-04, -.1672D-04,  .5675D-03,
     +   .5655D+00,  .2371D+00,  .4313D+00,
     +   .3208D-01, -.2757D-02, -.1457D-04, -.1457D-04,  .5147D-03,
     +   .5664D+00,  .2393D+00,  .4327D+00,
     +   .2942D-01, -.2509D-02, -.1272D-04, -.1272D-04,  .4677D-03,
     +   .5675D+00,  .2414D+00,  .4341D+00,
     +   .2728D-01, -.2312D-02, -.1129D-04, -.1130D-04,  .4301D-03,
     +   .5684D+00,  .2433D+00,  .4353D+00,
     +   .2524D-01, -.2125D-02, -.9996D-05, -.9993D-05,  .3944D-03,
     +   .5694D+00,  .2452D+00,  .4367D+00,
     +   .2347D-01, -.1965D-02, -.8907D-05, -.8910D-05,  .3636D-03,
     +   .5703D+00,  .2470D+00,  .4379D+00,
     +   .2185D-01, -.1818D-02, -.7946D-05, -.7948D-05,  .3355D-03,
     +   .5713D+00,  .2488D+00,  .4391D+00,
     +   .2052D-01, -.1699D-02, -.7186D-05, -.7184D-05,  .3125D-03,
     +   .5720D+00,  .2503D+00,  .4401D+00 /
        DATA ((PARTON(I,N,37),I=1,8),N=1,8)/
     +   .1227D+00, -.1082D-01, -.6974D-04, -.6974D-04,  .9876D-03,
     +   .5663D+00,  .2351D+00,  .4314D+00,
     +   .1083D+00, -.9415D-02, -.5794D-04, -.5794D-04,  .1010D-02,
     +   .5668D+00,  .2384D+00,  .4329D+00,
     +   .9856D-01, -.8482D-02, -.5035D-04, -.5035D-04,  .9945D-03,
     +   .5671D+00,  .2407D+00,  .4339D+00,
     +   .8856D-01, -.7535D-02, -.4291D-04, -.4291D-04,  .9552D-03,
     +   .5673D+00,  .2432D+00,  .4349D+00,
     +   .7804D-01, -.6555D-02, -.3549D-04, -.3549D-04,  .8905D-03,
     +   .5676D+00,  .2459D+00,  .4360D+00,
     +   .7128D-01, -.5933D-02, -.3097D-04, -.3097D-04,  .8375D-03,
     +   .5678D+00,  .2478D+00,  .4368D+00,
     +   .6648D-01, -.5495D-02, -.2787D-04, -.2787D-04,  .7950D-03,
     +   .5680D+00,  .2493D+00,  .4374D+00,
     +   .5995D-01, -.4907D-02, -.2383D-04, -.2383D-04,  .7313D-03,
     +   .5685D+00,  .2514D+00,  .4384D+00 /
        DATA ((PARTON(I,N,37),I=1,8),N=9,16)/
     +   .5564D-01, -.4522D-02, -.2128D-04, -.2128D-04,  .6858D-03,
     +   .5692D+00,  .2532D+00,  .4395D+00,
     +   .4804D-01, -.3852D-02, -.1701D-04, -.1701D-04,  .5998D-03,
     +   .5700D+00,  .2561D+00,  .4409D+00,
     +   .4202D-01, -.3329D-02, -.1385D-04, -.1385D-04,  .5273D-03,
     +   .5706D+00,  .2587D+00,  .4422D+00,
     +   .3738D-01, -.2931D-02, -.1157D-04, -.1157D-04,  .4693D-03,
     +   .5713D+00,  .2610D+00,  .4433D+00,
     +   .3385D-01, -.2632D-02, -.9923D-05, -.9924D-05,  .4242D-03,
     +   .5720D+00,  .2630D+00,  .4445D+00,
     +   .3017D-01, -.2324D-02, -.8292D-05, -.8292D-05,  .3764D-03,
     +   .5737D+00,  .2657D+00,  .4465D+00,
     +   .2729D-01, -.2084D-02, -.7085D-05, -.7085D-05,  .3387D-03,
     +   .5746D+00,  .2677D+00,  .4477D+00,
     +   .2482D-01, -.1881D-02, -.6102D-05, -.6103D-05,  .3062D-03,
     +   .5754D+00,  .2697D+00,  .4488D+00 /
        DATA ((PARTON(I,N,37),I=1,8),N=17,25)/
     +   .2279D-01, -.1716D-02, -.5328D-05, -.5329D-05,  .2794D-03,
     +   .5762D+00,  .2714D+00,  .4499D+00,
     +   .2049D-01, -.1530D-02, -.4493D-05, -.4490D-05,  .2491D-03,
     +   .5772D+00,  .2736D+00,  .4513D+00,
     +   .1858D-01, -.1377D-02, -.3835D-05, -.3832D-05,  .2239D-03,
     +   .5782D+00,  .2757D+00,  .4527D+00,
     +   .1688D-01, -.1242D-02, -.3275D-05, -.3273D-05,  .2017D-03,
     +   .5794D+00,  .2778D+00,  .4541D+00,
     +   .1553D-01, -.1136D-02, -.2848D-05, -.2848D-05,  .1840D-03,
     +   .5804D+00,  .2797D+00,  .4554D+00,
     +   .1426D-01, -.1036D-02, -.2468D-05, -.2466D-05,  .1674D-03,
     +   .5816D+00,  .2816D+00,  .4567D+00,
     +   .1317D-01, -.9512D-03, -.2146D-05, -.2150D-05,  .1532D-03,
     +   .5827D+00,  .2835D+00,  .4580D+00,
     +   .1217D-01, -.8741D-03, -.1869D-05, -.1870D-05,  .1402D-03,
     +   .5837D+00,  .2852D+00,  .4593D+00,
     +   .1135D-01, -.8117D-03, -.1651D-05, -.1653D-05,  .1297D-03,
     +   .5846D+00,  .2868D+00,  .4603D+00 /
        DATA ((PARTON(I,N,38),I=1,8),N=1,8)/
     +   .7811D-01, -.5794D-02, -.1989D-04, -.1989D-04,  .4503D-03,
     +   .5788D+00,  .2767D+00,  .4534D+00,
     +   .6785D-01, -.4966D-02, -.1621D-04, -.1621D-04,  .4606D-03,
     +   .5793D+00,  .2798D+00,  .4548D+00,
     +   .6103D-01, -.4423D-02, -.1387D-04, -.1387D-04,  .4509D-03,
     +   .5795D+00,  .2820D+00,  .4557D+00,
     +   .5413D-01, -.3881D-02, -.1161D-04, -.1161D-04,  .4289D-03,
     +   .5797D+00,  .2843D+00,  .4565D+00,
     +   .4698D-01, -.3326D-02, -.9398D-05, -.9394D-05,  .3944D-03,
     +   .5799D+00,  .2868D+00,  .4575D+00,
     +   .4246D-01, -.2980D-02, -.8063D-05, -.8064D-05,  .3670D-03,
     +   .5800D+00,  .2886D+00,  .4582D+00,
     +   .3927D-01, -.2738D-02, -.7168D-05, -.7163D-05,  .3455D-03,
     +   .5802D+00,  .2900D+00,  .4587D+00,
     +   .3499D-01, -.2416D-02, -.6004D-05, -.6002D-05,  .3139D-03,
     +   .5806D+00,  .2920D+00,  .4596D+00 /
        DATA ((PARTON(I,N,38),I=1,8),N=9,16)/
     +   .3220D-01, -.2209D-02, -.5284D-05, -.5284D-05,  .2918D-03,
     +   .5813D+00,  .2936D+00,  .4606D+00,
     +   .2734D-01, -.1851D-02, -.4095D-05, -.4093D-05,  .2508D-03,
     +   .5819D+00,  .2963D+00,  .4618D+00,
     +   .2355D-01, -.1576D-02, -.3236D-05, -.3233D-05,  .2170D-03,
     +   .5824D+00,  .2987D+00,  .4628D+00,
     +   .2068D-01, -.1370D-02, -.2624D-05, -.2624D-05,  .1906D-03,
     +   .5829D+00,  .3008D+00,  .4638D+00,
     +   .1853D-01, -.1217D-02, -.2190D-05, -.2190D-05,  .1704D-03,
     +   .5835D+00,  .3026D+00,  .4648D+00,
     +   .1630D-01, -.1061D-02, -.1768D-05, -.1768D-05,  .1493D-03,
     +   .5853D+00,  .3053D+00,  .4667D+00,
     +   .1459D-01, -.9421D-03, -.1462D-05, -.1462D-05,  .1330D-03,
     +   .5861D+00,  .3073D+00,  .4678D+00,
     +   .1313D-01, -.8419D-03, -.1217D-05, -.1217D-05,  .1191D-03,
     +   .5868D+00,  .3091D+00,  .4689D+00 /
        DATA ((PARTON(I,N,38),I=1,8),N=17,25)/
     +   .1195D-01, -.7610D-03, -.1026D-05, -.1025D-05,  .1077D-03,
     +   .5875D+00,  .3107D+00,  .4698D+00,
     +   .1062D-01, -.6712D-03, -.8219D-06, -.8200D-06,  .9501D-04,
     +   .5885D+00,  .3128D+00,  .4711D+00,
     +   .9533D-02, -.5979D-03, -.6663D-06, -.6654D-06,  .8452D-04,
     +   .5896D+00,  .3149D+00,  .4724D+00,
     +   .8576D-02, -.5341D-03, -.5320D-06, -.5312D-06,  .7541D-04,
     +   .5908D+00,  .3169D+00,  .4738D+00,
     +   .7823D-02, -.4843D-03, -.4294D-06, -.4303D-06,  .6820D-04,
     +   .5919D+00,  .3188D+00,  .4751D+00,
     +   .7118D-02, -.4380D-03, -.3458D-06, -.3435D-06,  .6141D-04,
     +   .5931D+00,  .3207D+00,  .4765D+00,
     +   .6518D-02, -.3988D-03, -.2677D-06, -.2701D-06,  .5572D-04,
     +   .5943D+00,  .3225D+00,  .4779D+00,
     +   .5975D-02, -.3636D-03, -.2045D-06, -.2059D-06,  .5046D-04,
     +   .5955D+00,  .3243D+00,  .4791D+00,
     +   .5536D-02, -.3353D-03, -.1554D-06, -.1564D-06,  .4623D-04,
     +   .5964D+00,  .3258D+00,  .4802D+00 /
        DATA ((PARTON(I,N,39),I=1,8),N=1,8)/
     +   .4325D-01, -.2624D-02, -.4132D-05, -.4136D-05,  .1784D-03,
     +   .5908D+00,  .3219D+00,  .4754D+00,
     +   .3690D-01, -.2210D-02, -.3280D-05, -.3281D-05,  .1796D-03,
     +   .5917D+00,  .3251D+00,  .4770D+00,
     +   .3275D-01, -.1943D-02, -.2742D-05, -.2742D-05,  .1734D-03,
     +   .5921D+00,  .3273D+00,  .4779D+00,
     +   .2862D-01, -.1680D-02, -.2243D-05, -.2239D-05,  .1622D-03,
     +   .5924D+00,  .3295D+00,  .4788D+00,
     +   .2441D-01, -.1416D-02, -.1755D-05, -.1753D-05,  .1463D-03,
     +   .5926D+00,  .3320D+00,  .4797D+00,
     +   .2179D-01, -.1253D-02, -.1464D-05, -.1464D-05,  .1343D-03,
     +   .5928D+00,  .3337D+00,  .4803D+00,
     +   .1996D-01, -.1141D-02, -.1275D-05, -.1272D-05,  .1251D-03,
     +   .5930D+00,  .3350D+00,  .4808D+00,
     +   .1754D-01, -.9933D-03, -.1026D-05, -.1022D-05,  .1119D-03,
     +   .5934D+00,  .3369D+00,  .4816D+00 /
        DATA ((PARTON(I,N,39),I=1,8),N=9,16)/
     +   .1598D-01, -.8991D-03, -.8815D-06, -.8799D-06,  .1030D-03,
     +   .5941D+00,  .3385D+00,  .4826D+00,
     +   .1331D-01, -.7393D-03, -.6381D-06, -.6332D-06,  .8676D-04,
     +   .5945D+00,  .3410D+00,  .4836D+00,
     +   .1127D-01, -.6189D-03, -.4653D-06, -.4595D-06,  .7382D-04,
     +   .5948D+00,  .3431D+00,  .4844D+00,
     +   .9746D-02, -.5302D-03, -.3425D-06, -.3423D-06,  .6393D-04,
     +   .5951D+00,  .3450D+00,  .4851D+00,
     +   .8621D-02, -.4653D-03, -.2586D-06, -.2573D-06,  .5650D-04,
     +   .5955D+00,  .3466D+00,  .4859D+00,
     +   .7477D-02, -.3999D-03, -.1767D-06, -.1749D-06,  .4892D-04,
     +   .5972D+00,  .3492D+00,  .4877D+00,
     +   .6606D-02, -.3506D-03, -.1190D-06, -.1185D-06,  .4315D-04,
     +   .5978D+00,  .3509D+00,  .4886D+00,
     +   .5877D-02, -.3097D-03, -.7662D-07, -.7509D-07,  .3827D-04,
     +   .5983D+00,  .3525D+00,  .4894D+00 /
        DATA ((PARTON(I,N,39),I=1,8),N=17,25)/
     +   .5291D-02, -.2770D-03, -.3980D-07, -.3882D-07,  .3434D-04,
     +   .5988D+00,  .3540D+00,  .4902D+00,
     +   .4643D-02, -.2412D-03, -.4526D-08,  .3801D-09,  .3001D-04,
     +   .5996D+00,  .3559D+00,  .4913D+00,
     +   .4117D-02, -.2124D-03,  .2466D-07,  .2722D-07,  .2642D-04,
     +   .6006D+00,  .3578D+00,  .4924D+00,
     +   .3661D-02, -.1876D-03,  .5351D-07,  .5384D-07,  .2333D-04,
     +   .6016D+00,  .3597D+00,  .4936D+00,
     +   .3306D-02, -.1684D-03,  .7430D-07,  .7430D-07,  .2084D-04,
     +   .6027D+00,  .3614D+00,  .4948D+00,
     +   .2977D-02, -.1508D-03,  .8631D-07,  .8726D-07,  .1857D-04,
     +   .6039D+00,  .3633D+00,  .4961D+00,
     +   .2700D-02, -.1360D-03,  .1075D-06,  .1052D-06,  .1664D-04,
     +   .6051D+00,  .3650D+00,  .4974D+00,
     +   .2452D-02, -.1229D-03,  .1203D-06,  .1166D-06,  .1474D-04,
     +   .6062D+00,  .3667D+00,  .4986D+00,
     +   .2254D-02, -.1124D-03,  .1292D-06,  .1292D-06,  .1326D-04,
     +   .6072D+00,  .3682D+00,  .4997D+00 /
        DATA ((PARTON(I,N,40),I=1,8),N=1,8)/
     +   .1932D-01, -.9151D-03, -.4940D-06, -.4933D-06,  .5512D-04,
     +   .6029D+00,  .3729D+00,  .4982D+00,
     +   .1613D-01, -.7545D-03, -.3724D-06, -.3697D-06,  .5409D-04,
     +   .6046D+00,  .3765D+00,  .5003D+00,
     +   .1409D-01, -.6531D-03, -.2868D-06, -.2872D-06,  .5122D-04,
     +   .6054D+00,  .3789D+00,  .5015D+00,
     +   .1209D-01, -.5547D-03, -.2252D-06, -.2234D-06,  .4696D-04,
     +   .6062D+00,  .3813D+00,  .5027D+00,
     +   .1009D-01, -.4579D-03, -.1632D-06, -.1579D-06,  .4131D-04,
     +   .6068D+00,  .3838D+00,  .5038D+00,
     +   .8873D-02, -.3993D-03, -.1170D-06, -.1187D-06,  .3733D-04,
     +   .6071D+00,  .3855D+00,  .5045D+00,
     +   .8037D-02, -.3595D-03, -.9242D-07, -.8993D-07,  .3441D-04,
     +   .6074D+00,  .3868D+00,  .5050D+00,
     +   .6944D-02, -.3078D-03, -.5658D-07, -.5049D-07,  .3031D-04,
     +   .6078D+00,  .3886D+00,  .5058D+00 /
        DATA ((PARTON(I,N,40),I=1,8),N=9,16)/
     +   .6251D-02, -.2754D-03, -.3802D-07, -.3723D-07,  .2757D-04,
     +   .6087D+00,  .3903D+00,  .5068D+00,
     +   .5083D-02, -.2212D-03, -.2010D-08,  .2555D-08,  .2283D-04,
     +   .6089D+00,  .3925D+00,  .5076D+00,
     +   .4213D-02, -.1814D-03,  .2554D-07,  .2718D-07,  .1921D-04,
     +   .6088D+00,  .3943D+00,  .5080D+00,
     +   .3577D-02, -.1526D-03,  .4543D-07,  .4702D-07,  .1650D-04,
     +   .6088D+00,  .3958D+00,  .5084D+00,
     +   .3116D-02, -.1319D-03,  .5741D-07,  .6037D-07,  .1451D-04,
     +   .6088D+00,  .3971D+00,  .5088D+00,
     +   .2654D-02, -.1114D-03,  .7468D-07,  .7627D-07,  .1252D-04,
     +   .6102D+00,  .3994D+00,  .5103D+00,
     +   .2309D-02, -.9623D-04,  .8651D-07,  .8565D-07,  .1107D-04,
     +   .6103D+00,  .4007D+00,  .5107D+00,
     +   .2025D-02, -.8381D-04,  .9233D-07,  .9255D-07,  .9820D-05,
     +   .6103D+00,  .4019D+00,  .5111D+00 /
        DATA ((PARTON(I,N,40),I=1,8),N=17,25)/
     +   .1799D-02, -.7403D-04,  .1004D-06,  .1028D-06,  .8829D-05,
     +   .6104D+00,  .4030D+00,  .5114D+00,
     +   .1554D-02, -.6346D-04,  .1111D-06,  .1142D-06,  .7700D-05,
     +   .6107D+00,  .4045D+00,  .5120D+00,
     +   .1358D-02, -.5509D-04,  .1149D-06,  .1180D-06,  .6710D-05,
     +   .6111D+00,  .4059D+00,  .5127D+00,
     +   .1190D-02, -.4798D-04,  .1245D-06,  .1267D-06,  .5909D-05,
     +   .6117D+00,  .4075D+00,  .5134D+00,
     +   .1061D-02, -.4255D-04,  .1353D-06,  .1339D-06,  .5211D-05,
     +   .6124D+00,  .4090D+00,  .5143D+00,
     +   .9438D-03, -.3764D-04,  .1368D-06,  .1369D-06,  .4551D-05,
     +   .6132D+00,  .4105D+00,  .5153D+00,
     +   .8460D-03, -.3357D-04,  .1470D-06,  .1434D-06,  .3954D-05,
     +   .6141D+00,  .4121D+00,  .5163D+00,
     +   .7595D-03, -.3000D-04,  .1524D-06,  .1506D-06,  .3254D-05,
     +   .6150D+00,  .4136D+00,  .5172D+00,
     +   .6910D-03, -.2717D-04,  .1566D-06,  .1557D-06,  .2720D-05,
     +   .6157D+00,  .4149D+00,  .5180D+00 /
        DATA ((PARTON(I,N,41),I=1,8),N=1,8)/
     +   .5865D-02, -.1992D-03,  .2334D-07,  .2024D-07,  .1183D-04,
     +   .6155D+00,  .4330D+00,  .5226D+00,
     +   .4756D-02, -.1596D-03,  .1924D-07,  .2505D-07,  .1126D-04,
     +   .6187D+00,  .4376D+00,  .5259D+00,
     +   .4065D-02, -.1353D-03,  .3120D-07,  .3251D-07,  .1043D-04,
     +   .6205D+00,  .4406D+00,  .5279D+00,
     +   .3405D-02, -.1122D-03,  .2532D-07,  .2832D-07,  .9470D-05,
     +   .6222D+00,  .4435D+00,  .5297D+00,
     +   .2763D-02, -.9012D-04,  .2882D-07,  .3213D-07,  .8157D-05,
     +   .6236D+00,  .4465D+00,  .5315D+00,
     +   .2381D-02, -.7708D-04,  .3763D-07,  .3649D-07,  .7249D-05,
     +   .6244D+00,  .4483D+00,  .5324D+00,
     +   .2124D-02, -.6836D-04,  .3270D-07,  .4077D-07,  .6623D-05,
     +   .6248D+00,  .4496D+00,  .5331D+00,
     +   .1794D-02, -.5727D-04,  .4879D-07,  .5026D-07,  .5872D-05,
     +   .6255D+00,  .4515D+00,  .5340D+00 /
        DATA ((PARTON(I,N,41),I=1,8),N=9,16)/
     +   .1589D-02, -.5042D-04,  .4661D-07,  .4841D-07,  .5355D-05,
     +   .6264D+00,  .4532D+00,  .5350D+00,
     +   .1252D-02, -.3930D-04,  .5427D-07,  .6018D-07,  .4549D-05,
     +   .6264D+00,  .4550D+00,  .5354D+00,
     +   .1008D-02, -.3136D-04,  .6714D-07,  .7022D-07,  .3921D-05,
     +   .6257D+00,  .4561D+00,  .5353D+00,
     +   .8348D-03, -.2576D-04,  .7637D-07,  .7873D-07,  .3544D-05,
     +   .6248D+00,  .4569D+00,  .5348D+00,
     +   .7121D-03, -.2183D-04,  .8373D-07,  .8506D-07,  .3297D-05,
     +   .6241D+00,  .4576D+00,  .5345D+00,
     +   .5921D-03, -.1802D-04,  .9393D-07,  .9558D-07,  .2956D-05,
     +   .6245D+00,  .4593D+00,  .5352D+00,
     +   .5043D-03, -.1526D-04,  .9917D-07,  .1008D-06,  .2775D-05,
     +   .6235D+00,  .4597D+00,  .5347D+00,
     +   .4336D-03, -.1306D-04,  .1028D-06,  .1028D-06,  .2620D-05,
     +   .6224D+00,  .4599D+00,  .5340D+00 /
        DATA ((PARTON(I,N,41),I=1,8),N=17,25)/
     +   .3785D-03, -.1135D-04,  .1108D-06,  .1107D-06,  .2428D-05,
     +   .6214D+00,  .4603D+00,  .5334D+00,
     +   .3198D-03, -.9543D-05,  .1170D-06,  .1205D-06,  .2229D-05,
     +   .6202D+00,  .4607D+00,  .5327D+00,
     +   .2737D-03, -.8139D-05,  .1204D-06,  .1218D-06,  .1988D-05,
     +   .6192D+00,  .4611D+00,  .5321D+00,
     +   .2353D-03, -.6961D-05,  .1286D-06,  .1314D-06,  .1788D-05,
     +   .6184D+00,  .4617D+00,  .5317D+00,
     +   .2063D-03, -.6084D-05,  .1393D-06,  .1378D-06,  .1545D-05,
     +   .6179D+00,  .4627D+00,  .5316D+00,
     +   .1802D-03, -.5295D-05,  .1381D-06,  .1400D-06,  .1292D-05,
     +   .6176D+00,  .4635D+00,  .5315D+00,
     +   .1589D-03, -.4666D-05,  .1493D-06,  .1462D-06,  .9970D-06,
     +   .6172D+00,  .4644D+00,  .5315D+00,
     +   .1404D-03, -.4112D-05,  .1530D-06,  .1510D-06,  .6898D-06,
     +   .6171D+00,  .4656D+00,  .5317D+00,
     +   .1259D-03, -.3680D-05,  .1571D-06,  .1551D-06,  .3925D-06,
     +   .6168D+00,  .4665D+00,  .5316D+00 /
C
         X  = DX
         Q  = DQ
         Q2 = DQ*DQ
*...CHECK OF X AND Q2 VALUES : 
C       IF ( (X.LT.1.0D-4) .OR. (X.GT.1.0D0) ) THEN
C           WRITE(6,91) 
C  91       FORMAT (2X,'PARTON INTERPOLATION: X OUT OF RANGE')
C          GOTO 60
C       ENDIF
C       IF ( (Q2.LT.0.4D0) .OR. (Q2.GT.1.D4) ) THEN
C           WRITE(6,92) 
C  92       FORMAT (2X,'PARTON INTERPOLATION: Q2 OUT OF RANGE')
C          GOTO 60
C       ENDIF
C
*...INITIALIZATION :
*    SELECTION AND READING OF THE GRID :
*    FILE - NO. = 11 FOR NLO 'STANDARD' SCENARIO ( FIRST NUMBER IN THE 
*                                                  GRID: 1.040D-03 )     
*    FILE - NO. = 22 FOR NLO 'VALENCE'  SCENARIO ( FIRST NUMBER IN THE 
*                                                  GRID: 9.740D-04 )     
*    FILE - NO. = 33 FOR  LO 'STANDARD' SCENARIO ( FIRST NUMBER IN THE 
*                                                  GRID: 1.731D-03 )     
*    FILE - NO. = 44 FOR  LO 'VALENCE'  SCENARIO ( FIRST NUMBER IN THE 
*                                                  GRID: 1.846D-03 )     
      IF (IINI.NE.0) GOTO 16
C      IF (ISET.EQ.1) THEN
C       IIREAD=11       
C       OPEN(UNIT=11,FILE='stdnloa1.grid',STATUS='OLD')
C      ELSE IF (ISET.EQ.2) THEN
C       IIREAD=22
C       OPEN(UNIT=22,FILE='valnloa1.grid',STATUS='OLD')
C      ELSE IF (ISET.EQ.3) THEN
C       IIREAD=33       
C       OPEN(UNIT=33,FILE='stdloa1.grid',STATUS='OLD')
C      ELSE IF (ISET.EQ.4) THEN
C       IIREAD=44
C       OPEN(UNIT=44,FILE='valloa1.grid',STATUS='OLD')
C      ELSE
C        WRITE(6,93)
C  93    FORMAT (2X,'PARTON INTERPOLATION: ISET OUT OF RANGE')
C        GOTO 60
C      END IF
C
C       DO 15 M = 1, NX-1 
C       DO 15 N = 1, NQ
C       READ(IIREAD,90) PARTON(1,N,M), PARTON(2,N,M), PARTON(3,N,M), 
C     1                 PARTON(4,N,M), PARTON(5,N,M), PARTON(6,N,M),
C     2                 PARTON(7,N,M), PARTON(8,N,M)
C  90   FORMAT (8(1PE10.3))
C  15   CONTINUE
C
      IINI = 1
*....ARRAYS FOR THE INTERPOLATION SUBROUTINE :
      DO 10 IQ = 1, NQ
      DO 20 IX = 1, NX-1
        XB0 = XB(IX) 
        XB1 = 1.D0-XB(IX)
        XUVF(IX,IQ) = PARTON(1,IQ,IX) / (XB1**3 * XB0**0.7)
        XDVF(IX,IQ) = PARTON(2,IQ,IX) / (XB1**4 * XB0**0.6)
        XQBF(IX,IQ) = PARTON(3,IQ,IX) / (XB1**7 * XB0**0.3) 
        XSF(IX,IQ)  = PARTON(4,IQ,IX) / (XB1**7 * XB0**0.3) 
        XGF(IX,IQ)  = PARTON(5,IQ,IX) / (XB1**10 * XB0**0.3)
        XAPF(IX,IQ)  = PARTON(6,IQ,IX) / XB0
        XANF(IX,IQ)  = PARTON(7,IQ,IX) / XB0
        XADF(IX,IQ)  = PARTON(8,IQ,IX) / XB0
  20  CONTINUE
        XUVF(NX,IQ) = 0.D0
        XDVF(NX,IQ) = 0.D0
        XQBF(NX,IQ) = 0.D0
        XSF(NX,IQ)  = 0.D0
        XGF(NX,IQ)  = 0.D0
        XAPF(NX,IQ)  = 0.D0
        XANF(NX,IQ)  = 0.D0
        XADF(NX,IQ)  = 0.D0
  10  CONTINUE  
      NA(1) = NX
      NA(2) = NQ
      DO 30 IX = 1, NX
        ARRF(IX) =  LOG(XB(IX))
  30  CONTINUE
      DO 40 IQ = 1, NQ
        ARRF(NX+IQ) =  LOG(QS(IQ))
  40  CONTINUE
  16  CONTINUE
C
*...INTERPOLATION :
      XT(1) =  LOG(X)
      XT(2) =  LOG(Q2)
      UV = DBFINT(NARG,XT,NA,ARRF,XUVF) * (1.D0-X)**3 * X**0.7
      DUV = UV
      DV = DBFINT(NARG,XT,NA,ARRF,XDVF) * (1.D0-X)**4 * X**0.6 
      DDV = DV 
      QB = DBFINT(NARG,XT,NA,ARRF,XQBF) * (1.D0-X)**7 * X**0.3
      DSEA = QB
      ST = DBFINT(NARG,XT,NA,ARRF,XSF)  * (1.D0-X)**7 * X**0.3
      DSTR = ST
      DCHM = ZEROD
      DBOT = ZEROD
      DTOP = ZEROD
      GL = DBFINT(NARG,XT,NA,ARRF,XGF)  * (1.D0-X)**10 * X**0.3
      DGL = GL
      A1P = DBFINT(NARG,XT,NA,ARRF,XAPF)  * X
      A1N = DBFINT(NARG,XT,NA,ARRF,XANF)  * X
      A1D = DBFINT(NARG,XT,NA,ARRF,XADF)  * X
 60   RETURN
      END
