# MPICH Developer Documentation Wiki

- [Getting And Building MPICH](source_code/Github.md)
    - [Building MPICH For Development](source_code/Building_MPICH_For_Development.md)
        - [Blue Gene/Q](source_code/BGQ.md)
        - [XC40](source_code/Cray.md)
        - [UCX](source_code/Summit.md)

- [Contributing To MPICH](source_code/Contributing_to_MPICH.md)
    - [Git Workflow](source_code/Git_Workflow.md)
    - [Coding Standards](source_code/Coding_Standards.md)
        - [Code Formatting And Cleanup Script](source_code/Code_Formatting_And_Cleanup_Script.md)
    - [Developer Guide](developer_guide.md)

- [Creating New Bug Reports](source_code/Bug_Tickets.md)
- [Using the Hydra Process Manager](how_to/Using_the_Hydra_Process_Manager.md)

- Tools
    - [MPE](tools/MPE_by_example.md)
    - [TAU](tools/TAU_by_example.md)
    - [HPCToolkit](tools/HPCToolkit_by_example.md)

- [FAQ](faq/Frequently_Asked_Questions.md)
- [ABI Compatibility Initiative](testing/ABI_Compatibility_Initiative.md)

- Testing
    - [Nightly Tests](testing/Nightly_Tests.md) (Out Of Date)
    - [Special Tests](https://www.mpich.org/static/cron/specialtests/index.htm) (Out Of Date)
    - [Jenkins](testing/Jenkins.md)
    - [Writing New Tests](testing/Writing_New_Tests.md)
    - [Testing Crons](testing/Testing_Crons.md)
    - [Code Coverage Reports](testing/Code_Coverage_Reports.md)
    - [MPICH ABI Tests](testing/MPICH_ABI_Tests.md)
    - [Helpful Compiler Flags](testing/Helpful_Compiler_Flags_For_Testing.md)

- [Design Documentation](design/Design_Documentation_Index.md)

- Options
    - [MPI+Argobots](options/MPI_Argobots.md)

- Miscellaneous
    - [Using etags On The MPICH Source Tree](source_code/Etags.md)
    - [Mailing Lists](https://www.mpich.org/support/mailing-lists/)
    - [Rules For Installation Targets](source_code/Rules_For_Installation_Targets.md)
    - [Adding New Error Messages](how_to/Adding_New_Error_Messages.md)
    - [Creating A Release](source_code/Creating_A_Release.md)
    - [Managing Commits In Trunk And Release Branches](source_code/Managing_Commits_In_Trunk_and_Release_Branches.md)
    - [Proposed MPIEXEC Extensions](design/Proposed_MPIEXEC_Extensions.md)
    - [Compiler Quirks](source_code/Compiler_Quirks.md)
    - [Shifting Towards C99](source_code/Shifting_Toward_C99.md)
    - [Creating MPICH Manpages](source_code/Creating_MPICH_Manpages.md)
