/*
 * Copyright (c) 2010 Diane Gagne at Hartman Technica 
 * diane@hartmantech.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS `AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGES
 */
#ifndef have_mathsf_h
#define have_mathsf_h

/* Get the __MSP430LIBC_* feature defines */
#include <msp430libc.h>

extern unsigned long __fpmulparts(unsigned long a1, unsigned long a2);

union MSVC_EVIL_FLOAT_HACK
{
   unsigned char Bytes[4];
   float Value;
};
//static union MSVC_EVIL_FLOAT_HACK INFINITY_HACK = {{0x00, 0x00, 0x80, 0x7F}};
#define INFINITY (((union MSVC_EVIL_FLOAT_HACK)({{0x00, 0x00, 0x80, 0x7F}})).Value)

#define MANT(fp)                (((fp) & MANTISSA_MASK) | HIDDEN)

#define POSITIVE_INFINITY       0x7F800000
#define NEGATIVE_INFINITY       0xFF800000
#define NAN                     0x7FC00000
#define POSITIVE_ZERO           0x00000000
#define NEGATIVE_ZERO           0x80000000

#define SHORT_SIGNBIT_MASK      0x8000
#define LONG_SIGNBIT_MASK       0x80000000
#define SHORT_EXPONENT_MASK     0x7F80
#define LONG_EXPONENT_MASK      0x7F800000
#define MANTISSA_MASK           0x7FFFFF
#define MANTISSA_BIT            0x00800000
#define NO_SIGN                 0x7FFFFFFF

#define HIDDEN                  (1ul << 23)

#define SHORT_SHIFT             16
#define MAX_EXPONENT            128
#define MIN_EXPONENT            -23         //The number of times the mantissa can be denormalized below a 0 exponent
#define EXPONENT_OVERFLOW       254
#define EXPONENT_SHIFT          7
#define MANTISSA_BITS           24
#define EXCESS                  126
#define EXPONENT_OFFSET         127

#define SIGN(fp)        ((fp) & LONG_SIGNBIT_MASK)
#define EXP(fp)         (((fp) >> 23) & 0x00FFul)
#define MANT(fp)        (((fp) & MANTISSA_MASK) | HIDDEN)
#define PACK(s,e,m)     ((s) | ((e) << 23) | (m))
#endif
