/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
    public enum Operation {

        CREATE("super.create(entity);", "PUT", "create"),
        EDIT("{super.edit(entity);", "POST", "edit"),
        REMOVE("super.remove(find(i));", "DELETE", "remove", "{i}"),
        FIND("return super.find(i);", "GET", "find", "{i}"),
        FIND_ALL("return super.findAll();", "GET", "findAll"),
        FIND_RANGE("return super.findRange(new int[] {new Integer(from), new Integer(to)});", "GET", "findRange", "{from}/{to}"),
        COUNT("return String.valueOf(super.count());", "GET", "count", "count");

        private String body, method, methodName, uriPath;

        private Operation(String body, String method, String methodName) {
            this.body = body;
            this.method = method;
            this.methodName = methodName;
        }

        private Operation(String body, String method, String methodName, String uriPath) {
            this.body = body;
            this.method = method;
            this.methodName = methodName;
            this.uriPath = uriPath;
        }
        public String getMethod() {
            return method;
        }
        public String getBody() {
            return body;
        }

        public String getMethodName() {
            return methodName;
        }

        public String getUriPath() {
            return uriPath;
        }
    }

 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.websvc.rest.wizard.fromdb;

/**
 * This class represents code generation options for invoking
 * <code>javax.persistence.EntityManager</code> .
 *
 * @author Erno Mononen
 */
public final class RestGenerationOptions {

    public enum Operation {

        CREATE("javax.ws.rs.POST", "create", true ),
        EDIT("javax.ws.rs.PUT", "edit", true ),
        REMOVE("javax.ws.rs.DELETE", "remove", "{id}"),
        FIND("javax.ws.rs.GET", "find", "{id}"),
        FIND_ALL("javax.ws.rs.GET", "findAll", true),
        FIND_RANGE("javax.ws.rs.GET", "findRange", "{from}/{to}"),
        COUNT("javax.ws.rs.GET", "countREST", "count");

        private String method, methodName, uriPath;
        private boolean override;
        
        private Operation(String method, String methodName, boolean override) {
            this.method = method;
            this.methodName = methodName;
            this.override = override;
        }

        private Operation(String method, String methodName) {
            this.method = method;
            this.methodName = methodName;
        }

        private Operation(String method, String methodName, String uriPath) {
            this.method = method;
            this.methodName = methodName;
            this.uriPath = uriPath;
        }
        
        public String getMethod() {
            return method;
        }

        public String getMethodName() {
            return methodName;
        }

        public String getUriPath() {
            return uriPath;
        }
        
        public boolean overrides(){
            return override;
        }
    }
    
    private Operation operation;
    private String returnType, body;
    private String[] parameterTypes, parameterNames, pathParams, consumes, produces;

    public String[] getConsumes() {
        return consumes;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setConsumes(String[] consumes) {
        this.consumes = consumes;
    }

    public String[] getParameterNames() {
        return parameterNames;
    }

    public void setParameterNames(String[] parameterNames) {
        this.parameterNames = parameterNames;
    }

    public String[] getPathParams() {
        return pathParams;
    }

    public void setPathParams(String[] pathParams) {
        this.pathParams = pathParams;
    }

    public String[] getProduces() {
        return produces;
    }

    public void setProduces(String[] produces) {
        this.produces = produces;
    }

    public String[] getParameterTypes() {
        return parameterTypes;
    }

    public void setParameterTypes(String[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public String getReturnType() {
        return returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public Operation getOperation() {
        return operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

}
