import { RandomGenerator as PureRandRandomGenerator } from 'pure-rand';
/**
 * Interface for `RandomGenerator` as declared in pure-rand for versions strictly lower than 5.x.x
 *
 * @deprecated
 * Temporary helper that will disappear and not be supported anymore in next major release.
 *
 * @remarks Since 2.17.0
 * @public
 */
export interface LegacyPureRandRandomGenerator {
    /** Minimal value (included) that could be generated by this generator */
    min(): number;
    /** Maximal value (included) that could be generated by this generator */
    max(): number;
    /** Generate next random value along with the next generator (does not impact current instance) */
    next(): [number, LegacyPureRandRandomGenerator];
    /** Compute the jumped generator (does not impact current instance) */
    jump?(): LegacyPureRandRandomGenerator;
}
/**
 * The minimal API for a random generator as requested by fast-check.
 * The most important point being that the generator HAS TO BE pure.
 * In other words, it has to expose methods to compute a random value while not impacting itself (see next/jump).
 *
 * @deprecated
 * Temporary helper that will disappear in next major release.
 * Prefer referencing directly RandomGenerator from RandomGenerator.
 *
 * @remarks Since 2.17.0
 * @public
 */
export declare type PureRandom = PureRandRandomGenerator | LegacyPureRandRandomGenerator;
