"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _yogaLayoutPrebuilt = _interopRequireDefault(require("yoga-layout-prebuilt"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const applyMarginStyles = (node, style) => {
  if (style.margin) {
    node.setMargin(_yogaLayoutPrebuilt.default.EDGE_TOP, style.margin);
    node.setMargin(_yogaLayoutPrebuilt.default.EDGE_BOTTOM, style.margin);
    node.setMargin(_yogaLayoutPrebuilt.default.EDGE_START, style.margin);
    node.setMargin(_yogaLayoutPrebuilt.default.EDGE_END, style.margin);
  }

  if (style.marginX) {
    node.setMargin(_yogaLayoutPrebuilt.default.EDGE_START, style.marginX);
    node.setMargin(_yogaLayoutPrebuilt.default.EDGE_END, style.marginX);
  }

  if (style.marginY) {
    node.setMargin(_yogaLayoutPrebuilt.default.EDGE_TOP, style.marginY);
    node.setMargin(_yogaLayoutPrebuilt.default.EDGE_BOTTOM, style.marginY);
  }

  if (style.marginTop) {
    node.setMargin(_yogaLayoutPrebuilt.default.EDGE_TOP, style.marginTop);
  }

  if (style.marginBottom) {
    node.setMargin(_yogaLayoutPrebuilt.default.EDGE_BOTTOM, style.marginBottom);
  }

  if (style.marginLeft) {
    node.setMargin(_yogaLayoutPrebuilt.default.EDGE_START, style.marginLeft);
  }

  if (style.marginRight) {
    node.setMargin(_yogaLayoutPrebuilt.default.EDGE_END, style.marginRight);
  }
};

const applyPaddingStyles = (node, style) => {
  if (style.padding) {
    node.setPadding(_yogaLayoutPrebuilt.default.EDGE_TOP, style.padding);
    node.setPadding(_yogaLayoutPrebuilt.default.EDGE_BOTTOM, style.padding);
    node.setPadding(_yogaLayoutPrebuilt.default.EDGE_LEFT, style.padding);
    node.setPadding(_yogaLayoutPrebuilt.default.EDGE_RIGHT, style.padding);
  }

  if (style.paddingX) {
    node.setPadding(_yogaLayoutPrebuilt.default.EDGE_LEFT, style.paddingX);
    node.setPadding(_yogaLayoutPrebuilt.default.EDGE_RIGHT, style.paddingX);
  }

  if (style.paddingY) {
    node.setPadding(_yogaLayoutPrebuilt.default.EDGE_TOP, style.paddingY);
    node.setPadding(_yogaLayoutPrebuilt.default.EDGE_BOTTOM, style.paddingY);
  }

  if (style.paddingTop) {
    node.setPadding(_yogaLayoutPrebuilt.default.EDGE_TOP, style.paddingTop);
  }

  if (style.paddingBottom) {
    node.setPadding(_yogaLayoutPrebuilt.default.EDGE_BOTTOM, style.paddingBottom);
  }

  if (style.paddingLeft) {
    node.setPadding(_yogaLayoutPrebuilt.default.EDGE_LEFT, style.paddingLeft);
  }

  if (style.paddingRight) {
    node.setPadding(_yogaLayoutPrebuilt.default.EDGE_RIGHT, style.paddingRight);
  }
};

const applyFlexStyles = (node, style) => {
  if (style.flexGrow) {
    node.setFlexGrow(style.flexGrow);
  }

  if (style.flexShrink) {
    node.setFlexShrink(style.flexShrink);
  }

  if (style.flexDirection) {
    if (style.flexDirection === 'row') {
      node.setFlexDirection(_yogaLayoutPrebuilt.default.FLEX_DIRECTION_ROW);
    }

    if (style.flexDirection === 'row-reverse') {
      node.setFlexDirection(_yogaLayoutPrebuilt.default.FLEX_DIRECTION_ROW_REVERSE);
    }

    if (style.flexDirection === 'column') {
      node.setFlexDirection(_yogaLayoutPrebuilt.default.FLEX_DIRECTION_COLUMN);
    }

    if (style.flexDirection === 'column-reverse') {
      node.setFlexDirection(_yogaLayoutPrebuilt.default.FLEX_DIRECTION_COLUMN_REVERSE);
    }
  }

  if (style.flexBasis !== undefined) {
    node.setFlexBasis(style.flexBasis);
  }

  if (style.alignItems) {
    if (style.alignItems === 'flex-start') {
      node.setAlignItems(_yogaLayoutPrebuilt.default.ALIGN_FLEX_START);
    }

    if (style.alignItems === 'center') {
      node.setAlignItems(_yogaLayoutPrebuilt.default.ALIGN_CENTER);
    }

    if (style.alignItems === 'flex-end') {
      node.setAlignItems(_yogaLayoutPrebuilt.default.ALIGN_FLEX_END);
    }
  }

  if (style.justifyContent) {
    if (style.justifyContent === 'flex-start') {
      node.setJustifyContent(_yogaLayoutPrebuilt.default.JUSTIFY_FLEX_START);
    }

    if (style.justifyContent === 'center') {
      node.setJustifyContent(_yogaLayoutPrebuilt.default.JUSTIFY_CENTER);
    }

    if (style.justifyContent === 'flex-end') {
      node.setJustifyContent(_yogaLayoutPrebuilt.default.JUSTIFY_FLEX_END);
    }

    if (style.justifyContent === 'space-between') {
      node.setJustifyContent(_yogaLayoutPrebuilt.default.JUSTIFY_SPACE_BETWEEN);
    }

    if (style.justifyContent === 'space-around') {
      node.setJustifyContent(_yogaLayoutPrebuilt.default.JUSTIFY_SPACE_AROUND);
    }
  }
};

const applyDimensionStyles = (node, style) => {
  if (style.width !== undefined) {
    node.setWidth(style.width);
  }

  if (style.height !== undefined) {
    node.setHeight(style.height);
  }

  if (style.minWidth !== undefined) {
    node.setMinWidth(style.minWidth);
  }

  if (style.minHeight !== undefined) {
    node.setMinHeight(style.minHeight);
  }
};

var _default = (node, style = {}) => {
  applyMarginStyles(node, style);
  applyPaddingStyles(node, style);
  applyFlexStyles(node, style);
  applyDimensionStyles(node, style);
};

exports.default = _default;