/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.AttributeMap;
import org.apache.xerces.dom.CoreDOMImplementationImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMConfigurationImpl;
import org.apache.xerces.dom.DOMErrorImpl;
import org.apache.xerces.dom.DOMLocatorImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.EntityReferenceImpl;
import org.apache.xerces.dom.PSVIAttrNSImpl;
import org.apache.xerces.dom.PSVIElementNSImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.dom3.DOMError;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.impl.RevalidationHandler;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xni.psvi.AttributePSVI;
import org.apache.xerces.xni.psvi.ElementPSVI;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DOMNormalizer
implements XMLDocumentHandler {
    protected static final boolean DEBUG_ND = false;
    protected static final boolean DEBUG = false;
    protected static final boolean DEBUG_EVENTS = false;
    protected static final String PREFIX = "NS";
    protected DOMConfigurationImpl fConfiguration = null;
    protected CoreDocumentImpl fDocument = null;
    protected final XMLAttributesProxy fAttrProxy = new XMLAttributesProxy();
    protected final QName fQName = new QName();
    protected RevalidationHandler fValidationHandler;
    protected SymbolTable fSymbolTable;
    protected DOMErrorHandler fErrorHandler;
    protected int fNamespaceCounter = 1;
    protected boolean fNamespaceValidation = false;
    protected boolean fPSVI = false;
    protected final NamespaceContext fNamespaceContext = new NamespaceSupport();
    protected final NamespaceContext fLocalNSBinder = new NamespaceSupport();
    protected final Vector fAttributeList = new Vector(5, 10);
    protected final DOMErrorImpl fDOMError = new DOMErrorImpl();
    protected final DOMLocatorImpl fLocator = new DOMLocatorImpl();
    protected Node fCurrentNode = null;
    private QName fAttrQName = new QName();
    final XMLString fNormalizedValue = new XMLString(new char[16], 0, 0);

    protected void normalizeDocument(CoreDocumentImpl coreDocumentImpl, DOMConfigurationImpl dOMConfigurationImpl) {
        this.fDocument = coreDocumentImpl;
        this.fConfiguration = dOMConfigurationImpl;
        this.fSymbolTable = (SymbolTable)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/symbol-table");
        this.fNamespaceContext.reset();
        this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
        this.fNamespaceCounter = 1;
        if ((this.fConfiguration.features & 0x40) != 0) {
            this.fValidationHandler = CoreDOMImplementationImpl.singleton.getValidator("http://www.w3.org/2001/XMLSchema");
            this.fConfiguration.setFeature("http://xml.org/sax/features/validation", true);
            this.fConfiguration.setFeature("http://apache.org/xml/features/validation/schema", true);
            this.fNamespaceValidation = true;
            this.fPSVI = (this.fConfiguration.features & 0x80) != 0;
            this.fDocument.clearIdentifiers();
            ((XMLComponent)((Object)this.fValidationHandler)).reset(this.fConfiguration);
        }
        this.fErrorHandler = (DOMErrorHandler)this.fConfiguration.getParameter("error-handler");
        if (this.fValidationHandler != null) {
            this.fValidationHandler.setBaseURI(this.fDocument.fDocumentURI);
            this.fValidationHandler.setDocumentHandler(this);
            this.fValidationHandler.startDocument(null, this.fDocument.encoding, this.fNamespaceContext, null);
        }
        try {
            Node node = this.fDocument.getFirstChild();
            while (node != null) {
                Node node2 = node.getNextSibling();
                if ((node = this.normalizeNode(node)) != null) {
                    node2 = node;
                }
                node = node2;
            }
            if (this.fValidationHandler != null) {
                this.fValidationHandler.endDocument(null);
                CoreDOMImplementationImpl.singleton.releaseValidator("http://www.w3.org/2001/XMLSchema", this.fValidationHandler);
                this.fValidationHandler = null;
            }
        }
        catch (RuntimeException runtimeException) {
            this.modifyDOMError("Runtime exception: " + runtimeException.getMessage(), (short)2, null);
            this.fErrorHandler.handleError(this.fDOMError);
            runtimeException.printStackTrace();
        }
    }

    protected Node normalizeNode(Node node) {
        short s = node.getNodeType();
        switch (s) {
            case 10: {
                if ((this.fConfiguration.features & 4) != 0) break;
                ((DocumentTypeImpl)node).entities.removeAll();
                break;
            }
            case 1: {
                Node node2;
                AttributeMap attributeMap;
                this.fNamespaceContext.pushContext();
                ElementImpl elementImpl = (ElementImpl)node;
                if (elementImpl.needsSyncChildren()) {
                    elementImpl.synchronizeChildren();
                }
                AttributeMap attributeMap2 = attributeMap = elementImpl.hasAttributes() ? (AttributeMap)elementImpl.getAttributes() : null;
                if ((this.fConfiguration.features & 1) != 0) {
                    this.namespaceFixUp(elementImpl, attributeMap);
                } else if (attributeMap != null) {
                    int n = 0;
                    while (n < attributeMap.getLength()) {
                        node2 = (Attr)attributeMap.item(n);
                        node2.normalize();
                        ++n;
                    }
                }
                if (this.fValidationHandler != null) {
                    this.fAttrProxy.setAttributes(attributeMap, this.fDocument, elementImpl);
                    this.updateQName(elementImpl, this.fQName);
                    this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                    this.fCurrentNode = node;
                    this.fValidationHandler.startElement(this.fQName, this.fAttrProxy, null);
                }
                Node node3 = elementImpl.getFirstChild();
                while (node3 != null) {
                    node2 = node3.getNextSibling();
                    if ((node3 = this.normalizeNode(node3)) != null) {
                        node2 = node3;
                    }
                    node3 = node2;
                }
                if (this.fValidationHandler != null) {
                    this.updateQName(elementImpl, this.fQName);
                    this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                    this.fCurrentNode = node;
                    this.fValidationHandler.endElement(this.fQName, null);
                }
                this.fNamespaceContext.popContext();
                break;
            }
            case 8: {
                Node node4;
                if ((this.fConfiguration.features & 0x20) != 0) break;
                Node node5 = node.getPreviousSibling();
                Node node6 = node.getParentNode();
                node6.removeChild(node);
                if (node5 == null || node5.getNodeType() != 3 || (node4 = node5.getNextSibling()) == null || node4.getNodeType() != 3) break;
                ((TextImpl)node4).insertData(0, node5.getNodeValue());
                node6.removeChild(node5);
                return node4;
            }
            case 5: {
                Node node7;
                if ((this.fConfiguration.features & 4) != 0) break;
                Node node8 = node.getPreviousSibling();
                Node node9 = node.getParentNode();
                ((EntityReferenceImpl)node).setReadOnly(false, true);
                this.expandEntityRef(node, node9, node);
                node9.removeChild(node);
                Node node10 = node7 = node8 != null ? node8.getNextSibling() : node9.getFirstChild();
                if (node8 != null && node8.getNodeType() == 3 && node7.getNodeType() == 3) {
                    return node8;
                }
                return node7;
            }
            case 4: {
                if ((this.fConfiguration.features & 8) == 0) {
                    Text text = this.fDocument.createTextNode(node.getNodeValue());
                    Node node11 = node.getParentNode();
                    Node node12 = node.getPreviousSibling();
                    node = node11.replaceChild(text, node);
                    if (node12 != null && node12.getNodeType() == 3) {
                        text.insertData(0, node12.getNodeValue());
                        node11.removeChild(node12);
                    }
                    return text;
                }
                if (this.fValidationHandler != null) {
                    this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                    this.fCurrentNode = node;
                    this.fValidationHandler.startCDATA(null);
                    this.fValidationHandler.characterData(node.getNodeValue(), null);
                    this.fValidationHandler.endCDATA(null);
                }
                if ((this.fConfiguration.features & 0x10) == 0) break;
                String string = node.getNodeValue();
                int n = string.indexOf("]]>");
                if (n >= 0) {
                    // empty if block
                }
                Node node13 = node.getParentNode();
                while (n >= 0) {
                    node.setNodeValue(string.substring(0, n + 2));
                    string = string.substring(n + 2);
                    node = this.fDocument.createCDATASection(string);
                    node13.insertBefore(node, node.getNextSibling());
                    n = string.indexOf("]]>");
                }
                break;
            }
            case 3: {
                int n;
                Node node14 = node.getNextSibling();
                if (node14 != null && node14.getNodeType() == 3) {
                    ((Text)node).appendData(node14.getNodeValue());
                    node.getParentNode().removeChild(node14);
                    return node;
                }
                if (node.getNodeValue().length() == 0) {
                    node.getParentNode().removeChild(node);
                    break;
                }
                if (this.fValidationHandler == null) break;
                int n2 = n = node14 != null ? (int)node14.getNodeType() : -1;
                if ((this.fConfiguration.features & 4) == 0 && n == 6 || (this.fConfiguration.features & 0x20) == 0 && n == 8 || (this.fConfiguration.features & 8) == 0 && n == 4) break;
                this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                this.fCurrentNode = node;
                this.fValidationHandler.characterData(node.getNodeValue(), null);
            }
        }
        return null;
    }

    protected final void expandEntityRef(Node node, Node node2, Node node3) {
        Node node4 = node.getFirstChild();
        while (node4 != null) {
            Node node5 = node4.getNextSibling();
            if (node.getNodeType() == 3) {
                this.expandEntityRef(node4, node2, node3);
            } else {
                node2.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    protected final void namespaceFixUp(ElementImpl elementImpl, AttributeMap attributeMap) {
        String string;
        boolean bl;
        String string2;
        String string3;
        Attr attr;
        if (attributeMap != null) {
            int n = 0;
            while (n < attributeMap.getLength()) {
                attr = (Attr)attributeMap.getItem(n);
                string3 = attr.getNamespaceURI();
                if (string3 != null && string3.equals(NamespaceContext.XMLNS_URI)) {
                    string2 = attr.getNodeValue();
                    if (string2 == null) {
                        string2 = XMLSymbols.EMPTY_STRING;
                    }
                    if (string2.equals(NamespaceContext.XMLNS_URI)) {
                        if (this.fErrorHandler != null) {
                            this.modifyDOMError("No prefix other than 'xmlns' can be bound to 'http://www.w3.org/2000/xmlns/' namespace name", (short)1, attr);
                            bl = this.fErrorHandler.handleError(this.fDOMError);
                            if (!bl) {
                                throw new RuntimeException("Stopped at user request");
                            }
                        }
                    } else {
                        string = attr.getPrefix();
                        string = string == null || string.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string);
                        String string4 = this.fSymbolTable.addSymbol(attr.getLocalName());
                        if (string == XMLSymbols.PREFIX_XMLNS) {
                            if ((string2 = this.fSymbolTable.addSymbol(string2)).length() != 0) {
                                this.fNamespaceContext.declarePrefix(string4, string2);
                                this.fLocalNSBinder.declarePrefix(string4, string2);
                            }
                        } else {
                            string2 = this.fSymbolTable.addSymbol(string2);
                            this.fLocalNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, string2);
                            this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, string2);
                        }
                    }
                }
                ++n;
            }
        }
        string3 = elementImpl.getNamespaceURI();
        string = elementImpl.getPrefix();
        if (string3 != null) {
            string3 = this.fSymbolTable.addSymbol(string3);
            String string5 = string = string == null || string.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string);
            if (this.fNamespaceContext.getURI(string) != string3) {
                this.addNamespaceDecl(string, string3, elementImpl);
                this.fLocalNSBinder.declarePrefix(string, string3);
                this.fNamespaceContext.declarePrefix(string, string3);
            }
        } else {
            String string6 = elementImpl.getNodeName();
            int n = string6.indexOf(58);
            if (n > -1) {
                bl = true;
                if (this.fErrorHandler != null) {
                    if (this.fNamespaceValidation) {
                        this.modifyDOMError("DOM Level 1 node: " + string6, (short)2, elementImpl);
                        this.fErrorHandler.handleError(this.fDOMError);
                    } else {
                        this.modifyDOMError("DOM Level 1 node: " + string6, (short)1, elementImpl);
                        bl = this.fErrorHandler.handleError(this.fDOMError);
                    }
                }
                if (this.fNamespaceValidation || !bl) {
                    throw new RuntimeException("DOM Level 1 node: " + string6);
                }
            } else {
                string3 = this.fNamespaceContext.getURI(XMLSymbols.EMPTY_STRING);
                if (string3 != null && string3.length() > 0) {
                    this.addNamespaceDecl(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING, elementImpl);
                    this.fLocalNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                    this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                }
            }
        }
        if (attributeMap != null) {
            attributeMap.cloneMap(this.fAttributeList);
            int n = 0;
            while (n < this.fAttributeList.size()) {
                attr = (Attr)this.fAttributeList.elementAt(n);
                attr.normalize();
                string2 = attr.getValue();
                String string7 = attr.getNodeName();
                string3 = attr.getNamespaceURI();
                if (string2 == null) {
                    string2 = XMLSymbols.EMPTY_STRING;
                }
                if (string3 != null) {
                    string = attr.getPrefix();
                    string = string == null || string.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string);
                    String string8 = this.fSymbolTable.addSymbol(attr.getLocalName());
                    if (string3 == null || !string3.equals(NamespaceContext.XMLNS_URI)) {
                        ((AttrImpl)attr).setIdAttribute(false);
                        string3 = this.fSymbolTable.addSymbol(string3);
                        String string9 = this.fNamespaceContext.getURI(string);
                        if (string == XMLSymbols.EMPTY_STRING || string9 != string3) {
                            string7 = attr.getNodeName();
                            String string10 = this.fNamespaceContext.getPrefix(string3);
                            if (string10 != null && string10 != XMLSymbols.EMPTY_STRING) {
                                string = string10;
                            } else {
                                if (string == XMLSymbols.EMPTY_STRING || this.fLocalNSBinder.getURI(string) != null) {
                                    string = this.fSymbolTable.addSymbol(PREFIX + this.fNamespaceCounter++);
                                    while (this.fLocalNSBinder.getURI(string) != null) {
                                        string = this.fSymbolTable.addSymbol(PREFIX + this.fNamespaceCounter++);
                                    }
                                }
                                this.addNamespaceDecl(string, string3, elementImpl);
                                string2 = this.fSymbolTable.addSymbol(string2);
                                this.fLocalNSBinder.declarePrefix(string, string2);
                                this.fNamespaceContext.declarePrefix(string, string3);
                            }
                            attr.setPrefix(string);
                        }
                    }
                } else {
                    int n2 = string7.indexOf(58);
                    ((AttrImpl)attr).setIdAttribute(false);
                    if (n2 > -1) {
                        boolean bl2 = true;
                        if (this.fErrorHandler != null) {
                            if (this.fNamespaceValidation) {
                                this.modifyDOMError("DOM Level 1 node: " + string7, (short)2, attr);
                                this.fErrorHandler.handleError(this.fDOMError);
                            } else {
                                this.modifyDOMError("DOM Level 1 node: " + string7, (short)1, attr);
                                bl2 = this.fErrorHandler.handleError(this.fDOMError);
                            }
                        }
                        if (this.fNamespaceValidation || !bl2) {
                            throw new RuntimeException("DOM Level 1 node");
                        }
                    }
                }
                ++n;
            }
        }
    }

    protected final void addNamespaceDecl(String string, String string2, ElementImpl elementImpl) {
        if (string == XMLSymbols.EMPTY_STRING) {
            elementImpl.setAttributeNS(NamespaceContext.XMLNS_URI, XMLSymbols.PREFIX_XMLNS, string2);
        } else {
            elementImpl.setAttributeNS(NamespaceContext.XMLNS_URI, "xmlns:" + string, string2);
        }
    }

    protected final DOMError modifyDOMError(String string, short s, Node node) {
        this.fDOMError.reset();
        this.fDOMError.fMessage = string;
        this.fDOMError.fSeverity = s;
        this.fDOMError.fLocator = this.fLocator;
        this.fLocator.fErrorNode = node;
        return this.fDOMError;
    }

    protected final void updateQName(Node node, QName qName) {
        String string = node.getPrefix();
        String string2 = node.getNamespaceURI();
        String string3 = node.getLocalName();
        qName.prefix = string != null && string.length() != 0 ? this.fSymbolTable.addSymbol(string) : null;
        qName.localpart = string3 != null ? this.fSymbolTable.addSymbol(string3) : null;
        qName.rawname = this.fSymbolTable.addSymbol(node.getNodeName());
        qName.uri = string2 != null ? this.fSymbolTable.addSymbol(string2) : null;
    }

    final String normalizeAttributeValue(String string, Attr attr) {
        if (!attr.getSpecified()) {
            return string;
        }
        int n = string.length();
        if (this.fNormalizedValue.ch.length < n) {
            this.fNormalizedValue.ch = new char[n];
        }
        this.fNormalizedValue.length = 0;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\t' || c == '\n') {
                this.fNormalizedValue.ch[this.fNormalizedValue.length++] = 32;
                bl = true;
            } else if (c == '\r') {
                bl = true;
                this.fNormalizedValue.ch[this.fNormalizedValue.length++] = 32;
                int n3 = n2 + 1;
                if (n3 < n && string.charAt(n3) == '\n') {
                    n2 = n3;
                }
            } else {
                this.fNormalizedValue.ch[this.fNormalizedValue.length++] = c;
            }
            ++n2;
        }
        if (bl) {
            string = this.fNormalizedValue.toString();
            attr.setValue(string);
        }
        return string;
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
    }

    public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
    }

    public void doctypeDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        Element element = (Element)this.fCurrentNode;
        int n = xMLAttributes.getLength();
        int n2 = 0;
        while (n2 < n) {
            xMLAttributes.getName(n2, this.fAttrQName);
            Attr attr = null;
            attr = element.getAttributeNodeNS(this.fAttrQName.uri, this.fAttrQName.localpart);
            AttributePSVI attributePSVI = (AttributePSVI)xMLAttributes.getAugmentations(n2).getItem("ATTRIBUTE_PSVI");
            if (attributePSVI != null) {
                XSTypeDefinition xSTypeDefinition = attributePSVI.getMemberTypeDefinition();
                boolean bl = false;
                if (xSTypeDefinition != null) {
                    bl = ((XSSimpleType)xSTypeDefinition).isIDType();
                } else {
                    xSTypeDefinition = attributePSVI.getTypeDefinition();
                    if (xSTypeDefinition != null) {
                        bl = ((XSSimpleType)xSTypeDefinition).isIDType();
                    }
                }
                if (bl) {
                    ((ElementImpl)element).setIdAttributeNode(attr, true);
                }
                if (this.fPSVI) {
                    ((PSVIAttrNSImpl)attr).setPSVI(attributePSVI);
                }
                if ((this.fConfiguration.features & 2) != 0) {
                    boolean bl2 = attr.getSpecified();
                    attr.setValue(attributePSVI.getSchemaNormalizedValue());
                    if (!bl2) {
                        ((AttrImpl)attr).setSpecified(bl2);
                    }
                }
            }
            ++n2;
        }
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.startElement(qName, xMLAttributes, augmentations);
        this.endElement(qName, augmentations);
    }

    public void startGeneralEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
    }

    public void textDecl(String string, String string2, Augmentations augmentations) throws XNIException {
    }

    public void endGeneralEntity(String string, Augmentations augmentations) throws XNIException {
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        ElementPSVI elementPSVI = (ElementPSVI)augmentations.getItem("ELEMENT_PSVI");
        if (elementPSVI != null) {
            ElementImpl elementImpl = (ElementImpl)this.fCurrentNode;
            if (this.fPSVI) {
                ((PSVIElementNSImpl)this.fCurrentNode).setPSVI(elementPSVI);
            }
            String string = elementPSVI.getSchemaNormalizedValue();
            if ((this.fConfiguration.features & 2) != 0) {
                elementImpl.setTextContent(string);
            } else {
                String string2 = elementImpl.getTextContent();
                if (string2.length() == 0) {
                    elementImpl.setTextContent(string);
                }
            }
        }
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
    }

    public void setDocumentSource(XMLDocumentSource xMLDocumentSource) {
    }

    public XMLDocumentSource getDocumentSource() {
        return null;
    }

    protected final class XMLAttributesProxy
    implements XMLAttributes {
        protected AttributeMap fAttributes;
        protected CoreDocumentImpl fDocument;
        protected ElementImpl fElement;
        protected final Vector fAugmentations = new Vector(5);

        protected XMLAttributesProxy() {
        }

        public void setAttributes(AttributeMap attributeMap, CoreDocumentImpl coreDocumentImpl, ElementImpl elementImpl) {
            this.fDocument = coreDocumentImpl;
            this.fAttributes = attributeMap;
            this.fElement = elementImpl;
            if (attributeMap != null) {
                int n = attributeMap.getLength();
                this.fAugmentations.setSize(n);
                int n2 = 0;
                while (n2 < n) {
                    this.fAugmentations.setElementAt(new AugmentationsImpl(), n2);
                    ++n2;
                }
            } else {
                this.fAugmentations.setSize(0);
            }
        }

        public int addAttribute(QName qName, String string, String string2) {
            int n = this.fElement.getXercesAttribute(qName.uri, qName.localpart);
            if (n < 0) {
                AttrImpl attrImpl = (AttrImpl)((CoreDocumentImpl)this.fElement.getOwnerDocument()).createAttributeNS(qName.uri, qName.rawname, qName.localpart);
                n = this.fElement.setXercesAttributeNode(attrImpl);
                attrImpl.setNodeValue(string2);
                this.fAugmentations.insertElementAt(new AugmentationsImpl(), n);
                attrImpl.setSpecified(false);
            }
            return n;
        }

        public void removeAllAttributes() {
        }

        public void removeAttributeAt(int n) {
        }

        public int getLength() {
            return this.fAttributes != null ? this.fAttributes.getLength() : 0;
        }

        public int getIndex(String string) {
            return -1;
        }

        public int getIndex(String string, String string2) {
            return -1;
        }

        public void setName(int n, QName qName) {
        }

        public void getName(int n, QName qName) {
            if (this.fAttributes != null) {
                DOMNormalizer.this.updateQName((Node)this.fAttributes.getItem(n), qName);
            }
        }

        public String getPrefix(int n) {
            return null;
        }

        public String getURI(int n) {
            return null;
        }

        public String getLocalName(int n) {
            return null;
        }

        public String getQName(int n) {
            return null;
        }

        public void setType(int n, String string) {
        }

        public String getType(int n) {
            return "CDATA";
        }

        public String getType(String string) {
            return "CDATA";
        }

        public String getType(String string, String string2) {
            return "CDATA";
        }

        public void setValue(int n, String string) {
            if (this.fAttributes != null) {
                AttrImpl attrImpl = (AttrImpl)this.fAttributes.getItem(n);
                boolean bl = attrImpl.getSpecified();
                attrImpl.setValue(string);
                attrImpl.setSpecified(bl);
            }
        }

        public String getValue(int n) {
            return this.fAttributes != null ? this.fAttributes.item(n).getNodeValue() : "";
        }

        public String getValue(String string) {
            return null;
        }

        public String getValue(String string, String string2) {
            if (this.fAttributes != null) {
                Node node = this.fAttributes.getNamedItemNS(string, string2);
                return node != null ? node.getNodeValue() : null;
            }
            return null;
        }

        public void setNonNormalizedValue(int n, String string) {
        }

        public String getNonNormalizedValue(int n) {
            return null;
        }

        public void setSpecified(int n, boolean bl) {
            AttrImpl attrImpl = (AttrImpl)this.fAttributes.getItem(n);
            attrImpl.setSpecified(bl);
        }

        public boolean isSpecified(int n) {
            return ((Attr)this.fAttributes.getItem(n)).getSpecified();
        }

        public Augmentations getAugmentations(int n) {
            return (Augmentations)this.fAugmentations.elementAt(n);
        }

        public Augmentations getAugmentations(String string, String string2) {
            return null;
        }

        public Augmentations getAugmentations(String string) {
            return null;
        }

        public void setAugmentations(int n, Augmentations augmentations) {
            this.fAugmentations.setElementAt(augmentations, n);
        }
    }
}

