/*###############################################################################
# Linux Management Providers (LMP), Sensors provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_ProcessorVoltageSensor.h"

CMPIObjectPath* Sensors_OpenDRIM_ProcessorVoltageSensor_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_ProcessorVoltageSensor& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_ProcessorVoltageSensor_classnames[0], OpenDRIM_ProcessorVoltageSensor_NAMESPACE);

	if (!instance.SystemCreationClassName_isNULL)
		op.addKey("SystemCreationClassName", instance.SystemCreationClassName);

	if (!instance.SystemName_isNULL)
		op.addKey("SystemName", instance.SystemName);

	if (!instance.CreationClassName_isNULL)
		op.addKey("CreationClassName", instance.CreationClassName);

	if (!instance.DeviceID_isNULL)
		op.addKey("DeviceID", instance.DeviceID);

	_L_;
	return op.getHdl();
}

CMPIInstance* Sensors_OpenDRIM_ProcessorVoltageSensor_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_ProcessorVoltageSensor& instance) {
	_E_;
	Objectpath op(broker, Sensors_OpenDRIM_ProcessorVoltageSensor_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.InstanceID_isNULL)
		ci.setProperty("InstanceID", instance.InstanceID);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.InstallDate_isNULL)
		ci.setPropertyDatetime("InstallDate", instance.InstallDate);

	if (!instance.Name_isNULL)
		ci.setProperty("Name", instance.Name);

	if (!instance.OperationalStatus_isNULL)
		ci.setProperty("OperationalStatus", instance.OperationalStatus);

	if (!instance.StatusDescriptions_isNULL)
		ci.setProperty("StatusDescriptions", instance.StatusDescriptions);

	if (!instance.Status_isNULL)
		ci.setProperty("Status", instance.Status);

	if (!instance.HealthState_isNULL)
		ci.setProperty("HealthState", instance.HealthState);

	if (!instance.CommunicationStatus_isNULL)
		ci.setProperty("CommunicationStatus", instance.CommunicationStatus);

	if (!instance.DetailedStatus_isNULL)
		ci.setProperty("DetailedStatus", instance.DetailedStatus);

	if (!instance.OperatingStatus_isNULL)
		ci.setProperty("OperatingStatus", instance.OperatingStatus);

	if (!instance.PrimaryStatus_isNULL)
		ci.setProperty("PrimaryStatus", instance.PrimaryStatus);

	if (!instance.EnabledState_isNULL)
		ci.setProperty("EnabledState", instance.EnabledState);

	if (!instance.OtherEnabledState_isNULL)
		ci.setProperty("OtherEnabledState", instance.OtherEnabledState);

	if (!instance.RequestedState_isNULL)
		ci.setProperty("RequestedState", instance.RequestedState);

	if (!instance.EnabledDefault_isNULL)
		ci.setProperty("EnabledDefault", instance.EnabledDefault);

	if (!instance.TimeOfLastStateChange_isNULL)
		ci.setPropertyDatetime("TimeOfLastStateChange", instance.TimeOfLastStateChange);

	if (!instance.AvailableRequestedStates_isNULL)
		ci.setProperty("AvailableRequestedStates", instance.AvailableRequestedStates);

	if (!instance.TransitioningToState_isNULL)
		ci.setProperty("TransitioningToState", instance.TransitioningToState);

	if (!instance.PowerManagementSupported_isNULL)
		ci.setProperty("PowerManagementSupported", instance.PowerManagementSupported);

	if (!instance.PowerManagementCapabilities_isNULL)
		ci.setProperty("PowerManagementCapabilities", instance.PowerManagementCapabilities);

	if (!instance.Availability_isNULL)
		ci.setProperty("Availability", instance.Availability);

	if (!instance.StatusInfo_isNULL)
		ci.setProperty("StatusInfo", instance.StatusInfo);

	if (!instance.LastErrorCode_isNULL)
		ci.setProperty("LastErrorCode", instance.LastErrorCode);

	if (!instance.ErrorDescription_isNULL)
		ci.setProperty("ErrorDescription", instance.ErrorDescription);

	if (!instance.ErrorCleared_isNULL)
		ci.setProperty("ErrorCleared", instance.ErrorCleared);

	if (!instance.OtherIdentifyingInfo_isNULL)
		ci.setProperty("OtherIdentifyingInfo", instance.OtherIdentifyingInfo);

	if (!instance.PowerOnHours_isNULL)
		ci.setProperty("PowerOnHours", instance.PowerOnHours);

	if (!instance.TotalPowerOnHours_isNULL)
		ci.setProperty("TotalPowerOnHours", instance.TotalPowerOnHours);

	if (!instance.IdentifyingDescriptions_isNULL)
		ci.setProperty("IdentifyingDescriptions", instance.IdentifyingDescriptions);

	if (!instance.AdditionalAvailability_isNULL)
		ci.setProperty("AdditionalAvailability", instance.AdditionalAvailability);

	if (!instance.MaxQuiesceTime_isNULL)
		ci.setProperty("MaxQuiesceTime", instance.MaxQuiesceTime);

	if (!instance.SensorType_isNULL)
		ci.setProperty("SensorType", instance.SensorType);

	if (!instance.OtherSensorTypeDescription_isNULL)
		ci.setProperty("OtherSensorTypeDescription", instance.OtherSensorTypeDescription);

	if (!instance.PossibleStates_isNULL)
		ci.setProperty("PossibleStates", instance.PossibleStates);

	if (!instance.CurrentState_isNULL)
		ci.setProperty("CurrentState", instance.CurrentState);

	if (!instance.PollingInterval_isNULL)
		ci.setProperty("PollingInterval", instance.PollingInterval);

	if (!instance.BaseUnits_isNULL)
		ci.setProperty("BaseUnits", instance.BaseUnits);

	if (!instance.UnitModifier_isNULL)
		ci.setProperty("UnitModifier", instance.UnitModifier);

	if (!instance.RateUnits_isNULL)
		ci.setProperty("RateUnits", instance.RateUnits);

	if (!instance.CurrentReading_isNULL)
		ci.setProperty("CurrentReading", instance.CurrentReading);

	if (!instance.NominalReading_isNULL)
		ci.setProperty("NominalReading", instance.NominalReading);

	if (!instance.NormalMax_isNULL)
		ci.setProperty("NormalMax", instance.NormalMax);

	if (!instance.NormalMin_isNULL)
		ci.setProperty("NormalMin", instance.NormalMin);

	if (!instance.MaxReadable_isNULL)
		ci.setProperty("MaxReadable", instance.MaxReadable);

	if (!instance.MinReadable_isNULL)
		ci.setProperty("MinReadable", instance.MinReadable);

	if (!instance.Resolution_isNULL)
		ci.setProperty("Resolution", instance.Resolution);

	if (!instance.Tolerance_isNULL)
		ci.setProperty("Tolerance", instance.Tolerance);

	if (!instance.Accuracy_isNULL)
		ci.setProperty("Accuracy", instance.Accuracy);

	if (!instance.IsLinear_isNULL)
		ci.setProperty("IsLinear", instance.IsLinear);

	if (!instance.Hysteresis_isNULL)
		ci.setProperty("Hysteresis", instance.Hysteresis);

	if (!instance.LowerThresholdNonCritical_isNULL)
		ci.setProperty("LowerThresholdNonCritical", instance.LowerThresholdNonCritical);

	if (!instance.UpperThresholdNonCritical_isNULL)
		ci.setProperty("UpperThresholdNonCritical", instance.UpperThresholdNonCritical);

	if (!instance.LowerThresholdCritical_isNULL)
		ci.setProperty("LowerThresholdCritical", instance.LowerThresholdCritical);

	if (!instance.UpperThresholdCritical_isNULL)
		ci.setProperty("UpperThresholdCritical", instance.UpperThresholdCritical);

	if (!instance.LowerThresholdFatal_isNULL)
		ci.setProperty("LowerThresholdFatal", instance.LowerThresholdFatal);

	if (!instance.UpperThresholdFatal_isNULL)
		ci.setProperty("UpperThresholdFatal", instance.UpperThresholdFatal);

	if (!instance.SupportedThresholds_isNULL)
		ci.setProperty("SupportedThresholds", instance.SupportedThresholds);

	if (!instance.EnabledThresholds_isNULL)
		ci.setProperty("EnabledThresholds", instance.EnabledThresholds);

	if (!instance.SettableThresholds_isNULL)
		ci.setProperty("SettableThresholds", instance.SettableThresholds);

	_L_;
	return ci.getHdl();
}

void Sensors_OpenDRIM_ProcessorVoltageSensor_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_ProcessorVoltageSensor& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("DeviceID", instance.DeviceID) == OK)
		instance.DeviceID_isNULL = false;

	if (op.getKey("SystemCreationClassName", instance.SystemCreationClassName) == OK)
		instance.SystemCreationClassName_isNULL = false;

	if (op.getKey("SystemName", instance.SystemName) == OK)
		instance.SystemName_isNULL = false;

	if (op.getKey("CreationClassName", instance.CreationClassName) == OK)
		instance.CreationClassName_isNULL = false;

	_L_;
}

void Sensors_OpenDRIM_ProcessorVoltageSensor_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_ProcessorVoltageSensor& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getPropertyDatetime("InstallDate", instance.InstallDate) == OK)
		instance.InstallDate_isNULL = false;

	if (inst.getProperty("Name", instance.Name) == OK)
		instance.Name_isNULL = false;

	if (inst.getProperty("OperationalStatus", instance.OperationalStatus) == OK)
		instance.OperationalStatus_isNULL = false;

	if (inst.getProperty("StatusDescriptions", instance.StatusDescriptions) == OK)
		instance.StatusDescriptions_isNULL = false;

	if (inst.getProperty("Status", instance.Status) == OK)
		instance.Status_isNULL = false;

	if (inst.getProperty("HealthState", instance.HealthState) == OK)
		instance.HealthState_isNULL = false;

	if (inst.getProperty("CommunicationStatus", instance.CommunicationStatus) == OK)
		instance.CommunicationStatus_isNULL = false;

	if (inst.getProperty("DetailedStatus", instance.DetailedStatus) == OK)
		instance.DetailedStatus_isNULL = false;

	if (inst.getProperty("OperatingStatus", instance.OperatingStatus) == OK)
		instance.OperatingStatus_isNULL = false;

	if (inst.getProperty("PrimaryStatus", instance.PrimaryStatus) == OK)
		instance.PrimaryStatus_isNULL = false;

	if (inst.getProperty("EnabledState", instance.EnabledState) == OK)
		instance.EnabledState_isNULL = false;

	if (inst.getProperty("OtherEnabledState", instance.OtherEnabledState) == OK)
		instance.OtherEnabledState_isNULL = false;

	if (inst.getProperty("RequestedState", instance.RequestedState) == OK)
		instance.RequestedState_isNULL = false;

	if (inst.getProperty("EnabledDefault", instance.EnabledDefault) == OK)
		instance.EnabledDefault_isNULL = false;

	if (inst.getPropertyDatetime("TimeOfLastStateChange", instance.TimeOfLastStateChange) == OK)
		instance.TimeOfLastStateChange_isNULL = false;

	if (inst.getProperty("AvailableRequestedStates", instance.AvailableRequestedStates) == OK)
		instance.AvailableRequestedStates_isNULL = false;

	if (inst.getProperty("TransitioningToState", instance.TransitioningToState) == OK)
		instance.TransitioningToState_isNULL = false;

	if (inst.getProperty("SystemCreationClassName", instance.SystemCreationClassName) == OK)
		instance.SystemCreationClassName_isNULL = false;

	if (inst.getProperty("SystemName", instance.SystemName) == OK)
		instance.SystemName_isNULL = false;

	if (inst.getProperty("CreationClassName", instance.CreationClassName) == OK)
		instance.CreationClassName_isNULL = false;

	if (inst.getProperty("DeviceID", instance.DeviceID) == OK)
		instance.DeviceID_isNULL = false;

	if (inst.getProperty("PowerManagementSupported", instance.PowerManagementSupported) == OK)
		instance.PowerManagementSupported_isNULL = false;

	if (inst.getProperty("PowerManagementCapabilities", instance.PowerManagementCapabilities) == OK)
		instance.PowerManagementCapabilities_isNULL = false;

	if (inst.getProperty("Availability", instance.Availability) == OK)
		instance.Availability_isNULL = false;

	if (inst.getProperty("StatusInfo", instance.StatusInfo) == OK)
		instance.StatusInfo_isNULL = false;

	if (inst.getProperty("LastErrorCode", instance.LastErrorCode) == OK)
		instance.LastErrorCode_isNULL = false;

	if (inst.getProperty("ErrorDescription", instance.ErrorDescription) == OK)
		instance.ErrorDescription_isNULL = false;

	if (inst.getProperty("ErrorCleared", instance.ErrorCleared) == OK)
		instance.ErrorCleared_isNULL = false;

	if (inst.getProperty("OtherIdentifyingInfo", instance.OtherIdentifyingInfo) == OK)
		instance.OtherIdentifyingInfo_isNULL = false;

	if (inst.getProperty("PowerOnHours", instance.PowerOnHours) == OK)
		instance.PowerOnHours_isNULL = false;

	if (inst.getProperty("TotalPowerOnHours", instance.TotalPowerOnHours) == OK)
		instance.TotalPowerOnHours_isNULL = false;

	if (inst.getProperty("IdentifyingDescriptions", instance.IdentifyingDescriptions) == OK)
		instance.IdentifyingDescriptions_isNULL = false;

	if (inst.getProperty("AdditionalAvailability", instance.AdditionalAvailability) == OK)
		instance.AdditionalAvailability_isNULL = false;

	if (inst.getProperty("MaxQuiesceTime", instance.MaxQuiesceTime) == OK)
		instance.MaxQuiesceTime_isNULL = false;

	if (inst.getProperty("SensorType", instance.SensorType) == OK)
		instance.SensorType_isNULL = false;

	if (inst.getProperty("OtherSensorTypeDescription", instance.OtherSensorTypeDescription) == OK)
		instance.OtherSensorTypeDescription_isNULL = false;

	if (inst.getProperty("PossibleStates", instance.PossibleStates) == OK)
		instance.PossibleStates_isNULL = false;

	if (inst.getProperty("CurrentState", instance.CurrentState) == OK)
		instance.CurrentState_isNULL = false;

	if (inst.getProperty("PollingInterval", instance.PollingInterval) == OK)
		instance.PollingInterval_isNULL = false;

	if (inst.getProperty("BaseUnits", instance.BaseUnits) == OK)
		instance.BaseUnits_isNULL = false;

	if (inst.getProperty("UnitModifier", instance.UnitModifier) == OK)
		instance.UnitModifier_isNULL = false;

	if (inst.getProperty("RateUnits", instance.RateUnits) == OK)
		instance.RateUnits_isNULL = false;

	if (inst.getProperty("CurrentReading", instance.CurrentReading) == OK)
		instance.CurrentReading_isNULL = false;

	if (inst.getProperty("NominalReading", instance.NominalReading) == OK)
		instance.NominalReading_isNULL = false;

	if (inst.getProperty("NormalMax", instance.NormalMax) == OK)
		instance.NormalMax_isNULL = false;

	if (inst.getProperty("NormalMin", instance.NormalMin) == OK)
		instance.NormalMin_isNULL = false;

	if (inst.getProperty("MaxReadable", instance.MaxReadable) == OK)
		instance.MaxReadable_isNULL = false;

	if (inst.getProperty("MinReadable", instance.MinReadable) == OK)
		instance.MinReadable_isNULL = false;

	if (inst.getProperty("Resolution", instance.Resolution) == OK)
		instance.Resolution_isNULL = false;

	if (inst.getProperty("Tolerance", instance.Tolerance) == OK)
		instance.Tolerance_isNULL = false;

	if (inst.getProperty("Accuracy", instance.Accuracy) == OK)
		instance.Accuracy_isNULL = false;

	if (inst.getProperty("IsLinear", instance.IsLinear) == OK)
		instance.IsLinear_isNULL = false;

	if (inst.getProperty("Hysteresis", instance.Hysteresis) == OK)
		instance.Hysteresis_isNULL = false;

	if (inst.getProperty("LowerThresholdNonCritical", instance.LowerThresholdNonCritical) == OK)
		instance.LowerThresholdNonCritical_isNULL = false;

	if (inst.getProperty("UpperThresholdNonCritical", instance.UpperThresholdNonCritical) == OK)
		instance.UpperThresholdNonCritical_isNULL = false;

	if (inst.getProperty("LowerThresholdCritical", instance.LowerThresholdCritical) == OK)
		instance.LowerThresholdCritical_isNULL = false;

	if (inst.getProperty("UpperThresholdCritical", instance.UpperThresholdCritical) == OK)
		instance.UpperThresholdCritical_isNULL = false;

	if (inst.getProperty("LowerThresholdFatal", instance.LowerThresholdFatal) == OK)
		instance.LowerThresholdFatal_isNULL = false;

	if (inst.getProperty("UpperThresholdFatal", instance.UpperThresholdFatal) == OK)
		instance.UpperThresholdFatal_isNULL = false;

	if (inst.getProperty("SupportedThresholds", instance.SupportedThresholds) == OK)
		instance.SupportedThresholds_isNULL = false;

	if (inst.getProperty("EnabledThresholds", instance.EnabledThresholds) == OK)
		instance.EnabledThresholds_isNULL = false;

	if (inst.getProperty("SettableThresholds", instance.SettableThresholds) == OK)
		instance.SettableThresholds_isNULL = false;

	_L_;
}

void Sensors_OpenDRIM_ProcessorVoltageSensor_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_ProcessorVoltageSensor_RequestStateChange_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	unsigned short RequestedState;
	data = in->ft->getArg(in, "RequestedState", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, RequestedState);	
		args.setRequestedState(RequestedState);
	}			

	Objectpath Job;
	data = in->ft->getArg(in, "Job", &rc);
	if (rc.rc == OK) {
		CT_ToC(broker, data, Job);	
		args.setJob(Job);
	}			

	string TimeoutPeriod;
	data = in->ft->getArg(in, "TimeoutPeriod", &rc);
	if (rc.rc == OK) {
		CT_ToCDatetime(data, TimeoutPeriod);	
		args.setTimeoutPeriod(TimeoutPeriod);
	}			

	_L_;
}

void Sensors_OpenDRIM_ProcessorVoltageSensor_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_ProcessorVoltageSensor_RequestStateChange_Out& args) {
	_E_;
	CMPIValue value;
	int errorMessage;

	Objectpath Job;
	errorMessage = args.getJob(Job);
	if (errorMessage == OK) {
		value = CT_toCMPI(Job);
		out->ft->addArg(out, "Job", &value, CMPI_ref);
	}

	_L_;
}
void Sensors_OpenDRIM_ProcessorVoltageSensor_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_ProcessorVoltageSensor_SetPowerState_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	unsigned short PowerState;
	data = in->ft->getArg(in, "PowerState", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, PowerState);	
		args.setPowerState(PowerState);
	}			

	string Time;
	data = in->ft->getArg(in, "Time", &rc);
	if (rc.rc == OK) {
		CT_ToCDatetime(data, Time);	
		args.setTime(Time);
	}			

	_L_;
}

void Sensors_OpenDRIM_ProcessorVoltageSensor_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_ProcessorVoltageSensor_EnableDevice_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	bool Enabled;
	data = in->ft->getArg(in, "Enabled", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, Enabled);	
		args.setEnabled(Enabled);
	}			

	_L_;
}

void Sensors_OpenDRIM_ProcessorVoltageSensor_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_ProcessorVoltageSensor_OnlineDevice_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	bool Online;
	data = in->ft->getArg(in, "Online", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, Online);	
		args.setOnline(Online);
	}			

	_L_;
}

void Sensors_OpenDRIM_ProcessorVoltageSensor_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_ProcessorVoltageSensor_QuiesceDevice_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	bool Quiesce;
	data = in->ft->getArg(in, "Quiesce", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, Quiesce);	
		args.setQuiesce(Quiesce);
	}			

	_L_;
}

void Sensors_OpenDRIM_ProcessorVoltageSensor_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_ProcessorVoltageSensor_GetNonLinearFactors_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	int SensorReading;
	data = in->ft->getArg(in, "SensorReading", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, SensorReading);	
		args.setSensorReading(SensorReading);
	}			

	int Accuracy;
	data = in->ft->getArg(in, "Accuracy", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, Accuracy);	
		args.setAccuracy(Accuracy);
	}			

	unsigned int Resolution;
	data = in->ft->getArg(in, "Resolution", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, Resolution);	
		args.setResolution(Resolution);
	}			

	int Tolerance;
	data = in->ft->getArg(in, "Tolerance", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, Tolerance);	
		args.setTolerance(Tolerance);
	}			

	unsigned int Hysteresis;
	data = in->ft->getArg(in, "Hysteresis", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, Hysteresis);	
		args.setHysteresis(Hysteresis);
	}			

	_L_;
}

void Sensors_OpenDRIM_ProcessorVoltageSensor_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_ProcessorVoltageSensor_GetNonLinearFactors_Out& args) {
	_E_;
	CMPIValue value;
	int errorMessage;

	int Accuracy;
	errorMessage = args.getAccuracy(Accuracy);
	if (errorMessage == OK) {
		value = CT_toCMPI(Accuracy);
		out->ft->addArg(out, "Accuracy", &value, CMPI_sint32);
	}

	unsigned int Resolution;
	errorMessage = args.getResolution(Resolution);
	if (errorMessage == OK) {
		value = CT_toCMPI(Resolution);
		out->ft->addArg(out, "Resolution", &value, CMPI_uint32);
	}

	int Tolerance;
	errorMessage = args.getTolerance(Tolerance);
	if (errorMessage == OK) {
		value = CT_toCMPI(Tolerance);
		out->ft->addArg(out, "Tolerance", &value, CMPI_sint32);
	}

	unsigned int Hysteresis;
	errorMessage = args.getHysteresis(Hysteresis);
	if (errorMessage == OK) {
		value = CT_toCMPI(Hysteresis);
		out->ft->addArg(out, "Hysteresis", &value, CMPI_uint32);
	}

	_L_;
}
