/*###############################################################################
# Linux Management Providers (LMP), Software Update provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_SoftwareInstallationServiceCapabilities.h"

CMPIObjectPath* SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceCapabilities_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_SoftwareInstallationServiceCapabilities& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_SoftwareInstallationServiceCapabilities_classnames[0], OpenDRIM_SoftwareInstallationServiceCapabilities_NAMESPACE);

	if (!instance.InstanceID_isNULL)
		op.addKey("InstanceID", instance.InstanceID);

	_L_;
	return op.getHdl();
}

CMPIInstance* SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceCapabilities_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_SoftwareInstallationServiceCapabilities& instance) {
	_E_;
	Objectpath op(broker, SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceCapabilities_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.SupportedAsynchronousActions_isNULL)
		ci.setProperty("SupportedAsynchronousActions", instance.SupportedAsynchronousActions);

	if (!instance.SupportedSynchronousActions_isNULL)
		ci.setProperty("SupportedSynchronousActions", instance.SupportedSynchronousActions);

	if (!instance.SupportedTargetTypes_isNULL)
		ci.setProperty("SupportedTargetTypes", instance.SupportedTargetTypes);

	if (!instance.SupportedExtendedResourceTypes_isNULL)
		ci.setProperty("SupportedExtendedResourceTypes", instance.SupportedExtendedResourceTypes);

	if (!instance.CanAddToCollection_isNULL)
		ci.setProperty("CanAddToCollection", instance.CanAddToCollection);

	if (!instance.SupportedInstallOptions_isNULL)
		ci.setProperty("SupportedInstallOptions", instance.SupportedInstallOptions);

	if (!instance.OtherSupportedExtendedResourceTypeDescriptions_isNULL)
		ci.setProperty("OtherSupportedExtendedResourceTypeDescriptions", instance.OtherSupportedExtendedResourceTypeDescriptions);

	if (!instance.SupportedExtendedResourceTypesMajorVersions_isNULL)
		ci.setProperty("SupportedExtendedResourceTypesMajorVersions", instance.SupportedExtendedResourceTypesMajorVersions);

	if (!instance.SupportedExtendedResourceTypesMinorVersions_isNULL)
		ci.setProperty("SupportedExtendedResourceTypesMinorVersions", instance.SupportedExtendedResourceTypesMinorVersions);

	if (!instance.SupportedExtendedResourceTypesRevisionNumbers_isNULL)
		ci.setProperty("SupportedExtendedResourceTypesRevisionNumbers", instance.SupportedExtendedResourceTypesRevisionNumbers);

	if (!instance.SupportedExtendedResourceTypesBuildNumbers_isNULL)
		ci.setProperty("SupportedExtendedResourceTypesBuildNumbers", instance.SupportedExtendedResourceTypesBuildNumbers);

	if (!instance.SupportedURISchemes_isNULL)
		ci.setProperty("SupportedURISchemes", instance.SupportedURISchemes);

	_L_;
	return ci.getHdl();
}

void SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceCapabilities_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_SoftwareInstallationServiceCapabilities& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	_L_;
}

void SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceCapabilities_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_SoftwareInstallationServiceCapabilities& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getProperty("SupportedAsynchronousActions", instance.SupportedAsynchronousActions) == OK)
		instance.SupportedAsynchronousActions_isNULL = false;

	if (inst.getProperty("SupportedSynchronousActions", instance.SupportedSynchronousActions) == OK)
		instance.SupportedSynchronousActions_isNULL = false;

	if (inst.getProperty("SupportedTargetTypes", instance.SupportedTargetTypes) == OK)
		instance.SupportedTargetTypes_isNULL = false;

	if (inst.getProperty("SupportedExtendedResourceTypes", instance.SupportedExtendedResourceTypes) == OK)
		instance.SupportedExtendedResourceTypes_isNULL = false;

	if (inst.getProperty("CanAddToCollection", instance.CanAddToCollection) == OK)
		instance.CanAddToCollection_isNULL = false;

	if (inst.getProperty("SupportedInstallOptions", instance.SupportedInstallOptions) == OK)
		instance.SupportedInstallOptions_isNULL = false;

	if (inst.getProperty("OtherSupportedExtendedResourceTypeDescriptions", instance.OtherSupportedExtendedResourceTypeDescriptions) == OK)
		instance.OtherSupportedExtendedResourceTypeDescriptions_isNULL = false;

	if (inst.getProperty("SupportedExtendedResourceTypesMajorVersions", instance.SupportedExtendedResourceTypesMajorVersions) == OK)
		instance.SupportedExtendedResourceTypesMajorVersions_isNULL = false;

	if (inst.getProperty("SupportedExtendedResourceTypesMinorVersions", instance.SupportedExtendedResourceTypesMinorVersions) == OK)
		instance.SupportedExtendedResourceTypesMinorVersions_isNULL = false;

	if (inst.getProperty("SupportedExtendedResourceTypesRevisionNumbers", instance.SupportedExtendedResourceTypesRevisionNumbers) == OK)
		instance.SupportedExtendedResourceTypesRevisionNumbers_isNULL = false;

	if (inst.getProperty("SupportedExtendedResourceTypesBuildNumbers", instance.SupportedExtendedResourceTypesBuildNumbers) == OK)
		instance.SupportedExtendedResourceTypesBuildNumbers_isNULL = false;

	if (inst.getProperty("SupportedURISchemes", instance.SupportedURISchemes) == OK)
		instance.SupportedURISchemes_isNULL = false;

	_L_;
}

