/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENCTL_TYPE_MANAGER_H_
#define _OPENCTL_TYPE_MANAGER_H_

#include <GTLCore/String.h>

namespace GTLCore {
  class Type;
  /**
   * This class gives access to all types used by a module.
   * @ingroup GTLCore
   */
  class GTLCORE_EXPORT TypesManager {
      GTL_NO_COPY(TypesManager);
    public:
      TypesManager();
      ~TypesManager();
      const GTLCore::Type* getStructure( const GTLCore::String& name) const;
      /**
       * @param type the type of the elements in the array
       * @return the array type
       */
      static const GTLCore::Type* getArray( const GTLCore::Type* type);
      /**
       * Create an array of array.
       * @param _type the base type of an array
       * @param _levelsCount the number of level of the array (if _levelsCount == 0,
       *            then _type is returned);
       * 
       * @code
       * getArray( GTLCore::Type::Integer32, 0 ) == GTLCore::Type::Integer32;
       * getArray( GTLCore::Type::Integer32, 1 ) == getArray( GTLCore::Type::Integer32 );
       * getArray( GTLCore::Type::Integer32, 2 ) == getArray( getArray( GTLCore::Type::Integer32 );
       * @endcode
       */
      static const GTLCore::Type* getArray( const GTLCore::Type* _type, int _levelsCount);
      /**
       * @param _type the type of the elements of the vector
       * @param _size number of elements of the vector
       * @return the vector type that contains \a _type
       */
      static const GTLCore::Type* getVector( const GTLCore::Type* _type, int _size );
    public:
      struct Private;
      Private* const d;
  };
}

#endif
