/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "Sketch.h"

#include <GTLCore/Debug.h>
#include <GTLCore/Function.h>
#include <GTLCore/Function_p.h>
#include <GTLCore/VirtualMachine_p.h>

#include "wrappers/CanvasWrap_p.h"
#include "wrappers/PaletteWrap_p.h"
#include <GTLFragment/Library_p.h>
#include <GTLCore/ModuleData_p.h>

using namespace OpenRijn;

Sketch::Sketch() : Library( GTLFragment::Library::RIJN_SKETCH)
{
}

Sketch::~Sketch()
{
}

void Sketch::draw(AbstractCanvas* _canvas, AbstractPalette* _palette)
{
  TEST_GUARD_READ(GTLFragment::Library::d)
  CanvasWrap cw;
  cw.canvas = _canvas;
  cw.count = 1;
  PaletteWrap pw;
  pw.data = _palette;
  pw.count = 1;
  
  const std::list<GTLCore::Function*>* drawFuncs = GTLFragment::Library::d->m_moduleData->function( name(), "draw");
  GTL_ASSERT(drawFuncs);
  GTL_ASSERT(drawFuncs->size() == 1);
  GTLCore::Function* function = *drawFuncs->begin();
  
  void (*func)(CanvasWrap*, PaletteWrap*)
        = ( void(*)(CanvasWrap*, PaletteWrap* ))
        GTLCore::VirtualMachine::instance()->getPointerToFunction( function->d->data->function());

  GTL_ASSERT(func);
  (*func)(&cw, &pw);
}

int Sketch::runTest() const
{
  TEST_GUARD_READ(GTLFragment::Library::d)
  GTL_ASSERT( isCompiled() );
  const std::list<GTLCore::Function*>* fs = GTLFragment::Library::d->m_moduleData->function( name(), "runTest");
  GTL_ASSERT( fs );
  GTLCore::Function* f = fs->front();
  GTLCore::Value v = f->call( std::vector< GTLCore::Value >() );
  return v.asInt32();
}

bool Sketch::hasTestFunction() const
{
  TEST_GUARD_READ(GTLFragment::Library::d)
  return GTLFragment::Library::d->m_moduleData->function( name(), "runTest");
}
