/*
 *    Copyright 2017 Kai Pastor
 *
 *    This file is part of OpenOrienteering.
 *
 *    OpenOrienteering is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    OpenOrienteering is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with OpenOrienteering.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef OPENORIENTEERING_TEXT_BROWSER_H
#define OPENORIENTEERING_TEXT_BROWSER_H

#include <QObject>
#include <QTextBrowser>
#include <QVariant>

class QUrl;
class QWidget;

namespace OpenOrienteering {


/**
 * A text browser which handles .txt files.
 * 
 * This class reimplements the loadResource() function so that .txt resources
 * are turned into preformatted HTML.
 */
class TextBrowser: public QTextBrowser
{
Q_OBJECT
public:
	TextBrowser(QWidget* parent = nullptr);
	
	~TextBrowser() override;
	
	QVariant loadResource(int type, const QUrl& name) override;
};


}  // namespace OpenOrienteering

#endif
