# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1463-1 (postgresql-7.4)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60180);
 script_cve_id("CVE-2007-3278", "CVE-2007-4769", "CVE-2007-4772", "CVE-2007-6067", "CVE-2007-6600", "CVE-2007-6601");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.2");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1463-1 (postgresql-7.4)";
 script_name(name);

 desc = "The remote host is missing an update to postgresql-7.4
announced via advisory DSA 1463-1.

Several local vulnerabilities have been discovered in PostgreSQL, an
object-relational SQL database. The Common Vulnerabilities and Exposures
project identifies the following problems:

CVE-2007-3278

It was discovered that the DBLink module performed insufficient
credential validation. This issue is also tracked as CVE-2007-6601,
since the initial upstream fix was incomplete.

CVE-2007-4769

Tavis Ormandy and Will Drewry discovered that a bug in the handling
of back-references inside the regular expressions engine could lead
to an out of bands read, resulting in a crash. This constitutes only
a security problem if an application using ProgreSQL processes
regular expressions from untrusted sources.

CVE-2007-4772

Tavis Ormandy and Will Drewry discovered that the optimizer for regular
expression could be tricked into an infinite loop, resulting in denial
of service. This constitutes only a security problem if an application
using ProgreSQL processes regular expressions from untrusted sources.

CVE-2007-6067

Tavis Ormandy and Will Drewry discovered that the optimizer for regular
expression could be tricked massive ressource consumption. This
constitutes only a security problem if an application using ProgreSQL
processes regular expressions from untrusted sources.

CVE-2007-6600

Functions in index expressions could lead to privilege escalation. For
a more in depth explanation please see the upstream announce available
at http://www.postgresql.org/about/news.905.

The unstable distribution (sid) no longer contains postgres-7.4

For the stable distribution (etch), these problems have been fixed in
version 7.4.19-0etch1.

For the old stable distribution (sarge), some of these problems have been
fixed in version 7.4.7-6sarge6 of the postgresql package. Please note that
the fix for CVE-2007-6600 and for the handling of regular expressions
hasn't been backported due to the intrusiveness of the fix. We recommend
to upgrade to the stable distribution if these vulnerabilities affect your
setup.

We recommend that you upgrade your postgresql-7.4 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201463-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1463-1 (postgresql-7.4)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"postgresql-doc", ver:"7.4.7-6sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql", ver:"7.4.7-6sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpq3", ver:"7.4.7-6sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpgtcl-dev", ver:"7.4.7-6sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-dev", ver:"7.4.7-6sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpgtcl", ver:"7.4.7-6sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg4", ver:"7.4.7-6sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-client", ver:"7.4.7-6sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-contrib", ver:"7.4.7-6sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg-dev", ver:"7.4.7-6sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-doc-7.4", ver:"7.4.19-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-server-dev-7.4", ver:"7.4.19-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-plpython-7.4", ver:"7.4.19-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-plperl-7.4", ver:"7.4.19-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-7.4", ver:"7.4.19-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-pltcl-7.4", ver:"7.4.19-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-client-7.4", ver:"7.4.19-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-contrib-7.4", ver:"7.4.19-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
