# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 155-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53583);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 155-1 (kdelibs)";
 script_name(name);

 desc = "The remote host is missing an update to kdelibs
announced via advisory DSA 155-1.

Due to a security engineering oversight, the SSL library from KDE,
which Konqueror uses, doesn't check whether an intermediate
certificate for a connection is signed by the certificate authority as
safe for the purpose, but accepts it when it is signed.  This makes it
possible for anyone with a valid VeriSign SSL site certificate to
forge any other VeriSign SSL site certificate, and abuse Konqueror
users.

A local root exploit using artsd has been discovered which exploited
an insecure use of a format string.  The exploit wasn't working on a
Debian system since artsd wasn't running setuid root.  Neither artsd
nor artswrapper need to be setuid root anymore since current computer
systems are fast enuogh to handle the audio data in time.

Theese problems have been fixed in version 2.2.2-13.woody.2 for the
current stable stable distribution (woody).  The old stable
distribution (potato) is not affected, since it doesn't contain KDE
packages.  The unstable distribution (sid) is not yet fixed, but new
packages are expected in the future, the fixed version will be version
2.2.2-14 or higher.

We recommend that you upgrade your kdelibs and libarts packages and


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20155-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 155-1 (kdelibs)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kdelibs3", ver:"2.2.2-13.woody.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs3-bin", ver:"2.2.2-13.woody.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libarts", ver:"2.2.2-13.woody.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
