# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1881-1 (cyrus-imapd-2.2)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64864);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 script_name("Debian Security Advisory DSA 1881-1 (cyrus-imapd-2.2)");

 desc = "The remote host is missing an update to cyrus-imapd-2.2
announced via advisory DSA 1881-1.

It was discovered that the SIEVE component of cyrus-imapd, a highly scalable
enterprise mail system, is vulnerable to a buffer overflow when processing
SIEVE scripts.  Due to incorrect use of the sizeof() operator an attacker is
able to pass a negative length to snprintf() calls resulting in large positive
values due to integer conversion.  This causes a buffer overflow which can be
used to elevate privileges to the cyrus system user.  An attacker who is able
to install SIEVE scripts executed by the server is therefore able to read and
modify arbitrary email messages on the system.


For the oldstable distribution (etch), this problem has been fixed in
version 2.2.13-10+etch2.

For the stable distribution (lenny), this problem has been fixed in
version 2.2.13-14+lenny1.

For the testing (squeeze) and unstable (sid) distribution, this problem
will be fixed soon.


We recommend that you upgrade your cyrus-imapd-2.2 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201881-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1881-1 (cyrus-imapd-2.2)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"cyrus-doc-2.2", ver:"2.2.13-10+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-admin-2.2", ver:"2.2.13-10+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-murder-2.2", ver:"2.2.13-10+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-imapd-2.2", ver:"2.2.13-10+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-clients-2.2", ver:"2.2.13-10+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcyrus-imap-perl22", ver:"2.2.13-10+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-nntpd-2.2", ver:"2.2.13-10+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-dev-2.2", ver:"2.2.13-10+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-pop3d-2.2", ver:"2.2.13-10+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-common-2.2", ver:"2.2.13-10+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-admin-2.2", ver:"2.2.13-14+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-doc-2.2", ver:"2.2.13-14+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-nntpd-2.2", ver:"2.2.13-14+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-dev-2.2", ver:"2.2.13-14+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcyrus-imap-perl22", ver:"2.2.13-14+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-pop3d-2.2", ver:"2.2.13-14+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-common-2.2", ver:"2.2.13-14+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-imapd-2.2", ver:"2.2.13-14+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-murder-2.2", ver:"2.2.13-14+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cyrus-clients-2.2", ver:"2.2.13-14+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
