#
#VID 1e6c4008-245f-11d9-b584-0050fc56d258
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52328);
 script_cve_id("CVE-2004-0891");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "FreeBSD Ports: gaim, ja-gaim, ru-gaim";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   gaim
   ja-gaim
   ru-gaim

CVE-2004-0891
Buffer overflow in the MSN protocol handler for gaim 0.79 to 1.0.1
allows remote attackers to cause a denial of service (application
crash) and possibly execute arbitrary code via an 'unexpected sequence
of MSNSLP messages' that results in an unbounded copy operation that
writes to the wrong buffer.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://gaim.sourceforge.net/security/?id=9
http://www.vuxml.org/freebsd/1e6c4008-245f-11d9-b584-0050fc56d258.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: gaim, ja-gaim, ru-gaim";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"gaim");
if(!isnull(bver) && revcomp(a:bver, b:"0.79")>=0 && revcomp(a:bver, b:"1.0.1")<=0) {
    security_note(0, data:"Package gaim version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ja-gaim");
if(!isnull(bver) && revcomp(a:bver, b:"0.79")>=0 && revcomp(a:bver, b:"1.0.1")<=0) {
    security_note(0, data:"Package ja-gaim version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ru-gaim");
if(!isnull(bver) && revcomp(a:bver, b:"0.79")>=0 && revcomp(a:bver, b:"1.0.1")<=0) {
    security_note(0, data:"Package ru-gaim version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"gaim");
if(!isnull(bver) && revcomp(a:bver, b:"20030000")>0) {
    security_note(0, data:"Package gaim version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
