#
#VID ed124f8c-82a2-11db-b46b-0012f06707f0
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57675);
 script_cve_id("CVE-2006-4197");
 script_bugtraq_id(19508);
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "FreeBSD Ports: libmusicbrainz";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: libmusicbrainz

CVE-2006-4197
Multiple buffer overflows in libmusicbrainz (aka mb_client or
MusicBrainz Client Library) 2.1.2 and earlier, and SVN 8406 and
earlier, allow remote attackers to cause a denial of service (crash)
or execute arbitrary code via (1) a long Location header by the HTTP
server, which triggers an overflow in the MBHttp::Download function in
lib/http.cpp; and (2) a long URL in RDF data, as demonstrated by a URL
in an rdf:resource field in an RDF XML document, which triggers
overflows in many functions in lib/rdfparse.c.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.securityfocus.com/bid/21185/discuss
http://www.vuxml.org/freebsd/ed124f8c-82a2-11db-b46b-0012f06707f0.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: libmusicbrainz";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"libmusicbrainz");
if(!isnull(bver) && revcomp(a:bver, b:"2.1.3")<0) {
    security_note(0, data:"Package libmusicbrainz version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
