#
#VID 84237895-8f39-11d8-8b29-0020ed76ef5a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52451);
 script_bugtraq_id(10136);
 script_cve_id("CVE-2004-0179");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.1");
 script_tag(name:"risk_factor", value:"High");
 name = "FreeBSD Ports: neon";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   neon
   tla
   sitecopy

CVE-2004-0179
Multiple format string vulnerabilities in (1) neon 0.24.4 and earlier,
and other products that use neon including (2) Cadaver, (3) Subversion,
or (4) OpenOffice, allow remote malicious WebDAV servers to execute
arbitrary code.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.webdav.org/neon/
http://secunia.com/advisories/11785
http://www.vuxml.org/freebsd/84237895-8f39-11d8-8b29-0020ed76ef5a.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: neon";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"neon");
if(!isnull(bver) && revcomp(a:bver, b:"0.24.5")<0) {
    security_note(0, data:"Package neon version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"tla");
if(!isnull(bver) && revcomp(a:bver, b:"1.2_1")<0) {
    security_note(0, data:"Package tla version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"sitecopy");
if(!isnull(bver) && revcomp(a:bver, b:"0.13.4_1")<=0) {
    security_note(0, data:"Package sitecopy version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
