#
#VID d5e1aac8-db0b-11dd-ae30-001cc0377035
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID d5e1aac8-db0b-11dd-ae30-001cc0377035
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63104);
 script_cve_id("CVE-2008-2383");
 script_bugtraq_id(33060);
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "FreeBSD Ports: xterm";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: xterm

CVE-2008-2383
CRLF injection vulnerability in xterm allows user-assisted attackers
to execute arbitrary commands via LF (aka \n) characters surrounding a
command name within a Device Control Request Status String (DECRQSS)
escape sequence in a text file, a related issue to CVE-2003-0063 and
CVE-2003-0071.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=510030
http://www.vuxml.org/freebsd/d5e1aac8-db0b-11dd-ae30-001cc0377035.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: xterm";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"xterm");
if(!isnull(bver) && revcomp(a:bver, b:"238")<0) {
    security_note(0, data:"Package xterm version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
