#
#ADV FreeBSD-SA-09:04.bind.asc
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from ADV FreeBSD-SA-09:04.bind.asc
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63243);
 script_cve_id("CVE-2009-0025");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Security Advisory (FreeBSD-SA-09:04.bind.asc)";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory FreeBSD-SA-09:04.bind.asc

BIND 9 is an implementation of the Domain Name System (DNS) protocols.
The named(8) daemon is an Internet Domain Name Server.  DNS Security
Extensions (DNSSEC) are additional protocol options that add
authentication as part of responses to DNS queries.

FreeBSD includes software from the OpenSSL Project.  The OpenSSL
Project is a collaborative effort to develop a robust,
commercial-grade, full-featured Open Source toolkit implementing the
Secure Sockets Layer (SSL v2/v3) and Transport Layer Security (TLS v1)
protocols as well as a full-strength general purpose cryptography
library.

The DSA_do_verify() function from OpenSSL is used to determine if a
DSA digital signature is valid.  When DNSSEC is used within BIND it
uses DSA_do_verify() to verify DSA signatures, but checks the function
return value incorrectly.

Solution:
Upgrade your system to the appropriate stable release
or security branch dated after the correction date

https://secure1.securityspace.com/smysecure/catid.html?in=FreeBSD-SA-09:04.bind.asc
Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Security Advisory (FreeBSD-SA-09:04.bind.asc)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdpatchlevel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
if(patchlevelcmp(rel:"7.1", patchlevel:"2")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"7.0", patchlevel:"9")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"6.4", patchlevel:"3")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"6.3", patchlevel:"9")<0) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
