###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apache_tomcat_mod_jk_info_disc_vuln.nasl 1630 2009-04-13 12:40:34Z apr $
#
# Apache Tomcat mod_jk Information Disclosure Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800277);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"2.6");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2008-5519");
  script_bugtraq_id(34412);
  script_name("Apache Tomcat mod_jk Information Disclosure Vulnerability");
  desc = "

  Overview:
  This host is running Apache Tomcat with mod_jk Module and is prone to
  Information Disclosure vulnerability.

  Vulnerability Insight:
  This flaw is due to
  - an error when handling empty POST requests with a non-zero 'Content-Length'
    header.
  - an error while handling multiple noncompliant AJP protocol related requests.

  Impact:
  This issue can be exploited to disclose response data associated with the
  request of a different user via specially crafted HTTP requests and to gain
  sensitive information about the remote host.

  Impact Level: Application

  Affected Software/OS:
  Apache Tomcat mod_jk version 1.2.0 to 1.2.26

  Fix:
  Upgrade to mod_jk 1.2.27 or later.
  http://svn.eu.apache.org/viewvc?view=rev&revision=702540

  References:
  http://secunia.com/advisories/34621
  http://marc.info/?l=tomcat-dev&m=123913700700879
  http://securitytracker.com/alerts/2009/Apr/1022001.html

  CVSS Score:
    CVSS Base Score     : 2.6 (AV:N/AC:H/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 1.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check version of Apache Module mod_jk");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_apache_mod_jk_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port)){
  exit(0);
}

modjkVer = get_kb_item("www/" + port + "/Apache/Mod_Jk");
if(modjkVer == NULL){
  exit(0);
}

if(version_in_range(version:modjkVer, test_version:"1.2.0", test_version2:"1.2.26"))
{
  security_warning(port);
  exit(0);
}
