###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for qimageblitz FEDORA-2008-0536
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860027);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2008-0536");
  script_name( "Fedora Update for qimageblitz FEDORA-2008-0536");
  desc = "

  Vulnerability Insight:
  Blitz is an interim image effect library that people can use until KDE 4.1 is
  released. KImageEffect, the old image effect class is being dropped for KDE 4.0
  and the replacement, Quasar, won't be ready until KDE 4.1. Blitz gives people
  something to use in the meantime.


  Affected Software/OS:
  qimageblitz on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-January/msg00456.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of qimageblitz");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"qimageblitz", rpm:"qimageblitz~0.0.4~0.3.svn706674.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qimageblitz-debuginfo", rpm:"qimageblitz-debuginfo~0.0.4~0.3.svn706674.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qimageblitz-examples", rpm:"qimageblitz-examples~0.0.4~0.3.svn706674.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qimageblitz-devel", rpm:"qimageblitz-devel~0.0.4~0.3.svn706674.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qimageblitz", rpm:"qimageblitz~0.0.4~0.3.svn706674.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qimageblitz-debuginfo", rpm:"qimageblitz-debuginfo~0.0.4~0.3.svn706674.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qimageblitz-examples", rpm:"qimageblitz-examples~0.0.4~0.3.svn706674.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qimageblitz-devel", rpm:"qimageblitz-devel~0.0.4~0.3.svn706674.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qimageblitz", rpm:"qimageblitz~0.0.4~0.3.svn706674.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}