###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_openssl_sec_bypass_vuln.nasl 823 2009-01-08 17:46:24Z jan $
#
# libcrypt-openssl-dsa-perl Security Bypass Vulnerability in OpenSSL
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800336);
  script_version("$Revision: 1.1 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-0129","CVE-2008-5077");
  script_bugtraq_id(33150);
  script_name("libcrypt-openssl-dsa-perl Security Bypass Vulnerability in OpenSSL");
  desc = "

  Overview: This host has OpenSSL installed and is prone to security bypass
  vulnerability.

  Vulnerability Insight:
  The flaw is due to libcrypt-openssl-dsa-perl which does not properly check
  the return value from the OpenSSL DSA_verify and DSA_do_verify functions.

  Impact:
  Successful exploitation will let the attacker spoof the user data with
  malicious DSA signature to gain access to user's sensitive information.

  Impact Level: Application

  Affected Software/OS:
  OpenSSL version prior to 0.9.8j on Linux.

  Fix: Upgrade to version 0.9.8j
  http://www.openssl.org/source/

  References:
  http://openwall.com/lists/oss-security/2009/01/12/4
  http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=511519

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of OpenSSL");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_openssl_detect_lin.nasl");
  exit(0);
}


include("version_func.inc");

sslVer = get_kb_item("OpenSSL/Linux/Ver");
if(!sslVer){
  exit(0);
}

# Check for OpenSSL version prior to 0.9.8j
if(version_is_less(version:sslVer, test_version:"0.9.8j")){
  security_warning(0);
}
