###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_zope_python_scripts_dos_vuln_lin.nasl 493 2008-11-19 17:58:44Z nov $
#
# Zope Python Scripts Local Denial of Service Vulnerability
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800064);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2008-5102");
  script_bugtraq_id(32267);
  script_name("Zope Python Scripts Local Denial of Service Vulnerability");
  desc = "
  Overview: This host is running Zope, and is prone to Denial of Service
  Vulnerability.

  Vulnerability Insight:
  Zope server allows improper strings to be passed via certain raise and
  import commands.

  Impact: Successful exploitation allows remote authenticated users to cause
  denial of service or resource exhaustion.

  Impact Level: Application

  Affected Software/OS:
  Zope Versions 2.x - 2.11.2 on Linux.

  Fix: Update Zope to higher version,
  http://www.zope.org/Products/Zope/
    or
  Apply available patch,
  http://www.zope.org/Products/Zope/Hotfix-2008-08-12/

  *****
  NOTE: Ignore this warning if above mentioned patch is already applied.
  *****

  References:
  http://www.zope.org/advisories/advisory-2008-08-12
  http://www.zope.org/Products/Zope/Hotfix-2008-08-12/README.txt

  CVSS Score:
    CVSS Base Score     : 4.0 (AV:N/AC:L/Au:SI/C:N/I:N/A:P)
    CVSS Temporal Score : 3.1
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of Zope");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Denial of Service");
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:8080);
if(!port){
  port = 8080;
}

banner = get_http_banner(port);
if(!banner){
  exit(0);
}

zopeVer = eregmatch(pattern:"Zope ([0-9.]+)", string:banner);
if(zopeVer != NULL)
{
  if(version_in_range(version:zopeVer[1], test_version:"2.0", test_version2:"2.11.2")){
    security_warning(port);
  }
}
