###############################################################################
# OpenVAS Vulnerability Test
# $Id$
#
# Podcast Generator 'core/admin/delete.php' Arbitrary File Deletion
# Vulnerability
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100135);
 script_bugtraq_id(34317);
 script_cve_id("CVE-2009-1230");
 script_version ("1.0");
 script_tag(name:"cvss_base", value:"6.5");
 script_tag(name:"risk_factor", value:"High");

 script_name("Podcast Generator 'core/admin/delete.php' Arbitrary File Deletion Vulnerability");
 desc = "

 Overview:
  Podcast Generator is prone to a vulnerability that lets attackers
  delete arbitrary files on the affected computer in the context of
  the webserver.

  Successful attacks may aid in launching further attacks.

  Podcast Generator 1.1 is vulnerable; prior versions may also be
  affected.

 Solution:
  The vendor has released an update. Please see http://podcastgen.sourceforge.net
  fore more information.

 See also:
  http://www.securityfocus.com/bid/34317

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Podcast Generator is vulnerable to Arbitrary File Deletion");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("podcast_generator_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

if(!version = get_kb_item(string("www/", port, "/podcast_generator")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_less(version: vers, test_version: "1.2")) {
      security_warning(port:port);
      exit(0);
  }  

}  

exit(0);
