###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_firefox_window_print_dos_vuln_lin.nasl 4891 2009-09-22 20:48:29Z sep $
#
# Mozilla Firefox 'window.print()' Denial Of Service Vulnerability (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900866);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2008-7244");
  script_name("Mozilla Firefox 'window.print()' Denial Of Service Vulnerability (Linux)");
  desc = "
  Overview: This host is installed with Mozilla Firefox and is prone to Denial
  of Service vulnerability.

  Vulnerability Insight:
  Error exists when application fails to handle user supplied input when calling
  the 'window.print' function in a loop aka a 'printing DoS attack'.

  Impact:
  Successful attacks may result in Denial of Service condition on the victim's
  system.

  Impact Level: Application

  Affected Software/OS:
  Mozilla Firefox version 3.0.1 and prior on Linux.

  Fix: Upgrade to Mozilla Firefox version 3.6.3 or later
  For updates refer, http://www.mozilla.com/en-US/firefox/

  References:
  http://websecurity.com.ua/2456/
  http://www.securityfocus.com/archive/1/archive/1/506328/100/100/threaded

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.5
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Mozilla Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_firefox_detect_lin.nasl");
  script_require_keys("Firefox/Linux/Ver");
  exit(0);
}


include("version_func.inc");

ffVer = get_kb_item("Firefox/Linux/Ver");
if(!ffVer){
  exit(0);
}

# Check for Mozilla Firefox version <= 3.0.1
if(version_is_less_equal(version:ffVer, test_version:"3.0.1")){
  security_warning(0);
}
