###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ghostscript_mult_bof_vuln_win.nasl 1699 2009-04-21 14:20:02Z apr $
#
# Ghostscript Multiple Buffer Overflow Vulnerabilities (Win).
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900540);
  script_version("$Revision: 8288 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-0792", "CVE-2009-0196");
  script_bugtraq_id(34445, 34184);
  script_name("Ghostscript Multiple Buffer Overflow Vulnerabilities (Win)");
  desc = "

  Overview: This host is installed with Ghostscript and is prone to
  Buffer Overflow Vulnerability.

  Vulnerability Insight:
  These flaws arise due to,
  - a boundary error in the jbig2_symbol_dict.c() function in the JBIG2
    decoding library (jbig2dec) while decoding JBIG2 symbol dictionary
    segments.
  - multiple integer overflows in icc.c in the ICC Format library while
    processing malformed PDF and PostScript files with embedded images.

  Impact:
  Successful exploitation allows the attacker to execute arbitrary code in
  the context of the affected application and can cause denial of service.

  Impact Level: Application

  Affected Software/OS:
  Ghostscript version 8.64 and prior on Windows.

  Fix: Upgrade to Ghostscript version 8.71 or later.
  For updates refer, http://ghostscript.com/releases/

  References:
  http://secunia.com/advisories/34292
  http://www.vupen.com/english/advisories/2009/0983
  http://securitytracker.com/alerts/2009/Apr/1022029.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Ghostscript");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_ghostscript_detect_win.nasl");
  script_require_keys("Ghostscript/Win/Ver");
  exit(0);
}


include("version_func.inc");

ghostVer = get_kb_item("Ghostscript/Win/Ver");
if(!ghostVer){
  exit(0);
}

if(version_is_less_equal(version:ghostVer, test_version:"8.64")){
  security_hole(0);
}
