# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-824-1 (php5)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64780);
 script_cve_id("CVE-2009-2687");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");
 script_name("Ubuntu USN-824-1 (php5)");

 desc = "The remote host is missing an update to php5
announced via advisory USN-824-1.

Details follow:

It was discovered that PHP did not properly handle certain malformed
JPEG images when being parsed by the Exif module. A remote attacker could
exploit this flaw and cause the PHP server to crash, resulting in a denial
of service.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  php5-cgi                        5.1.2-1ubuntu3.15
  php5-cli                        5.1.2-1ubuntu3.15

Ubuntu 8.04 LTS:
  php5-cgi                        5.2.4-2ubuntu5.7
  php5-cli                        5.2.4-2ubuntu5.7

Ubuntu 8.10:
  php5-cgi                        5.2.6-2ubuntu4.3
  php5-cli                        5.2.6-2ubuntu4.3

Ubuntu 9.04:
  php5-cgi                        5.2.6.dfsg.1-3ubuntu4.2
  php5-cli                        5.2.6.dfsg.1-3ubuntu4.2

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-824-1

Risk factor : High";

 script_description(desc);

 script_summary("Ubuntu USN-824-1 (php5)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Ubuntu Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"php-pear", ver:"5.1.2-1ubuntu3.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5", ver:"5.1.2-1ubuntu3.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-php5", ver:"5.1.2-1ubuntu3.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cgi", ver:"5.1.2-1ubuntu3.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cli", ver:"5.1.2-1ubuntu3.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-common", ver:"5.1.2-1ubuntu3.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-curl", ver:"5.1.2-1ubuntu3.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-dev", ver:"5.1.2-1ubuntu3.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-gd", ver:"5.1.2-1ubuntu3.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-ldap", ver:"5.1.2-1ubuntu3.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mhash", ver:"5.1.2-1ubuntu3.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mysql", ver:"5.1.2-1ubuntu3.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mysqli", ver:"5.1.2-1ubuntu3.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-odbc", ver:"5.1.2-1ubuntu3.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-pgsql", ver:"5.1.2-1ubuntu3.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-recode", ver:"5.1.2-1ubuntu3.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-snmp", ver:"5.1.2-1ubuntu3.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sqlite", ver:"5.1.2-1ubuntu3.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sybase", ver:"5.1.2-1ubuntu3.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xmlrpc", ver:"5.1.2-1ubuntu3.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xsl", ver:"5.1.2-1ubuntu3.15", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php-pear", ver:"5.2.4-2ubuntu5.7", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5", ver:"5.2.4-2ubuntu5.7", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-php5", ver:"5.2.4-2ubuntu5.7", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cgi", ver:"5.2.4-2ubuntu5.7", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cli", ver:"5.2.4-2ubuntu5.7", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-common", ver:"5.2.4-2ubuntu5.7", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-curl", ver:"5.2.4-2ubuntu5.7", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-dev", ver:"5.2.4-2ubuntu5.7", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-gd", ver:"5.2.4-2ubuntu5.7", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-gmp", ver:"5.2.4-2ubuntu5.7", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-ldap", ver:"5.2.4-2ubuntu5.7", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mhash", ver:"5.2.4-2ubuntu5.7", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mysql", ver:"5.2.4-2ubuntu5.7", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-odbc", ver:"5.2.4-2ubuntu5.7", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-pgsql", ver:"5.2.4-2ubuntu5.7", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-pspell", ver:"5.2.4-2ubuntu5.7", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-recode", ver:"5.2.4-2ubuntu5.7", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-snmp", ver:"5.2.4-2ubuntu5.7", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sqlite", ver:"5.2.4-2ubuntu5.7", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sybase", ver:"5.2.4-2ubuntu5.7", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-tidy", ver:"5.2.4-2ubuntu5.7", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xmlrpc", ver:"5.2.4-2ubuntu5.7", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xsl", ver:"5.2.4-2ubuntu5.7", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php-pear", ver:"5.2.6-2ubuntu4.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5", ver:"5.2.6-2ubuntu4.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-php5", ver:"5.2.6-2ubuntu4.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-php5filter", ver:"5.2.6-2ubuntu4.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cgi", ver:"5.2.6-2ubuntu4.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cli", ver:"5.2.6-2ubuntu4.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-common", ver:"5.2.6-2ubuntu4.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-curl", ver:"5.2.6-2ubuntu4.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-dbg", ver:"5.2.6-2ubuntu4.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-dev", ver:"5.2.6-2ubuntu4.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-gd", ver:"5.2.6-2ubuntu4.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-gmp", ver:"5.2.6-2ubuntu4.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-ldap", ver:"5.2.6-2ubuntu4.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mhash", ver:"5.2.6-2ubuntu4.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mysql", ver:"5.2.6-2ubuntu4.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-odbc", ver:"5.2.6-2ubuntu4.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-pgsql", ver:"5.2.6-2ubuntu4.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-pspell", ver:"5.2.6-2ubuntu4.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-recode", ver:"5.2.6-2ubuntu4.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-snmp", ver:"5.2.6-2ubuntu4.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sqlite", ver:"5.2.6-2ubuntu4.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sybase", ver:"5.2.6-2ubuntu4.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-tidy", ver:"5.2.6-2ubuntu4.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xmlrpc", ver:"5.2.6-2ubuntu4.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xsl", ver:"5.2.6-2ubuntu4.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php-pear", ver:"5.2.6.dfsg.1-3ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5", ver:"5.2.6.dfsg.1-3ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-php5", ver:"5.2.6.dfsg.1-3ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cgi", ver:"5.2.6.dfsg.1-3ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cli", ver:"5.2.6.dfsg.1-3ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-common", ver:"5.2.6.dfsg.1-3ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-curl", ver:"5.2.6.dfsg.1-3ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-dbg", ver:"5.2.6.dfsg.1-3ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-dev", ver:"5.2.6.dfsg.1-3ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-gd", ver:"5.2.6.dfsg.1-3ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-gmp", ver:"5.2.6.dfsg.1-3ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-ldap", ver:"5.2.6.dfsg.1-3ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mhash", ver:"5.2.6.dfsg.1-3ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mysql", ver:"5.2.6.dfsg.1-3ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-odbc", ver:"5.2.6.dfsg.1-3ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-pgsql", ver:"5.2.6.dfsg.1-3ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-pspell", ver:"5.2.6.dfsg.1-3ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-recode", ver:"5.2.6.dfsg.1-3ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-snmp", ver:"5.2.6.dfsg.1-3ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sqlite", ver:"5.2.6.dfsg.1-3ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sybase", ver:"5.2.6.dfsg.1-3ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-tidy", ver:"5.2.6.dfsg.1-3ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xmlrpc", ver:"5.2.6.dfsg.1-3ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xsl", ver:"5.2.6.dfsg.1-3ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-php5filter", ver:"5.2.6.dfsg.1-3ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
