///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __LAMMPS_DATA_PARSER_H
#define __LAMMPS_DATA_PARSER_H

#include <core/Core.h>
#include "../AtomsFileParser.h"

namespace AtomViz {

/******************************************************************************
* This file import class can read LAMMPS data files.
******************************************************************************/
class ATOMVIZ_DLLEXPORT LAMMPSDataParser : public AtomsFileParser
{
public:
	/// Default constructor.
	LAMMPSDataParser(bool isLoading = false) : AtomsFileParser(isLoading) {}

	/// \brief Reads an atomic data set from the input file.
	virtual EvaluationStatus loadAtomsFile(AtomsObject* destination, int movieFrame = 0, bool suppressDialogs = false);
	
	/// \brief Checks if the given file has format that can be read by this importer.
	virtual bool checkFileFormat(const QString& filePath);

private:

	/// \brief Removes whitespace characters in front and after the keyword.
	static string extractKeyword(const string& line);

	Q_OBJECT
	DECLARE_SERIALIZABLE_PLUGIN_CLASS(LAMMPSDataParser)
};

};	// End of namespace AtomViz

#endif // __LAMMPS_DATA_PARSER_H
