//=======================================================================
// pkg.cc
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#include "config.h"
#include "pkg.h"
#include "pkgwindow.h"
#include "filestreeview.h"
#include "filestab.h"
#include "paco/file.h"
#include <gdkmm/pixbuf.h>
#include <fstream>

using Glib::ustring;
using std::string;
using namespace Gpaco;


Pkg::Pkg(ustring const& __name)
:
	Paco::BasePkg(__name),
	mSizePercent(0),
	mFilesPercent(0),
	mpIcon(),
	mSummary(),
	mpWindow(NULL),
	mFileType(Pkg::INSTALLED_FILES),
	mChanged(false)
{
	readLog();
}


// [virtual]
Pkg::~Pkg()
{ }


void Pkg::readLog()
{
	string buf;
	std::ifstream f(mLog.c_str());
	g_return_if_fail(f);
	
	while (getline(f, buf) && buf[0] == '#') {
		if (!buf.find("##:")) {
			sscanf(buf.c_str(), "##:%ld|%ld|%ld|%ld",
				&mSizeInst, &mSizeMiss, &mFilesInst, &mFilesMiss);
		}
		else if (!buf.find("#i:/"))
			getIcon(buf.substr(3));
		else if (!buf.find("#:Summary: ")) {
			mSummary = buf.substr(11);
			break;
		}
	}

	f.close();
	getFiles();

	long total = mSizeInst + mSizeMiss;
	mSizePercent = total ? (100.0 * mSizeInst / total) : 100.0;
	total = mFilesInst + mFilesMiss;
	mFilesPercent = total ? (100.0 * mFilesInst / total) : 0.0;
}


void Pkg::getIcon(ustring const& path)
try {
	if (Glib::RefPtr<Gdk::Pixbuf> p = Gdk::Pixbuf::create_from_file(path)) {
		if (p->get_width() >= 72 || p->get_height() >= 72)
			mpIcon = p->scale_simple(72, 72, Gdk::INTERP_BILINEAR);
		else if (p->get_width() <= 24 || p->get_height() <= 24)
			mpIcon = p->scale_simple(24, 24, Gdk::INTERP_BILINEAR);
		else
			mpIcon = p;
	}
} catch (...) { }


void Pkg::presentWindow(int tab)
{
	if (!mpWindow) {
		mpWindow = new PkgWindow(*this);
		mpWindow->filesTab()->treeView()->writeLabel();
	}
	mpWindow->presentTab(tab);
}


void Pkg::deleteWindow()
{
	if (mpWindow) {
		delete mpWindow;
		mpWindow = NULL;
	}
}


bool Pkg::update(bool resetFilesModel /* = true */)
{
	bool ret = true;
	
	try {
		if ((ret = updateLog(mLog))) {
			readLog();
			if (mpWindow && resetFilesModel)
				mpWindow->filesTab()->treeView()->resetModel();
		}
	}
	catch (...) { }

	mChanged = true;

	return ret;
}

